#ifndef _CEGOFACTOR_H_INCLUDED_
#define _CEGOFACTOR_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoFactor.h
// ------------
// Cego factor structure class definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoFactor
// 
// Description: Container class to describe a factor element 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>
#include <lfcbase/SetT.h>
#include <lfcxml/Element.h>

// CEGO INCLUDES
#include "CegoFieldValue.h"
#include "CegoProcBlock.h"
#include "CegoProcFetch.h"
#include "CegoFunction.h"
#include "CegoAggregation.h"

class CegoDistManager;
class CegoExpr;
class CegoSelect;
class CegoCaseCond;

class CegoFactor {
    
 public:
    
    enum FacType { CONSTVAL, VAR, EXPR, FETCH, ATTR, FUNCTION, QUERY, AGGREGATION, CASECOND };

    CegoFactor(char* buf, CegoDistManager *pGTM, int tabSetId);
    CegoFactor(Element* pFactorElement, CegoDistManager *pGTM);

    CegoFactor(const CegoFactor& pf);
    CegoFactor(const Chain& varName);
    CegoFactor(const CegoFieldValue& fv);
    CegoFactor(CegoAttrDesc* pAttrDesc, bool isAttrRef = false);
    CegoFactor(CegoExpr* pExpr);
    CegoFactor(CegoProcFetch* pFetch);
    CegoFactor(CegoFunction* pFunction);
    CegoFactor(CegoAggregation* pAggr);
    CegoFactor(CegoSelect* pSelect);
    CegoFactor(CegoCaseCond* pCaseCond);

    ~CegoFactor();

    void setFieldListArray(ListT<CegoField> **pFLA);

    void setBlock(CegoProcBlock *pBlock);

    void clearAttrCache();

    void getFunctionList(SetT<CegoObject>& funcList);

    bool checkVar(Chain& var) const;
    CegoAttrDesc* checkAttr() const;

    CegoAttrDesc* getAttr() const;
    CegoFunction* getFunction() const;
    CegoAggregation* getAggregation() const;
    CegoSelect* getSelect() const;
    CegoCaseCond* getCaseCond() const;

    ListT<CegoField> getFieldList() const;

    ListT<CegoAttrDesc*> getAttrRefList() const;
    int evalReferences(CegoContentObject *pCO, const ListT<CegoField>& fl);
    
    CegoField evalField() const;
    CegoFieldValue evalFieldValue();

    const Chain& getVarName() const;
    const CegoFieldValue& getFieldValue() const;

    const FacType getType() const;
    CegoExpr* getExpr() const;

    CegoFactor* clone(bool isAttrRef = false);

    CegoFactor& operator = ( const CegoFactor& pf);

    Chain getId() const;
    Chain toChain() const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;

    Element* toElement() const;
    void fromElement(Element *pFactorElement, CegoDistManager* pGTM);

    void encode(char *buf);
    void decode(char *buf, CegoDistManager* pGTM, int tabSetId);
    int getEncodingLength() const;

    ListT<CegoAggregation*> getAggregationList();

    void getPlanList(ListT<Element*>& planList);

    friend ostream& operator << (ostream& s, const CegoFactor& pf);
      
 private:
    
    CegoFieldValue _fv;
    FacType _type;
    CegoAttrDesc* _pAttrDesc;
    bool _isAttrRef;
    Chain _varName;
    CegoExpr* _pExpr;
    CegoProcFetch *_pFetch;
    CegoFunction* _pFunction;
    CegoAggregation* _pAggr;
    CegoSelect* _pSelect;
    CegoCaseCond* _pCaseCond;
    
    ListT<CegoField>** _pFLA;

    int _flaCacheArrayPos;
    int _flaCacheFieldPos;
    bool _flaCached;

    CegoProcBlock* _pBlock;
};

#endif


