#ifndef _CEGOFILEHANDLER_H_INCLUDED_
#define _CEGOFILEHANDLER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoFileHandler.h
// -----------------
// Cego file handler class definition
//                                                         
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoFileHandler
// 
// Description: The filehandler class provides access to all datafiles. Datafiles consists
//              of a defined number of pages managed by the this class.
//              At the header of a datafile, a bitmap is stored for used page information
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#ifndef _REENTRANT
#define _REENTRANT    /* basic 3-lines for threads */
#endif

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/File.h>
#include <lfcbase/Logger.h>

// CEGO INCLUDES
#include "CegoLockHandler.h"
#include "CegoDefs.h"
#include "CegoModule.h"

class CegoFileHandler : public CegoModule {
    
public:
   
    enum FileType { DATAFILE, SYSTEMFILE, TEMP };

    CegoFileHandler(const Chain& logFile, const Chain& progName, int pageSize = 16384);
    ~CegoFileHandler();

    bool isBackup(int fileId);
    void setBackup(int fileId, bool m);
    bool isMarked(int fileId, int pageId);
        
    void cleanDataFile(int fileId, CegoLockHandler* pLockHandle);

    void initDataFile(int tabSetId, const Chain& path, int fileId, int numPages, FileType ft);
    void regDataFile(int tabSetId, const Chain& path, int fileId, CegoLockHandler* pLockHandle);

    void writePage(int fileId, int pageId, int fixStat, char* pageData, CegoLockHandler* pLockHandle);
    void readPage(int fileId, int pageId, int& tabSetId, int& fixStat, char* pageData, CegoLockHandler* pLockHandle);
    
    void claimPage(int fileId, int pageId, CegoLockHandler* pLockHandle);
    void allocatePage(int tabSetId, FileType ft, int& fileId, int& pageId, CegoLockHandler* pLockHandle, unsigned* &fbm, int& fbmSize, bool doAppend = false);
    void releasePage(int fileId, int pageId, CegoLockHandler* pLockHandle, unsigned* &fbm, int& fbmSize);

    void releaseFiles(int tabSetId);

    int getNumPages(int fileId);
    int getNumUsedPages(int fileId, CegoLockHandler* pLockHandle);

    unsigned long long getRegPageOffset(int fileId);
    
    int getFBMSize(int fileId);
    void readFBM(int fileId, unsigned *fbm, CegoLockHandler *pLockHandle);
    void writeFBM(int fileId, unsigned *fbm, CegoLockHandler *pLockHandle);

    bool isClaimed(int fileId, int pageId, CegoLockHandler *pLockHandle);
    
    void printBitMap(unsigned bm);

protected:
    
    int _pageSize;

private:
    
    void markPage(int fileId, int pageId);

    File* getHandle(int fileId);
    
    bool _isReg[FILMNG_MAXDATAFILE];
    int _tabSetId[FILMNG_MAXDATAFILE];
    int _fileType[FILMNG_MAXDATAFILE];
    int _numPages[FILMNG_MAXDATAFILE];

    unsigned long long _currentPageOffset;
    unsigned long long _regPageOffset[FILMNG_MAXDATAFILE];

    File* _fhList[FILMNG_MAXDATAFILE];

    Chain _path[FILMNG_MAXDATAFILE];

    unsigned* _buMask[FILMNG_MAXDATAFILE];
    bool _fbmMask[FILMNG_MAXDATAFILE];

    int _appendPos[FILMNG_MAXDATAFILE];

    unsigned long _modId;
};
#endif
