#ifndef _CEGOLOGHANDLER_H_INCLUDED_
#define _CEGOLOGHANDLER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoLogHandler.h
// ----------------
// Cego log handler class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoLogHandler
// 
// Description: Cego client log handler
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/NetHandler.h>
#include <lfcxml/XMLSuite.h>

// CEGO INCLUDES
#include "CegoModule.h"

class CegoLogHandler {
    
public:
   
    enum RequestType { WRITE_LOG, 
		       SESSION_CLOSE,
		       UNKNOWN };

    CegoLogHandler(CegoModule *pModule, NetHandler *pN = 0);
    ~CegoLogHandler();

    void requestLogSession(const Chain& tableSet);
    bool acceptLogSession(Chain& tableSet);

    void closeSession();

    void setNetHandle(NetHandler *pN);

    //////////////////////////
    // admin client methods //
    //////////////////////////

    void getMsg(Chain& msg);

    /////////////////////////
    // server node methods //
    /////////////////////////

    void getTableSet(Chain& tableSet);

    bool sendLogEntry(char* logBuf, int len);
    bool receiveLogEntry(char* &logBuf,  int &len);

    void sendAck();
    void sendNack();

private:

    NetHandler *_pN;
    CegoModule *_pModule;
    XMLSuite _xml;

    unsigned long _modId;
};
#endif
