///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoOrderCursor.cc
// -------------------
// Cego order cursor class implementation
//      
// Design and Implementation by Bjoern Lemke
//     
// (C)opyright 2000-2016 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoOrderCursor
// 
// Description: Traversing on a sorted AVL tuple tree
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// CEGO INCLUDES
#include "CegoOrderCursor.h"
#include "CegoOrderNode.h"

CegoOrderCursor::CegoOrderCursor(AVLTreeT<CegoOrderNode> *pAVL)
{
    _pAVL = pAVL;
}

CegoOrderCursor::~CegoOrderCursor()
{
}

bool CegoOrderCursor::getFirst(ListT<CegoField>& fl)
{
    CegoOrderNode* pN = _pAVL->First();

    if ( pN )
    {
	fl = pN->getTuple();
	return true;
    }
    return false;
}

bool CegoOrderCursor::getNext(ListT<CegoField>& fl)
{

    CegoOrderNode* pN = _pAVL->Next();

    if ( pN )
    {
	fl = pN->getTuple();
	return true;
    }
    return false;
}

void CegoOrderCursor::abort()
{
}
