///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcFetch.cc
// ----------------
// Cego procedure fetch structure class definition
//
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoProcFetch
// 
// Description: Stored procedure cursor fetch statement 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoProcFetch.h"
#include "CegoDatabaseFormater.h"

CegoProcFetch::CegoProcFetch()
{
}

CegoProcFetch::CegoProcFetch(CegoProcCursor *pCur, const ListT<Chain>& varList)
{
    _pCur = pCur;
    _varList = varList;
}

CegoProcFetch::~CegoProcFetch()
{
}

CegoProcFetch& CegoProcFetch::operator = ( const CegoProcFetch& pf)
{
    _pCur = pf._pCur;
    _varList = pf._varList;
    return (*this);
}

void CegoProcFetch::setBlock(CegoProcBlock *pBlock)
{
    _pBlock = pBlock;
}

bool CegoProcFetch::fetch()
{
    ListT<CegoField> fvl;

    bool moreTuple;
    
    moreTuple = _pCur->nextTuple(fvl);
    
    if ( moreTuple )
    {
	CegoField *pF = fvl.First();

	Chain *pVar = _varList.First();
	while ( pVar && pF )
	{
	    _pBlock->setValue(*pVar, pF->getValue());
	    pVar = _varList.Next();
	    pF = fvl.Next();
	}

	/*
	CegoProcVar **pVar = _varList.First();
	while ( pVar && pF )
	{
	    (*pVar)->setValue(pF->getValue());
	    pVar = _varList.Next();
	    pF = fvl.Next();
	}
	*/

    }
    
    return moreTuple;
}

Chain CegoProcFetch::toChain() const
{
    Chain s;

    s = Chain("fetch ") + _pCur->getName() + Chain(" into (");
   	
    Chain *pVar = _varList.First();
    while ( pVar )
    {
	s += Chain(":") + *pVar;
	pVar = _varList.Next();
	if ( pVar )
	    s += Chain(", ");
    }
    s += Chain(")");
    return s;
}

Chain CegoProcFetch::dbFormat(CegoDatabaseFormater* pForm) const
{
    return pForm->formatProcFetch(_pCur->getName(), _varList);
}

ostream& operator << (ostream& s, const CegoProcFetch& pf)
{    
    return s;
}
