#ifndef _CEGOPROCPRED_H_INCLUDED_
#define _CEGOPROCPRED_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcPred.h  
// --------------
// Cego procedure predicate class definition
//                                                        
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoProcPred
// 
// Description: Stored procedure predicate handling
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoComparison.h"
#include "CegoProcCond.h"
#include "CegoExpr.h"

class CegoProcCond;

class CegoProcPred  {
    
public:
    
    enum PredicateMode { EXPRCOMP, NULLCOMP, CONDITION };
    
    CegoProcPred();

    CegoProcPred(CegoExpr* pExpr1, CegoExpr* pExpr2, CegoComparison comp);
    CegoProcPred(CegoExpr* pExpr1, bool isNegate);
    CegoProcPred(CegoProcCond *pCond);
    ~CegoProcPred();

    void setBlock(CegoProcBlock *pBlock);
    bool eval() const;
    Chain toChain() const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;
    
    CegoProcPred& operator = (const CegoProcPred& c);
    friend ostream& operator << (ostream& s, const CegoProcPred& p);
    
private:

    PredicateMode _mode;
    CegoExpr *_pExpr1;
    CegoExpr *_pExpr2;
    CegoProcCond* _pCond;
    CegoComparison _comp;
    bool _isNegate;

};
#endif
