#ifndef _CEGOPROCEDURE_H_INCLUDED_
#define _CEGOPROCEDURE_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcedure.h  
// ---------------
// Cego procedure class definition
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoProcedure
// 
// Description: Stored procedure container class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/ListT.h>
#include <lfcbase/Chain.h>

// cego includes
#include "CegoProcBlock.h"
#include "CegoProcVar.h"
#include "CegoExpr.h"

class CegoDatabaseFormater;

class CegoProcedure  {
    
public:

    enum ProcType { PROCEDURE, FUNCTION };
    
    CegoProcedure();
    CegoProcedure(const Chain& procName, CegoProcBlock *pBlock);
    CegoProcedure(const Chain& procName, CegoProcBlock *pBlock, CegoDataType returnType, int returnTypeLen);

    ~CegoProcedure();

    void setMasterBlock(CegoProcBlock *pBlock);

    void getArgList(ListT<CegoProcVar>& argList);

    ListT<CegoProcVar>& getOutParamList();

    const Chain& getName() const;
    CegoProcBlock* getBlock();

    void execute(const ListT<CegoExpr*>& expList);
 
    CegoFieldValue getRetVal() const;

    CegoDataType getReturnType() const;
    int getReturnTypeLen() const;

    ProcType getProcType() const;

    CegoProcedure& operator = (const CegoProcedure& p);
    bool operator == (const CegoProcedure& p) const;

    Chain dbFormat(CegoDatabaseFormater *pForm) const;
    Chain toChain() const;

 private:
    
    CegoDataType _returnType;
    int _returnTypeLen;
    ProcType _procType;
    Chain _procName;
    CegoProcBlock* _pBlock;
    CegoProcBlock* _pMasterBlock;

    ListT<CegoProcVar> _outParamList;

};

#endif
