///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoTableDesc.cc
// ----------------
// Cego database table description implementation
//      
// Design and Implementation by Bjoern Lemke
//     
// (C)opyright 2000-2016 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoTableDesc
// 
// Description: Data structure for cego table description
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoTableDesc.h"
#include "CegoXMLdef.h"

#include <string.h>
#include <stdlib.h>

CegoTableDesc::CegoTableDesc()
{
}

CegoTableDesc::CegoTableDesc(const CegoTableDesc& td)
{    
    _tableName = td._tableName;
    _tabSetId = td._tabSetId;    
}

CegoTableDesc::CegoTableDesc(const Chain& tableName, int tabSetId)
{
    _tableName = tableName;
    _tabSetId = tabSetId;
}

CegoTableDesc::~CegoTableDesc()
{
}
    
void CegoTableDesc::setTableName(const Chain& tableName)
{
    _tableName = tableName;
}
 
const Chain& CegoTableDesc::getTableName() const
{
    return _tableName;
}

void CegoTableDesc::setTabSetId(int tabSetId)
{
    _tabSetId = tabSetId;
}
 
int CegoTableDesc::getTabSetId() const
{
    return _tabSetId;
}
        
CegoTableDesc& CegoTableDesc::operator = ( const CegoTableDesc& td)
{
    _tableName = td._tableName;
    _tabSetId = td._tabSetId;
    return (*this);
}
    
bool CegoTableDesc::operator == ( const CegoTableDesc& td)
{
    if ( _tableName == td._tableName 
	 && _tabSetId == td._tabSetId )
	return true;
    return false;
}

int CegoTableDesc::size() const
{
    return _tableName.length() + sizeof(int);
}

Chain CegoTableDesc::toChain() const
{
    Chain s;
    s = _tableName + Chain("@") + Chain(_tabSetId);
    return s;
}

ostream& operator << (ostream& s, const CegoTableDesc& td)
{    
    s <<  td._tableName << "(" << td._tabSetId << ")";
    return s;
}
