#ifndef _CEGOCHECKOBJECT_H_INCLUDED_
#define _CEGOCHECKOBJECT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoCheckObject.h
// -----------------
// Cego check object class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoCheckObject
// 
// Description: Derived class from CegoDecodable to use as a container class for check objects
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/ListT.h>
#include <lfcbase/Chain.h>

// CEGO INCLUDES
#include "CegoField.h"
#include "CegoObject.h"
#include "CegoPredicate.h"
#include "CegoDecodableObject.h"

class CegoCheckObject : public CegoDecodableObject {

 public:

    CegoCheckObject();
    CegoCheckObject(const CegoCheckObject& co);
    CegoCheckObject(ObjectType type,  const Chain& objName, int tabSetId = 0);
    CegoCheckObject(int tabSetId, const Chain& checkName, const Chain& tabName, CegoPredicate *pPredDesc);	
    ~CegoCheckObject();

    void setTabName(const Chain& name);
    const Chain& getTabName() const;
    
    void setPredDesc(CegoPredicate *pPredDesc);   
    CegoPredicate* getPredDesc();

    int getEntrySize() const;

    void encode(char *buf) const;
    void decode(char *buf);
    
    CegoCheckObject& operator = ( const CegoCheckObject& oe);
    bool operator == ( const CegoCheckObject& oe);
    
    Chain toChain(int defTabSetId) const;

    Chain getFormatted() const;

 private:

    Chain fill(const Chain& s, int num) const;

    Chain _tabName;
    CegoPredicate *_pPredDesc;
};
#endif
