///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoOrderCursor.cc
// -------------------
// Cego order cursor class implementation
//      
// Design and Implementation by Bjoern Lemke
//     
// (C)opyright 2000-2025 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoOrderCursor
// 
// Description: Traversing on a sorted AVL tuple tree
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// CEGO INCLUDES
#include "CegoOrderCursor.h"
#include "CegoOrderNode.h"

CegoOrderCursor::CegoOrderCursor(AVLTreeT<CegoOrderNode> *pAVL, ListT<CegoField>& schema)
{
    _pAVL = pAVL;
    _schema = schema;
}

CegoOrderCursor::~CegoOrderCursor()
{
}

bool CegoOrderCursor::getFirst(ListT<CegoField>& fl)
{
    CegoOrderNode* pN = _pAVL->First();

    if ( pN )
    {
	fl = _schema;

	CegoField* pF = fl.First();
	CegoFieldValue* pV = pN->getTuple().First();
	while ( pF && pV)
	{
	    pF->setValue(*pV);
	    pF = fl.Next();
	    pV = pN->getTuple().Next();
	}
	return true;
    }
    return false;
}

bool CegoOrderCursor::getNext(ListT<CegoField>& fl)
{
    CegoOrderNode* pN = _pAVL->Next();

    if ( pN )
    {
	fl = _schema;

	CegoField* pF = fl.First();
	CegoFieldValue* pV = pN->getTuple().First();
	while ( pF && pV)
	{
	    pF->setValue(*pV);
	    pF = fl.Next();
	    pV = pN->getTuple().Next();
	}
	return true;
    }
    return false;
}

void CegoOrderCursor::abort()
{
}
