///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoBeatConnection.cc
// ---------------------
// Cego mediator connection class implementation
//      
// Design and Implementation by Bjoern Lemke
//     
// (C)opyright 2000-2025 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoBeatConnection
// 
// Description: Utility class for cego nodes heart beat connection
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Net.h>
#include <lfcbase/Host.h>

// CEGO INCLUDES
#include "CegoBeatConnection.h"
#include "CegoXMLdef.h"

// POSIX INCLUDES
#include <stdlib.h>
#include <string.h>

CegoBeatConnection::CegoBeatConnection()
{
    _pN = 0;
    _pAdminHandle = 0;
}

CegoBeatConnection::CegoBeatConnection(const Chain& hostName)
{
    _hostName = hostName;
    _pN = 0;
    _pAdminHandle = 0;
}

CegoBeatConnection::CegoBeatConnection(const Chain& hostName, int portNo, const Chain& user, const Chain& passwd, CegoDatabaseManager *pDBMng)
{
    _hostName = hostName;
    _portNo = portNo;
    _user = user;
    _passwd = passwd;
    _pN = 0;
    _pAdminHandle = 0;
    _pDBMng = pDBMng;
    
    _modId = _pDBMng->getModId("CegoBeatConnection");
}
 
CegoBeatConnection::~CegoBeatConnection()
{
    if ( _pN )
	delete _pN;

    if ( _pAdminHandle )
	delete _pAdminHandle;
}

void CegoBeatConnection::setHostName(const Chain& hostName)
{
    _hostName = hostName;
}

const Chain& CegoBeatConnection::getHostName() const
{
    return _hostName;
}

void CegoBeatConnection::setPortNo(int portNo)
{
    _portNo = portNo;
}

int CegoBeatConnection::getPortNo() const
{
    return _portNo;
}

void CegoBeatConnection::setUser(const Chain& user)
{
    _user = user;
}

const Chain& CegoBeatConnection::getUser() const
{
    return _user;
}

void CegoBeatConnection::setPasswd(const Chain& passwd)
{
    _passwd = passwd;
}

const Chain& CegoBeatConnection::getPasswd() const
{
    return _passwd;
}

void CegoBeatConnection::beat(const ListT<Chain>& tsList, const ListT<Chain>& runList, const ListT<Chain>& syncList)
{   
    if ( _pAdminHandle )
    {
	Chain dbHost;
	_pDBMng->getDBHost(dbHost);

	_pAdminHandle->medNotifyMediator(dbHost, XML_ONLINE_VALUE, tsList, runList, syncList);
    }
}

void CegoBeatConnection::connect()
{
    Net n ( NETMNG_MSG_BUFLEN, NETMNG_SIZEBUFLEN, NETMNG_MAXSENDLEN );   
    _pN = n.connect(_hostName, _portNo);
    _pAdminHandle = new CegoAdminHandler(_pDBMng, _pN);
    _pAdminHandle->requestSession(_user, _passwd, false);
}

void CegoBeatConnection::disconnect()
{
    if ( _pAdminHandle )
	_pAdminHandle->closeSession();
}

CegoBeatConnection& CegoBeatConnection::operator = ( const CegoBeatConnection& mc )
{
    _hostName = mc._hostName;
    _portNo = mc._portNo;
    _user = mc._user;
    _passwd = mc._passwd;

    return (*this);
}

bool CegoBeatConnection::operator == ( const CegoBeatConnection& mc)
{    
    if (_hostName == mc._hostName)
	return true;
    return false;
}
	
ostream& operator << (ostream& s, const CegoBeatConnection& mc)
{
    s <<  mc._hostName << ":" << mc._portNo << ":" << mc._user << ":" << mc._passwd;
    return s;
}
