///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcAssignStmt.cc  
// ---------------------                                                     
// Cego procedure assign statement implementation
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2025 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoProcAssignStmt
//
// Description: Stored procedure assignment statement 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Exception.h>
#include <lfcbase/Tokenizer.h>
#include <lfcbase/Datetime.h>

// CEGO INCLUDES
#include "CegoProcAssignStmt.h"
#include "CegoDatabaseFormater.h"

CegoProcAssignStmt::CegoProcAssignStmt(CegoExpr *pExpr,
				       CegoProcBlock *pBlock) : CegoProcStmt(pBlock)
{
    _mode = EXPR2NULL;
    _pExpr = pExpr;
    _pBlock = pBlock;
}

CegoProcAssignStmt::CegoProcAssignStmt(const Chain& paramName,
				       CegoExpr *pExpr,
				       CegoProcBlock *pBlock) : CegoProcStmt(pBlock)
{
    _mode = EXPR2PARAM;
    _paramName = paramName;
    _pExpr = pExpr;
    _pBlock = pBlock;
}

CegoProcAssignStmt::~CegoProcAssignStmt()  
{
    if ( _pExpr )
    {
	delete _pExpr;    
    }
}

CegoException CegoProcAssignStmt::execute()
{
    try
    {
	/*
	ListT<CegoField> *pFL = getParentBlock()->getTriggerValueList();
	
	if ( pFL )
	{
	    CegoField *pF = pFL->First();
	    while ( pF )
	    {
		pF = pFL->Next();
	    }
	}
	*/
	
	
	switch ( _mode )
	{
	case CegoProcAssignStmt::EXPR2NULL:
	{
	    CegoFieldValue fv;

	    ListT<CegoField>* fl[2];
	    fl[0] = _pBlock->getTriggerValueList();
	    fl[1] = 0;

	    fv = _pExpr->evalFieldValue(fl, _pBlock);
	    break;
	}
	case CegoProcAssignStmt::EXPR2PARAM:
	{
	    ListT<CegoField>* fl[2];
	    fl[0] = _pBlock->getTriggerValueList();
	    fl[1] = 0;

	    setValue(_paramName, _pExpr->evalFieldValue(fl, _pBlock));
	    break;
	}
	}
	return NONE_EXCEP;
    }
    catch ( Exception e )
    {
	Chain excepMsg;
	e.pop(excepMsg);
	getParentBlock()->setExceptionMsg(excepMsg);
	return COREOP_EXCEP;
    }
}

void CegoProcAssignStmt::cleanUp()  
{
    if ( _pExpr )
    {
	_pExpr->cleanUp();
    }
}

Chain CegoProcAssignStmt::toChain(int defTabSetId, const Chain& indent) const
{
    Chain s;
	
    switch ( _mode )
    {
    case CegoProcAssignStmt::EXPR2NULL:
    {
	s =  indent + _pExpr->toChain(defTabSetId, indent);
	break;
    }
    case CegoProcAssignStmt::EXPR2PARAM:
    {
	Chain prefix = Chain(":")  + _paramName + Chain(" = ");
	Chain addIndent;
	for ( int i=0; i<prefix.length(); i++ )
	    addIndent += Chain(" ");
	s = indent + prefix + _pExpr->toChain(defTabSetId, indent + addIndent);
	break;
    }
    }
    return s;
}

Chain CegoProcAssignStmt::dbFormat(CegoDatabaseFormater *pForm) const
{
    return pForm->formatProcAssignStmt(_mode, _paramName, _pExpr);
}

bool CegoProcAssignStmt::isStatic() const
{
    try
    {
	_pExpr->getId(_pBlock);
	return true;
    }
    catch ( Exception e )
    {
	return false;
    }
}
