--
-- ### Procedure insert with altered table
--
-- works from version 2.47.10 up

drop if exists table t1;
create table t1( a int, b string(10), c int);

drop if exists procedure doInsert;
@
create procedure doInsert(a in int, b in string(10))
begin
  insert into t1 (a, b ) values ( :a, :b ), ( :a, :b ), ( :a, :b );
end;
@

call doInsert(1, 'alpha');
call doInsert(2, 'beta');
call doInsert(3, 'gamma');

update t1 set c = 11;

-- Now we alter the table
alter table t1 modify column c int default 42 not null;
-- the following procedure should still work 
call doInsert(4, 'omikron');

select * from t1;
