--
-- ### Nested procedure view and procedures with grace mode 
-- 
--

set grace on;

drop if exists table bill;
create table bill ( primary billid int not null, netto decimal(10,2));

insert into bill values ( 1, 12.23);
insert into bill values ( 2, 67.11);

-- we create a view, which uses non existing procedure getVat
drop if exists view plainvat;
create view plainvat as
select getVat() as vat;

-- now we create a procedure, which uses non-existing view vatview 
drop if exists procedure getVat;
@
create procedure getVat() return decimal(10,2)
begin
	var vat decimal(10,2);
    	:vat = ( select vat from vatview );
	return :vat;
end;
@

-- we provide vatview now
drop if exists view vatview;
create view vatview as
select (decimal)0.19 as vat;

-- no critical dependencies anymore on billview
drop if exists view billview;
create view billview as
select billid as billid,
netto as netto,
getVat() * netto as vat
from bill;

-- verify billview, objects are recompiled
select * from billview;

select * from vatview;

select * from plainvat;
