#ifndef _CEGOLOGTHREAD_H_INCLUDED_
#define _CEGOLOGTHREAD_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoLogThread.h  
// -----------------
// Cego log thread class definition
//                                                        
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoLogThread
// 
// Description: Logging Thread imlementation to handle db log messages
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Thread.h>
#include <lfcbase/NetHandler.h>

// cego includes
#include "CegoLogHandler.h"
#include "CegoLockHandler.h"
#include "CegoDatabaseManager.h"

class CegoLogThreadPool;

class CegoLogThread : public Thread {
    
public:
    
    CegoLogThread();
    CegoLogThread(CegoLogThreadPool *pPool, CegoDatabaseManager *pDBMng);
    ~CegoLogThread();

    const Chain& lastAction() const;
    void* job(void* arg);
    bool isTerminated();

private:

    void serveSession(CegoLogHandler *pLH);

    long _idx;
    CegoDatabaseManager* _pDBMng;
    CegoLogThreadPool* _pPool;
    NetHandler* _pRequest;
    Chain _lastAction;
    NanoTimer* _pTim;

    unsigned long _modId;
};
#endif
