#ifndef _CEGOTABLECURSOR_H_INCLUDED_
#define _CEGOTABLECURSOR_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoTableCursor.h
// -----------------
// Cego TableCursor class definition
//      
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoTableCursor
// 
// Description: Basic table cursor implementation
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

// cego includes
#include "CegoObject.h"
#include "CegoDataPointer.h"
#include "CegoTableManager.h"
#include "CegoObjectCursor.h"
#include "CegoAVLIndexCursor.h"
#include "CegoBTreeCursor.h"
#include "CegoAttrCond.h"
#include "CegoField.h"
#include "CegoQueryHelper.h"
#include "CegoBTreeObject.h"

class CegoTableCursor {
    
public:
    
    CegoTableCursor();
    CegoTableCursor(CegoTableManager* pTM, int tabSetId, const Chain& tableName, bool ignoreTouched = false);
    ~CegoTableCursor();
    
    CegoAttrCond::IndexMatch setup(const CegoAttrCond& attrCond);
    
    bool getFirst(ListT<CegoField>& fl, CegoDataPointer& dp);
    bool getNext(ListT<CegoField>& fl, CegoDataPointer& dp);
    const CegoObject::ObjectType getIndexType() const;
    const Chain& getIndexName() const;
    void getIdxSchema(ListT<CegoField>& idxSchema);
    void abort();

protected:

    CegoTableManager* _pTM;
    Chain _tableName;

private:

    CegoAttrCond::IndexMatch setupAnd(const CegoAttrCond& attrCond);
    
    CegoAVLIndexCursor* _pIC;
    CegoBTreeCursor* _pBTC;
    CegoObjectCursor* _pC;
    CegoAttrCond _attrCond;

    ListT<CegoAttrCond> _orCondList;
    
    ListT<CegoField> _idxSchema;
    Chain _idxAttrName;
    bool _idxSetup;
    Chain _idxName;
    CegoObject::ObjectType _type;
    CegoAttrCond::IndexMatch _idxMatch;
    int _tabSetId;
    bool _ignoreTouched;
    bool _readUncommitted;
    bool _idxCached;
    ListT<CegoTableObject> _idxList;
    ListT<CegoBTreeObject> _btreeList;
    CegoQueryHelper _qh;
    CegoDatabaseManager* _pDBMng;

    unsigned long _modId;
};
#endif
