//
// File: Cego.cc
// This code was produced by the dragon parser generator
//
#include "Cego.h"
#include <lfcbase/Exception.h>
#include <lfcbase/StackT.h>

Cego::ScannerStateEntry::ScannerStateEntry()
{
}

Cego::ScannerStateEntry::ScannerStateEntry(unsigned state, ScannerStateType type)
{
   _state = state;
   _type = type;
}

Cego::ScannerStateEntry& Cego::ScannerStateEntry::operator = (const Cego::ScannerStateEntry& s)
{
   _state = s._state;
   _type = s._type;
   return(*this);
}

bool Cego::ScannerStateEntry::operator == (const Cego::ScannerStateEntry& s)
{
   if ( _state == s._state )
      return true;
   return false;
}

Cego::ScannerStateType Cego::ScannerStateEntry::getType()
{
   return _type;
}
unsigned Cego::ScannerStateEntry::getState()
{
   return _state;
}


Cego::ScannerTransEntry::ScannerTransEntry()
{
}

Cego::ScannerTransEntry::ScannerTransEntry(unsigned state, char c)
{
   _state = state;
   _c = c;
}

Cego::ScannerTransEntry::ScannerTransEntry(unsigned state, char c, unsigned fstate)
{
   _state = state;
   _c = c;
   _fstate = fstate;
}

Cego::ScannerTransEntry& Cego::ScannerTransEntry::operator = (const Cego::ScannerTransEntry& s)
{
   _state = s._state;
   _c = s._c;
   _fstate = s._fstate;
   return(*this);
}

bool Cego::ScannerTransEntry::operator == (const Cego::ScannerTransEntry& s)
{
   if ( _state == s._state && _c == s._c)
      return true;
   return false;
}

unsigned Cego::ScannerTransEntry::getFState()
{
   return _fstate;
}


Cego::Scanner::Scanner()
{
}


Cego::Scanner::Scanner(Token t)
{
   _token = t;
}

Cego::Token Cego::Scanner::getToken()
{
   return _token;
}

void Cego::Scanner::addState(ScannerStateEntry s)
{
   _stateList.Insert(s);
}

void Cego::Scanner::addTransition(ScannerTransEntry t)
{
   _transList.Insert(t);
}

bool Cego::Scanner::checkPattern(const Chain& p)
{
   unsigned long state = 0;
   ScannerStateEntry* pS = _stateList.First();
   while (pS)
   {
      if (pS->getType() == START || pS->getType() == ANY)
      {
         state = pS->getState();
         pS = 0;
      }
      else
      {
         pS = _stateList.Next();
      }
   }
   unsigned long i = 0;
   ScannerTransEntry* pT = 
   _transList.Find(ScannerTransEntry(state, p[i]));
   while (pT)
   {
      ScannerStateEntry* pS = _stateList.Find(ScannerStateEntry(pT->getFState())); 
      if (pS)
      {
         if ( ( i == p.length()-2 ) && ( pS->getType() == FINAL || pS->getType() == ANY))
         {
            return true;
         }
         else
         {
            state = pT->getFState();
         }
      }
      else
      {
         return false;
      }
      i++;
      pT = _transList.Find(ScannerTransEntry(state, p[i]));
   }
   return false;
}
Cego::StackEntry::StackEntry()
{
   _symbol = NONE;
}

Cego::StackEntry::StackEntry(Symbol symbol, unsigned num, unsigned state, Chain tval)
{
   _symbol=symbol;
   _num=num;
   _state=state;
   _tval=tval;
}

Cego::StackEntry& Cego::StackEntry::operator = (const Cego::StackEntry& se)
{
   _symbol=se._symbol;
   _num=se._num;
   _state=se._state;
   _tval=se._tval;
   return(*this);
}

unsigned Cego::StackEntry::getState()
{
   return _state;
}
Cego::Symbol Cego::StackEntry::getSymbol()
{
   return _symbol;
}
Chain& Cego::StackEntry::getTval()
{
   return _tval;
}

Cego::ActionEntry::ActionEntry()
{
   _action=NULLACTION;
}

Cego::ActionEntry::ActionEntry(Action action , unsigned num)
{
   _action=action;
   _num=num;
}

bool Cego::ActionEntry::operator == (const Cego::ActionEntry& ae)
{
   if (_action == ae._action && _num == ae._num)
      return true;
   return false;
}

Cego::ActionEntry& Cego::ActionEntry::operator = (const Cego::ActionEntry& ae)
{
   _action=ae._action;
   _num=ae._num;
   return(*this);
}

Cego::Action Cego::ActionEntry::getAction()
{
   return _action;
}

unsigned Cego::ActionEntry::getNum()
{
   return _num;
}

Cego::ProdEntry::ProdEntry()
{
}

Cego::ProdEntry::ProdEntry(unsigned id)
{
   _id = id;
}

Cego::ProdEntry::ProdEntry(unsigned id, Production prod, unsigned numSymbol)
{
   _id = id;
   _prod = prod;
   _numSymbol = numSymbol;
}

bool Cego::ProdEntry::operator == (const Cego::ProdEntry& pe)
{
   if (_id == pe._id)
      return true;
   return false;
}

Cego::ProdEntry& Cego::ProdEntry::operator = (const Cego::ProdEntry& pe)
{
   _id = pe._id;
   _prod = pe._prod;
   _numSymbol = pe._numSymbol;
   return(*this);
}


unsigned Cego::ProdEntry::getId()
{
   return _id;
}

Cego::Production Cego::ProdEntry::getProd()
{
   return _prod;
}

unsigned Cego::ProdEntry::getNumSymbol()
{
   return _numSymbol;
}
void Cego::loadScanner()
{
   Scanner s0(ADD);
   s0.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(2 ,START));
   s0.addState(ScannerStateEntry(3 ,FINAL));
   s0.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s0.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s0.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s0.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s0.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s0.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s0);

   Scanner s1(AFTER);
   s1.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(2 ,START));
   s1.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(5 ,FINAL));
   s1.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s1.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s1.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s1.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s1.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s1.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s1.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s1.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s1.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s1.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s1);

   Scanner s2(ALIAS);
   s2.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(2 ,START));
   s2.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(5 ,FINAL));
   s2.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s2.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s2.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s2.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s2.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s2.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s2.addTransition(ScannerTransEntry(3 ,'A' ,4));
   s2.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s2.addTransition(ScannerTransEntry(4 ,'S' ,5));
   s2.addTransition(ScannerTransEntry(4 ,'s' ,5));
   _scannerList.Insert(s2);

   Scanner s3(AND);
   s3.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(2 ,START));
   s3.addState(ScannerStateEntry(3 ,FINAL));
   s3.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s3.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s3.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s3.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s3.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s3.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s3);

   Scanner s4(ALL);
   s4.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(2 ,START));
   s4.addState(ScannerStateEntry(3 ,FINAL));
   s4.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s4.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s4.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s4.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s4.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s4.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s4);

   Scanner s5(ALTER);
   s5.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(2 ,START));
   s5.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(5 ,FINAL));
   s5.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s5.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s5.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s5.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s5.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s5.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s5.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s5.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s5.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s5.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s5);

   Scanner s6(APPEND);
   s6.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(2 ,START));
   s6.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(6 ,FINAL));
   s6.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s6.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s6.addTransition(ScannerTransEntry(1 ,'P' ,3));
   s6.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s6.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s6.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s6.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s6.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s6.addTransition(ScannerTransEntry(4 ,'N' ,5));
   s6.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s6.addTransition(ScannerTransEntry(5 ,'D' ,6));
   s6.addTransition(ScannerTransEntry(5 ,'d' ,6));
   _scannerList.Insert(s6);

   Scanner s7(AS);
   s7.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(1 ,FINAL));
   s7.addState(ScannerStateEntry(2 ,START));
   s7.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s7.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s7.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s7.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s7);

   Scanner s8(ASC);
   s8.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(2 ,START));
   s8.addState(ScannerStateEntry(3 ,FINAL));
   s8.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s8.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s8.addTransition(ScannerTransEntry(1 ,'C' ,3));
   s8.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s8.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s8.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s8);

   Scanner s9(ASC2INT);
   s9.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(2 ,START));
   s9.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(7 ,FINAL));
   s9.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s9.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s9.addTransition(ScannerTransEntry(1 ,'C' ,3));
   s9.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s9.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s9.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s9.addTransition(ScannerTransEntry(3 ,'2' ,4));
   s9.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s9.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s9.addTransition(ScannerTransEntry(5 ,'N' ,6));
   s9.addTransition(ScannerTransEntry(5 ,'n' ,6));
   s9.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s9.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s9);

   Scanner s10(AUTHORIZE);
   s10.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(2 ,START));
   s10.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(9 ,FINAL));
   s10.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s10.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s10.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s10.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s10.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s10.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s10.addTransition(ScannerTransEntry(3 ,'H' ,4));
   s10.addTransition(ScannerTransEntry(3 ,'h' ,4));
   s10.addTransition(ScannerTransEntry(4 ,'O' ,5));
   s10.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s10.addTransition(ScannerTransEntry(5 ,'R' ,6));
   s10.addTransition(ScannerTransEntry(5 ,'r' ,6));
   s10.addTransition(ScannerTransEntry(6 ,'I' ,7));
   s10.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s10.addTransition(ScannerTransEntry(7 ,'Z' ,8));
   s10.addTransition(ScannerTransEntry(7 ,'z' ,8));
   s10.addTransition(ScannerTransEntry(8 ,'E' ,9));
   s10.addTransition(ScannerTransEntry(8 ,'e' ,9));
   _scannerList.Insert(s10);

   Scanner s11(AUTOCOMMIT);
   s11.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(2 ,START));
   s11.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(10 ,FINAL));
   s11.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s11.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s11.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s11.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s11.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s11.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s11.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s11.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s11.addTransition(ScannerTransEntry(4 ,'C' ,5));
   s11.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s11.addTransition(ScannerTransEntry(5 ,'O' ,6));
   s11.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s11.addTransition(ScannerTransEntry(6 ,'M' ,7));
   s11.addTransition(ScannerTransEntry(6 ,'m' ,7));
   s11.addTransition(ScannerTransEntry(7 ,'M' ,8));
   s11.addTransition(ScannerTransEntry(7 ,'m' ,8));
   s11.addTransition(ScannerTransEntry(8 ,'I' ,9));
   s11.addTransition(ScannerTransEntry(8 ,'i' ,9));
   s11.addTransition(ScannerTransEntry(9 ,'T' ,10));
   s11.addTransition(ScannerTransEntry(9 ,'t' ,10));
   _scannerList.Insert(s11);

   Scanner s12(AVG);
   s12.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(2 ,START));
   s12.addState(ScannerStateEntry(3 ,FINAL));
   s12.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s12.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s12.addTransition(ScannerTransEntry(1 ,'G' ,3));
   s12.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s12.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s12.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s12);

   Scanner s13(AVLTREE);
   s13.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(2 ,START));
   s13.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(7 ,FINAL));
   s13.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s13.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s13.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s13.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s13.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s13.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s13.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s13.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s13.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s13.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s13.addTransition(ScannerTransEntry(6 ,'E' ,7));
   s13.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s13);

   Scanner s14(BEFORE);
   s14.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(2 ,START));
   s14.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(6 ,FINAL));
   s14.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s14.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s14.addTransition(ScannerTransEntry(1 ,'F' ,3));
   s14.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s14.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s14.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s14.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s14.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s14.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s14.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s14.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s14.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s14);

   Scanner s15(BEGIN);
   s15.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(2 ,START));
   s15.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(5 ,FINAL));
   s15.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s15.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s15.addTransition(ScannerTransEntry(1 ,'G' ,3));
   s15.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s15.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s15.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s15.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s15.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s15.addTransition(ScannerTransEntry(4 ,'N' ,5));
   s15.addTransition(ScannerTransEntry(4 ,'n' ,5));
   _scannerList.Insert(s15);

   Scanner s16(BETWEEN);
   s16.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(2 ,START));
   s16.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(7 ,FINAL));
   s16.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s16.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s16.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s16.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s16.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s16.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s16.addTransition(ScannerTransEntry(3 ,'W' ,4));
   s16.addTransition(ScannerTransEntry(3 ,'w' ,4));
   s16.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s16.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s16.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s16.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s16.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s16.addTransition(ScannerTransEntry(6 ,'n' ,7));
   _scannerList.Insert(s16);

   Scanner s17(BIGINT);
   s17.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(2 ,START));
   s17.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(6 ,FINAL));
   s17.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s17.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s17.addTransition(ScannerTransEntry(1 ,'G' ,3));
   s17.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s17.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s17.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s17.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s17.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s17.addTransition(ScannerTransEntry(4 ,'N' ,5));
   s17.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s17.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s17.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s17);

   Scanner s18(BITAND);
   s18.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(2 ,START));
   s18.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(6 ,FINAL));
   s18.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s18.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s18.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s18.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s18.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s18.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s18.addTransition(ScannerTransEntry(3 ,'A' ,4));
   s18.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s18.addTransition(ScannerTransEntry(4 ,'N' ,5));
   s18.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s18.addTransition(ScannerTransEntry(5 ,'D' ,6));
   s18.addTransition(ScannerTransEntry(5 ,'d' ,6));
   _scannerList.Insert(s18);

   Scanner s19(BITOR);
   s19.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(2 ,START));
   s19.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(5 ,FINAL));
   s19.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s19.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s19.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s19.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s19.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s19.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s19.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s19.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s19.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s19.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s19);

   Scanner s20(BITXOR);
   s20.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(2 ,START));
   s20.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(6 ,FINAL));
   s20.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s20.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s20.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s20.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s20.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s20.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s20.addTransition(ScannerTransEntry(3 ,'X' ,4));
   s20.addTransition(ScannerTransEntry(3 ,'x' ,4));
   s20.addTransition(ScannerTransEntry(4 ,'O' ,5));
   s20.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s20.addTransition(ScannerTransEntry(5 ,'R' ,6));
   s20.addTransition(ScannerTransEntry(5 ,'r' ,6));
   _scannerList.Insert(s20);

   Scanner s21(BLOB);
   s21.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(2 ,START));
   s21.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(4 ,FINAL));
   s21.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s21.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s21.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s21.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s21.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s21.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s21.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s21.addTransition(ScannerTransEntry(3 ,'b' ,4));
   _scannerList.Insert(s21);

   Scanner s22(BLOBSIZE);
   s22.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(2 ,START));
   s22.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(8 ,FINAL));
   s22.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s22.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s22.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s22.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s22.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s22.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s22.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s22.addTransition(ScannerTransEntry(3 ,'b' ,4));
   s22.addTransition(ScannerTransEntry(4 ,'S' ,5));
   s22.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s22.addTransition(ScannerTransEntry(5 ,'I' ,6));
   s22.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s22.addTransition(ScannerTransEntry(6 ,'Z' ,7));
   s22.addTransition(ScannerTransEntry(6 ,'z' ,7));
   s22.addTransition(ScannerTransEntry(7 ,'E' ,8));
   s22.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s22);

   Scanner s23(BLOBREF);
   s23.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(2 ,START));
   s23.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(7 ,FINAL));
   s23.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s23.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s23.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s23.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s23.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s23.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s23.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s23.addTransition(ScannerTransEntry(3 ,'b' ,4));
   s23.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s23.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s23.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s23.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s23.addTransition(ScannerTransEntry(6 ,'F' ,7));
   s23.addTransition(ScannerTransEntry(6 ,'f' ,7));
   _scannerList.Insert(s23);

   Scanner s24(BOOL);
   s24.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(2 ,START));
   s24.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(4 ,FINAL));
   s24.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s24.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s24.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s24.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s24.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s24.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s24.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s24.addTransition(ScannerTransEntry(3 ,'l' ,4));
   _scannerList.Insert(s24);

   Scanner s25(BTREE);
   s25.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(2 ,START));
   s25.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(5 ,FINAL));
   s25.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s25.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s25.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s25.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s25.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s25.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s25.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s25.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s25.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s25.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s25);

   Scanner s26(BY);
   s26.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(1 ,FINAL));
   s26.addState(ScannerStateEntry(2 ,START));
   s26.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s26.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s26.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s26.addTransition(ScannerTransEntry(2 ,'b' ,0));
   _scannerList.Insert(s26);

   Scanner s27(CACHED);
   s27.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(2 ,START));
   s27.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(6 ,FINAL));
   s27.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s27.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s27.addTransition(ScannerTransEntry(1 ,'C' ,3));
   s27.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s27.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s27.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s27.addTransition(ScannerTransEntry(3 ,'H' ,4));
   s27.addTransition(ScannerTransEntry(3 ,'h' ,4));
   s27.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s27.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s27.addTransition(ScannerTransEntry(5 ,'D' ,6));
   s27.addTransition(ScannerTransEntry(5 ,'d' ,6));
   _scannerList.Insert(s27);

   Scanner s28(CALL);
   s28.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(2 ,START));
   s28.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(4 ,FINAL));
   s28.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s28.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s28.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s28.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s28.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s28.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s28.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s28.addTransition(ScannerTransEntry(3 ,'l' ,4));
   _scannerList.Insert(s28);

   Scanner s29(CASE);
   s29.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(2 ,START));
   s29.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(4 ,FINAL));
   s29.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s29.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s29.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s29.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s29.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s29.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s29.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s29.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s29);

   Scanner s30(CHECK);
   s30.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(2 ,START));
   s30.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(5 ,FINAL));
   s30.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s30.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s30.addTransition(ScannerTransEntry(1 ,'E' ,3));
   s30.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s30.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s30.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s30.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s30.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s30.addTransition(ScannerTransEntry(4 ,'K' ,5));
   s30.addTransition(ScannerTransEntry(4 ,'k' ,5));
   _scannerList.Insert(s30);

   Scanner s31(CLOB);
   s31.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(2 ,START));
   s31.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(4 ,FINAL));
   s31.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s31.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s31.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s31.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s31.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s31.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s31.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s31.addTransition(ScannerTransEntry(3 ,'b' ,4));
   _scannerList.Insert(s31);

   Scanner s32(CLOBSIZE);
   s32.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(2 ,START));
   s32.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(8 ,FINAL));
   s32.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s32.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s32.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s32.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s32.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s32.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s32.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s32.addTransition(ScannerTransEntry(3 ,'b' ,4));
   s32.addTransition(ScannerTransEntry(4 ,'S' ,5));
   s32.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s32.addTransition(ScannerTransEntry(5 ,'I' ,6));
   s32.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s32.addTransition(ScannerTransEntry(6 ,'Z' ,7));
   s32.addTransition(ScannerTransEntry(6 ,'z' ,7));
   s32.addTransition(ScannerTransEntry(7 ,'E' ,8));
   s32.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s32);

   Scanner s33(CLOBREF);
   s33.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(2 ,START));
   s33.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(7 ,FINAL));
   s33.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s33.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s33.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s33.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s33.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s33.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s33.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s33.addTransition(ScannerTransEntry(3 ,'b' ,4));
   s33.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s33.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s33.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s33.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s33.addTransition(ScannerTransEntry(6 ,'F' ,7));
   s33.addTransition(ScannerTransEntry(6 ,'f' ,7));
   _scannerList.Insert(s33);

   Scanner s34(CLOB2STR);
   s34.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(2 ,START));
   s34.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(8 ,FINAL));
   s34.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s34.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s34.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s34.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s34.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s34.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s34.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s34.addTransition(ScannerTransEntry(3 ,'b' ,4));
   s34.addTransition(ScannerTransEntry(4 ,'2' ,5));
   s34.addTransition(ScannerTransEntry(5 ,'S' ,6));
   s34.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s34.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s34.addTransition(ScannerTransEntry(6 ,'t' ,7));
   s34.addTransition(ScannerTransEntry(7 ,'R' ,8));
   s34.addTransition(ScannerTransEntry(7 ,'r' ,8));
   _scannerList.Insert(s34);

   Scanner s35(CLOSE);
   s35.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(2 ,START));
   s35.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(5 ,FINAL));
   s35.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s35.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s35.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s35.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s35.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s35.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s35.addTransition(ScannerTransEntry(3 ,'S' ,4));
   s35.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s35.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s35.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s35);

   Scanner s36(COMMIT);
   s36.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(2 ,START));
   s36.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(6 ,FINAL));
   s36.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s36.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s36.addTransition(ScannerTransEntry(1 ,'M' ,3));
   s36.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s36.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s36.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s36.addTransition(ScannerTransEntry(3 ,'M' ,4));
   s36.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s36.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s36.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s36.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s36.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s36);

   Scanner s37(COLUMN);
   s37.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(2 ,START));
   s37.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(6 ,FINAL));
   s37.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s37.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s37.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s37.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s37.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s37.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s37.addTransition(ScannerTransEntry(3 ,'U' ,4));
   s37.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s37.addTransition(ScannerTransEntry(4 ,'M' ,5));
   s37.addTransition(ScannerTransEntry(4 ,'m' ,5));
   s37.addTransition(ScannerTransEntry(5 ,'N' ,6));
   s37.addTransition(ScannerTransEntry(5 ,'n' ,6));
   _scannerList.Insert(s37);

   Scanner s38(CONDITION);
   s38.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(2 ,START));
   s38.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(9 ,FINAL));
   s38.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s38.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s38.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s38.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s38.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s38.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s38.addTransition(ScannerTransEntry(3 ,'D' ,4));
   s38.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s38.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s38.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s38.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s38.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s38.addTransition(ScannerTransEntry(6 ,'I' ,7));
   s38.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s38.addTransition(ScannerTransEntry(7 ,'O' ,8));
   s38.addTransition(ScannerTransEntry(7 ,'o' ,8));
   s38.addTransition(ScannerTransEntry(8 ,'N' ,9));
   s38.addTransition(ScannerTransEntry(8 ,'n' ,9));
   _scannerList.Insert(s38);

   Scanner s39(CONSTRAINT);
   s39.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(2 ,START));
   s39.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(10 ,FINAL));
   s39.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s39.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s39.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s39.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s39.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s39.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s39.addTransition(ScannerTransEntry(3 ,'S' ,4));
   s39.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s39.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s39.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s39.addTransition(ScannerTransEntry(5 ,'R' ,6));
   s39.addTransition(ScannerTransEntry(5 ,'r' ,6));
   s39.addTransition(ScannerTransEntry(6 ,'A' ,7));
   s39.addTransition(ScannerTransEntry(6 ,'a' ,7));
   s39.addTransition(ScannerTransEntry(7 ,'I' ,8));
   s39.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s39.addTransition(ScannerTransEntry(8 ,'N' ,9));
   s39.addTransition(ScannerTransEntry(8 ,'n' ,9));
   s39.addTransition(ScannerTransEntry(9 ,'T' ,10));
   s39.addTransition(ScannerTransEntry(9 ,'t' ,10));
   _scannerList.Insert(s39);

   Scanner s40(COUNT);
   s40.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(2 ,START));
   s40.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(5 ,FINAL));
   s40.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s40.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s40.addTransition(ScannerTransEntry(1 ,'U' ,3));
   s40.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s40.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s40.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s40.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s40.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s40.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s40.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s40);

   Scanner s41(COUNTER);
   s41.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(2 ,START));
   s41.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(7 ,FINAL));
   s41.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s41.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s41.addTransition(ScannerTransEntry(1 ,'U' ,3));
   s41.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s41.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s41.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s41.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s41.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s41.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s41.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s41.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s41.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s41.addTransition(ScannerTransEntry(6 ,'R' ,7));
   s41.addTransition(ScannerTransEntry(6 ,'r' ,7));
   _scannerList.Insert(s41);

   Scanner s42(CREATE);
   s42.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(2 ,START));
   s42.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(6 ,FINAL));
   s42.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s42.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s42.addTransition(ScannerTransEntry(1 ,'E' ,3));
   s42.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s42.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s42.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s42.addTransition(ScannerTransEntry(3 ,'A' ,4));
   s42.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s42.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s42.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s42.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s42.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s42);

   Scanner s43(CURSOR);
   s43.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(2 ,START));
   s43.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(6 ,FINAL));
   s43.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s43.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s43.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s43.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s43.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s43.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s43.addTransition(ScannerTransEntry(3 ,'S' ,4));
   s43.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s43.addTransition(ScannerTransEntry(4 ,'O' ,5));
   s43.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s43.addTransition(ScannerTransEntry(5 ,'R' ,6));
   s43.addTransition(ScannerTransEntry(5 ,'r' ,6));
   _scannerList.Insert(s43);

   Scanner s44(DATE2STR);
   s44.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(2 ,START));
   s44.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(8 ,FINAL));
   s44.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s44.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s44.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s44.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s44.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s44.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s44.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s44.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s44.addTransition(ScannerTransEntry(4 ,'2' ,5));
   s44.addTransition(ScannerTransEntry(5 ,'S' ,6));
   s44.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s44.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s44.addTransition(ScannerTransEntry(6 ,'t' ,7));
   s44.addTransition(ScannerTransEntry(7 ,'R' ,8));
   s44.addTransition(ScannerTransEntry(7 ,'r' ,8));
   _scannerList.Insert(s44);

   Scanner s45(DATE2LONG);
   s45.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(2 ,START));
   s45.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(9 ,FINAL));
   s45.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s45.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s45.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s45.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s45.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s45.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s45.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s45.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s45.addTransition(ScannerTransEntry(4 ,'2' ,5));
   s45.addTransition(ScannerTransEntry(5 ,'L' ,6));
   s45.addTransition(ScannerTransEntry(5 ,'l' ,6));
   s45.addTransition(ScannerTransEntry(6 ,'O' ,7));
   s45.addTransition(ScannerTransEntry(6 ,'o' ,7));
   s45.addTransition(ScannerTransEntry(7 ,'N' ,8));
   s45.addTransition(ScannerTransEntry(7 ,'n' ,8));
   s45.addTransition(ScannerTransEntry(8 ,'G' ,9));
   s45.addTransition(ScannerTransEntry(8 ,'g' ,9));
   _scannerList.Insert(s45);

   Scanner s46(DATETIME);
   s46.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(2 ,START));
   s46.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(8 ,FINAL));
   s46.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s46.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s46.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s46.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s46.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s46.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s46.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s46.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s46.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s46.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s46.addTransition(ScannerTransEntry(5 ,'I' ,6));
   s46.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s46.addTransition(ScannerTransEntry(6 ,'M' ,7));
   s46.addTransition(ScannerTransEntry(6 ,'m' ,7));
   s46.addTransition(ScannerTransEntry(7 ,'E' ,8));
   s46.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s46);

   Scanner s47(DECIMAL);
   s47.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(2 ,START));
   s47.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(7 ,FINAL));
   s47.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s47.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s47.addTransition(ScannerTransEntry(1 ,'C' ,3));
   s47.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s47.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s47.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s47.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s47.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s47.addTransition(ScannerTransEntry(4 ,'M' ,5));
   s47.addTransition(ScannerTransEntry(4 ,'m' ,5));
   s47.addTransition(ScannerTransEntry(5 ,'A' ,6));
   s47.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s47.addTransition(ScannerTransEntry(6 ,'L' ,7));
   s47.addTransition(ScannerTransEntry(6 ,'l' ,7));
   _scannerList.Insert(s47);

   Scanner s48(DEFAULT);
   s48.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(2 ,START));
   s48.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(7 ,FINAL));
   s48.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s48.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s48.addTransition(ScannerTransEntry(1 ,'F' ,3));
   s48.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s48.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s48.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s48.addTransition(ScannerTransEntry(3 ,'A' ,4));
   s48.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s48.addTransition(ScannerTransEntry(4 ,'U' ,5));
   s48.addTransition(ScannerTransEntry(4 ,'u' ,5));
   s48.addTransition(ScannerTransEntry(5 ,'L' ,6));
   s48.addTransition(ScannerTransEntry(5 ,'l' ,6));
   s48.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s48.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s48);

   Scanner s49(DELETETOK);
   s49.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(2 ,START));
   s49.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(6 ,FINAL));
   s49.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s49.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s49.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s49.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s49.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s49.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s49.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s49.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s49.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s49.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s49.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s49.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s49);

   Scanner s50(DESC);
   s50.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(2 ,START));
   s50.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(4 ,FINAL));
   s50.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s50.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s50.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s50.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s50.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s50.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s50.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s50.addTransition(ScannerTransEntry(3 ,'c' ,4));
   _scannerList.Insert(s50);

   Scanner s51(DISTINCT);
   s51.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(2 ,START));
   s51.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(8 ,FINAL));
   s51.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s51.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s51.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s51.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s51.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s51.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s51.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s51.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s51.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s51.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s51.addTransition(ScannerTransEntry(5 ,'N' ,6));
   s51.addTransition(ScannerTransEntry(5 ,'n' ,6));
   s51.addTransition(ScannerTransEntry(6 ,'C' ,7));
   s51.addTransition(ScannerTransEntry(6 ,'c' ,7));
   s51.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s51.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s51);

   Scanner s52(DIV);
   s52.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(2 ,START));
   s52.addState(ScannerStateEntry(3 ,FINAL));
   s52.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s52.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s52.addTransition(ScannerTransEntry(1 ,'V' ,3));
   s52.addTransition(ScannerTransEntry(1 ,'v' ,3));
   s52.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s52.addTransition(ScannerTransEntry(2 ,'d' ,0));
   _scannerList.Insert(s52);

   Scanner s53(DOUBLE);
   s53.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(2 ,START));
   s53.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(6 ,FINAL));
   s53.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s53.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s53.addTransition(ScannerTransEntry(1 ,'U' ,3));
   s53.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s53.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s53.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s53.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s53.addTransition(ScannerTransEntry(3 ,'b' ,4));
   s53.addTransition(ScannerTransEntry(4 ,'L' ,5));
   s53.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s53.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s53.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s53);

   Scanner s54(DROP);
   s54.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(2 ,START));
   s54.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(4 ,FINAL));
   s54.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s54.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s54.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s54.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s54.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s54.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s54.addTransition(ScannerTransEntry(3 ,'P' ,4));
   s54.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s54);

   Scanner s55(ELSE);
   s55.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(2 ,START));
   s55.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(4 ,FINAL));
   s55.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s55.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s55.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s55.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s55.addTransition(ScannerTransEntry(2 ,'E' ,0));
   s55.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s55.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s55.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s55);

   Scanner s56(ELSIF);
   s56.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(2 ,START));
   s56.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(5 ,FINAL));
   s56.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s56.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s56.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s56.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s56.addTransition(ScannerTransEntry(2 ,'E' ,0));
   s56.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s56.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s56.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s56.addTransition(ScannerTransEntry(4 ,'F' ,5));
   s56.addTransition(ScannerTransEntry(4 ,'f' ,5));
   _scannerList.Insert(s56);

   Scanner s57(END_TOKEN);
   s57.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(2 ,START));
   s57.addState(ScannerStateEntry(3 ,FINAL));
   s57.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s57.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s57.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s57.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s57.addTransition(ScannerTransEntry(2 ,'E' ,0));
   s57.addTransition(ScannerTransEntry(2 ,'e' ,0));
   _scannerList.Insert(s57);

   Scanner s58(EXCEPTION);
   s58.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(2 ,START));
   s58.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(9 ,FINAL));
   s58.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s58.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s58.addTransition(ScannerTransEntry(1 ,'C' ,3));
   s58.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s58.addTransition(ScannerTransEntry(2 ,'E' ,0));
   s58.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s58.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s58.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s58.addTransition(ScannerTransEntry(4 ,'P' ,5));
   s58.addTransition(ScannerTransEntry(4 ,'p' ,5));
   s58.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s58.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s58.addTransition(ScannerTransEntry(6 ,'I' ,7));
   s58.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s58.addTransition(ScannerTransEntry(7 ,'O' ,8));
   s58.addTransition(ScannerTransEntry(7 ,'o' ,8));
   s58.addTransition(ScannerTransEntry(8 ,'N' ,9));
   s58.addTransition(ScannerTransEntry(8 ,'n' ,9));
   _scannerList.Insert(s58);

   Scanner s59(EXISTS);
   s59.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(2 ,START));
   s59.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(6 ,FINAL));
   s59.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s59.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s59.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s59.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s59.addTransition(ScannerTransEntry(2 ,'E' ,0));
   s59.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s59.addTransition(ScannerTransEntry(3 ,'S' ,4));
   s59.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s59.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s59.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s59.addTransition(ScannerTransEntry(5 ,'S' ,6));
   s59.addTransition(ScannerTransEntry(5 ,'s' ,6));
   _scannerList.Insert(s59);

   Scanner s60(FALSEVAL);
   s60.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(2 ,START));
   s60.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(5 ,FINAL));
   s60.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s60.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s60.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s60.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s60.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s60.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s60.addTransition(ScannerTransEntry(3 ,'S' ,4));
   s60.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s60.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s60.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s60);

   Scanner s61(FETCH);
   s61.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(2 ,START));
   s61.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(5 ,FINAL));
   s61.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s61.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s61.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s61.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s61.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s61.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s61.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s61.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s61.addTransition(ScannerTransEntry(4 ,'H' ,5));
   s61.addTransition(ScannerTransEntry(4 ,'h' ,5));
   _scannerList.Insert(s61);

   Scanner s62(FIRST);
   s62.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(2 ,START));
   s62.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(5 ,FINAL));
   s62.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s62.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s62.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s62.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s62.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s62.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s62.addTransition(ScannerTransEntry(3 ,'S' ,4));
   s62.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s62.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s62.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s62);

   Scanner s63(FLOAT);
   s63.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(2 ,START));
   s63.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(5 ,FINAL));
   s63.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s63.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s63.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s63.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s63.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s63.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s63.addTransition(ScannerTransEntry(3 ,'A' ,4));
   s63.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s63.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s63.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s63);

   Scanner s64(FOR);
   s64.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(2 ,START));
   s64.addState(ScannerStateEntry(3 ,FINAL));
   s64.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s64.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s64.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s64.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s64.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s64.addTransition(ScannerTransEntry(2 ,'f' ,0));
   _scannerList.Insert(s64);

   Scanner s65(FOREIGN);
   s65.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(2 ,START));
   s65.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(7 ,FINAL));
   s65.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s65.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s65.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s65.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s65.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s65.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s65.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s65.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s65.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s65.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s65.addTransition(ScannerTransEntry(5 ,'G' ,6));
   s65.addTransition(ScannerTransEntry(5 ,'g' ,6));
   s65.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s65.addTransition(ScannerTransEntry(6 ,'n' ,7));
   _scannerList.Insert(s65);

   Scanner s66(FROM);
   s66.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(2 ,START));
   s66.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(4 ,FINAL));
   s66.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s66.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s66.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s66.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s66.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s66.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s66.addTransition(ScannerTransEntry(3 ,'M' ,4));
   s66.addTransition(ScannerTransEntry(3 ,'m' ,4));
   _scannerList.Insert(s66);

   Scanner s67(GETCOUNT);
   s67.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(2 ,START));
   s67.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(8 ,FINAL));
   s67.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s67.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s67.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s67.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s67.addTransition(ScannerTransEntry(2 ,'G' ,0));
   s67.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s67.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s67.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s67.addTransition(ScannerTransEntry(4 ,'O' ,5));
   s67.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s67.addTransition(ScannerTransEntry(5 ,'U' ,6));
   s67.addTransition(ScannerTransEntry(5 ,'u' ,6));
   s67.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s67.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s67.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s67.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s67);

   Scanner s68(GETPOS);
   s68.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(2 ,START));
   s68.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(6 ,FINAL));
   s68.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s68.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s68.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s68.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s68.addTransition(ScannerTransEntry(2 ,'G' ,0));
   s68.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s68.addTransition(ScannerTransEntry(3 ,'P' ,4));
   s68.addTransition(ScannerTransEntry(3 ,'p' ,4));
   s68.addTransition(ScannerTransEntry(4 ,'O' ,5));
   s68.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s68.addTransition(ScannerTransEntry(5 ,'S' ,6));
   s68.addTransition(ScannerTransEntry(5 ,'s' ,6));
   _scannerList.Insert(s68);

   Scanner s69(GRACE);
   s69.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(2 ,START));
   s69.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(5 ,FINAL));
   s69.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s69.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s69.addTransition(ScannerTransEntry(1 ,'A' ,3));
   s69.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s69.addTransition(ScannerTransEntry(2 ,'G' ,0));
   s69.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s69.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s69.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s69.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s69.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s69);

   Scanner s70(GROUP);
   s70.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(2 ,START));
   s70.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(5 ,FINAL));
   s70.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s70.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s70.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s70.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s70.addTransition(ScannerTransEntry(2 ,'G' ,0));
   s70.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s70.addTransition(ScannerTransEntry(3 ,'U' ,4));
   s70.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s70.addTransition(ScannerTransEntry(4 ,'P' ,5));
   s70.addTransition(ScannerTransEntry(4 ,'p' ,5));
   _scannerList.Insert(s70);

   Scanner s71(HAVING);
   s71.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(2 ,START));
   s71.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(6 ,FINAL));
   s71.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s71.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s71.addTransition(ScannerTransEntry(1 ,'V' ,3));
   s71.addTransition(ScannerTransEntry(1 ,'v' ,3));
   s71.addTransition(ScannerTransEntry(2 ,'H' ,0));
   s71.addTransition(ScannerTransEntry(2 ,'h' ,0));
   s71.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s71.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s71.addTransition(ScannerTransEntry(4 ,'N' ,5));
   s71.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s71.addTransition(ScannerTransEntry(5 ,'G' ,6));
   s71.addTransition(ScannerTransEntry(5 ,'g' ,6));
   _scannerList.Insert(s71);

   Scanner s72(IDENTIFIED);
   s72.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(2 ,START));
   s72.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(10 ,FINAL));
   s72.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s72.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s72.addTransition(ScannerTransEntry(1 ,'E' ,3));
   s72.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s72.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s72.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s72.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s72.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s72.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s72.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s72.addTransition(ScannerTransEntry(5 ,'I' ,6));
   s72.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s72.addTransition(ScannerTransEntry(6 ,'F' ,7));
   s72.addTransition(ScannerTransEntry(6 ,'f' ,7));
   s72.addTransition(ScannerTransEntry(7 ,'I' ,8));
   s72.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s72.addTransition(ScannerTransEntry(8 ,'E' ,9));
   s72.addTransition(ScannerTransEntry(8 ,'e' ,9));
   s72.addTransition(ScannerTransEntry(9 ,'D' ,10));
   s72.addTransition(ScannerTransEntry(9 ,'d' ,10));
   _scannerList.Insert(s72);

   Scanner s73(IF);
   s73.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(1 ,FINAL));
   s73.addState(ScannerStateEntry(2 ,START));
   s73.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s73.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s73.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s73.addTransition(ScannerTransEntry(2 ,'i' ,0));
   _scannerList.Insert(s73);

   Scanner s74(INDEX);
   s74.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(2 ,START));
   s74.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(5 ,FINAL));
   s74.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s74.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s74.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s74.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s74.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s74.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s74.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s74.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s74.addTransition(ScannerTransEntry(4 ,'X' ,5));
   s74.addTransition(ScannerTransEntry(4 ,'x' ,5));
   _scannerList.Insert(s74);

   Scanner s75(INTOK);
   s75.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(1 ,FINAL));
   s75.addState(ScannerStateEntry(2 ,START));
   s75.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s75.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s75.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s75.addTransition(ScannerTransEntry(2 ,'i' ,0));
   _scannerList.Insert(s75);

   Scanner s76(INNER);
   s76.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(2 ,START));
   s76.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(5 ,FINAL));
   s76.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s76.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s76.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s76.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s76.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s76.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s76.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s76.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s76.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s76.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s76);

   Scanner s77(INT);
   s77.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(2 ,START));
   s77.addState(ScannerStateEntry(3 ,FINAL));
   s77.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s77.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s77.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s77.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s77.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s77.addTransition(ScannerTransEntry(2 ,'i' ,0));
   _scannerList.Insert(s77);

   Scanner s78(INTO);
   s78.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(2 ,START));
   s78.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(4 ,FINAL));
   s78.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s78.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s78.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s78.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s78.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s78.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s78.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s78.addTransition(ScannerTransEntry(3 ,'o' ,4));
   _scannerList.Insert(s78);

   Scanner s79(LONG2DATE);
   s79.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(2 ,START));
   s79.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(9 ,FINAL));
   s79.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s79.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s79.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s79.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s79.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s79.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s79.addTransition(ScannerTransEntry(3 ,'G' ,4));
   s79.addTransition(ScannerTransEntry(3 ,'g' ,4));
   s79.addTransition(ScannerTransEntry(4 ,'2' ,5));
   s79.addTransition(ScannerTransEntry(5 ,'D' ,6));
   s79.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s79.addTransition(ScannerTransEntry(6 ,'A' ,7));
   s79.addTransition(ScannerTransEntry(6 ,'a' ,7));
   s79.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s79.addTransition(ScannerTransEntry(7 ,'t' ,8));
   s79.addTransition(ScannerTransEntry(8 ,'E' ,9));
   s79.addTransition(ScannerTransEntry(8 ,'e' ,9));
   _scannerList.Insert(s79);

   Scanner s80(NEWDATE);
   s80.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(2 ,START));
   s80.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(7 ,FINAL));
   s80.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s80.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s80.addTransition(ScannerTransEntry(1 ,'W' ,3));
   s80.addTransition(ScannerTransEntry(1 ,'w' ,3));
   s80.addTransition(ScannerTransEntry(2 ,'N' ,0));
   s80.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s80.addTransition(ScannerTransEntry(3 ,'D' ,4));
   s80.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s80.addTransition(ScannerTransEntry(4 ,'A' ,5));
   s80.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s80.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s80.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s80.addTransition(ScannerTransEntry(6 ,'E' ,7));
   s80.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s80);

   Scanner s81(INSERT);
   s81.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(2 ,START));
   s81.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(6 ,FINAL));
   s81.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s81.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s81.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s81.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s81.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s81.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s81.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s81.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s81.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s81.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s81.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s81.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s81);

   Scanner s82(INT2ASC);
   s82.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(2 ,START));
   s82.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(7 ,FINAL));
   s82.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s82.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s82.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s82.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s82.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s82.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s82.addTransition(ScannerTransEntry(3 ,'2' ,4));
   s82.addTransition(ScannerTransEntry(4 ,'A' ,5));
   s82.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s82.addTransition(ScannerTransEntry(5 ,'C' ,6));
   s82.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s82.addTransition(ScannerTransEntry(6 ,'C' ,7));
   s82.addTransition(ScannerTransEntry(6 ,'c' ,7));
   _scannerList.Insert(s82);

   Scanner s83(IS);
   s83.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(1 ,FINAL));
   s83.addState(ScannerStateEntry(2 ,START));
   s83.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s83.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s83.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s83.addTransition(ScannerTransEntry(2 ,'i' ,0));
   _scannerList.Insert(s83);

   Scanner s84(ISOLATION);
   s84.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(2 ,START));
   s84.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(9 ,FINAL));
   s84.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s84.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s84.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s84.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s84.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s84.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s84.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s84.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s84.addTransition(ScannerTransEntry(4 ,'A' ,5));
   s84.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s84.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s84.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s84.addTransition(ScannerTransEntry(6 ,'I' ,7));
   s84.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s84.addTransition(ScannerTransEntry(7 ,'O' ,8));
   s84.addTransition(ScannerTransEntry(7 ,'o' ,8));
   s84.addTransition(ScannerTransEntry(8 ,'N' ,9));
   s84.addTransition(ScannerTransEntry(8 ,'n' ,9));
   _scannerList.Insert(s84);

   Scanner s85(JDBC);
   s85.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(2 ,START));
   s85.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(4 ,FINAL));
   s85.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s85.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s85.addTransition(ScannerTransEntry(1 ,'B' ,3));
   s85.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s85.addTransition(ScannerTransEntry(2 ,'J' ,0));
   s85.addTransition(ScannerTransEntry(2 ,'j' ,0));
   s85.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s85.addTransition(ScannerTransEntry(3 ,'c' ,4));
   _scannerList.Insert(s85);

   Scanner s86(JOIN);
   s86.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(2 ,START));
   s86.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(4 ,FINAL));
   s86.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s86.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s86.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s86.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s86.addTransition(ScannerTransEntry(2 ,'J' ,0));
   s86.addTransition(ScannerTransEntry(2 ,'j' ,0));
   s86.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s86.addTransition(ScannerTransEntry(3 ,'n' ,4));
   _scannerList.Insert(s86);

   Scanner s87(KEY);
   s87.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(2 ,START));
   s87.addState(ScannerStateEntry(3 ,FINAL));
   s87.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s87.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s87.addTransition(ScannerTransEntry(1 ,'Y' ,3));
   s87.addTransition(ScannerTransEntry(1 ,'y' ,3));
   s87.addTransition(ScannerTransEntry(2 ,'K' ,0));
   s87.addTransition(ScannerTransEntry(2 ,'k' ,0));
   _scannerList.Insert(s87);

   Scanner s88(LEFT);
   s88.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(2 ,START));
   s88.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(4 ,FINAL));
   s88.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s88.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s88.addTransition(ScannerTransEntry(1 ,'F' ,3));
   s88.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s88.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s88.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s88.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s88.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s88);

   Scanner s89(LENGTH);
   s89.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(2 ,START));
   s89.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(6 ,FINAL));
   s89.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s89.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s89.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s89.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s89.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s89.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s89.addTransition(ScannerTransEntry(3 ,'G' ,4));
   s89.addTransition(ScannerTransEntry(3 ,'g' ,4));
   s89.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s89.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s89.addTransition(ScannerTransEntry(5 ,'H' ,6));
   s89.addTransition(ScannerTransEntry(5 ,'h' ,6));
   _scannerList.Insert(s89);

   Scanner s90(LIKE);
   s90.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(2 ,START));
   s90.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(4 ,FINAL));
   s90.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s90.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s90.addTransition(ScannerTransEntry(1 ,'K' ,3));
   s90.addTransition(ScannerTransEntry(1 ,'k' ,3));
   s90.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s90.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s90.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s90.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s90);

   Scanner s91(LIST);
   s91.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(2 ,START));
   s91.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(4 ,FINAL));
   s91.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s91.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s91.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s91.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s91.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s91.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s91.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s91.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s91);

   Scanner s92(LDIV);
   s92.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(2 ,START));
   s92.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(4 ,FINAL));
   s92.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s92.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s92.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s92.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s92.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s92.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s92.addTransition(ScannerTransEntry(3 ,'V' ,4));
   s92.addTransition(ScannerTransEntry(3 ,'v' ,4));
   _scannerList.Insert(s92);

   Scanner s93(LMOD);
   s93.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(2 ,START));
   s93.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(4 ,FINAL));
   s93.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s93.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s93.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s93.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s93.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s93.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s93.addTransition(ScannerTransEntry(3 ,'D' ,4));
   s93.addTransition(ScannerTransEntry(3 ,'d' ,4));
   _scannerList.Insert(s93);

   Scanner s94(LOAD);
   s94.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(2 ,START));
   s94.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(4 ,FINAL));
   s94.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s94.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s94.addTransition(ScannerTransEntry(1 ,'A' ,3));
   s94.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s94.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s94.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s94.addTransition(ScannerTransEntry(3 ,'D' ,4));
   s94.addTransition(ScannerTransEntry(3 ,'d' ,4));
   _scannerList.Insert(s94);

   Scanner s95(LOCK);
   s95.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(2 ,START));
   s95.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(4 ,FINAL));
   s95.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s95.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s95.addTransition(ScannerTransEntry(1 ,'C' ,3));
   s95.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s95.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s95.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s95.addTransition(ScannerTransEntry(3 ,'K' ,4));
   s95.addTransition(ScannerTransEntry(3 ,'k' ,4));
   _scannerList.Insert(s95);

   Scanner s96(UNLOCK);
   s96.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(2 ,START));
   s96.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(6 ,FINAL));
   s96.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s96.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s96.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s96.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s96.addTransition(ScannerTransEntry(2 ,'U' ,0));
   s96.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s96.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s96.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s96.addTransition(ScannerTransEntry(4 ,'C' ,5));
   s96.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s96.addTransition(ScannerTransEntry(5 ,'K' ,6));
   s96.addTransition(ScannerTransEntry(5 ,'k' ,6));
   _scannerList.Insert(s96);

   Scanner s97(LONG);
   s97.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(2 ,START));
   s97.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(4 ,FINAL));
   s97.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s97.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s97.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s97.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s97.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s97.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s97.addTransition(ScannerTransEntry(3 ,'G' ,4));
   s97.addTransition(ScannerTransEntry(3 ,'g' ,4));
   _scannerList.Insert(s97);

   Scanner s98(LOWER);
   s98.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(2 ,START));
   s98.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(5 ,FINAL));
   s98.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s98.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s98.addTransition(ScannerTransEntry(1 ,'W' ,3));
   s98.addTransition(ScannerTransEntry(1 ,'w' ,3));
   s98.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s98.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s98.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s98.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s98.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s98.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s98);

   Scanner s99(LTRIM);
   s99.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(2 ,START));
   s99.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(5 ,FINAL));
   s99.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s99.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s99.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s99.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s99.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s99.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s99.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s99.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s99.addTransition(ScannerTransEntry(4 ,'M' ,5));
   s99.addTransition(ScannerTransEntry(4 ,'m' ,5));
   _scannerList.Insert(s99);

   Scanner s100(MIN);
   s100.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(2 ,START));
   s100.addState(ScannerStateEntry(3 ,FINAL));
   s100.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s100.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s100.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s100.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s100.addTransition(ScannerTransEntry(2 ,'M' ,0));
   s100.addTransition(ScannerTransEntry(2 ,'m' ,0));
   _scannerList.Insert(s100);

   Scanner s101(MAX);
   s101.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(2 ,START));
   s101.addState(ScannerStateEntry(3 ,FINAL));
   s101.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s101.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s101.addTransition(ScannerTransEntry(1 ,'X' ,3));
   s101.addTransition(ScannerTransEntry(1 ,'x' ,3));
   s101.addTransition(ScannerTransEntry(2 ,'M' ,0));
   s101.addTransition(ScannerTransEntry(2 ,'m' ,0));
   _scannerList.Insert(s101);

   Scanner s102(MOD);
   s102.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(2 ,START));
   s102.addState(ScannerStateEntry(3 ,FINAL));
   s102.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s102.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s102.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s102.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s102.addTransition(ScannerTransEntry(2 ,'M' ,0));
   s102.addTransition(ScannerTransEntry(2 ,'m' ,0));
   _scannerList.Insert(s102);

   Scanner s103(MODIFY);
   s103.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(2 ,START));
   s103.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(6 ,FINAL));
   s103.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s103.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s103.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s103.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s103.addTransition(ScannerTransEntry(2 ,'M' ,0));
   s103.addTransition(ScannerTransEntry(2 ,'m' ,0));
   s103.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s103.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s103.addTransition(ScannerTransEntry(4 ,'F' ,5));
   s103.addTransition(ScannerTransEntry(4 ,'f' ,5));
   s103.addTransition(ScannerTransEntry(5 ,'Y' ,6));
   s103.addTransition(ScannerTransEntry(5 ,'y' ,6));
   _scannerList.Insert(s103);

   Scanner s104(NCLIKE);
   s104.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(2 ,START));
   s104.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(6 ,FINAL));
   s104.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s104.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s104.addTransition(ScannerTransEntry(2 ,'N' ,0));
   s104.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s104.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s104.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s104.addTransition(ScannerTransEntry(4 ,'K' ,5));
   s104.addTransition(ScannerTransEntry(4 ,'k' ,5));
   s104.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s104.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s104);

   Scanner s105(NEXTCOUNT);
   s105.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(2 ,START));
   s105.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(9 ,FINAL));
   s105.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s105.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s105.addTransition(ScannerTransEntry(1 ,'X' ,3));
   s105.addTransition(ScannerTransEntry(1 ,'x' ,3));
   s105.addTransition(ScannerTransEntry(2 ,'N' ,0));
   s105.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s105.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s105.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s105.addTransition(ScannerTransEntry(4 ,'C' ,5));
   s105.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s105.addTransition(ScannerTransEntry(5 ,'O' ,6));
   s105.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s105.addTransition(ScannerTransEntry(6 ,'U' ,7));
   s105.addTransition(ScannerTransEntry(6 ,'u' ,7));
   s105.addTransition(ScannerTransEntry(7 ,'N' ,8));
   s105.addTransition(ScannerTransEntry(7 ,'n' ,8));
   s105.addTransition(ScannerTransEntry(8 ,'T' ,9));
   s105.addTransition(ScannerTransEntry(8 ,'t' ,9));
   _scannerList.Insert(s105);

   Scanner s106(NOOP);
   s106.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(2 ,START));
   s106.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(4 ,FINAL));
   s106.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s106.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s106.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s106.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s106.addTransition(ScannerTransEntry(2 ,'N' ,0));
   s106.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s106.addTransition(ScannerTransEntry(3 ,'P' ,4));
   s106.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s106);

   Scanner s107(NOT);
   s107.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(2 ,START));
   s107.addState(ScannerStateEntry(3 ,FINAL));
   s107.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s107.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s107.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s107.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s107.addTransition(ScannerTransEntry(2 ,'N' ,0));
   s107.addTransition(ScannerTransEntry(2 ,'n' ,0));
   _scannerList.Insert(s107);

   Scanner s108(NULLTOKEN);
   s108.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(2 ,START));
   s108.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(4 ,FINAL));
   s108.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s108.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s108.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s108.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s108.addTransition(ScannerTransEntry(2 ,'N' ,0));
   s108.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s108.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s108.addTransition(ScannerTransEntry(3 ,'l' ,4));
   _scannerList.Insert(s108);

   Scanner s109(OFF);
   s109.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(2 ,START));
   s109.addState(ScannerStateEntry(3 ,FINAL));
   s109.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s109.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s109.addTransition(ScannerTransEntry(1 ,'F' ,3));
   s109.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s109.addTransition(ScannerTransEntry(2 ,'O' ,0));
   s109.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s109);

   Scanner s110(ON);
   s110.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(1 ,FINAL));
   s110.addState(ScannerStateEntry(2 ,START));
   s110.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s110.addTransition(ScannerTransEntry(2 ,'O' ,0));
   s110.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s110);

   Scanner s111(OUTTOK);
   s111.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s111.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s111.addState(ScannerStateEntry(2 ,START));
   s111.addState(ScannerStateEntry(3 ,FINAL));
   s111.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s111.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s111.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s111.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s111.addTransition(ScannerTransEntry(2 ,'O' ,0));
   s111.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s111);

   Scanner s112(OUTER);
   s112.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s112.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s112.addState(ScannerStateEntry(2 ,START));
   s112.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s112.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s112.addState(ScannerStateEntry(5 ,FINAL));
   s112.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s112.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s112.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s112.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s112.addTransition(ScannerTransEntry(2 ,'O' ,0));
   s112.addTransition(ScannerTransEntry(2 ,'o' ,0));
   s112.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s112.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s112.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s112.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s112);

   Scanner s113(OR);
   s113.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(1 ,FINAL));
   s113.addState(ScannerStateEntry(2 ,START));
   s113.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s113.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s113.addTransition(ScannerTransEntry(2 ,'O' ,0));
   s113.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s113);

   Scanner s114(ORDER);
   s114.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s114.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s114.addState(ScannerStateEntry(2 ,START));
   s114.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s114.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s114.addState(ScannerStateEntry(5 ,FINAL));
   s114.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s114.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s114.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s114.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s114.addTransition(ScannerTransEntry(2 ,'O' ,0));
   s114.addTransition(ScannerTransEntry(2 ,'o' ,0));
   s114.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s114.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s114.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s114.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s114);

   Scanner s115(PLAN);
   s115.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s115.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s115.addState(ScannerStateEntry(2 ,START));
   s115.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s115.addState(ScannerStateEntry(4 ,FINAL));
   s115.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'A' ,3));
   s115.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s115.addTransition(ScannerTransEntry(2 ,'P' ,0));
   s115.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s115.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s115.addTransition(ScannerTransEntry(3 ,'n' ,4));
   _scannerList.Insert(s115);

   Scanner s116(POOL);
   s116.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s116.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s116.addState(ScannerStateEntry(2 ,START));
   s116.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s116.addState(ScannerStateEntry(4 ,FINAL));
   s116.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s116.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s116.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s116.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s116.addTransition(ScannerTransEntry(2 ,'P' ,0));
   s116.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s116.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s116.addTransition(ScannerTransEntry(3 ,'l' ,4));
   _scannerList.Insert(s116);

   Scanner s117(POWER);
   s117.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s117.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s117.addState(ScannerStateEntry(2 ,START));
   s117.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s117.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s117.addState(ScannerStateEntry(5 ,FINAL));
   s117.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s117.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s117.addTransition(ScannerTransEntry(1 ,'W' ,3));
   s117.addTransition(ScannerTransEntry(1 ,'w' ,3));
   s117.addTransition(ScannerTransEntry(2 ,'P' ,0));
   s117.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s117.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s117.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s117.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s117.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s117);

   Scanner s118(PRIMARY);
   s118.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(2 ,START));
   s118.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(7 ,FINAL));
   s118.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s118.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s118.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s118.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s118.addTransition(ScannerTransEntry(2 ,'P' ,0));
   s118.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s118.addTransition(ScannerTransEntry(3 ,'M' ,4));
   s118.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s118.addTransition(ScannerTransEntry(4 ,'A' ,5));
   s118.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s118.addTransition(ScannerTransEntry(5 ,'R' ,6));
   s118.addTransition(ScannerTransEntry(5 ,'r' ,6));
   s118.addTransition(ScannerTransEntry(6 ,'Y' ,7));
   s118.addTransition(ScannerTransEntry(6 ,'y' ,7));
   _scannerList.Insert(s118);

   Scanner s119(PRINT);
   s119.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s119.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s119.addState(ScannerStateEntry(2 ,START));
   s119.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s119.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s119.addState(ScannerStateEntry(5 ,FINAL));
   s119.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s119.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s119.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s119.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s119.addTransition(ScannerTransEntry(2 ,'P' ,0));
   s119.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s119.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s119.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s119.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s119.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s119);

   Scanner s120(PROCEDURE);
   s120.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s120.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s120.addState(ScannerStateEntry(2 ,START));
   s120.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s120.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s120.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s120.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s120.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s120.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s120.addState(ScannerStateEntry(9 ,FINAL));
   s120.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s120.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s120.addTransition(ScannerTransEntry(2 ,'P' ,0));
   s120.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s120.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s120.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s120.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s120.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s120.addTransition(ScannerTransEntry(5 ,'D' ,6));
   s120.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s120.addTransition(ScannerTransEntry(6 ,'U' ,7));
   s120.addTransition(ScannerTransEntry(6 ,'u' ,7));
   s120.addTransition(ScannerTransEntry(7 ,'R' ,8));
   s120.addTransition(ScannerTransEntry(7 ,'r' ,8));
   s120.addTransition(ScannerTransEntry(8 ,'E' ,9));
   s120.addTransition(ScannerTransEntry(8 ,'e' ,9));
   _scannerList.Insert(s120);

   Scanner s121(QUIT);
   s121.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s121.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s121.addState(ScannerStateEntry(2 ,START));
   s121.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s121.addState(ScannerStateEntry(4 ,FINAL));
   s121.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s121.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s121.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s121.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s121.addTransition(ScannerTransEntry(2 ,'Q' ,0));
   s121.addTransition(ScannerTransEntry(2 ,'q' ,0));
   s121.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s121.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s121);

   Scanner s122(RANDSTR);
   s122.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s122.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s122.addState(ScannerStateEntry(2 ,START));
   s122.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s122.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s122.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s122.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s122.addState(ScannerStateEntry(7 ,FINAL));
   s122.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s122.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s122.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s122.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s122.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s122.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s122.addTransition(ScannerTransEntry(3 ,'D' ,4));
   s122.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s122.addTransition(ScannerTransEntry(4 ,'S' ,5));
   s122.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s122.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s122.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s122.addTransition(ScannerTransEntry(6 ,'R' ,7));
   s122.addTransition(ScannerTransEntry(6 ,'r' ,7));
   _scannerList.Insert(s122);

   Scanner s123(RANDINT);
   s123.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s123.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s123.addState(ScannerStateEntry(2 ,START));
   s123.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s123.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s123.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s123.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s123.addState(ScannerStateEntry(7 ,FINAL));
   s123.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s123.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s123.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s123.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s123.addTransition(ScannerTransEntry(3 ,'D' ,4));
   s123.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s123.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s123.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s123.addTransition(ScannerTransEntry(5 ,'N' ,6));
   s123.addTransition(ScannerTransEntry(5 ,'n' ,6));
   s123.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s123.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s123);

   Scanner s124(RBSEG);
   s124.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(2 ,START));
   s124.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(5 ,FINAL));
   s124.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s124.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s124.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s124.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s124.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s124.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s124.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s124.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s124.addTransition(ScannerTransEntry(4 ,'G' ,5));
   s124.addTransition(ScannerTransEntry(4 ,'g' ,5));
   _scannerList.Insert(s124);

   Scanner s125(REFERENCES);
   s125.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s125.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s125.addState(ScannerStateEntry(2 ,START));
   s125.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s125.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s125.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s125.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s125.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s125.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s125.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s125.addState(ScannerStateEntry(10 ,FINAL));
   s125.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s125.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s125.addTransition(ScannerTransEntry(1 ,'F' ,3));
   s125.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s125.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s125.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s125.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s125.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s125.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s125.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s125.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s125.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s125.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s125.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s125.addTransition(ScannerTransEntry(7 ,'C' ,8));
   s125.addTransition(ScannerTransEntry(7 ,'c' ,8));
   s125.addTransition(ScannerTransEntry(8 ,'E' ,9));
   s125.addTransition(ScannerTransEntry(8 ,'e' ,9));
   s125.addTransition(ScannerTransEntry(9 ,'S' ,10));
   s125.addTransition(ScannerTransEntry(9 ,'s' ,10));
   _scannerList.Insert(s125);

   Scanner s126(REGMATCH);
   s126.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(2 ,START));
   s126.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(8 ,FINAL));
   s126.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s126.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s126.addTransition(ScannerTransEntry(1 ,'G' ,3));
   s126.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s126.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s126.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s126.addTransition(ScannerTransEntry(3 ,'M' ,4));
   s126.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s126.addTransition(ScannerTransEntry(4 ,'A' ,5));
   s126.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s126.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s126.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s126.addTransition(ScannerTransEntry(6 ,'C' ,7));
   s126.addTransition(ScannerTransEntry(6 ,'c' ,7));
   s126.addTransition(ScannerTransEntry(7 ,'H' ,8));
   s126.addTransition(ScannerTransEntry(7 ,'h' ,8));
   _scannerList.Insert(s126);

   Scanner s127(RENAME);
   s127.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s127.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s127.addState(ScannerStateEntry(2 ,START));
   s127.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s127.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s127.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s127.addState(ScannerStateEntry(6 ,FINAL));
   s127.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s127.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s127.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s127.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s127.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s127.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s127.addTransition(ScannerTransEntry(3 ,'A' ,4));
   s127.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s127.addTransition(ScannerTransEntry(4 ,'M' ,5));
   s127.addTransition(ScannerTransEntry(4 ,'m' ,5));
   s127.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s127.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s127);

   Scanner s128(REORGANIZE);
   s128.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(2 ,START));
   s128.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(10 ,FINAL));
   s128.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s128.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s128.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s128.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s128.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s128.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s128.addTransition(ScannerTransEntry(3 ,'R' ,4));
   s128.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s128.addTransition(ScannerTransEntry(4 ,'G' ,5));
   s128.addTransition(ScannerTransEntry(4 ,'g' ,5));
   s128.addTransition(ScannerTransEntry(5 ,'A' ,6));
   s128.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s128.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s128.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s128.addTransition(ScannerTransEntry(7 ,'I' ,8));
   s128.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s128.addTransition(ScannerTransEntry(8 ,'Z' ,9));
   s128.addTransition(ScannerTransEntry(8 ,'z' ,9));
   s128.addTransition(ScannerTransEntry(9 ,'E' ,10));
   s128.addTransition(ScannerTransEntry(9 ,'e' ,10));
   _scannerList.Insert(s128);

   Scanner s129(RETURNTOKEN);
   s129.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s129.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s129.addState(ScannerStateEntry(2 ,START));
   s129.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s129.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s129.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s129.addState(ScannerStateEntry(6 ,FINAL));
   s129.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s129.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s129.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s129.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s129.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s129.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s129.addTransition(ScannerTransEntry(3 ,'U' ,4));
   s129.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s129.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s129.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s129.addTransition(ScannerTransEntry(5 ,'N' ,6));
   s129.addTransition(ScannerTransEntry(5 ,'n' ,6));
   _scannerList.Insert(s129);

   Scanner s130(REMOVE);
   s130.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s130.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s130.addState(ScannerStateEntry(2 ,START));
   s130.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s130.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s130.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s130.addState(ScannerStateEntry(6 ,FINAL));
   s130.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s130.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s130.addTransition(ScannerTransEntry(1 ,'M' ,3));
   s130.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s130.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s130.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s130.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s130.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s130.addTransition(ScannerTransEntry(4 ,'V' ,5));
   s130.addTransition(ScannerTransEntry(4 ,'v' ,5));
   s130.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s130.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s130);

   Scanner s131(REPLACE);
   s131.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s131.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s131.addState(ScannerStateEntry(2 ,START));
   s131.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s131.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s131.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s131.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s131.addState(ScannerStateEntry(7 ,FINAL));
   s131.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s131.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s131.addTransition(ScannerTransEntry(1 ,'P' ,3));
   s131.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s131.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s131.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s131.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s131.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s131.addTransition(ScannerTransEntry(4 ,'A' ,5));
   s131.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s131.addTransition(ScannerTransEntry(5 ,'C' ,6));
   s131.addTransition(ScannerTransEntry(5 ,'c' ,6));
   s131.addTransition(ScannerTransEntry(6 ,'E' ,7));
   s131.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s131);

   Scanner s132(RIGHT);
   s132.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s132.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s132.addState(ScannerStateEntry(2 ,START));
   s132.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s132.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s132.addState(ScannerStateEntry(5 ,FINAL));
   s132.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s132.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s132.addTransition(ScannerTransEntry(1 ,'G' ,3));
   s132.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s132.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s132.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s132.addTransition(ScannerTransEntry(3 ,'H' ,4));
   s132.addTransition(ScannerTransEntry(3 ,'h' ,4));
   s132.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s132.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s132);

   Scanner s133(ROLLBACK);
   s133.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(2 ,START));
   s133.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(8 ,FINAL));
   s133.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s133.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s133.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s133.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s133.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s133.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s133.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s133.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s133.addTransition(ScannerTransEntry(4 ,'B' ,5));
   s133.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s133.addTransition(ScannerTransEntry(5 ,'A' ,6));
   s133.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s133.addTransition(ScannerTransEntry(6 ,'C' ,7));
   s133.addTransition(ScannerTransEntry(6 ,'c' ,7));
   s133.addTransition(ScannerTransEntry(7 ,'K' ,8));
   s133.addTransition(ScannerTransEntry(7 ,'k' ,8));
   _scannerList.Insert(s133);

   Scanner s134(ROUND);
   s134.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s134.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s134.addState(ScannerStateEntry(2 ,START));
   s134.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s134.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s134.addState(ScannerStateEntry(5 ,FINAL));
   s134.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s134.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s134.addTransition(ScannerTransEntry(1 ,'U' ,3));
   s134.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s134.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s134.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s134.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s134.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s134.addTransition(ScannerTransEntry(4 ,'D' ,5));
   s134.addTransition(ScannerTransEntry(4 ,'d' ,5));
   _scannerList.Insert(s134);

   Scanner s135(ROWLIMIT);
   s135.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(2 ,START));
   s135.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(8 ,FINAL));
   s135.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s135.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s135.addTransition(ScannerTransEntry(1 ,'W' ,3));
   s135.addTransition(ScannerTransEntry(1 ,'w' ,3));
   s135.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s135.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s135.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s135.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s135.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s135.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s135.addTransition(ScannerTransEntry(5 ,'M' ,6));
   s135.addTransition(ScannerTransEntry(5 ,'m' ,6));
   s135.addTransition(ScannerTransEntry(6 ,'I' ,7));
   s135.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s135.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s135.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s135);

   Scanner s136(RTRIM);
   s136.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(2 ,START));
   s136.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(5 ,FINAL));
   s136.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s136.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s136.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s136.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s136.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s136.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s136.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s136.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s136.addTransition(ScannerTransEntry(4 ,'M' ,5));
   s136.addTransition(ScannerTransEntry(4 ,'m' ,5));
   _scannerList.Insert(s136);

   Scanner s137(SCANDATE);
   s137.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s137.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s137.addState(ScannerStateEntry(2 ,START));
   s137.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s137.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s137.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s137.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s137.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s137.addState(ScannerStateEntry(8 ,FINAL));
   s137.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s137.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s137.addTransition(ScannerTransEntry(1 ,'A' ,3));
   s137.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s137.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s137.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s137.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s137.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s137.addTransition(ScannerTransEntry(4 ,'D' ,5));
   s137.addTransition(ScannerTransEntry(4 ,'d' ,5));
   s137.addTransition(ScannerTransEntry(5 ,'A' ,6));
   s137.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s137.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s137.addTransition(ScannerTransEntry(6 ,'t' ,7));
   s137.addTransition(ScannerTransEntry(7 ,'E' ,8));
   s137.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s137);

   Scanner s138(SELECT);
   s138.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(2 ,START));
   s138.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(6 ,FINAL));
   s138.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s138.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s138.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s138.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s138.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s138.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s138.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s138.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s138.addTransition(ScannerTransEntry(4 ,'C' ,5));
   s138.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s138.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s138.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s138);

   Scanner s139(SET);
   s139.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s139.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s139.addState(ScannerStateEntry(2 ,START));
   s139.addState(ScannerStateEntry(3 ,FINAL));
   s139.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s139.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s139.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s139.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s139.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s139.addTransition(ScannerTransEntry(2 ,'s' ,0));
   _scannerList.Insert(s139);

   Scanner s140(SETCOUNT);
   s140.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s140.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s140.addState(ScannerStateEntry(2 ,START));
   s140.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s140.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s140.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s140.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s140.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s140.addState(ScannerStateEntry(8 ,FINAL));
   s140.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s140.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s140.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s140.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s140.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s140.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s140.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s140.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s140.addTransition(ScannerTransEntry(4 ,'O' ,5));
   s140.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s140.addTransition(ScannerTransEntry(5 ,'U' ,6));
   s140.addTransition(ScannerTransEntry(5 ,'u' ,6));
   s140.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s140.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s140.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s140.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s140);

   Scanner s141(SHOW);
   s141.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s141.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s141.addState(ScannerStateEntry(2 ,START));
   s141.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s141.addState(ScannerStateEntry(4 ,FINAL));
   s141.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s141.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s141.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s141.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s141.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s141.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s141.addTransition(ScannerTransEntry(3 ,'W' ,4));
   s141.addTransition(ScannerTransEntry(3 ,'w' ,4));
   _scannerList.Insert(s141);

   Scanner s142(SMALLINT);
   s142.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s142.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s142.addState(ScannerStateEntry(2 ,START));
   s142.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s142.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s142.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s142.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s142.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s142.addState(ScannerStateEntry(8 ,FINAL));
   s142.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s142.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s142.addTransition(ScannerTransEntry(1 ,'A' ,3));
   s142.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s142.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s142.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s142.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s142.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s142.addTransition(ScannerTransEntry(4 ,'L' ,5));
   s142.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s142.addTransition(ScannerTransEntry(5 ,'I' ,6));
   s142.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s142.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s142.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s142.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s142.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s142);

   Scanner s143(START_TOKEN);
   s143.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s143.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s143.addState(ScannerStateEntry(2 ,START));
   s143.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s143.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s143.addState(ScannerStateEntry(5 ,FINAL));
   s143.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s143.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s143.addTransition(ScannerTransEntry(1 ,'A' ,3));
   s143.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s143.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s143.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s143.addTransition(ScannerTransEntry(3 ,'R' ,4));
   s143.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s143.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s143.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s143);

   Scanner s144(STRING);
   s144.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s144.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s144.addState(ScannerStateEntry(2 ,START));
   s144.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s144.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s144.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s144.addState(ScannerStateEntry(6 ,FINAL));
   s144.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s144.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s144.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s144.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s144.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s144.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s144.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s144.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s144.addTransition(ScannerTransEntry(4 ,'N' ,5));
   s144.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s144.addTransition(ScannerTransEntry(5 ,'G' ,6));
   s144.addTransition(ScannerTransEntry(5 ,'g' ,6));
   _scannerList.Insert(s144);

   Scanner s145(SUBSTR);
   s145.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(2 ,START));
   s145.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(6 ,FINAL));
   s145.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s145.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s145.addTransition(ScannerTransEntry(1 ,'B' ,3));
   s145.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s145.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s145.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s145.addTransition(ScannerTransEntry(3 ,'S' ,4));
   s145.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s145.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s145.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s145.addTransition(ScannerTransEntry(5 ,'R' ,6));
   s145.addTransition(ScannerTransEntry(5 ,'r' ,6));
   _scannerList.Insert(s145);

   Scanner s146(SUM);
   s146.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s146.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s146.addState(ScannerStateEntry(2 ,START));
   s146.addState(ScannerStateEntry(3 ,FINAL));
   s146.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s146.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s146.addTransition(ScannerTransEntry(1 ,'M' ,3));
   s146.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s146.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s146.addTransition(ScannerTransEntry(2 ,'s' ,0));
   _scannerList.Insert(s146);

   Scanner s147(SYNC);
   s147.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s147.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s147.addState(ScannerStateEntry(2 ,START));
   s147.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s147.addState(ScannerStateEntry(4 ,FINAL));
   s147.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s147.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s147.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s147.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s147.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s147.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s147.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s147.addTransition(ScannerTransEntry(3 ,'c' ,4));
   _scannerList.Insert(s147);

   Scanner s148(SYSDATE);
   s148.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s148.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s148.addState(ScannerStateEntry(2 ,START));
   s148.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s148.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s148.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s148.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s148.addState(ScannerStateEntry(7 ,FINAL));
   s148.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s148.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s148.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s148.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s148.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s148.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s148.addTransition(ScannerTransEntry(3 ,'D' ,4));
   s148.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s148.addTransition(ScannerTransEntry(4 ,'A' ,5));
   s148.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s148.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s148.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s148.addTransition(ScannerTransEntry(6 ,'E' ,7));
   s148.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s148);

   Scanner s149(SYSTEMSPACE);
   s149.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(2 ,START));
   s149.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(11 ,FINAL));
   s149.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s149.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s149.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s149.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s149.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s149.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s149.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s149.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s149.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s149.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s149.addTransition(ScannerTransEntry(5 ,'M' ,6));
   s149.addTransition(ScannerTransEntry(5 ,'m' ,6));
   s149.addTransition(ScannerTransEntry(6 ,'S' ,7));
   s149.addTransition(ScannerTransEntry(6 ,'s' ,7));
   s149.addTransition(ScannerTransEntry(7 ,'P' ,8));
   s149.addTransition(ScannerTransEntry(7 ,'p' ,8));
   s149.addTransition(ScannerTransEntry(8 ,'A' ,9));
   s149.addTransition(ScannerTransEntry(8 ,'a' ,9));
   s149.addTransition(ScannerTransEntry(9 ,'C' ,10));
   s149.addTransition(ScannerTransEntry(9 ,'c' ,10));
   s149.addTransition(ScannerTransEntry(10 ,'E' ,11));
   s149.addTransition(ScannerTransEntry(10 ,'e' ,11));
   _scannerList.Insert(s149);

   Scanner s150(SYSOBJ);
   s150.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s150.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s150.addState(ScannerStateEntry(2 ,START));
   s150.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s150.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s150.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s150.addState(ScannerStateEntry(6 ,FINAL));
   s150.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s150.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s150.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s150.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s150.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s150.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s150.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s150.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s150.addTransition(ScannerTransEntry(4 ,'B' ,5));
   s150.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s150.addTransition(ScannerTransEntry(5 ,'J' ,6));
   s150.addTransition(ScannerTransEntry(5 ,'j' ,6));
   _scannerList.Insert(s150);

   Scanner s151(TABLEINFO);
   s151.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s151.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s151.addState(ScannerStateEntry(2 ,START));
   s151.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s151.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s151.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s151.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s151.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s151.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s151.addState(ScannerStateEntry(9 ,FINAL));
   s151.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s151.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s151.addTransition(ScannerTransEntry(1 ,'B' ,3));
   s151.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s151.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s151.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s151.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s151.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s151.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s151.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s151.addTransition(ScannerTransEntry(5 ,'I' ,6));
   s151.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s151.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s151.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s151.addTransition(ScannerTransEntry(7 ,'F' ,8));
   s151.addTransition(ScannerTransEntry(7 ,'f' ,8));
   s151.addTransition(ScannerTransEntry(8 ,'O' ,9));
   s151.addTransition(ScannerTransEntry(8 ,'o' ,9));
   _scannerList.Insert(s151);

   Scanner s152(TABLESIZE);
   s152.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s152.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s152.addState(ScannerStateEntry(2 ,START));
   s152.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s152.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s152.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s152.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s152.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s152.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s152.addState(ScannerStateEntry(9 ,FINAL));
   s152.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s152.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s152.addTransition(ScannerTransEntry(1 ,'B' ,3));
   s152.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s152.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s152.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s152.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s152.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s152.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s152.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s152.addTransition(ScannerTransEntry(5 ,'S' ,6));
   s152.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s152.addTransition(ScannerTransEntry(6 ,'I' ,7));
   s152.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s152.addTransition(ScannerTransEntry(7 ,'Z' ,8));
   s152.addTransition(ScannerTransEntry(7 ,'z' ,8));
   s152.addTransition(ScannerTransEntry(8 ,'E' ,9));
   s152.addTransition(ScannerTransEntry(8 ,'e' ,9));
   _scannerList.Insert(s152);

   Scanner s153(TABLE);
   s153.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s153.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s153.addState(ScannerStateEntry(2 ,START));
   s153.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s153.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s153.addState(ScannerStateEntry(5 ,FINAL));
   s153.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s153.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s153.addTransition(ScannerTransEntry(1 ,'B' ,3));
   s153.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s153.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s153.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s153.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s153.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s153.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s153.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s153);

   Scanner s154(TABLESET);
   s154.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s154.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s154.addState(ScannerStateEntry(2 ,START));
   s154.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s154.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s154.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s154.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s154.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s154.addState(ScannerStateEntry(8 ,FINAL));
   s154.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s154.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s154.addTransition(ScannerTransEntry(1 ,'B' ,3));
   s154.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s154.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s154.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s154.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s154.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s154.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s154.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s154.addTransition(ScannerTransEntry(5 ,'S' ,6));
   s154.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s154.addTransition(ScannerTransEntry(6 ,'E' ,7));
   s154.addTransition(ScannerTransEntry(6 ,'e' ,7));
   s154.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s154.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s154);

   Scanner s155(THEN);
   s155.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s155.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s155.addState(ScannerStateEntry(2 ,START));
   s155.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s155.addState(ScannerStateEntry(4 ,FINAL));
   s155.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s155.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s155.addTransition(ScannerTransEntry(1 ,'E' ,3));
   s155.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s155.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s155.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s155.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s155.addTransition(ScannerTransEntry(3 ,'n' ,4));
   _scannerList.Insert(s155);

   Scanner s156(THROW);
   s156.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s156.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s156.addState(ScannerStateEntry(2 ,START));
   s156.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s156.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s156.addState(ScannerStateEntry(5 ,FINAL));
   s156.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s156.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s156.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s156.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s156.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s156.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s156.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s156.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s156.addTransition(ScannerTransEntry(4 ,'W' ,5));
   s156.addTransition(ScannerTransEntry(4 ,'w' ,5));
   _scannerList.Insert(s156);

   Scanner s157(TINYINT);
   s157.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s157.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s157.addState(ScannerStateEntry(2 ,START));
   s157.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s157.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s157.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s157.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s157.addState(ScannerStateEntry(7 ,FINAL));
   s157.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s157.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s157.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s157.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s157.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s157.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s157.addTransition(ScannerTransEntry(3 ,'Y' ,4));
   s157.addTransition(ScannerTransEntry(3 ,'y' ,4));
   s157.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s157.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s157.addTransition(ScannerTransEntry(5 ,'N' ,6));
   s157.addTransition(ScannerTransEntry(5 ,'n' ,6));
   s157.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s157.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s157);

   Scanner s158(TMPOBJ);
   s158.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s158.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s158.addState(ScannerStateEntry(2 ,START));
   s158.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s158.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s158.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s158.addState(ScannerStateEntry(6 ,FINAL));
   s158.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s158.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s158.addTransition(ScannerTransEntry(1 ,'P' ,3));
   s158.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s158.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s158.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s158.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s158.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s158.addTransition(ScannerTransEntry(4 ,'B' ,5));
   s158.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s158.addTransition(ScannerTransEntry(5 ,'J' ,6));
   s158.addTransition(ScannerTransEntry(5 ,'j' ,6));
   _scannerList.Insert(s158);

   Scanner s159(TRANSACTION);
   s159.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(2 ,START));
   s159.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(11 ,FINAL));
   s159.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s159.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s159.addTransition(ScannerTransEntry(1 ,'A' ,3));
   s159.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s159.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s159.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s159.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s159.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s159.addTransition(ScannerTransEntry(4 ,'S' ,5));
   s159.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s159.addTransition(ScannerTransEntry(5 ,'A' ,6));
   s159.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s159.addTransition(ScannerTransEntry(6 ,'C' ,7));
   s159.addTransition(ScannerTransEntry(6 ,'c' ,7));
   s159.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s159.addTransition(ScannerTransEntry(7 ,'t' ,8));
   s159.addTransition(ScannerTransEntry(8 ,'I' ,9));
   s159.addTransition(ScannerTransEntry(8 ,'i' ,9));
   s159.addTransition(ScannerTransEntry(9 ,'O' ,10));
   s159.addTransition(ScannerTransEntry(9 ,'o' ,10));
   s159.addTransition(ScannerTransEntry(10 ,'N' ,11));
   s159.addTransition(ScannerTransEntry(10 ,'n' ,11));
   _scannerList.Insert(s159);

   Scanner s160(TRIGGER);
   s160.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s160.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s160.addState(ScannerStateEntry(2 ,START));
   s160.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s160.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s160.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s160.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s160.addState(ScannerStateEntry(7 ,FINAL));
   s160.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s160.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s160.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s160.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s160.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s160.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s160.addTransition(ScannerTransEntry(3 ,'G' ,4));
   s160.addTransition(ScannerTransEntry(3 ,'g' ,4));
   s160.addTransition(ScannerTransEntry(4 ,'G' ,5));
   s160.addTransition(ScannerTransEntry(4 ,'g' ,5));
   s160.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s160.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s160.addTransition(ScannerTransEntry(6 ,'R' ,7));
   s160.addTransition(ScannerTransEntry(6 ,'r' ,7));
   _scannerList.Insert(s160);

   Scanner s161(TUPLEINFO);
   s161.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s161.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s161.addState(ScannerStateEntry(2 ,START));
   s161.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s161.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s161.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s161.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s161.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s161.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s161.addState(ScannerStateEntry(9 ,FINAL));
   s161.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s161.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s161.addTransition(ScannerTransEntry(1 ,'P' ,3));
   s161.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s161.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s161.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s161.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s161.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s161.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s161.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s161.addTransition(ScannerTransEntry(5 ,'I' ,6));
   s161.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s161.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s161.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s161.addTransition(ScannerTransEntry(7 ,'F' ,8));
   s161.addTransition(ScannerTransEntry(7 ,'f' ,8));
   s161.addTransition(ScannerTransEntry(8 ,'O' ,9));
   s161.addTransition(ScannerTransEntry(8 ,'o' ,9));
   _scannerList.Insert(s161);

   Scanner s162(STR2INT);
   s162.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s162.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s162.addState(ScannerStateEntry(2 ,START));
   s162.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s162.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s162.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s162.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s162.addState(ScannerStateEntry(7 ,FINAL));
   s162.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s162.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s162.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s162.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s162.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s162.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s162.addTransition(ScannerTransEntry(3 ,'2' ,4));
   s162.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s162.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s162.addTransition(ScannerTransEntry(5 ,'N' ,6));
   s162.addTransition(ScannerTransEntry(5 ,'n' ,6));
   s162.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s162.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s162);

   Scanner s163(STR2LONG);
   s163.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s163.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s163.addState(ScannerStateEntry(2 ,START));
   s163.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s163.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s163.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s163.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s163.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s163.addState(ScannerStateEntry(8 ,FINAL));
   s163.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s163.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s163.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s163.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s163.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s163.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s163.addTransition(ScannerTransEntry(3 ,'2' ,4));
   s163.addTransition(ScannerTransEntry(4 ,'L' ,5));
   s163.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s163.addTransition(ScannerTransEntry(5 ,'O' ,6));
   s163.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s163.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s163.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s163.addTransition(ScannerTransEntry(7 ,'G' ,8));
   s163.addTransition(ScannerTransEntry(7 ,'g' ,8));
   _scannerList.Insert(s163);

   Scanner s164(TO);
   s164.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s164.addState(ScannerStateEntry(1 ,FINAL));
   s164.addState(ScannerStateEntry(2 ,START));
   s164.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s164.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s164.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s164.addTransition(ScannerTransEntry(2 ,'t' ,0));
   _scannerList.Insert(s164);

   Scanner s165(TRIM);
   s165.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s165.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s165.addState(ScannerStateEntry(2 ,START));
   s165.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s165.addState(ScannerStateEntry(4 ,FINAL));
   s165.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s165.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s165.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s165.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s165.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s165.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s165.addTransition(ScannerTransEntry(3 ,'M' ,4));
   s165.addTransition(ScannerTransEntry(3 ,'m' ,4));
   _scannerList.Insert(s165);

   Scanner s166(TRUEVAL);
   s166.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s166.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s166.addState(ScannerStateEntry(2 ,START));
   s166.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s166.addState(ScannerStateEntry(4 ,FINAL));
   s166.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s166.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s166.addTransition(ScannerTransEntry(1 ,'U' ,3));
   s166.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s166.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s166.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s166.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s166.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s166);

   Scanner s167(TRUNC);
   s167.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s167.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s167.addState(ScannerStateEntry(2 ,START));
   s167.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s167.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s167.addState(ScannerStateEntry(5 ,FINAL));
   s167.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s167.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s167.addTransition(ScannerTransEntry(1 ,'U' ,3));
   s167.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s167.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s167.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s167.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s167.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s167.addTransition(ScannerTransEntry(4 ,'C' ,5));
   s167.addTransition(ScannerTransEntry(4 ,'c' ,5));
   _scannerList.Insert(s167);

   Scanner s168(TRUNCATE);
   s168.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s168.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s168.addState(ScannerStateEntry(2 ,START));
   s168.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s168.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s168.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s168.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s168.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s168.addState(ScannerStateEntry(8 ,FINAL));
   s168.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s168.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s168.addTransition(ScannerTransEntry(1 ,'U' ,3));
   s168.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s168.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s168.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s168.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s168.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s168.addTransition(ScannerTransEntry(4 ,'C' ,5));
   s168.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s168.addTransition(ScannerTransEntry(5 ,'A' ,6));
   s168.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s168.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s168.addTransition(ScannerTransEntry(6 ,'t' ,7));
   s168.addTransition(ScannerTransEntry(7 ,'E' ,8));
   s168.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s168);

   Scanner s169(UNION);
   s169.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s169.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s169.addState(ScannerStateEntry(2 ,START));
   s169.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s169.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s169.addState(ScannerStateEntry(5 ,FINAL));
   s169.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s169.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s169.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s169.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s169.addTransition(ScannerTransEntry(2 ,'U' ,0));
   s169.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s169.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s169.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s169.addTransition(ScannerTransEntry(4 ,'N' ,5));
   s169.addTransition(ScannerTransEntry(4 ,'n' ,5));
   _scannerList.Insert(s169);

   Scanner s170(UNIQUE);
   s170.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s170.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s170.addState(ScannerStateEntry(2 ,START));
   s170.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s170.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s170.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s170.addState(ScannerStateEntry(6 ,FINAL));
   s170.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s170.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s170.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s170.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s170.addTransition(ScannerTransEntry(2 ,'U' ,0));
   s170.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s170.addTransition(ScannerTransEntry(3 ,'Q' ,4));
   s170.addTransition(ScannerTransEntry(3 ,'q' ,4));
   s170.addTransition(ScannerTransEntry(4 ,'U' ,5));
   s170.addTransition(ScannerTransEntry(4 ,'u' ,5));
   s170.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s170.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s170);

   Scanner s171(UPDATE);
   s171.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s171.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s171.addState(ScannerStateEntry(2 ,START));
   s171.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s171.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s171.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s171.addState(ScannerStateEntry(6 ,FINAL));
   s171.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s171.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s171.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s171.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s171.addTransition(ScannerTransEntry(2 ,'U' ,0));
   s171.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s171.addTransition(ScannerTransEntry(3 ,'A' ,4));
   s171.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s171.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s171.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s171.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s171.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s171);

   Scanner s172(UPTIME);
   s172.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s172.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s172.addState(ScannerStateEntry(2 ,START));
   s172.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s172.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s172.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s172.addState(ScannerStateEntry(6 ,FINAL));
   s172.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s172.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s172.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s172.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s172.addTransition(ScannerTransEntry(2 ,'U' ,0));
   s172.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s172.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s172.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s172.addTransition(ScannerTransEntry(4 ,'M' ,5));
   s172.addTransition(ScannerTransEntry(4 ,'m' ,5));
   s172.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s172.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s172);

   Scanner s173(UPPER);
   s173.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s173.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s173.addState(ScannerStateEntry(2 ,START));
   s173.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s173.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s173.addState(ScannerStateEntry(5 ,FINAL));
   s173.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s173.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s173.addTransition(ScannerTransEntry(1 ,'P' ,3));
   s173.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s173.addTransition(ScannerTransEntry(2 ,'U' ,0));
   s173.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s173.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s173.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s173.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s173.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s173);

   Scanner s174(VAR);
   s174.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s174.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s174.addState(ScannerStateEntry(2 ,START));
   s174.addState(ScannerStateEntry(3 ,FINAL));
   s174.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s174.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s174.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s174.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s174.addTransition(ScannerTransEntry(2 ,'V' ,0));
   s174.addTransition(ScannerTransEntry(2 ,'v' ,0));
   _scannerList.Insert(s174);

   Scanner s175(VALUES);
   s175.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s175.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s175.addState(ScannerStateEntry(2 ,START));
   s175.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s175.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s175.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s175.addState(ScannerStateEntry(6 ,FINAL));
   s175.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s175.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s175.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s175.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s175.addTransition(ScannerTransEntry(2 ,'V' ,0));
   s175.addTransition(ScannerTransEntry(2 ,'v' ,0));
   s175.addTransition(ScannerTransEntry(3 ,'U' ,4));
   s175.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s175.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s175.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s175.addTransition(ScannerTransEntry(5 ,'S' ,6));
   s175.addTransition(ScannerTransEntry(5 ,'s' ,6));
   _scannerList.Insert(s175);

   Scanner s176(VIEW);
   s176.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s176.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s176.addState(ScannerStateEntry(2 ,START));
   s176.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s176.addState(ScannerStateEntry(4 ,FINAL));
   s176.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s176.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s176.addTransition(ScannerTransEntry(1 ,'E' ,3));
   s176.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s176.addTransition(ScannerTransEntry(2 ,'V' ,0));
   s176.addTransition(ScannerTransEntry(2 ,'v' ,0));
   s176.addTransition(ScannerTransEntry(3 ,'W' ,4));
   s176.addTransition(ScannerTransEntry(3 ,'w' ,4));
   _scannerList.Insert(s176);

   Scanner s177(WHEN);
   s177.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s177.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s177.addState(ScannerStateEntry(2 ,START));
   s177.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s177.addState(ScannerStateEntry(4 ,FINAL));
   s177.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s177.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s177.addTransition(ScannerTransEntry(1 ,'E' ,3));
   s177.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s177.addTransition(ScannerTransEntry(2 ,'W' ,0));
   s177.addTransition(ScannerTransEntry(2 ,'w' ,0));
   s177.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s177.addTransition(ScannerTransEntry(3 ,'n' ,4));
   _scannerList.Insert(s177);

   Scanner s178(WHERE);
   s178.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s178.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s178.addState(ScannerStateEntry(2 ,START));
   s178.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s178.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s178.addState(ScannerStateEntry(5 ,FINAL));
   s178.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'E' ,3));
   s178.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s178.addTransition(ScannerTransEntry(2 ,'W' ,0));
   s178.addTransition(ScannerTransEntry(2 ,'w' ,0));
   s178.addTransition(ScannerTransEntry(3 ,'R' ,4));
   s178.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s178.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s178.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s178);

   Scanner s179(WHILE);
   s179.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s179.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s179.addState(ScannerStateEntry(2 ,START));
   s179.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s179.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s179.addState(ScannerStateEntry(5 ,FINAL));
   s179.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s179.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s179.addTransition(ScannerTransEntry(2 ,'W' ,0));
   s179.addTransition(ScannerTransEntry(2 ,'w' ,0));
   s179.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s179.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s179.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s179.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s179);

   Scanner s180(CONCAT);
   s180.addState(ScannerStateEntry(0 ,START));
   s180.addState(ScannerStateEntry(1 ,FINAL));
   s180.addTransition(ScannerTransEntry(0 ,'|' ,1));
   _scannerList.Insert(s180);

   Scanner s181(EQU);
   s181.addState(ScannerStateEntry(0 ,START));
   s181.addState(ScannerStateEntry(1 ,FINAL));
   s181.addTransition(ScannerTransEntry(0 ,'=' ,1));
   _scannerList.Insert(s181);

   Scanner s182(KSEP);
   s182.addState(ScannerStateEntry(0 ,START));
   s182.addState(ScannerStateEntry(1 ,FINAL));
   s182.addTransition(ScannerTransEntry(0 ,',' ,1));
   _scannerList.Insert(s182);

   Scanner s183(LB);
   s183.addState(ScannerStateEntry(0 ,START));
   s183.addState(ScannerStateEntry(1 ,FINAL));
   s183.addTransition(ScannerTransEntry(0 ,'(' ,1));
   _scannerList.Insert(s183);

   Scanner s184(LT);
   s184.addState(ScannerStateEntry(0 ,START));
   s184.addState(ScannerStateEntry(1 ,FINAL));
   s184.addTransition(ScannerTransEntry(0 ,'<' ,1));
   _scannerList.Insert(s184);

   Scanner s185(MT);
   s185.addState(ScannerStateEntry(0 ,START));
   s185.addState(ScannerStateEntry(1 ,FINAL));
   s185.addTransition(ScannerTransEntry(0 ,'>' ,1));
   _scannerList.Insert(s185);

   Scanner s186(NEGATION);
   s186.addState(ScannerStateEntry(0 ,START));
   s186.addState(ScannerStateEntry(1 ,FINAL));
   s186.addTransition(ScannerTransEntry(0 ,'!' ,1));
   _scannerList.Insert(s186);

   Scanner s187(RB);
   s187.addState(ScannerStateEntry(0 ,START));
   s187.addState(ScannerStateEntry(1 ,FINAL));
   s187.addTransition(ScannerTransEntry(0 ,')' ,1));
   _scannerList.Insert(s187);

   Scanner s188(LAB);
   s188.addState(ScannerStateEntry(0 ,START));
   s188.addState(ScannerStateEntry(1 ,FINAL));
   s188.addTransition(ScannerTransEntry(0 ,'[' ,1));
   _scannerList.Insert(s188);

   Scanner s189(RAB);
   s189.addState(ScannerStateEntry(0 ,START));
   s189.addState(ScannerStateEntry(1 ,FINAL));
   s189.addTransition(ScannerTransEntry(0 ,']' ,1));
   _scannerList.Insert(s189);

   Scanner s190(SEMICOLON);
   s190.addState(ScannerStateEntry(0 ,START));
   s190.addState(ScannerStateEntry(1 ,FINAL));
   s190.addTransition(ScannerTransEntry(0 ,';' ,1));
   _scannerList.Insert(s190);

   Scanner s191(STAR);
   s191.addState(ScannerStateEntry(0 ,START));
   s191.addState(ScannerStateEntry(1 ,FINAL));
   s191.addTransition(ScannerTransEntry(0 ,'*' ,1));
   _scannerList.Insert(s191);

   Scanner s192(DIVISION);
   s192.addState(ScannerStateEntry(0 ,START));
   s192.addState(ScannerStateEntry(1 ,FINAL));
   s192.addTransition(ScannerTransEntry(0 ,'/' ,1));
   _scannerList.Insert(s192);

   Scanner s193(MINUS);
   s193.addState(ScannerStateEntry(0 ,START));
   s193.addState(ScannerStateEntry(1 ,FINAL));
   s193.addTransition(ScannerTransEntry(0 ,'-' ,1));
   _scannerList.Insert(s193);

   Scanner s194(PLUS);
   s194.addState(ScannerStateEntry(0 ,START));
   s194.addState(ScannerStateEntry(1 ,FINAL));
   s194.addTransition(ScannerTransEntry(0 ,'+' ,1));
   _scannerList.Insert(s194);

   Scanner s195(INTVAL);
   s195.addState(ScannerStateEntry(0 ,START));
   s195.addState(ScannerStateEntry(1 ,FINAL));
   s195.addState(ScannerStateEntry(2 ,FINAL));
   s195.addTransition(ScannerTransEntry(0 ,'1' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'2' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'3' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'4' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'5' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'6' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'7' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'8' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'9' ,1));
   s195.addTransition(ScannerTransEntry(0 ,'0' ,2));
   s195.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s195.addTransition(ScannerTransEntry(1 ,'9' ,1));
   _scannerList.Insert(s195);

   Scanner s196(FLOATVAL);
   s196.addState(ScannerStateEntry(0 ,START));
   s196.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s196.addState(ScannerStateEntry(2 ,INTERMEDIATE));
   s196.addState(ScannerStateEntry(3 ,FINAL));
   s196.addTransition(ScannerTransEntry(0 ,'1' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'2' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'3' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'4' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'5' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'6' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'7' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'8' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'9' ,1));
   s196.addTransition(ScannerTransEntry(0 ,'0' ,2));
   s196.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s196.addTransition(ScannerTransEntry(1 ,'.' ,3));
   s196.addTransition(ScannerTransEntry(2 ,'.' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'0' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'1' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'2' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'3' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'4' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'5' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'6' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'7' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'8' ,3));
   s196.addTransition(ScannerTransEntry(3 ,'9' ,3));
   _scannerList.Insert(s196);

   Scanner s197(IDENTIFIER);
   s197.addState(ScannerStateEntry(0 ,START));
   s197.addState(ScannerStateEntry(1 ,FINAL));
   s197.addTransition(ScannerTransEntry(0 ,'$' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s197.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s197.addTransition(ScannerTransEntry(1 ,'z' ,1));
   _scannerList.Insert(s197);

   Scanner s198(VARREF);
   s198.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s198.addState(ScannerStateEntry(1 ,FINAL));
   s198.addState(ScannerStateEntry(2 ,START));
   s198.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s198.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s198.addTransition(ScannerTransEntry(1 ,'z' ,1));
   s198.addTransition(ScannerTransEntry(2 ,':' ,0));
   _scannerList.Insert(s198);

   Scanner s199(QUALIFIEDOBJ);
   s199.addState(ScannerStateEntry(0 ,START));
   s199.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s199.addState(ScannerStateEntry(2 ,INTERMEDIATE));
   s199.addState(ScannerStateEntry(3 ,FINAL));
   s199.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s199.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'z' ,1));
   s199.addTransition(ScannerTransEntry(1 ,'.' ,2));
   s199.addTransition(ScannerTransEntry(2 ,'$' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'A' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'B' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'C' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'D' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'E' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'F' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'G' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'H' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'I' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'J' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'K' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'L' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'M' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'N' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'O' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'P' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'Q' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'R' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'S' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'T' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'U' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'V' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'W' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'X' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'Y' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'Z' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'a' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'b' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'c' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'d' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'e' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'f' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'g' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'h' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'i' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'j' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'k' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'l' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'m' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'n' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'o' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'p' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'q' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'r' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'s' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'t' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'u' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'v' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'w' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'x' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'y' ,3));
   s199.addTransition(ScannerTransEntry(2 ,'z' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'0' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'1' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'2' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'3' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'4' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'5' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'6' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'7' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'8' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'9' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'A' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'B' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'C' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'D' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'E' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'F' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'G' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'H' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'I' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'J' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'K' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'L' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'M' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'N' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'O' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'P' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'Q' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'R' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'S' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'T' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'U' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'V' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'W' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'X' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'Y' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'Z' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'_' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'a' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'b' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'c' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'d' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'e' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'f' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'g' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'h' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'i' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'j' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'k' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'l' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'m' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'n' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'o' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'p' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'q' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'r' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'s' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'t' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'u' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'v' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'w' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'x' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'y' ,3));
   s199.addTransition(ScannerTransEntry(3 ,'z' ,3));
   _scannerList.Insert(s199);

   Scanner s200(QUALIFIEDPRE);
   s200.addState(ScannerStateEntry(0 ,START));
   s200.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s200.addState(ScannerStateEntry(2 ,FINAL));
   s200.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s200.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'z' ,1));
   s200.addTransition(ScannerTransEntry(1 ,'.' ,2));
   _scannerList.Insert(s200);

   Scanner s201(QUALIFIEDTS);
   s201.addState(ScannerStateEntry(0 ,START));
   s201.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s201.addState(ScannerStateEntry(2 ,INTERMEDIATE));
   s201.addState(ScannerStateEntry(3 ,FINAL));
   s201.addTransition(ScannerTransEntry(0 ,'$' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s201.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'z' ,1));
   s201.addTransition(ScannerTransEntry(1 ,'@' ,2));
   s201.addTransition(ScannerTransEntry(2 ,'A' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'B' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'C' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'D' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'E' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'F' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'G' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'H' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'I' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'J' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'K' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'L' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'M' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'N' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'O' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'P' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'Q' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'R' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'S' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'T' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'U' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'V' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'W' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'X' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'Y' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'Z' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'a' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'b' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'c' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'d' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'e' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'f' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'g' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'h' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'i' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'j' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'k' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'l' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'m' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'n' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'o' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'p' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'q' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'r' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'s' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'t' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'u' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'v' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'w' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'x' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'y' ,3));
   s201.addTransition(ScannerTransEntry(2 ,'z' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'0' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'1' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'2' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'3' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'4' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'5' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'6' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'7' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'8' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'9' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'A' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'B' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'C' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'D' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'E' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'F' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'G' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'H' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'I' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'J' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'K' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'L' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'M' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'N' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'O' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'P' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'Q' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'R' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'S' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'T' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'U' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'V' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'W' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'X' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'Y' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'Z' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'_' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'a' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'b' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'c' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'d' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'e' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'f' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'g' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'h' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'i' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'j' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'k' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'l' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'m' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'n' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'o' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'p' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'q' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'r' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'s' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'t' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'u' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'v' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'w' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'x' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'y' ,3));
   s201.addTransition(ScannerTransEntry(3 ,'z' ,3));
   _scannerList.Insert(s201);

}
void Cego::loadParser0()
{
   _actionMap[949][SEMICOLON] = ActionEntry(REDUCE, 88);
   _actionMap[948][RB] = ActionEntry(SHIFT, 949);
   _actionMap[947][IDENTIFIER] = ActionEntry(SHIFT, 824);
   _jumpMap[947][SimpleAttr] = 823;
   _jumpMap[947][SimpleAttrList] = 948;
   _actionMap[945][LB] = ActionEntry(SHIFT, 947);
   _actionMap[946][ROWLIMIT] = ActionEntry(REDUCE, 208);
   _actionMap[946][UNION] = ActionEntry(REDUCE, 208);
   _actionMap[946][ENDTOKEN] = ActionEntry(REDUCE, 208);
   _actionMap[946][RB] = ActionEntry(REDUCE, 208);
   _actionMap[946][SEMICOLON] = ActionEntry(REDUCE, 208);
   _actionMap[946][KSEP] = ActionEntry(REDUCE, 208);
   _actionMap[942][IDENTIFIER] = ActionEntry(SHIFT, 945);
   _actionMap[943][SEMICOLON] = ActionEntry(REDUCE, 220);
   _actionMap[943][RB] = ActionEntry(REDUCE, 220);
   _actionMap[944][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[944][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[944][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[944][ASC] = ActionEntry(SHIFT, 936);
   _actionMap[944][ROWLIMIT] = ActionEntry(REDUCE, 213);
   _actionMap[944][DESC] = ActionEntry(SHIFT, 937);
   _actionMap[944][UNION] = ActionEntry(REDUCE, 213);
   _actionMap[944][ENDTOKEN] = ActionEntry(REDUCE, 213);
   _actionMap[944][RB] = ActionEntry(REDUCE, 213);
   _actionMap[944][SEMICOLON] = ActionEntry(REDUCE, 213);
   _actionMap[944][KSEP] = ActionEntry(REDUCE, 213);
   _jumpMap[944][DefaultOrderOpt] = 935;
   _jumpMap[944][OrderingOpt] = 946;
   _actionMap[928][REFERENCES] = ActionEntry(SHIFT, 942);
   _actionMap[929][ELSE] = ActionEntry(REDUCE, 278);
   _actionMap[929][ELSIF] = ActionEntry(REDUCE, 278);
   _actionMap[929][EXCEPTION] = ActionEntry(REDUCE, 278);
   _actionMap[929][END_TOKEN] = ActionEntry(REDUCE, 278);
   _actionMap[929][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[929][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[929][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[929][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[929][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[929][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[929][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[929][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[929][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[929][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[929][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[929][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[929][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[929][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[929][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[929][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[929][LEFT] = ActionEntry(SHIFT, 148);
}
void Cego::loadParser1()
{
   _actionMap[929][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[929][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[929][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[929][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[929][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[929][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[929][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[929][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[929][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[929][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[929][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[929][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[929][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[929][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[929][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[929][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[929][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[929][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[929][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[929][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[929][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[929][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[929][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[929][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[929][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[929][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[929][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[929][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[929][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[929][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[929][LB] = ActionEntry(SHIFT, 178);
   _actionMap[929][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[929][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[929][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[929][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[929][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[929][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[929][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[929][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[929][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[929][VARREF] = ActionEntry(SHIFT, 422);
   _actionMap[929][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[929][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[929][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[929][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[929][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[929][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[929][IF] = ActionEntry(SHIFT, 416);
   _actionMap[929][BEGIN] = ActionEntry(SHIFT, 413);
   _actionMap[929][UNLOCK] = ActionEntry(SHIFT, 28);
}
void Cego::loadParser2()
{
   _actionMap[929][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[929][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[929][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[929][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[929][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[929][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[929][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[929][VAR] = ActionEntry(SHIFT, 420);
   _actionMap[929][CURSOR] = ActionEntry(SHIFT, 415);
   _actionMap[929][CLOSE] = ActionEntry(SHIFT, 414);
   _actionMap[929][NOOP] = ActionEntry(SHIFT, 417);
   _actionMap[929][THROW] = ActionEntry(SHIFT, 419);
   _actionMap[929][RETURNTOKEN] = ActionEntry(SHIFT, 418);
   _actionMap[929][WHILE] = ActionEntry(SHIFT, 421);
   _jumpMap[929][ObjSpec] = 122;
   _jumpMap[929][Constant] = 121;
   _jumpMap[929][SignedFloat] = 120;
   _jumpMap[929][SignedInt] = 119;
   _jumpMap[929][Attribute] = 118;
   _jumpMap[929][Function] = 117;
   _jumpMap[929][Factor] = 116;
   _jumpMap[929][Term] = 115;
   _jumpMap[929][Expr] = 412;
   _jumpMap[929][ProcStatement] = 564;
   _jumpMap[929][ProcIfPart] = 410;
   _jumpMap[929][ProcBlockStart] = 409;
   _jumpMap[929][DeleteStatement] = 406;
   _jumpMap[929][UpdateStatement] = 405;
   _jumpMap[929][InsertStatement] = 404;
   _jumpMap[929][UnlockStatement] = 403;
   _jumpMap[929][LockStatement] = 402;
   _jumpMap[929][RollbackStatement] = 401;
   _jumpMap[929][CommitStatement] = 400;
   _jumpMap[929][StartStatement] = 399;
   _jumpMap[929][CasePrepare] = 113;
   _jumpMap[929][CaseClause] = 112;
   _actionMap[930][RB] = ActionEntry(REDUCE, 395);
   _actionMap[931][SEMICOLON] = ActionEntry(REDUCE, 66);
   _actionMap[932][SELECT] = ActionEntry(SHIFT, 34);
   _jumpMap[932][SelectStatement] = 943;
   _actionMap[933][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[933][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[933][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[933][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[933][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[933][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[933][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[933][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[933][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[933][SCANDATE] = ActionEntry(SHIFT, 167);
}
void Cego::loadParser3()
{
   _actionMap[933][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[933][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[933][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[933][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[933][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[933][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[933][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[933][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[933][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[933][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[933][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[933][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[933][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[933][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[933][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[933][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[933][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[933][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[933][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[933][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[933][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[933][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[933][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[933][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[933][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[933][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[933][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[933][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[933][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[933][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[933][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[933][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[933][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[933][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[933][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[933][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[933][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[933][LB] = ActionEntry(SHIFT, 178);
   _actionMap[933][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[933][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[933][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[933][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[933][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[933][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[933][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[933][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[933][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[933][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[933][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[933][COUNT] = ActionEntry(SHIFT, 137);
}
void Cego::loadParser4()
{
   _actionMap[933][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[933][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[933][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[933][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[933][ObjSpec] = 122;
   _jumpMap[933][Constant] = 121;
   _jumpMap[933][SignedFloat] = 120;
   _jumpMap[933][SignedInt] = 119;
   _jumpMap[933][Attribute] = 118;
   _jumpMap[933][Function] = 117;
   _jumpMap[933][Factor] = 116;
   _jumpMap[933][Term] = 115;
   _jumpMap[933][Expr] = 944;
   _jumpMap[933][CasePrepare] = 113;
   _jumpMap[933][CaseClause] = 112;
   _actionMap[934][ROWLIMIT] = ActionEntry(REDUCE, 209);
   _actionMap[934][UNION] = ActionEntry(REDUCE, 209);
   _actionMap[934][ENDTOKEN] = ActionEntry(REDUCE, 209);
   _actionMap[934][RB] = ActionEntry(REDUCE, 209);
   _actionMap[934][SEMICOLON] = ActionEntry(REDUCE, 209);
   _actionMap[934][KSEP] = ActionEntry(REDUCE, 209);
   _actionMap[935][ROWLIMIT] = ActionEntry(REDUCE, 210);
   _actionMap[935][UNION] = ActionEntry(REDUCE, 210);
   _actionMap[935][ENDTOKEN] = ActionEntry(REDUCE, 210);
   _actionMap[935][RB] = ActionEntry(REDUCE, 210);
   _actionMap[935][SEMICOLON] = ActionEntry(REDUCE, 210);
   _actionMap[935][KSEP] = ActionEntry(REDUCE, 210);
   _actionMap[936][ROWLIMIT] = ActionEntry(REDUCE, 212);
   _actionMap[936][UNION] = ActionEntry(REDUCE, 212);
   _actionMap[936][ENDTOKEN] = ActionEntry(REDUCE, 212);
   _actionMap[936][RB] = ActionEntry(REDUCE, 212);
   _actionMap[936][SEMICOLON] = ActionEntry(REDUCE, 212);
   _actionMap[936][KSEP] = ActionEntry(REDUCE, 212);
   _actionMap[937][ROWLIMIT] = ActionEntry(REDUCE, 211);
   _actionMap[937][UNION] = ActionEntry(REDUCE, 211);
   _actionMap[937][ENDTOKEN] = ActionEntry(REDUCE, 211);
   _actionMap[937][RB] = ActionEntry(REDUCE, 211);
   _actionMap[937][SEMICOLON] = ActionEntry(REDUCE, 211);
   _actionMap[937][KSEP] = ActionEntry(REDUCE, 211);
   _actionMap[938][OR] = ActionEntry(SHIFT, 444);
   _actionMap[938][ORDER] = ActionEntry(REDUCE, 202);
   _actionMap[938][ROWLIMIT] = ActionEntry(REDUCE, 202);
   _actionMap[938][UNION] = ActionEntry(REDUCE, 202);
   _actionMap[938][ENDTOKEN] = ActionEntry(REDUCE, 202);
   _actionMap[938][RB] = ActionEntry(REDUCE, 202);
   _actionMap[938][SEMICOLON] = ActionEntry(REDUCE, 202);
   _actionMap[939][KSEP] = ActionEntry(REDUCE, 200);
   _actionMap[939][HAVING] = ActionEntry(REDUCE, 200);
   _actionMap[939][ORDER] = ActionEntry(REDUCE, 200);
   _actionMap[939][ROWLIMIT] = ActionEntry(REDUCE, 200);
}
void Cego::loadParser5()
{
   _actionMap[939][UNION] = ActionEntry(REDUCE, 200);
   _actionMap[939][ENDTOKEN] = ActionEntry(REDUCE, 200);
   _actionMap[939][RB] = ActionEntry(REDUCE, 200);
   _actionMap[939][SEMICOLON] = ActionEntry(REDUCE, 200);
   _actionMap[940][OR] = ActionEntry(SHIFT, 444);
   _actionMap[940][LEFT] = ActionEntry(REDUCE, 184);
   _actionMap[940][RIGHT] = ActionEntry(REDUCE, 184);
   _actionMap[940][INNER] = ActionEntry(REDUCE, 184);
   _actionMap[940][JOIN] = ActionEntry(REDUCE, 184);
   _actionMap[940][RB] = ActionEntry(REDUCE, 184);
   _actionMap[940][ENDTOKEN] = ActionEntry(REDUCE, 184);
   _actionMap[940][UNION] = ActionEntry(REDUCE, 184);
   _actionMap[940][ROWLIMIT] = ActionEntry(REDUCE, 184);
   _actionMap[940][ORDER] = ActionEntry(REDUCE, 184);
   _actionMap[940][GROUP] = ActionEntry(REDUCE, 184);
   _actionMap[940][SEMICOLON] = ActionEntry(REDUCE, 184);
   _actionMap[940][RETURNTOKEN] = ActionEntry(REDUCE, 184);
   _actionMap[940][WHERE] = ActionEntry(REDUCE, 184);
   _actionMap[941][OR] = ActionEntry(SHIFT, 444);
   _actionMap[941][LEFT] = ActionEntry(REDUCE, 186);
   _actionMap[941][RIGHT] = ActionEntry(REDUCE, 186);
   _actionMap[941][INNER] = ActionEntry(REDUCE, 186);
   _actionMap[941][JOIN] = ActionEntry(REDUCE, 186);
   _actionMap[941][RB] = ActionEntry(REDUCE, 186);
   _actionMap[941][ENDTOKEN] = ActionEntry(REDUCE, 186);
   _actionMap[941][UNION] = ActionEntry(REDUCE, 186);
   _actionMap[941][ROWLIMIT] = ActionEntry(REDUCE, 186);
   _actionMap[941][ORDER] = ActionEntry(REDUCE, 186);
   _actionMap[941][GROUP] = ActionEntry(REDUCE, 186);
   _actionMap[941][SEMICOLON] = ActionEntry(REDUCE, 186);
   _actionMap[941][RETURNTOKEN] = ActionEntry(REDUCE, 186);
   _actionMap[941][WHERE] = ActionEntry(REDUCE, 186);
   _actionMap[901][RB] = ActionEntry(SHIFT, 928);
   _actionMap[902][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[902][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[902][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[902][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[902][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[902][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[902][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[902][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[902][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[902][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[902][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[902][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[902][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[902][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[902][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[902][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[902][LEFT] = ActionEntry(SHIFT, 148);
}
void Cego::loadParser6()
{
   _actionMap[902][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[902][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[902][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[902][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[902][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[902][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[902][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[902][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[902][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[902][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[902][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[902][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[902][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[902][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[902][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[902][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[902][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[902][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[902][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[902][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[902][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[902][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[902][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[902][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[902][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[902][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[902][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[902][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[902][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[902][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[902][LB] = ActionEntry(SHIFT, 178);
   _actionMap[902][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[902][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[902][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[902][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[902][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[902][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[902][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[902][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[902][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[902][VARREF] = ActionEntry(SHIFT, 422);
   _actionMap[902][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[902][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[902][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[902][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[902][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[902][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[902][IF] = ActionEntry(SHIFT, 416);
   _actionMap[902][BEGIN] = ActionEntry(SHIFT, 413);
   _actionMap[902][UNLOCK] = ActionEntry(SHIFT, 28);
}
void Cego::loadParser7()
{
   _actionMap[902][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[902][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[902][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[902][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[902][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[902][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[902][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[902][VAR] = ActionEntry(SHIFT, 420);
   _actionMap[902][CURSOR] = ActionEntry(SHIFT, 415);
   _actionMap[902][CLOSE] = ActionEntry(SHIFT, 414);
   _actionMap[902][NOOP] = ActionEntry(SHIFT, 417);
   _actionMap[902][THROW] = ActionEntry(SHIFT, 419);
   _actionMap[902][RETURNTOKEN] = ActionEntry(SHIFT, 418);
   _actionMap[902][WHILE] = ActionEntry(SHIFT, 421);
   _jumpMap[902][ObjSpec] = 122;
   _jumpMap[902][Constant] = 121;
   _jumpMap[902][SignedFloat] = 120;
   _jumpMap[902][SignedInt] = 119;
   _jumpMap[902][Attribute] = 118;
   _jumpMap[902][Function] = 117;
   _jumpMap[902][Factor] = 116;
   _jumpMap[902][Term] = 115;
   _jumpMap[902][Expr] = 412;
   _jumpMap[902][ProcStatement] = 411;
   _jumpMap[902][ProcIfPart] = 410;
   _jumpMap[902][ProcBlockStart] = 409;
   _jumpMap[902][ProcStatementList] = 929;
   _jumpMap[902][DeleteStatement] = 406;
   _jumpMap[902][UpdateStatement] = 405;
   _jumpMap[902][InsertStatement] = 404;
   _jumpMap[902][UnlockStatement] = 403;
   _jumpMap[902][LockStatement] = 402;
   _jumpMap[902][RollbackStatement] = 401;
   _jumpMap[902][CommitStatement] = 400;
   _jumpMap[902][StartStatement] = 399;
   _jumpMap[902][CasePrepare] = 113;
   _jumpMap[902][CaseClause] = 112;
   _actionMap[903][BEGIN] = ActionEntry(REDUCE, 386);
   _actionMap[903][EQU] = ActionEntry(REDUCE, 386);
   _actionMap[903][DEFAULT] = ActionEntry(REDUCE, 386);
   _actionMap[903][NULLTOKEN] = ActionEntry(REDUCE, 386);
   _actionMap[903][NOT] = ActionEntry(REDUCE, 386);
   _actionMap[903][KSEP] = ActionEntry(REDUCE, 386);
   _actionMap[903][SEMICOLON] = ActionEntry(REDUCE, 386);
   _actionMap[903][RB] = ActionEntry(REDUCE, 386);
   _actionMap[904][BEGIN] = ActionEntry(REDUCE, 391);
   _actionMap[904][EQU] = ActionEntry(REDUCE, 391);
   _actionMap[904][DEFAULT] = ActionEntry(REDUCE, 391);
   _actionMap[904][NULLTOKEN] = ActionEntry(REDUCE, 391);
   _actionMap[904][NOT] = ActionEntry(REDUCE, 391);
}
void Cego::loadParser8()
{
   _actionMap[904][KSEP] = ActionEntry(REDUCE, 391);
   _actionMap[904][SEMICOLON] = ActionEntry(REDUCE, 391);
   _actionMap[904][RB] = ActionEntry(REDUCE, 391);
   _actionMap[905][INTVAL] = ActionEntry(SHIFT, 930);
   _actionMap[906][BEGIN] = ActionEntry(REDUCE, 383);
   _actionMap[906][EQU] = ActionEntry(REDUCE, 383);
   _actionMap[906][DEFAULT] = ActionEntry(REDUCE, 383);
   _actionMap[906][NULLTOKEN] = ActionEntry(REDUCE, 383);
   _actionMap[906][NOT] = ActionEntry(REDUCE, 383);
   _actionMap[906][KSEP] = ActionEntry(REDUCE, 383);
   _actionMap[906][SEMICOLON] = ActionEntry(REDUCE, 383);
   _actionMap[906][RB] = ActionEntry(REDUCE, 383);
   _actionMap[907][CACHED] = ActionEntry(SHIFT, 911);
   _actionMap[907][SEMICOLON] = ActionEntry(REDUCE, 68);
   _jumpMap[907][CachedOpt] = 931;
   _actionMap[908][KSEP] = ActionEntry(REDUCE, 70);
   _actionMap[908][RB] = ActionEntry(REDUCE, 70);
   _actionMap[909][KSEP] = ActionEntry(REDUCE, 72);
   _actionMap[909][RB] = ActionEntry(REDUCE, 72);
   _actionMap[910][SEMICOLON] = ActionEntry(REDUCE, 65);
   _actionMap[911][SEMICOLON] = ActionEntry(REDUCE, 67);
   _actionMap[912][RB] = ActionEntry(REDUCE, 128);
   _actionMap[913][SEMICOLON] = ActionEntry(REDUCE, 122);
   _actionMap[913][KSEP] = ActionEntry(REDUCE, 122);
   _actionMap[913][RB] = ActionEntry(REDUCE, 122);
   _actionMap[914][SEMICOLON] = ActionEntry(REDUCE, 169);
   _actionMap[914][RB] = ActionEntry(REDUCE, 169);
   _actionMap[915][ALL] = ActionEntry(SHIFT, 932);
   _actionMap[916][UNION] = ActionEntry(REDUCE, 217);
   _actionMap[916][ENDTOKEN] = ActionEntry(REDUCE, 217);
   _actionMap[916][RB] = ActionEntry(REDUCE, 217);
   _actionMap[916][SEMICOLON] = ActionEntry(REDUCE, 217);
   _actionMap[917][KSEP] = ActionEntry(SHIFT, 933);
   _actionMap[917][ROWLIMIT] = ActionEntry(REDUCE, 205);
   _actionMap[917][UNION] = ActionEntry(REDUCE, 205);
   _actionMap[917][ENDTOKEN] = ActionEntry(REDUCE, 205);
   _actionMap[917][RB] = ActionEntry(REDUCE, 205);
   _actionMap[917][SEMICOLON] = ActionEntry(REDUCE, 205);
   _actionMap[918][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[918][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[918][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[918][ASC] = ActionEntry(SHIFT, 936);
   _actionMap[918][ROWLIMIT] = ActionEntry(REDUCE, 213);
   _actionMap[918][DESC] = ActionEntry(SHIFT, 937);
   _actionMap[918][UNION] = ActionEntry(REDUCE, 213);
   _actionMap[918][ENDTOKEN] = ActionEntry(REDUCE, 213);
   _actionMap[918][RB] = ActionEntry(REDUCE, 213);
   _actionMap[918][SEMICOLON] = ActionEntry(REDUCE, 213);
   _actionMap[918][KSEP] = ActionEntry(REDUCE, 213);
   _jumpMap[918][DefaultOrderOpt] = 935;
}
void Cego::loadParser9()
{
   _jumpMap[918][OrderingOpt] = 934;
   _actionMap[919][ORDER] = ActionEntry(REDUCE, 197);
   _actionMap[919][ROWLIMIT] = ActionEntry(REDUCE, 197);
   _actionMap[919][UNION] = ActionEntry(REDUCE, 197);
   _actionMap[919][ENDTOKEN] = ActionEntry(REDUCE, 197);
   _actionMap[919][RB] = ActionEntry(REDUCE, 197);
   _actionMap[919][SEMICOLON] = ActionEntry(REDUCE, 197);
   _actionMap[920][ORDER] = ActionEntry(REDUCE, 203);
   _actionMap[920][ROWLIMIT] = ActionEntry(REDUCE, 203);
   _actionMap[920][UNION] = ActionEntry(REDUCE, 203);
   _actionMap[920][ENDTOKEN] = ActionEntry(REDUCE, 203);
   _actionMap[920][RB] = ActionEntry(REDUCE, 203);
   _actionMap[920][SEMICOLON] = ActionEntry(REDUCE, 203);
   _actionMap[921][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[921][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[921][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[921][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[921][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[921][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[921][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[921][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[921][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[921][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[921][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[921][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[921][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[921][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[921][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[921][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[921][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[921][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[921][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[921][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[921][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[921][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[921][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[921][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[921][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[921][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[921][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[921][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[921][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[921][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[921][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[921][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[921][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[921][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[921][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[921][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[921][BLOBREF] = ActionEntry(SHIFT, 131);
}
void Cego::loadParser10()
{
   _actionMap[921][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[921][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[921][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[921][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[921][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[921][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[921][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[921][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[921][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[921][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[921][LB] = ActionEntry(SHIFT, 178);
   _actionMap[921][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[921][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[921][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[921][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[921][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[921][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[921][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[921][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[921][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[921][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[921][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[921][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[921][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[921][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[921][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[921][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[921][EXISTS] = ActionEntry(SHIFT, 277);
   _actionMap[921][NOT] = ActionEntry(SHIFT, 278);
   _jumpMap[921][ObjSpec] = 122;
   _jumpMap[921][Constant] = 121;
   _jumpMap[921][SignedFloat] = 120;
   _jumpMap[921][SignedInt] = 119;
   _jumpMap[921][Attribute] = 118;
   _jumpMap[921][Function] = 117;
   _jumpMap[921][Factor] = 116;
   _jumpMap[921][Term] = 115;
   _jumpMap[921][Expr] = 276;
   _jumpMap[921][Predicate] = 275;
   _jumpMap[921][Conjunction] = 274;
   _jumpMap[921][Condition] = 938;
   _jumpMap[921][CasePrepare] = 113;
   _jumpMap[921][CaseClause] = 112;
   _actionMap[922][IDENTIFIER] = ActionEntry(SHIFT, 893);
   _actionMap[922][QUALIFIEDOBJ] = ActionEntry(SHIFT, 894);
   _actionMap[922][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _jumpMap[922][Attribute] = 939;
   _actionMap[923][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[923][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[923][INTVAL] = ActionEntry(SHIFT, 180);
}
void Cego::loadParser11()
{
   _actionMap[923][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[923][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[923][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[923][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[923][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[923][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[923][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[923][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[923][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[923][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[923][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[923][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[923][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[923][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[923][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[923][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[923][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[923][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[923][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[923][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[923][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[923][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[923][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[923][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[923][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[923][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[923][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[923][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[923][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[923][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[923][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[923][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[923][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[923][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[923][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[923][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[923][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[923][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[923][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[923][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[923][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[923][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[923][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[923][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[923][LB] = ActionEntry(SHIFT, 178);
   _actionMap[923][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[923][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[923][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[923][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[923][FALSEVAL] = ActionEntry(SHIFT, 141);
}
void Cego::loadParser12()
{
   _actionMap[923][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[923][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[923][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[923][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[923][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[923][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[923][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[923][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[923][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[923][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[923][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[923][EXISTS] = ActionEntry(SHIFT, 277);
   _actionMap[923][NOT] = ActionEntry(SHIFT, 278);
   _jumpMap[923][ObjSpec] = 122;
   _jumpMap[923][Constant] = 121;
   _jumpMap[923][SignedFloat] = 120;
   _jumpMap[923][SignedInt] = 119;
   _jumpMap[923][Attribute] = 118;
   _jumpMap[923][Function] = 117;
   _jumpMap[923][Factor] = 116;
   _jumpMap[923][Term] = 115;
   _jumpMap[923][Expr] = 276;
   _jumpMap[923][Predicate] = 275;
   _jumpMap[923][Conjunction] = 274;
   _jumpMap[923][Condition] = 940;
   _jumpMap[923][CasePrepare] = 113;
   _jumpMap[923][CaseClause] = 112;
   _actionMap[924][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[924][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[924][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[924][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[924][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[924][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[924][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[924][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[924][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[924][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[924][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[924][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[924][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[924][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[924][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[924][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[924][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[924][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[924][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[924][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[924][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[924][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[924][TRUNC] = ActionEntry(SHIFT, 176);
}
void Cego::loadParser13()
{
   _actionMap[924][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[924][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[924][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[924][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[924][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[924][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[924][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[924][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[924][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[924][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[924][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[924][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[924][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[924][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[924][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[924][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[924][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[924][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[924][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[924][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[924][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[924][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[924][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[924][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[924][LB] = ActionEntry(SHIFT, 178);
   _actionMap[924][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[924][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[924][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[924][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[924][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[924][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[924][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[924][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[924][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[924][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[924][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[924][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[924][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[924][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[924][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[924][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[924][EXISTS] = ActionEntry(SHIFT, 277);
   _actionMap[924][NOT] = ActionEntry(SHIFT, 278);
   _jumpMap[924][ObjSpec] = 122;
   _jumpMap[924][Constant] = 121;
   _jumpMap[924][SignedFloat] = 120;
   _jumpMap[924][SignedInt] = 119;
   _jumpMap[924][Attribute] = 118;
   _jumpMap[924][Function] = 117;
   _jumpMap[924][Factor] = 116;
}
void Cego::loadParser14()
{
   _jumpMap[924][Term] = 115;
   _jumpMap[924][Expr] = 276;
   _jumpMap[924][Predicate] = 275;
   _jumpMap[924][Conjunction] = 274;
   _jumpMap[924][Condition] = 941;
   _jumpMap[924][CasePrepare] = 113;
   _jumpMap[924][CaseClause] = 112;
   _actionMap[925][SEMICOLON] = ActionEntry(REDUCE, 162);
   _actionMap[925][KSEP] = ActionEntry(REDUCE, 162);
   _actionMap[926][KSEP] = ActionEntry(SHIFT, 898);
   _actionMap[926][SEMICOLON] = ActionEntry(REDUCE, 158);
   _actionMap[927][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[927][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[927][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[927][SEMICOLON] = ActionEntry(REDUCE, 164);
   _actionMap[927][KSEP] = ActionEntry(REDUCE, 164);
   _actionMap[858][OR] = ActionEntry(SHIFT, 444);
   _actionMap[858][SEMICOLON] = ActionEntry(REDUCE, 89);
   _actionMap[859][IDENTIFIER] = ActionEntry(SHIFT, 824);
   _jumpMap[859][SimpleAttr] = 823;
   _jumpMap[859][SimpleAttrList] = 901;
   _actionMap[860][SEMICOLON] = ActionEntry(REDUCE, 231);
   _actionMap[860][KSEP] = ActionEntry(REDUCE, 231);
   _actionMap[861][LONG] = ActionEntry(SHIFT, 346);
   _actionMap[861][BIGINT] = ActionEntry(SHIFT, 342);
   _actionMap[861][SMALLINT] = ActionEntry(SHIFT, 347);
   _actionMap[861][TINYINT] = ActionEntry(SHIFT, 348);
   _actionMap[861][DOUBLE] = ActionEntry(SHIFT, 345);
   _actionMap[861][DECIMAL] = ActionEntry(SHIFT, 344);
   _actionMap[861][DATETIME] = ActionEntry(SHIFT, 343);
   _actionMap[862][SEMICOLON] = ActionEntry(REDUCE, 232);
   _actionMap[862][KSEP] = ActionEntry(REDUCE, 232);
   _actionMap[863][THEN] = ActionEntry(SHIFT, 902);
   _actionMap[864][THEN] = ActionEntry(REDUCE, 283);
   _actionMap[865][END_TOKEN] = ActionEntry(REDUCE, 288);
   _actionMap[865][ELSE] = ActionEntry(REDUCE, 288);
   _actionMap[865][ELSIF] = ActionEntry(REDUCE, 288);
   _actionMap[866][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[866][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[866][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[866][SEMICOLON] = ActionEntry(REDUCE, 260);
   _actionMap[867][RB] = ActionEntry(SHIFT, 903);
   _actionMap[868][RB] = ActionEntry(SHIFT, 904);
   _actionMap[869][RB] = ActionEntry(REDUCE, 394);
   _actionMap[869][KSEP] = ActionEntry(SHIFT, 905);
   _actionMap[870][RB] = ActionEntry(SHIFT, 906);
   _actionMap[871][SEMICOLON] = ActionEntry(REDUCE, 294);
   _actionMap[872][RB] = ActionEntry(SHIFT, 907);
   _actionMap[873][IDENTIFIER] = ActionEntry(SHIFT, 821);
   _jumpMap[873][AliasAttr] = 908;
}
void Cego::loadParser15()
{
   _actionMap[874][SEMICOLON] = ActionEntry(REDUCE, 69);
   _actionMap[875][IDENTIFIER] = ActionEntry(SHIFT, 909);
   _actionMap[876][CACHED] = ActionEntry(SHIFT, 911);
   _actionMap[876][SEMICOLON] = ActionEntry(REDUCE, 68);
   _jumpMap[876][CachedOpt] = 910;
   _actionMap[877][IDENTIFIER] = ActionEntry(SHIFT, 824);
   _jumpMap[877][SimpleAttr] = 823;
   _jumpMap[877][SimpleAttrList] = 912;
   _actionMap[878][SEMICOLON] = ActionEntry(REDUCE, 120);
   _actionMap[878][KSEP] = ActionEntry(REDUCE, 120);
   _actionMap[878][RB] = ActionEntry(REDUCE, 120);
   _actionMap[879][SEMICOLON] = ActionEntry(REDUCE, 123);
   _actionMap[879][KSEP] = ActionEntry(REDUCE, 123);
   _actionMap[879][RB] = ActionEntry(REDUCE, 123);
   _actionMap[880][NULLTOKEN] = ActionEntry(SHIFT, 913);
   _actionMap[881][SEMICOLON] = ActionEntry(REDUCE, 121);
   _actionMap[881][KSEP] = ActionEntry(REDUCE, 121);
   _actionMap[881][RB] = ActionEntry(REDUCE, 121);
   _actionMap[882][NULLTOKEN] = ActionEntry(REDUCE, 125);
   _actionMap[882][NOT] = ActionEntry(REDUCE, 125);
   _actionMap[882][KSEP] = ActionEntry(REDUCE, 125);
   _actionMap[882][SEMICOLON] = ActionEntry(REDUCE, 125);
   _actionMap[882][RB] = ActionEntry(REDUCE, 125);
   _actionMap[883][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[883][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[883][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[883][KSEP] = ActionEntry(REDUCE, 152);
   _actionMap[883][RB] = ActionEntry(REDUCE, 152);
   _actionMap[884][LEFT] = ActionEntry(REDUCE, 304);
   _actionMap[884][RIGHT] = ActionEntry(REDUCE, 304);
   _actionMap[884][INNER] = ActionEntry(REDUCE, 304);
   _actionMap[884][JOIN] = ActionEntry(REDUCE, 304);
   _actionMap[884][ENDTOKEN] = ActionEntry(REDUCE, 304);
   _actionMap[884][UNION] = ActionEntry(REDUCE, 304);
   _actionMap[884][ROWLIMIT] = ActionEntry(REDUCE, 304);
   _actionMap[884][ORDER] = ActionEntry(REDUCE, 304);
   _actionMap[884][GROUP] = ActionEntry(REDUCE, 304);
   _actionMap[884][SEMICOLON] = ActionEntry(REDUCE, 304);
   _actionMap[884][RETURNTOKEN] = ActionEntry(REDUCE, 304);
   _actionMap[884][WHERE] = ActionEntry(REDUCE, 304);
   _actionMap[884][RB] = ActionEntry(REDUCE, 304);
   _actionMap[884][BEGIN] = ActionEntry(REDUCE, 304);
   _actionMap[884][THEN] = ActionEntry(REDUCE, 304);
   _actionMap[884][AND] = ActionEntry(REDUCE, 304);
   _actionMap[884][OR] = ActionEntry(REDUCE, 304);
   _actionMap[885][LEFT] = ActionEntry(REDUCE, 302);
   _actionMap[885][RIGHT] = ActionEntry(REDUCE, 302);
   _actionMap[885][INNER] = ActionEntry(REDUCE, 302);
   _actionMap[885][JOIN] = ActionEntry(REDUCE, 302);
   _actionMap[885][ENDTOKEN] = ActionEntry(REDUCE, 302);
}
void Cego::loadParser16()
{
   _actionMap[885][UNION] = ActionEntry(REDUCE, 302);
   _actionMap[885][ROWLIMIT] = ActionEntry(REDUCE, 302);
   _actionMap[885][ORDER] = ActionEntry(REDUCE, 302);
   _actionMap[885][GROUP] = ActionEntry(REDUCE, 302);
   _actionMap[885][SEMICOLON] = ActionEntry(REDUCE, 302);
   _actionMap[885][RETURNTOKEN] = ActionEntry(REDUCE, 302);
   _actionMap[885][WHERE] = ActionEntry(REDUCE, 302);
   _actionMap[885][RB] = ActionEntry(REDUCE, 302);
   _actionMap[885][BEGIN] = ActionEntry(REDUCE, 302);
   _actionMap[885][THEN] = ActionEntry(REDUCE, 302);
   _actionMap[885][AND] = ActionEntry(REDUCE, 302);
   _actionMap[885][OR] = ActionEntry(REDUCE, 302);
   _actionMap[886][KSEP] = ActionEntry(REDUCE, 114);
   _actionMap[886][RB] = ActionEntry(REDUCE, 114);
   _actionMap[887][UNION] = ActionEntry(SHIFT, 915);
   _actionMap[887][SEMICOLON] = ActionEntry(REDUCE, 221);
   _actionMap[887][RB] = ActionEntry(REDUCE, 221);
   _jumpMap[887][UnionAllOpt] = 914;
   _actionMap[888][UNION] = ActionEntry(REDUCE, 218);
   _actionMap[888][ENDTOKEN] = ActionEntry(REDUCE, 218);
   _actionMap[888][RB] = ActionEntry(REDUCE, 218);
   _actionMap[888][SEMICOLON] = ActionEntry(REDUCE, 218);
   _actionMap[889][INTVAL] = ActionEntry(SHIFT, 916);
   _actionMap[890][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[890][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[890][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[890][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[890][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[890][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[890][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[890][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[890][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[890][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[890][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[890][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[890][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[890][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[890][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[890][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[890][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[890][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[890][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[890][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[890][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[890][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[890][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[890][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[890][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[890][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[890][RANDINT] = ActionEntry(SHIFT, 161);
}
void Cego::loadParser17()
{
   _actionMap[890][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[890][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[890][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[890][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[890][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[890][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[890][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[890][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[890][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[890][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[890][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[890][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[890][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[890][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[890][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[890][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[890][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[890][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[890][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[890][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[890][LB] = ActionEntry(SHIFT, 178);
   _actionMap[890][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[890][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[890][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[890][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[890][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[890][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[890][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[890][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[890][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[890][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[890][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[890][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[890][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[890][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[890][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[890][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[890][ObjSpec] = 122;
   _jumpMap[890][Constant] = 121;
   _jumpMap[890][SignedFloat] = 120;
   _jumpMap[890][SignedInt] = 119;
   _jumpMap[890][Attribute] = 118;
   _jumpMap[890][Function] = 117;
   _jumpMap[890][Factor] = 116;
   _jumpMap[890][Term] = 115;
   _jumpMap[890][Expr] = 918;
   _jumpMap[890][OrderingList] = 917;
   _jumpMap[890][CasePrepare] = 113;
   _jumpMap[890][CaseClause] = 112;
   _actionMap[891][KSEP] = ActionEntry(SHIFT, 922);
}
void Cego::loadParser18()
{
   _actionMap[891][ORDER] = ActionEntry(REDUCE, 204);
   _actionMap[891][HAVING] = ActionEntry(SHIFT, 921);
   _actionMap[891][ROWLIMIT] = ActionEntry(REDUCE, 204);
   _actionMap[891][UNION] = ActionEntry(REDUCE, 204);
   _actionMap[891][ENDTOKEN] = ActionEntry(REDUCE, 204);
   _actionMap[891][RB] = ActionEntry(REDUCE, 204);
   _actionMap[891][SEMICOLON] = ActionEntry(REDUCE, 204);
   _jumpMap[891][NoHaving] = 920;
   _jumpMap[891][HavingClause] = 919;
   _actionMap[892][KSEP] = ActionEntry(REDUCE, 201);
   _actionMap[892][HAVING] = ActionEntry(REDUCE, 201);
   _actionMap[892][ORDER] = ActionEntry(REDUCE, 201);
   _actionMap[892][ROWLIMIT] = ActionEntry(REDUCE, 201);
   _actionMap[892][UNION] = ActionEntry(REDUCE, 201);
   _actionMap[892][ENDTOKEN] = ActionEntry(REDUCE, 201);
   _actionMap[892][RB] = ActionEntry(REDUCE, 201);
   _actionMap[892][SEMICOLON] = ActionEntry(REDUCE, 201);
   _actionMap[893][KSEP] = ActionEntry(REDUCE, 402);
   _actionMap[893][HAVING] = ActionEntry(REDUCE, 402);
   _actionMap[893][ORDER] = ActionEntry(REDUCE, 402);
   _actionMap[893][ROWLIMIT] = ActionEntry(REDUCE, 402);
   _actionMap[893][UNION] = ActionEntry(REDUCE, 402);
   _actionMap[893][ENDTOKEN] = ActionEntry(REDUCE, 402);
   _actionMap[893][RB] = ActionEntry(REDUCE, 402);
   _actionMap[893][SEMICOLON] = ActionEntry(REDUCE, 402);
   _actionMap[894][KSEP] = ActionEntry(REDUCE, 403);
   _actionMap[894][HAVING] = ActionEntry(REDUCE, 403);
   _actionMap[894][ORDER] = ActionEntry(REDUCE, 403);
   _actionMap[894][ROWLIMIT] = ActionEntry(REDUCE, 403);
   _actionMap[894][UNION] = ActionEntry(REDUCE, 403);
   _actionMap[894][ENDTOKEN] = ActionEntry(REDUCE, 403);
   _actionMap[894][RB] = ActionEntry(REDUCE, 403);
   _actionMap[894][SEMICOLON] = ActionEntry(REDUCE, 403);
   _actionMap[895][OR] = ActionEntry(SHIFT, 444);
   _actionMap[895][LEFT] = ActionEntry(REDUCE, 182);
   _actionMap[895][RIGHT] = ActionEntry(REDUCE, 182);
   _actionMap[895][INNER] = ActionEntry(REDUCE, 182);
   _actionMap[895][JOIN] = ActionEntry(REDUCE, 182);
   _actionMap[895][RB] = ActionEntry(REDUCE, 182);
   _actionMap[895][ENDTOKEN] = ActionEntry(REDUCE, 182);
   _actionMap[895][UNION] = ActionEntry(REDUCE, 182);
   _actionMap[895][ROWLIMIT] = ActionEntry(REDUCE, 182);
   _actionMap[895][ORDER] = ActionEntry(REDUCE, 182);
   _actionMap[895][GROUP] = ActionEntry(REDUCE, 182);
   _actionMap[895][SEMICOLON] = ActionEntry(REDUCE, 182);
   _actionMap[895][RETURNTOKEN] = ActionEntry(REDUCE, 182);
   _actionMap[895][WHERE] = ActionEntry(REDUCE, 182);
   _actionMap[896][ON] = ActionEntry(SHIFT, 923);
   _actionMap[896][LEFT] = ActionEntry(REDUCE, 183);
   _actionMap[896][RIGHT] = ActionEntry(REDUCE, 183);
}
void Cego::loadParser19()
{
   _actionMap[896][INNER] = ActionEntry(REDUCE, 183);
   _actionMap[896][JOIN] = ActionEntry(REDUCE, 183);
   _actionMap[896][RB] = ActionEntry(REDUCE, 183);
   _actionMap[896][ENDTOKEN] = ActionEntry(REDUCE, 183);
   _actionMap[896][UNION] = ActionEntry(REDUCE, 183);
   _actionMap[896][ROWLIMIT] = ActionEntry(REDUCE, 183);
   _actionMap[896][ORDER] = ActionEntry(REDUCE, 183);
   _actionMap[896][GROUP] = ActionEntry(REDUCE, 183);
   _actionMap[896][SEMICOLON] = ActionEntry(REDUCE, 183);
   _actionMap[896][RETURNTOKEN] = ActionEntry(REDUCE, 183);
   _actionMap[896][WHERE] = ActionEntry(REDUCE, 183);
   _actionMap[897][ON] = ActionEntry(SHIFT, 924);
   _actionMap[897][LEFT] = ActionEntry(REDUCE, 185);
   _actionMap[897][RIGHT] = ActionEntry(REDUCE, 185);
   _actionMap[897][INNER] = ActionEntry(REDUCE, 185);
   _actionMap[897][JOIN] = ActionEntry(REDUCE, 185);
   _actionMap[897][RB] = ActionEntry(REDUCE, 185);
   _actionMap[897][ENDTOKEN] = ActionEntry(REDUCE, 185);
   _actionMap[897][UNION] = ActionEntry(REDUCE, 185);
   _actionMap[897][ROWLIMIT] = ActionEntry(REDUCE, 185);
   _actionMap[897][ORDER] = ActionEntry(REDUCE, 185);
   _actionMap[897][GROUP] = ActionEntry(REDUCE, 185);
   _actionMap[897][SEMICOLON] = ActionEntry(REDUCE, 185);
   _actionMap[897][RETURNTOKEN] = ActionEntry(REDUCE, 185);
   _actionMap[897][WHERE] = ActionEntry(REDUCE, 185);
   _actionMap[898][VARREF] = ActionEntry(SHIFT, 857);
   _jumpMap[898][ReturnVar] = 925;
   _actionMap[899][VARREF] = ActionEntry(SHIFT, 857);
   _jumpMap[899][ReturnVar] = 855;
   _jumpMap[899][ReturnVarList] = 926;
   _actionMap[900][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[900][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[900][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[900][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[900][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[900][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[900][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[900][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[900][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[900][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[900][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[900][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[900][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[900][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[900][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[900][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[900][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[900][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[900][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[900][SUBSTR] = ActionEntry(SHIFT, 169);
}
void Cego::loadParser20()
{
   _actionMap[900][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[900][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[900][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[900][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[900][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[900][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[900][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[900][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[900][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[900][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[900][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[900][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[900][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[900][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[900][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[900][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[900][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[900][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[900][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[900][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[900][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[900][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[900][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[900][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[900][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[900][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[900][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[900][LB] = ActionEntry(SHIFT, 178);
   _actionMap[900][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[900][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[900][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[900][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[900][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[900][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[900][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[900][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[900][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[900][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[900][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[900][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[900][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[900][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[900][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[900][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[900][ObjSpec] = 122;
   _jumpMap[900][Constant] = 121;
   _jumpMap[900][SignedFloat] = 120;
   _jumpMap[900][SignedInt] = 119;
   _jumpMap[900][Attribute] = 118;
   _jumpMap[900][Function] = 117;
}
void Cego::loadParser21()
{
   _jumpMap[900][Factor] = 116;
   _jumpMap[900][Term] = 115;
   _jumpMap[900][Expr] = 927;
   _jumpMap[900][CasePrepare] = 113;
   _jumpMap[900][CaseClause] = 112;
   _actionMap[801][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[801][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[801][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[801][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[801][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[801][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[801][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[801][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[801][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[801][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[801][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[801][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[801][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[801][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[801][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[801][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[801][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[801][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[801][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[801][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[801][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[801][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[801][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[801][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[801][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[801][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[801][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[801][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[801][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[801][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[801][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[801][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[801][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[801][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[801][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[801][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[801][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[801][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[801][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[801][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[801][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[801][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[801][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[801][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[801][IDENTIFIER] = ActionEntry(SHIFT, 182);
}
void Cego::loadParser22()
{
   _actionMap[801][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[801][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[801][LB] = ActionEntry(SHIFT, 178);
   _actionMap[801][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[801][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[801][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[801][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[801][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[801][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[801][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[801][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[801][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[801][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[801][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[801][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[801][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[801][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[801][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[801][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[801][EXISTS] = ActionEntry(SHIFT, 277);
   _actionMap[801][NOT] = ActionEntry(SHIFT, 278);
   _jumpMap[801][ObjSpec] = 122;
   _jumpMap[801][Constant] = 121;
   _jumpMap[801][SignedFloat] = 120;
   _jumpMap[801][SignedInt] = 119;
   _jumpMap[801][Attribute] = 118;
   _jumpMap[801][Function] = 117;
   _jumpMap[801][Factor] = 116;
   _jumpMap[801][Term] = 115;
   _jumpMap[801][Expr] = 276;
   _jumpMap[801][Predicate] = 275;
   _jumpMap[801][Conjunction] = 274;
   _jumpMap[801][Condition] = 858;
   _jumpMap[801][CasePrepare] = 113;
   _jumpMap[801][CaseClause] = 112;
   _actionMap[802][LB] = ActionEntry(SHIFT, 859);
   _actionMap[803][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[803][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[803][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[803][LB] = ActionEntry(SHIFT, 861);
   _actionMap[803][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[803][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[803][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[803][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[803][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[803][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[803][CLOB] = ActionEntry(SHIFT, 133);
   _jumpMap[803][Constant] = 860;
   _jumpMap[803][SignedFloat] = 120;
   _jumpMap[803][SignedInt] = 119;
}
void Cego::loadParser23()
{
   _actionMap[804][IDENTIFIER] = ActionEntry(SHIFT, 862);
   _actionMap[805][SEMICOLON] = ActionEntry(REDUCE, 36);
   _actionMap[806][IDENTIFIER] = ActionEntry(SHIFT, 864);
   _jumpMap[806][ProcExceptionType] = 863;
   _actionMap[807][END_TOKEN] = ActionEntry(REDUCE, 289);
   _actionMap[808][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[808][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[808][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[808][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[808][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[808][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[808][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[808][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[808][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[808][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[808][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[808][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[808][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[808][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[808][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[808][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[808][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[808][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[808][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[808][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[808][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[808][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[808][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[808][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[808][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[808][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[808][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[808][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[808][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[808][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[808][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[808][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[808][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[808][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[808][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[808][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[808][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[808][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[808][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[808][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[808][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[808][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[808][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[808][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[808][IDENTIFIER] = ActionEntry(SHIFT, 182);
}
void Cego::loadParser24()
{
   _actionMap[808][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[808][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[808][LB] = ActionEntry(SHIFT, 178);
   _actionMap[808][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[808][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[808][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[808][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[808][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[808][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[808][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[808][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[808][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[808][VARREF] = ActionEntry(SHIFT, 422);
   _actionMap[808][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[808][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[808][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[808][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[808][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[808][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[808][IF] = ActionEntry(SHIFT, 416);
   _actionMap[808][BEGIN] = ActionEntry(SHIFT, 413);
   _actionMap[808][UNLOCK] = ActionEntry(SHIFT, 28);
   _actionMap[808][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[808][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[808][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[808][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[808][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[808][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[808][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[808][VAR] = ActionEntry(SHIFT, 420);
   _actionMap[808][CURSOR] = ActionEntry(SHIFT, 415);
   _actionMap[808][CLOSE] = ActionEntry(SHIFT, 414);
   _actionMap[808][NOOP] = ActionEntry(SHIFT, 417);
   _actionMap[808][THROW] = ActionEntry(SHIFT, 419);
   _actionMap[808][RETURNTOKEN] = ActionEntry(SHIFT, 418);
   _actionMap[808][WHILE] = ActionEntry(SHIFT, 421);
   _jumpMap[808][ObjSpec] = 122;
   _jumpMap[808][Constant] = 121;
   _jumpMap[808][SignedFloat] = 120;
   _jumpMap[808][SignedInt] = 119;
   _jumpMap[808][Attribute] = 118;
   _jumpMap[808][Function] = 117;
   _jumpMap[808][Factor] = 116;
   _jumpMap[808][Term] = 115;
   _jumpMap[808][Expr] = 412;
   _jumpMap[808][ProcStatement] = 411;
   _jumpMap[808][ProcIfPart] = 410;
   _jumpMap[808][ProcBlockStart] = 409;
   _jumpMap[808][ProcStatementList] = 408;
   _jumpMap[808][ProcStmtBlock] = 865;
}
void Cego::loadParser25()
{
   _jumpMap[808][DeleteStatement] = 406;
   _jumpMap[808][UpdateStatement] = 405;
   _jumpMap[808][InsertStatement] = 404;
   _jumpMap[808][UnlockStatement] = 403;
   _jumpMap[808][LockStatement] = 402;
   _jumpMap[808][RollbackStatement] = 401;
   _jumpMap[808][CommitStatement] = 400;
   _jumpMap[808][StartStatement] = 399;
   _jumpMap[808][CasePrepare] = 113;
   _jumpMap[808][CaseClause] = 112;
   _actionMap[809][SEMICOLON] = ActionEntry(REDUCE, 255);
   _actionMap[810][END_TOKEN] = ActionEntry(REDUCE, 285);
   _actionMap[810][ELSE] = ActionEntry(REDUCE, 285);
   _actionMap[810][ELSIF] = ActionEntry(REDUCE, 285);
   _actionMap[811][SEMICOLON] = ActionEntry(REDUCE, 254);
   _actionMap[812][SEMICOLON] = ActionEntry(REDUCE, 261);
   _actionMap[813][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[813][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[813][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[813][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[813][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[813][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[813][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[813][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[813][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[813][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[813][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[813][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[813][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[813][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[813][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[813][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[813][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[813][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[813][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[813][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[813][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[813][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[813][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[813][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[813][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[813][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[813][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[813][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[813][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[813][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[813][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[813][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[813][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[813][BITOR] = ActionEntry(SHIFT, 127);
}
void Cego::loadParser26()
{
   _actionMap[813][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[813][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[813][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[813][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[813][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[813][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[813][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[813][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[813][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[813][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[813][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[813][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[813][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[813][LB] = ActionEntry(SHIFT, 178);
   _actionMap[813][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[813][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[813][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[813][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[813][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[813][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[813][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[813][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[813][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[813][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[813][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[813][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[813][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[813][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[813][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[813][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[813][ObjSpec] = 122;
   _jumpMap[813][Constant] = 121;
   _jumpMap[813][SignedFloat] = 120;
   _jumpMap[813][SignedInt] = 119;
   _jumpMap[813][Attribute] = 118;
   _jumpMap[813][Function] = 117;
   _jumpMap[813][Factor] = 116;
   _jumpMap[813][Term] = 115;
   _jumpMap[813][Expr] = 866;
   _jumpMap[813][CasePrepare] = 113;
   _jumpMap[813][CaseClause] = 112;
   _actionMap[814][INTVAL] = ActionEntry(SHIFT, 867);
   _actionMap[815][INTVAL] = ActionEntry(SHIFT, 869);
   _jumpMap[815][DecimalDim] = 868;
   _actionMap[816][INTVAL] = ActionEntry(SHIFT, 870);
   _actionMap[817][END_TOKEN] = ActionEntry(SHIFT, 871);
   _actionMap[818][IDENTIFIER] = ActionEntry(SHIFT, 824);
   _jumpMap[818][SimpleAttr] = 823;
   _jumpMap[818][SimpleAttrList] = 872;
   _actionMap[819][RB] = ActionEntry(SHIFT, 874);
}
void Cego::loadParser27()
{
   _actionMap[819][KSEP] = ActionEntry(SHIFT, 873);
   _actionMap[820][KSEP] = ActionEntry(REDUCE, 71);
   _actionMap[820][RB] = ActionEntry(REDUCE, 71);
   _actionMap[821][AS] = ActionEntry(SHIFT, 875);
   _actionMap[822][RB] = ActionEntry(SHIFT, 876);
   _actionMap[823][KSEP] = ActionEntry(SHIFT, 877);
   _actionMap[823][RB] = ActionEntry(REDUCE, 129);
   _actionMap[824][RB] = ActionEntry(REDUCE, 130);
   _actionMap[824][KSEP] = ActionEntry(REDUCE, 130);
   _actionMap[825][KSEP] = ActionEntry(REDUCE, 247);
   _actionMap[825][RB] = ActionEntry(REDUCE, 247);
   _actionMap[826][BEGIN] = ActionEntry(REDUCE, 243);
   _actionMap[827][KSEP] = ActionEntry(REDUCE, 249);
   _actionMap[827][RB] = ActionEntry(REDUCE, 249);
   _actionMap[828][KSEP] = ActionEntry(REDUCE, 250);
   _actionMap[828][RB] = ActionEntry(REDUCE, 250);
   _actionMap[829][KSEP] = ActionEntry(REDUCE, 116);
   _actionMap[829][RB] = ActionEntry(REDUCE, 116);
   _actionMap[830][SEMICOLON] = ActionEntry(REDUCE, 124);
   _actionMap[830][NULLTOKEN] = ActionEntry(SHIFT, 881);
   _actionMap[830][NOT] = ActionEntry(SHIFT, 880);
   _actionMap[830][KSEP] = ActionEntry(REDUCE, 124);
   _actionMap[830][RB] = ActionEntry(REDUCE, 124);
   _jumpMap[830][DefaultNullOpt] = 879;
   _jumpMap[830][NullOpt] = 878;
   _actionMap[831][NULLTOKEN] = ActionEntry(REDUCE, 126);
   _actionMap[831][NOT] = ActionEntry(REDUCE, 126);
   _actionMap[831][KSEP] = ActionEntry(REDUCE, 126);
   _actionMap[831][SEMICOLON] = ActionEntry(REDUCE, 126);
   _actionMap[831][RB] = ActionEntry(REDUCE, 126);
   _actionMap[832][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[832][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[832][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[832][LB] = ActionEntry(SHIFT, 861);
   _actionMap[832][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[832][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[832][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[832][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[832][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[832][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[832][CLOB] = ActionEntry(SHIFT, 133);
   _jumpMap[832][Constant] = 882;
   _jumpMap[832][SignedFloat] = 120;
   _jumpMap[832][SignedInt] = 119;
   _actionMap[833][BEGIN] = ActionEntry(REDUCE, 101);
   _actionMap[834][OR] = ActionEntry(REDUCE, 104);
   _actionMap[834][ON] = ActionEntry(REDUCE, 104);
   _actionMap[835][SEMICOLON] = ActionEntry(REDUCE, 147);
   _actionMap[835][KSEP] = ActionEntry(REDUCE, 147);
   _actionMap[836][FLOATVAL] = ActionEntry(SHIFT, 181);
}
void Cego::loadParser28()
{
   _actionMap[836][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[836][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[836][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[836][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[836][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[836][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[836][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[836][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[836][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[836][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[836][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[836][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[836][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[836][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[836][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[836][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[836][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[836][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[836][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[836][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[836][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[836][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[836][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[836][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[836][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[836][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[836][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[836][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[836][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[836][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[836][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[836][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[836][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[836][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[836][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[836][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[836][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[836][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[836][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[836][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[836][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[836][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[836][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[836][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[836][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[836][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[836][LB] = ActionEntry(SHIFT, 178);
   _actionMap[836][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[836][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[836][NULLTOKEN] = ActionEntry(SHIFT, 158);
}
void Cego::loadParser29()
{
   _actionMap[836][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[836][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[836][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[836][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[836][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[836][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[836][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[836][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[836][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[836][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[836][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[836][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[836][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[836][ObjSpec] = 122;
   _jumpMap[836][Constant] = 121;
   _jumpMap[836][SignedFloat] = 120;
   _jumpMap[836][SignedInt] = 119;
   _jumpMap[836][Attribute] = 118;
   _jumpMap[836][Function] = 117;
   _jumpMap[836][Factor] = 116;
   _jumpMap[836][Term] = 115;
   _jumpMap[836][Expr] = 883;
   _jumpMap[836][CasePrepare] = 113;
   _jumpMap[836][CaseClause] = 112;
   _actionMap[837][SEMICOLON] = ActionEntry(REDUCE, 149);
   _actionMap[837][KSEP] = ActionEntry(REDUCE, 149);
   _actionMap[838][KSEP] = ActionEntry(REDUCE, 150);
   _actionMap[838][RB] = ActionEntry(REDUCE, 150);
   _actionMap[839][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[839][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[839][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[839][LEFT] = ActionEntry(REDUCE, 306);
   _actionMap[839][RIGHT] = ActionEntry(REDUCE, 306);
   _actionMap[839][INNER] = ActionEntry(REDUCE, 306);
   _actionMap[839][JOIN] = ActionEntry(REDUCE, 306);
   _actionMap[839][ENDTOKEN] = ActionEntry(REDUCE, 306);
   _actionMap[839][UNION] = ActionEntry(REDUCE, 306);
   _actionMap[839][ROWLIMIT] = ActionEntry(REDUCE, 306);
   _actionMap[839][ORDER] = ActionEntry(REDUCE, 306);
   _actionMap[839][GROUP] = ActionEntry(REDUCE, 306);
   _actionMap[839][SEMICOLON] = ActionEntry(REDUCE, 306);
   _actionMap[839][RETURNTOKEN] = ActionEntry(REDUCE, 306);
   _actionMap[839][WHERE] = ActionEntry(REDUCE, 306);
   _actionMap[839][RB] = ActionEntry(REDUCE, 306);
   _actionMap[839][BEGIN] = ActionEntry(REDUCE, 306);
   _actionMap[839][THEN] = ActionEntry(REDUCE, 306);
   _actionMap[839][AND] = ActionEntry(REDUCE, 306);
   _actionMap[839][OR] = ActionEntry(REDUCE, 306);
   _actionMap[840][LEFT] = ActionEntry(REDUCE, 303);
   _actionMap[840][RIGHT] = ActionEntry(REDUCE, 303);
}
void Cego::loadParser30()
{
   _actionMap[840][INNER] = ActionEntry(REDUCE, 303);
   _actionMap[840][JOIN] = ActionEntry(REDUCE, 303);
   _actionMap[840][ENDTOKEN] = ActionEntry(REDUCE, 303);
   _actionMap[840][UNION] = ActionEntry(REDUCE, 303);
   _actionMap[840][ROWLIMIT] = ActionEntry(REDUCE, 303);
   _actionMap[840][ORDER] = ActionEntry(REDUCE, 303);
   _actionMap[840][GROUP] = ActionEntry(REDUCE, 303);
   _actionMap[840][SEMICOLON] = ActionEntry(REDUCE, 303);
   _actionMap[840][RETURNTOKEN] = ActionEntry(REDUCE, 303);
   _actionMap[840][WHERE] = ActionEntry(REDUCE, 303);
   _actionMap[840][RB] = ActionEntry(REDUCE, 303);
   _actionMap[840][BEGIN] = ActionEntry(REDUCE, 303);
   _actionMap[840][THEN] = ActionEntry(REDUCE, 303);
   _actionMap[840][AND] = ActionEntry(REDUCE, 303);
   _actionMap[840][OR] = ActionEntry(REDUCE, 303);
   _actionMap[841][LEFT] = ActionEntry(REDUCE, 301);
   _actionMap[841][RIGHT] = ActionEntry(REDUCE, 301);
   _actionMap[841][INNER] = ActionEntry(REDUCE, 301);
   _actionMap[841][JOIN] = ActionEntry(REDUCE, 301);
   _actionMap[841][ENDTOKEN] = ActionEntry(REDUCE, 301);
   _actionMap[841][UNION] = ActionEntry(REDUCE, 301);
   _actionMap[841][ROWLIMIT] = ActionEntry(REDUCE, 301);
   _actionMap[841][ORDER] = ActionEntry(REDUCE, 301);
   _actionMap[841][GROUP] = ActionEntry(REDUCE, 301);
   _actionMap[841][SEMICOLON] = ActionEntry(REDUCE, 301);
   _actionMap[841][RETURNTOKEN] = ActionEntry(REDUCE, 301);
   _actionMap[841][WHERE] = ActionEntry(REDUCE, 301);
   _actionMap[841][RB] = ActionEntry(REDUCE, 301);
   _actionMap[841][BEGIN] = ActionEntry(REDUCE, 301);
   _actionMap[841][THEN] = ActionEntry(REDUCE, 301);
   _actionMap[841][AND] = ActionEntry(REDUCE, 301);
   _actionMap[841][OR] = ActionEntry(REDUCE, 301);
   _actionMap[842][RB] = ActionEntry(SHIFT, 884);
   _actionMap[843][RB] = ActionEntry(SHIFT, 885);
   _actionMap[843][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[844][VARREF] = ActionEntry(SHIFT, 886);
   _actionMap[845][WHEN] = ActionEntry(REDUCE, 324);
   _actionMap[845][ELSE] = ActionEntry(REDUCE, 324);
   _actionMap[845][LEFT] = ActionEntry(REDUCE, 324);
   _actionMap[845][RIGHT] = ActionEntry(REDUCE, 324);
   _actionMap[845][INNER] = ActionEntry(REDUCE, 324);
   _actionMap[845][JOIN] = ActionEntry(REDUCE, 324);
   _actionMap[845][ORDER] = ActionEntry(REDUCE, 324);
   _actionMap[845][GROUP] = ActionEntry(REDUCE, 324);
   _actionMap[845][RETURNTOKEN] = ActionEntry(REDUCE, 324);
   _actionMap[845][WHERE] = ActionEntry(REDUCE, 324);
   _actionMap[845][AS] = ActionEntry(REDUCE, 324);
   _actionMap[845][FROM] = ActionEntry(REDUCE, 324);
   _actionMap[845][END_TOKEN] = ActionEntry(REDUCE, 324);
   _actionMap[845][BEGIN] = ActionEntry(REDUCE, 324);
}
void Cego::loadParser31()
{
   _actionMap[845][THEN] = ActionEntry(REDUCE, 324);
   _actionMap[845][OR] = ActionEntry(REDUCE, 324);
   _actionMap[845][AND] = ActionEntry(REDUCE, 324);
   _actionMap[845][NCLIKE] = ActionEntry(REDUCE, 324);
   _actionMap[845][LIKE] = ActionEntry(REDUCE, 324);
   _actionMap[845][IS] = ActionEntry(REDUCE, 324);
   _actionMap[845][BETWEEN] = ActionEntry(REDUCE, 324);
   _actionMap[845][EQU] = ActionEntry(REDUCE, 324);
   _actionMap[845][NEGATION] = ActionEntry(REDUCE, 324);
   _actionMap[845][LT] = ActionEntry(REDUCE, 324);
   _actionMap[845][MT] = ActionEntry(REDUCE, 324);
   _actionMap[845][NOT] = ActionEntry(REDUCE, 324);
   _actionMap[845][INTOK] = ActionEntry(REDUCE, 324);
   _actionMap[845][DESC] = ActionEntry(REDUCE, 324);
   _actionMap[845][ASC] = ActionEntry(REDUCE, 324);
   _actionMap[845][KSEP] = ActionEntry(REDUCE, 324);
   _actionMap[845][ROWLIMIT] = ActionEntry(REDUCE, 324);
   _actionMap[845][UNION] = ActionEntry(REDUCE, 324);
   _actionMap[845][ENDTOKEN] = ActionEntry(REDUCE, 324);
   _actionMap[845][RB] = ActionEntry(REDUCE, 324);
   _actionMap[845][CONCAT] = ActionEntry(REDUCE, 324);
   _actionMap[845][STAR] = ActionEntry(REDUCE, 324);
   _actionMap[845][DIVISION] = ActionEntry(REDUCE, 324);
   _actionMap[845][MINUS] = ActionEntry(REDUCE, 324);
   _actionMap[845][PLUS] = ActionEntry(REDUCE, 324);
   _actionMap[845][SEMICOLON] = ActionEntry(REDUCE, 324);
   _actionMap[846][WHEN] = ActionEntry(REDUCE, 375);
   _actionMap[846][ELSE] = ActionEntry(REDUCE, 375);
   _actionMap[846][FROM] = ActionEntry(REDUCE, 375);
   _actionMap[846][AS] = ActionEntry(REDUCE, 375);
   _actionMap[846][END_TOKEN] = ActionEntry(REDUCE, 375);
   _actionMap[846][BEGIN] = ActionEntry(REDUCE, 375);
   _actionMap[846][THEN] = ActionEntry(REDUCE, 375);
   _actionMap[846][LEFT] = ActionEntry(REDUCE, 375);
   _actionMap[846][RIGHT] = ActionEntry(REDUCE, 375);
   _actionMap[846][INNER] = ActionEntry(REDUCE, 375);
   _actionMap[846][JOIN] = ActionEntry(REDUCE, 375);
   _actionMap[846][ORDER] = ActionEntry(REDUCE, 375);
   _actionMap[846][GROUP] = ActionEntry(REDUCE, 375);
   _actionMap[846][RETURNTOKEN] = ActionEntry(REDUCE, 375);
   _actionMap[846][WHERE] = ActionEntry(REDUCE, 375);
   _actionMap[846][AND] = ActionEntry(REDUCE, 375);
   _actionMap[846][OR] = ActionEntry(REDUCE, 375);
   _actionMap[846][INTOK] = ActionEntry(REDUCE, 375);
   _actionMap[846][NOT] = ActionEntry(REDUCE, 375);
   _actionMap[846][MT] = ActionEntry(REDUCE, 375);
   _actionMap[846][LT] = ActionEntry(REDUCE, 375);
   _actionMap[846][NEGATION] = ActionEntry(REDUCE, 375);
   _actionMap[846][EQU] = ActionEntry(REDUCE, 375);
   _actionMap[846][BETWEEN] = ActionEntry(REDUCE, 375);
}
void Cego::loadParser32()
{
   _actionMap[846][IS] = ActionEntry(REDUCE, 375);
   _actionMap[846][LIKE] = ActionEntry(REDUCE, 375);
   _actionMap[846][NCLIKE] = ActionEntry(REDUCE, 375);
   _actionMap[846][RB] = ActionEntry(REDUCE, 375);
   _actionMap[846][ENDTOKEN] = ActionEntry(REDUCE, 375);
   _actionMap[846][UNION] = ActionEntry(REDUCE, 375);
   _actionMap[846][ROWLIMIT] = ActionEntry(REDUCE, 375);
   _actionMap[846][KSEP] = ActionEntry(REDUCE, 375);
   _actionMap[846][ASC] = ActionEntry(REDUCE, 375);
   _actionMap[846][DESC] = ActionEntry(REDUCE, 375);
   _actionMap[846][PLUS] = ActionEntry(REDUCE, 375);
   _actionMap[846][MINUS] = ActionEntry(REDUCE, 375);
   _actionMap[846][DIVISION] = ActionEntry(REDUCE, 375);
   _actionMap[846][STAR] = ActionEntry(REDUCE, 375);
   _actionMap[846][CONCAT] = ActionEntry(REDUCE, 375);
   _actionMap[846][SEMICOLON] = ActionEntry(REDUCE, 375);
   _actionMap[847][SEMICOLON] = ActionEntry(REDUCE, 219);
   _actionMap[847][RB] = ActionEntry(REDUCE, 219);
   _actionMap[847][ENDTOKEN] = ActionEntry(REDUCE, 219);
   _actionMap[847][UNION] = ActionEntry(REDUCE, 219);
   _actionMap[847][ROWLIMIT] = ActionEntry(SHIFT, 889);
   _jumpMap[847][NoLimit] = 888;
   _jumpMap[847][LimitOpt] = 887;
   _actionMap[848][ROWLIMIT] = ActionEntry(REDUCE, 206);
   _actionMap[848][UNION] = ActionEntry(REDUCE, 206);
   _actionMap[848][ENDTOKEN] = ActionEntry(REDUCE, 206);
   _actionMap[848][RB] = ActionEntry(REDUCE, 206);
   _actionMap[848][SEMICOLON] = ActionEntry(REDUCE, 206);
   _actionMap[849][BY] = ActionEntry(SHIFT, 890);
   _actionMap[850][IDENTIFIER] = ActionEntry(SHIFT, 893);
   _actionMap[850][QUALIFIEDOBJ] = ActionEntry(SHIFT, 894);
   _actionMap[850][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _jumpMap[850][Attribute] = 892;
   _jumpMap[850][GroupList] = 891;
   _actionMap[851][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[851][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[851][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[851][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[851][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[851][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[851][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[851][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[851][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[851][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[851][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[851][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[851][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[851][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[851][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[851][UPPER] = ActionEntry(SHIFT, 177);
}
void Cego::loadParser33()
{
   _actionMap[851][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[851][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[851][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[851][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[851][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[851][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[851][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[851][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[851][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[851][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[851][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[851][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[851][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[851][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[851][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[851][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[851][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[851][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[851][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[851][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[851][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[851][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[851][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[851][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[851][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[851][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[851][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[851][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[851][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[851][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[851][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[851][LB] = ActionEntry(SHIFT, 178);
   _actionMap[851][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[851][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[851][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[851][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[851][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[851][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[851][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[851][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[851][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[851][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[851][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[851][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[851][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[851][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[851][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[851][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[851][EXISTS] = ActionEntry(SHIFT, 277);
   _actionMap[851][NOT] = ActionEntry(SHIFT, 278);
}
void Cego::loadParser34()
{
   _jumpMap[851][ObjSpec] = 122;
   _jumpMap[851][Constant] = 121;
   _jumpMap[851][SignedFloat] = 120;
   _jumpMap[851][SignedInt] = 119;
   _jumpMap[851][Attribute] = 118;
   _jumpMap[851][Function] = 117;
   _jumpMap[851][Factor] = 116;
   _jumpMap[851][Term] = 115;
   _jumpMap[851][Expr] = 276;
   _jumpMap[851][Predicate] = 275;
   _jumpMap[851][Conjunction] = 274;
   _jumpMap[851][Condition] = 895;
   _jumpMap[851][CasePrepare] = 113;
   _jumpMap[851][CaseClause] = 112;
   _actionMap[852][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[852][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[852][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[852][ObjSpec] = 542;
   _jumpMap[852][JoinTable] = 896;
   _jumpMap[852][Table] = 787;
   _actionMap[853][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[853][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[853][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[853][ObjSpec] = 542;
   _jumpMap[853][JoinTable] = 897;
   _jumpMap[853][Table] = 787;
   _actionMap[854][KSEP] = ActionEntry(SHIFT, 898);
   _actionMap[854][SEMICOLON] = ActionEntry(REDUCE, 159);
   _actionMap[855][SEMICOLON] = ActionEntry(REDUCE, 163);
   _actionMap[855][KSEP] = ActionEntry(REDUCE, 163);
   _actionMap[856][FIRST] = ActionEntry(SHIFT, 899);
   _actionMap[857][EQU] = ActionEntry(SHIFT, 900);
   _actionMap[711][SEMICOLON] = ActionEntry(REDUCE, 226);
   _actionMap[712][COLUMN] = ActionEntry(SHIFT, 555);
   _actionMap[713][ON] = ActionEntry(SHIFT, 801);
   _actionMap[714][SEMICOLON] = ActionEntry(REDUCE, 229);
   _actionMap[714][KSEP] = ActionEntry(REDUCE, 229);
   _actionMap[715][IDENTIFIER] = ActionEntry(SHIFT, 802);
   _actionMap[716][SEMICOLON] = ActionEntry(REDUCE, 228);
   _actionMap[716][KSEP] = ActionEntry(REDUCE, 228);
   _actionMap[717][SEMICOLON] = ActionEntry(REDUCE, 230);
   _actionMap[717][KSEP] = ActionEntry(REDUCE, 230);
   _actionMap[718][DEFAULT] = ActionEntry(SHIFT, 803);
   _actionMap[718][INT] = ActionEntry(SHIFT, 744);
   _actionMap[718][LONG] = ActionEntry(SHIFT, 745);
   _actionMap[718][STRING] = ActionEntry(SHIFT, 747);
   _actionMap[718][DATETIME] = ActionEntry(SHIFT, 740);
   _actionMap[718][BOOL] = ActionEntry(SHIFT, 738);
   _actionMap[718][BIGINT] = ActionEntry(SHIFT, 736);
   _actionMap[718][FLOAT] = ActionEntry(SHIFT, 743);
}
void Cego::loadParser35()
{
   _actionMap[718][DOUBLE] = ActionEntry(SHIFT, 742);
   _actionMap[718][SMALLINT] = ActionEntry(SHIFT, 746);
   _actionMap[718][TINYINT] = ActionEntry(SHIFT, 748);
   _actionMap[718][DECIMAL] = ActionEntry(SHIFT, 741);
   _actionMap[718][BLOB] = ActionEntry(SHIFT, 737);
   _actionMap[718][CLOB] = ActionEntry(SHIFT, 739);
   _jumpMap[718][DataTypeProd] = 762;
   _actionMap[719][TO] = ActionEntry(SHIFT, 804);
   _actionMap[720][IDENTIFIER] = ActionEntry(SHIFT, 805);
   _actionMap[721][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[721][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[721][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[721][KSEP] = ActionEntry(REDUCE, 281);
   _actionMap[721][RB] = ActionEntry(REDUCE, 281);
   _actionMap[722][ELSE] = ActionEntry(REDUCE, 276);
   _actionMap[722][ELSIF] = ActionEntry(REDUCE, 276);
   _actionMap[722][EXCEPTION] = ActionEntry(REDUCE, 276);
   _actionMap[722][END_TOKEN] = ActionEntry(REDUCE, 276);
   _actionMap[723][WHEN] = ActionEntry(SHIFT, 806);
   _actionMap[724][EXCEPTION] = ActionEntry(REDUCE, 252);
   _actionMap[724][END_TOKEN] = ActionEntry(REDUCE, 252);
   _actionMap[724][ELSE] = ActionEntry(REDUCE, 252);
   _actionMap[724][ELSIF] = ActionEntry(REDUCE, 252);
   _actionMap[724][VAR] = ActionEntry(REDUCE, 252);
   _actionMap[724][CURSOR] = ActionEntry(REDUCE, 252);
   _actionMap[724][CLOSE] = ActionEntry(REDUCE, 252);
   _actionMap[724][VARREF] = ActionEntry(REDUCE, 252);
   _actionMap[724][NOOP] = ActionEntry(REDUCE, 252);
   _actionMap[724][THROW] = ActionEntry(REDUCE, 252);
   _actionMap[724][RETURNTOKEN] = ActionEntry(REDUCE, 252);
   _actionMap[724][WHILE] = ActionEntry(REDUCE, 252);
   _actionMap[724][IF] = ActionEntry(REDUCE, 252);
   _actionMap[724][BEGIN] = ActionEntry(REDUCE, 252);
   _actionMap[724][UNLOCK] = ActionEntry(REDUCE, 252);
   _actionMap[724][LOCK] = ActionEntry(REDUCE, 252);
   _actionMap[724][ROLLBACK] = ActionEntry(REDUCE, 252);
   _actionMap[724][COMMIT] = ActionEntry(REDUCE, 252);
   _actionMap[724][START_TOKEN] = ActionEntry(REDUCE, 252);
   _actionMap[724][UPDATE] = ActionEntry(REDUCE, 252);
   _actionMap[724][DELETETOK] = ActionEntry(REDUCE, 252);
   _actionMap[724][INSERT] = ActionEntry(REDUCE, 252);
   _actionMap[724][FETCH] = ActionEntry(REDUCE, 252);
   _actionMap[724][LB] = ActionEntry(REDUCE, 252);
   _actionMap[724][COUNT] = ActionEntry(REDUCE, 252);
   _actionMap[724][SUM] = ActionEntry(REDUCE, 252);
   _actionMap[724][AVG] = ActionEntry(REDUCE, 252);
   _actionMap[724][MIN] = ActionEntry(REDUCE, 252);
   _actionMap[724][MAX] = ActionEntry(REDUCE, 252);
   _actionMap[724][CASE] = ActionEntry(REDUCE, 252);
   _actionMap[724][INT2ASC] = ActionEntry(REDUCE, 252);
}
void Cego::loadParser36()
{
   _actionMap[724][ASC2INT] = ActionEntry(REDUCE, 252);
   _actionMap[724][TRIM] = ActionEntry(REDUCE, 252);
   _actionMap[724][RTRIM] = ActionEntry(REDUCE, 252);
   _actionMap[724][LTRIM] = ActionEntry(REDUCE, 252);
   _actionMap[724][ROUND] = ActionEntry(REDUCE, 252);
   _actionMap[724][SCANDATE] = ActionEntry(REDUCE, 252);
   _actionMap[724][DATE2STR] = ActionEntry(REDUCE, 252);
   _actionMap[724][DATE2LONG] = ActionEntry(REDUCE, 252);
   _actionMap[724][LONG2DATE] = ActionEntry(REDUCE, 252);
   _actionMap[724][NEWDATE] = ActionEntry(REDUCE, 252);
   _actionMap[724][LOWER] = ActionEntry(REDUCE, 252);
   _actionMap[724][UPPER] = ActionEntry(REDUCE, 252);
   _actionMap[724][LEFT] = ActionEntry(REDUCE, 252);
   _actionMap[724][RIGHT] = ActionEntry(REDUCE, 252);
   _actionMap[724][GETPOS] = ActionEntry(REDUCE, 252);
   _actionMap[724][SUBSTR] = ActionEntry(REDUCE, 252);
   _actionMap[724][REPLACE] = ActionEntry(REDUCE, 252);
   _actionMap[724][LENGTH] = ActionEntry(REDUCE, 252);
   _actionMap[724][TRUNC] = ActionEntry(REDUCE, 252);
   _actionMap[724][STR2INT] = ActionEntry(REDUCE, 252);
   _actionMap[724][STR2LONG] = ActionEntry(REDUCE, 252);
   _actionMap[724][RANDSTR] = ActionEntry(REDUCE, 252);
   _actionMap[724][RANDINT] = ActionEntry(REDUCE, 252);
   _actionMap[724][MOD] = ActionEntry(REDUCE, 252);
   _actionMap[724][DIV] = ActionEntry(REDUCE, 252);
   _actionMap[724][LMOD] = ActionEntry(REDUCE, 252);
   _actionMap[724][LDIV] = ActionEntry(REDUCE, 252);
   _actionMap[724][POWER] = ActionEntry(REDUCE, 252);
   _actionMap[724][BITAND] = ActionEntry(REDUCE, 252);
   _actionMap[724][BITOR] = ActionEntry(REDUCE, 252);
   _actionMap[724][BITXOR] = ActionEntry(REDUCE, 252);
   _actionMap[724][BLOBSIZE] = ActionEntry(REDUCE, 252);
   _actionMap[724][BLOBREF] = ActionEntry(REDUCE, 252);
   _actionMap[724][CLOBSIZE] = ActionEntry(REDUCE, 252);
   _actionMap[724][CLOBREF] = ActionEntry(REDUCE, 252);
   _actionMap[724][CLOB2STR] = ActionEntry(REDUCE, 252);
   _actionMap[724][REGMATCH] = ActionEntry(REDUCE, 252);
   _actionMap[724][NEXTCOUNT] = ActionEntry(REDUCE, 252);
   _actionMap[724][SETCOUNT] = ActionEntry(REDUCE, 252);
   _actionMap[724][GETCOUNT] = ActionEntry(REDUCE, 252);
   _actionMap[724][IDENTIFIER] = ActionEntry(REDUCE, 252);
   _actionMap[724][QUALIFIEDOBJ] = ActionEntry(REDUCE, 252);
   _actionMap[724][QUALIFIEDTS] = ActionEntry(REDUCE, 252);
   _actionMap[724][QUALIFIEDPRE] = ActionEntry(REDUCE, 252);
   _actionMap[724][STRINGVAL] = ActionEntry(REDUCE, 252);
   _actionMap[724][SYSDATE] = ActionEntry(REDUCE, 252);
   _actionMap[724][NULLTOKEN] = ActionEntry(REDUCE, 252);
   _actionMap[724][TRUEVAL] = ActionEntry(REDUCE, 252);
   _actionMap[724][FALSEVAL] = ActionEntry(REDUCE, 252);
   _actionMap[724][BLOB] = ActionEntry(REDUCE, 252);
}
void Cego::loadParser37()
{
   _actionMap[724][CLOB] = ActionEntry(REDUCE, 252);
   _actionMap[724][FLOATVAL] = ActionEntry(REDUCE, 252);
   _actionMap[724][MINUS] = ActionEntry(REDUCE, 252);
   _actionMap[724][INTVAL] = ActionEntry(REDUCE, 252);
   _actionMap[725][SEMICOLON] = ActionEntry(REDUCE, 274);
   _actionMap[726][END_TOKEN] = ActionEntry(SHIFT, 729);
   _actionMap[727][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[727][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[727][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[727][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[727][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[727][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[727][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[727][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[727][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[727][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[727][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[727][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[727][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[727][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[727][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[727][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[727][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[727][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[727][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[727][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[727][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[727][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[727][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[727][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[727][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[727][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[727][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[727][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[727][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[727][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[727][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[727][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[727][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[727][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[727][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[727][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[727][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[727][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[727][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[727][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[727][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[727][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[727][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[727][GETCOUNT] = ActionEntry(SHIFT, 143);
}
void Cego::loadParser38()
{
   _actionMap[727][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[727][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[727][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[727][LB] = ActionEntry(SHIFT, 178);
   _actionMap[727][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[727][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[727][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[727][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[727][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[727][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[727][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[727][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[727][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[727][VARREF] = ActionEntry(SHIFT, 422);
   _actionMap[727][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[727][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[727][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[727][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[727][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[727][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[727][IF] = ActionEntry(SHIFT, 416);
   _actionMap[727][BEGIN] = ActionEntry(SHIFT, 413);
   _actionMap[727][UNLOCK] = ActionEntry(SHIFT, 28);
   _actionMap[727][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[727][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[727][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[727][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[727][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[727][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[727][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[727][VAR] = ActionEntry(SHIFT, 420);
   _actionMap[727][CURSOR] = ActionEntry(SHIFT, 415);
   _actionMap[727][CLOSE] = ActionEntry(SHIFT, 414);
   _actionMap[727][NOOP] = ActionEntry(SHIFT, 417);
   _actionMap[727][THROW] = ActionEntry(SHIFT, 419);
   _actionMap[727][RETURNTOKEN] = ActionEntry(SHIFT, 418);
   _actionMap[727][WHILE] = ActionEntry(SHIFT, 421);
   _jumpMap[727][ObjSpec] = 122;
   _jumpMap[727][Constant] = 121;
   _jumpMap[727][SignedFloat] = 120;
   _jumpMap[727][SignedInt] = 119;
   _jumpMap[727][Attribute] = 118;
   _jumpMap[727][Function] = 117;
   _jumpMap[727][Factor] = 116;
   _jumpMap[727][Term] = 115;
   _jumpMap[727][Expr] = 412;
   _jumpMap[727][ProcStatement] = 411;
   _jumpMap[727][ProcIfPart] = 410;
   _jumpMap[727][ProcBlockStart] = 409;
   _jumpMap[727][ProcStatementList] = 408;
}
void Cego::loadParser39()
{
   _jumpMap[727][ProcStmtBlock] = 807;
   _jumpMap[727][DeleteStatement] = 406;
   _jumpMap[727][UpdateStatement] = 405;
   _jumpMap[727][InsertStatement] = 404;
   _jumpMap[727][UnlockStatement] = 403;
   _jumpMap[727][LockStatement] = 402;
   _jumpMap[727][RollbackStatement] = 401;
   _jumpMap[727][CommitStatement] = 400;
   _jumpMap[727][StartStatement] = 399;
   _jumpMap[727][CasePrepare] = 113;
   _jumpMap[727][CaseClause] = 112;
   _actionMap[728][VAR] = ActionEntry(REDUCE, 291);
   _actionMap[728][CURSOR] = ActionEntry(REDUCE, 291);
   _actionMap[728][CLOSE] = ActionEntry(REDUCE, 291);
   _actionMap[728][VARREF] = ActionEntry(REDUCE, 291);
   _actionMap[728][NOOP] = ActionEntry(REDUCE, 291);
   _actionMap[728][THROW] = ActionEntry(REDUCE, 291);
   _actionMap[728][RETURNTOKEN] = ActionEntry(REDUCE, 291);
   _actionMap[728][WHILE] = ActionEntry(REDUCE, 291);
   _actionMap[728][IF] = ActionEntry(REDUCE, 291);
   _actionMap[728][BEGIN] = ActionEntry(REDUCE, 291);
   _actionMap[728][UNLOCK] = ActionEntry(REDUCE, 291);
   _actionMap[728][LOCK] = ActionEntry(REDUCE, 291);
   _actionMap[728][ROLLBACK] = ActionEntry(REDUCE, 291);
   _actionMap[728][COMMIT] = ActionEntry(REDUCE, 291);
   _actionMap[728][START_TOKEN] = ActionEntry(REDUCE, 291);
   _actionMap[728][UPDATE] = ActionEntry(REDUCE, 291);
   _actionMap[728][DELETETOK] = ActionEntry(REDUCE, 291);
   _actionMap[728][INSERT] = ActionEntry(REDUCE, 291);
   _actionMap[728][FETCH] = ActionEntry(REDUCE, 291);
   _actionMap[728][LB] = ActionEntry(REDUCE, 291);
   _actionMap[728][COUNT] = ActionEntry(REDUCE, 291);
   _actionMap[728][SUM] = ActionEntry(REDUCE, 291);
   _actionMap[728][AVG] = ActionEntry(REDUCE, 291);
   _actionMap[728][MIN] = ActionEntry(REDUCE, 291);
   _actionMap[728][MAX] = ActionEntry(REDUCE, 291);
   _actionMap[728][CASE] = ActionEntry(REDUCE, 291);
   _actionMap[728][INT2ASC] = ActionEntry(REDUCE, 291);
   _actionMap[728][ASC2INT] = ActionEntry(REDUCE, 291);
   _actionMap[728][TRIM] = ActionEntry(REDUCE, 291);
   _actionMap[728][RTRIM] = ActionEntry(REDUCE, 291);
   _actionMap[728][LTRIM] = ActionEntry(REDUCE, 291);
   _actionMap[728][ROUND] = ActionEntry(REDUCE, 291);
   _actionMap[728][SCANDATE] = ActionEntry(REDUCE, 291);
   _actionMap[728][DATE2STR] = ActionEntry(REDUCE, 291);
   _actionMap[728][DATE2LONG] = ActionEntry(REDUCE, 291);
   _actionMap[728][LONG2DATE] = ActionEntry(REDUCE, 291);
   _actionMap[728][NEWDATE] = ActionEntry(REDUCE, 291);
   _actionMap[728][LOWER] = ActionEntry(REDUCE, 291);
   _actionMap[728][UPPER] = ActionEntry(REDUCE, 291);
}
void Cego::loadParser40()
{
   _actionMap[728][LEFT] = ActionEntry(REDUCE, 291);
   _actionMap[728][RIGHT] = ActionEntry(REDUCE, 291);
   _actionMap[728][GETPOS] = ActionEntry(REDUCE, 291);
   _actionMap[728][SUBSTR] = ActionEntry(REDUCE, 291);
   _actionMap[728][REPLACE] = ActionEntry(REDUCE, 291);
   _actionMap[728][LENGTH] = ActionEntry(REDUCE, 291);
   _actionMap[728][TRUNC] = ActionEntry(REDUCE, 291);
   _actionMap[728][STR2INT] = ActionEntry(REDUCE, 291);
   _actionMap[728][STR2LONG] = ActionEntry(REDUCE, 291);
   _actionMap[728][RANDSTR] = ActionEntry(REDUCE, 291);
   _actionMap[728][RANDINT] = ActionEntry(REDUCE, 291);
   _actionMap[728][MOD] = ActionEntry(REDUCE, 291);
   _actionMap[728][DIV] = ActionEntry(REDUCE, 291);
   _actionMap[728][LMOD] = ActionEntry(REDUCE, 291);
   _actionMap[728][LDIV] = ActionEntry(REDUCE, 291);
   _actionMap[728][POWER] = ActionEntry(REDUCE, 291);
   _actionMap[728][BITAND] = ActionEntry(REDUCE, 291);
   _actionMap[728][BITOR] = ActionEntry(REDUCE, 291);
   _actionMap[728][BITXOR] = ActionEntry(REDUCE, 291);
   _actionMap[728][BLOBSIZE] = ActionEntry(REDUCE, 291);
   _actionMap[728][BLOBREF] = ActionEntry(REDUCE, 291);
   _actionMap[728][CLOBSIZE] = ActionEntry(REDUCE, 291);
   _actionMap[728][CLOBREF] = ActionEntry(REDUCE, 291);
   _actionMap[728][CLOB2STR] = ActionEntry(REDUCE, 291);
   _actionMap[728][REGMATCH] = ActionEntry(REDUCE, 291);
   _actionMap[728][NEXTCOUNT] = ActionEntry(REDUCE, 291);
   _actionMap[728][SETCOUNT] = ActionEntry(REDUCE, 291);
   _actionMap[728][GETCOUNT] = ActionEntry(REDUCE, 291);
   _actionMap[728][IDENTIFIER] = ActionEntry(REDUCE, 291);
   _actionMap[728][QUALIFIEDOBJ] = ActionEntry(REDUCE, 291);
   _actionMap[728][QUALIFIEDTS] = ActionEntry(REDUCE, 291);
   _actionMap[728][QUALIFIEDPRE] = ActionEntry(REDUCE, 291);
   _actionMap[728][STRINGVAL] = ActionEntry(REDUCE, 291);
   _actionMap[728][SYSDATE] = ActionEntry(REDUCE, 291);
   _actionMap[728][NULLTOKEN] = ActionEntry(REDUCE, 291);
   _actionMap[728][TRUEVAL] = ActionEntry(REDUCE, 291);
   _actionMap[728][FALSEVAL] = ActionEntry(REDUCE, 291);
   _actionMap[728][BLOB] = ActionEntry(REDUCE, 291);
   _actionMap[728][CLOB] = ActionEntry(REDUCE, 291);
   _actionMap[728][FLOATVAL] = ActionEntry(REDUCE, 291);
   _actionMap[728][MINUS] = ActionEntry(REDUCE, 291);
   _actionMap[728][INTVAL] = ActionEntry(REDUCE, 291);
   _actionMap[729][SEMICOLON] = ActionEntry(REDUCE, 284);
   _actionMap[730][END_TOKEN] = ActionEntry(REDUCE, 286);
   _actionMap[730][ELSE] = ActionEntry(REDUCE, 286);
   _actionMap[731][THEN] = ActionEntry(SHIFT, 808);
   _actionMap[732][OR] = ActionEntry(SHIFT, 444);
   _actionMap[732][THEN] = ActionEntry(REDUCE, 293);
   _actionMap[733][SELECT] = ActionEntry(SHIFT, 34);
   _jumpMap[733][SelectStatement] = 809;
}
void Cego::loadParser41()
{
   _actionMap[734][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[734][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[734][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[734][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[734][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[734][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[734][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[734][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[734][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[734][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[734][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[734][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[734][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[734][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[734][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[734][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[734][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[734][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[734][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[734][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[734][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[734][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[734][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[734][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[734][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[734][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[734][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[734][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[734][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[734][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[734][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[734][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[734][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[734][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[734][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[734][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[734][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[734][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[734][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[734][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[734][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[734][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[734][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[734][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[734][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[734][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[734][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[734][LB] = ActionEntry(SHIFT, 178);
   _actionMap[734][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[734][SYSDATE] = ActionEntry(SHIFT, 171);
}
void Cego::loadParser42()
{
   _actionMap[734][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[734][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[734][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[734][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[734][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[734][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[734][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[734][VARREF] = ActionEntry(SHIFT, 422);
   _actionMap[734][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[734][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[734][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[734][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[734][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[734][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[734][IF] = ActionEntry(SHIFT, 416);
   _actionMap[734][BEGIN] = ActionEntry(SHIFT, 413);
   _actionMap[734][UNLOCK] = ActionEntry(SHIFT, 28);
   _actionMap[734][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[734][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[734][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[734][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[734][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[734][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[734][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[734][VAR] = ActionEntry(SHIFT, 420);
   _actionMap[734][CURSOR] = ActionEntry(SHIFT, 415);
   _actionMap[734][CLOSE] = ActionEntry(SHIFT, 414);
   _actionMap[734][NOOP] = ActionEntry(SHIFT, 417);
   _actionMap[734][THROW] = ActionEntry(SHIFT, 419);
   _actionMap[734][RETURNTOKEN] = ActionEntry(SHIFT, 418);
   _actionMap[734][WHILE] = ActionEntry(SHIFT, 421);
   _jumpMap[734][ObjSpec] = 122;
   _jumpMap[734][Constant] = 121;
   _jumpMap[734][SignedFloat] = 120;
   _jumpMap[734][SignedInt] = 119;
   _jumpMap[734][Attribute] = 118;
   _jumpMap[734][Function] = 117;
   _jumpMap[734][Factor] = 116;
   _jumpMap[734][Term] = 115;
   _jumpMap[734][Expr] = 412;
   _jumpMap[734][ProcStatement] = 411;
   _jumpMap[734][ProcIfPart] = 410;
   _jumpMap[734][ProcBlockStart] = 409;
   _jumpMap[734][ProcStatementList] = 408;
   _jumpMap[734][ProcStmtBlock] = 810;
   _jumpMap[734][DeleteStatement] = 406;
   _jumpMap[734][UpdateStatement] = 405;
   _jumpMap[734][InsertStatement] = 404;
   _jumpMap[734][UnlockStatement] = 403;
   _jumpMap[734][LockStatement] = 402;
}
void Cego::loadParser43()
{
   _jumpMap[734][RollbackStatement] = 401;
   _jumpMap[734][CommitStatement] = 400;
   _jumpMap[734][StartStatement] = 399;
   _jumpMap[734][CasePrepare] = 113;
   _jumpMap[734][CaseClause] = 112;
   _actionMap[735][SEMICOLON] = ActionEntry(REDUCE, 262);
   _actionMap[735][EQU] = ActionEntry(SHIFT, 813);
   _jumpMap[735][ProcNoAssignment] = 812;
   _jumpMap[735][ProcInitialAssignment] = 811;
   _actionMap[736][LB] = ActionEntry(SHIFT, 814);
   _actionMap[737][BEGIN] = ActionEntry(REDUCE, 392);
   _actionMap[737][EQU] = ActionEntry(REDUCE, 392);
   _actionMap[737][DEFAULT] = ActionEntry(REDUCE, 392);
   _actionMap[737][NULLTOKEN] = ActionEntry(REDUCE, 392);
   _actionMap[737][NOT] = ActionEntry(REDUCE, 392);
   _actionMap[737][KSEP] = ActionEntry(REDUCE, 392);
   _actionMap[737][SEMICOLON] = ActionEntry(REDUCE, 392);
   _actionMap[737][RB] = ActionEntry(REDUCE, 392);
   _actionMap[738][BEGIN] = ActionEntry(REDUCE, 385);
   _actionMap[738][EQU] = ActionEntry(REDUCE, 385);
   _actionMap[738][DEFAULT] = ActionEntry(REDUCE, 385);
   _actionMap[738][NULLTOKEN] = ActionEntry(REDUCE, 385);
   _actionMap[738][NOT] = ActionEntry(REDUCE, 385);
   _actionMap[738][KSEP] = ActionEntry(REDUCE, 385);
   _actionMap[738][SEMICOLON] = ActionEntry(REDUCE, 385);
   _actionMap[738][RB] = ActionEntry(REDUCE, 385);
   _actionMap[739][BEGIN] = ActionEntry(REDUCE, 393);
   _actionMap[739][EQU] = ActionEntry(REDUCE, 393);
   _actionMap[739][DEFAULT] = ActionEntry(REDUCE, 393);
   _actionMap[739][NULLTOKEN] = ActionEntry(REDUCE, 393);
   _actionMap[739][NOT] = ActionEntry(REDUCE, 393);
   _actionMap[739][KSEP] = ActionEntry(REDUCE, 393);
   _actionMap[739][SEMICOLON] = ActionEntry(REDUCE, 393);
   _actionMap[739][RB] = ActionEntry(REDUCE, 393);
   _actionMap[740][BEGIN] = ActionEntry(REDUCE, 384);
   _actionMap[740][EQU] = ActionEntry(REDUCE, 384);
   _actionMap[740][DEFAULT] = ActionEntry(REDUCE, 384);
   _actionMap[740][NULLTOKEN] = ActionEntry(REDUCE, 384);
   _actionMap[740][NOT] = ActionEntry(REDUCE, 384);
   _actionMap[740][KSEP] = ActionEntry(REDUCE, 384);
   _actionMap[740][SEMICOLON] = ActionEntry(REDUCE, 384);
   _actionMap[740][RB] = ActionEntry(REDUCE, 384);
   _actionMap[741][LB] = ActionEntry(SHIFT, 815);
   _actionMap[742][BEGIN] = ActionEntry(REDUCE, 388);
   _actionMap[742][EQU] = ActionEntry(REDUCE, 388);
   _actionMap[742][DEFAULT] = ActionEntry(REDUCE, 388);
   _actionMap[742][NULLTOKEN] = ActionEntry(REDUCE, 388);
   _actionMap[742][NOT] = ActionEntry(REDUCE, 388);
   _actionMap[742][KSEP] = ActionEntry(REDUCE, 388);
   _actionMap[742][SEMICOLON] = ActionEntry(REDUCE, 388);
}
void Cego::loadParser44()
{
   _actionMap[742][RB] = ActionEntry(REDUCE, 388);
   _actionMap[743][BEGIN] = ActionEntry(REDUCE, 387);
   _actionMap[743][EQU] = ActionEntry(REDUCE, 387);
   _actionMap[743][DEFAULT] = ActionEntry(REDUCE, 387);
   _actionMap[743][NULLTOKEN] = ActionEntry(REDUCE, 387);
   _actionMap[743][NOT] = ActionEntry(REDUCE, 387);
   _actionMap[743][KSEP] = ActionEntry(REDUCE, 387);
   _actionMap[743][SEMICOLON] = ActionEntry(REDUCE, 387);
   _actionMap[743][RB] = ActionEntry(REDUCE, 387);
   _actionMap[744][BEGIN] = ActionEntry(REDUCE, 381);
   _actionMap[744][EQU] = ActionEntry(REDUCE, 381);
   _actionMap[744][DEFAULT] = ActionEntry(REDUCE, 381);
   _actionMap[744][NULLTOKEN] = ActionEntry(REDUCE, 381);
   _actionMap[744][NOT] = ActionEntry(REDUCE, 381);
   _actionMap[744][KSEP] = ActionEntry(REDUCE, 381);
   _actionMap[744][SEMICOLON] = ActionEntry(REDUCE, 381);
   _actionMap[744][RB] = ActionEntry(REDUCE, 381);
   _actionMap[745][BEGIN] = ActionEntry(REDUCE, 382);
   _actionMap[745][EQU] = ActionEntry(REDUCE, 382);
   _actionMap[745][DEFAULT] = ActionEntry(REDUCE, 382);
   _actionMap[745][NULLTOKEN] = ActionEntry(REDUCE, 382);
   _actionMap[745][NOT] = ActionEntry(REDUCE, 382);
   _actionMap[745][KSEP] = ActionEntry(REDUCE, 382);
   _actionMap[745][SEMICOLON] = ActionEntry(REDUCE, 382);
   _actionMap[745][RB] = ActionEntry(REDUCE, 382);
   _actionMap[746][BEGIN] = ActionEntry(REDUCE, 389);
   _actionMap[746][EQU] = ActionEntry(REDUCE, 389);
   _actionMap[746][DEFAULT] = ActionEntry(REDUCE, 389);
   _actionMap[746][NULLTOKEN] = ActionEntry(REDUCE, 389);
   _actionMap[746][NOT] = ActionEntry(REDUCE, 389);
   _actionMap[746][KSEP] = ActionEntry(REDUCE, 389);
   _actionMap[746][SEMICOLON] = ActionEntry(REDUCE, 389);
   _actionMap[746][RB] = ActionEntry(REDUCE, 389);
   _actionMap[747][LB] = ActionEntry(SHIFT, 816);
   _actionMap[748][BEGIN] = ActionEntry(REDUCE, 390);
   _actionMap[748][EQU] = ActionEntry(REDUCE, 390);
   _actionMap[748][DEFAULT] = ActionEntry(REDUCE, 390);
   _actionMap[748][NULLTOKEN] = ActionEntry(REDUCE, 390);
   _actionMap[748][NOT] = ActionEntry(REDUCE, 390);
   _actionMap[748][KSEP] = ActionEntry(REDUCE, 390);
   _actionMap[748][SEMICOLON] = ActionEntry(REDUCE, 390);
   _actionMap[748][RB] = ActionEntry(REDUCE, 390);
   _actionMap[749][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[749][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[749][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[749][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[749][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[749][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[749][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[749][LTRIM] = ActionEntry(SHIFT, 153);
}
void Cego::loadParser45()
{
   _actionMap[749][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[749][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[749][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[749][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[749][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[749][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[749][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[749][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[749][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[749][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[749][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[749][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[749][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[749][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[749][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[749][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[749][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[749][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[749][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[749][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[749][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[749][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[749][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[749][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[749][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[749][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[749][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[749][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[749][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[749][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[749][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[749][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[749][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[749][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[749][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[749][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[749][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[749][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[749][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[749][LB] = ActionEntry(SHIFT, 178);
   _actionMap[749][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[749][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[749][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[749][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[749][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[749][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[749][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[749][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[749][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[749][VARREF] = ActionEntry(SHIFT, 422);
}
void Cego::loadParser46()
{
   _actionMap[749][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[749][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[749][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[749][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[749][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[749][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[749][IF] = ActionEntry(SHIFT, 416);
   _actionMap[749][BEGIN] = ActionEntry(SHIFT, 413);
   _actionMap[749][UNLOCK] = ActionEntry(SHIFT, 28);
   _actionMap[749][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[749][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[749][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[749][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[749][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[749][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[749][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[749][VAR] = ActionEntry(SHIFT, 420);
   _actionMap[749][CURSOR] = ActionEntry(SHIFT, 415);
   _actionMap[749][CLOSE] = ActionEntry(SHIFT, 414);
   _actionMap[749][NOOP] = ActionEntry(SHIFT, 417);
   _actionMap[749][THROW] = ActionEntry(SHIFT, 419);
   _actionMap[749][RETURNTOKEN] = ActionEntry(SHIFT, 418);
   _actionMap[749][WHILE] = ActionEntry(SHIFT, 421);
   _jumpMap[749][ObjSpec] = 122;
   _jumpMap[749][Constant] = 121;
   _jumpMap[749][SignedFloat] = 120;
   _jumpMap[749][SignedInt] = 119;
   _jumpMap[749][Attribute] = 118;
   _jumpMap[749][Function] = 117;
   _jumpMap[749][Factor] = 116;
   _jumpMap[749][Term] = 115;
   _jumpMap[749][Expr] = 412;
   _jumpMap[749][ProcStatement] = 411;
   _jumpMap[749][ProcIfPart] = 410;
   _jumpMap[749][ProcBlockStart] = 409;
   _jumpMap[749][ProcStatementList] = 408;
   _jumpMap[749][ProcStmtBlock] = 817;
   _jumpMap[749][DeleteStatement] = 406;
   _jumpMap[749][UpdateStatement] = 405;
   _jumpMap[749][InsertStatement] = 404;
   _jumpMap[749][UnlockStatement] = 403;
   _jumpMap[749][LockStatement] = 402;
   _jumpMap[749][RollbackStatement] = 401;
   _jumpMap[749][CommitStatement] = 400;
   _jumpMap[749][StartStatement] = 399;
   _jumpMap[749][CasePrepare] = 113;
   _jumpMap[749][CaseClause] = 112;
   _actionMap[750][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[750][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[750][CONCAT] = ActionEntry(SHIFT, 285);
}
void Cego::loadParser47()
{
   _actionMap[750][SEMICOLON] = ActionEntry(REDUCE, 257);
   _actionMap[751][LB] = ActionEntry(SHIFT, 818);
   _actionMap[752][IDENTIFIER] = ActionEntry(SHIFT, 821);
   _jumpMap[752][AliasAttr] = 820;
   _jumpMap[752][AliasAttrList] = 819;
   _actionMap[753][IDENTIFIER] = ActionEntry(SHIFT, 824);
   _jumpMap[753][SimpleAttr] = 823;
   _jumpMap[753][SimpleAttrList] = 822;
   _actionMap[754][IDENTIFIER] = ActionEntry(SHIFT, 588);
   _jumpMap[754][ProcArg] = 825;
   _actionMap[755][BEGIN] = ActionEntry(REDUCE, 241);
   _actionMap[756][INT] = ActionEntry(SHIFT, 744);
   _actionMap[756][LONG] = ActionEntry(SHIFT, 745);
   _actionMap[756][STRING] = ActionEntry(SHIFT, 747);
   _actionMap[756][DATETIME] = ActionEntry(SHIFT, 740);
   _actionMap[756][BOOL] = ActionEntry(SHIFT, 738);
   _actionMap[756][BIGINT] = ActionEntry(SHIFT, 736);
   _actionMap[756][FLOAT] = ActionEntry(SHIFT, 743);
   _actionMap[756][DOUBLE] = ActionEntry(SHIFT, 742);
   _actionMap[756][SMALLINT] = ActionEntry(SHIFT, 746);
   _actionMap[756][TINYINT] = ActionEntry(SHIFT, 748);
   _actionMap[756][DECIMAL] = ActionEntry(SHIFT, 741);
   _actionMap[756][BLOB] = ActionEntry(SHIFT, 737);
   _actionMap[756][CLOB] = ActionEntry(SHIFT, 739);
   _jumpMap[756][DataTypeProd] = 826;
   _actionMap[757][INT] = ActionEntry(SHIFT, 744);
   _actionMap[757][LONG] = ActionEntry(SHIFT, 745);
   _actionMap[757][STRING] = ActionEntry(SHIFT, 747);
   _actionMap[757][DATETIME] = ActionEntry(SHIFT, 740);
   _actionMap[757][BOOL] = ActionEntry(SHIFT, 738);
   _actionMap[757][BIGINT] = ActionEntry(SHIFT, 736);
   _actionMap[757][FLOAT] = ActionEntry(SHIFT, 743);
   _actionMap[757][DOUBLE] = ActionEntry(SHIFT, 742);
   _actionMap[757][SMALLINT] = ActionEntry(SHIFT, 746);
   _actionMap[757][TINYINT] = ActionEntry(SHIFT, 748);
   _actionMap[757][DECIMAL] = ActionEntry(SHIFT, 741);
   _actionMap[757][BLOB] = ActionEntry(SHIFT, 737);
   _actionMap[757][CLOB] = ActionEntry(SHIFT, 739);
   _jumpMap[757][DataTypeProd] = 827;
   _actionMap[758][INT] = ActionEntry(SHIFT, 744);
   _actionMap[758][LONG] = ActionEntry(SHIFT, 745);
   _actionMap[758][STRING] = ActionEntry(SHIFT, 747);
   _actionMap[758][DATETIME] = ActionEntry(SHIFT, 740);
   _actionMap[758][BOOL] = ActionEntry(SHIFT, 738);
   _actionMap[758][BIGINT] = ActionEntry(SHIFT, 736);
   _actionMap[758][FLOAT] = ActionEntry(SHIFT, 743);
   _actionMap[758][DOUBLE] = ActionEntry(SHIFT, 742);
   _actionMap[758][SMALLINT] = ActionEntry(SHIFT, 746);
   _actionMap[758][TINYINT] = ActionEntry(SHIFT, 748);
   _actionMap[758][DECIMAL] = ActionEntry(SHIFT, 741);
}
void Cego::loadParser48()
{
   _actionMap[758][BLOB] = ActionEntry(SHIFT, 737);
   _actionMap[758][CLOB] = ActionEntry(SHIFT, 739);
   _jumpMap[758][DataTypeProd] = 828;
   _actionMap[759][IDENTIFIER] = ActionEntry(SHIFT, 593);
   _actionMap[759][PRIMARY] = ActionEntry(SHIFT, 592);
   _jumpMap[759][ColumnDesc] = 591;
   _jumpMap[759][KeyColumn] = 829;
   _actionMap[760][SEMICOLON] = ActionEntry(REDUCE, 64);
   _actionMap[761][KSEP] = ActionEntry(REDUCE, 118);
   _actionMap[761][RB] = ActionEntry(REDUCE, 118);
   _actionMap[762][RB] = ActionEntry(REDUCE, 127);
   _actionMap[762][SEMICOLON] = ActionEntry(REDUCE, 127);
   _actionMap[762][KSEP] = ActionEntry(REDUCE, 127);
   _actionMap[762][NOT] = ActionEntry(REDUCE, 127);
   _actionMap[762][NULLTOKEN] = ActionEntry(REDUCE, 127);
   _actionMap[762][DEFAULT] = ActionEntry(SHIFT, 832);
   _jumpMap[762][DefaultDefOpt] = 831;
   _jumpMap[762][DefaultOpt] = 830;
   _actionMap[763][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[763][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[763][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[763][ObjSpec] = 833;
   _actionMap[764][INSERT] = ActionEntry(SHIFT, 597);
   _actionMap[764][UPDATE] = ActionEntry(SHIFT, 598);
   _actionMap[764][DELETETOK] = ActionEntry(SHIFT, 596);
   _jumpMap[764][TriggerOp] = 834;
   _actionMap[765][LB] = ActionEntry(SHIFT, 603);
   _jumpMap[765][InsertValueSpec] = 835;
   _actionMap[766][RB] = ActionEntry(SHIFT, 837);
   _actionMap[766][KSEP] = ActionEntry(SHIFT, 836);
   _actionMap[767][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[767][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[767][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[767][KSEP] = ActionEntry(REDUCE, 153);
   _actionMap[767][RB] = ActionEntry(REDUCE, 153);
   _actionMap[768][IDENTIFIER] = ActionEntry(SHIFT, 838);
   _actionMap[769][SELECT] = ActionEntry(REDUCE, 144);
   _actionMap[769][VALUES] = ActionEntry(REDUCE, 144);
   _actionMap[770][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[770][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[770][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[770][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[770][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[770][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[770][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[770][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[770][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[770][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[770][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[770][DATE2LONG] = ActionEntry(SHIFT, 139);
}
void Cego::loadParser49()
{
   _actionMap[770][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[770][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[770][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[770][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[770][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[770][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[770][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[770][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[770][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[770][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[770][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[770][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[770][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[770][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[770][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[770][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[770][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[770][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[770][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[770][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[770][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[770][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[770][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[770][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[770][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[770][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[770][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[770][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[770][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[770][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[770][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[770][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[770][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[770][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[770][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[770][LB] = ActionEntry(SHIFT, 178);
   _actionMap[770][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[770][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[770][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[770][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[770][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[770][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[770][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[770][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[770][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[770][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[770][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[770][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[770][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[770][AVG] = ActionEntry(SHIFT, 125);
}
void Cego::loadParser50()
{
   _actionMap[770][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[770][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[770][ObjSpec] = 122;
   _jumpMap[770][Constant] = 121;
   _jumpMap[770][SignedFloat] = 120;
   _jumpMap[770][SignedInt] = 119;
   _jumpMap[770][Attribute] = 118;
   _jumpMap[770][Function] = 117;
   _jumpMap[770][Factor] = 116;
   _jumpMap[770][Term] = 115;
   _jumpMap[770][Expr] = 839;
   _jumpMap[770][CasePrepare] = 113;
   _jumpMap[770][CaseClause] = 112;
   _actionMap[771][RB] = ActionEntry(SHIFT, 840);
   _actionMap[772][RB] = ActionEntry(SHIFT, 841);
   _actionMap[772][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[773][LEFT] = ActionEntry(REDUCE, 308);
   _actionMap[773][RIGHT] = ActionEntry(REDUCE, 308);
   _actionMap[773][INNER] = ActionEntry(REDUCE, 308);
   _actionMap[773][JOIN] = ActionEntry(REDUCE, 308);
   _actionMap[773][ENDTOKEN] = ActionEntry(REDUCE, 308);
   _actionMap[773][UNION] = ActionEntry(REDUCE, 308);
   _actionMap[773][ROWLIMIT] = ActionEntry(REDUCE, 308);
   _actionMap[773][ORDER] = ActionEntry(REDUCE, 308);
   _actionMap[773][GROUP] = ActionEntry(REDUCE, 308);
   _actionMap[773][SEMICOLON] = ActionEntry(REDUCE, 308);
   _actionMap[773][RETURNTOKEN] = ActionEntry(REDUCE, 308);
   _actionMap[773][WHERE] = ActionEntry(REDUCE, 308);
   _actionMap[773][RB] = ActionEntry(REDUCE, 308);
   _actionMap[773][BEGIN] = ActionEntry(REDUCE, 308);
   _actionMap[773][THEN] = ActionEntry(REDUCE, 308);
   _actionMap[773][AND] = ActionEntry(REDUCE, 308);
   _actionMap[773][OR] = ActionEntry(REDUCE, 308);
   _actionMap[774][SELECT] = ActionEntry(SHIFT, 34);
   _actionMap[774][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[774][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[774][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[774][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[774][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[774][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[774][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[774][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[774][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[774][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[774][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[774][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[774][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[774][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[774][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[774][UPPER] = ActionEntry(SHIFT, 177);
}
void Cego::loadParser51()
{
   _actionMap[774][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[774][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[774][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[774][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[774][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[774][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[774][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[774][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[774][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[774][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[774][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[774][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[774][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[774][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[774][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[774][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[774][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[774][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[774][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[774][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[774][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[774][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[774][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[774][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[774][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[774][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[774][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[774][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[774][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[774][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[774][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[774][LB] = ActionEntry(SHIFT, 178);
   _actionMap[774][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[774][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[774][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[774][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[774][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[774][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[774][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[774][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[774][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[774][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[774][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[774][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[774][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[774][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[774][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[774][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[774][ObjSpec] = 122;
   _jumpMap[774][Constant] = 121;
}
void Cego::loadParser52()
{
   _jumpMap[774][SignedFloat] = 120;
   _jumpMap[774][SignedInt] = 119;
   _jumpMap[774][Attribute] = 118;
   _jumpMap[774][ExpressionList] = 843;
   _jumpMap[774][Function] = 117;
   _jumpMap[774][Factor] = 116;
   _jumpMap[774][Term] = 115;
   _jumpMap[774][Expr] = 468;
   _jumpMap[774][SelectStatement] = 842;
   _jumpMap[774][CasePrepare] = 113;
   _jumpMap[774][CaseClause] = 112;
   _actionMap[775][LEFT] = ActionEntry(REDUCE, 310);
   _actionMap[775][RIGHT] = ActionEntry(REDUCE, 310);
   _actionMap[775][INNER] = ActionEntry(REDUCE, 310);
   _actionMap[775][JOIN] = ActionEntry(REDUCE, 310);
   _actionMap[775][ENDTOKEN] = ActionEntry(REDUCE, 310);
   _actionMap[775][UNION] = ActionEntry(REDUCE, 310);
   _actionMap[775][ROWLIMIT] = ActionEntry(REDUCE, 310);
   _actionMap[775][ORDER] = ActionEntry(REDUCE, 310);
   _actionMap[775][GROUP] = ActionEntry(REDUCE, 310);
   _actionMap[775][SEMICOLON] = ActionEntry(REDUCE, 310);
   _actionMap[775][RETURNTOKEN] = ActionEntry(REDUCE, 310);
   _actionMap[775][WHERE] = ActionEntry(REDUCE, 310);
   _actionMap[775][RB] = ActionEntry(REDUCE, 310);
   _actionMap[775][BEGIN] = ActionEntry(REDUCE, 310);
   _actionMap[775][THEN] = ActionEntry(REDUCE, 310);
   _actionMap[775][AND] = ActionEntry(REDUCE, 310);
   _actionMap[775][OR] = ActionEntry(REDUCE, 310);
   _actionMap[776][LEFT] = ActionEntry(REDUCE, 312);
   _actionMap[776][RIGHT] = ActionEntry(REDUCE, 312);
   _actionMap[776][INNER] = ActionEntry(REDUCE, 312);
   _actionMap[776][JOIN] = ActionEntry(REDUCE, 312);
   _actionMap[776][ENDTOKEN] = ActionEntry(REDUCE, 312);
   _actionMap[776][UNION] = ActionEntry(REDUCE, 312);
   _actionMap[776][ROWLIMIT] = ActionEntry(REDUCE, 312);
   _actionMap[776][ORDER] = ActionEntry(REDUCE, 312);
   _actionMap[776][GROUP] = ActionEntry(REDUCE, 312);
   _actionMap[776][SEMICOLON] = ActionEntry(REDUCE, 312);
   _actionMap[776][RETURNTOKEN] = ActionEntry(REDUCE, 312);
   _actionMap[776][WHERE] = ActionEntry(REDUCE, 312);
   _actionMap[776][RB] = ActionEntry(REDUCE, 312);
   _actionMap[776][BEGIN] = ActionEntry(REDUCE, 312);
   _actionMap[776][THEN] = ActionEntry(REDUCE, 312);
   _actionMap[776][AND] = ActionEntry(REDUCE, 312);
   _actionMap[776][OR] = ActionEntry(REDUCE, 312);
   _actionMap[777][LEFT] = ActionEntry(REDUCE, 300);
   _actionMap[777][RIGHT] = ActionEntry(REDUCE, 300);
   _actionMap[777][INNER] = ActionEntry(REDUCE, 300);
   _actionMap[777][JOIN] = ActionEntry(REDUCE, 300);
   _actionMap[777][ENDTOKEN] = ActionEntry(REDUCE, 300);
}
void Cego::loadParser53()
{
   _actionMap[777][UNION] = ActionEntry(REDUCE, 300);
   _actionMap[777][ROWLIMIT] = ActionEntry(REDUCE, 300);
   _actionMap[777][ORDER] = ActionEntry(REDUCE, 300);
   _actionMap[777][GROUP] = ActionEntry(REDUCE, 300);
   _actionMap[777][SEMICOLON] = ActionEntry(REDUCE, 300);
   _actionMap[777][RETURNTOKEN] = ActionEntry(REDUCE, 300);
   _actionMap[777][WHERE] = ActionEntry(REDUCE, 300);
   _actionMap[777][RB] = ActionEntry(REDUCE, 300);
   _actionMap[777][BEGIN] = ActionEntry(REDUCE, 300);
   _actionMap[777][THEN] = ActionEntry(REDUCE, 300);
   _actionMap[777][AND] = ActionEntry(REDUCE, 300);
   _actionMap[777][OR] = ActionEntry(REDUCE, 300);
   _actionMap[778][WHEN] = ActionEntry(REDUCE, 109);
   _actionMap[778][ELSE] = ActionEntry(REDUCE, 109);
   _actionMap[778][LEFT] = ActionEntry(REDUCE, 109);
   _actionMap[778][RIGHT] = ActionEntry(REDUCE, 109);
   _actionMap[778][INNER] = ActionEntry(REDUCE, 109);
   _actionMap[778][JOIN] = ActionEntry(REDUCE, 109);
   _actionMap[778][ORDER] = ActionEntry(REDUCE, 109);
   _actionMap[778][GROUP] = ActionEntry(REDUCE, 109);
   _actionMap[778][RETURNTOKEN] = ActionEntry(REDUCE, 109);
   _actionMap[778][WHERE] = ActionEntry(REDUCE, 109);
   _actionMap[778][FROM] = ActionEntry(REDUCE, 109);
   _actionMap[778][AS] = ActionEntry(REDUCE, 109);
   _actionMap[778][END_TOKEN] = ActionEntry(REDUCE, 109);
   _actionMap[778][BEGIN] = ActionEntry(REDUCE, 109);
   _actionMap[778][THEN] = ActionEntry(REDUCE, 109);
   _actionMap[778][AND] = ActionEntry(REDUCE, 109);
   _actionMap[778][OR] = ActionEntry(REDUCE, 109);
   _actionMap[778][INTOK] = ActionEntry(REDUCE, 109);
   _actionMap[778][NOT] = ActionEntry(REDUCE, 109);
   _actionMap[778][MT] = ActionEntry(REDUCE, 109);
   _actionMap[778][LT] = ActionEntry(REDUCE, 109);
   _actionMap[778][NEGATION] = ActionEntry(REDUCE, 109);
   _actionMap[778][EQU] = ActionEntry(REDUCE, 109);
   _actionMap[778][BETWEEN] = ActionEntry(REDUCE, 109);
   _actionMap[778][IS] = ActionEntry(REDUCE, 109);
   _actionMap[778][LIKE] = ActionEntry(REDUCE, 109);
   _actionMap[778][NCLIKE] = ActionEntry(REDUCE, 109);
   _actionMap[778][RB] = ActionEntry(REDUCE, 109);
   _actionMap[778][ENDTOKEN] = ActionEntry(REDUCE, 109);
   _actionMap[778][UNION] = ActionEntry(REDUCE, 109);
   _actionMap[778][ROWLIMIT] = ActionEntry(REDUCE, 109);
   _actionMap[778][KSEP] = ActionEntry(REDUCE, 109);
   _actionMap[778][ASC] = ActionEntry(REDUCE, 109);
   _actionMap[778][DESC] = ActionEntry(REDUCE, 109);
   _actionMap[778][PLUS] = ActionEntry(REDUCE, 109);
   _actionMap[778][MINUS] = ActionEntry(REDUCE, 109);
   _actionMap[778][DIVISION] = ActionEntry(REDUCE, 109);
   _actionMap[778][STAR] = ActionEntry(REDUCE, 109);
}
void Cego::loadParser54()
{
   _actionMap[778][CONCAT] = ActionEntry(REDUCE, 109);
   _actionMap[778][SEMICOLON] = ActionEntry(REDUCE, 109);
   _actionMap[779][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[779][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[779][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[779][WHEN] = ActionEntry(REDUCE, 112);
   _actionMap[779][ELSE] = ActionEntry(REDUCE, 112);
   _actionMap[780][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[780][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[780][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[780][KSEP] = ActionEntry(REDUCE, 379);
   _actionMap[780][RB] = ActionEntry(REDUCE, 379);
   _actionMap[781][RB] = ActionEntry(SHIFT, 845);
   _actionMap[781][KSEP] = ActionEntry(SHIFT, 844);
   _actionMap[782][KSEP] = ActionEntry(REDUCE, 115);
   _actionMap[782][RB] = ActionEntry(REDUCE, 115);
   _actionMap[783][RB] = ActionEntry(SHIFT, 846);
   _actionMap[783][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[783][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[783][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[784][SEMICOLON] = ActionEntry(REDUCE, 207);
   _actionMap[784][RB] = ActionEntry(REDUCE, 207);
   _actionMap[784][ENDTOKEN] = ActionEntry(REDUCE, 207);
   _actionMap[784][UNION] = ActionEntry(REDUCE, 207);
   _actionMap[784][ROWLIMIT] = ActionEntry(REDUCE, 207);
   _actionMap[784][ORDER] = ActionEntry(SHIFT, 849);
   _jumpMap[784][NoOrdering] = 848;
   _jumpMap[784][OrderingClause] = 847;
   _actionMap[785][ORDER] = ActionEntry(REDUCE, 198);
   _actionMap[785][ROWLIMIT] = ActionEntry(REDUCE, 198);
   _actionMap[785][UNION] = ActionEntry(REDUCE, 198);
   _actionMap[785][ENDTOKEN] = ActionEntry(REDUCE, 198);
   _actionMap[785][RB] = ActionEntry(REDUCE, 198);
   _actionMap[785][SEMICOLON] = ActionEntry(REDUCE, 198);
   _actionMap[786][BY] = ActionEntry(SHIFT, 850);
   _actionMap[787][LEFT] = ActionEntry(REDUCE, 193);
   _actionMap[787][RIGHT] = ActionEntry(REDUCE, 193);
   _actionMap[787][INNER] = ActionEntry(REDUCE, 193);
   _actionMap[787][JOIN] = ActionEntry(REDUCE, 193);
   _actionMap[787][RB] = ActionEntry(REDUCE, 193);
   _actionMap[787][ENDTOKEN] = ActionEntry(REDUCE, 193);
   _actionMap[787][UNION] = ActionEntry(REDUCE, 193);
   _actionMap[787][ROWLIMIT] = ActionEntry(REDUCE, 193);
   _actionMap[787][ORDER] = ActionEntry(REDUCE, 193);
   _actionMap[787][GROUP] = ActionEntry(REDUCE, 193);
   _actionMap[787][SEMICOLON] = ActionEntry(REDUCE, 193);
   _actionMap[787][RETURNTOKEN] = ActionEntry(REDUCE, 193);
   _actionMap[787][WHERE] = ActionEntry(REDUCE, 193);
   _actionMap[787][ON] = ActionEntry(REDUCE, 193);
   _actionMap[788][ON] = ActionEntry(SHIFT, 851);
}
void Cego::loadParser55()
{
   _actionMap[788][LEFT] = ActionEntry(REDUCE, 181);
   _actionMap[788][RIGHT] = ActionEntry(REDUCE, 181);
   _actionMap[788][INNER] = ActionEntry(REDUCE, 181);
   _actionMap[788][JOIN] = ActionEntry(REDUCE, 181);
   _actionMap[788][RB] = ActionEntry(REDUCE, 181);
   _actionMap[788][ENDTOKEN] = ActionEntry(REDUCE, 181);
   _actionMap[788][UNION] = ActionEntry(REDUCE, 181);
   _actionMap[788][ROWLIMIT] = ActionEntry(REDUCE, 181);
   _actionMap[788][ORDER] = ActionEntry(REDUCE, 181);
   _actionMap[788][GROUP] = ActionEntry(REDUCE, 181);
   _actionMap[788][SEMICOLON] = ActionEntry(REDUCE, 181);
   _actionMap[788][RETURNTOKEN] = ActionEntry(REDUCE, 181);
   _actionMap[788][WHERE] = ActionEntry(REDUCE, 181);
   _actionMap[789][IDENTIFIER] = ActionEntry(REDUCE, 187);
   _actionMap[789][QUALIFIEDOBJ] = ActionEntry(REDUCE, 187);
   _actionMap[789][QUALIFIEDTS] = ActionEntry(REDUCE, 187);
   _actionMap[790][JOIN] = ActionEntry(SHIFT, 852);
   _actionMap[791][JOIN] = ActionEntry(SHIFT, 853);
   _actionMap[792][RB] = ActionEntry(REDUCE, 189);
   _actionMap[792][ENDTOKEN] = ActionEntry(REDUCE, 189);
   _actionMap[792][UNION] = ActionEntry(REDUCE, 189);
   _actionMap[792][ROWLIMIT] = ActionEntry(REDUCE, 189);
   _actionMap[792][ORDER] = ActionEntry(REDUCE, 189);
   _actionMap[792][GROUP] = ActionEntry(REDUCE, 189);
   _actionMap[792][SEMICOLON] = ActionEntry(REDUCE, 189);
   _actionMap[792][RETURNTOKEN] = ActionEntry(REDUCE, 189);
   _actionMap[792][WHERE] = ActionEntry(REDUCE, 189);
   _actionMap[793][KSEP] = ActionEntry(SHIFT, 702);
   _actionMap[793][RB] = ActionEntry(REDUCE, 190);
   _actionMap[793][ENDTOKEN] = ActionEntry(REDUCE, 190);
   _actionMap[793][UNION] = ActionEntry(REDUCE, 190);
   _actionMap[793][ROWLIMIT] = ActionEntry(REDUCE, 190);
   _actionMap[793][ORDER] = ActionEntry(REDUCE, 190);
   _actionMap[793][GROUP] = ActionEntry(REDUCE, 190);
   _actionMap[793][SEMICOLON] = ActionEntry(REDUCE, 190);
   _actionMap[793][RETURNTOKEN] = ActionEntry(REDUCE, 190);
   _actionMap[793][WHERE] = ActionEntry(REDUCE, 190);
   _actionMap[794][SEMICOLON] = ActionEntry(REDUCE, 154);
   _actionMap[795][SEMICOLON] = ActionEntry(REDUCE, 160);
   _actionMap[796][ON] = ActionEntry(SHIFT, 856);
   _actionMap[796][VARREF] = ActionEntry(SHIFT, 857);
   _jumpMap[796][ReturnVar] = 855;
   _jumpMap[796][ReturnVarList] = 854;
   _actionMap[797][KSEP] = ActionEntry(REDUCE, 155);
   _actionMap[797][WHERE] = ActionEntry(REDUCE, 155);
   _actionMap[797][RETURNTOKEN] = ActionEntry(REDUCE, 155);
   _actionMap[797][SEMICOLON] = ActionEntry(REDUCE, 155);
   _actionMap[797][GROUP] = ActionEntry(REDUCE, 155);
   _actionMap[797][ORDER] = ActionEntry(REDUCE, 155);
   _actionMap[797][ROWLIMIT] = ActionEntry(REDUCE, 155);
}
void Cego::loadParser56()
{
   _actionMap[797][UNION] = ActionEntry(REDUCE, 155);
   _actionMap[797][ENDTOKEN] = ActionEntry(REDUCE, 155);
   _actionMap[797][RB] = ActionEntry(REDUCE, 155);
   _actionMap[798][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[798][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[798][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[798][KSEP] = ActionEntry(REDUCE, 157);
   _actionMap[798][WHERE] = ActionEntry(REDUCE, 157);
   _actionMap[798][RETURNTOKEN] = ActionEntry(REDUCE, 157);
   _actionMap[798][SEMICOLON] = ActionEntry(REDUCE, 157);
   _actionMap[798][GROUP] = ActionEntry(REDUCE, 157);
   _actionMap[798][ORDER] = ActionEntry(REDUCE, 157);
   _actionMap[798][ROWLIMIT] = ActionEntry(REDUCE, 157);
   _actionMap[798][UNION] = ActionEntry(REDUCE, 157);
   _actionMap[798][ENDTOKEN] = ActionEntry(REDUCE, 157);
   _actionMap[798][RB] = ActionEntry(REDUCE, 157);
   _actionMap[799][RB] = ActionEntry(SHIFT, 800);
   _actionMap[800][SEMICOLON] = ActionEntry(REDUCE, 63);
   _actionMap[553][DROP] = ActionEntry(SHIFT, 391);
   _actionMap[553][ADD] = ActionEntry(SHIFT, 712);
   _actionMap[553][MODIFY] = ActionEntry(SHIFT, 392);
   _actionMap[553][RENAME] = ActionEntry(SHIFT, 393);
   _jumpMap[553][AlterOption] = 389;
   _jumpMap[553][AlterList] = 711;
   _actionMap[554][IDENTIFIER] = ActionEntry(SHIFT, 713);
   _actionMap[555][IDENTIFIER] = ActionEntry(SHIFT, 593);
   _jumpMap[555][ColumnDesc] = 714;
   _actionMap[556][KEY] = ActionEntry(SHIFT, 715);
   _actionMap[557][IDENTIFIER] = ActionEntry(SHIFT, 716);
   _actionMap[558][IDENTIFIER] = ActionEntry(SHIFT, 718);
   _jumpMap[558][ColumnDesc] = 717;
   _actionMap[559][IDENTIFIER] = ActionEntry(SHIFT, 719);
   _actionMap[560][FOR] = ActionEntry(SHIFT, 720);
   _actionMap[561][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[561][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[561][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[561][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[561][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[561][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[561][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[561][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[561][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[561][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[561][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[561][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[561][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[561][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[561][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[561][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[561][LEFT] = ActionEntry(SHIFT, 148);
}
void Cego::loadParser57()
{
   _actionMap[561][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[561][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[561][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[561][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[561][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[561][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[561][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[561][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[561][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[561][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[561][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[561][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[561][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[561][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[561][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[561][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[561][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[561][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[561][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[561][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[561][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[561][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[561][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[561][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[561][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[561][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[561][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[561][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[561][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[561][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[561][LB] = ActionEntry(SHIFT, 178);
   _actionMap[561][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[561][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[561][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[561][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[561][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[561][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[561][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[561][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[561][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[561][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[561][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[561][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[561][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[561][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[561][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[561][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[561][ObjSpec] = 122;
   _jumpMap[561][Constant] = 121;
   _jumpMap[561][SignedFloat] = 120;
}
void Cego::loadParser58()
{
   _jumpMap[561][SignedInt] = 119;
   _jumpMap[561][Attribute] = 118;
   _jumpMap[561][Function] = 117;
   _jumpMap[561][Factor] = 116;
   _jumpMap[561][Term] = 115;
   _jumpMap[561][Expr] = 721;
   _jumpMap[561][CasePrepare] = 113;
   _jumpMap[561][CaseClause] = 112;
   _actionMap[562][SEMICOLON] = ActionEntry(REDUCE, 100);
   _actionMap[563][ELSE] = ActionEntry(REDUCE, 251);
   _actionMap[563][ELSIF] = ActionEntry(REDUCE, 251);
   _actionMap[563][END_TOKEN] = ActionEntry(REDUCE, 251);
   _actionMap[563][EXCEPTION] = ActionEntry(SHIFT, 723);
   _jumpMap[563][ProcExceptionStmt] = 722;
   _actionMap[564][SEMICOLON] = ActionEntry(SHIFT, 724);
   _actionMap[565][END_TOKEN] = ActionEntry(SHIFT, 725);
   _actionMap[566][ELSE] = ActionEntry(SHIFT, 728);
   _actionMap[566][END_TOKEN] = ActionEntry(REDUCE, 290);
   _jumpMap[566][ProcElsePart] = 727;
   _jumpMap[566][ProcElseOpt] = 726;
   _actionMap[567][ELSIF] = ActionEntry(SHIFT, 568);
   _actionMap[567][END_TOKEN] = ActionEntry(REDUCE, 287);
   _actionMap[567][ELSE] = ActionEntry(REDUCE, 287);
   _jumpMap[567][ProcElsIfOpt] = 567;
   _jumpMap[567][ProcElsIfList] = 730;
   _actionMap[568][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[568][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[568][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[568][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[568][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[568][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[568][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[568][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[568][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[568][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[568][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[568][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[568][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[568][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[568][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[568][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[568][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[568][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[568][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[568][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[568][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[568][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[568][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[568][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[568][STR2LONG] = ActionEntry(SHIFT, 173);
}
void Cego::loadParser59()
{
   _actionMap[568][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[568][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[568][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[568][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[568][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[568][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[568][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[568][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[568][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[568][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[568][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[568][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[568][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[568][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[568][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[568][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[568][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[568][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[568][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[568][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[568][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[568][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[568][LB] = ActionEntry(SHIFT, 178);
   _actionMap[568][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[568][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[568][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[568][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[568][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[568][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[568][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[568][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[568][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[568][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[568][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[568][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[568][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[568][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[568][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[568][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[568][EXISTS] = ActionEntry(SHIFT, 277);
   _actionMap[568][NOT] = ActionEntry(SHIFT, 278);
   _jumpMap[568][ObjSpec] = 122;
   _jumpMap[568][Constant] = 121;
   _jumpMap[568][SignedFloat] = 120;
   _jumpMap[568][SignedInt] = 119;
   _jumpMap[568][Attribute] = 118;
   _jumpMap[568][Function] = 117;
   _jumpMap[568][Factor] = 116;
   _jumpMap[568][Term] = 115;
   _jumpMap[568][Expr] = 276;
}
void Cego::loadParser60()
{
   _jumpMap[568][Predicate] = 275;
   _jumpMap[568][Conjunction] = 274;
   _jumpMap[568][Condition] = 732;
   _jumpMap[568][ProcElsIfCondition] = 731;
   _jumpMap[568][CasePrepare] = 113;
   _jumpMap[568][CaseClause] = 112;
   _actionMap[569][EXCEPTION] = ActionEntry(REDUCE, 253);
   _actionMap[569][END_TOKEN] = ActionEntry(REDUCE, 253);
   _actionMap[569][ELSE] = ActionEntry(REDUCE, 253);
   _actionMap[569][ELSIF] = ActionEntry(REDUCE, 253);
   _actionMap[569][VAR] = ActionEntry(REDUCE, 253);
   _actionMap[569][CURSOR] = ActionEntry(REDUCE, 253);
   _actionMap[569][CLOSE] = ActionEntry(REDUCE, 253);
   _actionMap[569][VARREF] = ActionEntry(REDUCE, 253);
   _actionMap[569][NOOP] = ActionEntry(REDUCE, 253);
   _actionMap[569][THROW] = ActionEntry(REDUCE, 253);
   _actionMap[569][RETURNTOKEN] = ActionEntry(REDUCE, 253);
   _actionMap[569][WHILE] = ActionEntry(REDUCE, 253);
   _actionMap[569][IF] = ActionEntry(REDUCE, 253);
   _actionMap[569][BEGIN] = ActionEntry(REDUCE, 253);
   _actionMap[569][UNLOCK] = ActionEntry(REDUCE, 253);
   _actionMap[569][LOCK] = ActionEntry(REDUCE, 253);
   _actionMap[569][ROLLBACK] = ActionEntry(REDUCE, 253);
   _actionMap[569][COMMIT] = ActionEntry(REDUCE, 253);
   _actionMap[569][START_TOKEN] = ActionEntry(REDUCE, 253);
   _actionMap[569][UPDATE] = ActionEntry(REDUCE, 253);
   _actionMap[569][DELETETOK] = ActionEntry(REDUCE, 253);
   _actionMap[569][INSERT] = ActionEntry(REDUCE, 253);
   _actionMap[569][FETCH] = ActionEntry(REDUCE, 253);
   _actionMap[569][LB] = ActionEntry(REDUCE, 253);
   _actionMap[569][COUNT] = ActionEntry(REDUCE, 253);
   _actionMap[569][SUM] = ActionEntry(REDUCE, 253);
   _actionMap[569][AVG] = ActionEntry(REDUCE, 253);
   _actionMap[569][MIN] = ActionEntry(REDUCE, 253);
   _actionMap[569][MAX] = ActionEntry(REDUCE, 253);
   _actionMap[569][CASE] = ActionEntry(REDUCE, 253);
   _actionMap[569][INT2ASC] = ActionEntry(REDUCE, 253);
   _actionMap[569][ASC2INT] = ActionEntry(REDUCE, 253);
   _actionMap[569][TRIM] = ActionEntry(REDUCE, 253);
   _actionMap[569][RTRIM] = ActionEntry(REDUCE, 253);
   _actionMap[569][LTRIM] = ActionEntry(REDUCE, 253);
   _actionMap[569][ROUND] = ActionEntry(REDUCE, 253);
   _actionMap[569][SCANDATE] = ActionEntry(REDUCE, 253);
   _actionMap[569][DATE2STR] = ActionEntry(REDUCE, 253);
   _actionMap[569][DATE2LONG] = ActionEntry(REDUCE, 253);
   _actionMap[569][LONG2DATE] = ActionEntry(REDUCE, 253);
   _actionMap[569][NEWDATE] = ActionEntry(REDUCE, 253);
   _actionMap[569][LOWER] = ActionEntry(REDUCE, 253);
   _actionMap[569][UPPER] = ActionEntry(REDUCE, 253);
   _actionMap[569][LEFT] = ActionEntry(REDUCE, 253);
}
void Cego::loadParser61()
{
   _actionMap[569][RIGHT] = ActionEntry(REDUCE, 253);
   _actionMap[569][GETPOS] = ActionEntry(REDUCE, 253);
   _actionMap[569][SUBSTR] = ActionEntry(REDUCE, 253);
   _actionMap[569][REPLACE] = ActionEntry(REDUCE, 253);
   _actionMap[569][LENGTH] = ActionEntry(REDUCE, 253);
   _actionMap[569][TRUNC] = ActionEntry(REDUCE, 253);
   _actionMap[569][STR2INT] = ActionEntry(REDUCE, 253);
   _actionMap[569][STR2LONG] = ActionEntry(REDUCE, 253);
   _actionMap[569][RANDSTR] = ActionEntry(REDUCE, 253);
   _actionMap[569][RANDINT] = ActionEntry(REDUCE, 253);
   _actionMap[569][MOD] = ActionEntry(REDUCE, 253);
   _actionMap[569][DIV] = ActionEntry(REDUCE, 253);
   _actionMap[569][LMOD] = ActionEntry(REDUCE, 253);
   _actionMap[569][LDIV] = ActionEntry(REDUCE, 253);
   _actionMap[569][POWER] = ActionEntry(REDUCE, 253);
   _actionMap[569][BITAND] = ActionEntry(REDUCE, 253);
   _actionMap[569][BITOR] = ActionEntry(REDUCE, 253);
   _actionMap[569][BITXOR] = ActionEntry(REDUCE, 253);
   _actionMap[569][BLOBSIZE] = ActionEntry(REDUCE, 253);
   _actionMap[569][BLOBREF] = ActionEntry(REDUCE, 253);
   _actionMap[569][CLOBSIZE] = ActionEntry(REDUCE, 253);
   _actionMap[569][CLOBREF] = ActionEntry(REDUCE, 253);
   _actionMap[569][CLOB2STR] = ActionEntry(REDUCE, 253);
   _actionMap[569][REGMATCH] = ActionEntry(REDUCE, 253);
   _actionMap[569][NEXTCOUNT] = ActionEntry(REDUCE, 253);
   _actionMap[569][SETCOUNT] = ActionEntry(REDUCE, 253);
   _actionMap[569][GETCOUNT] = ActionEntry(REDUCE, 253);
   _actionMap[569][IDENTIFIER] = ActionEntry(REDUCE, 253);
   _actionMap[569][QUALIFIEDOBJ] = ActionEntry(REDUCE, 253);
   _actionMap[569][QUALIFIEDTS] = ActionEntry(REDUCE, 253);
   _actionMap[569][QUALIFIEDPRE] = ActionEntry(REDUCE, 253);
   _actionMap[569][STRINGVAL] = ActionEntry(REDUCE, 253);
   _actionMap[569][SYSDATE] = ActionEntry(REDUCE, 253);
   _actionMap[569][NULLTOKEN] = ActionEntry(REDUCE, 253);
   _actionMap[569][TRUEVAL] = ActionEntry(REDUCE, 253);
   _actionMap[569][FALSEVAL] = ActionEntry(REDUCE, 253);
   _actionMap[569][BLOB] = ActionEntry(REDUCE, 253);
   _actionMap[569][CLOB] = ActionEntry(REDUCE, 253);
   _actionMap[569][FLOATVAL] = ActionEntry(REDUCE, 253);
   _actionMap[569][MINUS] = ActionEntry(REDUCE, 253);
   _actionMap[569][INTVAL] = ActionEntry(REDUCE, 253);
   _actionMap[570][SEMICOLON] = ActionEntry(REDUCE, 256);
   _actionMap[571][AS] = ActionEntry(SHIFT, 733);
   _actionMap[572][THEN] = ActionEntry(SHIFT, 734);
   _actionMap[573][OR] = ActionEntry(SHIFT, 444);
   _actionMap[573][THEN] = ActionEntry(REDUCE, 292);
   _actionMap[574][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[574][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[574][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[574][SEMICOLON] = ActionEntry(REDUCE, 273);
}
void Cego::loadParser62()
{
   _actionMap[575][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[575][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[575][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[575][SEMICOLON] = ActionEntry(REDUCE, 263);
   _actionMap[576][INT] = ActionEntry(SHIFT, 744);
   _actionMap[576][LONG] = ActionEntry(SHIFT, 745);
   _actionMap[576][STRING] = ActionEntry(SHIFT, 747);
   _actionMap[576][DATETIME] = ActionEntry(SHIFT, 740);
   _actionMap[576][BOOL] = ActionEntry(SHIFT, 738);
   _actionMap[576][BIGINT] = ActionEntry(SHIFT, 736);
   _actionMap[576][FLOAT] = ActionEntry(SHIFT, 743);
   _actionMap[576][DOUBLE] = ActionEntry(SHIFT, 742);
   _actionMap[576][SMALLINT] = ActionEntry(SHIFT, 746);
   _actionMap[576][TINYINT] = ActionEntry(SHIFT, 748);
   _actionMap[576][DECIMAL] = ActionEntry(SHIFT, 741);
   _actionMap[576][BLOB] = ActionEntry(SHIFT, 737);
   _actionMap[576][CLOB] = ActionEntry(SHIFT, 739);
   _jumpMap[576][DataTypeProd] = 735;
   _actionMap[577][BEGIN] = ActionEntry(SHIFT, 749);
   _actionMap[578][OR] = ActionEntry(SHIFT, 444);
   _actionMap[578][BEGIN] = ActionEntry(REDUCE, 295);
   _actionMap[579][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[579][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[579][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[579][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[579][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[579][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[579][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[579][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[579][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[579][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[579][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[579][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[579][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[579][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[579][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[579][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[579][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[579][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[579][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[579][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[579][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[579][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[579][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[579][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[579][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[579][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[579][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[579][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[579][DIV] = ActionEntry(SHIFT, 140);
}
void Cego::loadParser63()
{
   _actionMap[579][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[579][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[579][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[579][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[579][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[579][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[579][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[579][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[579][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[579][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[579][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[579][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[579][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[579][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[579][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[579][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[579][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[579][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[579][LB] = ActionEntry(SHIFT, 178);
   _actionMap[579][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[579][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[579][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[579][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[579][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[579][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[579][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[579][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[579][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[579][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[579][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[579][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[579][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[579][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[579][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[579][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[579][ObjSpec] = 122;
   _jumpMap[579][Constant] = 121;
   _jumpMap[579][SignedFloat] = 120;
   _jumpMap[579][SignedInt] = 119;
   _jumpMap[579][Attribute] = 118;
   _jumpMap[579][Function] = 117;
   _jumpMap[579][Factor] = 116;
   _jumpMap[579][Term] = 115;
   _jumpMap[579][Expr] = 750;
   _jumpMap[579][CasePrepare] = 113;
   _jumpMap[579][CaseClause] = 112;
   _actionMap[580][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[580][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[580][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[580][ObjSpec] = 751;
}
void Cego::loadParser64()
{
   _actionMap[581][SEMICOLON] = ActionEntry(REDUCE, 242);
   _actionMap[582][LB] = ActionEntry(SHIFT, 752);
   _actionMap[583][LB] = ActionEntry(SHIFT, 753);
   _actionMap[584][RB] = ActionEntry(SHIFT, 587);
   _actionMap[585][KSEP] = ActionEntry(SHIFT, 754);
   _actionMap[585][RB] = ActionEntry(REDUCE, 245);
   _actionMap[586][KSEP] = ActionEntry(REDUCE, 248);
   _actionMap[586][RB] = ActionEntry(REDUCE, 248);
   _actionMap[587][RETURNTOKEN] = ActionEntry(SHIFT, 756);
   _actionMap[587][BEGIN] = ActionEntry(REDUCE, 244);
   _jumpMap[587][ReturnOpt] = 755;
   _actionMap[588][INTOK] = ActionEntry(SHIFT, 757);
   _actionMap[588][OUTTOK] = ActionEntry(SHIFT, 758);
   _actionMap[589][RB] = ActionEntry(SHIFT, 760);
   _actionMap[589][KSEP] = ActionEntry(SHIFT, 759);
   _actionMap[590][KSEP] = ActionEntry(REDUCE, 117);
   _actionMap[590][RB] = ActionEntry(REDUCE, 117);
   _actionMap[591][KSEP] = ActionEntry(REDUCE, 119);
   _actionMap[591][RB] = ActionEntry(REDUCE, 119);
   _actionMap[592][IDENTIFIER] = ActionEntry(SHIFT, 593);
   _jumpMap[592][ColumnDesc] = 761;
   _actionMap[593][INT] = ActionEntry(SHIFT, 744);
   _actionMap[593][LONG] = ActionEntry(SHIFT, 745);
   _actionMap[593][STRING] = ActionEntry(SHIFT, 747);
   _actionMap[593][DATETIME] = ActionEntry(SHIFT, 740);
   _actionMap[593][BOOL] = ActionEntry(SHIFT, 738);
   _actionMap[593][BIGINT] = ActionEntry(SHIFT, 736);
   _actionMap[593][FLOAT] = ActionEntry(SHIFT, 743);
   _actionMap[593][DOUBLE] = ActionEntry(SHIFT, 742);
   _actionMap[593][SMALLINT] = ActionEntry(SHIFT, 746);
   _actionMap[593][TINYINT] = ActionEntry(SHIFT, 748);
   _actionMap[593][DECIMAL] = ActionEntry(SHIFT, 741);
   _actionMap[593][BLOB] = ActionEntry(SHIFT, 737);
   _actionMap[593][CLOB] = ActionEntry(SHIFT, 739);
   _jumpMap[593][DataTypeProd] = 762;
   _actionMap[594][ON] = ActionEntry(SHIFT, 763);
   _actionMap[594][OR] = ActionEntry(SHIFT, 764);
   _actionMap[595][OR] = ActionEntry(REDUCE, 105);
   _actionMap[595][ON] = ActionEntry(REDUCE, 105);
   _actionMap[596][OR] = ActionEntry(REDUCE, 108);
   _actionMap[596][ON] = ActionEntry(REDUCE, 108);
   _actionMap[597][OR] = ActionEntry(REDUCE, 106);
   _actionMap[597][ON] = ActionEntry(REDUCE, 106);
   _actionMap[598][OR] = ActionEntry(REDUCE, 107);
   _actionMap[598][ON] = ActionEntry(REDUCE, 107);
   _actionMap[599][SEMICOLON] = ActionEntry(REDUCE, 58);
   _actionMap[600][OR] = ActionEntry(SHIFT, 444);
   _actionMap[600][RETURNTOKEN] = ActionEntry(REDUCE, 222);
   _actionMap[600][GROUP] = ActionEntry(REDUCE, 222);
   _actionMap[600][ORDER] = ActionEntry(REDUCE, 222);
}
void Cego::loadParser65()
{
   _actionMap[600][ROWLIMIT] = ActionEntry(REDUCE, 222);
   _actionMap[600][UNION] = ActionEntry(REDUCE, 222);
   _actionMap[600][ENDTOKEN] = ActionEntry(REDUCE, 222);
   _actionMap[600][RB] = ActionEntry(REDUCE, 222);
   _actionMap[600][SEMICOLON] = ActionEntry(REDUCE, 222);
   _actionMap[601][KSEP] = ActionEntry(SHIFT, 765);
   _actionMap[601][SEMICOLON] = ActionEntry(REDUCE, 142);
   _actionMap[602][SEMICOLON] = ActionEntry(REDUCE, 148);
   _actionMap[602][KSEP] = ActionEntry(REDUCE, 148);
   _actionMap[603][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[603][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[603][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[603][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[603][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[603][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[603][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[603][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[603][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[603][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[603][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[603][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[603][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[603][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[603][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[603][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[603][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[603][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[603][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[603][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[603][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[603][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[603][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[603][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[603][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[603][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[603][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[603][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[603][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[603][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[603][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[603][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[603][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[603][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[603][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[603][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[603][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[603][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[603][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[603][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[603][REGMATCH] = ActionEntry(SHIFT, 162);
}
void Cego::loadParser66()
{
   _actionMap[603][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[603][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[603][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[603][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[603][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[603][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[603][LB] = ActionEntry(SHIFT, 178);
   _actionMap[603][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[603][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[603][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[603][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[603][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[603][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[603][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[603][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[603][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[603][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[603][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[603][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[603][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[603][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[603][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[603][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[603][ObjSpec] = 122;
   _jumpMap[603][Constant] = 121;
   _jumpMap[603][SignedFloat] = 120;
   _jumpMap[603][SignedInt] = 119;
   _jumpMap[603][Attribute] = 118;
   _jumpMap[603][Function] = 117;
   _jumpMap[603][Factor] = 116;
   _jumpMap[603][Term] = 115;
   _jumpMap[603][Expr] = 767;
   _jumpMap[603][InsertValueList] = 766;
   _jumpMap[603][CasePrepare] = 113;
   _jumpMap[603][CaseClause] = 112;
   _actionMap[604][RB] = ActionEntry(SHIFT, 769);
   _actionMap[604][KSEP] = ActionEntry(SHIFT, 768);
   _actionMap[605][KSEP] = ActionEntry(REDUCE, 151);
   _actionMap[605][RB] = ActionEntry(REDUCE, 151);
   _actionMap[606][AND] = ActionEntry(SHIFT, 445);
   _actionMap[606][LEFT] = ActionEntry(REDUCE, 296);
   _actionMap[606][RIGHT] = ActionEntry(REDUCE, 296);
   _actionMap[606][INNER] = ActionEntry(REDUCE, 296);
   _actionMap[606][JOIN] = ActionEntry(REDUCE, 296);
   _actionMap[606][ENDTOKEN] = ActionEntry(REDUCE, 296);
   _actionMap[606][UNION] = ActionEntry(REDUCE, 296);
   _actionMap[606][ROWLIMIT] = ActionEntry(REDUCE, 296);
   _actionMap[606][ORDER] = ActionEntry(REDUCE, 296);
   _actionMap[606][GROUP] = ActionEntry(REDUCE, 296);
   _actionMap[606][SEMICOLON] = ActionEntry(REDUCE, 296);
}
void Cego::loadParser67()
{
   _actionMap[606][RETURNTOKEN] = ActionEntry(REDUCE, 296);
   _actionMap[606][WHERE] = ActionEntry(REDUCE, 296);
   _actionMap[606][RB] = ActionEntry(REDUCE, 296);
   _actionMap[606][BEGIN] = ActionEntry(REDUCE, 296);
   _actionMap[606][THEN] = ActionEntry(REDUCE, 296);
   _actionMap[606][OR] = ActionEntry(REDUCE, 296);
   _actionMap[607][LEFT] = ActionEntry(REDUCE, 298);
   _actionMap[607][RIGHT] = ActionEntry(REDUCE, 298);
   _actionMap[607][INNER] = ActionEntry(REDUCE, 298);
   _actionMap[607][JOIN] = ActionEntry(REDUCE, 298);
   _actionMap[607][ENDTOKEN] = ActionEntry(REDUCE, 298);
   _actionMap[607][UNION] = ActionEntry(REDUCE, 298);
   _actionMap[607][ROWLIMIT] = ActionEntry(REDUCE, 298);
   _actionMap[607][ORDER] = ActionEntry(REDUCE, 298);
   _actionMap[607][GROUP] = ActionEntry(REDUCE, 298);
   _actionMap[607][SEMICOLON] = ActionEntry(REDUCE, 298);
   _actionMap[607][RETURNTOKEN] = ActionEntry(REDUCE, 298);
   _actionMap[607][WHERE] = ActionEntry(REDUCE, 298);
   _actionMap[607][RB] = ActionEntry(REDUCE, 298);
   _actionMap[607][BEGIN] = ActionEntry(REDUCE, 298);
   _actionMap[607][THEN] = ActionEntry(REDUCE, 298);
   _actionMap[607][OR] = ActionEntry(REDUCE, 298);
   _actionMap[607][AND] = ActionEntry(REDUCE, 298);
   _actionMap[608][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[608][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[608][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[608][LEFT] = ActionEntry(REDUCE, 305);
   _actionMap[608][RIGHT] = ActionEntry(REDUCE, 305);
   _actionMap[608][INNER] = ActionEntry(REDUCE, 305);
   _actionMap[608][JOIN] = ActionEntry(REDUCE, 305);
   _actionMap[608][ENDTOKEN] = ActionEntry(REDUCE, 305);
   _actionMap[608][UNION] = ActionEntry(REDUCE, 305);
   _actionMap[608][ROWLIMIT] = ActionEntry(REDUCE, 305);
   _actionMap[608][ORDER] = ActionEntry(REDUCE, 305);
   _actionMap[608][GROUP] = ActionEntry(REDUCE, 305);
   _actionMap[608][SEMICOLON] = ActionEntry(REDUCE, 305);
   _actionMap[608][RETURNTOKEN] = ActionEntry(REDUCE, 305);
   _actionMap[608][WHERE] = ActionEntry(REDUCE, 305);
   _actionMap[608][RB] = ActionEntry(REDUCE, 305);
   _actionMap[608][BEGIN] = ActionEntry(REDUCE, 305);
   _actionMap[608][THEN] = ActionEntry(REDUCE, 305);
   _actionMap[608][AND] = ActionEntry(REDUCE, 305);
   _actionMap[608][OR] = ActionEntry(REDUCE, 305);
   _actionMap[609][AND] = ActionEntry(SHIFT, 770);
   _actionMap[609][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[609][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[609][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[610][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[610][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[610][INTVAL] = ActionEntry(SHIFT, 180);
}
void Cego::loadParser68()
{
   _actionMap[610][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[610][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[610][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[610][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[610][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[610][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[610][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[610][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[610][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[610][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[610][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[610][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[610][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[610][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[610][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[610][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[610][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[610][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[610][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[610][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[610][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[610][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[610][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[610][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[610][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[610][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[610][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[610][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[610][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[610][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[610][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[610][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[610][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[610][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[610][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[610][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[610][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[610][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[610][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[610][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[610][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[610][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[610][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[610][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[610][LB] = ActionEntry(SHIFT, 178);
   _actionMap[610][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[610][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[610][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[610][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[610][FALSEVAL] = ActionEntry(SHIFT, 141);
}
void Cego::loadParser69()
{
   _actionMap[610][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[610][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[610][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[610][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[610][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[610][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[610][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[610][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[610][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[610][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[610][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[610][SELECT] = ActionEntry(SHIFT, 34);
   _jumpMap[610][ObjSpec] = 122;
   _jumpMap[610][Constant] = 121;
   _jumpMap[610][SignedFloat] = 120;
   _jumpMap[610][SignedInt] = 119;
   _jumpMap[610][Attribute] = 118;
   _jumpMap[610][ExpressionList] = 772;
   _jumpMap[610][Function] = 117;
   _jumpMap[610][Factor] = 116;
   _jumpMap[610][Term] = 115;
   _jumpMap[610][Expr] = 468;
   _jumpMap[610][SelectStatement] = 771;
   _jumpMap[610][CasePrepare] = 113;
   _jumpMap[610][CaseClause] = 112;
   _actionMap[611][NULLTOKEN] = ActionEntry(SHIFT, 773);
   _actionMap[612][LEFT] = ActionEntry(REDUCE, 307);
   _actionMap[612][RIGHT] = ActionEntry(REDUCE, 307);
   _actionMap[612][INNER] = ActionEntry(REDUCE, 307);
   _actionMap[612][JOIN] = ActionEntry(REDUCE, 307);
   _actionMap[612][ENDTOKEN] = ActionEntry(REDUCE, 307);
   _actionMap[612][UNION] = ActionEntry(REDUCE, 307);
   _actionMap[612][ROWLIMIT] = ActionEntry(REDUCE, 307);
   _actionMap[612][ORDER] = ActionEntry(REDUCE, 307);
   _actionMap[612][GROUP] = ActionEntry(REDUCE, 307);
   _actionMap[612][SEMICOLON] = ActionEntry(REDUCE, 307);
   _actionMap[612][RETURNTOKEN] = ActionEntry(REDUCE, 307);
   _actionMap[612][WHERE] = ActionEntry(REDUCE, 307);
   _actionMap[612][RB] = ActionEntry(REDUCE, 307);
   _actionMap[612][BEGIN] = ActionEntry(REDUCE, 307);
   _actionMap[612][THEN] = ActionEntry(REDUCE, 307);
   _actionMap[612][AND] = ActionEntry(REDUCE, 307);
   _actionMap[612][OR] = ActionEntry(REDUCE, 307);
   _actionMap[613][LEFT] = ActionEntry(REDUCE, 309);
   _actionMap[613][RIGHT] = ActionEntry(REDUCE, 309);
   _actionMap[613][INNER] = ActionEntry(REDUCE, 309);
   _actionMap[613][JOIN] = ActionEntry(REDUCE, 309);
   _actionMap[613][ENDTOKEN] = ActionEntry(REDUCE, 309);
   _actionMap[613][UNION] = ActionEntry(REDUCE, 309);
   _actionMap[613][ROWLIMIT] = ActionEntry(REDUCE, 309);
}
void Cego::loadParser70()
{
   _actionMap[613][ORDER] = ActionEntry(REDUCE, 309);
   _actionMap[613][GROUP] = ActionEntry(REDUCE, 309);
   _actionMap[613][SEMICOLON] = ActionEntry(REDUCE, 309);
   _actionMap[613][RETURNTOKEN] = ActionEntry(REDUCE, 309);
   _actionMap[613][WHERE] = ActionEntry(REDUCE, 309);
   _actionMap[613][RB] = ActionEntry(REDUCE, 309);
   _actionMap[613][BEGIN] = ActionEntry(REDUCE, 309);
   _actionMap[613][THEN] = ActionEntry(REDUCE, 309);
   _actionMap[613][AND] = ActionEntry(REDUCE, 309);
   _actionMap[613][OR] = ActionEntry(REDUCE, 309);
   _actionMap[614][LEFT] = ActionEntry(REDUCE, 311);
   _actionMap[614][RIGHT] = ActionEntry(REDUCE, 311);
   _actionMap[614][INNER] = ActionEntry(REDUCE, 311);
   _actionMap[614][JOIN] = ActionEntry(REDUCE, 311);
   _actionMap[614][ENDTOKEN] = ActionEntry(REDUCE, 311);
   _actionMap[614][UNION] = ActionEntry(REDUCE, 311);
   _actionMap[614][ROWLIMIT] = ActionEntry(REDUCE, 311);
   _actionMap[614][ORDER] = ActionEntry(REDUCE, 311);
   _actionMap[614][GROUP] = ActionEntry(REDUCE, 311);
   _actionMap[614][SEMICOLON] = ActionEntry(REDUCE, 311);
   _actionMap[614][RETURNTOKEN] = ActionEntry(REDUCE, 311);
   _actionMap[614][WHERE] = ActionEntry(REDUCE, 311);
   _actionMap[614][RB] = ActionEntry(REDUCE, 311);
   _actionMap[614][BEGIN] = ActionEntry(REDUCE, 311);
   _actionMap[614][THEN] = ActionEntry(REDUCE, 311);
   _actionMap[614][AND] = ActionEntry(REDUCE, 311);
   _actionMap[614][OR] = ActionEntry(REDUCE, 311);
   _actionMap[615][LB] = ActionEntry(SHIFT, 774);
   _actionMap[616][STRINGVAL] = ActionEntry(SHIFT, 775);
   _actionMap[617][STRINGVAL] = ActionEntry(SHIFT, 776);
   _actionMap[618][VARREF] = ActionEntry(REDUCE, 400);
   _actionMap[618][FETCH] = ActionEntry(REDUCE, 400);
   _actionMap[618][LB] = ActionEntry(REDUCE, 400);
   _actionMap[618][COUNT] = ActionEntry(REDUCE, 400);
   _actionMap[618][SUM] = ActionEntry(REDUCE, 400);
   _actionMap[618][AVG] = ActionEntry(REDUCE, 400);
   _actionMap[618][MIN] = ActionEntry(REDUCE, 400);
   _actionMap[618][MAX] = ActionEntry(REDUCE, 400);
   _actionMap[618][CASE] = ActionEntry(REDUCE, 400);
   _actionMap[618][INT2ASC] = ActionEntry(REDUCE, 400);
   _actionMap[618][ASC2INT] = ActionEntry(REDUCE, 400);
   _actionMap[618][TRIM] = ActionEntry(REDUCE, 400);
   _actionMap[618][RTRIM] = ActionEntry(REDUCE, 400);
   _actionMap[618][LTRIM] = ActionEntry(REDUCE, 400);
   _actionMap[618][ROUND] = ActionEntry(REDUCE, 400);
   _actionMap[618][SCANDATE] = ActionEntry(REDUCE, 400);
   _actionMap[618][DATE2STR] = ActionEntry(REDUCE, 400);
   _actionMap[618][DATE2LONG] = ActionEntry(REDUCE, 400);
   _actionMap[618][LONG2DATE] = ActionEntry(REDUCE, 400);
   _actionMap[618][NEWDATE] = ActionEntry(REDUCE, 400);
}
void Cego::loadParser71()
{
   _actionMap[618][LOWER] = ActionEntry(REDUCE, 400);
   _actionMap[618][UPPER] = ActionEntry(REDUCE, 400);
   _actionMap[618][LEFT] = ActionEntry(REDUCE, 400);
   _actionMap[618][RIGHT] = ActionEntry(REDUCE, 400);
   _actionMap[618][GETPOS] = ActionEntry(REDUCE, 400);
   _actionMap[618][SUBSTR] = ActionEntry(REDUCE, 400);
   _actionMap[618][REPLACE] = ActionEntry(REDUCE, 400);
   _actionMap[618][LENGTH] = ActionEntry(REDUCE, 400);
   _actionMap[618][TRUNC] = ActionEntry(REDUCE, 400);
   _actionMap[618][STR2INT] = ActionEntry(REDUCE, 400);
   _actionMap[618][STR2LONG] = ActionEntry(REDUCE, 400);
   _actionMap[618][RANDSTR] = ActionEntry(REDUCE, 400);
   _actionMap[618][RANDINT] = ActionEntry(REDUCE, 400);
   _actionMap[618][MOD] = ActionEntry(REDUCE, 400);
   _actionMap[618][DIV] = ActionEntry(REDUCE, 400);
   _actionMap[618][LMOD] = ActionEntry(REDUCE, 400);
   _actionMap[618][LDIV] = ActionEntry(REDUCE, 400);
   _actionMap[618][POWER] = ActionEntry(REDUCE, 400);
   _actionMap[618][BITAND] = ActionEntry(REDUCE, 400);
   _actionMap[618][BITOR] = ActionEntry(REDUCE, 400);
   _actionMap[618][BITXOR] = ActionEntry(REDUCE, 400);
   _actionMap[618][BLOBSIZE] = ActionEntry(REDUCE, 400);
   _actionMap[618][BLOBREF] = ActionEntry(REDUCE, 400);
   _actionMap[618][CLOBSIZE] = ActionEntry(REDUCE, 400);
   _actionMap[618][CLOBREF] = ActionEntry(REDUCE, 400);
   _actionMap[618][CLOB2STR] = ActionEntry(REDUCE, 400);
   _actionMap[618][REGMATCH] = ActionEntry(REDUCE, 400);
   _actionMap[618][NEXTCOUNT] = ActionEntry(REDUCE, 400);
   _actionMap[618][SETCOUNT] = ActionEntry(REDUCE, 400);
   _actionMap[618][GETCOUNT] = ActionEntry(REDUCE, 400);
   _actionMap[618][IDENTIFIER] = ActionEntry(REDUCE, 400);
   _actionMap[618][QUALIFIEDOBJ] = ActionEntry(REDUCE, 400);
   _actionMap[618][QUALIFIEDTS] = ActionEntry(REDUCE, 400);
   _actionMap[618][QUALIFIEDPRE] = ActionEntry(REDUCE, 400);
   _actionMap[618][STRINGVAL] = ActionEntry(REDUCE, 400);
   _actionMap[618][SYSDATE] = ActionEntry(REDUCE, 400);
   _actionMap[618][NULLTOKEN] = ActionEntry(REDUCE, 400);
   _actionMap[618][TRUEVAL] = ActionEntry(REDUCE, 400);
   _actionMap[618][FALSEVAL] = ActionEntry(REDUCE, 400);
   _actionMap[618][BLOB] = ActionEntry(REDUCE, 400);
   _actionMap[618][CLOB] = ActionEntry(REDUCE, 400);
   _actionMap[618][FLOATVAL] = ActionEntry(REDUCE, 400);
   _actionMap[618][MINUS] = ActionEntry(REDUCE, 400);
   _actionMap[618][INTVAL] = ActionEntry(REDUCE, 400);
   _actionMap[619][VARREF] = ActionEntry(REDUCE, 401);
   _actionMap[619][FETCH] = ActionEntry(REDUCE, 401);
   _actionMap[619][LB] = ActionEntry(REDUCE, 401);
   _actionMap[619][COUNT] = ActionEntry(REDUCE, 401);
   _actionMap[619][SUM] = ActionEntry(REDUCE, 401);
   _actionMap[619][AVG] = ActionEntry(REDUCE, 401);
}
void Cego::loadParser72()
{
   _actionMap[619][MIN] = ActionEntry(REDUCE, 401);
   _actionMap[619][MAX] = ActionEntry(REDUCE, 401);
   _actionMap[619][CASE] = ActionEntry(REDUCE, 401);
   _actionMap[619][INT2ASC] = ActionEntry(REDUCE, 401);
   _actionMap[619][ASC2INT] = ActionEntry(REDUCE, 401);
   _actionMap[619][TRIM] = ActionEntry(REDUCE, 401);
   _actionMap[619][RTRIM] = ActionEntry(REDUCE, 401);
   _actionMap[619][LTRIM] = ActionEntry(REDUCE, 401);
   _actionMap[619][ROUND] = ActionEntry(REDUCE, 401);
   _actionMap[619][SCANDATE] = ActionEntry(REDUCE, 401);
   _actionMap[619][DATE2STR] = ActionEntry(REDUCE, 401);
   _actionMap[619][DATE2LONG] = ActionEntry(REDUCE, 401);
   _actionMap[619][LONG2DATE] = ActionEntry(REDUCE, 401);
   _actionMap[619][NEWDATE] = ActionEntry(REDUCE, 401);
   _actionMap[619][LOWER] = ActionEntry(REDUCE, 401);
   _actionMap[619][UPPER] = ActionEntry(REDUCE, 401);
   _actionMap[619][LEFT] = ActionEntry(REDUCE, 401);
   _actionMap[619][RIGHT] = ActionEntry(REDUCE, 401);
   _actionMap[619][GETPOS] = ActionEntry(REDUCE, 401);
   _actionMap[619][SUBSTR] = ActionEntry(REDUCE, 401);
   _actionMap[619][REPLACE] = ActionEntry(REDUCE, 401);
   _actionMap[619][LENGTH] = ActionEntry(REDUCE, 401);
   _actionMap[619][TRUNC] = ActionEntry(REDUCE, 401);
   _actionMap[619][STR2INT] = ActionEntry(REDUCE, 401);
   _actionMap[619][STR2LONG] = ActionEntry(REDUCE, 401);
   _actionMap[619][RANDSTR] = ActionEntry(REDUCE, 401);
   _actionMap[619][RANDINT] = ActionEntry(REDUCE, 401);
   _actionMap[619][MOD] = ActionEntry(REDUCE, 401);
   _actionMap[619][DIV] = ActionEntry(REDUCE, 401);
   _actionMap[619][LMOD] = ActionEntry(REDUCE, 401);
   _actionMap[619][LDIV] = ActionEntry(REDUCE, 401);
   _actionMap[619][POWER] = ActionEntry(REDUCE, 401);
   _actionMap[619][BITAND] = ActionEntry(REDUCE, 401);
   _actionMap[619][BITOR] = ActionEntry(REDUCE, 401);
   _actionMap[619][BITXOR] = ActionEntry(REDUCE, 401);
   _actionMap[619][BLOBSIZE] = ActionEntry(REDUCE, 401);
   _actionMap[619][BLOBREF] = ActionEntry(REDUCE, 401);
   _actionMap[619][CLOBSIZE] = ActionEntry(REDUCE, 401);
   _actionMap[619][CLOBREF] = ActionEntry(REDUCE, 401);
   _actionMap[619][CLOB2STR] = ActionEntry(REDUCE, 401);
   _actionMap[619][REGMATCH] = ActionEntry(REDUCE, 401);
   _actionMap[619][NEXTCOUNT] = ActionEntry(REDUCE, 401);
   _actionMap[619][SETCOUNT] = ActionEntry(REDUCE, 401);
   _actionMap[619][GETCOUNT] = ActionEntry(REDUCE, 401);
   _actionMap[619][IDENTIFIER] = ActionEntry(REDUCE, 401);
   _actionMap[619][QUALIFIEDOBJ] = ActionEntry(REDUCE, 401);
   _actionMap[619][QUALIFIEDTS] = ActionEntry(REDUCE, 401);
   _actionMap[619][QUALIFIEDPRE] = ActionEntry(REDUCE, 401);
   _actionMap[619][STRINGVAL] = ActionEntry(REDUCE, 401);
   _actionMap[619][SYSDATE] = ActionEntry(REDUCE, 401);
}
void Cego::loadParser73()
{
   _actionMap[619][NULLTOKEN] = ActionEntry(REDUCE, 401);
   _actionMap[619][TRUEVAL] = ActionEntry(REDUCE, 401);
   _actionMap[619][FALSEVAL] = ActionEntry(REDUCE, 401);
   _actionMap[619][BLOB] = ActionEntry(REDUCE, 401);
   _actionMap[619][CLOB] = ActionEntry(REDUCE, 401);
   _actionMap[619][FLOATVAL] = ActionEntry(REDUCE, 401);
   _actionMap[619][MINUS] = ActionEntry(REDUCE, 401);
   _actionMap[619][INTVAL] = ActionEntry(REDUCE, 401);
   _actionMap[620][VARREF] = ActionEntry(REDUCE, 397);
   _actionMap[620][FETCH] = ActionEntry(REDUCE, 397);
   _actionMap[620][LB] = ActionEntry(REDUCE, 397);
   _actionMap[620][COUNT] = ActionEntry(REDUCE, 397);
   _actionMap[620][SUM] = ActionEntry(REDUCE, 397);
   _actionMap[620][AVG] = ActionEntry(REDUCE, 397);
   _actionMap[620][MIN] = ActionEntry(REDUCE, 397);
   _actionMap[620][MAX] = ActionEntry(REDUCE, 397);
   _actionMap[620][CASE] = ActionEntry(REDUCE, 397);
   _actionMap[620][INT2ASC] = ActionEntry(REDUCE, 397);
   _actionMap[620][ASC2INT] = ActionEntry(REDUCE, 397);
   _actionMap[620][TRIM] = ActionEntry(REDUCE, 397);
   _actionMap[620][RTRIM] = ActionEntry(REDUCE, 397);
   _actionMap[620][LTRIM] = ActionEntry(REDUCE, 397);
   _actionMap[620][ROUND] = ActionEntry(REDUCE, 397);
   _actionMap[620][SCANDATE] = ActionEntry(REDUCE, 397);
   _actionMap[620][DATE2STR] = ActionEntry(REDUCE, 397);
   _actionMap[620][DATE2LONG] = ActionEntry(REDUCE, 397);
   _actionMap[620][LONG2DATE] = ActionEntry(REDUCE, 397);
   _actionMap[620][NEWDATE] = ActionEntry(REDUCE, 397);
   _actionMap[620][LOWER] = ActionEntry(REDUCE, 397);
   _actionMap[620][UPPER] = ActionEntry(REDUCE, 397);
   _actionMap[620][LEFT] = ActionEntry(REDUCE, 397);
   _actionMap[620][RIGHT] = ActionEntry(REDUCE, 397);
   _actionMap[620][GETPOS] = ActionEntry(REDUCE, 397);
   _actionMap[620][SUBSTR] = ActionEntry(REDUCE, 397);
   _actionMap[620][REPLACE] = ActionEntry(REDUCE, 397);
   _actionMap[620][LENGTH] = ActionEntry(REDUCE, 397);
   _actionMap[620][TRUNC] = ActionEntry(REDUCE, 397);
   _actionMap[620][STR2INT] = ActionEntry(REDUCE, 397);
   _actionMap[620][STR2LONG] = ActionEntry(REDUCE, 397);
   _actionMap[620][RANDSTR] = ActionEntry(REDUCE, 397);
   _actionMap[620][RANDINT] = ActionEntry(REDUCE, 397);
   _actionMap[620][MOD] = ActionEntry(REDUCE, 397);
   _actionMap[620][DIV] = ActionEntry(REDUCE, 397);
   _actionMap[620][LMOD] = ActionEntry(REDUCE, 397);
   _actionMap[620][LDIV] = ActionEntry(REDUCE, 397);
   _actionMap[620][POWER] = ActionEntry(REDUCE, 397);
   _actionMap[620][BITAND] = ActionEntry(REDUCE, 397);
   _actionMap[620][BITOR] = ActionEntry(REDUCE, 397);
   _actionMap[620][BITXOR] = ActionEntry(REDUCE, 397);
   _actionMap[620][BLOBSIZE] = ActionEntry(REDUCE, 397);
}
void Cego::loadParser74()
{
   _actionMap[620][BLOBREF] = ActionEntry(REDUCE, 397);
   _actionMap[620][CLOBSIZE] = ActionEntry(REDUCE, 397);
   _actionMap[620][CLOBREF] = ActionEntry(REDUCE, 397);
   _actionMap[620][CLOB2STR] = ActionEntry(REDUCE, 397);
   _actionMap[620][REGMATCH] = ActionEntry(REDUCE, 397);
   _actionMap[620][NEXTCOUNT] = ActionEntry(REDUCE, 397);
   _actionMap[620][SETCOUNT] = ActionEntry(REDUCE, 397);
   _actionMap[620][GETCOUNT] = ActionEntry(REDUCE, 397);
   _actionMap[620][IDENTIFIER] = ActionEntry(REDUCE, 397);
   _actionMap[620][QUALIFIEDOBJ] = ActionEntry(REDUCE, 397);
   _actionMap[620][QUALIFIEDTS] = ActionEntry(REDUCE, 397);
   _actionMap[620][QUALIFIEDPRE] = ActionEntry(REDUCE, 397);
   _actionMap[620][STRINGVAL] = ActionEntry(REDUCE, 397);
   _actionMap[620][SYSDATE] = ActionEntry(REDUCE, 397);
   _actionMap[620][NULLTOKEN] = ActionEntry(REDUCE, 397);
   _actionMap[620][TRUEVAL] = ActionEntry(REDUCE, 397);
   _actionMap[620][FALSEVAL] = ActionEntry(REDUCE, 397);
   _actionMap[620][BLOB] = ActionEntry(REDUCE, 397);
   _actionMap[620][CLOB] = ActionEntry(REDUCE, 397);
   _actionMap[620][FLOATVAL] = ActionEntry(REDUCE, 397);
   _actionMap[620][MINUS] = ActionEntry(REDUCE, 397);
   _actionMap[620][INTVAL] = ActionEntry(REDUCE, 397);
   _actionMap[621][RB] = ActionEntry(SHIFT, 777);
   _actionMap[622][SEMICOLON] = ActionEntry(REDUCE, 59);
   _actionMap[623][END_TOKEN] = ActionEntry(SHIFT, 778);
   _actionMap[623][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[623][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[623][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[624][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[624][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[624][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[624][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[624][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[624][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[624][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[624][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[624][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[624][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[624][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[624][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[624][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[624][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[624][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[624][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[624][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[624][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[624][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[624][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[624][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[624][LENGTH] = ActionEntry(SHIFT, 149);
}
void Cego::loadParser75()
{
   _actionMap[624][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[624][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[624][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[624][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[624][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[624][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[624][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[624][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[624][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[624][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[624][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[624][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[624][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[624][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[624][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[624][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[624][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[624][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[624][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[624][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[624][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[624][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[624][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[624][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[624][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[624][LB] = ActionEntry(SHIFT, 178);
   _actionMap[624][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[624][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[624][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[624][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[624][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[624][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[624][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[624][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[624][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[624][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[624][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[624][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[624][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[624][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[624][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[624][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[624][ObjSpec] = 122;
   _jumpMap[624][Constant] = 121;
   _jumpMap[624][SignedFloat] = 120;
   _jumpMap[624][SignedInt] = 119;
   _jumpMap[624][Attribute] = 118;
   _jumpMap[624][Function] = 117;
   _jumpMap[624][Factor] = 116;
   _jumpMap[624][Term] = 115;
}
void Cego::loadParser76()
{
   _jumpMap[624][Expr] = 779;
   _jumpMap[624][CasePrepare] = 113;
   _jumpMap[624][CaseClause] = 112;
   _actionMap[625][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[625][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[625][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[625][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[625][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[625][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[625][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[625][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[625][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[625][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[625][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[625][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[625][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[625][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[625][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[625][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[625][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[625][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[625][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[625][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[625][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[625][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[625][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[625][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[625][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[625][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[625][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[625][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[625][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[625][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[625][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[625][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[625][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[625][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[625][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[625][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[625][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[625][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[625][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[625][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[625][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[625][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[625][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[625][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[625][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[625][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[625][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
}
void Cego::loadParser77()
{
   _actionMap[625][LB] = ActionEntry(SHIFT, 178);
   _actionMap[625][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[625][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[625][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[625][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[625][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[625][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[625][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[625][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[625][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[625][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[625][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[625][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[625][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[625][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[625][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[625][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[625][ObjSpec] = 122;
   _jumpMap[625][Constant] = 121;
   _jumpMap[625][SignedFloat] = 120;
   _jumpMap[625][SignedInt] = 119;
   _jumpMap[625][Attribute] = 118;
   _jumpMap[625][Function] = 117;
   _jumpMap[625][Factor] = 116;
   _jumpMap[625][Term] = 115;
   _jumpMap[625][Expr] = 780;
   _jumpMap[625][CasePrepare] = 113;
   _jumpMap[625][CaseClause] = 112;
   _actionMap[626][WHEN] = ActionEntry(REDUCE, 377);
   _actionMap[626][ELSE] = ActionEntry(REDUCE, 377);
   _actionMap[626][LEFT] = ActionEntry(REDUCE, 377);
   _actionMap[626][RIGHT] = ActionEntry(REDUCE, 377);
   _actionMap[626][INNER] = ActionEntry(REDUCE, 377);
   _actionMap[626][JOIN] = ActionEntry(REDUCE, 377);
   _actionMap[626][ORDER] = ActionEntry(REDUCE, 377);
   _actionMap[626][GROUP] = ActionEntry(REDUCE, 377);
   _actionMap[626][RETURNTOKEN] = ActionEntry(REDUCE, 377);
   _actionMap[626][WHERE] = ActionEntry(REDUCE, 377);
   _actionMap[626][FROM] = ActionEntry(REDUCE, 377);
   _actionMap[626][AS] = ActionEntry(REDUCE, 377);
   _actionMap[626][END_TOKEN] = ActionEntry(REDUCE, 377);
   _actionMap[626][BEGIN] = ActionEntry(REDUCE, 377);
   _actionMap[626][THEN] = ActionEntry(REDUCE, 377);
   _actionMap[626][AND] = ActionEntry(REDUCE, 377);
   _actionMap[626][OR] = ActionEntry(REDUCE, 377);
   _actionMap[626][INTOK] = ActionEntry(REDUCE, 377);
   _actionMap[626][NOT] = ActionEntry(REDUCE, 377);
   _actionMap[626][MT] = ActionEntry(REDUCE, 377);
   _actionMap[626][LT] = ActionEntry(REDUCE, 377);
   _actionMap[626][NEGATION] = ActionEntry(REDUCE, 377);
}
void Cego::loadParser78()
{
   _actionMap[626][EQU] = ActionEntry(REDUCE, 377);
   _actionMap[626][BETWEEN] = ActionEntry(REDUCE, 377);
   _actionMap[626][IS] = ActionEntry(REDUCE, 377);
   _actionMap[626][LIKE] = ActionEntry(REDUCE, 377);
   _actionMap[626][NCLIKE] = ActionEntry(REDUCE, 377);
   _actionMap[626][RB] = ActionEntry(REDUCE, 377);
   _actionMap[626][ENDTOKEN] = ActionEntry(REDUCE, 377);
   _actionMap[626][UNION] = ActionEntry(REDUCE, 377);
   _actionMap[626][ROWLIMIT] = ActionEntry(REDUCE, 377);
   _actionMap[626][KSEP] = ActionEntry(REDUCE, 377);
   _actionMap[626][ASC] = ActionEntry(REDUCE, 377);
   _actionMap[626][DESC] = ActionEntry(REDUCE, 377);
   _actionMap[626][PLUS] = ActionEntry(REDUCE, 377);
   _actionMap[626][MINUS] = ActionEntry(REDUCE, 377);
   _actionMap[626][DIVISION] = ActionEntry(REDUCE, 377);
   _actionMap[626][STAR] = ActionEntry(REDUCE, 377);
   _actionMap[626][CONCAT] = ActionEntry(REDUCE, 377);
   _actionMap[626][SEMICOLON] = ActionEntry(REDUCE, 377);
   _actionMap[627][WHEN] = ActionEntry(REDUCE, 337);
   _actionMap[627][ELSE] = ActionEntry(REDUCE, 337);
   _actionMap[627][LEFT] = ActionEntry(REDUCE, 337);
   _actionMap[627][RIGHT] = ActionEntry(REDUCE, 337);
   _actionMap[627][INNER] = ActionEntry(REDUCE, 337);
   _actionMap[627][JOIN] = ActionEntry(REDUCE, 337);
   _actionMap[627][ORDER] = ActionEntry(REDUCE, 337);
   _actionMap[627][GROUP] = ActionEntry(REDUCE, 337);
   _actionMap[627][RETURNTOKEN] = ActionEntry(REDUCE, 337);
   _actionMap[627][WHERE] = ActionEntry(REDUCE, 337);
   _actionMap[627][FROM] = ActionEntry(REDUCE, 337);
   _actionMap[627][AS] = ActionEntry(REDUCE, 337);
   _actionMap[627][END_TOKEN] = ActionEntry(REDUCE, 337);
   _actionMap[627][BEGIN] = ActionEntry(REDUCE, 337);
   _actionMap[627][THEN] = ActionEntry(REDUCE, 337);
   _actionMap[627][AND] = ActionEntry(REDUCE, 337);
   _actionMap[627][OR] = ActionEntry(REDUCE, 337);
   _actionMap[627][INTOK] = ActionEntry(REDUCE, 337);
   _actionMap[627][NOT] = ActionEntry(REDUCE, 337);
   _actionMap[627][MT] = ActionEntry(REDUCE, 337);
   _actionMap[627][LT] = ActionEntry(REDUCE, 337);
   _actionMap[627][NEGATION] = ActionEntry(REDUCE, 337);
   _actionMap[627][EQU] = ActionEntry(REDUCE, 337);
   _actionMap[627][BETWEEN] = ActionEntry(REDUCE, 337);
   _actionMap[627][IS] = ActionEntry(REDUCE, 337);
   _actionMap[627][LIKE] = ActionEntry(REDUCE, 337);
   _actionMap[627][NCLIKE] = ActionEntry(REDUCE, 337);
   _actionMap[627][RB] = ActionEntry(REDUCE, 337);
   _actionMap[627][ENDTOKEN] = ActionEntry(REDUCE, 337);
   _actionMap[627][UNION] = ActionEntry(REDUCE, 337);
   _actionMap[627][ROWLIMIT] = ActionEntry(REDUCE, 337);
   _actionMap[627][KSEP] = ActionEntry(REDUCE, 337);
}
void Cego::loadParser79()
{
   _actionMap[627][ASC] = ActionEntry(REDUCE, 337);
   _actionMap[627][DESC] = ActionEntry(REDUCE, 337);
   _actionMap[627][PLUS] = ActionEntry(REDUCE, 337);
   _actionMap[627][MINUS] = ActionEntry(REDUCE, 337);
   _actionMap[627][DIVISION] = ActionEntry(REDUCE, 337);
   _actionMap[627][STAR] = ActionEntry(REDUCE, 337);
   _actionMap[627][CONCAT] = ActionEntry(REDUCE, 337);
   _actionMap[627][SEMICOLON] = ActionEntry(REDUCE, 337);
   _actionMap[628][WHEN] = ActionEntry(REDUCE, 332);
   _actionMap[628][ELSE] = ActionEntry(REDUCE, 332);
   _actionMap[628][LEFT] = ActionEntry(REDUCE, 332);
   _actionMap[628][RIGHT] = ActionEntry(REDUCE, 332);
   _actionMap[628][INNER] = ActionEntry(REDUCE, 332);
   _actionMap[628][JOIN] = ActionEntry(REDUCE, 332);
   _actionMap[628][ORDER] = ActionEntry(REDUCE, 332);
   _actionMap[628][GROUP] = ActionEntry(REDUCE, 332);
   _actionMap[628][RETURNTOKEN] = ActionEntry(REDUCE, 332);
   _actionMap[628][WHERE] = ActionEntry(REDUCE, 332);
   _actionMap[628][AS] = ActionEntry(REDUCE, 332);
   _actionMap[628][FROM] = ActionEntry(REDUCE, 332);
   _actionMap[628][END_TOKEN] = ActionEntry(REDUCE, 332);
   _actionMap[628][BEGIN] = ActionEntry(REDUCE, 332);
   _actionMap[628][THEN] = ActionEntry(REDUCE, 332);
   _actionMap[628][OR] = ActionEntry(REDUCE, 332);
   _actionMap[628][AND] = ActionEntry(REDUCE, 332);
   _actionMap[628][NCLIKE] = ActionEntry(REDUCE, 332);
   _actionMap[628][LIKE] = ActionEntry(REDUCE, 332);
   _actionMap[628][IS] = ActionEntry(REDUCE, 332);
   _actionMap[628][BETWEEN] = ActionEntry(REDUCE, 332);
   _actionMap[628][EQU] = ActionEntry(REDUCE, 332);
   _actionMap[628][NEGATION] = ActionEntry(REDUCE, 332);
   _actionMap[628][LT] = ActionEntry(REDUCE, 332);
   _actionMap[628][MT] = ActionEntry(REDUCE, 332);
   _actionMap[628][NOT] = ActionEntry(REDUCE, 332);
   _actionMap[628][INTOK] = ActionEntry(REDUCE, 332);
   _actionMap[628][DESC] = ActionEntry(REDUCE, 332);
   _actionMap[628][ASC] = ActionEntry(REDUCE, 332);
   _actionMap[628][KSEP] = ActionEntry(REDUCE, 332);
   _actionMap[628][ROWLIMIT] = ActionEntry(REDUCE, 332);
   _actionMap[628][UNION] = ActionEntry(REDUCE, 332);
   _actionMap[628][ENDTOKEN] = ActionEntry(REDUCE, 332);
   _actionMap[628][RB] = ActionEntry(REDUCE, 332);
   _actionMap[628][CONCAT] = ActionEntry(REDUCE, 332);
   _actionMap[628][STAR] = ActionEntry(REDUCE, 332);
   _actionMap[628][DIVISION] = ActionEntry(REDUCE, 332);
   _actionMap[628][MINUS] = ActionEntry(REDUCE, 332);
   _actionMap[628][PLUS] = ActionEntry(REDUCE, 332);
   _actionMap[628][SEMICOLON] = ActionEntry(REDUCE, 332);
   _actionMap[629][WHEN] = ActionEntry(REDUCE, 365);
   _actionMap[629][ELSE] = ActionEntry(REDUCE, 365);
}
void Cego::loadParser80()
{
   _actionMap[629][LEFT] = ActionEntry(REDUCE, 365);
   _actionMap[629][RIGHT] = ActionEntry(REDUCE, 365);
   _actionMap[629][INNER] = ActionEntry(REDUCE, 365);
   _actionMap[629][JOIN] = ActionEntry(REDUCE, 365);
   _actionMap[629][ORDER] = ActionEntry(REDUCE, 365);
   _actionMap[629][GROUP] = ActionEntry(REDUCE, 365);
   _actionMap[629][RETURNTOKEN] = ActionEntry(REDUCE, 365);
   _actionMap[629][WHERE] = ActionEntry(REDUCE, 365);
   _actionMap[629][FROM] = ActionEntry(REDUCE, 365);
   _actionMap[629][AS] = ActionEntry(REDUCE, 365);
   _actionMap[629][END_TOKEN] = ActionEntry(REDUCE, 365);
   _actionMap[629][BEGIN] = ActionEntry(REDUCE, 365);
   _actionMap[629][THEN] = ActionEntry(REDUCE, 365);
   _actionMap[629][AND] = ActionEntry(REDUCE, 365);
   _actionMap[629][OR] = ActionEntry(REDUCE, 365);
   _actionMap[629][INTOK] = ActionEntry(REDUCE, 365);
   _actionMap[629][NOT] = ActionEntry(REDUCE, 365);
   _actionMap[629][MT] = ActionEntry(REDUCE, 365);
   _actionMap[629][LT] = ActionEntry(REDUCE, 365);
   _actionMap[629][NEGATION] = ActionEntry(REDUCE, 365);
   _actionMap[629][EQU] = ActionEntry(REDUCE, 365);
   _actionMap[629][BETWEEN] = ActionEntry(REDUCE, 365);
   _actionMap[629][IS] = ActionEntry(REDUCE, 365);
   _actionMap[629][LIKE] = ActionEntry(REDUCE, 365);
   _actionMap[629][NCLIKE] = ActionEntry(REDUCE, 365);
   _actionMap[629][RB] = ActionEntry(REDUCE, 365);
   _actionMap[629][ENDTOKEN] = ActionEntry(REDUCE, 365);
   _actionMap[629][UNION] = ActionEntry(REDUCE, 365);
   _actionMap[629][ROWLIMIT] = ActionEntry(REDUCE, 365);
   _actionMap[629][KSEP] = ActionEntry(REDUCE, 365);
   _actionMap[629][ASC] = ActionEntry(REDUCE, 365);
   _actionMap[629][DESC] = ActionEntry(REDUCE, 365);
   _actionMap[629][PLUS] = ActionEntry(REDUCE, 365);
   _actionMap[629][MINUS] = ActionEntry(REDUCE, 365);
   _actionMap[629][DIVISION] = ActionEntry(REDUCE, 365);
   _actionMap[629][STAR] = ActionEntry(REDUCE, 365);
   _actionMap[629][CONCAT] = ActionEntry(REDUCE, 365);
   _actionMap[629][SEMICOLON] = ActionEntry(REDUCE, 365);
   _actionMap[630][WHEN] = ActionEntry(REDUCE, 366);
   _actionMap[630][ELSE] = ActionEntry(REDUCE, 366);
   _actionMap[630][LEFT] = ActionEntry(REDUCE, 366);
   _actionMap[630][RIGHT] = ActionEntry(REDUCE, 366);
   _actionMap[630][INNER] = ActionEntry(REDUCE, 366);
   _actionMap[630][JOIN] = ActionEntry(REDUCE, 366);
   _actionMap[630][ORDER] = ActionEntry(REDUCE, 366);
   _actionMap[630][GROUP] = ActionEntry(REDUCE, 366);
   _actionMap[630][RETURNTOKEN] = ActionEntry(REDUCE, 366);
   _actionMap[630][WHERE] = ActionEntry(REDUCE, 366);
   _actionMap[630][FROM] = ActionEntry(REDUCE, 366);
   _actionMap[630][AS] = ActionEntry(REDUCE, 366);
}
void Cego::loadParser81()
{
   _actionMap[630][END_TOKEN] = ActionEntry(REDUCE, 366);
   _actionMap[630][BEGIN] = ActionEntry(REDUCE, 366);
   _actionMap[630][THEN] = ActionEntry(REDUCE, 366);
   _actionMap[630][AND] = ActionEntry(REDUCE, 366);
   _actionMap[630][OR] = ActionEntry(REDUCE, 366);
   _actionMap[630][INTOK] = ActionEntry(REDUCE, 366);
   _actionMap[630][NOT] = ActionEntry(REDUCE, 366);
   _actionMap[630][MT] = ActionEntry(REDUCE, 366);
   _actionMap[630][LT] = ActionEntry(REDUCE, 366);
   _actionMap[630][NEGATION] = ActionEntry(REDUCE, 366);
   _actionMap[630][EQU] = ActionEntry(REDUCE, 366);
   _actionMap[630][BETWEEN] = ActionEntry(REDUCE, 366);
   _actionMap[630][IS] = ActionEntry(REDUCE, 366);
   _actionMap[630][LIKE] = ActionEntry(REDUCE, 366);
   _actionMap[630][NCLIKE] = ActionEntry(REDUCE, 366);
   _actionMap[630][RB] = ActionEntry(REDUCE, 366);
   _actionMap[630][ENDTOKEN] = ActionEntry(REDUCE, 366);
   _actionMap[630][UNION] = ActionEntry(REDUCE, 366);
   _actionMap[630][ROWLIMIT] = ActionEntry(REDUCE, 366);
   _actionMap[630][KSEP] = ActionEntry(REDUCE, 366);
   _actionMap[630][ASC] = ActionEntry(REDUCE, 366);
   _actionMap[630][DESC] = ActionEntry(REDUCE, 366);
   _actionMap[630][PLUS] = ActionEntry(REDUCE, 366);
   _actionMap[630][MINUS] = ActionEntry(REDUCE, 366);
   _actionMap[630][DIVISION] = ActionEntry(REDUCE, 366);
   _actionMap[630][STAR] = ActionEntry(REDUCE, 366);
   _actionMap[630][CONCAT] = ActionEntry(REDUCE, 366);
   _actionMap[630][SEMICOLON] = ActionEntry(REDUCE, 366);
   _actionMap[631][WHEN] = ActionEntry(REDUCE, 367);
   _actionMap[631][ELSE] = ActionEntry(REDUCE, 367);
   _actionMap[631][LEFT] = ActionEntry(REDUCE, 367);
   _actionMap[631][RIGHT] = ActionEntry(REDUCE, 367);
   _actionMap[631][INNER] = ActionEntry(REDUCE, 367);
   _actionMap[631][JOIN] = ActionEntry(REDUCE, 367);
   _actionMap[631][ORDER] = ActionEntry(REDUCE, 367);
   _actionMap[631][GROUP] = ActionEntry(REDUCE, 367);
   _actionMap[631][RETURNTOKEN] = ActionEntry(REDUCE, 367);
   _actionMap[631][WHERE] = ActionEntry(REDUCE, 367);
   _actionMap[631][FROM] = ActionEntry(REDUCE, 367);
   _actionMap[631][AS] = ActionEntry(REDUCE, 367);
   _actionMap[631][END_TOKEN] = ActionEntry(REDUCE, 367);
   _actionMap[631][BEGIN] = ActionEntry(REDUCE, 367);
   _actionMap[631][THEN] = ActionEntry(REDUCE, 367);
   _actionMap[631][AND] = ActionEntry(REDUCE, 367);
   _actionMap[631][OR] = ActionEntry(REDUCE, 367);
   _actionMap[631][INTOK] = ActionEntry(REDUCE, 367);
   _actionMap[631][NOT] = ActionEntry(REDUCE, 367);
   _actionMap[631][MT] = ActionEntry(REDUCE, 367);
   _actionMap[631][LT] = ActionEntry(REDUCE, 367);
   _actionMap[631][NEGATION] = ActionEntry(REDUCE, 367);
}
void Cego::loadParser82()
{
   _actionMap[631][EQU] = ActionEntry(REDUCE, 367);
   _actionMap[631][BETWEEN] = ActionEntry(REDUCE, 367);
   _actionMap[631][IS] = ActionEntry(REDUCE, 367);
   _actionMap[631][LIKE] = ActionEntry(REDUCE, 367);
   _actionMap[631][NCLIKE] = ActionEntry(REDUCE, 367);
   _actionMap[631][RB] = ActionEntry(REDUCE, 367);
   _actionMap[631][ENDTOKEN] = ActionEntry(REDUCE, 367);
   _actionMap[631][UNION] = ActionEntry(REDUCE, 367);
   _actionMap[631][ROWLIMIT] = ActionEntry(REDUCE, 367);
   _actionMap[631][KSEP] = ActionEntry(REDUCE, 367);
   _actionMap[631][ASC] = ActionEntry(REDUCE, 367);
   _actionMap[631][DESC] = ActionEntry(REDUCE, 367);
   _actionMap[631][PLUS] = ActionEntry(REDUCE, 367);
   _actionMap[631][MINUS] = ActionEntry(REDUCE, 367);
   _actionMap[631][DIVISION] = ActionEntry(REDUCE, 367);
   _actionMap[631][STAR] = ActionEntry(REDUCE, 367);
   _actionMap[631][CONCAT] = ActionEntry(REDUCE, 367);
   _actionMap[631][SEMICOLON] = ActionEntry(REDUCE, 367);
   _actionMap[632][WHEN] = ActionEntry(REDUCE, 423);
   _actionMap[632][ELSE] = ActionEntry(REDUCE, 423);
   _actionMap[632][LEFT] = ActionEntry(REDUCE, 423);
   _actionMap[632][RIGHT] = ActionEntry(REDUCE, 423);
   _actionMap[632][INNER] = ActionEntry(REDUCE, 423);
   _actionMap[632][JOIN] = ActionEntry(REDUCE, 423);
   _actionMap[632][ORDER] = ActionEntry(REDUCE, 423);
   _actionMap[632][GROUP] = ActionEntry(REDUCE, 423);
   _actionMap[632][RETURNTOKEN] = ActionEntry(REDUCE, 423);
   _actionMap[632][WHERE] = ActionEntry(REDUCE, 423);
   _actionMap[632][NULLTOKEN] = ActionEntry(REDUCE, 423);
   _actionMap[632][FROM] = ActionEntry(REDUCE, 423);
   _actionMap[632][AS] = ActionEntry(REDUCE, 423);
   _actionMap[632][END_TOKEN] = ActionEntry(REDUCE, 423);
   _actionMap[632][BEGIN] = ActionEntry(REDUCE, 423);
   _actionMap[632][THEN] = ActionEntry(REDUCE, 423);
   _actionMap[632][AND] = ActionEntry(REDUCE, 423);
   _actionMap[632][OR] = ActionEntry(REDUCE, 423);
   _actionMap[632][INTOK] = ActionEntry(REDUCE, 423);
   _actionMap[632][NOT] = ActionEntry(REDUCE, 423);
   _actionMap[632][MT] = ActionEntry(REDUCE, 423);
   _actionMap[632][LT] = ActionEntry(REDUCE, 423);
   _actionMap[632][NEGATION] = ActionEntry(REDUCE, 423);
   _actionMap[632][EQU] = ActionEntry(REDUCE, 423);
   _actionMap[632][BETWEEN] = ActionEntry(REDUCE, 423);
   _actionMap[632][IS] = ActionEntry(REDUCE, 423);
   _actionMap[632][LIKE] = ActionEntry(REDUCE, 423);
   _actionMap[632][NCLIKE] = ActionEntry(REDUCE, 423);
   _actionMap[632][RB] = ActionEntry(REDUCE, 423);
   _actionMap[632][ENDTOKEN] = ActionEntry(REDUCE, 423);
   _actionMap[632][UNION] = ActionEntry(REDUCE, 423);
   _actionMap[632][ROWLIMIT] = ActionEntry(REDUCE, 423);
}
void Cego::loadParser83()
{
   _actionMap[632][KSEP] = ActionEntry(REDUCE, 423);
   _actionMap[632][ASC] = ActionEntry(REDUCE, 423);
   _actionMap[632][DESC] = ActionEntry(REDUCE, 423);
   _actionMap[632][PLUS] = ActionEntry(REDUCE, 423);
   _actionMap[632][MINUS] = ActionEntry(REDUCE, 423);
   _actionMap[632][DIVISION] = ActionEntry(REDUCE, 423);
   _actionMap[632][STAR] = ActionEntry(REDUCE, 423);
   _actionMap[632][CONCAT] = ActionEntry(REDUCE, 423);
   _actionMap[632][SEMICOLON] = ActionEntry(REDUCE, 423);
   _actionMap[633][WHEN] = ActionEntry(REDUCE, 368);
   _actionMap[633][ELSE] = ActionEntry(REDUCE, 368);
   _actionMap[633][LEFT] = ActionEntry(REDUCE, 368);
   _actionMap[633][RIGHT] = ActionEntry(REDUCE, 368);
   _actionMap[633][INNER] = ActionEntry(REDUCE, 368);
   _actionMap[633][JOIN] = ActionEntry(REDUCE, 368);
   _actionMap[633][ORDER] = ActionEntry(REDUCE, 368);
   _actionMap[633][GROUP] = ActionEntry(REDUCE, 368);
   _actionMap[633][RETURNTOKEN] = ActionEntry(REDUCE, 368);
   _actionMap[633][WHERE] = ActionEntry(REDUCE, 368);
   _actionMap[633][FROM] = ActionEntry(REDUCE, 368);
   _actionMap[633][AS] = ActionEntry(REDUCE, 368);
   _actionMap[633][END_TOKEN] = ActionEntry(REDUCE, 368);
   _actionMap[633][BEGIN] = ActionEntry(REDUCE, 368);
   _actionMap[633][THEN] = ActionEntry(REDUCE, 368);
   _actionMap[633][AND] = ActionEntry(REDUCE, 368);
   _actionMap[633][OR] = ActionEntry(REDUCE, 368);
   _actionMap[633][INTOK] = ActionEntry(REDUCE, 368);
   _actionMap[633][NOT] = ActionEntry(REDUCE, 368);
   _actionMap[633][MT] = ActionEntry(REDUCE, 368);
   _actionMap[633][LT] = ActionEntry(REDUCE, 368);
   _actionMap[633][NEGATION] = ActionEntry(REDUCE, 368);
   _actionMap[633][EQU] = ActionEntry(REDUCE, 368);
   _actionMap[633][BETWEEN] = ActionEntry(REDUCE, 368);
   _actionMap[633][IS] = ActionEntry(REDUCE, 368);
   _actionMap[633][LIKE] = ActionEntry(REDUCE, 368);
   _actionMap[633][NCLIKE] = ActionEntry(REDUCE, 368);
   _actionMap[633][RB] = ActionEntry(REDUCE, 368);
   _actionMap[633][ENDTOKEN] = ActionEntry(REDUCE, 368);
   _actionMap[633][UNION] = ActionEntry(REDUCE, 368);
   _actionMap[633][ROWLIMIT] = ActionEntry(REDUCE, 368);
   _actionMap[633][KSEP] = ActionEntry(REDUCE, 368);
   _actionMap[633][ASC] = ActionEntry(REDUCE, 368);
   _actionMap[633][DESC] = ActionEntry(REDUCE, 368);
   _actionMap[633][PLUS] = ActionEntry(REDUCE, 368);
   _actionMap[633][MINUS] = ActionEntry(REDUCE, 368);
   _actionMap[633][DIVISION] = ActionEntry(REDUCE, 368);
   _actionMap[633][STAR] = ActionEntry(REDUCE, 368);
   _actionMap[633][CONCAT] = ActionEntry(REDUCE, 368);
   _actionMap[633][SEMICOLON] = ActionEntry(REDUCE, 368);
   _actionMap[634][WHEN] = ActionEntry(REDUCE, 369);
}
void Cego::loadParser84()
{
   _actionMap[634][ELSE] = ActionEntry(REDUCE, 369);
   _actionMap[634][LEFT] = ActionEntry(REDUCE, 369);
   _actionMap[634][RIGHT] = ActionEntry(REDUCE, 369);
   _actionMap[634][INNER] = ActionEntry(REDUCE, 369);
   _actionMap[634][JOIN] = ActionEntry(REDUCE, 369);
   _actionMap[634][ORDER] = ActionEntry(REDUCE, 369);
   _actionMap[634][GROUP] = ActionEntry(REDUCE, 369);
   _actionMap[634][RETURNTOKEN] = ActionEntry(REDUCE, 369);
   _actionMap[634][WHERE] = ActionEntry(REDUCE, 369);
   _actionMap[634][FROM] = ActionEntry(REDUCE, 369);
   _actionMap[634][AS] = ActionEntry(REDUCE, 369);
   _actionMap[634][END_TOKEN] = ActionEntry(REDUCE, 369);
   _actionMap[634][BEGIN] = ActionEntry(REDUCE, 369);
   _actionMap[634][THEN] = ActionEntry(REDUCE, 369);
   _actionMap[634][AND] = ActionEntry(REDUCE, 369);
   _actionMap[634][OR] = ActionEntry(REDUCE, 369);
   _actionMap[634][INTOK] = ActionEntry(REDUCE, 369);
   _actionMap[634][NOT] = ActionEntry(REDUCE, 369);
   _actionMap[634][MT] = ActionEntry(REDUCE, 369);
   _actionMap[634][LT] = ActionEntry(REDUCE, 369);
   _actionMap[634][NEGATION] = ActionEntry(REDUCE, 369);
   _actionMap[634][EQU] = ActionEntry(REDUCE, 369);
   _actionMap[634][BETWEEN] = ActionEntry(REDUCE, 369);
   _actionMap[634][IS] = ActionEntry(REDUCE, 369);
   _actionMap[634][LIKE] = ActionEntry(REDUCE, 369);
   _actionMap[634][NCLIKE] = ActionEntry(REDUCE, 369);
   _actionMap[634][RB] = ActionEntry(REDUCE, 369);
   _actionMap[634][ENDTOKEN] = ActionEntry(REDUCE, 369);
   _actionMap[634][UNION] = ActionEntry(REDUCE, 369);
   _actionMap[634][ROWLIMIT] = ActionEntry(REDUCE, 369);
   _actionMap[634][KSEP] = ActionEntry(REDUCE, 369);
   _actionMap[634][ASC] = ActionEntry(REDUCE, 369);
   _actionMap[634][DESC] = ActionEntry(REDUCE, 369);
   _actionMap[634][PLUS] = ActionEntry(REDUCE, 369);
   _actionMap[634][MINUS] = ActionEntry(REDUCE, 369);
   _actionMap[634][DIVISION] = ActionEntry(REDUCE, 369);
   _actionMap[634][STAR] = ActionEntry(REDUCE, 369);
   _actionMap[634][CONCAT] = ActionEntry(REDUCE, 369);
   _actionMap[634][SEMICOLON] = ActionEntry(REDUCE, 369);
   _actionMap[635][WHEN] = ActionEntry(REDUCE, 424);
   _actionMap[635][ELSE] = ActionEntry(REDUCE, 424);
   _actionMap[635][LEFT] = ActionEntry(REDUCE, 424);
   _actionMap[635][RIGHT] = ActionEntry(REDUCE, 424);
   _actionMap[635][INNER] = ActionEntry(REDUCE, 424);
   _actionMap[635][JOIN] = ActionEntry(REDUCE, 424);
   _actionMap[635][ORDER] = ActionEntry(REDUCE, 424);
   _actionMap[635][GROUP] = ActionEntry(REDUCE, 424);
   _actionMap[635][RETURNTOKEN] = ActionEntry(REDUCE, 424);
   _actionMap[635][WHERE] = ActionEntry(REDUCE, 424);
   _actionMap[635][NULLTOKEN] = ActionEntry(REDUCE, 424);
}
void Cego::loadParser85()
{
   _actionMap[635][FROM] = ActionEntry(REDUCE, 424);
   _actionMap[635][AS] = ActionEntry(REDUCE, 424);
   _actionMap[635][END_TOKEN] = ActionEntry(REDUCE, 424);
   _actionMap[635][BEGIN] = ActionEntry(REDUCE, 424);
   _actionMap[635][THEN] = ActionEntry(REDUCE, 424);
   _actionMap[635][AND] = ActionEntry(REDUCE, 424);
   _actionMap[635][OR] = ActionEntry(REDUCE, 424);
   _actionMap[635][INTOK] = ActionEntry(REDUCE, 424);
   _actionMap[635][NOT] = ActionEntry(REDUCE, 424);
   _actionMap[635][MT] = ActionEntry(REDUCE, 424);
   _actionMap[635][LT] = ActionEntry(REDUCE, 424);
   _actionMap[635][NEGATION] = ActionEntry(REDUCE, 424);
   _actionMap[635][EQU] = ActionEntry(REDUCE, 424);
   _actionMap[635][BETWEEN] = ActionEntry(REDUCE, 424);
   _actionMap[635][IS] = ActionEntry(REDUCE, 424);
   _actionMap[635][LIKE] = ActionEntry(REDUCE, 424);
   _actionMap[635][NCLIKE] = ActionEntry(REDUCE, 424);
   _actionMap[635][RB] = ActionEntry(REDUCE, 424);
   _actionMap[635][ENDTOKEN] = ActionEntry(REDUCE, 424);
   _actionMap[635][UNION] = ActionEntry(REDUCE, 424);
   _actionMap[635][ROWLIMIT] = ActionEntry(REDUCE, 424);
   _actionMap[635][KSEP] = ActionEntry(REDUCE, 424);
   _actionMap[635][ASC] = ActionEntry(REDUCE, 424);
   _actionMap[635][DESC] = ActionEntry(REDUCE, 424);
   _actionMap[635][PLUS] = ActionEntry(REDUCE, 424);
   _actionMap[635][MINUS] = ActionEntry(REDUCE, 424);
   _actionMap[635][DIVISION] = ActionEntry(REDUCE, 424);
   _actionMap[635][STAR] = ActionEntry(REDUCE, 424);
   _actionMap[635][CONCAT] = ActionEntry(REDUCE, 424);
   _actionMap[635][SEMICOLON] = ActionEntry(REDUCE, 424);
   _actionMap[636][WHEN] = ActionEntry(REDUCE, 370);
   _actionMap[636][ELSE] = ActionEntry(REDUCE, 370);
   _actionMap[636][LEFT] = ActionEntry(REDUCE, 370);
   _actionMap[636][RIGHT] = ActionEntry(REDUCE, 370);
   _actionMap[636][INNER] = ActionEntry(REDUCE, 370);
   _actionMap[636][JOIN] = ActionEntry(REDUCE, 370);
   _actionMap[636][ORDER] = ActionEntry(REDUCE, 370);
   _actionMap[636][GROUP] = ActionEntry(REDUCE, 370);
   _actionMap[636][RETURNTOKEN] = ActionEntry(REDUCE, 370);
   _actionMap[636][WHERE] = ActionEntry(REDUCE, 370);
   _actionMap[636][FROM] = ActionEntry(REDUCE, 370);
   _actionMap[636][AS] = ActionEntry(REDUCE, 370);
   _actionMap[636][END_TOKEN] = ActionEntry(REDUCE, 370);
   _actionMap[636][BEGIN] = ActionEntry(REDUCE, 370);
   _actionMap[636][THEN] = ActionEntry(REDUCE, 370);
   _actionMap[636][AND] = ActionEntry(REDUCE, 370);
   _actionMap[636][OR] = ActionEntry(REDUCE, 370);
   _actionMap[636][INTOK] = ActionEntry(REDUCE, 370);
   _actionMap[636][NOT] = ActionEntry(REDUCE, 370);
   _actionMap[636][MT] = ActionEntry(REDUCE, 370);
}
void Cego::loadParser86()
{
   _actionMap[636][LT] = ActionEntry(REDUCE, 370);
   _actionMap[636][NEGATION] = ActionEntry(REDUCE, 370);
   _actionMap[636][EQU] = ActionEntry(REDUCE, 370);
   _actionMap[636][BETWEEN] = ActionEntry(REDUCE, 370);
   _actionMap[636][IS] = ActionEntry(REDUCE, 370);
   _actionMap[636][LIKE] = ActionEntry(REDUCE, 370);
   _actionMap[636][NCLIKE] = ActionEntry(REDUCE, 370);
   _actionMap[636][RB] = ActionEntry(REDUCE, 370);
   _actionMap[636][ENDTOKEN] = ActionEntry(REDUCE, 370);
   _actionMap[636][UNION] = ActionEntry(REDUCE, 370);
   _actionMap[636][ROWLIMIT] = ActionEntry(REDUCE, 370);
   _actionMap[636][KSEP] = ActionEntry(REDUCE, 370);
   _actionMap[636][ASC] = ActionEntry(REDUCE, 370);
   _actionMap[636][DESC] = ActionEntry(REDUCE, 370);
   _actionMap[636][PLUS] = ActionEntry(REDUCE, 370);
   _actionMap[636][MINUS] = ActionEntry(REDUCE, 370);
   _actionMap[636][DIVISION] = ActionEntry(REDUCE, 370);
   _actionMap[636][STAR] = ActionEntry(REDUCE, 370);
   _actionMap[636][CONCAT] = ActionEntry(REDUCE, 370);
   _actionMap[636][SEMICOLON] = ActionEntry(REDUCE, 370);
   _actionMap[637][WHEN] = ActionEntry(REDUCE, 371);
   _actionMap[637][ELSE] = ActionEntry(REDUCE, 371);
   _actionMap[637][LEFT] = ActionEntry(REDUCE, 371);
   _actionMap[637][RIGHT] = ActionEntry(REDUCE, 371);
   _actionMap[637][INNER] = ActionEntry(REDUCE, 371);
   _actionMap[637][JOIN] = ActionEntry(REDUCE, 371);
   _actionMap[637][ORDER] = ActionEntry(REDUCE, 371);
   _actionMap[637][GROUP] = ActionEntry(REDUCE, 371);
   _actionMap[637][RETURNTOKEN] = ActionEntry(REDUCE, 371);
   _actionMap[637][WHERE] = ActionEntry(REDUCE, 371);
   _actionMap[637][FROM] = ActionEntry(REDUCE, 371);
   _actionMap[637][AS] = ActionEntry(REDUCE, 371);
   _actionMap[637][END_TOKEN] = ActionEntry(REDUCE, 371);
   _actionMap[637][BEGIN] = ActionEntry(REDUCE, 371);
   _actionMap[637][THEN] = ActionEntry(REDUCE, 371);
   _actionMap[637][AND] = ActionEntry(REDUCE, 371);
   _actionMap[637][OR] = ActionEntry(REDUCE, 371);
   _actionMap[637][INTOK] = ActionEntry(REDUCE, 371);
   _actionMap[637][NOT] = ActionEntry(REDUCE, 371);
   _actionMap[637][MT] = ActionEntry(REDUCE, 371);
   _actionMap[637][LT] = ActionEntry(REDUCE, 371);
   _actionMap[637][NEGATION] = ActionEntry(REDUCE, 371);
   _actionMap[637][EQU] = ActionEntry(REDUCE, 371);
   _actionMap[637][BETWEEN] = ActionEntry(REDUCE, 371);
   _actionMap[637][IS] = ActionEntry(REDUCE, 371);
   _actionMap[637][LIKE] = ActionEntry(REDUCE, 371);
   _actionMap[637][NCLIKE] = ActionEntry(REDUCE, 371);
   _actionMap[637][RB] = ActionEntry(REDUCE, 371);
   _actionMap[637][ENDTOKEN] = ActionEntry(REDUCE, 371);
   _actionMap[637][UNION] = ActionEntry(REDUCE, 371);
}
void Cego::loadParser87()
{
   _actionMap[637][ROWLIMIT] = ActionEntry(REDUCE, 371);
   _actionMap[637][KSEP] = ActionEntry(REDUCE, 371);
   _actionMap[637][ASC] = ActionEntry(REDUCE, 371);
   _actionMap[637][DESC] = ActionEntry(REDUCE, 371);
   _actionMap[637][PLUS] = ActionEntry(REDUCE, 371);
   _actionMap[637][MINUS] = ActionEntry(REDUCE, 371);
   _actionMap[637][DIVISION] = ActionEntry(REDUCE, 371);
   _actionMap[637][STAR] = ActionEntry(REDUCE, 371);
   _actionMap[637][CONCAT] = ActionEntry(REDUCE, 371);
   _actionMap[637][SEMICOLON] = ActionEntry(REDUCE, 371);
   _actionMap[638][WHEN] = ActionEntry(REDUCE, 372);
   _actionMap[638][ELSE] = ActionEntry(REDUCE, 372);
   _actionMap[638][LEFT] = ActionEntry(REDUCE, 372);
   _actionMap[638][RIGHT] = ActionEntry(REDUCE, 372);
   _actionMap[638][INNER] = ActionEntry(REDUCE, 372);
   _actionMap[638][JOIN] = ActionEntry(REDUCE, 372);
   _actionMap[638][ORDER] = ActionEntry(REDUCE, 372);
   _actionMap[638][GROUP] = ActionEntry(REDUCE, 372);
   _actionMap[638][RETURNTOKEN] = ActionEntry(REDUCE, 372);
   _actionMap[638][WHERE] = ActionEntry(REDUCE, 372);
   _actionMap[638][FROM] = ActionEntry(REDUCE, 372);
   _actionMap[638][AS] = ActionEntry(REDUCE, 372);
   _actionMap[638][END_TOKEN] = ActionEntry(REDUCE, 372);
   _actionMap[638][BEGIN] = ActionEntry(REDUCE, 372);
   _actionMap[638][THEN] = ActionEntry(REDUCE, 372);
   _actionMap[638][AND] = ActionEntry(REDUCE, 372);
   _actionMap[638][OR] = ActionEntry(REDUCE, 372);
   _actionMap[638][INTOK] = ActionEntry(REDUCE, 372);
   _actionMap[638][NOT] = ActionEntry(REDUCE, 372);
   _actionMap[638][MT] = ActionEntry(REDUCE, 372);
   _actionMap[638][LT] = ActionEntry(REDUCE, 372);
   _actionMap[638][NEGATION] = ActionEntry(REDUCE, 372);
   _actionMap[638][EQU] = ActionEntry(REDUCE, 372);
   _actionMap[638][BETWEEN] = ActionEntry(REDUCE, 372);
   _actionMap[638][IS] = ActionEntry(REDUCE, 372);
   _actionMap[638][LIKE] = ActionEntry(REDUCE, 372);
   _actionMap[638][NCLIKE] = ActionEntry(REDUCE, 372);
   _actionMap[638][RB] = ActionEntry(REDUCE, 372);
   _actionMap[638][ENDTOKEN] = ActionEntry(REDUCE, 372);
   _actionMap[638][UNION] = ActionEntry(REDUCE, 372);
   _actionMap[638][ROWLIMIT] = ActionEntry(REDUCE, 372);
   _actionMap[638][KSEP] = ActionEntry(REDUCE, 372);
   _actionMap[638][ASC] = ActionEntry(REDUCE, 372);
   _actionMap[638][DESC] = ActionEntry(REDUCE, 372);
   _actionMap[638][PLUS] = ActionEntry(REDUCE, 372);
   _actionMap[638][MINUS] = ActionEntry(REDUCE, 372);
   _actionMap[638][DIVISION] = ActionEntry(REDUCE, 372);
   _actionMap[638][STAR] = ActionEntry(REDUCE, 372);
   _actionMap[638][CONCAT] = ActionEntry(REDUCE, 372);
   _actionMap[638][SEMICOLON] = ActionEntry(REDUCE, 372);
}
void Cego::loadParser88()
{
   _actionMap[639][WHEN] = ActionEntry(REDUCE, 333);
   _actionMap[639][ELSE] = ActionEntry(REDUCE, 333);
   _actionMap[639][LEFT] = ActionEntry(REDUCE, 333);
   _actionMap[639][RIGHT] = ActionEntry(REDUCE, 333);
   _actionMap[639][INNER] = ActionEntry(REDUCE, 333);
   _actionMap[639][JOIN] = ActionEntry(REDUCE, 333);
   _actionMap[639][ORDER] = ActionEntry(REDUCE, 333);
   _actionMap[639][GROUP] = ActionEntry(REDUCE, 333);
   _actionMap[639][RETURNTOKEN] = ActionEntry(REDUCE, 333);
   _actionMap[639][WHERE] = ActionEntry(REDUCE, 333);
   _actionMap[639][AS] = ActionEntry(REDUCE, 333);
   _actionMap[639][FROM] = ActionEntry(REDUCE, 333);
   _actionMap[639][END_TOKEN] = ActionEntry(REDUCE, 333);
   _actionMap[639][BEGIN] = ActionEntry(REDUCE, 333);
   _actionMap[639][THEN] = ActionEntry(REDUCE, 333);
   _actionMap[639][OR] = ActionEntry(REDUCE, 333);
   _actionMap[639][AND] = ActionEntry(REDUCE, 333);
   _actionMap[639][NCLIKE] = ActionEntry(REDUCE, 333);
   _actionMap[639][LIKE] = ActionEntry(REDUCE, 333);
   _actionMap[639][IS] = ActionEntry(REDUCE, 333);
   _actionMap[639][BETWEEN] = ActionEntry(REDUCE, 333);
   _actionMap[639][EQU] = ActionEntry(REDUCE, 333);
   _actionMap[639][NEGATION] = ActionEntry(REDUCE, 333);
   _actionMap[639][LT] = ActionEntry(REDUCE, 333);
   _actionMap[639][MT] = ActionEntry(REDUCE, 333);
   _actionMap[639][NOT] = ActionEntry(REDUCE, 333);
   _actionMap[639][INTOK] = ActionEntry(REDUCE, 333);
   _actionMap[639][DESC] = ActionEntry(REDUCE, 333);
   _actionMap[639][ASC] = ActionEntry(REDUCE, 333);
   _actionMap[639][KSEP] = ActionEntry(REDUCE, 333);
   _actionMap[639][ROWLIMIT] = ActionEntry(REDUCE, 333);
   _actionMap[639][UNION] = ActionEntry(REDUCE, 333);
   _actionMap[639][ENDTOKEN] = ActionEntry(REDUCE, 333);
   _actionMap[639][RB] = ActionEntry(REDUCE, 333);
   _actionMap[639][CONCAT] = ActionEntry(REDUCE, 333);
   _actionMap[639][STAR] = ActionEntry(REDUCE, 333);
   _actionMap[639][DIVISION] = ActionEntry(REDUCE, 333);
   _actionMap[639][MINUS] = ActionEntry(REDUCE, 333);
   _actionMap[639][PLUS] = ActionEntry(REDUCE, 333);
   _actionMap[639][SEMICOLON] = ActionEntry(REDUCE, 333);
   _actionMap[640][WHEN] = ActionEntry(REDUCE, 330);
   _actionMap[640][ELSE] = ActionEntry(REDUCE, 330);
   _actionMap[640][LEFT] = ActionEntry(REDUCE, 330);
   _actionMap[640][RIGHT] = ActionEntry(REDUCE, 330);
   _actionMap[640][INNER] = ActionEntry(REDUCE, 330);
   _actionMap[640][JOIN] = ActionEntry(REDUCE, 330);
   _actionMap[640][ORDER] = ActionEntry(REDUCE, 330);
   _actionMap[640][GROUP] = ActionEntry(REDUCE, 330);
   _actionMap[640][RETURNTOKEN] = ActionEntry(REDUCE, 330);
   _actionMap[640][WHERE] = ActionEntry(REDUCE, 330);
}
void Cego::loadParser89()
{
   _actionMap[640][AS] = ActionEntry(REDUCE, 330);
   _actionMap[640][FROM] = ActionEntry(REDUCE, 330);
   _actionMap[640][END_TOKEN] = ActionEntry(REDUCE, 330);
   _actionMap[640][BEGIN] = ActionEntry(REDUCE, 330);
   _actionMap[640][THEN] = ActionEntry(REDUCE, 330);
   _actionMap[640][OR] = ActionEntry(REDUCE, 330);
   _actionMap[640][AND] = ActionEntry(REDUCE, 330);
   _actionMap[640][NCLIKE] = ActionEntry(REDUCE, 330);
   _actionMap[640][LIKE] = ActionEntry(REDUCE, 330);
   _actionMap[640][IS] = ActionEntry(REDUCE, 330);
   _actionMap[640][BETWEEN] = ActionEntry(REDUCE, 330);
   _actionMap[640][EQU] = ActionEntry(REDUCE, 330);
   _actionMap[640][NEGATION] = ActionEntry(REDUCE, 330);
   _actionMap[640][LT] = ActionEntry(REDUCE, 330);
   _actionMap[640][MT] = ActionEntry(REDUCE, 330);
   _actionMap[640][NOT] = ActionEntry(REDUCE, 330);
   _actionMap[640][INTOK] = ActionEntry(REDUCE, 330);
   _actionMap[640][DESC] = ActionEntry(REDUCE, 330);
   _actionMap[640][ASC] = ActionEntry(REDUCE, 330);
   _actionMap[640][KSEP] = ActionEntry(REDUCE, 330);
   _actionMap[640][ROWLIMIT] = ActionEntry(REDUCE, 330);
   _actionMap[640][UNION] = ActionEntry(REDUCE, 330);
   _actionMap[640][ENDTOKEN] = ActionEntry(REDUCE, 330);
   _actionMap[640][RB] = ActionEntry(REDUCE, 330);
   _actionMap[640][CONCAT] = ActionEntry(REDUCE, 330);
   _actionMap[640][STAR] = ActionEntry(REDUCE, 330);
   _actionMap[640][DIVISION] = ActionEntry(REDUCE, 330);
   _actionMap[640][MINUS] = ActionEntry(REDUCE, 330);
   _actionMap[640][PLUS] = ActionEntry(REDUCE, 330);
   _actionMap[640][SEMICOLON] = ActionEntry(REDUCE, 330);
   _actionMap[641][WHEN] = ActionEntry(REDUCE, 343);
   _actionMap[641][ELSE] = ActionEntry(REDUCE, 343);
   _actionMap[641][LEFT] = ActionEntry(REDUCE, 343);
   _actionMap[641][RIGHT] = ActionEntry(REDUCE, 343);
   _actionMap[641][INNER] = ActionEntry(REDUCE, 343);
   _actionMap[641][JOIN] = ActionEntry(REDUCE, 343);
   _actionMap[641][ORDER] = ActionEntry(REDUCE, 343);
   _actionMap[641][GROUP] = ActionEntry(REDUCE, 343);
   _actionMap[641][RETURNTOKEN] = ActionEntry(REDUCE, 343);
   _actionMap[641][WHERE] = ActionEntry(REDUCE, 343);
   _actionMap[641][FROM] = ActionEntry(REDUCE, 343);
   _actionMap[641][AS] = ActionEntry(REDUCE, 343);
   _actionMap[641][END_TOKEN] = ActionEntry(REDUCE, 343);
   _actionMap[641][BEGIN] = ActionEntry(REDUCE, 343);
   _actionMap[641][THEN] = ActionEntry(REDUCE, 343);
   _actionMap[641][AND] = ActionEntry(REDUCE, 343);
   _actionMap[641][OR] = ActionEntry(REDUCE, 343);
   _actionMap[641][INTOK] = ActionEntry(REDUCE, 343);
   _actionMap[641][NOT] = ActionEntry(REDUCE, 343);
   _actionMap[641][MT] = ActionEntry(REDUCE, 343);
}
void Cego::loadParser90()
{
   _actionMap[641][LT] = ActionEntry(REDUCE, 343);
   _actionMap[641][NEGATION] = ActionEntry(REDUCE, 343);
   _actionMap[641][EQU] = ActionEntry(REDUCE, 343);
   _actionMap[641][BETWEEN] = ActionEntry(REDUCE, 343);
   _actionMap[641][IS] = ActionEntry(REDUCE, 343);
   _actionMap[641][LIKE] = ActionEntry(REDUCE, 343);
   _actionMap[641][NCLIKE] = ActionEntry(REDUCE, 343);
   _actionMap[641][RB] = ActionEntry(REDUCE, 343);
   _actionMap[641][ENDTOKEN] = ActionEntry(REDUCE, 343);
   _actionMap[641][UNION] = ActionEntry(REDUCE, 343);
   _actionMap[641][ROWLIMIT] = ActionEntry(REDUCE, 343);
   _actionMap[641][KSEP] = ActionEntry(REDUCE, 343);
   _actionMap[641][ASC] = ActionEntry(REDUCE, 343);
   _actionMap[641][DESC] = ActionEntry(REDUCE, 343);
   _actionMap[641][PLUS] = ActionEntry(REDUCE, 343);
   _actionMap[641][MINUS] = ActionEntry(REDUCE, 343);
   _actionMap[641][DIVISION] = ActionEntry(REDUCE, 343);
   _actionMap[641][STAR] = ActionEntry(REDUCE, 343);
   _actionMap[641][CONCAT] = ActionEntry(REDUCE, 343);
   _actionMap[641][SEMICOLON] = ActionEntry(REDUCE, 343);
   _actionMap[642][WHEN] = ActionEntry(REDUCE, 344);
   _actionMap[642][ELSE] = ActionEntry(REDUCE, 344);
   _actionMap[642][LEFT] = ActionEntry(REDUCE, 344);
   _actionMap[642][RIGHT] = ActionEntry(REDUCE, 344);
   _actionMap[642][INNER] = ActionEntry(REDUCE, 344);
   _actionMap[642][JOIN] = ActionEntry(REDUCE, 344);
   _actionMap[642][ORDER] = ActionEntry(REDUCE, 344);
   _actionMap[642][GROUP] = ActionEntry(REDUCE, 344);
   _actionMap[642][RETURNTOKEN] = ActionEntry(REDUCE, 344);
   _actionMap[642][WHERE] = ActionEntry(REDUCE, 344);
   _actionMap[642][FROM] = ActionEntry(REDUCE, 344);
   _actionMap[642][AS] = ActionEntry(REDUCE, 344);
   _actionMap[642][END_TOKEN] = ActionEntry(REDUCE, 344);
   _actionMap[642][BEGIN] = ActionEntry(REDUCE, 344);
   _actionMap[642][THEN] = ActionEntry(REDUCE, 344);
   _actionMap[642][AND] = ActionEntry(REDUCE, 344);
   _actionMap[642][OR] = ActionEntry(REDUCE, 344);
   _actionMap[642][INTOK] = ActionEntry(REDUCE, 344);
   _actionMap[642][NOT] = ActionEntry(REDUCE, 344);
   _actionMap[642][MT] = ActionEntry(REDUCE, 344);
   _actionMap[642][LT] = ActionEntry(REDUCE, 344);
   _actionMap[642][NEGATION] = ActionEntry(REDUCE, 344);
   _actionMap[642][EQU] = ActionEntry(REDUCE, 344);
   _actionMap[642][BETWEEN] = ActionEntry(REDUCE, 344);
   _actionMap[642][IS] = ActionEntry(REDUCE, 344);
   _actionMap[642][LIKE] = ActionEntry(REDUCE, 344);
   _actionMap[642][NCLIKE] = ActionEntry(REDUCE, 344);
   _actionMap[642][RB] = ActionEntry(REDUCE, 344);
   _actionMap[642][ENDTOKEN] = ActionEntry(REDUCE, 344);
   _actionMap[642][UNION] = ActionEntry(REDUCE, 344);
}
void Cego::loadParser91()
{
   _actionMap[642][ROWLIMIT] = ActionEntry(REDUCE, 344);
   _actionMap[642][KSEP] = ActionEntry(REDUCE, 344);
   _actionMap[642][ASC] = ActionEntry(REDUCE, 344);
   _actionMap[642][DESC] = ActionEntry(REDUCE, 344);
   _actionMap[642][PLUS] = ActionEntry(REDUCE, 344);
   _actionMap[642][MINUS] = ActionEntry(REDUCE, 344);
   _actionMap[642][DIVISION] = ActionEntry(REDUCE, 344);
   _actionMap[642][STAR] = ActionEntry(REDUCE, 344);
   _actionMap[642][CONCAT] = ActionEntry(REDUCE, 344);
   _actionMap[642][SEMICOLON] = ActionEntry(REDUCE, 344);
   _actionMap[643][WHEN] = ActionEntry(REDUCE, 361);
   _actionMap[643][ELSE] = ActionEntry(REDUCE, 361);
   _actionMap[643][LEFT] = ActionEntry(REDUCE, 361);
   _actionMap[643][RIGHT] = ActionEntry(REDUCE, 361);
   _actionMap[643][INNER] = ActionEntry(REDUCE, 361);
   _actionMap[643][JOIN] = ActionEntry(REDUCE, 361);
   _actionMap[643][ORDER] = ActionEntry(REDUCE, 361);
   _actionMap[643][GROUP] = ActionEntry(REDUCE, 361);
   _actionMap[643][RETURNTOKEN] = ActionEntry(REDUCE, 361);
   _actionMap[643][WHERE] = ActionEntry(REDUCE, 361);
   _actionMap[643][FROM] = ActionEntry(REDUCE, 361);
   _actionMap[643][AS] = ActionEntry(REDUCE, 361);
   _actionMap[643][END_TOKEN] = ActionEntry(REDUCE, 361);
   _actionMap[643][BEGIN] = ActionEntry(REDUCE, 361);
   _actionMap[643][THEN] = ActionEntry(REDUCE, 361);
   _actionMap[643][AND] = ActionEntry(REDUCE, 361);
   _actionMap[643][OR] = ActionEntry(REDUCE, 361);
   _actionMap[643][INTOK] = ActionEntry(REDUCE, 361);
   _actionMap[643][NOT] = ActionEntry(REDUCE, 361);
   _actionMap[643][MT] = ActionEntry(REDUCE, 361);
   _actionMap[643][LT] = ActionEntry(REDUCE, 361);
   _actionMap[643][NEGATION] = ActionEntry(REDUCE, 361);
   _actionMap[643][EQU] = ActionEntry(REDUCE, 361);
   _actionMap[643][BETWEEN] = ActionEntry(REDUCE, 361);
   _actionMap[643][IS] = ActionEntry(REDUCE, 361);
   _actionMap[643][LIKE] = ActionEntry(REDUCE, 361);
   _actionMap[643][NCLIKE] = ActionEntry(REDUCE, 361);
   _actionMap[643][RB] = ActionEntry(REDUCE, 361);
   _actionMap[643][ENDTOKEN] = ActionEntry(REDUCE, 361);
   _actionMap[643][UNION] = ActionEntry(REDUCE, 361);
   _actionMap[643][ROWLIMIT] = ActionEntry(REDUCE, 361);
   _actionMap[643][KSEP] = ActionEntry(REDUCE, 361);
   _actionMap[643][ASC] = ActionEntry(REDUCE, 361);
   _actionMap[643][DESC] = ActionEntry(REDUCE, 361);
   _actionMap[643][PLUS] = ActionEntry(REDUCE, 361);
   _actionMap[643][MINUS] = ActionEntry(REDUCE, 361);
   _actionMap[643][DIVISION] = ActionEntry(REDUCE, 361);
   _actionMap[643][STAR] = ActionEntry(REDUCE, 361);
   _actionMap[643][CONCAT] = ActionEntry(REDUCE, 361);
   _actionMap[643][SEMICOLON] = ActionEntry(REDUCE, 361);
}
void Cego::loadParser92()
{
   _actionMap[644][VARREF] = ActionEntry(SHIFT, 782);
   _jumpMap[644][FetchArgList] = 781;
   _actionMap[645][WHEN] = ActionEntry(REDUCE, 376);
   _actionMap[645][ELSE] = ActionEntry(REDUCE, 376);
   _actionMap[645][LEFT] = ActionEntry(REDUCE, 376);
   _actionMap[645][RIGHT] = ActionEntry(REDUCE, 376);
   _actionMap[645][INNER] = ActionEntry(REDUCE, 376);
   _actionMap[645][JOIN] = ActionEntry(REDUCE, 376);
   _actionMap[645][ORDER] = ActionEntry(REDUCE, 376);
   _actionMap[645][GROUP] = ActionEntry(REDUCE, 376);
   _actionMap[645][RETURNTOKEN] = ActionEntry(REDUCE, 376);
   _actionMap[645][WHERE] = ActionEntry(REDUCE, 376);
   _actionMap[645][FROM] = ActionEntry(REDUCE, 376);
   _actionMap[645][AS] = ActionEntry(REDUCE, 376);
   _actionMap[645][END_TOKEN] = ActionEntry(REDUCE, 376);
   _actionMap[645][BEGIN] = ActionEntry(REDUCE, 376);
   _actionMap[645][THEN] = ActionEntry(REDUCE, 376);
   _actionMap[645][AND] = ActionEntry(REDUCE, 376);
   _actionMap[645][OR] = ActionEntry(REDUCE, 376);
   _actionMap[645][INTOK] = ActionEntry(REDUCE, 376);
   _actionMap[645][NOT] = ActionEntry(REDUCE, 376);
   _actionMap[645][MT] = ActionEntry(REDUCE, 376);
   _actionMap[645][LT] = ActionEntry(REDUCE, 376);
   _actionMap[645][NEGATION] = ActionEntry(REDUCE, 376);
   _actionMap[645][EQU] = ActionEntry(REDUCE, 376);
   _actionMap[645][BETWEEN] = ActionEntry(REDUCE, 376);
   _actionMap[645][IS] = ActionEntry(REDUCE, 376);
   _actionMap[645][LIKE] = ActionEntry(REDUCE, 376);
   _actionMap[645][NCLIKE] = ActionEntry(REDUCE, 376);
   _actionMap[645][RB] = ActionEntry(REDUCE, 376);
   _actionMap[645][ENDTOKEN] = ActionEntry(REDUCE, 376);
   _actionMap[645][UNION] = ActionEntry(REDUCE, 376);
   _actionMap[645][ROWLIMIT] = ActionEntry(REDUCE, 376);
   _actionMap[645][KSEP] = ActionEntry(REDUCE, 376);
   _actionMap[645][ASC] = ActionEntry(REDUCE, 376);
   _actionMap[645][DESC] = ActionEntry(REDUCE, 376);
   _actionMap[645][PLUS] = ActionEntry(REDUCE, 376);
   _actionMap[645][MINUS] = ActionEntry(REDUCE, 376);
   _actionMap[645][DIVISION] = ActionEntry(REDUCE, 376);
   _actionMap[645][STAR] = ActionEntry(REDUCE, 376);
   _actionMap[645][CONCAT] = ActionEntry(REDUCE, 376);
   _actionMap[645][SEMICOLON] = ActionEntry(REDUCE, 376);
   _actionMap[646][WHEN] = ActionEntry(REDUCE, 351);
   _actionMap[646][ELSE] = ActionEntry(REDUCE, 351);
   _actionMap[646][LEFT] = ActionEntry(REDUCE, 351);
   _actionMap[646][RIGHT] = ActionEntry(REDUCE, 351);
   _actionMap[646][INNER] = ActionEntry(REDUCE, 351);
   _actionMap[646][JOIN] = ActionEntry(REDUCE, 351);
   _actionMap[646][ORDER] = ActionEntry(REDUCE, 351);
   _actionMap[646][GROUP] = ActionEntry(REDUCE, 351);
}
void Cego::loadParser93()
{
   _actionMap[646][RETURNTOKEN] = ActionEntry(REDUCE, 351);
   _actionMap[646][WHERE] = ActionEntry(REDUCE, 351);
   _actionMap[646][FROM] = ActionEntry(REDUCE, 351);
   _actionMap[646][AS] = ActionEntry(REDUCE, 351);
   _actionMap[646][END_TOKEN] = ActionEntry(REDUCE, 351);
   _actionMap[646][BEGIN] = ActionEntry(REDUCE, 351);
   _actionMap[646][THEN] = ActionEntry(REDUCE, 351);
   _actionMap[646][AND] = ActionEntry(REDUCE, 351);
   _actionMap[646][OR] = ActionEntry(REDUCE, 351);
   _actionMap[646][INTOK] = ActionEntry(REDUCE, 351);
   _actionMap[646][NOT] = ActionEntry(REDUCE, 351);
   _actionMap[646][MT] = ActionEntry(REDUCE, 351);
   _actionMap[646][LT] = ActionEntry(REDUCE, 351);
   _actionMap[646][NEGATION] = ActionEntry(REDUCE, 351);
   _actionMap[646][EQU] = ActionEntry(REDUCE, 351);
   _actionMap[646][BETWEEN] = ActionEntry(REDUCE, 351);
   _actionMap[646][IS] = ActionEntry(REDUCE, 351);
   _actionMap[646][LIKE] = ActionEntry(REDUCE, 351);
   _actionMap[646][NCLIKE] = ActionEntry(REDUCE, 351);
   _actionMap[646][RB] = ActionEntry(REDUCE, 351);
   _actionMap[646][ENDTOKEN] = ActionEntry(REDUCE, 351);
   _actionMap[646][UNION] = ActionEntry(REDUCE, 351);
   _actionMap[646][ROWLIMIT] = ActionEntry(REDUCE, 351);
   _actionMap[646][KSEP] = ActionEntry(REDUCE, 351);
   _actionMap[646][ASC] = ActionEntry(REDUCE, 351);
   _actionMap[646][DESC] = ActionEntry(REDUCE, 351);
   _actionMap[646][PLUS] = ActionEntry(REDUCE, 351);
   _actionMap[646][MINUS] = ActionEntry(REDUCE, 351);
   _actionMap[646][DIVISION] = ActionEntry(REDUCE, 351);
   _actionMap[646][STAR] = ActionEntry(REDUCE, 351);
   _actionMap[646][CONCAT] = ActionEntry(REDUCE, 351);
   _actionMap[646][SEMICOLON] = ActionEntry(REDUCE, 351);
   _actionMap[647][WHEN] = ActionEntry(REDUCE, 345);
   _actionMap[647][ELSE] = ActionEntry(REDUCE, 345);
   _actionMap[647][LEFT] = ActionEntry(REDUCE, 345);
   _actionMap[647][RIGHT] = ActionEntry(REDUCE, 345);
   _actionMap[647][INNER] = ActionEntry(REDUCE, 345);
   _actionMap[647][JOIN] = ActionEntry(REDUCE, 345);
   _actionMap[647][ORDER] = ActionEntry(REDUCE, 345);
   _actionMap[647][GROUP] = ActionEntry(REDUCE, 345);
   _actionMap[647][RETURNTOKEN] = ActionEntry(REDUCE, 345);
   _actionMap[647][WHERE] = ActionEntry(REDUCE, 345);
   _actionMap[647][FROM] = ActionEntry(REDUCE, 345);
   _actionMap[647][AS] = ActionEntry(REDUCE, 345);
   _actionMap[647][END_TOKEN] = ActionEntry(REDUCE, 345);
   _actionMap[647][BEGIN] = ActionEntry(REDUCE, 345);
   _actionMap[647][THEN] = ActionEntry(REDUCE, 345);
   _actionMap[647][AND] = ActionEntry(REDUCE, 345);
   _actionMap[647][OR] = ActionEntry(REDUCE, 345);
   _actionMap[647][INTOK] = ActionEntry(REDUCE, 345);
}
void Cego::loadParser94()
{
   _actionMap[647][NOT] = ActionEntry(REDUCE, 345);
   _actionMap[647][MT] = ActionEntry(REDUCE, 345);
   _actionMap[647][LT] = ActionEntry(REDUCE, 345);
   _actionMap[647][NEGATION] = ActionEntry(REDUCE, 345);
   _actionMap[647][EQU] = ActionEntry(REDUCE, 345);
   _actionMap[647][BETWEEN] = ActionEntry(REDUCE, 345);
   _actionMap[647][IS] = ActionEntry(REDUCE, 345);
   _actionMap[647][LIKE] = ActionEntry(REDUCE, 345);
   _actionMap[647][NCLIKE] = ActionEntry(REDUCE, 345);
   _actionMap[647][RB] = ActionEntry(REDUCE, 345);
   _actionMap[647][ENDTOKEN] = ActionEntry(REDUCE, 345);
   _actionMap[647][UNION] = ActionEntry(REDUCE, 345);
   _actionMap[647][ROWLIMIT] = ActionEntry(REDUCE, 345);
   _actionMap[647][KSEP] = ActionEntry(REDUCE, 345);
   _actionMap[647][ASC] = ActionEntry(REDUCE, 345);
   _actionMap[647][DESC] = ActionEntry(REDUCE, 345);
   _actionMap[647][PLUS] = ActionEntry(REDUCE, 345);
   _actionMap[647][MINUS] = ActionEntry(REDUCE, 345);
   _actionMap[647][DIVISION] = ActionEntry(REDUCE, 345);
   _actionMap[647][STAR] = ActionEntry(REDUCE, 345);
   _actionMap[647][CONCAT] = ActionEntry(REDUCE, 345);
   _actionMap[647][SEMICOLON] = ActionEntry(REDUCE, 345);
   _actionMap[648][WHEN] = ActionEntry(REDUCE, 346);
   _actionMap[648][ELSE] = ActionEntry(REDUCE, 346);
   _actionMap[648][LEFT] = ActionEntry(REDUCE, 346);
   _actionMap[648][RIGHT] = ActionEntry(REDUCE, 346);
   _actionMap[648][INNER] = ActionEntry(REDUCE, 346);
   _actionMap[648][JOIN] = ActionEntry(REDUCE, 346);
   _actionMap[648][ORDER] = ActionEntry(REDUCE, 346);
   _actionMap[648][GROUP] = ActionEntry(REDUCE, 346);
   _actionMap[648][RETURNTOKEN] = ActionEntry(REDUCE, 346);
   _actionMap[648][WHERE] = ActionEntry(REDUCE, 346);
   _actionMap[648][FROM] = ActionEntry(REDUCE, 346);
   _actionMap[648][AS] = ActionEntry(REDUCE, 346);
   _actionMap[648][END_TOKEN] = ActionEntry(REDUCE, 346);
   _actionMap[648][BEGIN] = ActionEntry(REDUCE, 346);
   _actionMap[648][THEN] = ActionEntry(REDUCE, 346);
   _actionMap[648][AND] = ActionEntry(REDUCE, 346);
   _actionMap[648][OR] = ActionEntry(REDUCE, 346);
   _actionMap[648][INTOK] = ActionEntry(REDUCE, 346);
   _actionMap[648][NOT] = ActionEntry(REDUCE, 346);
   _actionMap[648][MT] = ActionEntry(REDUCE, 346);
   _actionMap[648][LT] = ActionEntry(REDUCE, 346);
   _actionMap[648][NEGATION] = ActionEntry(REDUCE, 346);
   _actionMap[648][EQU] = ActionEntry(REDUCE, 346);
   _actionMap[648][BETWEEN] = ActionEntry(REDUCE, 346);
   _actionMap[648][IS] = ActionEntry(REDUCE, 346);
   _actionMap[648][LIKE] = ActionEntry(REDUCE, 346);
   _actionMap[648][NCLIKE] = ActionEntry(REDUCE, 346);
   _actionMap[648][RB] = ActionEntry(REDUCE, 346);
}
void Cego::loadParser95()
{
   _actionMap[648][ENDTOKEN] = ActionEntry(REDUCE, 346);
   _actionMap[648][UNION] = ActionEntry(REDUCE, 346);
   _actionMap[648][ROWLIMIT] = ActionEntry(REDUCE, 346);
   _actionMap[648][KSEP] = ActionEntry(REDUCE, 346);
   _actionMap[648][ASC] = ActionEntry(REDUCE, 346);
   _actionMap[648][DESC] = ActionEntry(REDUCE, 346);
   _actionMap[648][PLUS] = ActionEntry(REDUCE, 346);
   _actionMap[648][MINUS] = ActionEntry(REDUCE, 346);
   _actionMap[648][DIVISION] = ActionEntry(REDUCE, 346);
   _actionMap[648][STAR] = ActionEntry(REDUCE, 346);
   _actionMap[648][CONCAT] = ActionEntry(REDUCE, 346);
   _actionMap[648][SEMICOLON] = ActionEntry(REDUCE, 346);
   _actionMap[649][WHEN] = ActionEntry(REDUCE, 336);
   _actionMap[649][ELSE] = ActionEntry(REDUCE, 336);
   _actionMap[649][LEFT] = ActionEntry(REDUCE, 336);
   _actionMap[649][RIGHT] = ActionEntry(REDUCE, 336);
   _actionMap[649][INNER] = ActionEntry(REDUCE, 336);
   _actionMap[649][JOIN] = ActionEntry(REDUCE, 336);
   _actionMap[649][ORDER] = ActionEntry(REDUCE, 336);
   _actionMap[649][GROUP] = ActionEntry(REDUCE, 336);
   _actionMap[649][RETURNTOKEN] = ActionEntry(REDUCE, 336);
   _actionMap[649][WHERE] = ActionEntry(REDUCE, 336);
   _actionMap[649][FROM] = ActionEntry(REDUCE, 336);
   _actionMap[649][AS] = ActionEntry(REDUCE, 336);
   _actionMap[649][END_TOKEN] = ActionEntry(REDUCE, 336);
   _actionMap[649][BEGIN] = ActionEntry(REDUCE, 336);
   _actionMap[649][THEN] = ActionEntry(REDUCE, 336);
   _actionMap[649][AND] = ActionEntry(REDUCE, 336);
   _actionMap[649][OR] = ActionEntry(REDUCE, 336);
   _actionMap[649][INTOK] = ActionEntry(REDUCE, 336);
   _actionMap[649][NOT] = ActionEntry(REDUCE, 336);
   _actionMap[649][MT] = ActionEntry(REDUCE, 336);
   _actionMap[649][LT] = ActionEntry(REDUCE, 336);
   _actionMap[649][NEGATION] = ActionEntry(REDUCE, 336);
   _actionMap[649][EQU] = ActionEntry(REDUCE, 336);
   _actionMap[649][BETWEEN] = ActionEntry(REDUCE, 336);
   _actionMap[649][IS] = ActionEntry(REDUCE, 336);
   _actionMap[649][LIKE] = ActionEntry(REDUCE, 336);
   _actionMap[649][NCLIKE] = ActionEntry(REDUCE, 336);
   _actionMap[649][RB] = ActionEntry(REDUCE, 336);
   _actionMap[649][ENDTOKEN] = ActionEntry(REDUCE, 336);
   _actionMap[649][UNION] = ActionEntry(REDUCE, 336);
   _actionMap[649][ROWLIMIT] = ActionEntry(REDUCE, 336);
   _actionMap[649][KSEP] = ActionEntry(REDUCE, 336);
   _actionMap[649][ASC] = ActionEntry(REDUCE, 336);
   _actionMap[649][DESC] = ActionEntry(REDUCE, 336);
   _actionMap[649][PLUS] = ActionEntry(REDUCE, 336);
   _actionMap[649][MINUS] = ActionEntry(REDUCE, 336);
   _actionMap[649][DIVISION] = ActionEntry(REDUCE, 336);
   _actionMap[649][STAR] = ActionEntry(REDUCE, 336);
}
void Cego::loadParser96()
{
   _actionMap[649][CONCAT] = ActionEntry(REDUCE, 336);
   _actionMap[649][SEMICOLON] = ActionEntry(REDUCE, 336);
   _actionMap[650][WHEN] = ActionEntry(REDUCE, 349);
   _actionMap[650][ELSE] = ActionEntry(REDUCE, 349);
   _actionMap[650][LEFT] = ActionEntry(REDUCE, 349);
   _actionMap[650][RIGHT] = ActionEntry(REDUCE, 349);
   _actionMap[650][INNER] = ActionEntry(REDUCE, 349);
   _actionMap[650][JOIN] = ActionEntry(REDUCE, 349);
   _actionMap[650][ORDER] = ActionEntry(REDUCE, 349);
   _actionMap[650][GROUP] = ActionEntry(REDUCE, 349);
   _actionMap[650][RETURNTOKEN] = ActionEntry(REDUCE, 349);
   _actionMap[650][WHERE] = ActionEntry(REDUCE, 349);
   _actionMap[650][FROM] = ActionEntry(REDUCE, 349);
   _actionMap[650][AS] = ActionEntry(REDUCE, 349);
   _actionMap[650][END_TOKEN] = ActionEntry(REDUCE, 349);
   _actionMap[650][BEGIN] = ActionEntry(REDUCE, 349);
   _actionMap[650][THEN] = ActionEntry(REDUCE, 349);
   _actionMap[650][AND] = ActionEntry(REDUCE, 349);
   _actionMap[650][OR] = ActionEntry(REDUCE, 349);
   _actionMap[650][INTOK] = ActionEntry(REDUCE, 349);
   _actionMap[650][NOT] = ActionEntry(REDUCE, 349);
   _actionMap[650][MT] = ActionEntry(REDUCE, 349);
   _actionMap[650][LT] = ActionEntry(REDUCE, 349);
   _actionMap[650][NEGATION] = ActionEntry(REDUCE, 349);
   _actionMap[650][EQU] = ActionEntry(REDUCE, 349);
   _actionMap[650][BETWEEN] = ActionEntry(REDUCE, 349);
   _actionMap[650][IS] = ActionEntry(REDUCE, 349);
   _actionMap[650][LIKE] = ActionEntry(REDUCE, 349);
   _actionMap[650][NCLIKE] = ActionEntry(REDUCE, 349);
   _actionMap[650][RB] = ActionEntry(REDUCE, 349);
   _actionMap[650][ENDTOKEN] = ActionEntry(REDUCE, 349);
   _actionMap[650][UNION] = ActionEntry(REDUCE, 349);
   _actionMap[650][ROWLIMIT] = ActionEntry(REDUCE, 349);
   _actionMap[650][KSEP] = ActionEntry(REDUCE, 349);
   _actionMap[650][ASC] = ActionEntry(REDUCE, 349);
   _actionMap[650][DESC] = ActionEntry(REDUCE, 349);
   _actionMap[650][PLUS] = ActionEntry(REDUCE, 349);
   _actionMap[650][MINUS] = ActionEntry(REDUCE, 349);
   _actionMap[650][DIVISION] = ActionEntry(REDUCE, 349);
   _actionMap[650][STAR] = ActionEntry(REDUCE, 349);
   _actionMap[650][CONCAT] = ActionEntry(REDUCE, 349);
   _actionMap[650][SEMICOLON] = ActionEntry(REDUCE, 349);
   _actionMap[651][WHEN] = ActionEntry(REDUCE, 354);
   _actionMap[651][ELSE] = ActionEntry(REDUCE, 354);
   _actionMap[651][LEFT] = ActionEntry(REDUCE, 354);
   _actionMap[651][RIGHT] = ActionEntry(REDUCE, 354);
   _actionMap[651][INNER] = ActionEntry(REDUCE, 354);
   _actionMap[651][JOIN] = ActionEntry(REDUCE, 354);
   _actionMap[651][ORDER] = ActionEntry(REDUCE, 354);
   _actionMap[651][GROUP] = ActionEntry(REDUCE, 354);
}
void Cego::loadParser97()
{
   _actionMap[651][RETURNTOKEN] = ActionEntry(REDUCE, 354);
   _actionMap[651][WHERE] = ActionEntry(REDUCE, 354);
   _actionMap[651][FROM] = ActionEntry(REDUCE, 354);
   _actionMap[651][AS] = ActionEntry(REDUCE, 354);
   _actionMap[651][END_TOKEN] = ActionEntry(REDUCE, 354);
   _actionMap[651][BEGIN] = ActionEntry(REDUCE, 354);
   _actionMap[651][THEN] = ActionEntry(REDUCE, 354);
   _actionMap[651][AND] = ActionEntry(REDUCE, 354);
   _actionMap[651][OR] = ActionEntry(REDUCE, 354);
   _actionMap[651][INTOK] = ActionEntry(REDUCE, 354);
   _actionMap[651][NOT] = ActionEntry(REDUCE, 354);
   _actionMap[651][MT] = ActionEntry(REDUCE, 354);
   _actionMap[651][LT] = ActionEntry(REDUCE, 354);
   _actionMap[651][NEGATION] = ActionEntry(REDUCE, 354);
   _actionMap[651][EQU] = ActionEntry(REDUCE, 354);
   _actionMap[651][BETWEEN] = ActionEntry(REDUCE, 354);
   _actionMap[651][IS] = ActionEntry(REDUCE, 354);
   _actionMap[651][LIKE] = ActionEntry(REDUCE, 354);
   _actionMap[651][NCLIKE] = ActionEntry(REDUCE, 354);
   _actionMap[651][RB] = ActionEntry(REDUCE, 354);
   _actionMap[651][ENDTOKEN] = ActionEntry(REDUCE, 354);
   _actionMap[651][UNION] = ActionEntry(REDUCE, 354);
   _actionMap[651][ROWLIMIT] = ActionEntry(REDUCE, 354);
   _actionMap[651][KSEP] = ActionEntry(REDUCE, 354);
   _actionMap[651][ASC] = ActionEntry(REDUCE, 354);
   _actionMap[651][DESC] = ActionEntry(REDUCE, 354);
   _actionMap[651][PLUS] = ActionEntry(REDUCE, 354);
   _actionMap[651][MINUS] = ActionEntry(REDUCE, 354);
   _actionMap[651][DIVISION] = ActionEntry(REDUCE, 354);
   _actionMap[651][STAR] = ActionEntry(REDUCE, 354);
   _actionMap[651][CONCAT] = ActionEntry(REDUCE, 354);
   _actionMap[651][SEMICOLON] = ActionEntry(REDUCE, 354);
   _actionMap[652][WHEN] = ActionEntry(REDUCE, 363);
   _actionMap[652][ELSE] = ActionEntry(REDUCE, 363);
   _actionMap[652][LEFT] = ActionEntry(REDUCE, 363);
   _actionMap[652][RIGHT] = ActionEntry(REDUCE, 363);
   _actionMap[652][INNER] = ActionEntry(REDUCE, 363);
   _actionMap[652][JOIN] = ActionEntry(REDUCE, 363);
   _actionMap[652][ORDER] = ActionEntry(REDUCE, 363);
   _actionMap[652][GROUP] = ActionEntry(REDUCE, 363);
   _actionMap[652][RETURNTOKEN] = ActionEntry(REDUCE, 363);
   _actionMap[652][WHERE] = ActionEntry(REDUCE, 363);
   _actionMap[652][FROM] = ActionEntry(REDUCE, 363);
   _actionMap[652][AS] = ActionEntry(REDUCE, 363);
   _actionMap[652][END_TOKEN] = ActionEntry(REDUCE, 363);
   _actionMap[652][BEGIN] = ActionEntry(REDUCE, 363);
   _actionMap[652][THEN] = ActionEntry(REDUCE, 363);
   _actionMap[652][AND] = ActionEntry(REDUCE, 363);
   _actionMap[652][OR] = ActionEntry(REDUCE, 363);
   _actionMap[652][INTOK] = ActionEntry(REDUCE, 363);
}
void Cego::loadParser98()
{
   _actionMap[652][NOT] = ActionEntry(REDUCE, 363);
   _actionMap[652][MT] = ActionEntry(REDUCE, 363);
   _actionMap[652][LT] = ActionEntry(REDUCE, 363);
   _actionMap[652][NEGATION] = ActionEntry(REDUCE, 363);
   _actionMap[652][EQU] = ActionEntry(REDUCE, 363);
   _actionMap[652][BETWEEN] = ActionEntry(REDUCE, 363);
   _actionMap[652][IS] = ActionEntry(REDUCE, 363);
   _actionMap[652][LIKE] = ActionEntry(REDUCE, 363);
   _actionMap[652][NCLIKE] = ActionEntry(REDUCE, 363);
   _actionMap[652][RB] = ActionEntry(REDUCE, 363);
   _actionMap[652][ENDTOKEN] = ActionEntry(REDUCE, 363);
   _actionMap[652][UNION] = ActionEntry(REDUCE, 363);
   _actionMap[652][ROWLIMIT] = ActionEntry(REDUCE, 363);
   _actionMap[652][KSEP] = ActionEntry(REDUCE, 363);
   _actionMap[652][ASC] = ActionEntry(REDUCE, 363);
   _actionMap[652][DESC] = ActionEntry(REDUCE, 363);
   _actionMap[652][PLUS] = ActionEntry(REDUCE, 363);
   _actionMap[652][MINUS] = ActionEntry(REDUCE, 363);
   _actionMap[652][DIVISION] = ActionEntry(REDUCE, 363);
   _actionMap[652][STAR] = ActionEntry(REDUCE, 363);
   _actionMap[652][CONCAT] = ActionEntry(REDUCE, 363);
   _actionMap[652][SEMICOLON] = ActionEntry(REDUCE, 363);
   _actionMap[653][WHEN] = ActionEntry(REDUCE, 362);
   _actionMap[653][ELSE] = ActionEntry(REDUCE, 362);
   _actionMap[653][LEFT] = ActionEntry(REDUCE, 362);
   _actionMap[653][RIGHT] = ActionEntry(REDUCE, 362);
   _actionMap[653][INNER] = ActionEntry(REDUCE, 362);
   _actionMap[653][JOIN] = ActionEntry(REDUCE, 362);
   _actionMap[653][ORDER] = ActionEntry(REDUCE, 362);
   _actionMap[653][GROUP] = ActionEntry(REDUCE, 362);
   _actionMap[653][RETURNTOKEN] = ActionEntry(REDUCE, 362);
   _actionMap[653][WHERE] = ActionEntry(REDUCE, 362);
   _actionMap[653][FROM] = ActionEntry(REDUCE, 362);
   _actionMap[653][AS] = ActionEntry(REDUCE, 362);
   _actionMap[653][END_TOKEN] = ActionEntry(REDUCE, 362);
   _actionMap[653][BEGIN] = ActionEntry(REDUCE, 362);
   _actionMap[653][THEN] = ActionEntry(REDUCE, 362);
   _actionMap[653][AND] = ActionEntry(REDUCE, 362);
   _actionMap[653][OR] = ActionEntry(REDUCE, 362);
   _actionMap[653][INTOK] = ActionEntry(REDUCE, 362);
   _actionMap[653][NOT] = ActionEntry(REDUCE, 362);
   _actionMap[653][MT] = ActionEntry(REDUCE, 362);
   _actionMap[653][LT] = ActionEntry(REDUCE, 362);
   _actionMap[653][NEGATION] = ActionEntry(REDUCE, 362);
   _actionMap[653][EQU] = ActionEntry(REDUCE, 362);
   _actionMap[653][BETWEEN] = ActionEntry(REDUCE, 362);
   _actionMap[653][IS] = ActionEntry(REDUCE, 362);
   _actionMap[653][LIKE] = ActionEntry(REDUCE, 362);
   _actionMap[653][NCLIKE] = ActionEntry(REDUCE, 362);
   _actionMap[653][RB] = ActionEntry(REDUCE, 362);
}
void Cego::loadParser99()
{
   _actionMap[653][ENDTOKEN] = ActionEntry(REDUCE, 362);
   _actionMap[653][UNION] = ActionEntry(REDUCE, 362);
   _actionMap[653][ROWLIMIT] = ActionEntry(REDUCE, 362);
   _actionMap[653][KSEP] = ActionEntry(REDUCE, 362);
   _actionMap[653][ASC] = ActionEntry(REDUCE, 362);
   _actionMap[653][DESC] = ActionEntry(REDUCE, 362);
   _actionMap[653][PLUS] = ActionEntry(REDUCE, 362);
   _actionMap[653][MINUS] = ActionEntry(REDUCE, 362);
   _actionMap[653][DIVISION] = ActionEntry(REDUCE, 362);
   _actionMap[653][STAR] = ActionEntry(REDUCE, 362);
   _actionMap[653][CONCAT] = ActionEntry(REDUCE, 362);
   _actionMap[653][SEMICOLON] = ActionEntry(REDUCE, 362);
   _actionMap[654][WHEN] = ActionEntry(REDUCE, 347);
   _actionMap[654][ELSE] = ActionEntry(REDUCE, 347);
   _actionMap[654][LEFT] = ActionEntry(REDUCE, 347);
   _actionMap[654][RIGHT] = ActionEntry(REDUCE, 347);
   _actionMap[654][INNER] = ActionEntry(REDUCE, 347);
   _actionMap[654][JOIN] = ActionEntry(REDUCE, 347);
   _actionMap[654][ORDER] = ActionEntry(REDUCE, 347);
   _actionMap[654][GROUP] = ActionEntry(REDUCE, 347);
   _actionMap[654][RETURNTOKEN] = ActionEntry(REDUCE, 347);
   _actionMap[654][WHERE] = ActionEntry(REDUCE, 347);
   _actionMap[654][FROM] = ActionEntry(REDUCE, 347);
   _actionMap[654][AS] = ActionEntry(REDUCE, 347);
   _actionMap[654][END_TOKEN] = ActionEntry(REDUCE, 347);
   _actionMap[654][BEGIN] = ActionEntry(REDUCE, 347);
   _actionMap[654][THEN] = ActionEntry(REDUCE, 347);
   _actionMap[654][AND] = ActionEntry(REDUCE, 347);
   _actionMap[654][OR] = ActionEntry(REDUCE, 347);
   _actionMap[654][INTOK] = ActionEntry(REDUCE, 347);
   _actionMap[654][NOT] = ActionEntry(REDUCE, 347);
   _actionMap[654][MT] = ActionEntry(REDUCE, 347);
   _actionMap[654][LT] = ActionEntry(REDUCE, 347);
   _actionMap[654][NEGATION] = ActionEntry(REDUCE, 347);
   _actionMap[654][EQU] = ActionEntry(REDUCE, 347);
   _actionMap[654][BETWEEN] = ActionEntry(REDUCE, 347);
   _actionMap[654][IS] = ActionEntry(REDUCE, 347);
   _actionMap[654][LIKE] = ActionEntry(REDUCE, 347);
   _actionMap[654][NCLIKE] = ActionEntry(REDUCE, 347);
   _actionMap[654][RB] = ActionEntry(REDUCE, 347);
   _actionMap[654][ENDTOKEN] = ActionEntry(REDUCE, 347);
   _actionMap[654][UNION] = ActionEntry(REDUCE, 347);
   _actionMap[654][ROWLIMIT] = ActionEntry(REDUCE, 347);
   _actionMap[654][KSEP] = ActionEntry(REDUCE, 347);
   _actionMap[654][ASC] = ActionEntry(REDUCE, 347);
   _actionMap[654][DESC] = ActionEntry(REDUCE, 347);
   _actionMap[654][PLUS] = ActionEntry(REDUCE, 347);
   _actionMap[654][MINUS] = ActionEntry(REDUCE, 347);
   _actionMap[654][DIVISION] = ActionEntry(REDUCE, 347);
   _actionMap[654][STAR] = ActionEntry(REDUCE, 347);
}
void Cego::loadParser100()
{
   _actionMap[654][CONCAT] = ActionEntry(REDUCE, 347);
   _actionMap[654][SEMICOLON] = ActionEntry(REDUCE, 347);
   _actionMap[655][WHEN] = ActionEntry(REDUCE, 340);
   _actionMap[655][ELSE] = ActionEntry(REDUCE, 340);
   _actionMap[655][LEFT] = ActionEntry(REDUCE, 340);
   _actionMap[655][RIGHT] = ActionEntry(REDUCE, 340);
   _actionMap[655][INNER] = ActionEntry(REDUCE, 340);
   _actionMap[655][JOIN] = ActionEntry(REDUCE, 340);
   _actionMap[655][ORDER] = ActionEntry(REDUCE, 340);
   _actionMap[655][GROUP] = ActionEntry(REDUCE, 340);
   _actionMap[655][RETURNTOKEN] = ActionEntry(REDUCE, 340);
   _actionMap[655][WHERE] = ActionEntry(REDUCE, 340);
   _actionMap[655][FROM] = ActionEntry(REDUCE, 340);
   _actionMap[655][AS] = ActionEntry(REDUCE, 340);
   _actionMap[655][END_TOKEN] = ActionEntry(REDUCE, 340);
   _actionMap[655][BEGIN] = ActionEntry(REDUCE, 340);
   _actionMap[655][THEN] = ActionEntry(REDUCE, 340);
   _actionMap[655][AND] = ActionEntry(REDUCE, 340);
   _actionMap[655][OR] = ActionEntry(REDUCE, 340);
   _actionMap[655][INTOK] = ActionEntry(REDUCE, 340);
   _actionMap[655][NOT] = ActionEntry(REDUCE, 340);
   _actionMap[655][MT] = ActionEntry(REDUCE, 340);
   _actionMap[655][LT] = ActionEntry(REDUCE, 340);
   _actionMap[655][NEGATION] = ActionEntry(REDUCE, 340);
   _actionMap[655][EQU] = ActionEntry(REDUCE, 340);
   _actionMap[655][BETWEEN] = ActionEntry(REDUCE, 340);
   _actionMap[655][IS] = ActionEntry(REDUCE, 340);
   _actionMap[655][LIKE] = ActionEntry(REDUCE, 340);
   _actionMap[655][NCLIKE] = ActionEntry(REDUCE, 340);
   _actionMap[655][RB] = ActionEntry(REDUCE, 340);
   _actionMap[655][ENDTOKEN] = ActionEntry(REDUCE, 340);
   _actionMap[655][UNION] = ActionEntry(REDUCE, 340);
   _actionMap[655][ROWLIMIT] = ActionEntry(REDUCE, 340);
   _actionMap[655][KSEP] = ActionEntry(REDUCE, 340);
   _actionMap[655][ASC] = ActionEntry(REDUCE, 340);
   _actionMap[655][DESC] = ActionEntry(REDUCE, 340);
   _actionMap[655][PLUS] = ActionEntry(REDUCE, 340);
   _actionMap[655][MINUS] = ActionEntry(REDUCE, 340);
   _actionMap[655][DIVISION] = ActionEntry(REDUCE, 340);
   _actionMap[655][STAR] = ActionEntry(REDUCE, 340);
   _actionMap[655][CONCAT] = ActionEntry(REDUCE, 340);
   _actionMap[655][SEMICOLON] = ActionEntry(REDUCE, 340);
   _actionMap[656][WHEN] = ActionEntry(REDUCE, 334);
   _actionMap[656][ELSE] = ActionEntry(REDUCE, 334);
   _actionMap[656][LEFT] = ActionEntry(REDUCE, 334);
   _actionMap[656][RIGHT] = ActionEntry(REDUCE, 334);
   _actionMap[656][INNER] = ActionEntry(REDUCE, 334);
   _actionMap[656][JOIN] = ActionEntry(REDUCE, 334);
   _actionMap[656][ORDER] = ActionEntry(REDUCE, 334);
   _actionMap[656][GROUP] = ActionEntry(REDUCE, 334);
}
void Cego::loadParser101()
{
   _actionMap[656][RETURNTOKEN] = ActionEntry(REDUCE, 334);
   _actionMap[656][WHERE] = ActionEntry(REDUCE, 334);
   _actionMap[656][AS] = ActionEntry(REDUCE, 334);
   _actionMap[656][FROM] = ActionEntry(REDUCE, 334);
   _actionMap[656][END_TOKEN] = ActionEntry(REDUCE, 334);
   _actionMap[656][BEGIN] = ActionEntry(REDUCE, 334);
   _actionMap[656][THEN] = ActionEntry(REDUCE, 334);
   _actionMap[656][OR] = ActionEntry(REDUCE, 334);
   _actionMap[656][AND] = ActionEntry(REDUCE, 334);
   _actionMap[656][NCLIKE] = ActionEntry(REDUCE, 334);
   _actionMap[656][LIKE] = ActionEntry(REDUCE, 334);
   _actionMap[656][IS] = ActionEntry(REDUCE, 334);
   _actionMap[656][BETWEEN] = ActionEntry(REDUCE, 334);
   _actionMap[656][EQU] = ActionEntry(REDUCE, 334);
   _actionMap[656][NEGATION] = ActionEntry(REDUCE, 334);
   _actionMap[656][LT] = ActionEntry(REDUCE, 334);
   _actionMap[656][MT] = ActionEntry(REDUCE, 334);
   _actionMap[656][NOT] = ActionEntry(REDUCE, 334);
   _actionMap[656][INTOK] = ActionEntry(REDUCE, 334);
   _actionMap[656][DESC] = ActionEntry(REDUCE, 334);
   _actionMap[656][ASC] = ActionEntry(REDUCE, 334);
   _actionMap[656][KSEP] = ActionEntry(REDUCE, 334);
   _actionMap[656][ROWLIMIT] = ActionEntry(REDUCE, 334);
   _actionMap[656][UNION] = ActionEntry(REDUCE, 334);
   _actionMap[656][ENDTOKEN] = ActionEntry(REDUCE, 334);
   _actionMap[656][RB] = ActionEntry(REDUCE, 334);
   _actionMap[656][CONCAT] = ActionEntry(REDUCE, 334);
   _actionMap[656][STAR] = ActionEntry(REDUCE, 334);
   _actionMap[656][DIVISION] = ActionEntry(REDUCE, 334);
   _actionMap[656][MINUS] = ActionEntry(REDUCE, 334);
   _actionMap[656][PLUS] = ActionEntry(REDUCE, 334);
   _actionMap[656][SEMICOLON] = ActionEntry(REDUCE, 334);
   _actionMap[657][WHEN] = ActionEntry(REDUCE, 335);
   _actionMap[657][ELSE] = ActionEntry(REDUCE, 335);
   _actionMap[657][LEFT] = ActionEntry(REDUCE, 335);
   _actionMap[657][RIGHT] = ActionEntry(REDUCE, 335);
   _actionMap[657][INNER] = ActionEntry(REDUCE, 335);
   _actionMap[657][JOIN] = ActionEntry(REDUCE, 335);
   _actionMap[657][ORDER] = ActionEntry(REDUCE, 335);
   _actionMap[657][GROUP] = ActionEntry(REDUCE, 335);
   _actionMap[657][RETURNTOKEN] = ActionEntry(REDUCE, 335);
   _actionMap[657][WHERE] = ActionEntry(REDUCE, 335);
   _actionMap[657][AS] = ActionEntry(REDUCE, 335);
   _actionMap[657][FROM] = ActionEntry(REDUCE, 335);
   _actionMap[657][END_TOKEN] = ActionEntry(REDUCE, 335);
   _actionMap[657][BEGIN] = ActionEntry(REDUCE, 335);
   _actionMap[657][THEN] = ActionEntry(REDUCE, 335);
   _actionMap[657][OR] = ActionEntry(REDUCE, 335);
   _actionMap[657][AND] = ActionEntry(REDUCE, 335);
   _actionMap[657][NCLIKE] = ActionEntry(REDUCE, 335);
}
void Cego::loadParser102()
{
   _actionMap[657][LIKE] = ActionEntry(REDUCE, 335);
   _actionMap[657][IS] = ActionEntry(REDUCE, 335);
   _actionMap[657][BETWEEN] = ActionEntry(REDUCE, 335);
   _actionMap[657][EQU] = ActionEntry(REDUCE, 335);
   _actionMap[657][NEGATION] = ActionEntry(REDUCE, 335);
   _actionMap[657][LT] = ActionEntry(REDUCE, 335);
   _actionMap[657][MT] = ActionEntry(REDUCE, 335);
   _actionMap[657][NOT] = ActionEntry(REDUCE, 335);
   _actionMap[657][INTOK] = ActionEntry(REDUCE, 335);
   _actionMap[657][DESC] = ActionEntry(REDUCE, 335);
   _actionMap[657][ASC] = ActionEntry(REDUCE, 335);
   _actionMap[657][KSEP] = ActionEntry(REDUCE, 335);
   _actionMap[657][ROWLIMIT] = ActionEntry(REDUCE, 335);
   _actionMap[657][UNION] = ActionEntry(REDUCE, 335);
   _actionMap[657][ENDTOKEN] = ActionEntry(REDUCE, 335);
   _actionMap[657][RB] = ActionEntry(REDUCE, 335);
   _actionMap[657][CONCAT] = ActionEntry(REDUCE, 335);
   _actionMap[657][STAR] = ActionEntry(REDUCE, 335);
   _actionMap[657][DIVISION] = ActionEntry(REDUCE, 335);
   _actionMap[657][MINUS] = ActionEntry(REDUCE, 335);
   _actionMap[657][PLUS] = ActionEntry(REDUCE, 335);
   _actionMap[657][SEMICOLON] = ActionEntry(REDUCE, 335);
   _actionMap[658][WHEN] = ActionEntry(REDUCE, 360);
   _actionMap[658][ELSE] = ActionEntry(REDUCE, 360);
   _actionMap[658][LEFT] = ActionEntry(REDUCE, 360);
   _actionMap[658][RIGHT] = ActionEntry(REDUCE, 360);
   _actionMap[658][INNER] = ActionEntry(REDUCE, 360);
   _actionMap[658][JOIN] = ActionEntry(REDUCE, 360);
   _actionMap[658][ORDER] = ActionEntry(REDUCE, 360);
   _actionMap[658][GROUP] = ActionEntry(REDUCE, 360);
   _actionMap[658][RETURNTOKEN] = ActionEntry(REDUCE, 360);
   _actionMap[658][WHERE] = ActionEntry(REDUCE, 360);
   _actionMap[658][FROM] = ActionEntry(REDUCE, 360);
   _actionMap[658][AS] = ActionEntry(REDUCE, 360);
   _actionMap[658][END_TOKEN] = ActionEntry(REDUCE, 360);
   _actionMap[658][BEGIN] = ActionEntry(REDUCE, 360);
   _actionMap[658][THEN] = ActionEntry(REDUCE, 360);
   _actionMap[658][AND] = ActionEntry(REDUCE, 360);
   _actionMap[658][OR] = ActionEntry(REDUCE, 360);
   _actionMap[658][INTOK] = ActionEntry(REDUCE, 360);
   _actionMap[658][NOT] = ActionEntry(REDUCE, 360);
   _actionMap[658][MT] = ActionEntry(REDUCE, 360);
   _actionMap[658][LT] = ActionEntry(REDUCE, 360);
   _actionMap[658][NEGATION] = ActionEntry(REDUCE, 360);
   _actionMap[658][EQU] = ActionEntry(REDUCE, 360);
   _actionMap[658][BETWEEN] = ActionEntry(REDUCE, 360);
   _actionMap[658][IS] = ActionEntry(REDUCE, 360);
   _actionMap[658][LIKE] = ActionEntry(REDUCE, 360);
   _actionMap[658][NCLIKE] = ActionEntry(REDUCE, 360);
   _actionMap[658][RB] = ActionEntry(REDUCE, 360);
}
void Cego::loadParser103()
{
   _actionMap[658][ENDTOKEN] = ActionEntry(REDUCE, 360);
   _actionMap[658][UNION] = ActionEntry(REDUCE, 360);
   _actionMap[658][ROWLIMIT] = ActionEntry(REDUCE, 360);
   _actionMap[658][KSEP] = ActionEntry(REDUCE, 360);
   _actionMap[658][ASC] = ActionEntry(REDUCE, 360);
   _actionMap[658][DESC] = ActionEntry(REDUCE, 360);
   _actionMap[658][PLUS] = ActionEntry(REDUCE, 360);
   _actionMap[658][MINUS] = ActionEntry(REDUCE, 360);
   _actionMap[658][DIVISION] = ActionEntry(REDUCE, 360);
   _actionMap[658][STAR] = ActionEntry(REDUCE, 360);
   _actionMap[658][CONCAT] = ActionEntry(REDUCE, 360);
   _actionMap[658][SEMICOLON] = ActionEntry(REDUCE, 360);
   _actionMap[659][WHEN] = ActionEntry(REDUCE, 374);
   _actionMap[659][ELSE] = ActionEntry(REDUCE, 374);
   _actionMap[659][LEFT] = ActionEntry(REDUCE, 374);
   _actionMap[659][RIGHT] = ActionEntry(REDUCE, 374);
   _actionMap[659][INNER] = ActionEntry(REDUCE, 374);
   _actionMap[659][JOIN] = ActionEntry(REDUCE, 374);
   _actionMap[659][ORDER] = ActionEntry(REDUCE, 374);
   _actionMap[659][GROUP] = ActionEntry(REDUCE, 374);
   _actionMap[659][RETURNTOKEN] = ActionEntry(REDUCE, 374);
   _actionMap[659][WHERE] = ActionEntry(REDUCE, 374);
   _actionMap[659][FROM] = ActionEntry(REDUCE, 374);
   _actionMap[659][AS] = ActionEntry(REDUCE, 374);
   _actionMap[659][END_TOKEN] = ActionEntry(REDUCE, 374);
   _actionMap[659][BEGIN] = ActionEntry(REDUCE, 374);
   _actionMap[659][THEN] = ActionEntry(REDUCE, 374);
   _actionMap[659][AND] = ActionEntry(REDUCE, 374);
   _actionMap[659][OR] = ActionEntry(REDUCE, 374);
   _actionMap[659][INTOK] = ActionEntry(REDUCE, 374);
   _actionMap[659][NOT] = ActionEntry(REDUCE, 374);
   _actionMap[659][MT] = ActionEntry(REDUCE, 374);
   _actionMap[659][LT] = ActionEntry(REDUCE, 374);
   _actionMap[659][NEGATION] = ActionEntry(REDUCE, 374);
   _actionMap[659][EQU] = ActionEntry(REDUCE, 374);
   _actionMap[659][BETWEEN] = ActionEntry(REDUCE, 374);
   _actionMap[659][IS] = ActionEntry(REDUCE, 374);
   _actionMap[659][LIKE] = ActionEntry(REDUCE, 374);
   _actionMap[659][NCLIKE] = ActionEntry(REDUCE, 374);
   _actionMap[659][RB] = ActionEntry(REDUCE, 374);
   _actionMap[659][ENDTOKEN] = ActionEntry(REDUCE, 374);
   _actionMap[659][UNION] = ActionEntry(REDUCE, 374);
   _actionMap[659][ROWLIMIT] = ActionEntry(REDUCE, 374);
   _actionMap[659][KSEP] = ActionEntry(REDUCE, 374);
   _actionMap[659][ASC] = ActionEntry(REDUCE, 374);
   _actionMap[659][DESC] = ActionEntry(REDUCE, 374);
   _actionMap[659][PLUS] = ActionEntry(REDUCE, 374);
   _actionMap[659][MINUS] = ActionEntry(REDUCE, 374);
   _actionMap[659][DIVISION] = ActionEntry(REDUCE, 374);
   _actionMap[659][STAR] = ActionEntry(REDUCE, 374);
}
void Cego::loadParser104()
{
   _actionMap[659][CONCAT] = ActionEntry(REDUCE, 374);
   _actionMap[659][SEMICOLON] = ActionEntry(REDUCE, 374);
   _actionMap[660][WHEN] = ActionEntry(REDUCE, 364);
   _actionMap[660][ELSE] = ActionEntry(REDUCE, 364);
   _actionMap[660][FROM] = ActionEntry(REDUCE, 364);
   _actionMap[660][AS] = ActionEntry(REDUCE, 364);
   _actionMap[660][END_TOKEN] = ActionEntry(REDUCE, 364);
   _actionMap[660][BEGIN] = ActionEntry(REDUCE, 364);
   _actionMap[660][THEN] = ActionEntry(REDUCE, 364);
   _actionMap[660][LEFT] = ActionEntry(REDUCE, 364);
   _actionMap[660][RIGHT] = ActionEntry(REDUCE, 364);
   _actionMap[660][INNER] = ActionEntry(REDUCE, 364);
   _actionMap[660][JOIN] = ActionEntry(REDUCE, 364);
   _actionMap[660][ORDER] = ActionEntry(REDUCE, 364);
   _actionMap[660][GROUP] = ActionEntry(REDUCE, 364);
   _actionMap[660][RETURNTOKEN] = ActionEntry(REDUCE, 364);
   _actionMap[660][WHERE] = ActionEntry(REDUCE, 364);
   _actionMap[660][AND] = ActionEntry(REDUCE, 364);
   _actionMap[660][OR] = ActionEntry(REDUCE, 364);
   _actionMap[660][INTOK] = ActionEntry(REDUCE, 364);
   _actionMap[660][NOT] = ActionEntry(REDUCE, 364);
   _actionMap[660][MT] = ActionEntry(REDUCE, 364);
   _actionMap[660][LT] = ActionEntry(REDUCE, 364);
   _actionMap[660][NEGATION] = ActionEntry(REDUCE, 364);
   _actionMap[660][EQU] = ActionEntry(REDUCE, 364);
   _actionMap[660][BETWEEN] = ActionEntry(REDUCE, 364);
   _actionMap[660][IS] = ActionEntry(REDUCE, 364);
   _actionMap[660][LIKE] = ActionEntry(REDUCE, 364);
   _actionMap[660][NCLIKE] = ActionEntry(REDUCE, 364);
   _actionMap[660][RB] = ActionEntry(REDUCE, 364);
   _actionMap[660][ENDTOKEN] = ActionEntry(REDUCE, 364);
   _actionMap[660][UNION] = ActionEntry(REDUCE, 364);
   _actionMap[660][ROWLIMIT] = ActionEntry(REDUCE, 364);
   _actionMap[660][KSEP] = ActionEntry(REDUCE, 364);
   _actionMap[660][ASC] = ActionEntry(REDUCE, 364);
   _actionMap[660][DESC] = ActionEntry(REDUCE, 364);
   _actionMap[660][PLUS] = ActionEntry(REDUCE, 364);
   _actionMap[660][MINUS] = ActionEntry(REDUCE, 364);
   _actionMap[660][DIVISION] = ActionEntry(REDUCE, 364);
   _actionMap[660][STAR] = ActionEntry(REDUCE, 364);
   _actionMap[660][CONCAT] = ActionEntry(REDUCE, 364);
   _actionMap[660][SEMICOLON] = ActionEntry(REDUCE, 364);
   _actionMap[661][WHEN] = ActionEntry(REDUCE, 358);
   _actionMap[661][ELSE] = ActionEntry(REDUCE, 358);
   _actionMap[661][FROM] = ActionEntry(REDUCE, 358);
   _actionMap[661][AS] = ActionEntry(REDUCE, 358);
   _actionMap[661][END_TOKEN] = ActionEntry(REDUCE, 358);
   _actionMap[661][BEGIN] = ActionEntry(REDUCE, 358);
   _actionMap[661][THEN] = ActionEntry(REDUCE, 358);
   _actionMap[661][LEFT] = ActionEntry(REDUCE, 358);
}
void Cego::loadParser105()
{
   _actionMap[661][RIGHT] = ActionEntry(REDUCE, 358);
   _actionMap[661][INNER] = ActionEntry(REDUCE, 358);
   _actionMap[661][JOIN] = ActionEntry(REDUCE, 358);
   _actionMap[661][ORDER] = ActionEntry(REDUCE, 358);
   _actionMap[661][GROUP] = ActionEntry(REDUCE, 358);
   _actionMap[661][RETURNTOKEN] = ActionEntry(REDUCE, 358);
   _actionMap[661][WHERE] = ActionEntry(REDUCE, 358);
   _actionMap[661][AND] = ActionEntry(REDUCE, 358);
   _actionMap[661][OR] = ActionEntry(REDUCE, 358);
   _actionMap[661][INTOK] = ActionEntry(REDUCE, 358);
   _actionMap[661][NOT] = ActionEntry(REDUCE, 358);
   _actionMap[661][MT] = ActionEntry(REDUCE, 358);
   _actionMap[661][LT] = ActionEntry(REDUCE, 358);
   _actionMap[661][NEGATION] = ActionEntry(REDUCE, 358);
   _actionMap[661][EQU] = ActionEntry(REDUCE, 358);
   _actionMap[661][BETWEEN] = ActionEntry(REDUCE, 358);
   _actionMap[661][IS] = ActionEntry(REDUCE, 358);
   _actionMap[661][LIKE] = ActionEntry(REDUCE, 358);
   _actionMap[661][NCLIKE] = ActionEntry(REDUCE, 358);
   _actionMap[661][RB] = ActionEntry(REDUCE, 358);
   _actionMap[661][ENDTOKEN] = ActionEntry(REDUCE, 358);
   _actionMap[661][UNION] = ActionEntry(REDUCE, 358);
   _actionMap[661][ROWLIMIT] = ActionEntry(REDUCE, 358);
   _actionMap[661][KSEP] = ActionEntry(REDUCE, 358);
   _actionMap[661][ASC] = ActionEntry(REDUCE, 358);
   _actionMap[661][DESC] = ActionEntry(REDUCE, 358);
   _actionMap[661][PLUS] = ActionEntry(REDUCE, 358);
   _actionMap[661][MINUS] = ActionEntry(REDUCE, 358);
   _actionMap[661][DIVISION] = ActionEntry(REDUCE, 358);
   _actionMap[661][STAR] = ActionEntry(REDUCE, 358);
   _actionMap[661][CONCAT] = ActionEntry(REDUCE, 358);
   _actionMap[661][SEMICOLON] = ActionEntry(REDUCE, 358);
   _actionMap[662][WHEN] = ActionEntry(REDUCE, 359);
   _actionMap[662][ELSE] = ActionEntry(REDUCE, 359);
   _actionMap[662][FROM] = ActionEntry(REDUCE, 359);
   _actionMap[662][AS] = ActionEntry(REDUCE, 359);
   _actionMap[662][END_TOKEN] = ActionEntry(REDUCE, 359);
   _actionMap[662][BEGIN] = ActionEntry(REDUCE, 359);
   _actionMap[662][THEN] = ActionEntry(REDUCE, 359);
   _actionMap[662][LEFT] = ActionEntry(REDUCE, 359);
   _actionMap[662][RIGHT] = ActionEntry(REDUCE, 359);
   _actionMap[662][INNER] = ActionEntry(REDUCE, 359);
   _actionMap[662][JOIN] = ActionEntry(REDUCE, 359);
   _actionMap[662][ORDER] = ActionEntry(REDUCE, 359);
   _actionMap[662][GROUP] = ActionEntry(REDUCE, 359);
   _actionMap[662][RETURNTOKEN] = ActionEntry(REDUCE, 359);
   _actionMap[662][WHERE] = ActionEntry(REDUCE, 359);
   _actionMap[662][AND] = ActionEntry(REDUCE, 359);
   _actionMap[662][OR] = ActionEntry(REDUCE, 359);
   _actionMap[662][INTOK] = ActionEntry(REDUCE, 359);
}
void Cego::loadParser106()
{
   _actionMap[662][NOT] = ActionEntry(REDUCE, 359);
   _actionMap[662][MT] = ActionEntry(REDUCE, 359);
   _actionMap[662][LT] = ActionEntry(REDUCE, 359);
   _actionMap[662][NEGATION] = ActionEntry(REDUCE, 359);
   _actionMap[662][EQU] = ActionEntry(REDUCE, 359);
   _actionMap[662][BETWEEN] = ActionEntry(REDUCE, 359);
   _actionMap[662][IS] = ActionEntry(REDUCE, 359);
   _actionMap[662][LIKE] = ActionEntry(REDUCE, 359);
   _actionMap[662][NCLIKE] = ActionEntry(REDUCE, 359);
   _actionMap[662][RB] = ActionEntry(REDUCE, 359);
   _actionMap[662][ENDTOKEN] = ActionEntry(REDUCE, 359);
   _actionMap[662][UNION] = ActionEntry(REDUCE, 359);
   _actionMap[662][ROWLIMIT] = ActionEntry(REDUCE, 359);
   _actionMap[662][KSEP] = ActionEntry(REDUCE, 359);
   _actionMap[662][ASC] = ActionEntry(REDUCE, 359);
   _actionMap[662][DESC] = ActionEntry(REDUCE, 359);
   _actionMap[662][PLUS] = ActionEntry(REDUCE, 359);
   _actionMap[662][MINUS] = ActionEntry(REDUCE, 359);
   _actionMap[662][DIVISION] = ActionEntry(REDUCE, 359);
   _actionMap[662][STAR] = ActionEntry(REDUCE, 359);
   _actionMap[662][CONCAT] = ActionEntry(REDUCE, 359);
   _actionMap[662][SEMICOLON] = ActionEntry(REDUCE, 359);
   _actionMap[663][WHEN] = ActionEntry(REDUCE, 373);
   _actionMap[663][ELSE] = ActionEntry(REDUCE, 373);
   _actionMap[663][FROM] = ActionEntry(REDUCE, 373);
   _actionMap[663][AS] = ActionEntry(REDUCE, 373);
   _actionMap[663][END_TOKEN] = ActionEntry(REDUCE, 373);
   _actionMap[663][BEGIN] = ActionEntry(REDUCE, 373);
   _actionMap[663][THEN] = ActionEntry(REDUCE, 373);
   _actionMap[663][LEFT] = ActionEntry(REDUCE, 373);
   _actionMap[663][RIGHT] = ActionEntry(REDUCE, 373);
   _actionMap[663][INNER] = ActionEntry(REDUCE, 373);
   _actionMap[663][JOIN] = ActionEntry(REDUCE, 373);
   _actionMap[663][ORDER] = ActionEntry(REDUCE, 373);
   _actionMap[663][GROUP] = ActionEntry(REDUCE, 373);
   _actionMap[663][RETURNTOKEN] = ActionEntry(REDUCE, 373);
   _actionMap[663][WHERE] = ActionEntry(REDUCE, 373);
   _actionMap[663][AND] = ActionEntry(REDUCE, 373);
   _actionMap[663][OR] = ActionEntry(REDUCE, 373);
   _actionMap[663][INTOK] = ActionEntry(REDUCE, 373);
   _actionMap[663][NOT] = ActionEntry(REDUCE, 373);
   _actionMap[663][MT] = ActionEntry(REDUCE, 373);
   _actionMap[663][LT] = ActionEntry(REDUCE, 373);
   _actionMap[663][NEGATION] = ActionEntry(REDUCE, 373);
   _actionMap[663][EQU] = ActionEntry(REDUCE, 373);
   _actionMap[663][BETWEEN] = ActionEntry(REDUCE, 373);
   _actionMap[663][IS] = ActionEntry(REDUCE, 373);
   _actionMap[663][LIKE] = ActionEntry(REDUCE, 373);
   _actionMap[663][NCLIKE] = ActionEntry(REDUCE, 373);
   _actionMap[663][RB] = ActionEntry(REDUCE, 373);
}
void Cego::loadParser107()
{
   _actionMap[663][ENDTOKEN] = ActionEntry(REDUCE, 373);
   _actionMap[663][UNION] = ActionEntry(REDUCE, 373);
   _actionMap[663][ROWLIMIT] = ActionEntry(REDUCE, 373);
   _actionMap[663][KSEP] = ActionEntry(REDUCE, 373);
   _actionMap[663][ASC] = ActionEntry(REDUCE, 373);
   _actionMap[663][DESC] = ActionEntry(REDUCE, 373);
   _actionMap[663][PLUS] = ActionEntry(REDUCE, 373);
   _actionMap[663][MINUS] = ActionEntry(REDUCE, 373);
   _actionMap[663][DIVISION] = ActionEntry(REDUCE, 373);
   _actionMap[663][STAR] = ActionEntry(REDUCE, 373);
   _actionMap[663][CONCAT] = ActionEntry(REDUCE, 373);
   _actionMap[663][SEMICOLON] = ActionEntry(REDUCE, 373);
   _actionMap[664][WHEN] = ActionEntry(REDUCE, 353);
   _actionMap[664][ELSE] = ActionEntry(REDUCE, 353);
   _actionMap[664][FROM] = ActionEntry(REDUCE, 353);
   _actionMap[664][AS] = ActionEntry(REDUCE, 353);
   _actionMap[664][END_TOKEN] = ActionEntry(REDUCE, 353);
   _actionMap[664][BEGIN] = ActionEntry(REDUCE, 353);
   _actionMap[664][THEN] = ActionEntry(REDUCE, 353);
   _actionMap[664][LEFT] = ActionEntry(REDUCE, 353);
   _actionMap[664][RIGHT] = ActionEntry(REDUCE, 353);
   _actionMap[664][INNER] = ActionEntry(REDUCE, 353);
   _actionMap[664][JOIN] = ActionEntry(REDUCE, 353);
   _actionMap[664][ORDER] = ActionEntry(REDUCE, 353);
   _actionMap[664][GROUP] = ActionEntry(REDUCE, 353);
   _actionMap[664][RETURNTOKEN] = ActionEntry(REDUCE, 353);
   _actionMap[664][WHERE] = ActionEntry(REDUCE, 353);
   _actionMap[664][AND] = ActionEntry(REDUCE, 353);
   _actionMap[664][OR] = ActionEntry(REDUCE, 353);
   _actionMap[664][INTOK] = ActionEntry(REDUCE, 353);
   _actionMap[664][NOT] = ActionEntry(REDUCE, 353);
   _actionMap[664][MT] = ActionEntry(REDUCE, 353);
   _actionMap[664][LT] = ActionEntry(REDUCE, 353);
   _actionMap[664][NEGATION] = ActionEntry(REDUCE, 353);
   _actionMap[664][EQU] = ActionEntry(REDUCE, 353);
   _actionMap[664][BETWEEN] = ActionEntry(REDUCE, 353);
   _actionMap[664][IS] = ActionEntry(REDUCE, 353);
   _actionMap[664][LIKE] = ActionEntry(REDUCE, 353);
   _actionMap[664][NCLIKE] = ActionEntry(REDUCE, 353);
   _actionMap[664][RB] = ActionEntry(REDUCE, 353);
   _actionMap[664][ENDTOKEN] = ActionEntry(REDUCE, 353);
   _actionMap[664][UNION] = ActionEntry(REDUCE, 353);
   _actionMap[664][ROWLIMIT] = ActionEntry(REDUCE, 353);
   _actionMap[664][KSEP] = ActionEntry(REDUCE, 353);
   _actionMap[664][ASC] = ActionEntry(REDUCE, 353);
   _actionMap[664][DESC] = ActionEntry(REDUCE, 353);
   _actionMap[664][PLUS] = ActionEntry(REDUCE, 353);
   _actionMap[664][MINUS] = ActionEntry(REDUCE, 353);
   _actionMap[664][DIVISION] = ActionEntry(REDUCE, 353);
   _actionMap[664][STAR] = ActionEntry(REDUCE, 353);
}
void Cego::loadParser108()
{
   _actionMap[664][CONCAT] = ActionEntry(REDUCE, 353);
   _actionMap[664][SEMICOLON] = ActionEntry(REDUCE, 353);
   _actionMap[665][WHEN] = ActionEntry(REDUCE, 350);
   _actionMap[665][ELSE] = ActionEntry(REDUCE, 350);
   _actionMap[665][FROM] = ActionEntry(REDUCE, 350);
   _actionMap[665][AS] = ActionEntry(REDUCE, 350);
   _actionMap[665][END_TOKEN] = ActionEntry(REDUCE, 350);
   _actionMap[665][BEGIN] = ActionEntry(REDUCE, 350);
   _actionMap[665][THEN] = ActionEntry(REDUCE, 350);
   _actionMap[665][LEFT] = ActionEntry(REDUCE, 350);
   _actionMap[665][RIGHT] = ActionEntry(REDUCE, 350);
   _actionMap[665][INNER] = ActionEntry(REDUCE, 350);
   _actionMap[665][JOIN] = ActionEntry(REDUCE, 350);
   _actionMap[665][ORDER] = ActionEntry(REDUCE, 350);
   _actionMap[665][GROUP] = ActionEntry(REDUCE, 350);
   _actionMap[665][RETURNTOKEN] = ActionEntry(REDUCE, 350);
   _actionMap[665][WHERE] = ActionEntry(REDUCE, 350);
   _actionMap[665][AND] = ActionEntry(REDUCE, 350);
   _actionMap[665][OR] = ActionEntry(REDUCE, 350);
   _actionMap[665][INTOK] = ActionEntry(REDUCE, 350);
   _actionMap[665][NOT] = ActionEntry(REDUCE, 350);
   _actionMap[665][MT] = ActionEntry(REDUCE, 350);
   _actionMap[665][LT] = ActionEntry(REDUCE, 350);
   _actionMap[665][NEGATION] = ActionEntry(REDUCE, 350);
   _actionMap[665][EQU] = ActionEntry(REDUCE, 350);
   _actionMap[665][BETWEEN] = ActionEntry(REDUCE, 350);
   _actionMap[665][IS] = ActionEntry(REDUCE, 350);
   _actionMap[665][LIKE] = ActionEntry(REDUCE, 350);
   _actionMap[665][NCLIKE] = ActionEntry(REDUCE, 350);
   _actionMap[665][RB] = ActionEntry(REDUCE, 350);
   _actionMap[665][ENDTOKEN] = ActionEntry(REDUCE, 350);
   _actionMap[665][UNION] = ActionEntry(REDUCE, 350);
   _actionMap[665][ROWLIMIT] = ActionEntry(REDUCE, 350);
   _actionMap[665][KSEP] = ActionEntry(REDUCE, 350);
   _actionMap[665][ASC] = ActionEntry(REDUCE, 350);
   _actionMap[665][DESC] = ActionEntry(REDUCE, 350);
   _actionMap[665][PLUS] = ActionEntry(REDUCE, 350);
   _actionMap[665][MINUS] = ActionEntry(REDUCE, 350);
   _actionMap[665][DIVISION] = ActionEntry(REDUCE, 350);
   _actionMap[665][STAR] = ActionEntry(REDUCE, 350);
   _actionMap[665][CONCAT] = ActionEntry(REDUCE, 350);
   _actionMap[665][SEMICOLON] = ActionEntry(REDUCE, 350);
   _actionMap[666][WHEN] = ActionEntry(REDUCE, 341);
   _actionMap[666][ELSE] = ActionEntry(REDUCE, 341);
   _actionMap[666][FROM] = ActionEntry(REDUCE, 341);
   _actionMap[666][AS] = ActionEntry(REDUCE, 341);
   _actionMap[666][END_TOKEN] = ActionEntry(REDUCE, 341);
   _actionMap[666][BEGIN] = ActionEntry(REDUCE, 341);
   _actionMap[666][THEN] = ActionEntry(REDUCE, 341);
   _actionMap[666][LEFT] = ActionEntry(REDUCE, 341);
}
void Cego::loadParser109()
{
   _actionMap[666][RIGHT] = ActionEntry(REDUCE, 341);
   _actionMap[666][INNER] = ActionEntry(REDUCE, 341);
   _actionMap[666][JOIN] = ActionEntry(REDUCE, 341);
   _actionMap[666][ORDER] = ActionEntry(REDUCE, 341);
   _actionMap[666][GROUP] = ActionEntry(REDUCE, 341);
   _actionMap[666][RETURNTOKEN] = ActionEntry(REDUCE, 341);
   _actionMap[666][WHERE] = ActionEntry(REDUCE, 341);
   _actionMap[666][AND] = ActionEntry(REDUCE, 341);
   _actionMap[666][OR] = ActionEntry(REDUCE, 341);
   _actionMap[666][INTOK] = ActionEntry(REDUCE, 341);
   _actionMap[666][NOT] = ActionEntry(REDUCE, 341);
   _actionMap[666][MT] = ActionEntry(REDUCE, 341);
   _actionMap[666][LT] = ActionEntry(REDUCE, 341);
   _actionMap[666][NEGATION] = ActionEntry(REDUCE, 341);
   _actionMap[666][EQU] = ActionEntry(REDUCE, 341);
   _actionMap[666][BETWEEN] = ActionEntry(REDUCE, 341);
   _actionMap[666][IS] = ActionEntry(REDUCE, 341);
   _actionMap[666][LIKE] = ActionEntry(REDUCE, 341);
   _actionMap[666][NCLIKE] = ActionEntry(REDUCE, 341);
   _actionMap[666][RB] = ActionEntry(REDUCE, 341);
   _actionMap[666][ENDTOKEN] = ActionEntry(REDUCE, 341);
   _actionMap[666][UNION] = ActionEntry(REDUCE, 341);
   _actionMap[666][ROWLIMIT] = ActionEntry(REDUCE, 341);
   _actionMap[666][KSEP] = ActionEntry(REDUCE, 341);
   _actionMap[666][ASC] = ActionEntry(REDUCE, 341);
   _actionMap[666][DESC] = ActionEntry(REDUCE, 341);
   _actionMap[666][PLUS] = ActionEntry(REDUCE, 341);
   _actionMap[666][MINUS] = ActionEntry(REDUCE, 341);
   _actionMap[666][DIVISION] = ActionEntry(REDUCE, 341);
   _actionMap[666][STAR] = ActionEntry(REDUCE, 341);
   _actionMap[666][CONCAT] = ActionEntry(REDUCE, 341);
   _actionMap[666][SEMICOLON] = ActionEntry(REDUCE, 341);
   _actionMap[667][WHEN] = ActionEntry(REDUCE, 339);
   _actionMap[667][ELSE] = ActionEntry(REDUCE, 339);
   _actionMap[667][FROM] = ActionEntry(REDUCE, 339);
   _actionMap[667][AS] = ActionEntry(REDUCE, 339);
   _actionMap[667][END_TOKEN] = ActionEntry(REDUCE, 339);
   _actionMap[667][BEGIN] = ActionEntry(REDUCE, 339);
   _actionMap[667][THEN] = ActionEntry(REDUCE, 339);
   _actionMap[667][LEFT] = ActionEntry(REDUCE, 339);
   _actionMap[667][RIGHT] = ActionEntry(REDUCE, 339);
   _actionMap[667][INNER] = ActionEntry(REDUCE, 339);
   _actionMap[667][JOIN] = ActionEntry(REDUCE, 339);
   _actionMap[667][ORDER] = ActionEntry(REDUCE, 339);
   _actionMap[667][GROUP] = ActionEntry(REDUCE, 339);
   _actionMap[667][RETURNTOKEN] = ActionEntry(REDUCE, 339);
   _actionMap[667][WHERE] = ActionEntry(REDUCE, 339);
   _actionMap[667][AND] = ActionEntry(REDUCE, 339);
   _actionMap[667][OR] = ActionEntry(REDUCE, 339);
   _actionMap[667][INTOK] = ActionEntry(REDUCE, 339);
}
void Cego::loadParser110()
{
   _actionMap[667][NOT] = ActionEntry(REDUCE, 339);
   _actionMap[667][MT] = ActionEntry(REDUCE, 339);
   _actionMap[667][LT] = ActionEntry(REDUCE, 339);
   _actionMap[667][NEGATION] = ActionEntry(REDUCE, 339);
   _actionMap[667][EQU] = ActionEntry(REDUCE, 339);
   _actionMap[667][BETWEEN] = ActionEntry(REDUCE, 339);
   _actionMap[667][IS] = ActionEntry(REDUCE, 339);
   _actionMap[667][LIKE] = ActionEntry(REDUCE, 339);
   _actionMap[667][NCLIKE] = ActionEntry(REDUCE, 339);
   _actionMap[667][RB] = ActionEntry(REDUCE, 339);
   _actionMap[667][ENDTOKEN] = ActionEntry(REDUCE, 339);
   _actionMap[667][UNION] = ActionEntry(REDUCE, 339);
   _actionMap[667][ROWLIMIT] = ActionEntry(REDUCE, 339);
   _actionMap[667][KSEP] = ActionEntry(REDUCE, 339);
   _actionMap[667][ASC] = ActionEntry(REDUCE, 339);
   _actionMap[667][DESC] = ActionEntry(REDUCE, 339);
   _actionMap[667][PLUS] = ActionEntry(REDUCE, 339);
   _actionMap[667][MINUS] = ActionEntry(REDUCE, 339);
   _actionMap[667][DIVISION] = ActionEntry(REDUCE, 339);
   _actionMap[667][STAR] = ActionEntry(REDUCE, 339);
   _actionMap[667][CONCAT] = ActionEntry(REDUCE, 339);
   _actionMap[667][SEMICOLON] = ActionEntry(REDUCE, 339);
   _actionMap[668][WHEN] = ActionEntry(REDUCE, 342);
   _actionMap[668][ELSE] = ActionEntry(REDUCE, 342);
   _actionMap[668][FROM] = ActionEntry(REDUCE, 342);
   _actionMap[668][AS] = ActionEntry(REDUCE, 342);
   _actionMap[668][END_TOKEN] = ActionEntry(REDUCE, 342);
   _actionMap[668][BEGIN] = ActionEntry(REDUCE, 342);
   _actionMap[668][THEN] = ActionEntry(REDUCE, 342);
   _actionMap[668][LEFT] = ActionEntry(REDUCE, 342);
   _actionMap[668][RIGHT] = ActionEntry(REDUCE, 342);
   _actionMap[668][INNER] = ActionEntry(REDUCE, 342);
   _actionMap[668][JOIN] = ActionEntry(REDUCE, 342);
   _actionMap[668][ORDER] = ActionEntry(REDUCE, 342);
   _actionMap[668][GROUP] = ActionEntry(REDUCE, 342);
   _actionMap[668][RETURNTOKEN] = ActionEntry(REDUCE, 342);
   _actionMap[668][WHERE] = ActionEntry(REDUCE, 342);
   _actionMap[668][AND] = ActionEntry(REDUCE, 342);
   _actionMap[668][OR] = ActionEntry(REDUCE, 342);
   _actionMap[668][INTOK] = ActionEntry(REDUCE, 342);
   _actionMap[668][NOT] = ActionEntry(REDUCE, 342);
   _actionMap[668][MT] = ActionEntry(REDUCE, 342);
   _actionMap[668][LT] = ActionEntry(REDUCE, 342);
   _actionMap[668][NEGATION] = ActionEntry(REDUCE, 342);
   _actionMap[668][EQU] = ActionEntry(REDUCE, 342);
   _actionMap[668][BETWEEN] = ActionEntry(REDUCE, 342);
   _actionMap[668][IS] = ActionEntry(REDUCE, 342);
   _actionMap[668][LIKE] = ActionEntry(REDUCE, 342);
   _actionMap[668][NCLIKE] = ActionEntry(REDUCE, 342);
   _actionMap[668][RB] = ActionEntry(REDUCE, 342);
}
void Cego::loadParser111()
{
   _actionMap[668][ENDTOKEN] = ActionEntry(REDUCE, 342);
   _actionMap[668][UNION] = ActionEntry(REDUCE, 342);
   _actionMap[668][ROWLIMIT] = ActionEntry(REDUCE, 342);
   _actionMap[668][KSEP] = ActionEntry(REDUCE, 342);
   _actionMap[668][ASC] = ActionEntry(REDUCE, 342);
   _actionMap[668][DESC] = ActionEntry(REDUCE, 342);
   _actionMap[668][PLUS] = ActionEntry(REDUCE, 342);
   _actionMap[668][MINUS] = ActionEntry(REDUCE, 342);
   _actionMap[668][DIVISION] = ActionEntry(REDUCE, 342);
   _actionMap[668][STAR] = ActionEntry(REDUCE, 342);
   _actionMap[668][CONCAT] = ActionEntry(REDUCE, 342);
   _actionMap[668][SEMICOLON] = ActionEntry(REDUCE, 342);
   _actionMap[669][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[669][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[669][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[669][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[669][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[669][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[669][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[669][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[669][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[669][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[669][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[669][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[669][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[669][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[669][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[669][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[669][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[669][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[669][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[669][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[669][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[669][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[669][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[669][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[669][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[669][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[669][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[669][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[669][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[669][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[669][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[669][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[669][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[669][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[669][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[669][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[669][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[669][CLOBSIZE] = ActionEntry(SHIFT, 134);
}
void Cego::loadParser112()
{
   _actionMap[669][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[669][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[669][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[669][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[669][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[669][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[669][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[669][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[669][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[669][LB] = ActionEntry(SHIFT, 178);
   _actionMap[669][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[669][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[669][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[669][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[669][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[669][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[669][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[669][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[669][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[669][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[669][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[669][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[669][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[669][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[669][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[669][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[669][ObjSpec] = 122;
   _jumpMap[669][Constant] = 121;
   _jumpMap[669][SignedFloat] = 120;
   _jumpMap[669][SignedInt] = 119;
   _jumpMap[669][Attribute] = 118;
   _jumpMap[669][Function] = 117;
   _jumpMap[669][Factor] = 116;
   _jumpMap[669][Term] = 115;
   _jumpMap[669][Expr] = 783;
   _jumpMap[669][CasePrepare] = 113;
   _jumpMap[669][CaseClause] = 112;
   _actionMap[670][WHEN] = ActionEntry(REDUCE, 352);
   _actionMap[670][ELSE] = ActionEntry(REDUCE, 352);
   _actionMap[670][FROM] = ActionEntry(REDUCE, 352);
   _actionMap[670][AS] = ActionEntry(REDUCE, 352);
   _actionMap[670][END_TOKEN] = ActionEntry(REDUCE, 352);
   _actionMap[670][BEGIN] = ActionEntry(REDUCE, 352);
   _actionMap[670][THEN] = ActionEntry(REDUCE, 352);
   _actionMap[670][LEFT] = ActionEntry(REDUCE, 352);
   _actionMap[670][RIGHT] = ActionEntry(REDUCE, 352);
   _actionMap[670][INNER] = ActionEntry(REDUCE, 352);
   _actionMap[670][JOIN] = ActionEntry(REDUCE, 352);
   _actionMap[670][ORDER] = ActionEntry(REDUCE, 352);
   _actionMap[670][GROUP] = ActionEntry(REDUCE, 352);
}
void Cego::loadParser113()
{
   _actionMap[670][RETURNTOKEN] = ActionEntry(REDUCE, 352);
   _actionMap[670][WHERE] = ActionEntry(REDUCE, 352);
   _actionMap[670][AND] = ActionEntry(REDUCE, 352);
   _actionMap[670][OR] = ActionEntry(REDUCE, 352);
   _actionMap[670][INTOK] = ActionEntry(REDUCE, 352);
   _actionMap[670][NOT] = ActionEntry(REDUCE, 352);
   _actionMap[670][MT] = ActionEntry(REDUCE, 352);
   _actionMap[670][LT] = ActionEntry(REDUCE, 352);
   _actionMap[670][NEGATION] = ActionEntry(REDUCE, 352);
   _actionMap[670][EQU] = ActionEntry(REDUCE, 352);
   _actionMap[670][BETWEEN] = ActionEntry(REDUCE, 352);
   _actionMap[670][IS] = ActionEntry(REDUCE, 352);
   _actionMap[670][LIKE] = ActionEntry(REDUCE, 352);
   _actionMap[670][NCLIKE] = ActionEntry(REDUCE, 352);
   _actionMap[670][RB] = ActionEntry(REDUCE, 352);
   _actionMap[670][ENDTOKEN] = ActionEntry(REDUCE, 352);
   _actionMap[670][UNION] = ActionEntry(REDUCE, 352);
   _actionMap[670][ROWLIMIT] = ActionEntry(REDUCE, 352);
   _actionMap[670][KSEP] = ActionEntry(REDUCE, 352);
   _actionMap[670][ASC] = ActionEntry(REDUCE, 352);
   _actionMap[670][DESC] = ActionEntry(REDUCE, 352);
   _actionMap[670][PLUS] = ActionEntry(REDUCE, 352);
   _actionMap[670][MINUS] = ActionEntry(REDUCE, 352);
   _actionMap[670][DIVISION] = ActionEntry(REDUCE, 352);
   _actionMap[670][STAR] = ActionEntry(REDUCE, 352);
   _actionMap[670][CONCAT] = ActionEntry(REDUCE, 352);
   _actionMap[670][SEMICOLON] = ActionEntry(REDUCE, 352);
   _actionMap[671][WHEN] = ActionEntry(REDUCE, 331);
   _actionMap[671][ELSE] = ActionEntry(REDUCE, 331);
   _actionMap[671][AS] = ActionEntry(REDUCE, 331);
   _actionMap[671][FROM] = ActionEntry(REDUCE, 331);
   _actionMap[671][END_TOKEN] = ActionEntry(REDUCE, 331);
   _actionMap[671][BEGIN] = ActionEntry(REDUCE, 331);
   _actionMap[671][THEN] = ActionEntry(REDUCE, 331);
   _actionMap[671][LEFT] = ActionEntry(REDUCE, 331);
   _actionMap[671][RIGHT] = ActionEntry(REDUCE, 331);
   _actionMap[671][INNER] = ActionEntry(REDUCE, 331);
   _actionMap[671][JOIN] = ActionEntry(REDUCE, 331);
   _actionMap[671][ORDER] = ActionEntry(REDUCE, 331);
   _actionMap[671][GROUP] = ActionEntry(REDUCE, 331);
   _actionMap[671][RETURNTOKEN] = ActionEntry(REDUCE, 331);
   _actionMap[671][WHERE] = ActionEntry(REDUCE, 331);
   _actionMap[671][OR] = ActionEntry(REDUCE, 331);
   _actionMap[671][AND] = ActionEntry(REDUCE, 331);
   _actionMap[671][NCLIKE] = ActionEntry(REDUCE, 331);
   _actionMap[671][LIKE] = ActionEntry(REDUCE, 331);
   _actionMap[671][IS] = ActionEntry(REDUCE, 331);
   _actionMap[671][BETWEEN] = ActionEntry(REDUCE, 331);
   _actionMap[671][EQU] = ActionEntry(REDUCE, 331);
   _actionMap[671][NEGATION] = ActionEntry(REDUCE, 331);
}
void Cego::loadParser114()
{
   _actionMap[671][LT] = ActionEntry(REDUCE, 331);
   _actionMap[671][MT] = ActionEntry(REDUCE, 331);
   _actionMap[671][NOT] = ActionEntry(REDUCE, 331);
   _actionMap[671][INTOK] = ActionEntry(REDUCE, 331);
   _actionMap[671][DESC] = ActionEntry(REDUCE, 331);
   _actionMap[671][ASC] = ActionEntry(REDUCE, 331);
   _actionMap[671][KSEP] = ActionEntry(REDUCE, 331);
   _actionMap[671][ROWLIMIT] = ActionEntry(REDUCE, 331);
   _actionMap[671][UNION] = ActionEntry(REDUCE, 331);
   _actionMap[671][ENDTOKEN] = ActionEntry(REDUCE, 331);
   _actionMap[671][RB] = ActionEntry(REDUCE, 331);
   _actionMap[671][CONCAT] = ActionEntry(REDUCE, 331);
   _actionMap[671][STAR] = ActionEntry(REDUCE, 331);
   _actionMap[671][DIVISION] = ActionEntry(REDUCE, 331);
   _actionMap[671][MINUS] = ActionEntry(REDUCE, 331);
   _actionMap[671][PLUS] = ActionEntry(REDUCE, 331);
   _actionMap[671][SEMICOLON] = ActionEntry(REDUCE, 331);
   _actionMap[672][WHEN] = ActionEntry(REDUCE, 356);
   _actionMap[672][ELSE] = ActionEntry(REDUCE, 356);
   _actionMap[672][FROM] = ActionEntry(REDUCE, 356);
   _actionMap[672][AS] = ActionEntry(REDUCE, 356);
   _actionMap[672][END_TOKEN] = ActionEntry(REDUCE, 356);
   _actionMap[672][BEGIN] = ActionEntry(REDUCE, 356);
   _actionMap[672][THEN] = ActionEntry(REDUCE, 356);
   _actionMap[672][LEFT] = ActionEntry(REDUCE, 356);
   _actionMap[672][RIGHT] = ActionEntry(REDUCE, 356);
   _actionMap[672][INNER] = ActionEntry(REDUCE, 356);
   _actionMap[672][JOIN] = ActionEntry(REDUCE, 356);
   _actionMap[672][ORDER] = ActionEntry(REDUCE, 356);
   _actionMap[672][GROUP] = ActionEntry(REDUCE, 356);
   _actionMap[672][RETURNTOKEN] = ActionEntry(REDUCE, 356);
   _actionMap[672][WHERE] = ActionEntry(REDUCE, 356);
   _actionMap[672][AND] = ActionEntry(REDUCE, 356);
   _actionMap[672][OR] = ActionEntry(REDUCE, 356);
   _actionMap[672][INTOK] = ActionEntry(REDUCE, 356);
   _actionMap[672][NOT] = ActionEntry(REDUCE, 356);
   _actionMap[672][MT] = ActionEntry(REDUCE, 356);
   _actionMap[672][LT] = ActionEntry(REDUCE, 356);
   _actionMap[672][NEGATION] = ActionEntry(REDUCE, 356);
   _actionMap[672][EQU] = ActionEntry(REDUCE, 356);
   _actionMap[672][BETWEEN] = ActionEntry(REDUCE, 356);
   _actionMap[672][IS] = ActionEntry(REDUCE, 356);
   _actionMap[672][LIKE] = ActionEntry(REDUCE, 356);
   _actionMap[672][NCLIKE] = ActionEntry(REDUCE, 356);
   _actionMap[672][RB] = ActionEntry(REDUCE, 356);
   _actionMap[672][ENDTOKEN] = ActionEntry(REDUCE, 356);
   _actionMap[672][UNION] = ActionEntry(REDUCE, 356);
   _actionMap[672][ROWLIMIT] = ActionEntry(REDUCE, 356);
   _actionMap[672][KSEP] = ActionEntry(REDUCE, 356);
   _actionMap[672][ASC] = ActionEntry(REDUCE, 356);
}
void Cego::loadParser115()
{
   _actionMap[672][DESC] = ActionEntry(REDUCE, 356);
   _actionMap[672][PLUS] = ActionEntry(REDUCE, 356);
   _actionMap[672][MINUS] = ActionEntry(REDUCE, 356);
   _actionMap[672][DIVISION] = ActionEntry(REDUCE, 356);
   _actionMap[672][STAR] = ActionEntry(REDUCE, 356);
   _actionMap[672][CONCAT] = ActionEntry(REDUCE, 356);
   _actionMap[672][SEMICOLON] = ActionEntry(REDUCE, 356);
   _actionMap[673][WHEN] = ActionEntry(REDUCE, 357);
   _actionMap[673][ELSE] = ActionEntry(REDUCE, 357);
   _actionMap[673][FROM] = ActionEntry(REDUCE, 357);
   _actionMap[673][AS] = ActionEntry(REDUCE, 357);
   _actionMap[673][END_TOKEN] = ActionEntry(REDUCE, 357);
   _actionMap[673][BEGIN] = ActionEntry(REDUCE, 357);
   _actionMap[673][THEN] = ActionEntry(REDUCE, 357);
   _actionMap[673][LEFT] = ActionEntry(REDUCE, 357);
   _actionMap[673][RIGHT] = ActionEntry(REDUCE, 357);
   _actionMap[673][INNER] = ActionEntry(REDUCE, 357);
   _actionMap[673][JOIN] = ActionEntry(REDUCE, 357);
   _actionMap[673][ORDER] = ActionEntry(REDUCE, 357);
   _actionMap[673][GROUP] = ActionEntry(REDUCE, 357);
   _actionMap[673][RETURNTOKEN] = ActionEntry(REDUCE, 357);
   _actionMap[673][WHERE] = ActionEntry(REDUCE, 357);
   _actionMap[673][AND] = ActionEntry(REDUCE, 357);
   _actionMap[673][OR] = ActionEntry(REDUCE, 357);
   _actionMap[673][INTOK] = ActionEntry(REDUCE, 357);
   _actionMap[673][NOT] = ActionEntry(REDUCE, 357);
   _actionMap[673][MT] = ActionEntry(REDUCE, 357);
   _actionMap[673][LT] = ActionEntry(REDUCE, 357);
   _actionMap[673][NEGATION] = ActionEntry(REDUCE, 357);
   _actionMap[673][EQU] = ActionEntry(REDUCE, 357);
   _actionMap[673][BETWEEN] = ActionEntry(REDUCE, 357);
   _actionMap[673][IS] = ActionEntry(REDUCE, 357);
   _actionMap[673][LIKE] = ActionEntry(REDUCE, 357);
   _actionMap[673][NCLIKE] = ActionEntry(REDUCE, 357);
   _actionMap[673][RB] = ActionEntry(REDUCE, 357);
   _actionMap[673][ENDTOKEN] = ActionEntry(REDUCE, 357);
   _actionMap[673][UNION] = ActionEntry(REDUCE, 357);
   _actionMap[673][ROWLIMIT] = ActionEntry(REDUCE, 357);
   _actionMap[673][KSEP] = ActionEntry(REDUCE, 357);
   _actionMap[673][ASC] = ActionEntry(REDUCE, 357);
   _actionMap[673][DESC] = ActionEntry(REDUCE, 357);
   _actionMap[673][PLUS] = ActionEntry(REDUCE, 357);
   _actionMap[673][MINUS] = ActionEntry(REDUCE, 357);
   _actionMap[673][DIVISION] = ActionEntry(REDUCE, 357);
   _actionMap[673][STAR] = ActionEntry(REDUCE, 357);
   _actionMap[673][CONCAT] = ActionEntry(REDUCE, 357);
   _actionMap[673][SEMICOLON] = ActionEntry(REDUCE, 357);
   _actionMap[674][WHEN] = ActionEntry(REDUCE, 338);
   _actionMap[674][ELSE] = ActionEntry(REDUCE, 338);
   _actionMap[674][FROM] = ActionEntry(REDUCE, 338);
}
void Cego::loadParser116()
{
   _actionMap[674][AS] = ActionEntry(REDUCE, 338);
   _actionMap[674][END_TOKEN] = ActionEntry(REDUCE, 338);
   _actionMap[674][BEGIN] = ActionEntry(REDUCE, 338);
   _actionMap[674][THEN] = ActionEntry(REDUCE, 338);
   _actionMap[674][LEFT] = ActionEntry(REDUCE, 338);
   _actionMap[674][RIGHT] = ActionEntry(REDUCE, 338);
   _actionMap[674][INNER] = ActionEntry(REDUCE, 338);
   _actionMap[674][JOIN] = ActionEntry(REDUCE, 338);
   _actionMap[674][ORDER] = ActionEntry(REDUCE, 338);
   _actionMap[674][GROUP] = ActionEntry(REDUCE, 338);
   _actionMap[674][RETURNTOKEN] = ActionEntry(REDUCE, 338);
   _actionMap[674][WHERE] = ActionEntry(REDUCE, 338);
   _actionMap[674][AND] = ActionEntry(REDUCE, 338);
   _actionMap[674][OR] = ActionEntry(REDUCE, 338);
   _actionMap[674][INTOK] = ActionEntry(REDUCE, 338);
   _actionMap[674][NOT] = ActionEntry(REDUCE, 338);
   _actionMap[674][MT] = ActionEntry(REDUCE, 338);
   _actionMap[674][LT] = ActionEntry(REDUCE, 338);
   _actionMap[674][NEGATION] = ActionEntry(REDUCE, 338);
   _actionMap[674][EQU] = ActionEntry(REDUCE, 338);
   _actionMap[674][BETWEEN] = ActionEntry(REDUCE, 338);
   _actionMap[674][IS] = ActionEntry(REDUCE, 338);
   _actionMap[674][LIKE] = ActionEntry(REDUCE, 338);
   _actionMap[674][NCLIKE] = ActionEntry(REDUCE, 338);
   _actionMap[674][RB] = ActionEntry(REDUCE, 338);
   _actionMap[674][ENDTOKEN] = ActionEntry(REDUCE, 338);
   _actionMap[674][UNION] = ActionEntry(REDUCE, 338);
   _actionMap[674][ROWLIMIT] = ActionEntry(REDUCE, 338);
   _actionMap[674][KSEP] = ActionEntry(REDUCE, 338);
   _actionMap[674][ASC] = ActionEntry(REDUCE, 338);
   _actionMap[674][DESC] = ActionEntry(REDUCE, 338);
   _actionMap[674][PLUS] = ActionEntry(REDUCE, 338);
   _actionMap[674][MINUS] = ActionEntry(REDUCE, 338);
   _actionMap[674][DIVISION] = ActionEntry(REDUCE, 338);
   _actionMap[674][STAR] = ActionEntry(REDUCE, 338);
   _actionMap[674][CONCAT] = ActionEntry(REDUCE, 338);
   _actionMap[674][SEMICOLON] = ActionEntry(REDUCE, 338);
   _actionMap[675][WHEN] = ActionEntry(REDUCE, 355);
   _actionMap[675][ELSE] = ActionEntry(REDUCE, 355);
   _actionMap[675][FROM] = ActionEntry(REDUCE, 355);
   _actionMap[675][AS] = ActionEntry(REDUCE, 355);
   _actionMap[675][END_TOKEN] = ActionEntry(REDUCE, 355);
   _actionMap[675][BEGIN] = ActionEntry(REDUCE, 355);
   _actionMap[675][THEN] = ActionEntry(REDUCE, 355);
   _actionMap[675][LEFT] = ActionEntry(REDUCE, 355);
   _actionMap[675][RIGHT] = ActionEntry(REDUCE, 355);
   _actionMap[675][INNER] = ActionEntry(REDUCE, 355);
   _actionMap[675][JOIN] = ActionEntry(REDUCE, 355);
   _actionMap[675][ORDER] = ActionEntry(REDUCE, 355);
   _actionMap[675][GROUP] = ActionEntry(REDUCE, 355);
}
void Cego::loadParser117()
{
   _actionMap[675][RETURNTOKEN] = ActionEntry(REDUCE, 355);
   _actionMap[675][WHERE] = ActionEntry(REDUCE, 355);
   _actionMap[675][AND] = ActionEntry(REDUCE, 355);
   _actionMap[675][OR] = ActionEntry(REDUCE, 355);
   _actionMap[675][INTOK] = ActionEntry(REDUCE, 355);
   _actionMap[675][NOT] = ActionEntry(REDUCE, 355);
   _actionMap[675][MT] = ActionEntry(REDUCE, 355);
   _actionMap[675][LT] = ActionEntry(REDUCE, 355);
   _actionMap[675][NEGATION] = ActionEntry(REDUCE, 355);
   _actionMap[675][EQU] = ActionEntry(REDUCE, 355);
   _actionMap[675][BETWEEN] = ActionEntry(REDUCE, 355);
   _actionMap[675][IS] = ActionEntry(REDUCE, 355);
   _actionMap[675][LIKE] = ActionEntry(REDUCE, 355);
   _actionMap[675][NCLIKE] = ActionEntry(REDUCE, 355);
   _actionMap[675][RB] = ActionEntry(REDUCE, 355);
   _actionMap[675][ENDTOKEN] = ActionEntry(REDUCE, 355);
   _actionMap[675][UNION] = ActionEntry(REDUCE, 355);
   _actionMap[675][ROWLIMIT] = ActionEntry(REDUCE, 355);
   _actionMap[675][KSEP] = ActionEntry(REDUCE, 355);
   _actionMap[675][ASC] = ActionEntry(REDUCE, 355);
   _actionMap[675][DESC] = ActionEntry(REDUCE, 355);
   _actionMap[675][PLUS] = ActionEntry(REDUCE, 355);
   _actionMap[675][MINUS] = ActionEntry(REDUCE, 355);
   _actionMap[675][DIVISION] = ActionEntry(REDUCE, 355);
   _actionMap[675][STAR] = ActionEntry(REDUCE, 355);
   _actionMap[675][CONCAT] = ActionEntry(REDUCE, 355);
   _actionMap[675][SEMICOLON] = ActionEntry(REDUCE, 355);
   _actionMap[676][WHEN] = ActionEntry(REDUCE, 348);
   _actionMap[676][ELSE] = ActionEntry(REDUCE, 348);
   _actionMap[676][FROM] = ActionEntry(REDUCE, 348);
   _actionMap[676][AS] = ActionEntry(REDUCE, 348);
   _actionMap[676][END_TOKEN] = ActionEntry(REDUCE, 348);
   _actionMap[676][BEGIN] = ActionEntry(REDUCE, 348);
   _actionMap[676][THEN] = ActionEntry(REDUCE, 348);
   _actionMap[676][LEFT] = ActionEntry(REDUCE, 348);
   _actionMap[676][RIGHT] = ActionEntry(REDUCE, 348);
   _actionMap[676][INNER] = ActionEntry(REDUCE, 348);
   _actionMap[676][JOIN] = ActionEntry(REDUCE, 348);
   _actionMap[676][ORDER] = ActionEntry(REDUCE, 348);
   _actionMap[676][GROUP] = ActionEntry(REDUCE, 348);
   _actionMap[676][RETURNTOKEN] = ActionEntry(REDUCE, 348);
   _actionMap[676][WHERE] = ActionEntry(REDUCE, 348);
   _actionMap[676][AND] = ActionEntry(REDUCE, 348);
   _actionMap[676][OR] = ActionEntry(REDUCE, 348);
   _actionMap[676][INTOK] = ActionEntry(REDUCE, 348);
   _actionMap[676][NOT] = ActionEntry(REDUCE, 348);
   _actionMap[676][MT] = ActionEntry(REDUCE, 348);
   _actionMap[676][LT] = ActionEntry(REDUCE, 348);
   _actionMap[676][NEGATION] = ActionEntry(REDUCE, 348);
   _actionMap[676][EQU] = ActionEntry(REDUCE, 348);
}
void Cego::loadParser118()
{
   _actionMap[676][BETWEEN] = ActionEntry(REDUCE, 348);
   _actionMap[676][IS] = ActionEntry(REDUCE, 348);
   _actionMap[676][LIKE] = ActionEntry(REDUCE, 348);
   _actionMap[676][NCLIKE] = ActionEntry(REDUCE, 348);
   _actionMap[676][RB] = ActionEntry(REDUCE, 348);
   _actionMap[676][ENDTOKEN] = ActionEntry(REDUCE, 348);
   _actionMap[676][UNION] = ActionEntry(REDUCE, 348);
   _actionMap[676][ROWLIMIT] = ActionEntry(REDUCE, 348);
   _actionMap[676][KSEP] = ActionEntry(REDUCE, 348);
   _actionMap[676][ASC] = ActionEntry(REDUCE, 348);
   _actionMap[676][DESC] = ActionEntry(REDUCE, 348);
   _actionMap[676][PLUS] = ActionEntry(REDUCE, 348);
   _actionMap[676][MINUS] = ActionEntry(REDUCE, 348);
   _actionMap[676][DIVISION] = ActionEntry(REDUCE, 348);
   _actionMap[676][STAR] = ActionEntry(REDUCE, 348);
   _actionMap[676][CONCAT] = ActionEntry(REDUCE, 348);
   _actionMap[676][SEMICOLON] = ActionEntry(REDUCE, 348);
   _actionMap[677][WHEN] = ActionEntry(REDUCE, 411);
   _actionMap[677][ELSE] = ActionEntry(REDUCE, 411);
   _actionMap[677][FROM] = ActionEntry(REDUCE, 411);
   _actionMap[677][AS] = ActionEntry(REDUCE, 411);
   _actionMap[677][END_TOKEN] = ActionEntry(REDUCE, 411);
   _actionMap[677][BEGIN] = ActionEntry(REDUCE, 411);
   _actionMap[677][THEN] = ActionEntry(REDUCE, 411);
   _actionMap[677][LEFT] = ActionEntry(REDUCE, 411);
   _actionMap[677][RIGHT] = ActionEntry(REDUCE, 411);
   _actionMap[677][INNER] = ActionEntry(REDUCE, 411);
   _actionMap[677][JOIN] = ActionEntry(REDUCE, 411);
   _actionMap[677][ORDER] = ActionEntry(REDUCE, 411);
   _actionMap[677][GROUP] = ActionEntry(REDUCE, 411);
   _actionMap[677][RETURNTOKEN] = ActionEntry(REDUCE, 411);
   _actionMap[677][WHERE] = ActionEntry(REDUCE, 411);
   _actionMap[677][AND] = ActionEntry(REDUCE, 411);
   _actionMap[677][OR] = ActionEntry(REDUCE, 411);
   _actionMap[677][INTOK] = ActionEntry(REDUCE, 411);
   _actionMap[677][MT] = ActionEntry(REDUCE, 411);
   _actionMap[677][LT] = ActionEntry(REDUCE, 411);
   _actionMap[677][NEGATION] = ActionEntry(REDUCE, 411);
   _actionMap[677][EQU] = ActionEntry(REDUCE, 411);
   _actionMap[677][BETWEEN] = ActionEntry(REDUCE, 411);
   _actionMap[677][IS] = ActionEntry(REDUCE, 411);
   _actionMap[677][LIKE] = ActionEntry(REDUCE, 411);
   _actionMap[677][NCLIKE] = ActionEntry(REDUCE, 411);
   _actionMap[677][ENDTOKEN] = ActionEntry(REDUCE, 411);
   _actionMap[677][UNION] = ActionEntry(REDUCE, 411);
   _actionMap[677][ROWLIMIT] = ActionEntry(REDUCE, 411);
   _actionMap[677][ASC] = ActionEntry(REDUCE, 411);
   _actionMap[677][DESC] = ActionEntry(REDUCE, 411);
   _actionMap[677][PLUS] = ActionEntry(REDUCE, 411);
   _actionMap[677][MINUS] = ActionEntry(REDUCE, 411);
}
void Cego::loadParser119()
{
   _actionMap[677][DIVISION] = ActionEntry(REDUCE, 411);
   _actionMap[677][STAR] = ActionEntry(REDUCE, 411);
   _actionMap[677][CONCAT] = ActionEntry(REDUCE, 411);
   _actionMap[677][NULLTOKEN] = ActionEntry(REDUCE, 411);
   _actionMap[677][NOT] = ActionEntry(REDUCE, 411);
   _actionMap[677][KSEP] = ActionEntry(REDUCE, 411);
   _actionMap[677][SEMICOLON] = ActionEntry(REDUCE, 411);
   _actionMap[677][RB] = ActionEntry(REDUCE, 411);
   _actionMap[678][INTVAL] = ActionEntry(SHIFT, 349);
   _actionMap[679][WHEN] = ActionEntry(REDUCE, 418);
   _actionMap[679][ELSE] = ActionEntry(REDUCE, 418);
   _actionMap[679][FROM] = ActionEntry(REDUCE, 418);
   _actionMap[679][AS] = ActionEntry(REDUCE, 418);
   _actionMap[679][END_TOKEN] = ActionEntry(REDUCE, 418);
   _actionMap[679][BEGIN] = ActionEntry(REDUCE, 418);
   _actionMap[679][THEN] = ActionEntry(REDUCE, 418);
   _actionMap[679][LEFT] = ActionEntry(REDUCE, 418);
   _actionMap[679][RIGHT] = ActionEntry(REDUCE, 418);
   _actionMap[679][INNER] = ActionEntry(REDUCE, 418);
   _actionMap[679][JOIN] = ActionEntry(REDUCE, 418);
   _actionMap[679][ORDER] = ActionEntry(REDUCE, 418);
   _actionMap[679][GROUP] = ActionEntry(REDUCE, 418);
   _actionMap[679][RETURNTOKEN] = ActionEntry(REDUCE, 418);
   _actionMap[679][WHERE] = ActionEntry(REDUCE, 418);
   _actionMap[679][AND] = ActionEntry(REDUCE, 418);
   _actionMap[679][OR] = ActionEntry(REDUCE, 418);
   _actionMap[679][INTOK] = ActionEntry(REDUCE, 418);
   _actionMap[679][MT] = ActionEntry(REDUCE, 418);
   _actionMap[679][LT] = ActionEntry(REDUCE, 418);
   _actionMap[679][NEGATION] = ActionEntry(REDUCE, 418);
   _actionMap[679][EQU] = ActionEntry(REDUCE, 418);
   _actionMap[679][BETWEEN] = ActionEntry(REDUCE, 418);
   _actionMap[679][IS] = ActionEntry(REDUCE, 418);
   _actionMap[679][LIKE] = ActionEntry(REDUCE, 418);
   _actionMap[679][NCLIKE] = ActionEntry(REDUCE, 418);
   _actionMap[679][ENDTOKEN] = ActionEntry(REDUCE, 418);
   _actionMap[679][UNION] = ActionEntry(REDUCE, 418);
   _actionMap[679][ROWLIMIT] = ActionEntry(REDUCE, 418);
   _actionMap[679][ASC] = ActionEntry(REDUCE, 418);
   _actionMap[679][DESC] = ActionEntry(REDUCE, 418);
   _actionMap[679][PLUS] = ActionEntry(REDUCE, 418);
   _actionMap[679][MINUS] = ActionEntry(REDUCE, 418);
   _actionMap[679][DIVISION] = ActionEntry(REDUCE, 418);
   _actionMap[679][STAR] = ActionEntry(REDUCE, 418);
   _actionMap[679][CONCAT] = ActionEntry(REDUCE, 418);
   _actionMap[679][NULLTOKEN] = ActionEntry(REDUCE, 418);
   _actionMap[679][NOT] = ActionEntry(REDUCE, 418);
   _actionMap[679][KSEP] = ActionEntry(REDUCE, 418);
   _actionMap[679][SEMICOLON] = ActionEntry(REDUCE, 418);
   _actionMap[679][RB] = ActionEntry(REDUCE, 418);
}
void Cego::loadParser120()
{
   _actionMap[680][WHEN] = ActionEntry(REDUCE, 417);
   _actionMap[680][ELSE] = ActionEntry(REDUCE, 417);
   _actionMap[680][FROM] = ActionEntry(REDUCE, 417);
   _actionMap[680][AS] = ActionEntry(REDUCE, 417);
   _actionMap[680][END_TOKEN] = ActionEntry(REDUCE, 417);
   _actionMap[680][BEGIN] = ActionEntry(REDUCE, 417);
   _actionMap[680][THEN] = ActionEntry(REDUCE, 417);
   _actionMap[680][LEFT] = ActionEntry(REDUCE, 417);
   _actionMap[680][RIGHT] = ActionEntry(REDUCE, 417);
   _actionMap[680][INNER] = ActionEntry(REDUCE, 417);
   _actionMap[680][JOIN] = ActionEntry(REDUCE, 417);
   _actionMap[680][ORDER] = ActionEntry(REDUCE, 417);
   _actionMap[680][GROUP] = ActionEntry(REDUCE, 417);
   _actionMap[680][RETURNTOKEN] = ActionEntry(REDUCE, 417);
   _actionMap[680][WHERE] = ActionEntry(REDUCE, 417);
   _actionMap[680][AND] = ActionEntry(REDUCE, 417);
   _actionMap[680][OR] = ActionEntry(REDUCE, 417);
   _actionMap[680][INTOK] = ActionEntry(REDUCE, 417);
   _actionMap[680][MT] = ActionEntry(REDUCE, 417);
   _actionMap[680][LT] = ActionEntry(REDUCE, 417);
   _actionMap[680][NEGATION] = ActionEntry(REDUCE, 417);
   _actionMap[680][EQU] = ActionEntry(REDUCE, 417);
   _actionMap[680][BETWEEN] = ActionEntry(REDUCE, 417);
   _actionMap[680][IS] = ActionEntry(REDUCE, 417);
   _actionMap[680][LIKE] = ActionEntry(REDUCE, 417);
   _actionMap[680][NCLIKE] = ActionEntry(REDUCE, 417);
   _actionMap[680][ENDTOKEN] = ActionEntry(REDUCE, 417);
   _actionMap[680][UNION] = ActionEntry(REDUCE, 417);
   _actionMap[680][ROWLIMIT] = ActionEntry(REDUCE, 417);
   _actionMap[680][ASC] = ActionEntry(REDUCE, 417);
   _actionMap[680][DESC] = ActionEntry(REDUCE, 417);
   _actionMap[680][PLUS] = ActionEntry(REDUCE, 417);
   _actionMap[680][MINUS] = ActionEntry(REDUCE, 417);
   _actionMap[680][DIVISION] = ActionEntry(REDUCE, 417);
   _actionMap[680][STAR] = ActionEntry(REDUCE, 417);
   _actionMap[680][CONCAT] = ActionEntry(REDUCE, 417);
   _actionMap[680][NULLTOKEN] = ActionEntry(REDUCE, 417);
   _actionMap[680][NOT] = ActionEntry(REDUCE, 417);
   _actionMap[680][KSEP] = ActionEntry(REDUCE, 417);
   _actionMap[680][SEMICOLON] = ActionEntry(REDUCE, 417);
   _actionMap[680][RB] = ActionEntry(REDUCE, 417);
   _actionMap[681][FLOATVAL] = ActionEntry(SHIFT, 350);
   _actionMap[682][WHEN] = ActionEntry(REDUCE, 416);
   _actionMap[682][ELSE] = ActionEntry(REDUCE, 416);
   _actionMap[682][FROM] = ActionEntry(REDUCE, 416);
   _actionMap[682][AS] = ActionEntry(REDUCE, 416);
   _actionMap[682][END_TOKEN] = ActionEntry(REDUCE, 416);
   _actionMap[682][BEGIN] = ActionEntry(REDUCE, 416);
   _actionMap[682][THEN] = ActionEntry(REDUCE, 416);
   _actionMap[682][LEFT] = ActionEntry(REDUCE, 416);
}
void Cego::loadParser121()
{
   _actionMap[682][RIGHT] = ActionEntry(REDUCE, 416);
   _actionMap[682][INNER] = ActionEntry(REDUCE, 416);
   _actionMap[682][JOIN] = ActionEntry(REDUCE, 416);
   _actionMap[682][ORDER] = ActionEntry(REDUCE, 416);
   _actionMap[682][GROUP] = ActionEntry(REDUCE, 416);
   _actionMap[682][RETURNTOKEN] = ActionEntry(REDUCE, 416);
   _actionMap[682][WHERE] = ActionEntry(REDUCE, 416);
   _actionMap[682][AND] = ActionEntry(REDUCE, 416);
   _actionMap[682][OR] = ActionEntry(REDUCE, 416);
   _actionMap[682][INTOK] = ActionEntry(REDUCE, 416);
   _actionMap[682][MT] = ActionEntry(REDUCE, 416);
   _actionMap[682][LT] = ActionEntry(REDUCE, 416);
   _actionMap[682][NEGATION] = ActionEntry(REDUCE, 416);
   _actionMap[682][EQU] = ActionEntry(REDUCE, 416);
   _actionMap[682][BETWEEN] = ActionEntry(REDUCE, 416);
   _actionMap[682][IS] = ActionEntry(REDUCE, 416);
   _actionMap[682][LIKE] = ActionEntry(REDUCE, 416);
   _actionMap[682][NCLIKE] = ActionEntry(REDUCE, 416);
   _actionMap[682][ENDTOKEN] = ActionEntry(REDUCE, 416);
   _actionMap[682][UNION] = ActionEntry(REDUCE, 416);
   _actionMap[682][ROWLIMIT] = ActionEntry(REDUCE, 416);
   _actionMap[682][ASC] = ActionEntry(REDUCE, 416);
   _actionMap[682][DESC] = ActionEntry(REDUCE, 416);
   _actionMap[682][PLUS] = ActionEntry(REDUCE, 416);
   _actionMap[682][MINUS] = ActionEntry(REDUCE, 416);
   _actionMap[682][DIVISION] = ActionEntry(REDUCE, 416);
   _actionMap[682][STAR] = ActionEntry(REDUCE, 416);
   _actionMap[682][CONCAT] = ActionEntry(REDUCE, 416);
   _actionMap[682][NULLTOKEN] = ActionEntry(REDUCE, 416);
   _actionMap[682][NOT] = ActionEntry(REDUCE, 416);
   _actionMap[682][KSEP] = ActionEntry(REDUCE, 416);
   _actionMap[682][SEMICOLON] = ActionEntry(REDUCE, 416);
   _actionMap[682][RB] = ActionEntry(REDUCE, 416);
   _actionMap[683][WHEN] = ActionEntry(REDUCE, 410);
   _actionMap[683][ELSE] = ActionEntry(REDUCE, 410);
   _actionMap[683][FROM] = ActionEntry(REDUCE, 410);
   _actionMap[683][AS] = ActionEntry(REDUCE, 410);
   _actionMap[683][END_TOKEN] = ActionEntry(REDUCE, 410);
   _actionMap[683][BEGIN] = ActionEntry(REDUCE, 410);
   _actionMap[683][THEN] = ActionEntry(REDUCE, 410);
   _actionMap[683][LEFT] = ActionEntry(REDUCE, 410);
   _actionMap[683][RIGHT] = ActionEntry(REDUCE, 410);
   _actionMap[683][INNER] = ActionEntry(REDUCE, 410);
   _actionMap[683][JOIN] = ActionEntry(REDUCE, 410);
   _actionMap[683][ORDER] = ActionEntry(REDUCE, 410);
   _actionMap[683][GROUP] = ActionEntry(REDUCE, 410);
   _actionMap[683][RETURNTOKEN] = ActionEntry(REDUCE, 410);
   _actionMap[683][WHERE] = ActionEntry(REDUCE, 410);
   _actionMap[683][AND] = ActionEntry(REDUCE, 410);
   _actionMap[683][OR] = ActionEntry(REDUCE, 410);
}
void Cego::loadParser122()
{
   _actionMap[683][INTOK] = ActionEntry(REDUCE, 410);
   _actionMap[683][MT] = ActionEntry(REDUCE, 410);
   _actionMap[683][LT] = ActionEntry(REDUCE, 410);
   _actionMap[683][NEGATION] = ActionEntry(REDUCE, 410);
   _actionMap[683][EQU] = ActionEntry(REDUCE, 410);
   _actionMap[683][BETWEEN] = ActionEntry(REDUCE, 410);
   _actionMap[683][IS] = ActionEntry(REDUCE, 410);
   _actionMap[683][LIKE] = ActionEntry(REDUCE, 410);
   _actionMap[683][NCLIKE] = ActionEntry(REDUCE, 410);
   _actionMap[683][ENDTOKEN] = ActionEntry(REDUCE, 410);
   _actionMap[683][UNION] = ActionEntry(REDUCE, 410);
   _actionMap[683][ROWLIMIT] = ActionEntry(REDUCE, 410);
   _actionMap[683][ASC] = ActionEntry(REDUCE, 410);
   _actionMap[683][DESC] = ActionEntry(REDUCE, 410);
   _actionMap[683][PLUS] = ActionEntry(REDUCE, 410);
   _actionMap[683][MINUS] = ActionEntry(REDUCE, 410);
   _actionMap[683][DIVISION] = ActionEntry(REDUCE, 410);
   _actionMap[683][STAR] = ActionEntry(REDUCE, 410);
   _actionMap[683][CONCAT] = ActionEntry(REDUCE, 410);
   _actionMap[683][NULLTOKEN] = ActionEntry(REDUCE, 410);
   _actionMap[683][NOT] = ActionEntry(REDUCE, 410);
   _actionMap[683][KSEP] = ActionEntry(REDUCE, 410);
   _actionMap[683][SEMICOLON] = ActionEntry(REDUCE, 410);
   _actionMap[683][RB] = ActionEntry(REDUCE, 410);
   _actionMap[684][WHEN] = ActionEntry(REDUCE, 412);
   _actionMap[684][ELSE] = ActionEntry(REDUCE, 412);
   _actionMap[684][FROM] = ActionEntry(REDUCE, 412);
   _actionMap[684][AS] = ActionEntry(REDUCE, 412);
   _actionMap[684][END_TOKEN] = ActionEntry(REDUCE, 412);
   _actionMap[684][BEGIN] = ActionEntry(REDUCE, 412);
   _actionMap[684][THEN] = ActionEntry(REDUCE, 412);
   _actionMap[684][LEFT] = ActionEntry(REDUCE, 412);
   _actionMap[684][RIGHT] = ActionEntry(REDUCE, 412);
   _actionMap[684][INNER] = ActionEntry(REDUCE, 412);
   _actionMap[684][JOIN] = ActionEntry(REDUCE, 412);
   _actionMap[684][ORDER] = ActionEntry(REDUCE, 412);
   _actionMap[684][GROUP] = ActionEntry(REDUCE, 412);
   _actionMap[684][RETURNTOKEN] = ActionEntry(REDUCE, 412);
   _actionMap[684][WHERE] = ActionEntry(REDUCE, 412);
   _actionMap[684][AND] = ActionEntry(REDUCE, 412);
   _actionMap[684][OR] = ActionEntry(REDUCE, 412);
   _actionMap[684][INTOK] = ActionEntry(REDUCE, 412);
   _actionMap[684][MT] = ActionEntry(REDUCE, 412);
   _actionMap[684][LT] = ActionEntry(REDUCE, 412);
   _actionMap[684][NEGATION] = ActionEntry(REDUCE, 412);
   _actionMap[684][EQU] = ActionEntry(REDUCE, 412);
   _actionMap[684][BETWEEN] = ActionEntry(REDUCE, 412);
   _actionMap[684][IS] = ActionEntry(REDUCE, 412);
   _actionMap[684][LIKE] = ActionEntry(REDUCE, 412);
   _actionMap[684][NCLIKE] = ActionEntry(REDUCE, 412);
}
void Cego::loadParser123()
{
   _actionMap[684][ENDTOKEN] = ActionEntry(REDUCE, 412);
   _actionMap[684][UNION] = ActionEntry(REDUCE, 412);
   _actionMap[684][ROWLIMIT] = ActionEntry(REDUCE, 412);
   _actionMap[684][ASC] = ActionEntry(REDUCE, 412);
   _actionMap[684][DESC] = ActionEntry(REDUCE, 412);
   _actionMap[684][PLUS] = ActionEntry(REDUCE, 412);
   _actionMap[684][MINUS] = ActionEntry(REDUCE, 412);
   _actionMap[684][DIVISION] = ActionEntry(REDUCE, 412);
   _actionMap[684][STAR] = ActionEntry(REDUCE, 412);
   _actionMap[684][CONCAT] = ActionEntry(REDUCE, 412);
   _actionMap[684][NULLTOKEN] = ActionEntry(REDUCE, 412);
   _actionMap[684][NOT] = ActionEntry(REDUCE, 412);
   _actionMap[684][KSEP] = ActionEntry(REDUCE, 412);
   _actionMap[684][SEMICOLON] = ActionEntry(REDUCE, 412);
   _actionMap[684][RB] = ActionEntry(REDUCE, 412);
   _actionMap[685][WHEN] = ActionEntry(REDUCE, 413);
   _actionMap[685][ELSE] = ActionEntry(REDUCE, 413);
   _actionMap[685][FROM] = ActionEntry(REDUCE, 413);
   _actionMap[685][AS] = ActionEntry(REDUCE, 413);
   _actionMap[685][END_TOKEN] = ActionEntry(REDUCE, 413);
   _actionMap[685][BEGIN] = ActionEntry(REDUCE, 413);
   _actionMap[685][THEN] = ActionEntry(REDUCE, 413);
   _actionMap[685][LEFT] = ActionEntry(REDUCE, 413);
   _actionMap[685][RIGHT] = ActionEntry(REDUCE, 413);
   _actionMap[685][INNER] = ActionEntry(REDUCE, 413);
   _actionMap[685][JOIN] = ActionEntry(REDUCE, 413);
   _actionMap[685][ORDER] = ActionEntry(REDUCE, 413);
   _actionMap[685][GROUP] = ActionEntry(REDUCE, 413);
   _actionMap[685][RETURNTOKEN] = ActionEntry(REDUCE, 413);
   _actionMap[685][WHERE] = ActionEntry(REDUCE, 413);
   _actionMap[685][AND] = ActionEntry(REDUCE, 413);
   _actionMap[685][OR] = ActionEntry(REDUCE, 413);
   _actionMap[685][INTOK] = ActionEntry(REDUCE, 413);
   _actionMap[685][MT] = ActionEntry(REDUCE, 413);
   _actionMap[685][LT] = ActionEntry(REDUCE, 413);
   _actionMap[685][NEGATION] = ActionEntry(REDUCE, 413);
   _actionMap[685][EQU] = ActionEntry(REDUCE, 413);
   _actionMap[685][BETWEEN] = ActionEntry(REDUCE, 413);
   _actionMap[685][IS] = ActionEntry(REDUCE, 413);
   _actionMap[685][LIKE] = ActionEntry(REDUCE, 413);
   _actionMap[685][NCLIKE] = ActionEntry(REDUCE, 413);
   _actionMap[685][ENDTOKEN] = ActionEntry(REDUCE, 413);
   _actionMap[685][UNION] = ActionEntry(REDUCE, 413);
   _actionMap[685][ROWLIMIT] = ActionEntry(REDUCE, 413);
   _actionMap[685][ASC] = ActionEntry(REDUCE, 413);
   _actionMap[685][DESC] = ActionEntry(REDUCE, 413);
   _actionMap[685][PLUS] = ActionEntry(REDUCE, 413);
   _actionMap[685][MINUS] = ActionEntry(REDUCE, 413);
   _actionMap[685][DIVISION] = ActionEntry(REDUCE, 413);
   _actionMap[685][STAR] = ActionEntry(REDUCE, 413);
}
void Cego::loadParser124()
{
   _actionMap[685][CONCAT] = ActionEntry(REDUCE, 413);
   _actionMap[685][NULLTOKEN] = ActionEntry(REDUCE, 413);
   _actionMap[685][NOT] = ActionEntry(REDUCE, 413);
   _actionMap[685][KSEP] = ActionEntry(REDUCE, 413);
   _actionMap[685][SEMICOLON] = ActionEntry(REDUCE, 413);
   _actionMap[685][RB] = ActionEntry(REDUCE, 413);
   _actionMap[686][SEMICOLON] = ActionEntry(REDUCE, 235);
   _actionMap[687][SEMICOLON] = ActionEntry(REDUCE, 234);
   _actionMap[688][SEMICOLON] = ActionEntry(REDUCE, 239);
   _actionMap[689][SEMICOLON] = ActionEntry(REDUCE, 236);
   _actionMap[690][SEMICOLON] = ActionEntry(REDUCE, 237);
   _actionMap[691][SEMICOLON] = ActionEntry(REDUCE, 233);
   _actionMap[692][SEMICOLON] = ActionEntry(REDUCE, 240);
   _actionMap[693][SEMICOLON] = ActionEntry(REDUCE, 238);
   _actionMap[694][SEMICOLON] = ActionEntry(REDUCE, 199);
   _actionMap[694][RB] = ActionEntry(REDUCE, 199);
   _actionMap[694][ENDTOKEN] = ActionEntry(REDUCE, 199);
   _actionMap[694][UNION] = ActionEntry(REDUCE, 199);
   _actionMap[694][ROWLIMIT] = ActionEntry(REDUCE, 199);
   _actionMap[694][ORDER] = ActionEntry(REDUCE, 199);
   _actionMap[694][GROUP] = ActionEntry(SHIFT, 786);
   _jumpMap[694][NoGroup] = 785;
   _jumpMap[694][GroupClause] = 784;
   _actionMap[695][LEFT] = ActionEntry(REDUCE, 179);
   _actionMap[695][RIGHT] = ActionEntry(REDUCE, 179);
   _actionMap[695][INNER] = ActionEntry(REDUCE, 179);
   _actionMap[695][JOIN] = ActionEntry(REDUCE, 179);
   _actionMap[695][RB] = ActionEntry(REDUCE, 179);
   _actionMap[695][ENDTOKEN] = ActionEntry(REDUCE, 179);
   _actionMap[695][UNION] = ActionEntry(REDUCE, 179);
   _actionMap[695][ROWLIMIT] = ActionEntry(REDUCE, 179);
   _actionMap[695][ORDER] = ActionEntry(REDUCE, 179);
   _actionMap[695][GROUP] = ActionEntry(REDUCE, 179);
   _actionMap[695][SEMICOLON] = ActionEntry(REDUCE, 179);
   _actionMap[695][RETURNTOKEN] = ActionEntry(REDUCE, 179);
   _actionMap[695][WHERE] = ActionEntry(REDUCE, 179);
   _actionMap[696][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[696][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[696][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[696][ObjSpec] = 542;
   _jumpMap[696][JoinTable] = 788;
   _jumpMap[696][Table] = 787;
   _actionMap[697][JOIN] = ActionEntry(SHIFT, 789);
   _actionMap[698][IDENTIFIER] = ActionEntry(REDUCE, 188);
   _actionMap[698][QUALIFIEDOBJ] = ActionEntry(REDUCE, 188);
   _actionMap[698][QUALIFIEDTS] = ActionEntry(REDUCE, 188);
   _actionMap[699][OUTER] = ActionEntry(SHIFT, 790);
   _actionMap[700][OUTER] = ActionEntry(SHIFT, 791);
   _actionMap[701][LEFT] = ActionEntry(REDUCE, 180);
   _actionMap[701][RIGHT] = ActionEntry(REDUCE, 180);
}
void Cego::loadParser125()
{
   _actionMap[701][INNER] = ActionEntry(REDUCE, 180);
   _actionMap[701][JOIN] = ActionEntry(REDUCE, 180);
   _actionMap[701][RB] = ActionEntry(REDUCE, 180);
   _actionMap[701][ENDTOKEN] = ActionEntry(REDUCE, 180);
   _actionMap[701][UNION] = ActionEntry(REDUCE, 180);
   _actionMap[701][ROWLIMIT] = ActionEntry(REDUCE, 180);
   _actionMap[701][ORDER] = ActionEntry(REDUCE, 180);
   _actionMap[701][GROUP] = ActionEntry(REDUCE, 180);
   _actionMap[701][SEMICOLON] = ActionEntry(REDUCE, 180);
   _actionMap[701][RETURNTOKEN] = ActionEntry(REDUCE, 180);
   _actionMap[701][WHERE] = ActionEntry(REDUCE, 180);
   _actionMap[702][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[702][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[702][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[702][ObjSpec] = 542;
   _jumpMap[702][Table] = 793;
   _jumpMap[702][TableList] = 792;
   _actionMap[703][KSEP] = ActionEntry(REDUCE, 192);
   _actionMap[703][LEFT] = ActionEntry(REDUCE, 192);
   _actionMap[703][RIGHT] = ActionEntry(REDUCE, 192);
   _actionMap[703][INNER] = ActionEntry(REDUCE, 192);
   _actionMap[703][JOIN] = ActionEntry(REDUCE, 192);
   _actionMap[703][RB] = ActionEntry(REDUCE, 192);
   _actionMap[703][ENDTOKEN] = ActionEntry(REDUCE, 192);
   _actionMap[703][UNION] = ActionEntry(REDUCE, 192);
   _actionMap[703][ROWLIMIT] = ActionEntry(REDUCE, 192);
   _actionMap[703][ORDER] = ActionEntry(REDUCE, 192);
   _actionMap[703][GROUP] = ActionEntry(REDUCE, 192);
   _actionMap[703][SEMICOLON] = ActionEntry(REDUCE, 192);
   _actionMap[703][RETURNTOKEN] = ActionEntry(REDUCE, 192);
   _actionMap[703][WHERE] = ActionEntry(REDUCE, 192);
   _actionMap[703][ON] = ActionEntry(REDUCE, 192);
   _actionMap[704][FROM] = ActionEntry(REDUCE, 174);
   _actionMap[704][RB] = ActionEntry(REDUCE, 174);
   _actionMap[704][SEMICOLON] = ActionEntry(REDUCE, 174);
   _actionMap[704][ENDTOKEN] = ActionEntry(REDUCE, 174);
   _actionMap[704][KSEP] = ActionEntry(REDUCE, 174);
   _actionMap[705][KSEP] = ActionEntry(REDUCE, 194);
   _actionMap[705][FROM] = ActionEntry(REDUCE, 194);
   _actionMap[705][RB] = ActionEntry(REDUCE, 194);
   _actionMap[705][SEMICOLON] = ActionEntry(REDUCE, 194);
   _actionMap[705][ENDTOKEN] = ActionEntry(REDUCE, 194);
   _actionMap[706][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[706][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[706][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[706][SEMICOLON] = ActionEntry(REDUCE, 95);
   _actionMap[707][SEMICOLON] = ActionEntry(REDUCE, 161);
   _actionMap[707][RETURNTOKEN] = ActionEntry(SHIFT, 796);
   _jumpMap[707][NoUpdateReturnOpt] = 795;
   _jumpMap[707][UpdReturnOpt] = 794;
}
void Cego::loadParser126()
{
   _actionMap[708][IDENTIFIER] = ActionEntry(SHIFT, 551);
   _jumpMap[708][Assignment] = 797;
   _actionMap[709][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[709][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[709][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[709][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[709][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[709][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[709][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[709][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[709][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[709][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[709][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[709][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[709][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[709][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[709][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[709][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[709][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[709][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[709][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[709][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[709][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[709][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[709][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[709][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[709][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[709][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[709][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[709][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[709][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[709][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[709][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[709][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[709][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[709][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[709][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[709][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[709][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[709][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[709][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[709][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[709][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[709][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[709][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[709][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[709][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[709][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[709][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[709][LB] = ActionEntry(SHIFT, 178);
}
void Cego::loadParser127()
{
   _actionMap[709][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[709][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[709][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[709][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[709][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[709][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[709][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[709][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[709][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[709][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[709][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[709][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[709][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[709][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[709][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[709][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[709][ObjSpec] = 122;
   _jumpMap[709][Constant] = 121;
   _jumpMap[709][SignedFloat] = 120;
   _jumpMap[709][SignedInt] = 119;
   _jumpMap[709][Attribute] = 118;
   _jumpMap[709][Function] = 117;
   _jumpMap[709][Factor] = 116;
   _jumpMap[709][Term] = 115;
   _jumpMap[709][Expr] = 798;
   _jumpMap[709][CasePrepare] = 113;
   _jumpMap[709][CaseClause] = 112;
   _actionMap[710][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[710][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[710][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[710][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[710][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[710][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[710][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[710][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[710][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[710][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[710][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[710][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[710][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[710][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[710][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[710][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[710][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[710][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[710][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[710][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[710][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[710][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[710][TRUNC] = ActionEntry(SHIFT, 176);
}
void Cego::loadParser128()
{
   _actionMap[710][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[710][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[710][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[710][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[710][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[710][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[710][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[710][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[710][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[710][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[710][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[710][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[710][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[710][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[710][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[710][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[710][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[710][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[710][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[710][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[710][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[710][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[710][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[710][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[710][LB] = ActionEntry(SHIFT, 178);
   _actionMap[710][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[710][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[710][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[710][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[710][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[710][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[710][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[710][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[710][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[710][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[710][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[710][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[710][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[710][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[710][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[710][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[710][RB] = ActionEntry(REDUCE, 280);
   _jumpMap[710][ObjSpec] = 122;
   _jumpMap[710][Constant] = 121;
   _jumpMap[710][SignedFloat] = 120;
   _jumpMap[710][SignedInt] = 119;
   _jumpMap[710][Attribute] = 118;
   _jumpMap[710][Function] = 117;
   _jumpMap[710][Factor] = 116;
   _jumpMap[710][Term] = 115;
}
void Cego::loadParser129()
{
   _jumpMap[710][Expr] = 397;
   _jumpMap[710][ProcValueList] = 396;
   _jumpMap[710][ProcValueListOpt] = 799;
   _jumpMap[710][CasePrepare] = 113;
   _jumpMap[710][CaseClause] = 112;
   _actionMap[387][SEMICOLON] = ActionEntry(REDUCE, 81);
   _actionMap[388][SEMICOLON] = ActionEntry(REDUCE, 225);
   _actionMap[389][KSEP] = ActionEntry(SHIFT, 553);
   _actionMap[389][SEMICOLON] = ActionEntry(REDUCE, 227);
   _actionMap[390][CHECK] = ActionEntry(SHIFT, 554);
   _actionMap[390][FOREIGN] = ActionEntry(SHIFT, 556);
   _actionMap[390][COLUMN] = ActionEntry(SHIFT, 555);
   _actionMap[391][COLUMN] = ActionEntry(SHIFT, 557);
   _actionMap[392][COLUMN] = ActionEntry(SHIFT, 558);
   _actionMap[393][COLUMN] = ActionEntry(SHIFT, 559);
   _actionMap[394][STRINGVAL] = ActionEntry(SHIFT, 560);
   _actionMap[395][RB] = ActionEntry(SHIFT, 398);
   _actionMap[396][KSEP] = ActionEntry(SHIFT, 561);
   _actionMap[396][RB] = ActionEntry(REDUCE, 279);
   _actionMap[397][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[397][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[397][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[397][KSEP] = ActionEntry(REDUCE, 282);
   _actionMap[397][RB] = ActionEntry(REDUCE, 282);
   _actionMap[398][SEMICOLON] = ActionEntry(REDUCE, 62);
   _actionMap[399][SEMICOLON] = ActionEntry(REDUCE, 267);
   _actionMap[400][SEMICOLON] = ActionEntry(REDUCE, 268);
   _actionMap[401][SEMICOLON] = ActionEntry(REDUCE, 269);
   _actionMap[402][SEMICOLON] = ActionEntry(REDUCE, 270);
   _actionMap[403][SEMICOLON] = ActionEntry(REDUCE, 271);
   _actionMap[404][SEMICOLON] = ActionEntry(REDUCE, 264);
   _actionMap[405][SEMICOLON] = ActionEntry(REDUCE, 266);
   _actionMap[406][SEMICOLON] = ActionEntry(REDUCE, 265);
   _actionMap[407][END_TOKEN] = ActionEntry(SHIFT, 562);
   _actionMap[408][EXCEPTION] = ActionEntry(REDUCE, 277);
   _actionMap[408][ELSE] = ActionEntry(REDUCE, 277);
   _actionMap[408][ELSIF] = ActionEntry(REDUCE, 277);
   _actionMap[408][END_TOKEN] = ActionEntry(REDUCE, 277);
   _actionMap[408][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[408][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[408][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[408][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[408][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[408][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[408][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[408][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[408][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[408][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[408][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[408][DATE2LONG] = ActionEntry(SHIFT, 139);
}
void Cego::loadParser130()
{
   _actionMap[408][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[408][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[408][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[408][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[408][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[408][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[408][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[408][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[408][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[408][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[408][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[408][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[408][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[408][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[408][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[408][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[408][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[408][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[408][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[408][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[408][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[408][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[408][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[408][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[408][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[408][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[408][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[408][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[408][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[408][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[408][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[408][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[408][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[408][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[408][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[408][LB] = ActionEntry(SHIFT, 178);
   _actionMap[408][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[408][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[408][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[408][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[408][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[408][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[408][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[408][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[408][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[408][VARREF] = ActionEntry(SHIFT, 422);
   _actionMap[408][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[408][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[408][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[408][AVG] = ActionEntry(SHIFT, 125);
}
void Cego::loadParser131()
{
   _actionMap[408][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[408][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[408][IF] = ActionEntry(SHIFT, 416);
   _actionMap[408][BEGIN] = ActionEntry(SHIFT, 413);
   _actionMap[408][UNLOCK] = ActionEntry(SHIFT, 28);
   _actionMap[408][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[408][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[408][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[408][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[408][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[408][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[408][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[408][VAR] = ActionEntry(SHIFT, 420);
   _actionMap[408][CURSOR] = ActionEntry(SHIFT, 415);
   _actionMap[408][CLOSE] = ActionEntry(SHIFT, 414);
   _actionMap[408][NOOP] = ActionEntry(SHIFT, 417);
   _actionMap[408][THROW] = ActionEntry(SHIFT, 419);
   _actionMap[408][RETURNTOKEN] = ActionEntry(SHIFT, 418);
   _actionMap[408][WHILE] = ActionEntry(SHIFT, 421);
   _jumpMap[408][ObjSpec] = 122;
   _jumpMap[408][Constant] = 121;
   _jumpMap[408][SignedFloat] = 120;
   _jumpMap[408][SignedInt] = 119;
   _jumpMap[408][Attribute] = 118;
   _jumpMap[408][Function] = 117;
   _jumpMap[408][Factor] = 116;
   _jumpMap[408][Term] = 115;
   _jumpMap[408][Expr] = 412;
   _jumpMap[408][ProcStatement] = 564;
   _jumpMap[408][ProcIfPart] = 410;
   _jumpMap[408][ProcExceptionList] = 563;
   _jumpMap[408][ProcBlockStart] = 409;
   _jumpMap[408][DeleteStatement] = 406;
   _jumpMap[408][UpdateStatement] = 405;
   _jumpMap[408][InsertStatement] = 404;
   _jumpMap[408][UnlockStatement] = 403;
   _jumpMap[408][LockStatement] = 402;
   _jumpMap[408][RollbackStatement] = 401;
   _jumpMap[408][CommitStatement] = 400;
   _jumpMap[408][StartStatement] = 399;
   _jumpMap[408][CasePrepare] = 113;
   _jumpMap[408][CaseClause] = 112;
   _actionMap[409][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[409][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[409][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[409][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[409][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[409][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[409][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[409][LTRIM] = ActionEntry(SHIFT, 153);
}
void Cego::loadParser132()
{
   _actionMap[409][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[409][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[409][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[409][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[409][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[409][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[409][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[409][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[409][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[409][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[409][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[409][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[409][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[409][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[409][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[409][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[409][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[409][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[409][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[409][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[409][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[409][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[409][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[409][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[409][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[409][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[409][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[409][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[409][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[409][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[409][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[409][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[409][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[409][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[409][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[409][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[409][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[409][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[409][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[409][LB] = ActionEntry(SHIFT, 178);
   _actionMap[409][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[409][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[409][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[409][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[409][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[409][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[409][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[409][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[409][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[409][VARREF] = ActionEntry(SHIFT, 422);
}
void Cego::loadParser133()
{
   _actionMap[409][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[409][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[409][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[409][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[409][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[409][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[409][IF] = ActionEntry(SHIFT, 416);
   _actionMap[409][BEGIN] = ActionEntry(SHIFT, 413);
   _actionMap[409][UNLOCK] = ActionEntry(SHIFT, 28);
   _actionMap[409][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[409][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[409][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[409][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[409][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[409][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[409][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[409][VAR] = ActionEntry(SHIFT, 420);
   _actionMap[409][CURSOR] = ActionEntry(SHIFT, 415);
   _actionMap[409][CLOSE] = ActionEntry(SHIFT, 414);
   _actionMap[409][NOOP] = ActionEntry(SHIFT, 417);
   _actionMap[409][THROW] = ActionEntry(SHIFT, 419);
   _actionMap[409][RETURNTOKEN] = ActionEntry(SHIFT, 418);
   _actionMap[409][WHILE] = ActionEntry(SHIFT, 421);
   _jumpMap[409][ObjSpec] = 122;
   _jumpMap[409][Constant] = 121;
   _jumpMap[409][SignedFloat] = 120;
   _jumpMap[409][SignedInt] = 119;
   _jumpMap[409][Attribute] = 118;
   _jumpMap[409][Function] = 117;
   _jumpMap[409][Factor] = 116;
   _jumpMap[409][Term] = 115;
   _jumpMap[409][Expr] = 412;
   _jumpMap[409][ProcStatement] = 411;
   _jumpMap[409][ProcIfPart] = 410;
   _jumpMap[409][ProcBlockStart] = 409;
   _jumpMap[409][ProcStatementList] = 408;
   _jumpMap[409][ProcStmtBlock] = 565;
   _jumpMap[409][DeleteStatement] = 406;
   _jumpMap[409][UpdateStatement] = 405;
   _jumpMap[409][InsertStatement] = 404;
   _jumpMap[409][UnlockStatement] = 403;
   _jumpMap[409][LockStatement] = 402;
   _jumpMap[409][RollbackStatement] = 401;
   _jumpMap[409][CommitStatement] = 400;
   _jumpMap[409][StartStatement] = 399;
   _jumpMap[409][CasePrepare] = 113;
   _jumpMap[409][CaseClause] = 112;
   _actionMap[410][ELSIF] = ActionEntry(SHIFT, 568);
   _actionMap[410][END_TOKEN] = ActionEntry(REDUCE, 287);
   _actionMap[410][ELSE] = ActionEntry(REDUCE, 287);
}
void Cego::loadParser134()
{
   _jumpMap[410][ProcElsIfOpt] = 567;
   _jumpMap[410][ProcElsIfList] = 566;
   _actionMap[411][SEMICOLON] = ActionEntry(SHIFT, 569);
   _actionMap[412][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[412][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[412][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[412][SEMICOLON] = ActionEntry(REDUCE, 258);
   _actionMap[413][VAR] = ActionEntry(REDUCE, 275);
   _actionMap[413][CURSOR] = ActionEntry(REDUCE, 275);
   _actionMap[413][CLOSE] = ActionEntry(REDUCE, 275);
   _actionMap[413][VARREF] = ActionEntry(REDUCE, 275);
   _actionMap[413][NOOP] = ActionEntry(REDUCE, 275);
   _actionMap[413][THROW] = ActionEntry(REDUCE, 275);
   _actionMap[413][RETURNTOKEN] = ActionEntry(REDUCE, 275);
   _actionMap[413][WHILE] = ActionEntry(REDUCE, 275);
   _actionMap[413][IF] = ActionEntry(REDUCE, 275);
   _actionMap[413][BEGIN] = ActionEntry(REDUCE, 275);
   _actionMap[413][UNLOCK] = ActionEntry(REDUCE, 275);
   _actionMap[413][LOCK] = ActionEntry(REDUCE, 275);
   _actionMap[413][ROLLBACK] = ActionEntry(REDUCE, 275);
   _actionMap[413][COMMIT] = ActionEntry(REDUCE, 275);
   _actionMap[413][START_TOKEN] = ActionEntry(REDUCE, 275);
   _actionMap[413][UPDATE] = ActionEntry(REDUCE, 275);
   _actionMap[413][DELETETOK] = ActionEntry(REDUCE, 275);
   _actionMap[413][INSERT] = ActionEntry(REDUCE, 275);
   _actionMap[413][FETCH] = ActionEntry(REDUCE, 275);
   _actionMap[413][LB] = ActionEntry(REDUCE, 275);
   _actionMap[413][COUNT] = ActionEntry(REDUCE, 275);
   _actionMap[413][SUM] = ActionEntry(REDUCE, 275);
   _actionMap[413][AVG] = ActionEntry(REDUCE, 275);
   _actionMap[413][MIN] = ActionEntry(REDUCE, 275);
   _actionMap[413][MAX] = ActionEntry(REDUCE, 275);
   _actionMap[413][CASE] = ActionEntry(REDUCE, 275);
   _actionMap[413][INT2ASC] = ActionEntry(REDUCE, 275);
   _actionMap[413][ASC2INT] = ActionEntry(REDUCE, 275);
   _actionMap[413][TRIM] = ActionEntry(REDUCE, 275);
   _actionMap[413][RTRIM] = ActionEntry(REDUCE, 275);
   _actionMap[413][LTRIM] = ActionEntry(REDUCE, 275);
   _actionMap[413][ROUND] = ActionEntry(REDUCE, 275);
   _actionMap[413][SCANDATE] = ActionEntry(REDUCE, 275);
   _actionMap[413][DATE2STR] = ActionEntry(REDUCE, 275);
   _actionMap[413][DATE2LONG] = ActionEntry(REDUCE, 275);
   _actionMap[413][LONG2DATE] = ActionEntry(REDUCE, 275);
   _actionMap[413][NEWDATE] = ActionEntry(REDUCE, 275);
   _actionMap[413][LOWER] = ActionEntry(REDUCE, 275);
   _actionMap[413][UPPER] = ActionEntry(REDUCE, 275);
   _actionMap[413][LEFT] = ActionEntry(REDUCE, 275);
   _actionMap[413][RIGHT] = ActionEntry(REDUCE, 275);
   _actionMap[413][GETPOS] = ActionEntry(REDUCE, 275);
   _actionMap[413][SUBSTR] = ActionEntry(REDUCE, 275);
}
void Cego::loadParser135()
{
   _actionMap[413][REPLACE] = ActionEntry(REDUCE, 275);
   _actionMap[413][LENGTH] = ActionEntry(REDUCE, 275);
   _actionMap[413][TRUNC] = ActionEntry(REDUCE, 275);
   _actionMap[413][STR2INT] = ActionEntry(REDUCE, 275);
   _actionMap[413][STR2LONG] = ActionEntry(REDUCE, 275);
   _actionMap[413][RANDSTR] = ActionEntry(REDUCE, 275);
   _actionMap[413][RANDINT] = ActionEntry(REDUCE, 275);
   _actionMap[413][MOD] = ActionEntry(REDUCE, 275);
   _actionMap[413][DIV] = ActionEntry(REDUCE, 275);
   _actionMap[413][LMOD] = ActionEntry(REDUCE, 275);
   _actionMap[413][LDIV] = ActionEntry(REDUCE, 275);
   _actionMap[413][POWER] = ActionEntry(REDUCE, 275);
   _actionMap[413][BITAND] = ActionEntry(REDUCE, 275);
   _actionMap[413][BITOR] = ActionEntry(REDUCE, 275);
   _actionMap[413][BITXOR] = ActionEntry(REDUCE, 275);
   _actionMap[413][BLOBSIZE] = ActionEntry(REDUCE, 275);
   _actionMap[413][BLOBREF] = ActionEntry(REDUCE, 275);
   _actionMap[413][CLOBSIZE] = ActionEntry(REDUCE, 275);
   _actionMap[413][CLOBREF] = ActionEntry(REDUCE, 275);
   _actionMap[413][CLOB2STR] = ActionEntry(REDUCE, 275);
   _actionMap[413][REGMATCH] = ActionEntry(REDUCE, 275);
   _actionMap[413][NEXTCOUNT] = ActionEntry(REDUCE, 275);
   _actionMap[413][SETCOUNT] = ActionEntry(REDUCE, 275);
   _actionMap[413][GETCOUNT] = ActionEntry(REDUCE, 275);
   _actionMap[413][IDENTIFIER] = ActionEntry(REDUCE, 275);
   _actionMap[413][QUALIFIEDOBJ] = ActionEntry(REDUCE, 275);
   _actionMap[413][QUALIFIEDTS] = ActionEntry(REDUCE, 275);
   _actionMap[413][QUALIFIEDPRE] = ActionEntry(REDUCE, 275);
   _actionMap[413][STRINGVAL] = ActionEntry(REDUCE, 275);
   _actionMap[413][SYSDATE] = ActionEntry(REDUCE, 275);
   _actionMap[413][NULLTOKEN] = ActionEntry(REDUCE, 275);
   _actionMap[413][TRUEVAL] = ActionEntry(REDUCE, 275);
   _actionMap[413][FALSEVAL] = ActionEntry(REDUCE, 275);
   _actionMap[413][BLOB] = ActionEntry(REDUCE, 275);
   _actionMap[413][CLOB] = ActionEntry(REDUCE, 275);
   _actionMap[413][FLOATVAL] = ActionEntry(REDUCE, 275);
   _actionMap[413][MINUS] = ActionEntry(REDUCE, 275);
   _actionMap[413][INTVAL] = ActionEntry(REDUCE, 275);
   _actionMap[414][IDENTIFIER] = ActionEntry(SHIFT, 570);
   _actionMap[415][IDENTIFIER] = ActionEntry(SHIFT, 571);
   _actionMap[416][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[416][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[416][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[416][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[416][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[416][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[416][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[416][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[416][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[416][SCANDATE] = ActionEntry(SHIFT, 167);
}
void Cego::loadParser136()
{
   _actionMap[416][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[416][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[416][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[416][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[416][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[416][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[416][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[416][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[416][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[416][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[416][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[416][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[416][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[416][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[416][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[416][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[416][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[416][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[416][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[416][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[416][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[416][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[416][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[416][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[416][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[416][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[416][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[416][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[416][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[416][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[416][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[416][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[416][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[416][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[416][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[416][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[416][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[416][LB] = ActionEntry(SHIFT, 178);
   _actionMap[416][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[416][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[416][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[416][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[416][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[416][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[416][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[416][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[416][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[416][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[416][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[416][COUNT] = ActionEntry(SHIFT, 137);
}
void Cego::loadParser137()
{
   _actionMap[416][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[416][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[416][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[416][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[416][EXISTS] = ActionEntry(SHIFT, 277);
   _actionMap[416][NOT] = ActionEntry(SHIFT, 278);
   _jumpMap[416][ObjSpec] = 122;
   _jumpMap[416][Constant] = 121;
   _jumpMap[416][SignedFloat] = 120;
   _jumpMap[416][SignedInt] = 119;
   _jumpMap[416][Attribute] = 118;
   _jumpMap[416][Function] = 117;
   _jumpMap[416][Factor] = 116;
   _jumpMap[416][Term] = 115;
   _jumpMap[416][Expr] = 276;
   _jumpMap[416][Predicate] = 275;
   _jumpMap[416][Conjunction] = 274;
   _jumpMap[416][Condition] = 573;
   _jumpMap[416][ProcIfCondition] = 572;
   _jumpMap[416][CasePrepare] = 113;
   _jumpMap[416][CaseClause] = 112;
   _actionMap[417][SEMICOLON] = ActionEntry(REDUCE, 259);
   _actionMap[418][SEMICOLON] = ActionEntry(REDUCE, 272);
   _actionMap[418][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[418][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[418][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[418][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[418][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[418][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[418][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[418][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[418][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[418][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[418][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[418][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[418][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[418][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[418][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[418][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[418][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[418][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[418][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[418][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[418][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[418][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[418][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[418][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[418][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[418][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[418][RANDINT] = ActionEntry(SHIFT, 161);
}
void Cego::loadParser138()
{
   _actionMap[418][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[418][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[418][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[418][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[418][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[418][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[418][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[418][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[418][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[418][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[418][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[418][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[418][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[418][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[418][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[418][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[418][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[418][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[418][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[418][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[418][LB] = ActionEntry(SHIFT, 178);
   _actionMap[418][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[418][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[418][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[418][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[418][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[418][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[418][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[418][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[418][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[418][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[418][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[418][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[418][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[418][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[418][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[418][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[418][ObjSpec] = 122;
   _jumpMap[418][Constant] = 121;
   _jumpMap[418][SignedFloat] = 120;
   _jumpMap[418][SignedInt] = 119;
   _jumpMap[418][Attribute] = 118;
   _jumpMap[418][Function] = 117;
   _jumpMap[418][Factor] = 116;
   _jumpMap[418][Term] = 115;
   _jumpMap[418][Expr] = 574;
   _jumpMap[418][CasePrepare] = 113;
   _jumpMap[418][CaseClause] = 112;
   _actionMap[419][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[419][MINUS] = ActionEntry(SHIFT, 179);
}
void Cego::loadParser139()
{
   _actionMap[419][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[419][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[419][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[419][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[419][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[419][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[419][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[419][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[419][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[419][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[419][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[419][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[419][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[419][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[419][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[419][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[419][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[419][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[419][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[419][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[419][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[419][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[419][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[419][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[419][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[419][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[419][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[419][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[419][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[419][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[419][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[419][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[419][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[419][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[419][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[419][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[419][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[419][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[419][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[419][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[419][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[419][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[419][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[419][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[419][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[419][LB] = ActionEntry(SHIFT, 178);
   _actionMap[419][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[419][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[419][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[419][TRUEVAL] = ActionEntry(SHIFT, 175);
}
void Cego::loadParser140()
{
   _actionMap[419][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[419][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[419][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[419][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[419][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[419][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[419][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[419][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[419][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[419][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[419][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[419][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[419][ObjSpec] = 122;
   _jumpMap[419][Constant] = 121;
   _jumpMap[419][SignedFloat] = 120;
   _jumpMap[419][SignedInt] = 119;
   _jumpMap[419][Attribute] = 118;
   _jumpMap[419][Function] = 117;
   _jumpMap[419][Factor] = 116;
   _jumpMap[419][Term] = 115;
   _jumpMap[419][Expr] = 575;
   _jumpMap[419][CasePrepare] = 113;
   _jumpMap[419][CaseClause] = 112;
   _actionMap[420][IDENTIFIER] = ActionEntry(SHIFT, 576);
   _actionMap[421][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[421][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[421][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[421][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[421][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[421][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[421][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[421][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[421][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[421][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[421][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[421][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[421][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[421][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[421][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[421][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[421][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[421][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[421][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[421][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[421][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[421][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[421][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[421][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[421][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[421][RANDSTR] = ActionEntry(SHIFT, 160);
}
void Cego::loadParser141()
{
   _actionMap[421][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[421][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[421][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[421][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[421][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[421][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[421][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[421][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[421][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[421][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[421][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[421][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[421][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[421][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[421][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[421][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[421][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[421][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[421][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[421][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[421][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[421][LB] = ActionEntry(SHIFT, 178);
   _actionMap[421][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[421][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[421][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[421][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[421][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[421][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[421][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[421][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[421][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[421][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[421][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[421][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[421][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[421][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[421][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[421][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[421][EXISTS] = ActionEntry(SHIFT, 277);
   _actionMap[421][NOT] = ActionEntry(SHIFT, 278);
   _jumpMap[421][ObjSpec] = 122;
   _jumpMap[421][Constant] = 121;
   _jumpMap[421][SignedFloat] = 120;
   _jumpMap[421][SignedInt] = 119;
   _jumpMap[421][Attribute] = 118;
   _jumpMap[421][Function] = 117;
   _jumpMap[421][Factor] = 116;
   _jumpMap[421][Term] = 115;
   _jumpMap[421][Expr] = 276;
   _jumpMap[421][Predicate] = 275;
}
void Cego::loadParser142()
{
   _jumpMap[421][Conjunction] = 274;
   _jumpMap[421][Condition] = 578;
   _jumpMap[421][ProcWhileCondition] = 577;
   _jumpMap[421][CasePrepare] = 113;
   _jumpMap[421][CaseClause] = 112;
   _actionMap[422][CONCAT] = ActionEntry(REDUCE, 322);
   _actionMap[422][STAR] = ActionEntry(REDUCE, 322);
   _actionMap[422][DIVISION] = ActionEntry(REDUCE, 322);
   _actionMap[422][MINUS] = ActionEntry(REDUCE, 322);
   _actionMap[422][PLUS] = ActionEntry(REDUCE, 322);
   _actionMap[422][SEMICOLON] = ActionEntry(REDUCE, 322);
   _actionMap[422][EQU] = ActionEntry(SHIFT, 579);
   _actionMap[423][ON] = ActionEntry(SHIFT, 580);
   _actionMap[424][END_TOKEN] = ActionEntry(SHIFT, 581);
   _actionMap[425][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[425][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[425][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[425][ObjSpec] = 582;
   _actionMap[426][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[426][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[426][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[426][ObjSpec] = 583;
   _actionMap[427][IDENTIFIER] = ActionEntry(SHIFT, 588);
   _actionMap[427][RB] = ActionEntry(REDUCE, 246);
   _jumpMap[427][ProcArg] = 586;
   _jumpMap[427][ProcArgList] = 585;
   _jumpMap[427][ProcArgOpt] = 584;
   _actionMap[428][IDENTIFIER] = ActionEntry(SHIFT, 593);
   _actionMap[428][PRIMARY] = ActionEntry(SHIFT, 592);
   _jumpMap[428][ColumnDesc] = 591;
   _jumpMap[428][KeyColumn] = 590;
   _jumpMap[428][ColumnList] = 589;
   _actionMap[429][INSERT] = ActionEntry(SHIFT, 597);
   _actionMap[429][UPDATE] = ActionEntry(SHIFT, 598);
   _actionMap[429][DELETETOK] = ActionEntry(SHIFT, 596);
   _jumpMap[429][TriggerOp] = 595;
   _jumpMap[429][TriggerCondition] = 594;
   _actionMap[430][INSERT] = ActionEntry(REDUCE, 103);
   _actionMap[430][UPDATE] = ActionEntry(REDUCE, 103);
   _actionMap[430][DELETETOK] = ActionEntry(REDUCE, 103);
   _actionMap[431][INSERT] = ActionEntry(REDUCE, 102);
   _actionMap[431][UPDATE] = ActionEntry(REDUCE, 102);
   _actionMap[431][DELETETOK] = ActionEntry(REDUCE, 102);
   _actionMap[432][SELECT] = ActionEntry(SHIFT, 34);
   _jumpMap[432][SelectStatement] = 599;
   _actionMap[433][SEMICOLON] = ActionEntry(REDUCE, 224);
   _actionMap[433][WHERE] = ActionEntry(SHIFT, 436);
   _jumpMap[433][NoWhere] = 435;
   _jumpMap[433][WhereClause] = 434;
   _actionMap[434][SEMICOLON] = ActionEntry(REDUCE, 165);
}
void Cego::loadParser143()
{
   _actionMap[435][RETURNTOKEN] = ActionEntry(REDUCE, 223);
   _actionMap[435][GROUP] = ActionEntry(REDUCE, 223);
   _actionMap[435][ORDER] = ActionEntry(REDUCE, 223);
   _actionMap[435][ROWLIMIT] = ActionEntry(REDUCE, 223);
   _actionMap[435][UNION] = ActionEntry(REDUCE, 223);
   _actionMap[435][ENDTOKEN] = ActionEntry(REDUCE, 223);
   _actionMap[435][RB] = ActionEntry(REDUCE, 223);
   _actionMap[435][SEMICOLON] = ActionEntry(REDUCE, 223);
   _actionMap[436][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[436][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[436][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[436][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[436][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[436][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[436][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[436][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[436][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[436][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[436][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[436][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[436][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[436][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[436][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[436][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[436][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[436][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[436][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[436][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[436][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[436][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[436][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[436][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[436][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[436][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[436][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[436][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[436][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[436][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[436][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[436][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[436][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[436][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[436][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[436][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[436][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[436][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[436][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[436][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[436][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[436][NEXTCOUNT] = ActionEntry(SHIFT, 157);
}
void Cego::loadParser144()
{
   _actionMap[436][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[436][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[436][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[436][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[436][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[436][LB] = ActionEntry(SHIFT, 178);
   _actionMap[436][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[436][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[436][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[436][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[436][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[436][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[436][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[436][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[436][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[436][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[436][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[436][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[436][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[436][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[436][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[436][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[436][EXISTS] = ActionEntry(SHIFT, 277);
   _actionMap[436][NOT] = ActionEntry(SHIFT, 278);
   _jumpMap[436][ObjSpec] = 122;
   _jumpMap[436][Constant] = 121;
   _jumpMap[436][SignedFloat] = 120;
   _jumpMap[436][SignedInt] = 119;
   _jumpMap[436][Attribute] = 118;
   _jumpMap[436][Function] = 117;
   _jumpMap[436][Factor] = 116;
   _jumpMap[436][Term] = 115;
   _jumpMap[436][Expr] = 276;
   _jumpMap[436][Predicate] = 275;
   _jumpMap[436][Conjunction] = 274;
   _jumpMap[436][Condition] = 600;
   _jumpMap[436][CasePrepare] = 113;
   _jumpMap[436][CaseClause] = 112;
   _actionMap[437][SEMICOLON] = ActionEntry(REDUCE, 27);
   _actionMap[438][SELECT] = ActionEntry(SHIFT, 34);
   _actionMap[438][VALUES] = ActionEntry(SHIFT, 441);
   _jumpMap[438][SelectStatement] = 440;
   _jumpMap[438][InsertPrepare] = 439;
   _actionMap[439][LB] = ActionEntry(SHIFT, 603);
   _jumpMap[439][InsertValueSpec] = 602;
   _jumpMap[439][InsertValueSpecList] = 601;
   _actionMap[440][SEMICOLON] = ActionEntry(REDUCE, 143);
   _actionMap[441][LB] = ActionEntry(REDUCE, 146);
   _actionMap[442][IDENTIFIER] = ActionEntry(SHIFT, 605);
   _jumpMap[442][InsertArgList] = 604;
}
void Cego::loadParser145()
{
   _actionMap[443][SEMICOLON] = ActionEntry(REDUCE, 15);
   _actionMap[444][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[444][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[444][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[444][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[444][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[444][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[444][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[444][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[444][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[444][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[444][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[444][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[444][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[444][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[444][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[444][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[444][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[444][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[444][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[444][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[444][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[444][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[444][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[444][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[444][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[444][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[444][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[444][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[444][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[444][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[444][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[444][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[444][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[444][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[444][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[444][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[444][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[444][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[444][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[444][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[444][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[444][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[444][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[444][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[444][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[444][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[444][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[444][LB] = ActionEntry(SHIFT, 178);
   _actionMap[444][STRINGVAL] = ActionEntry(SHIFT, 123);
}
void Cego::loadParser146()
{
   _actionMap[444][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[444][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[444][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[444][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[444][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[444][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[444][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[444][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[444][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[444][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[444][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[444][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[444][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[444][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[444][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[444][EXISTS] = ActionEntry(SHIFT, 277);
   _actionMap[444][NOT] = ActionEntry(SHIFT, 278);
   _jumpMap[444][ObjSpec] = 122;
   _jumpMap[444][Constant] = 121;
   _jumpMap[444][SignedFloat] = 120;
   _jumpMap[444][SignedInt] = 119;
   _jumpMap[444][Attribute] = 118;
   _jumpMap[444][Function] = 117;
   _jumpMap[444][Factor] = 116;
   _jumpMap[444][Term] = 115;
   _jumpMap[444][Expr] = 276;
   _jumpMap[444][Predicate] = 275;
   _jumpMap[444][Conjunction] = 606;
   _jumpMap[444][CasePrepare] = 113;
   _jumpMap[444][CaseClause] = 112;
   _actionMap[445][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[445][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[445][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[445][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[445][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[445][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[445][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[445][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[445][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[445][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[445][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[445][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[445][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[445][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[445][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[445][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[445][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[445][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[445][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[445][SUBSTR] = ActionEntry(SHIFT, 169);
}
void Cego::loadParser147()
{
   _actionMap[445][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[445][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[445][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[445][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[445][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[445][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[445][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[445][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[445][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[445][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[445][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[445][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[445][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[445][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[445][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[445][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[445][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[445][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[445][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[445][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[445][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[445][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[445][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[445][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[445][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[445][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[445][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[445][LB] = ActionEntry(SHIFT, 178);
   _actionMap[445][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[445][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[445][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[445][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[445][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[445][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[445][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[445][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[445][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[445][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[445][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[445][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[445][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[445][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[445][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[445][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[445][EXISTS] = ActionEntry(SHIFT, 277);
   _actionMap[445][NOT] = ActionEntry(SHIFT, 278);
   _jumpMap[445][ObjSpec] = 122;
   _jumpMap[445][Constant] = 121;
   _jumpMap[445][SignedFloat] = 120;
   _jumpMap[445][SignedInt] = 119;
}
void Cego::loadParser148()
{
   _jumpMap[445][Attribute] = 118;
   _jumpMap[445][Function] = 117;
   _jumpMap[445][Factor] = 116;
   _jumpMap[445][Term] = 115;
   _jumpMap[445][Expr] = 276;
   _jumpMap[445][Predicate] = 607;
   _jumpMap[445][CasePrepare] = 113;
   _jumpMap[445][CaseClause] = 112;
   _actionMap[446][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[446][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[446][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[446][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[446][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[446][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[446][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[446][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[446][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[446][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[446][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[446][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[446][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[446][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[446][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[446][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[446][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[446][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[446][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[446][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[446][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[446][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[446][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[446][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[446][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[446][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[446][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[446][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[446][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[446][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[446][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[446][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[446][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[446][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[446][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[446][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[446][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[446][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[446][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[446][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[446][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[446][NEXTCOUNT] = ActionEntry(SHIFT, 157);
}
void Cego::loadParser149()
{
   _actionMap[446][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[446][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[446][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[446][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[446][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[446][LB] = ActionEntry(SHIFT, 178);
   _actionMap[446][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[446][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[446][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[446][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[446][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[446][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[446][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[446][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[446][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[446][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[446][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[446][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[446][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[446][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[446][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[446][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[446][ObjSpec] = 122;
   _jumpMap[446][Constant] = 121;
   _jumpMap[446][SignedFloat] = 120;
   _jumpMap[446][SignedInt] = 119;
   _jumpMap[446][Attribute] = 118;
   _jumpMap[446][Function] = 117;
   _jumpMap[446][Factor] = 116;
   _jumpMap[446][Term] = 115;
   _jumpMap[446][Expr] = 608;
   _jumpMap[446][CasePrepare] = 113;
   _jumpMap[446][CaseClause] = 112;
   _actionMap[447][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[447][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[447][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[447][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[447][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[447][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[447][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[447][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[447][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[447][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[447][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[447][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[447][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[447][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[447][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[447][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[447][LEFT] = ActionEntry(SHIFT, 148);
}
void Cego::loadParser150()
{
   _actionMap[447][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[447][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[447][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[447][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[447][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[447][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[447][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[447][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[447][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[447][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[447][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[447][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[447][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[447][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[447][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[447][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[447][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[447][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[447][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[447][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[447][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[447][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[447][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[447][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[447][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[447][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[447][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[447][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[447][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[447][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[447][LB] = ActionEntry(SHIFT, 178);
   _actionMap[447][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[447][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[447][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[447][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[447][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[447][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[447][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[447][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[447][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[447][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[447][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[447][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[447][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[447][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[447][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[447][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[447][ObjSpec] = 122;
   _jumpMap[447][Constant] = 121;
   _jumpMap[447][SignedFloat] = 120;
}
void Cego::loadParser151()
{
   _jumpMap[447][SignedInt] = 119;
   _jumpMap[447][Attribute] = 118;
   _jumpMap[447][Function] = 117;
   _jumpMap[447][Factor] = 116;
   _jumpMap[447][Term] = 115;
   _jumpMap[447][Expr] = 609;
   _jumpMap[447][CasePrepare] = 113;
   _jumpMap[447][CaseClause] = 112;
   _actionMap[448][LB] = ActionEntry(SHIFT, 610);
   _actionMap[449][NOT] = ActionEntry(SHIFT, 611);
   _actionMap[449][NULLTOKEN] = ActionEntry(SHIFT, 612);
   _actionMap[450][STRINGVAL] = ActionEntry(SHIFT, 613);
   _actionMap[451][STRINGVAL] = ActionEntry(SHIFT, 614);
   _actionMap[452][NCLIKE] = ActionEntry(SHIFT, 617);
   _actionMap[452][LIKE] = ActionEntry(SHIFT, 616);
   _actionMap[452][INTOK] = ActionEntry(SHIFT, 615);
   _actionMap[453][VARREF] = ActionEntry(REDUCE, 396);
   _actionMap[453][FETCH] = ActionEntry(REDUCE, 396);
   _actionMap[453][LB] = ActionEntry(REDUCE, 396);
   _actionMap[453][COUNT] = ActionEntry(REDUCE, 396);
   _actionMap[453][SUM] = ActionEntry(REDUCE, 396);
   _actionMap[453][AVG] = ActionEntry(REDUCE, 396);
   _actionMap[453][MIN] = ActionEntry(REDUCE, 396);
   _actionMap[453][MAX] = ActionEntry(REDUCE, 396);
   _actionMap[453][CASE] = ActionEntry(REDUCE, 396);
   _actionMap[453][INT2ASC] = ActionEntry(REDUCE, 396);
   _actionMap[453][ASC2INT] = ActionEntry(REDUCE, 396);
   _actionMap[453][TRIM] = ActionEntry(REDUCE, 396);
   _actionMap[453][RTRIM] = ActionEntry(REDUCE, 396);
   _actionMap[453][LTRIM] = ActionEntry(REDUCE, 396);
   _actionMap[453][ROUND] = ActionEntry(REDUCE, 396);
   _actionMap[453][SCANDATE] = ActionEntry(REDUCE, 396);
   _actionMap[453][DATE2STR] = ActionEntry(REDUCE, 396);
   _actionMap[453][DATE2LONG] = ActionEntry(REDUCE, 396);
   _actionMap[453][LONG2DATE] = ActionEntry(REDUCE, 396);
   _actionMap[453][NEWDATE] = ActionEntry(REDUCE, 396);
   _actionMap[453][LOWER] = ActionEntry(REDUCE, 396);
   _actionMap[453][UPPER] = ActionEntry(REDUCE, 396);
   _actionMap[453][LEFT] = ActionEntry(REDUCE, 396);
   _actionMap[453][RIGHT] = ActionEntry(REDUCE, 396);
   _actionMap[453][GETPOS] = ActionEntry(REDUCE, 396);
   _actionMap[453][SUBSTR] = ActionEntry(REDUCE, 396);
   _actionMap[453][REPLACE] = ActionEntry(REDUCE, 396);
   _actionMap[453][LENGTH] = ActionEntry(REDUCE, 396);
   _actionMap[453][TRUNC] = ActionEntry(REDUCE, 396);
   _actionMap[453][STR2INT] = ActionEntry(REDUCE, 396);
   _actionMap[453][STR2LONG] = ActionEntry(REDUCE, 396);
   _actionMap[453][RANDSTR] = ActionEntry(REDUCE, 396);
   _actionMap[453][RANDINT] = ActionEntry(REDUCE, 396);
   _actionMap[453][MOD] = ActionEntry(REDUCE, 396);
}
void Cego::loadParser152()
{
   _actionMap[453][DIV] = ActionEntry(REDUCE, 396);
   _actionMap[453][LMOD] = ActionEntry(REDUCE, 396);
   _actionMap[453][LDIV] = ActionEntry(REDUCE, 396);
   _actionMap[453][POWER] = ActionEntry(REDUCE, 396);
   _actionMap[453][BITAND] = ActionEntry(REDUCE, 396);
   _actionMap[453][BITOR] = ActionEntry(REDUCE, 396);
   _actionMap[453][BITXOR] = ActionEntry(REDUCE, 396);
   _actionMap[453][BLOBSIZE] = ActionEntry(REDUCE, 396);
   _actionMap[453][BLOBREF] = ActionEntry(REDUCE, 396);
   _actionMap[453][CLOBSIZE] = ActionEntry(REDUCE, 396);
   _actionMap[453][CLOBREF] = ActionEntry(REDUCE, 396);
   _actionMap[453][CLOB2STR] = ActionEntry(REDUCE, 396);
   _actionMap[453][REGMATCH] = ActionEntry(REDUCE, 396);
   _actionMap[453][NEXTCOUNT] = ActionEntry(REDUCE, 396);
   _actionMap[453][SETCOUNT] = ActionEntry(REDUCE, 396);
   _actionMap[453][GETCOUNT] = ActionEntry(REDUCE, 396);
   _actionMap[453][IDENTIFIER] = ActionEntry(REDUCE, 396);
   _actionMap[453][QUALIFIEDOBJ] = ActionEntry(REDUCE, 396);
   _actionMap[453][QUALIFIEDTS] = ActionEntry(REDUCE, 396);
   _actionMap[453][QUALIFIEDPRE] = ActionEntry(REDUCE, 396);
   _actionMap[453][STRINGVAL] = ActionEntry(REDUCE, 396);
   _actionMap[453][SYSDATE] = ActionEntry(REDUCE, 396);
   _actionMap[453][NULLTOKEN] = ActionEntry(REDUCE, 396);
   _actionMap[453][TRUEVAL] = ActionEntry(REDUCE, 396);
   _actionMap[453][FALSEVAL] = ActionEntry(REDUCE, 396);
   _actionMap[453][BLOB] = ActionEntry(REDUCE, 396);
   _actionMap[453][CLOB] = ActionEntry(REDUCE, 396);
   _actionMap[453][FLOATVAL] = ActionEntry(REDUCE, 396);
   _actionMap[453][MINUS] = ActionEntry(REDUCE, 396);
   _actionMap[453][INTVAL] = ActionEntry(REDUCE, 396);
   _actionMap[454][VARREF] = ActionEntry(REDUCE, 398);
   _actionMap[454][FETCH] = ActionEntry(REDUCE, 398);
   _actionMap[454][LB] = ActionEntry(REDUCE, 398);
   _actionMap[454][COUNT] = ActionEntry(REDUCE, 398);
   _actionMap[454][SUM] = ActionEntry(REDUCE, 398);
   _actionMap[454][AVG] = ActionEntry(REDUCE, 398);
   _actionMap[454][MIN] = ActionEntry(REDUCE, 398);
   _actionMap[454][MAX] = ActionEntry(REDUCE, 398);
   _actionMap[454][CASE] = ActionEntry(REDUCE, 398);
   _actionMap[454][INT2ASC] = ActionEntry(REDUCE, 398);
   _actionMap[454][ASC2INT] = ActionEntry(REDUCE, 398);
   _actionMap[454][TRIM] = ActionEntry(REDUCE, 398);
   _actionMap[454][RTRIM] = ActionEntry(REDUCE, 398);
   _actionMap[454][LTRIM] = ActionEntry(REDUCE, 398);
   _actionMap[454][ROUND] = ActionEntry(REDUCE, 398);
   _actionMap[454][SCANDATE] = ActionEntry(REDUCE, 398);
   _actionMap[454][DATE2STR] = ActionEntry(REDUCE, 398);
   _actionMap[454][DATE2LONG] = ActionEntry(REDUCE, 398);
   _actionMap[454][LONG2DATE] = ActionEntry(REDUCE, 398);
   _actionMap[454][NEWDATE] = ActionEntry(REDUCE, 398);
}
void Cego::loadParser153()
{
   _actionMap[454][LOWER] = ActionEntry(REDUCE, 398);
   _actionMap[454][UPPER] = ActionEntry(REDUCE, 398);
   _actionMap[454][LEFT] = ActionEntry(REDUCE, 398);
   _actionMap[454][RIGHT] = ActionEntry(REDUCE, 398);
   _actionMap[454][GETPOS] = ActionEntry(REDUCE, 398);
   _actionMap[454][SUBSTR] = ActionEntry(REDUCE, 398);
   _actionMap[454][REPLACE] = ActionEntry(REDUCE, 398);
   _actionMap[454][LENGTH] = ActionEntry(REDUCE, 398);
   _actionMap[454][TRUNC] = ActionEntry(REDUCE, 398);
   _actionMap[454][STR2INT] = ActionEntry(REDUCE, 398);
   _actionMap[454][STR2LONG] = ActionEntry(REDUCE, 398);
   _actionMap[454][RANDSTR] = ActionEntry(REDUCE, 398);
   _actionMap[454][RANDINT] = ActionEntry(REDUCE, 398);
   _actionMap[454][MOD] = ActionEntry(REDUCE, 398);
   _actionMap[454][DIV] = ActionEntry(REDUCE, 398);
   _actionMap[454][LMOD] = ActionEntry(REDUCE, 398);
   _actionMap[454][LDIV] = ActionEntry(REDUCE, 398);
   _actionMap[454][POWER] = ActionEntry(REDUCE, 398);
   _actionMap[454][BITAND] = ActionEntry(REDUCE, 398);
   _actionMap[454][BITOR] = ActionEntry(REDUCE, 398);
   _actionMap[454][BITXOR] = ActionEntry(REDUCE, 398);
   _actionMap[454][BLOBSIZE] = ActionEntry(REDUCE, 398);
   _actionMap[454][BLOBREF] = ActionEntry(REDUCE, 398);
   _actionMap[454][CLOBSIZE] = ActionEntry(REDUCE, 398);
   _actionMap[454][CLOBREF] = ActionEntry(REDUCE, 398);
   _actionMap[454][CLOB2STR] = ActionEntry(REDUCE, 398);
   _actionMap[454][REGMATCH] = ActionEntry(REDUCE, 398);
   _actionMap[454][NEXTCOUNT] = ActionEntry(REDUCE, 398);
   _actionMap[454][SETCOUNT] = ActionEntry(REDUCE, 398);
   _actionMap[454][GETCOUNT] = ActionEntry(REDUCE, 398);
   _actionMap[454][IDENTIFIER] = ActionEntry(REDUCE, 398);
   _actionMap[454][QUALIFIEDOBJ] = ActionEntry(REDUCE, 398);
   _actionMap[454][QUALIFIEDTS] = ActionEntry(REDUCE, 398);
   _actionMap[454][QUALIFIEDPRE] = ActionEntry(REDUCE, 398);
   _actionMap[454][STRINGVAL] = ActionEntry(REDUCE, 398);
   _actionMap[454][SYSDATE] = ActionEntry(REDUCE, 398);
   _actionMap[454][NULLTOKEN] = ActionEntry(REDUCE, 398);
   _actionMap[454][TRUEVAL] = ActionEntry(REDUCE, 398);
   _actionMap[454][FALSEVAL] = ActionEntry(REDUCE, 398);
   _actionMap[454][BLOB] = ActionEntry(REDUCE, 398);
   _actionMap[454][CLOB] = ActionEntry(REDUCE, 398);
   _actionMap[454][FLOATVAL] = ActionEntry(REDUCE, 398);
   _actionMap[454][MINUS] = ActionEntry(REDUCE, 398);
   _actionMap[454][INTVAL] = ActionEntry(REDUCE, 398);
   _actionMap[454][EQU] = ActionEntry(SHIFT, 618);
   _actionMap[455][VARREF] = ActionEntry(REDUCE, 399);
   _actionMap[455][FETCH] = ActionEntry(REDUCE, 399);
   _actionMap[455][LB] = ActionEntry(REDUCE, 399);
   _actionMap[455][COUNT] = ActionEntry(REDUCE, 399);
   _actionMap[455][SUM] = ActionEntry(REDUCE, 399);
}
void Cego::loadParser154()
{
   _actionMap[455][AVG] = ActionEntry(REDUCE, 399);
   _actionMap[455][MIN] = ActionEntry(REDUCE, 399);
   _actionMap[455][MAX] = ActionEntry(REDUCE, 399);
   _actionMap[455][CASE] = ActionEntry(REDUCE, 399);
   _actionMap[455][INT2ASC] = ActionEntry(REDUCE, 399);
   _actionMap[455][ASC2INT] = ActionEntry(REDUCE, 399);
   _actionMap[455][TRIM] = ActionEntry(REDUCE, 399);
   _actionMap[455][RTRIM] = ActionEntry(REDUCE, 399);
   _actionMap[455][LTRIM] = ActionEntry(REDUCE, 399);
   _actionMap[455][ROUND] = ActionEntry(REDUCE, 399);
   _actionMap[455][SCANDATE] = ActionEntry(REDUCE, 399);
   _actionMap[455][DATE2STR] = ActionEntry(REDUCE, 399);
   _actionMap[455][DATE2LONG] = ActionEntry(REDUCE, 399);
   _actionMap[455][LONG2DATE] = ActionEntry(REDUCE, 399);
   _actionMap[455][NEWDATE] = ActionEntry(REDUCE, 399);
   _actionMap[455][LOWER] = ActionEntry(REDUCE, 399);
   _actionMap[455][UPPER] = ActionEntry(REDUCE, 399);
   _actionMap[455][LEFT] = ActionEntry(REDUCE, 399);
   _actionMap[455][RIGHT] = ActionEntry(REDUCE, 399);
   _actionMap[455][GETPOS] = ActionEntry(REDUCE, 399);
   _actionMap[455][SUBSTR] = ActionEntry(REDUCE, 399);
   _actionMap[455][REPLACE] = ActionEntry(REDUCE, 399);
   _actionMap[455][LENGTH] = ActionEntry(REDUCE, 399);
   _actionMap[455][TRUNC] = ActionEntry(REDUCE, 399);
   _actionMap[455][STR2INT] = ActionEntry(REDUCE, 399);
   _actionMap[455][STR2LONG] = ActionEntry(REDUCE, 399);
   _actionMap[455][RANDSTR] = ActionEntry(REDUCE, 399);
   _actionMap[455][RANDINT] = ActionEntry(REDUCE, 399);
   _actionMap[455][MOD] = ActionEntry(REDUCE, 399);
   _actionMap[455][DIV] = ActionEntry(REDUCE, 399);
   _actionMap[455][LMOD] = ActionEntry(REDUCE, 399);
   _actionMap[455][LDIV] = ActionEntry(REDUCE, 399);
   _actionMap[455][POWER] = ActionEntry(REDUCE, 399);
   _actionMap[455][BITAND] = ActionEntry(REDUCE, 399);
   _actionMap[455][BITOR] = ActionEntry(REDUCE, 399);
   _actionMap[455][BITXOR] = ActionEntry(REDUCE, 399);
   _actionMap[455][BLOBSIZE] = ActionEntry(REDUCE, 399);
   _actionMap[455][BLOBREF] = ActionEntry(REDUCE, 399);
   _actionMap[455][CLOBSIZE] = ActionEntry(REDUCE, 399);
   _actionMap[455][CLOBREF] = ActionEntry(REDUCE, 399);
   _actionMap[455][CLOB2STR] = ActionEntry(REDUCE, 399);
   _actionMap[455][REGMATCH] = ActionEntry(REDUCE, 399);
   _actionMap[455][NEXTCOUNT] = ActionEntry(REDUCE, 399);
   _actionMap[455][SETCOUNT] = ActionEntry(REDUCE, 399);
   _actionMap[455][GETCOUNT] = ActionEntry(REDUCE, 399);
   _actionMap[455][IDENTIFIER] = ActionEntry(REDUCE, 399);
   _actionMap[455][QUALIFIEDOBJ] = ActionEntry(REDUCE, 399);
   _actionMap[455][QUALIFIEDTS] = ActionEntry(REDUCE, 399);
   _actionMap[455][QUALIFIEDPRE] = ActionEntry(REDUCE, 399);
   _actionMap[455][STRINGVAL] = ActionEntry(REDUCE, 399);
}
void Cego::loadParser155()
{
   _actionMap[455][SYSDATE] = ActionEntry(REDUCE, 399);
   _actionMap[455][NULLTOKEN] = ActionEntry(REDUCE, 399);
   _actionMap[455][TRUEVAL] = ActionEntry(REDUCE, 399);
   _actionMap[455][FALSEVAL] = ActionEntry(REDUCE, 399);
   _actionMap[455][BLOB] = ActionEntry(REDUCE, 399);
   _actionMap[455][CLOB] = ActionEntry(REDUCE, 399);
   _actionMap[455][FLOATVAL] = ActionEntry(REDUCE, 399);
   _actionMap[455][MINUS] = ActionEntry(REDUCE, 399);
   _actionMap[455][INTVAL] = ActionEntry(REDUCE, 399);
   _actionMap[455][EQU] = ActionEntry(SHIFT, 619);
   _actionMap[456][EQU] = ActionEntry(SHIFT, 620);
   _actionMap[457][SELECT] = ActionEntry(SHIFT, 34);
   _jumpMap[457][SelectStatement] = 621;
   _actionMap[458][LEFT] = ActionEntry(REDUCE, 314);
   _actionMap[458][RIGHT] = ActionEntry(REDUCE, 314);
   _actionMap[458][INNER] = ActionEntry(REDUCE, 314);
   _actionMap[458][JOIN] = ActionEntry(REDUCE, 314);
   _actionMap[458][ENDTOKEN] = ActionEntry(REDUCE, 314);
   _actionMap[458][UNION] = ActionEntry(REDUCE, 314);
   _actionMap[458][ROWLIMIT] = ActionEntry(REDUCE, 314);
   _actionMap[458][ORDER] = ActionEntry(REDUCE, 314);
   _actionMap[458][GROUP] = ActionEntry(REDUCE, 314);
   _actionMap[458][SEMICOLON] = ActionEntry(REDUCE, 314);
   _actionMap[458][RETURNTOKEN] = ActionEntry(REDUCE, 314);
   _actionMap[458][WHERE] = ActionEntry(REDUCE, 314);
   _actionMap[458][RB] = ActionEntry(REDUCE, 314);
   _actionMap[458][BEGIN] = ActionEntry(REDUCE, 314);
   _actionMap[458][THEN] = ActionEntry(REDUCE, 314);
   _actionMap[458][AND] = ActionEntry(REDUCE, 314);
   _actionMap[458][OR] = ActionEntry(REDUCE, 314);
   _actionMap[459][SELECT] = ActionEntry(SHIFT, 34);
   _jumpMap[459][SelectStatement] = 622;
   _actionMap[460][WHEN] = ActionEntry(REDUCE, 110);
   _actionMap[460][ELSE] = ActionEntry(REDUCE, 110);
   _actionMap[461][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[461][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[461][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[461][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[461][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[461][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[461][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[461][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[461][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[461][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[461][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[461][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[461][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[461][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[461][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[461][UPPER] = ActionEntry(SHIFT, 177);
}
void Cego::loadParser156()
{
   _actionMap[461][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[461][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[461][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[461][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[461][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[461][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[461][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[461][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[461][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[461][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[461][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[461][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[461][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[461][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[461][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[461][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[461][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[461][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[461][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[461][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[461][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[461][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[461][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[461][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[461][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[461][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[461][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[461][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[461][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[461][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[461][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[461][LB] = ActionEntry(SHIFT, 178);
   _actionMap[461][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[461][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[461][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[461][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[461][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[461][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[461][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[461][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[461][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[461][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[461][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[461][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[461][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[461][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[461][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[461][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[461][ObjSpec] = 122;
   _jumpMap[461][Constant] = 121;
}
void Cego::loadParser157()
{
   _jumpMap[461][SignedFloat] = 120;
   _jumpMap[461][SignedInt] = 119;
   _jumpMap[461][Attribute] = 118;
   _jumpMap[461][Function] = 117;
   _jumpMap[461][Factor] = 116;
   _jumpMap[461][Term] = 115;
   _jumpMap[461][Expr] = 623;
   _jumpMap[461][CasePrepare] = 113;
   _jumpMap[461][CaseClause] = 112;
   _actionMap[462][THEN] = ActionEntry(SHIFT, 624);
   _actionMap[462][OR] = ActionEntry(SHIFT, 444);
   _actionMap[463][STAR] = ActionEntry(SHIFT, 288);
   _actionMap[463][DIVISION] = ActionEntry(SHIFT, 289);
   _actionMap[463][WHEN] = ActionEntry(REDUCE, 318);
   _actionMap[463][ELSE] = ActionEntry(REDUCE, 318);
   _actionMap[463][LEFT] = ActionEntry(REDUCE, 318);
   _actionMap[463][RIGHT] = ActionEntry(REDUCE, 318);
   _actionMap[463][INNER] = ActionEntry(REDUCE, 318);
   _actionMap[463][JOIN] = ActionEntry(REDUCE, 318);
   _actionMap[463][ORDER] = ActionEntry(REDUCE, 318);
   _actionMap[463][GROUP] = ActionEntry(REDUCE, 318);
   _actionMap[463][RETURNTOKEN] = ActionEntry(REDUCE, 318);
   _actionMap[463][WHERE] = ActionEntry(REDUCE, 318);
   _actionMap[463][AS] = ActionEntry(REDUCE, 318);
   _actionMap[463][FROM] = ActionEntry(REDUCE, 318);
   _actionMap[463][BEGIN] = ActionEntry(REDUCE, 318);
   _actionMap[463][THEN] = ActionEntry(REDUCE, 318);
   _actionMap[463][OR] = ActionEntry(REDUCE, 318);
   _actionMap[463][NCLIKE] = ActionEntry(REDUCE, 318);
   _actionMap[463][LIKE] = ActionEntry(REDUCE, 318);
   _actionMap[463][IS] = ActionEntry(REDUCE, 318);
   _actionMap[463][BETWEEN] = ActionEntry(REDUCE, 318);
   _actionMap[463][EQU] = ActionEntry(REDUCE, 318);
   _actionMap[463][NEGATION] = ActionEntry(REDUCE, 318);
   _actionMap[463][LT] = ActionEntry(REDUCE, 318);
   _actionMap[463][MT] = ActionEntry(REDUCE, 318);
   _actionMap[463][NOT] = ActionEntry(REDUCE, 318);
   _actionMap[463][INTOK] = ActionEntry(REDUCE, 318);
   _actionMap[463][END_TOKEN] = ActionEntry(REDUCE, 318);
   _actionMap[463][AND] = ActionEntry(REDUCE, 318);
   _actionMap[463][CONCAT] = ActionEntry(REDUCE, 318);
   _actionMap[463][MINUS] = ActionEntry(REDUCE, 318);
   _actionMap[463][PLUS] = ActionEntry(REDUCE, 318);
   _actionMap[463][DESC] = ActionEntry(REDUCE, 318);
   _actionMap[463][ASC] = ActionEntry(REDUCE, 318);
   _actionMap[463][KSEP] = ActionEntry(REDUCE, 318);
   _actionMap[463][ROWLIMIT] = ActionEntry(REDUCE, 318);
   _actionMap[463][UNION] = ActionEntry(REDUCE, 318);
   _actionMap[463][ENDTOKEN] = ActionEntry(REDUCE, 318);
   _actionMap[463][RB] = ActionEntry(REDUCE, 318);
}
void Cego::loadParser158()
{
   _actionMap[463][SEMICOLON] = ActionEntry(REDUCE, 318);
   _actionMap[464][STAR] = ActionEntry(SHIFT, 288);
   _actionMap[464][DIVISION] = ActionEntry(SHIFT, 289);
   _actionMap[464][WHEN] = ActionEntry(REDUCE, 316);
   _actionMap[464][ELSE] = ActionEntry(REDUCE, 316);
   _actionMap[464][LEFT] = ActionEntry(REDUCE, 316);
   _actionMap[464][RIGHT] = ActionEntry(REDUCE, 316);
   _actionMap[464][INNER] = ActionEntry(REDUCE, 316);
   _actionMap[464][JOIN] = ActionEntry(REDUCE, 316);
   _actionMap[464][ORDER] = ActionEntry(REDUCE, 316);
   _actionMap[464][GROUP] = ActionEntry(REDUCE, 316);
   _actionMap[464][RETURNTOKEN] = ActionEntry(REDUCE, 316);
   _actionMap[464][WHERE] = ActionEntry(REDUCE, 316);
   _actionMap[464][AS] = ActionEntry(REDUCE, 316);
   _actionMap[464][FROM] = ActionEntry(REDUCE, 316);
   _actionMap[464][BEGIN] = ActionEntry(REDUCE, 316);
   _actionMap[464][THEN] = ActionEntry(REDUCE, 316);
   _actionMap[464][OR] = ActionEntry(REDUCE, 316);
   _actionMap[464][NCLIKE] = ActionEntry(REDUCE, 316);
   _actionMap[464][LIKE] = ActionEntry(REDUCE, 316);
   _actionMap[464][IS] = ActionEntry(REDUCE, 316);
   _actionMap[464][BETWEEN] = ActionEntry(REDUCE, 316);
   _actionMap[464][EQU] = ActionEntry(REDUCE, 316);
   _actionMap[464][NEGATION] = ActionEntry(REDUCE, 316);
   _actionMap[464][LT] = ActionEntry(REDUCE, 316);
   _actionMap[464][MT] = ActionEntry(REDUCE, 316);
   _actionMap[464][NOT] = ActionEntry(REDUCE, 316);
   _actionMap[464][INTOK] = ActionEntry(REDUCE, 316);
   _actionMap[464][END_TOKEN] = ActionEntry(REDUCE, 316);
   _actionMap[464][AND] = ActionEntry(REDUCE, 316);
   _actionMap[464][CONCAT] = ActionEntry(REDUCE, 316);
   _actionMap[464][MINUS] = ActionEntry(REDUCE, 316);
   _actionMap[464][PLUS] = ActionEntry(REDUCE, 316);
   _actionMap[464][DESC] = ActionEntry(REDUCE, 316);
   _actionMap[464][ASC] = ActionEntry(REDUCE, 316);
   _actionMap[464][KSEP] = ActionEntry(REDUCE, 316);
   _actionMap[464][ROWLIMIT] = ActionEntry(REDUCE, 316);
   _actionMap[464][UNION] = ActionEntry(REDUCE, 316);
   _actionMap[464][ENDTOKEN] = ActionEntry(REDUCE, 316);
   _actionMap[464][RB] = ActionEntry(REDUCE, 316);
   _actionMap[464][SEMICOLON] = ActionEntry(REDUCE, 316);
   _actionMap[465][STAR] = ActionEntry(SHIFT, 288);
   _actionMap[465][DIVISION] = ActionEntry(SHIFT, 289);
   _actionMap[465][WHEN] = ActionEntry(REDUCE, 315);
   _actionMap[465][ELSE] = ActionEntry(REDUCE, 315);
   _actionMap[465][LEFT] = ActionEntry(REDUCE, 315);
   _actionMap[465][RIGHT] = ActionEntry(REDUCE, 315);
   _actionMap[465][INNER] = ActionEntry(REDUCE, 315);
   _actionMap[465][JOIN] = ActionEntry(REDUCE, 315);
   _actionMap[465][ORDER] = ActionEntry(REDUCE, 315);
}
void Cego::loadParser159()
{
   _actionMap[465][GROUP] = ActionEntry(REDUCE, 315);
   _actionMap[465][RETURNTOKEN] = ActionEntry(REDUCE, 315);
   _actionMap[465][WHERE] = ActionEntry(REDUCE, 315);
   _actionMap[465][AS] = ActionEntry(REDUCE, 315);
   _actionMap[465][FROM] = ActionEntry(REDUCE, 315);
   _actionMap[465][BEGIN] = ActionEntry(REDUCE, 315);
   _actionMap[465][THEN] = ActionEntry(REDUCE, 315);
   _actionMap[465][OR] = ActionEntry(REDUCE, 315);
   _actionMap[465][NCLIKE] = ActionEntry(REDUCE, 315);
   _actionMap[465][LIKE] = ActionEntry(REDUCE, 315);
   _actionMap[465][IS] = ActionEntry(REDUCE, 315);
   _actionMap[465][BETWEEN] = ActionEntry(REDUCE, 315);
   _actionMap[465][EQU] = ActionEntry(REDUCE, 315);
   _actionMap[465][NEGATION] = ActionEntry(REDUCE, 315);
   _actionMap[465][LT] = ActionEntry(REDUCE, 315);
   _actionMap[465][MT] = ActionEntry(REDUCE, 315);
   _actionMap[465][NOT] = ActionEntry(REDUCE, 315);
   _actionMap[465][INTOK] = ActionEntry(REDUCE, 315);
   _actionMap[465][END_TOKEN] = ActionEntry(REDUCE, 315);
   _actionMap[465][AND] = ActionEntry(REDUCE, 315);
   _actionMap[465][CONCAT] = ActionEntry(REDUCE, 315);
   _actionMap[465][MINUS] = ActionEntry(REDUCE, 315);
   _actionMap[465][PLUS] = ActionEntry(REDUCE, 315);
   _actionMap[465][DESC] = ActionEntry(REDUCE, 315);
   _actionMap[465][ASC] = ActionEntry(REDUCE, 315);
   _actionMap[465][KSEP] = ActionEntry(REDUCE, 315);
   _actionMap[465][ROWLIMIT] = ActionEntry(REDUCE, 315);
   _actionMap[465][UNION] = ActionEntry(REDUCE, 315);
   _actionMap[465][ENDTOKEN] = ActionEntry(REDUCE, 315);
   _actionMap[465][RB] = ActionEntry(REDUCE, 315);
   _actionMap[465][SEMICOLON] = ActionEntry(REDUCE, 315);
   _actionMap[466][WHEN] = ActionEntry(REDUCE, 319);
   _actionMap[466][ELSE] = ActionEntry(REDUCE, 319);
   _actionMap[466][LEFT] = ActionEntry(REDUCE, 319);
   _actionMap[466][RIGHT] = ActionEntry(REDUCE, 319);
   _actionMap[466][INNER] = ActionEntry(REDUCE, 319);
   _actionMap[466][JOIN] = ActionEntry(REDUCE, 319);
   _actionMap[466][ORDER] = ActionEntry(REDUCE, 319);
   _actionMap[466][GROUP] = ActionEntry(REDUCE, 319);
   _actionMap[466][RETURNTOKEN] = ActionEntry(REDUCE, 319);
   _actionMap[466][WHERE] = ActionEntry(REDUCE, 319);
   _actionMap[466][FROM] = ActionEntry(REDUCE, 319);
   _actionMap[466][AS] = ActionEntry(REDUCE, 319);
   _actionMap[466][END_TOKEN] = ActionEntry(REDUCE, 319);
   _actionMap[466][BEGIN] = ActionEntry(REDUCE, 319);
   _actionMap[466][THEN] = ActionEntry(REDUCE, 319);
   _actionMap[466][AND] = ActionEntry(REDUCE, 319);
   _actionMap[466][OR] = ActionEntry(REDUCE, 319);
   _actionMap[466][INTOK] = ActionEntry(REDUCE, 319);
   _actionMap[466][NOT] = ActionEntry(REDUCE, 319);
}
void Cego::loadParser160()
{
   _actionMap[466][MT] = ActionEntry(REDUCE, 319);
   _actionMap[466][LT] = ActionEntry(REDUCE, 319);
   _actionMap[466][NEGATION] = ActionEntry(REDUCE, 319);
   _actionMap[466][EQU] = ActionEntry(REDUCE, 319);
   _actionMap[466][BETWEEN] = ActionEntry(REDUCE, 319);
   _actionMap[466][IS] = ActionEntry(REDUCE, 319);
   _actionMap[466][LIKE] = ActionEntry(REDUCE, 319);
   _actionMap[466][NCLIKE] = ActionEntry(REDUCE, 319);
   _actionMap[466][RB] = ActionEntry(REDUCE, 319);
   _actionMap[466][ENDTOKEN] = ActionEntry(REDUCE, 319);
   _actionMap[466][UNION] = ActionEntry(REDUCE, 319);
   _actionMap[466][ROWLIMIT] = ActionEntry(REDUCE, 319);
   _actionMap[466][KSEP] = ActionEntry(REDUCE, 319);
   _actionMap[466][ASC] = ActionEntry(REDUCE, 319);
   _actionMap[466][DESC] = ActionEntry(REDUCE, 319);
   _actionMap[466][PLUS] = ActionEntry(REDUCE, 319);
   _actionMap[466][MINUS] = ActionEntry(REDUCE, 319);
   _actionMap[466][CONCAT] = ActionEntry(REDUCE, 319);
   _actionMap[466][SEMICOLON] = ActionEntry(REDUCE, 319);
   _actionMap[466][DIVISION] = ActionEntry(REDUCE, 319);
   _actionMap[466][STAR] = ActionEntry(REDUCE, 319);
   _actionMap[467][WHEN] = ActionEntry(REDUCE, 320);
   _actionMap[467][ELSE] = ActionEntry(REDUCE, 320);
   _actionMap[467][LEFT] = ActionEntry(REDUCE, 320);
   _actionMap[467][RIGHT] = ActionEntry(REDUCE, 320);
   _actionMap[467][INNER] = ActionEntry(REDUCE, 320);
   _actionMap[467][JOIN] = ActionEntry(REDUCE, 320);
   _actionMap[467][ORDER] = ActionEntry(REDUCE, 320);
   _actionMap[467][GROUP] = ActionEntry(REDUCE, 320);
   _actionMap[467][RETURNTOKEN] = ActionEntry(REDUCE, 320);
   _actionMap[467][WHERE] = ActionEntry(REDUCE, 320);
   _actionMap[467][FROM] = ActionEntry(REDUCE, 320);
   _actionMap[467][AS] = ActionEntry(REDUCE, 320);
   _actionMap[467][END_TOKEN] = ActionEntry(REDUCE, 320);
   _actionMap[467][BEGIN] = ActionEntry(REDUCE, 320);
   _actionMap[467][THEN] = ActionEntry(REDUCE, 320);
   _actionMap[467][AND] = ActionEntry(REDUCE, 320);
   _actionMap[467][OR] = ActionEntry(REDUCE, 320);
   _actionMap[467][INTOK] = ActionEntry(REDUCE, 320);
   _actionMap[467][NOT] = ActionEntry(REDUCE, 320);
   _actionMap[467][MT] = ActionEntry(REDUCE, 320);
   _actionMap[467][LT] = ActionEntry(REDUCE, 320);
   _actionMap[467][NEGATION] = ActionEntry(REDUCE, 320);
   _actionMap[467][EQU] = ActionEntry(REDUCE, 320);
   _actionMap[467][BETWEEN] = ActionEntry(REDUCE, 320);
   _actionMap[467][IS] = ActionEntry(REDUCE, 320);
   _actionMap[467][LIKE] = ActionEntry(REDUCE, 320);
   _actionMap[467][NCLIKE] = ActionEntry(REDUCE, 320);
   _actionMap[467][RB] = ActionEntry(REDUCE, 320);
   _actionMap[467][ENDTOKEN] = ActionEntry(REDUCE, 320);
}
void Cego::loadParser161()
{
   _actionMap[467][UNION] = ActionEntry(REDUCE, 320);
   _actionMap[467][ROWLIMIT] = ActionEntry(REDUCE, 320);
   _actionMap[467][KSEP] = ActionEntry(REDUCE, 320);
   _actionMap[467][ASC] = ActionEntry(REDUCE, 320);
   _actionMap[467][DESC] = ActionEntry(REDUCE, 320);
   _actionMap[467][PLUS] = ActionEntry(REDUCE, 320);
   _actionMap[467][MINUS] = ActionEntry(REDUCE, 320);
   _actionMap[467][CONCAT] = ActionEntry(REDUCE, 320);
   _actionMap[467][SEMICOLON] = ActionEntry(REDUCE, 320);
   _actionMap[467][DIVISION] = ActionEntry(REDUCE, 320);
   _actionMap[467][STAR] = ActionEntry(REDUCE, 320);
   _actionMap[468][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[468][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[468][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[468][KSEP] = ActionEntry(REDUCE, 380);
   _actionMap[468][RB] = ActionEntry(REDUCE, 380);
   _actionMap[469][RB] = ActionEntry(SHIFT, 626);
   _actionMap[469][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[470][WHEN] = ActionEntry(REDUCE, 378);
   _actionMap[470][ELSE] = ActionEntry(REDUCE, 378);
   _actionMap[470][LEFT] = ActionEntry(REDUCE, 378);
   _actionMap[470][RIGHT] = ActionEntry(REDUCE, 378);
   _actionMap[470][INNER] = ActionEntry(REDUCE, 378);
   _actionMap[470][JOIN] = ActionEntry(REDUCE, 378);
   _actionMap[470][ORDER] = ActionEntry(REDUCE, 378);
   _actionMap[470][GROUP] = ActionEntry(REDUCE, 378);
   _actionMap[470][RETURNTOKEN] = ActionEntry(REDUCE, 378);
   _actionMap[470][WHERE] = ActionEntry(REDUCE, 378);
   _actionMap[470][FROM] = ActionEntry(REDUCE, 378);
   _actionMap[470][AS] = ActionEntry(REDUCE, 378);
   _actionMap[470][END_TOKEN] = ActionEntry(REDUCE, 378);
   _actionMap[470][BEGIN] = ActionEntry(REDUCE, 378);
   _actionMap[470][THEN] = ActionEntry(REDUCE, 378);
   _actionMap[470][AND] = ActionEntry(REDUCE, 378);
   _actionMap[470][OR] = ActionEntry(REDUCE, 378);
   _actionMap[470][INTOK] = ActionEntry(REDUCE, 378);
   _actionMap[470][NOT] = ActionEntry(REDUCE, 378);
   _actionMap[470][MT] = ActionEntry(REDUCE, 378);
   _actionMap[470][LT] = ActionEntry(REDUCE, 378);
   _actionMap[470][NEGATION] = ActionEntry(REDUCE, 378);
   _actionMap[470][EQU] = ActionEntry(REDUCE, 378);
   _actionMap[470][BETWEEN] = ActionEntry(REDUCE, 378);
   _actionMap[470][IS] = ActionEntry(REDUCE, 378);
   _actionMap[470][LIKE] = ActionEntry(REDUCE, 378);
   _actionMap[470][NCLIKE] = ActionEntry(REDUCE, 378);
   _actionMap[470][RB] = ActionEntry(REDUCE, 378);
   _actionMap[470][ENDTOKEN] = ActionEntry(REDUCE, 378);
   _actionMap[470][UNION] = ActionEntry(REDUCE, 378);
   _actionMap[470][ROWLIMIT] = ActionEntry(REDUCE, 378);
   _actionMap[470][KSEP] = ActionEntry(REDUCE, 378);
}
void Cego::loadParser162()
{
   _actionMap[470][ASC] = ActionEntry(REDUCE, 378);
   _actionMap[470][DESC] = ActionEntry(REDUCE, 378);
   _actionMap[470][PLUS] = ActionEntry(REDUCE, 378);
   _actionMap[470][MINUS] = ActionEntry(REDUCE, 378);
   _actionMap[470][DIVISION] = ActionEntry(REDUCE, 378);
   _actionMap[470][STAR] = ActionEntry(REDUCE, 378);
   _actionMap[470][CONCAT] = ActionEntry(REDUCE, 378);
   _actionMap[470][SEMICOLON] = ActionEntry(REDUCE, 378);
   _actionMap[471][RB] = ActionEntry(SHIFT, 627);
   _actionMap[471][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[472][RB] = ActionEntry(SHIFT, 628);
   _actionMap[472][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[472][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[472][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[473][RB] = ActionEntry(SHIFT, 629);
   _actionMap[473][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[474][RB] = ActionEntry(SHIFT, 630);
   _actionMap[474][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[475][RB] = ActionEntry(SHIFT, 631);
   _actionMap[475][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[476][RAB] = ActionEntry(SHIFT, 632);
   _actionMap[477][RB] = ActionEntry(SHIFT, 633);
   _actionMap[477][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[478][RB] = ActionEntry(SHIFT, 634);
   _actionMap[478][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[479][RAB] = ActionEntry(SHIFT, 635);
   _actionMap[480][RB] = ActionEntry(SHIFT, 636);
   _actionMap[480][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[481][RB] = ActionEntry(SHIFT, 637);
   _actionMap[481][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[482][RB] = ActionEntry(SHIFT, 638);
   _actionMap[482][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[483][RB] = ActionEntry(SHIFT, 639);
   _actionMap[483][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[483][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[483][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[484][RB] = ActionEntry(SHIFT, 640);
   _actionMap[485][RB] = ActionEntry(SHIFT, 641);
   _actionMap[485][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[486][RB] = ActionEntry(SHIFT, 642);
   _actionMap[486][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[487][RB] = ActionEntry(SHIFT, 643);
   _actionMap[487][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[488][LB] = ActionEntry(SHIFT, 644);
   _actionMap[489][RB] = ActionEntry(SHIFT, 645);
   _actionMap[490][RB] = ActionEntry(SHIFT, 646);
   _actionMap[490][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[491][RB] = ActionEntry(SHIFT, 647);
   _actionMap[491][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[492][RB] = ActionEntry(SHIFT, 648);
}
void Cego::loadParser163()
{
   _actionMap[492][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[493][RB] = ActionEntry(SHIFT, 649);
   _actionMap[493][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[494][RB] = ActionEntry(SHIFT, 650);
   _actionMap[494][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[495][RB] = ActionEntry(SHIFT, 651);
   _actionMap[495][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[496][RB] = ActionEntry(SHIFT, 652);
   _actionMap[496][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[497][RB] = ActionEntry(SHIFT, 653);
   _actionMap[497][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[498][RB] = ActionEntry(SHIFT, 654);
   _actionMap[498][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[499][RB] = ActionEntry(SHIFT, 655);
   _actionMap[499][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[500][RB] = ActionEntry(SHIFT, 656);
   _actionMap[500][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[500][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[500][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[501][RB] = ActionEntry(SHIFT, 657);
   _actionMap[501][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[501][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[501][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[502][RB] = ActionEntry(SHIFT, 658);
   _actionMap[502][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[503][RB] = ActionEntry(SHIFT, 659);
   _actionMap[504][RB] = ActionEntry(SHIFT, 660);
   _actionMap[504][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[505][RB] = ActionEntry(SHIFT, 661);
   _actionMap[505][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[506][RB] = ActionEntry(SHIFT, 662);
   _actionMap[506][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[507][RB] = ActionEntry(SHIFT, 663);
   _actionMap[507][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[508][RB] = ActionEntry(SHIFT, 664);
   _actionMap[508][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[509][RB] = ActionEntry(SHIFT, 665);
   _actionMap[509][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[510][RB] = ActionEntry(SHIFT, 666);
   _actionMap[510][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[511][RB] = ActionEntry(SHIFT, 667);
   _actionMap[511][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[512][RB] = ActionEntry(SHIFT, 668);
   _actionMap[512][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[513][KSEP] = ActionEntry(SHIFT, 669);
   _actionMap[514][RB] = ActionEntry(SHIFT, 670);
   _actionMap[514][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[515][RB] = ActionEntry(SHIFT, 671);
   _actionMap[515][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[515][MINUS] = ActionEntry(SHIFT, 286);
}
void Cego::loadParser164()
{
   _actionMap[515][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[516][RB] = ActionEntry(SHIFT, 672);
   _actionMap[516][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[517][RB] = ActionEntry(SHIFT, 673);
   _actionMap[517][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[518][RB] = ActionEntry(SHIFT, 674);
   _actionMap[518][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[519][RB] = ActionEntry(SHIFT, 675);
   _actionMap[519][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[520][RB] = ActionEntry(SHIFT, 676);
   _actionMap[520][KSEP] = ActionEntry(SHIFT, 625);
   _actionMap[521][WHEN] = ActionEntry(REDUCE, 328);
   _actionMap[521][ELSE] = ActionEntry(REDUCE, 328);
   _actionMap[521][AS] = ActionEntry(REDUCE, 328);
   _actionMap[521][FROM] = ActionEntry(REDUCE, 328);
   _actionMap[521][END_TOKEN] = ActionEntry(REDUCE, 328);
   _actionMap[521][BEGIN] = ActionEntry(REDUCE, 328);
   _actionMap[521][THEN] = ActionEntry(REDUCE, 328);
   _actionMap[521][LEFT] = ActionEntry(REDUCE, 328);
   _actionMap[521][RIGHT] = ActionEntry(REDUCE, 328);
   _actionMap[521][INNER] = ActionEntry(REDUCE, 328);
   _actionMap[521][JOIN] = ActionEntry(REDUCE, 328);
   _actionMap[521][ORDER] = ActionEntry(REDUCE, 328);
   _actionMap[521][GROUP] = ActionEntry(REDUCE, 328);
   _actionMap[521][RETURNTOKEN] = ActionEntry(REDUCE, 328);
   _actionMap[521][WHERE] = ActionEntry(REDUCE, 328);
   _actionMap[521][OR] = ActionEntry(REDUCE, 328);
   _actionMap[521][AND] = ActionEntry(REDUCE, 328);
   _actionMap[521][NCLIKE] = ActionEntry(REDUCE, 328);
   _actionMap[521][LIKE] = ActionEntry(REDUCE, 328);
   _actionMap[521][IS] = ActionEntry(REDUCE, 328);
   _actionMap[521][BETWEEN] = ActionEntry(REDUCE, 328);
   _actionMap[521][EQU] = ActionEntry(REDUCE, 328);
   _actionMap[521][NEGATION] = ActionEntry(REDUCE, 328);
   _actionMap[521][LT] = ActionEntry(REDUCE, 328);
   _actionMap[521][MT] = ActionEntry(REDUCE, 328);
   _actionMap[521][NOT] = ActionEntry(REDUCE, 328);
   _actionMap[521][INTOK] = ActionEntry(REDUCE, 328);
   _actionMap[521][DESC] = ActionEntry(REDUCE, 328);
   _actionMap[521][ASC] = ActionEntry(REDUCE, 328);
   _actionMap[521][KSEP] = ActionEntry(REDUCE, 328);
   _actionMap[521][ROWLIMIT] = ActionEntry(REDUCE, 328);
   _actionMap[521][UNION] = ActionEntry(REDUCE, 328);
   _actionMap[521][ENDTOKEN] = ActionEntry(REDUCE, 328);
   _actionMap[521][RB] = ActionEntry(REDUCE, 328);
   _actionMap[521][CONCAT] = ActionEntry(REDUCE, 328);
   _actionMap[521][STAR] = ActionEntry(REDUCE, 328);
   _actionMap[521][DIVISION] = ActionEntry(REDUCE, 328);
   _actionMap[521][MINUS] = ActionEntry(REDUCE, 328);
   _actionMap[521][PLUS] = ActionEntry(REDUCE, 328);
}
void Cego::loadParser165()
{
   _actionMap[521][SEMICOLON] = ActionEntry(REDUCE, 328);
   _actionMap[522][WHEN] = ActionEntry(REDUCE, 327);
   _actionMap[522][ELSE] = ActionEntry(REDUCE, 327);
   _actionMap[522][AS] = ActionEntry(REDUCE, 327);
   _actionMap[522][FROM] = ActionEntry(REDUCE, 327);
   _actionMap[522][END_TOKEN] = ActionEntry(REDUCE, 327);
   _actionMap[522][BEGIN] = ActionEntry(REDUCE, 327);
   _actionMap[522][THEN] = ActionEntry(REDUCE, 327);
   _actionMap[522][LEFT] = ActionEntry(REDUCE, 327);
   _actionMap[522][RIGHT] = ActionEntry(REDUCE, 327);
   _actionMap[522][INNER] = ActionEntry(REDUCE, 327);
   _actionMap[522][JOIN] = ActionEntry(REDUCE, 327);
   _actionMap[522][ORDER] = ActionEntry(REDUCE, 327);
   _actionMap[522][GROUP] = ActionEntry(REDUCE, 327);
   _actionMap[522][RETURNTOKEN] = ActionEntry(REDUCE, 327);
   _actionMap[522][WHERE] = ActionEntry(REDUCE, 327);
   _actionMap[522][OR] = ActionEntry(REDUCE, 327);
   _actionMap[522][AND] = ActionEntry(REDUCE, 327);
   _actionMap[522][NCLIKE] = ActionEntry(REDUCE, 327);
   _actionMap[522][LIKE] = ActionEntry(REDUCE, 327);
   _actionMap[522][IS] = ActionEntry(REDUCE, 327);
   _actionMap[522][BETWEEN] = ActionEntry(REDUCE, 327);
   _actionMap[522][EQU] = ActionEntry(REDUCE, 327);
   _actionMap[522][NEGATION] = ActionEntry(REDUCE, 327);
   _actionMap[522][LT] = ActionEntry(REDUCE, 327);
   _actionMap[522][MT] = ActionEntry(REDUCE, 327);
   _actionMap[522][NOT] = ActionEntry(REDUCE, 327);
   _actionMap[522][INTOK] = ActionEntry(REDUCE, 327);
   _actionMap[522][DESC] = ActionEntry(REDUCE, 327);
   _actionMap[522][ASC] = ActionEntry(REDUCE, 327);
   _actionMap[522][KSEP] = ActionEntry(REDUCE, 327);
   _actionMap[522][ROWLIMIT] = ActionEntry(REDUCE, 327);
   _actionMap[522][UNION] = ActionEntry(REDUCE, 327);
   _actionMap[522][ENDTOKEN] = ActionEntry(REDUCE, 327);
   _actionMap[522][RB] = ActionEntry(REDUCE, 327);
   _actionMap[522][CONCAT] = ActionEntry(REDUCE, 327);
   _actionMap[522][STAR] = ActionEntry(REDUCE, 327);
   _actionMap[522][DIVISION] = ActionEntry(REDUCE, 327);
   _actionMap[522][MINUS] = ActionEntry(REDUCE, 327);
   _actionMap[522][PLUS] = ActionEntry(REDUCE, 327);
   _actionMap[522][SEMICOLON] = ActionEntry(REDUCE, 327);
   _actionMap[523][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[523][MINUS] = ActionEntry(SHIFT, 678);
   _jumpMap[523][SignedInt] = 677;
   _actionMap[524][STRINGVAL] = ActionEntry(SHIFT, 679);
   _actionMap[525][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[525][MINUS] = ActionEntry(SHIFT, 681);
   _jumpMap[525][SignedFloat] = 680;
   _actionMap[526][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[526][MINUS] = ActionEntry(SHIFT, 681);
}
void Cego::loadParser166()
{
   _jumpMap[526][SignedFloat] = 682;
   _actionMap[527][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[527][MINUS] = ActionEntry(SHIFT, 678);
   _jumpMap[527][SignedInt] = 683;
   _actionMap[528][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[528][MINUS] = ActionEntry(SHIFT, 678);
   _jumpMap[528][SignedInt] = 684;
   _actionMap[529][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[529][MINUS] = ActionEntry(SHIFT, 678);
   _jumpMap[529][SignedInt] = 685;
   _actionMap[530][IDENTIFIER] = ActionEntry(SHIFT, 686);
   _actionMap[531][IDENTIFIER] = ActionEntry(SHIFT, 687);
   _actionMap[532][IDENTIFIER] = ActionEntry(SHIFT, 688);
   _actionMap[533][IDENTIFIER] = ActionEntry(SHIFT, 689);
   _actionMap[534][IDENTIFIER] = ActionEntry(SHIFT, 690);
   _actionMap[535][IDENTIFIER] = ActionEntry(SHIFT, 691);
   _actionMap[536][IDENTIFIER] = ActionEntry(SHIFT, 692);
   _actionMap[537][IDENTIFIER] = ActionEntry(SHIFT, 693);
   _actionMap[538][SEMICOLON] = ActionEntry(REDUCE, 224);
   _actionMap[538][RB] = ActionEntry(REDUCE, 224);
   _actionMap[538][ENDTOKEN] = ActionEntry(REDUCE, 224);
   _actionMap[538][UNION] = ActionEntry(REDUCE, 224);
   _actionMap[538][ROWLIMIT] = ActionEntry(REDUCE, 224);
   _actionMap[538][ORDER] = ActionEntry(REDUCE, 224);
   _actionMap[538][GROUP] = ActionEntry(REDUCE, 224);
   _actionMap[538][WHERE] = ActionEntry(SHIFT, 436);
   _jumpMap[538][NoWhere] = 435;
   _jumpMap[538][WhereClause] = 694;
   _actionMap[539][WHERE] = ActionEntry(REDUCE, 178);
   _actionMap[539][RETURNTOKEN] = ActionEntry(REDUCE, 178);
   _actionMap[539][SEMICOLON] = ActionEntry(REDUCE, 178);
   _actionMap[539][GROUP] = ActionEntry(REDUCE, 178);
   _actionMap[539][ORDER] = ActionEntry(REDUCE, 178);
   _actionMap[539][ROWLIMIT] = ActionEntry(REDUCE, 178);
   _actionMap[539][UNION] = ActionEntry(REDUCE, 178);
   _actionMap[539][ENDTOKEN] = ActionEntry(REDUCE, 178);
   _actionMap[539][RB] = ActionEntry(REDUCE, 178);
   _actionMap[539][INNER] = ActionEntry(SHIFT, 697);
   _actionMap[539][JOIN] = ActionEntry(SHIFT, 698);
   _actionMap[539][LEFT] = ActionEntry(SHIFT, 699);
   _actionMap[539][RIGHT] = ActionEntry(SHIFT, 700);
   _jumpMap[539][InnerJoin] = 696;
   _jumpMap[539][JoinSpec] = 695;
   _actionMap[540][WHERE] = ActionEntry(REDUCE, 177);
   _actionMap[540][RETURNTOKEN] = ActionEntry(REDUCE, 177);
   _actionMap[540][SEMICOLON] = ActionEntry(REDUCE, 177);
   _actionMap[540][GROUP] = ActionEntry(REDUCE, 177);
   _actionMap[540][ORDER] = ActionEntry(REDUCE, 177);
   _actionMap[540][ROWLIMIT] = ActionEntry(REDUCE, 177);
   _actionMap[540][UNION] = ActionEntry(REDUCE, 177);
}
void Cego::loadParser167()
{
   _actionMap[540][ENDTOKEN] = ActionEntry(REDUCE, 177);
   _actionMap[540][RB] = ActionEntry(REDUCE, 177);
   _actionMap[541][KSEP] = ActionEntry(SHIFT, 702);
   _actionMap[541][RB] = ActionEntry(REDUCE, 190);
   _actionMap[541][ENDTOKEN] = ActionEntry(REDUCE, 190);
   _actionMap[541][UNION] = ActionEntry(REDUCE, 190);
   _actionMap[541][ROWLIMIT] = ActionEntry(REDUCE, 190);
   _actionMap[541][ORDER] = ActionEntry(REDUCE, 190);
   _actionMap[541][GROUP] = ActionEntry(REDUCE, 190);
   _actionMap[541][SEMICOLON] = ActionEntry(REDUCE, 190);
   _actionMap[541][RETURNTOKEN] = ActionEntry(REDUCE, 190);
   _actionMap[541][WHERE] = ActionEntry(REDUCE, 190);
   _actionMap[541][INNER] = ActionEntry(SHIFT, 697);
   _actionMap[541][JOIN] = ActionEntry(SHIFT, 698);
   _actionMap[541][LEFT] = ActionEntry(SHIFT, 699);
   _actionMap[541][RIGHT] = ActionEntry(SHIFT, 700);
   _jumpMap[541][InnerJoin] = 696;
   _jumpMap[541][JoinSpec] = 701;
   _actionMap[542][KSEP] = ActionEntry(REDUCE, 191);
   _actionMap[542][IDENTIFIER] = ActionEntry(SHIFT, 703);
   _actionMap[542][LEFT] = ActionEntry(REDUCE, 191);
   _actionMap[542][RIGHT] = ActionEntry(REDUCE, 191);
   _actionMap[542][INNER] = ActionEntry(REDUCE, 191);
   _actionMap[542][JOIN] = ActionEntry(REDUCE, 191);
   _actionMap[542][RB] = ActionEntry(REDUCE, 191);
   _actionMap[542][ENDTOKEN] = ActionEntry(REDUCE, 191);
   _actionMap[542][UNION] = ActionEntry(REDUCE, 191);
   _actionMap[542][ROWLIMIT] = ActionEntry(REDUCE, 191);
   _actionMap[542][ORDER] = ActionEntry(REDUCE, 191);
   _actionMap[542][GROUP] = ActionEntry(REDUCE, 191);
   _actionMap[542][SEMICOLON] = ActionEntry(REDUCE, 191);
   _actionMap[542][RETURNTOKEN] = ActionEntry(REDUCE, 191);
   _actionMap[542][WHERE] = ActionEntry(REDUCE, 191);
   _actionMap[542][ON] = ActionEntry(REDUCE, 191);
   _actionMap[543][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[543][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[543][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[543][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[543][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[543][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[543][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[543][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[543][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[543][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[543][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[543][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[543][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[543][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[543][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[543][UPPER] = ActionEntry(SHIFT, 177);
}
void Cego::loadParser168()
{
   _actionMap[543][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[543][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[543][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[543][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[543][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[543][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[543][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[543][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[543][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[543][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[543][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[543][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[543][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[543][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[543][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[543][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[543][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[543][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[543][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[543][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[543][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[543][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[543][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[543][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[543][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[543][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[543][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[543][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[543][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[543][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[543][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[543][LB] = ActionEntry(SHIFT, 178);
   _actionMap[543][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[543][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[543][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[543][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[543][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[543][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[543][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[543][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[543][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[543][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[543][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[543][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[543][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[543][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[543][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[543][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[543][ObjSpec] = 122;
   _jumpMap[543][Constant] = 121;
}
void Cego::loadParser169()
{
   _jumpMap[543][SignedFloat] = 120;
   _jumpMap[543][SignedInt] = 119;
   _jumpMap[543][Attribute] = 118;
   _jumpMap[543][Function] = 117;
   _jumpMap[543][Factor] = 116;
   _jumpMap[543][Term] = 115;
   _jumpMap[543][Expr] = 367;
   _jumpMap[543][SelectItem] = 704;
   _jumpMap[543][CasePrepare] = 113;
   _jumpMap[543][CaseClause] = 112;
   _actionMap[544][KSEP] = ActionEntry(REDUCE, 176);
   _actionMap[544][FROM] = ActionEntry(REDUCE, 176);
   _actionMap[544][RB] = ActionEntry(REDUCE, 176);
   _actionMap[544][SEMICOLON] = ActionEntry(REDUCE, 176);
   _actionMap[544][ENDTOKEN] = ActionEntry(REDUCE, 176);
   _actionMap[545][KSEP] = ActionEntry(REDUCE, 195);
   _actionMap[545][FROM] = ActionEntry(REDUCE, 195);
   _actionMap[545][RB] = ActionEntry(REDUCE, 195);
   _actionMap[545][SEMICOLON] = ActionEntry(REDUCE, 195);
   _actionMap[545][ENDTOKEN] = ActionEntry(REDUCE, 195);
   _actionMap[546][IDENTIFIER] = ActionEntry(SHIFT, 705);
   _actionMap[547][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[547][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[547][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[547][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[547][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[547][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[547][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[547][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[547][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[547][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[547][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[547][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[547][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[547][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[547][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[547][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[547][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[547][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[547][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[547][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[547][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[547][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[547][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[547][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[547][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[547][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[547][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[547][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[547][DIV] = ActionEntry(SHIFT, 140);
}
void Cego::loadParser170()
{
   _actionMap[547][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[547][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[547][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[547][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[547][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[547][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[547][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[547][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[547][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[547][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[547][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[547][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[547][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[547][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[547][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[547][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[547][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[547][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[547][LB] = ActionEntry(SHIFT, 178);
   _actionMap[547][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[547][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[547][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[547][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[547][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[547][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[547][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[547][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[547][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[547][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[547][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[547][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[547][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[547][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[547][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[547][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[547][ObjSpec] = 122;
   _jumpMap[547][Constant] = 121;
   _jumpMap[547][SignedFloat] = 120;
   _jumpMap[547][SignedInt] = 119;
   _jumpMap[547][Attribute] = 118;
   _jumpMap[547][Function] = 117;
   _jumpMap[547][Factor] = 116;
   _jumpMap[547][Term] = 115;
   _jumpMap[547][Expr] = 706;
   _jumpMap[547][CasePrepare] = 113;
   _jumpMap[547][CaseClause] = 112;
   _actionMap[548][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[548][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[548][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[548][SEMICOLON] = ActionEntry(REDUCE, 90);
}
void Cego::loadParser171()
{
   _actionMap[549][KSEP] = ActionEntry(SHIFT, 708);
   _actionMap[549][SEMICOLON] = ActionEntry(REDUCE, 224);
   _actionMap[549][RETURNTOKEN] = ActionEntry(REDUCE, 224);
   _actionMap[549][WHERE] = ActionEntry(SHIFT, 436);
   _jumpMap[549][NoWhere] = 435;
   _jumpMap[549][WhereClause] = 707;
   _actionMap[550][KSEP] = ActionEntry(REDUCE, 156);
   _actionMap[550][WHERE] = ActionEntry(REDUCE, 156);
   _actionMap[550][RETURNTOKEN] = ActionEntry(REDUCE, 156);
   _actionMap[550][SEMICOLON] = ActionEntry(REDUCE, 156);
   _actionMap[550][GROUP] = ActionEntry(REDUCE, 156);
   _actionMap[550][ORDER] = ActionEntry(REDUCE, 156);
   _actionMap[550][ROWLIMIT] = ActionEntry(REDUCE, 156);
   _actionMap[550][UNION] = ActionEntry(REDUCE, 156);
   _actionMap[550][ENDTOKEN] = ActionEntry(REDUCE, 156);
   _actionMap[550][RB] = ActionEntry(REDUCE, 156);
   _actionMap[551][EQU] = ActionEntry(SHIFT, 709);
   _actionMap[552][LB] = ActionEntry(SHIFT, 710);
   _actionMap[221][SEMICOLON] = ActionEntry(REDUCE, 84);
   _actionMap[222][SEMICOLON] = ActionEntry(REDUCE, 85);
   _actionMap[223][SEMICOLON] = ActionEntry(REDUCE, 78);
   _actionMap[224][SEMICOLON] = ActionEntry(REDUCE, 82);
   _actionMap[225][SEMICOLON] = ActionEntry(REDUCE, 94);
   _actionMap[226][TO] = ActionEntry(REDUCE, 96);
   _actionMap[226][SEMICOLON] = ActionEntry(REDUCE, 96);
   _actionMap[227][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[227][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[227][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[227][ObjSpec] = 387;
   _actionMap[228][SEMICOLON] = ActionEntry(REDUCE, 80);
   _actionMap[229][SEMICOLON] = ActionEntry(REDUCE, 77);
   _actionMap[230][SEMICOLON] = ActionEntry(REDUCE, 83);
   _actionMap[231][SEMICOLON] = ActionEntry(REDUCE, 79);
   _actionMap[232][ADD] = ActionEntry(SHIFT, 390);
   _actionMap[232][DROP] = ActionEntry(SHIFT, 391);
   _actionMap[232][MODIFY] = ActionEntry(SHIFT, 392);
   _actionMap[232][RENAME] = ActionEntry(SHIFT, 393);
   _jumpMap[232][AlterOption] = 389;
   _jumpMap[232][AlterList] = 388;
   _actionMap[233][BY] = ActionEntry(SHIFT, 394);
   _actionMap[234][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[234][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[234][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[234][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[234][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[234][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[234][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[234][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[234][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[234][SCANDATE] = ActionEntry(SHIFT, 167);
}
void Cego::loadParser172()
{
   _actionMap[234][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[234][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[234][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[234][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[234][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[234][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[234][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[234][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[234][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[234][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[234][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[234][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[234][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[234][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[234][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[234][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[234][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[234][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[234][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[234][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[234][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[234][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[234][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[234][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[234][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[234][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[234][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[234][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[234][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[234][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[234][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[234][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[234][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[234][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[234][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[234][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[234][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[234][LB] = ActionEntry(SHIFT, 178);
   _actionMap[234][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[234][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[234][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[234][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[234][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[234][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[234][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[234][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[234][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[234][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[234][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[234][COUNT] = ActionEntry(SHIFT, 137);
}
void Cego::loadParser173()
{
   _actionMap[234][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[234][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[234][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[234][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[234][RB] = ActionEntry(REDUCE, 280);
   _jumpMap[234][ObjSpec] = 122;
   _jumpMap[234][Constant] = 121;
   _jumpMap[234][SignedFloat] = 120;
   _jumpMap[234][SignedInt] = 119;
   _jumpMap[234][Attribute] = 118;
   _jumpMap[234][Function] = 117;
   _jumpMap[234][Factor] = 116;
   _jumpMap[234][Term] = 115;
   _jumpMap[234][Expr] = 397;
   _jumpMap[234][ProcValueList] = 396;
   _jumpMap[234][ProcValueListOpt] = 395;
   _jumpMap[234][CasePrepare] = 113;
   _jumpMap[234][CaseClause] = 112;
   _actionMap[235][SEMICOLON] = ActionEntry(REDUCE, 92);
   _actionMap[236][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[236][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[236][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[236][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[236][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[236][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[236][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[236][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[236][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[236][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[236][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[236][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[236][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[236][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[236][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[236][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[236][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[236][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[236][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[236][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[236][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[236][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[236][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[236][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[236][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[236][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[236][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[236][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[236][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[236][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[236][LDIV] = ActionEntry(SHIFT, 150);
}
void Cego::loadParser174()
{
   _actionMap[236][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[236][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[236][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[236][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[236][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[236][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[236][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[236][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[236][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[236][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[236][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[236][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[236][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[236][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[236][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[236][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[236][LB] = ActionEntry(SHIFT, 178);
   _actionMap[236][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[236][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[236][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[236][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[236][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[236][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[236][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[236][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[236][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[236][VARREF] = ActionEntry(SHIFT, 422);
   _actionMap[236][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[236][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[236][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[236][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[236][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[236][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[236][IF] = ActionEntry(SHIFT, 416);
   _actionMap[236][BEGIN] = ActionEntry(SHIFT, 413);
   _actionMap[236][UNLOCK] = ActionEntry(SHIFT, 28);
   _actionMap[236][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[236][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[236][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[236][START_TOKEN] = ActionEntry(SHIFT, 37);
   _actionMap[236][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[236][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[236][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[236][VAR] = ActionEntry(SHIFT, 420);
   _actionMap[236][CURSOR] = ActionEntry(SHIFT, 415);
   _actionMap[236][CLOSE] = ActionEntry(SHIFT, 414);
   _actionMap[236][NOOP] = ActionEntry(SHIFT, 417);
   _actionMap[236][THROW] = ActionEntry(SHIFT, 419);
   _actionMap[236][RETURNTOKEN] = ActionEntry(SHIFT, 418);
   _actionMap[236][WHILE] = ActionEntry(SHIFT, 421);
}
void Cego::loadParser175()
{
   _jumpMap[236][ObjSpec] = 122;
   _jumpMap[236][Constant] = 121;
   _jumpMap[236][SignedFloat] = 120;
   _jumpMap[236][SignedInt] = 119;
   _jumpMap[236][Attribute] = 118;
   _jumpMap[236][Function] = 117;
   _jumpMap[236][Factor] = 116;
   _jumpMap[236][Term] = 115;
   _jumpMap[236][Expr] = 412;
   _jumpMap[236][ProcStatement] = 411;
   _jumpMap[236][ProcIfPart] = 410;
   _jumpMap[236][ProcBlockStart] = 409;
   _jumpMap[236][ProcStatementList] = 408;
   _jumpMap[236][ProcStmtBlock] = 407;
   _jumpMap[236][DeleteStatement] = 406;
   _jumpMap[236][UpdateStatement] = 405;
   _jumpMap[236][InsertStatement] = 404;
   _jumpMap[236][UnlockStatement] = 403;
   _jumpMap[236][LockStatement] = 402;
   _jumpMap[236][RollbackStatement] = 401;
   _jumpMap[236][CommitStatement] = 400;
   _jumpMap[236][StartStatement] = 399;
   _jumpMap[236][CasePrepare] = 113;
   _jumpMap[236][CaseClause] = 112;
   _actionMap[237][IDENTIFIER] = ActionEntry(SHIFT, 423);
   _actionMap[238][ON] = ActionEntry(REDUCE, 134);
   _actionMap[238][IDENTIFIER] = ActionEntry(REDUCE, 134);
   _actionMap[239][ON] = ActionEntry(REDUCE, 133);
   _actionMap[239][IDENTIFIER] = ActionEntry(REDUCE, 133);
   _actionMap[240][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[240][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[240][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[240][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[240][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[240][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[240][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[240][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[240][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[240][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[240][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[240][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[240][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[240][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[240][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[240][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[240][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[240][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[240][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[240][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[240][REPLACE] = ActionEntry(SHIFT, 163);
}
void Cego::loadParser176()
{
   _actionMap[240][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[240][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[240][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[240][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[240][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[240][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[240][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[240][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[240][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[240][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[240][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[240][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[240][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[240][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[240][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[240][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[240][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[240][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[240][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[240][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[240][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[240][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[240][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[240][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[240][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[240][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[240][LB] = ActionEntry(SHIFT, 178);
   _actionMap[240][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[240][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[240][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[240][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[240][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[240][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[240][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[240][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[240][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[240][VARREF] = ActionEntry(SHIFT, 422);
   _actionMap[240][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[240][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[240][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[240][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[240][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[240][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[240][IF] = ActionEntry(SHIFT, 416);
   _actionMap[240][BEGIN] = ActionEntry(SHIFT, 413);
   _actionMap[240][UNLOCK] = ActionEntry(SHIFT, 28);
   _actionMap[240][LOCK] = ActionEntry(SHIFT, 27);
   _actionMap[240][ROLLBACK] = ActionEntry(SHIFT, 33);
   _actionMap[240][COMMIT] = ActionEntry(SHIFT, 18);
   _actionMap[240][START_TOKEN] = ActionEntry(SHIFT, 37);
}
void Cego::loadParser177()
{
   _actionMap[240][UPDATE] = ActionEntry(SHIFT, 43);
   _actionMap[240][DELETETOK] = ActionEntry(SHIFT, 20);
   _actionMap[240][INSERT] = ActionEntry(SHIFT, 23);
   _actionMap[240][VAR] = ActionEntry(SHIFT, 420);
   _actionMap[240][CURSOR] = ActionEntry(SHIFT, 415);
   _actionMap[240][CLOSE] = ActionEntry(SHIFT, 414);
   _actionMap[240][NOOP] = ActionEntry(SHIFT, 417);
   _actionMap[240][THROW] = ActionEntry(SHIFT, 419);
   _actionMap[240][RETURNTOKEN] = ActionEntry(SHIFT, 418);
   _actionMap[240][WHILE] = ActionEntry(SHIFT, 421);
   _jumpMap[240][ObjSpec] = 122;
   _jumpMap[240][Constant] = 121;
   _jumpMap[240][SignedFloat] = 120;
   _jumpMap[240][SignedInt] = 119;
   _jumpMap[240][Attribute] = 118;
   _jumpMap[240][Function] = 117;
   _jumpMap[240][Factor] = 116;
   _jumpMap[240][Term] = 115;
   _jumpMap[240][Expr] = 412;
   _jumpMap[240][ProcStatement] = 411;
   _jumpMap[240][ProcIfPart] = 410;
   _jumpMap[240][ProcBlockStart] = 409;
   _jumpMap[240][ProcStatementList] = 408;
   _jumpMap[240][ProcStmtBlock] = 424;
   _jumpMap[240][DeleteStatement] = 406;
   _jumpMap[240][UpdateStatement] = 405;
   _jumpMap[240][InsertStatement] = 404;
   _jumpMap[240][UnlockStatement] = 403;
   _jumpMap[240][LockStatement] = 402;
   _jumpMap[240][RollbackStatement] = 401;
   _jumpMap[240][CommitStatement] = 400;
   _jumpMap[240][StartStatement] = 399;
   _jumpMap[240][CasePrepare] = 113;
   _jumpMap[240][CaseClause] = 112;
   _actionMap[241][ON] = ActionEntry(SHIFT, 425);
   _actionMap[242][SEMICOLON] = ActionEntry(REDUCE, 93);
   _actionMap[243][ON] = ActionEntry(SHIFT, 426);
   _actionMap[244][LB] = ActionEntry(SHIFT, 427);
   _actionMap[245][LB] = ActionEntry(SHIFT, 428);
   _actionMap[246][BEFORE] = ActionEntry(SHIFT, 431);
   _actionMap[246][AFTER] = ActionEntry(SHIFT, 430);
   _jumpMap[246][TriggerEvent] = 429;
   _actionMap[247][AS] = ActionEntry(SHIFT, 432);
   _actionMap[248][IDENTIFIER] = ActionEntry(SHIFT, 385);
   _actionMap[248][WHERE] = ActionEntry(REDUCE, 167);
   _actionMap[248][RETURNTOKEN] = ActionEntry(REDUCE, 167);
   _actionMap[248][SEMICOLON] = ActionEntry(REDUCE, 167);
   _actionMap[248][GROUP] = ActionEntry(REDUCE, 167);
   _actionMap[248][ORDER] = ActionEntry(REDUCE, 167);
   _actionMap[248][ROWLIMIT] = ActionEntry(REDUCE, 167);
}
void Cego::loadParser178()
{
   _actionMap[248][UNION] = ActionEntry(REDUCE, 167);
   _actionMap[248][ENDTOKEN] = ActionEntry(REDUCE, 167);
   _actionMap[248][RB] = ActionEntry(REDUCE, 167);
   _jumpMap[248][NoWhere] = 435;
   _jumpMap[248][WhereClause] = 434;
   _jumpMap[248][UpdDelAlias] = 433;
   _actionMap[249][SEMICOLON] = ActionEntry(REDUCE, 25);
   _actionMap[250][SEMICOLON] = ActionEntry(REDUCE, 29);
   _actionMap[251][SEMICOLON] = ActionEntry(REDUCE, 24);
   _actionMap[252][SEMICOLON] = ActionEntry(REDUCE, 28);
   _actionMap[253][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[253][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[253][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[253][ObjSpec] = 437;
   _actionMap[254][SEMICOLON] = ActionEntry(REDUCE, 30);
   _actionMap[255][SEMICOLON] = ActionEntry(REDUCE, 23);
   _actionMap[256][SEMICOLON] = ActionEntry(REDUCE, 26);
   _actionMap[257][COUNTER] = ActionEntry(REDUCE, 87);
   _actionMap[257][ALIAS] = ActionEntry(REDUCE, 87);
   _actionMap[257][BTREE] = ActionEntry(REDUCE, 87);
   _actionMap[257][INDEX] = ActionEntry(REDUCE, 87);
   _actionMap[257][TRIGGER] = ActionEntry(REDUCE, 87);
   _actionMap[257][CHECK] = ActionEntry(REDUCE, 87);
   _actionMap[257][FOREIGN] = ActionEntry(REDUCE, 87);
   _actionMap[257][PROCEDURE] = ActionEntry(REDUCE, 87);
   _actionMap[257][VIEW] = ActionEntry(REDUCE, 87);
   _actionMap[257][AVLTREE] = ActionEntry(REDUCE, 87);
   _actionMap[257][TABLE] = ActionEntry(REDUCE, 87);
   _actionMap[258][LB] = ActionEntry(SHIFT, 442);
   _actionMap[258][VALUES] = ActionEntry(REDUCE, 145);
   _actionMap[258][SELECT] = ActionEntry(REDUCE, 145);
   _jumpMap[258][SelectStatement] = 440;
   _jumpMap[258][InsertPrepare] = 439;
   _jumpMap[258][InsertArgSpec] = 438;
   _actionMap[259][SEMICOLON] = ActionEntry(REDUCE, 98);
   _actionMap[259][IDENTIFIER] = ActionEntry(REDUCE, 98);
   _actionMap[260][SEMICOLON] = ActionEntry(REDUCE, 7);
   _actionMap[261][IDENTIFIER] = ActionEntry(SHIFT, 443);
   _actionMap[262][SEMICOLON] = ActionEntry(REDUCE, 14);
   _actionMap[263][SEMICOLON] = ActionEntry(REDUCE, 6);
   _actionMap[264][SEMICOLON] = ActionEntry(REDUCE, 12);
   _actionMap[265][SEMICOLON] = ActionEntry(REDUCE, 9);
   _actionMap[266][SEMICOLON] = ActionEntry(REDUCE, 8);
   _actionMap[267][SEMICOLON] = ActionEntry(REDUCE, 4);
   _actionMap[268][SEMICOLON] = ActionEntry(REDUCE, 10);
   _actionMap[269][SEMICOLON] = ActionEntry(REDUCE, 3);
   _actionMap[270][SEMICOLON] = ActionEntry(REDUCE, 11);
   _actionMap[271][SEMICOLON] = ActionEntry(REDUCE, 13);
   _actionMap[272][SEMICOLON] = ActionEntry(REDUCE, 5);
   _actionMap[273][OR] = ActionEntry(SHIFT, 444);
}
void Cego::loadParser179()
{
   _actionMap[273][SEMICOLON] = ActionEntry(REDUCE, 73);
   _actionMap[274][AND] = ActionEntry(SHIFT, 445);
   _actionMap[274][LEFT] = ActionEntry(REDUCE, 297);
   _actionMap[274][RIGHT] = ActionEntry(REDUCE, 297);
   _actionMap[274][INNER] = ActionEntry(REDUCE, 297);
   _actionMap[274][JOIN] = ActionEntry(REDUCE, 297);
   _actionMap[274][ENDTOKEN] = ActionEntry(REDUCE, 297);
   _actionMap[274][UNION] = ActionEntry(REDUCE, 297);
   _actionMap[274][ROWLIMIT] = ActionEntry(REDUCE, 297);
   _actionMap[274][ORDER] = ActionEntry(REDUCE, 297);
   _actionMap[274][GROUP] = ActionEntry(REDUCE, 297);
   _actionMap[274][SEMICOLON] = ActionEntry(REDUCE, 297);
   _actionMap[274][RETURNTOKEN] = ActionEntry(REDUCE, 297);
   _actionMap[274][WHERE] = ActionEntry(REDUCE, 297);
   _actionMap[274][RB] = ActionEntry(REDUCE, 297);
   _actionMap[274][BEGIN] = ActionEntry(REDUCE, 297);
   _actionMap[274][THEN] = ActionEntry(REDUCE, 297);
   _actionMap[274][OR] = ActionEntry(REDUCE, 297);
   _actionMap[275][LEFT] = ActionEntry(REDUCE, 299);
   _actionMap[275][RIGHT] = ActionEntry(REDUCE, 299);
   _actionMap[275][INNER] = ActionEntry(REDUCE, 299);
   _actionMap[275][JOIN] = ActionEntry(REDUCE, 299);
   _actionMap[275][ENDTOKEN] = ActionEntry(REDUCE, 299);
   _actionMap[275][UNION] = ActionEntry(REDUCE, 299);
   _actionMap[275][ROWLIMIT] = ActionEntry(REDUCE, 299);
   _actionMap[275][ORDER] = ActionEntry(REDUCE, 299);
   _actionMap[275][GROUP] = ActionEntry(REDUCE, 299);
   _actionMap[275][SEMICOLON] = ActionEntry(REDUCE, 299);
   _actionMap[275][RETURNTOKEN] = ActionEntry(REDUCE, 299);
   _actionMap[275][WHERE] = ActionEntry(REDUCE, 299);
   _actionMap[275][RB] = ActionEntry(REDUCE, 299);
   _actionMap[275][BEGIN] = ActionEntry(REDUCE, 299);
   _actionMap[275][THEN] = ActionEntry(REDUCE, 299);
   _actionMap[275][OR] = ActionEntry(REDUCE, 299);
   _actionMap[275][AND] = ActionEntry(REDUCE, 299);
   _actionMap[276][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[276][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[276][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[276][INTOK] = ActionEntry(SHIFT, 448);
   _actionMap[276][NOT] = ActionEntry(SHIFT, 452);
   _actionMap[276][BETWEEN] = ActionEntry(SHIFT, 447);
   _actionMap[276][IS] = ActionEntry(SHIFT, 449);
   _actionMap[276][LIKE] = ActionEntry(SHIFT, 450);
   _actionMap[276][NCLIKE] = ActionEntry(SHIFT, 451);
   _actionMap[276][LEFT] = ActionEntry(REDUCE, 313);
   _actionMap[276][RIGHT] = ActionEntry(REDUCE, 313);
   _actionMap[276][INNER] = ActionEntry(REDUCE, 313);
   _actionMap[276][JOIN] = ActionEntry(REDUCE, 313);
   _actionMap[276][ENDTOKEN] = ActionEntry(REDUCE, 313);
   _actionMap[276][UNION] = ActionEntry(REDUCE, 313);
}
void Cego::loadParser180()
{
   _actionMap[276][ROWLIMIT] = ActionEntry(REDUCE, 313);
   _actionMap[276][ORDER] = ActionEntry(REDUCE, 313);
   _actionMap[276][GROUP] = ActionEntry(REDUCE, 313);
   _actionMap[276][SEMICOLON] = ActionEntry(REDUCE, 313);
   _actionMap[276][RETURNTOKEN] = ActionEntry(REDUCE, 313);
   _actionMap[276][WHERE] = ActionEntry(REDUCE, 313);
   _actionMap[276][RB] = ActionEntry(REDUCE, 313);
   _actionMap[276][BEGIN] = ActionEntry(REDUCE, 313);
   _actionMap[276][THEN] = ActionEntry(REDUCE, 313);
   _actionMap[276][AND] = ActionEntry(REDUCE, 313);
   _actionMap[276][OR] = ActionEntry(REDUCE, 313);
   _actionMap[276][EQU] = ActionEntry(SHIFT, 453);
   _actionMap[276][NEGATION] = ActionEntry(SHIFT, 456);
   _actionMap[276][LT] = ActionEntry(SHIFT, 454);
   _actionMap[276][MT] = ActionEntry(SHIFT, 455);
   _jumpMap[276][Comparison] = 446;
   _actionMap[277][LB] = ActionEntry(SHIFT, 457);
   _actionMap[278][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[278][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[278][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[278][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[278][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[278][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[278][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[278][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[278][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[278][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[278][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[278][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[278][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[278][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[278][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[278][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[278][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[278][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[278][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[278][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[278][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[278][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[278][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[278][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[278][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[278][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[278][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[278][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[278][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[278][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[278][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[278][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[278][BITAND] = ActionEntry(SHIFT, 126);
}
void Cego::loadParser181()
{
   _actionMap[278][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[278][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[278][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[278][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[278][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[278][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[278][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[278][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[278][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[278][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[278][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[278][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[278][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[278][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[278][LB] = ActionEntry(SHIFT, 178);
   _actionMap[278][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[278][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[278][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[278][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[278][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[278][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[278][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[278][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[278][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[278][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[278][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[278][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[278][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[278][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[278][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[278][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[278][EXISTS] = ActionEntry(SHIFT, 277);
   _actionMap[278][NOT] = ActionEntry(SHIFT, 278);
   _jumpMap[278][ObjSpec] = 122;
   _jumpMap[278][Constant] = 121;
   _jumpMap[278][SignedFloat] = 120;
   _jumpMap[278][SignedInt] = 119;
   _jumpMap[278][Attribute] = 118;
   _jumpMap[278][Function] = 117;
   _jumpMap[278][Factor] = 116;
   _jumpMap[278][Term] = 115;
   _jumpMap[278][Expr] = 276;
   _jumpMap[278][Predicate] = 458;
   _jumpMap[278][CasePrepare] = 113;
   _jumpMap[278][CaseClause] = 112;
   _actionMap[279][AS] = ActionEntry(SHIFT, 459);
   _actionMap[280][SEMICOLON] = ActionEntry(REDUCE, 140);
   _actionMap[281][SEMICOLON] = ActionEntry(REDUCE, 141);
   _actionMap[282][ELSE] = ActionEntry(SHIFT, 461);
   _actionMap[282][WHEN] = ActionEntry(SHIFT, 284);
}
void Cego::loadParser182()
{
   _jumpMap[282][CaseCondition] = 460;
   _actionMap[283][WHEN] = ActionEntry(REDUCE, 111);
   _actionMap[283][ELSE] = ActionEntry(REDUCE, 111);
   _actionMap[284][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[284][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[284][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[284][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[284][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[284][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[284][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[284][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[284][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[284][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[284][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[284][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[284][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[284][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[284][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[284][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[284][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[284][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[284][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[284][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[284][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[284][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[284][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[284][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[284][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[284][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[284][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[284][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[284][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[284][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[284][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[284][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[284][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[284][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[284][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[284][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[284][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[284][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[284][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[284][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[284][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[284][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[284][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[284][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[284][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[284][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[284][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
}
void Cego::loadParser183()
{
   _actionMap[284][LB] = ActionEntry(SHIFT, 178);
   _actionMap[284][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[284][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[284][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[284][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[284][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[284][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[284][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[284][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[284][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[284][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[284][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[284][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[284][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[284][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[284][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[284][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[284][EXISTS] = ActionEntry(SHIFT, 277);
   _actionMap[284][NOT] = ActionEntry(SHIFT, 278);
   _jumpMap[284][ObjSpec] = 122;
   _jumpMap[284][Constant] = 121;
   _jumpMap[284][SignedFloat] = 120;
   _jumpMap[284][SignedInt] = 119;
   _jumpMap[284][Attribute] = 118;
   _jumpMap[284][Function] = 117;
   _jumpMap[284][Factor] = 116;
   _jumpMap[284][Term] = 115;
   _jumpMap[284][Expr] = 276;
   _jumpMap[284][Predicate] = 275;
   _jumpMap[284][Conjunction] = 274;
   _jumpMap[284][Condition] = 462;
   _jumpMap[284][CasePrepare] = 113;
   _jumpMap[284][CaseClause] = 112;
   _actionMap[285][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[285][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[285][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[285][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[285][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[285][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[285][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[285][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[285][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[285][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[285][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[285][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[285][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[285][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[285][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[285][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[285][LONG2DATE] = ActionEntry(SHIFT, 145);
}
void Cego::loadParser184()
{
   _actionMap[285][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[285][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[285][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[285][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[285][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[285][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[285][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[285][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[285][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[285][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[285][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[285][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[285][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[285][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[285][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[285][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[285][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[285][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[285][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[285][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[285][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[285][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[285][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[285][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[285][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[285][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[285][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[285][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[285][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[285][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[285][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[285][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[285][LB] = ActionEntry(SHIFT, 178);
   _actionMap[285][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[285][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[285][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[285][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[285][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[285][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[285][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[285][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[285][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[285][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[285][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[285][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[285][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[285][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[285][ObjSpec] = 122;
   _jumpMap[285][Constant] = 121;
   _jumpMap[285][SignedFloat] = 120;
}
void Cego::loadParser185()
{
   _jumpMap[285][SignedInt] = 119;
   _jumpMap[285][Attribute] = 118;
   _jumpMap[285][Function] = 117;
   _jumpMap[285][Factor] = 116;
   _jumpMap[285][Term] = 463;
   _jumpMap[285][CasePrepare] = 113;
   _jumpMap[285][CaseClause] = 112;
   _actionMap[286][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[286][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[286][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[286][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[286][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[286][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[286][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[286][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[286][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[286][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[286][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[286][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[286][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[286][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[286][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[286][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[286][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[286][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[286][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[286][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[286][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[286][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[286][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[286][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[286][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[286][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[286][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[286][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[286][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[286][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[286][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[286][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[286][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[286][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[286][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[286][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[286][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[286][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[286][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[286][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[286][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[286][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[286][CLOBREF] = ActionEntry(SHIFT, 135);
}
void Cego::loadParser186()
{
   _actionMap[286][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[286][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[286][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[286][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[286][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[286][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[286][LB] = ActionEntry(SHIFT, 178);
   _actionMap[286][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[286][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[286][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[286][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[286][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[286][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[286][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[286][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[286][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[286][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[286][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[286][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[286][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[286][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[286][ObjSpec] = 122;
   _jumpMap[286][Constant] = 121;
   _jumpMap[286][SignedFloat] = 120;
   _jumpMap[286][SignedInt] = 119;
   _jumpMap[286][Attribute] = 118;
   _jumpMap[286][Function] = 117;
   _jumpMap[286][Factor] = 116;
   _jumpMap[286][Term] = 464;
   _jumpMap[286][CasePrepare] = 113;
   _jumpMap[286][CaseClause] = 112;
   _actionMap[287][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[287][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[287][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[287][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[287][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[287][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[287][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[287][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[287][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[287][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[287][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[287][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[287][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[287][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[287][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[287][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[287][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[287][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[287][LOWER] = ActionEntry(SHIFT, 152);
}
void Cego::loadParser187()
{
   _actionMap[287][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[287][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[287][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[287][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[287][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[287][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[287][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[287][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[287][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[287][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[287][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[287][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[287][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[287][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[287][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[287][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[287][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[287][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[287][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[287][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[287][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[287][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[287][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[287][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[287][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[287][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[287][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[287][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[287][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[287][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[287][LB] = ActionEntry(SHIFT, 178);
   _actionMap[287][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[287][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[287][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[287][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[287][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[287][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[287][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[287][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[287][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[287][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[287][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[287][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[287][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[287][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[287][ObjSpec] = 122;
   _jumpMap[287][Constant] = 121;
   _jumpMap[287][SignedFloat] = 120;
   _jumpMap[287][SignedInt] = 119;
   _jumpMap[287][Attribute] = 118;
}
void Cego::loadParser188()
{
   _jumpMap[287][Function] = 117;
   _jumpMap[287][Factor] = 116;
   _jumpMap[287][Term] = 465;
   _jumpMap[287][CasePrepare] = 113;
   _jumpMap[287][CaseClause] = 112;
   _actionMap[288][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[288][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[288][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[288][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[288][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[288][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[288][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[288][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[288][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[288][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[288][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[288][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[288][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[288][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[288][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[288][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[288][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[288][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[288][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[288][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[288][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[288][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[288][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[288][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[288][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[288][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[288][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[288][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[288][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[288][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[288][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[288][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[288][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[288][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[288][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[288][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[288][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[288][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[288][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[288][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[288][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[288][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[288][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[288][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[288][REGMATCH] = ActionEntry(SHIFT, 162);
}
void Cego::loadParser189()
{
   _actionMap[288][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[288][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[288][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[288][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[288][LB] = ActionEntry(SHIFT, 178);
   _actionMap[288][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[288][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[288][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[288][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[288][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[288][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[288][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[288][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[288][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[288][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[288][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[288][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[288][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[288][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[288][ObjSpec] = 122;
   _jumpMap[288][Constant] = 121;
   _jumpMap[288][SignedFloat] = 120;
   _jumpMap[288][SignedInt] = 119;
   _jumpMap[288][Attribute] = 118;
   _jumpMap[288][Function] = 117;
   _jumpMap[288][Factor] = 466;
   _jumpMap[288][CasePrepare] = 113;
   _jumpMap[288][CaseClause] = 112;
   _actionMap[289][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[289][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[289][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[289][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[289][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[289][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[289][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[289][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[289][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[289][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[289][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[289][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[289][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[289][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[289][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[289][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[289][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[289][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[289][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[289][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[289][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[289][RIGHT] = ActionEntry(SHIFT, 164);
}
void Cego::loadParser190()
{
   _actionMap[289][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[289][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[289][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[289][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[289][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[289][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[289][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[289][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[289][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[289][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[289][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[289][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[289][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[289][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[289][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[289][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[289][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[289][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[289][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[289][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[289][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[289][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[289][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[289][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[289][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[289][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[289][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[289][LB] = ActionEntry(SHIFT, 178);
   _actionMap[289][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[289][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[289][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[289][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[289][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[289][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[289][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[289][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[289][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[289][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[289][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[289][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[289][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[289][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[289][ObjSpec] = 122;
   _jumpMap[289][Constant] = 121;
   _jumpMap[289][SignedFloat] = 120;
   _jumpMap[289][SignedInt] = 119;
   _jumpMap[289][Attribute] = 118;
   _jumpMap[289][Function] = 117;
   _jumpMap[289][Factor] = 467;
   _jumpMap[289][CasePrepare] = 113;
}
void Cego::loadParser191()
{
   _jumpMap[289][CaseClause] = 112;
   _actionMap[290][RB] = ActionEntry(SHIFT, 470);
   _actionMap[290][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[290][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[290][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[290][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[290][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[290][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[290][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[290][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[290][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[290][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[290][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[290][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[290][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[290][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[290][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[290][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[290][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[290][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[290][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[290][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[290][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[290][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[290][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[290][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[290][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[290][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[290][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[290][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[290][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[290][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[290][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[290][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[290][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[290][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[290][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[290][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[290][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[290][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[290][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[290][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[290][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[290][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[290][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[290][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[290][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[290][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[290][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[290][LB] = ActionEntry(SHIFT, 178);
}
void Cego::loadParser192()
{
   _actionMap[290][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[290][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[290][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[290][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[290][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[290][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[290][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[290][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[290][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[290][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[290][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[290][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[290][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[290][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[290][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[290][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[290][ObjSpec] = 122;
   _jumpMap[290][Constant] = 121;
   _jumpMap[290][SignedFloat] = 120;
   _jumpMap[290][SignedInt] = 119;
   _jumpMap[290][Attribute] = 118;
   _jumpMap[290][ExpressionList] = 469;
   _jumpMap[290][Function] = 117;
   _jumpMap[290][Factor] = 116;
   _jumpMap[290][Term] = 115;
   _jumpMap[290][Expr] = 468;
   _jumpMap[290][CasePrepare] = 113;
   _jumpMap[290][CaseClause] = 112;
   _actionMap[291][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[291][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[291][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[291][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[291][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[291][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[291][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[291][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[291][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[291][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[291][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[291][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[291][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[291][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[291][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[291][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[291][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[291][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[291][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[291][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[291][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[291][LENGTH] = ActionEntry(SHIFT, 149);
}
void Cego::loadParser193()
{
   _actionMap[291][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[291][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[291][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[291][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[291][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[291][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[291][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[291][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[291][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[291][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[291][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[291][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[291][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[291][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[291][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[291][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[291][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[291][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[291][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[291][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[291][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[291][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[291][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[291][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[291][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[291][LB] = ActionEntry(SHIFT, 178);
   _actionMap[291][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[291][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[291][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[291][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[291][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[291][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[291][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[291][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[291][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[291][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[291][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[291][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[291][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[291][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[291][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[291][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[291][ObjSpec] = 122;
   _jumpMap[291][Constant] = 121;
   _jumpMap[291][SignedFloat] = 120;
   _jumpMap[291][SignedInt] = 119;
   _jumpMap[291][Attribute] = 118;
   _jumpMap[291][ExpressionList] = 471;
   _jumpMap[291][Function] = 117;
   _jumpMap[291][Factor] = 116;
}
void Cego::loadParser194()
{
   _jumpMap[291][Term] = 115;
   _jumpMap[291][Expr] = 468;
   _jumpMap[291][CasePrepare] = 113;
   _jumpMap[291][CaseClause] = 112;
   _actionMap[292][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[292][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[292][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[292][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[292][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[292][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[292][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[292][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[292][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[292][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[292][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[292][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[292][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[292][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[292][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[292][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[292][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[292][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[292][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[292][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[292][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[292][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[292][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[292][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[292][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[292][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[292][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[292][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[292][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[292][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[292][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[292][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[292][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[292][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[292][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[292][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[292][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[292][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[292][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[292][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[292][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[292][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[292][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[292][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[292][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[292][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
}
void Cego::loadParser195()
{
   _actionMap[292][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[292][LB] = ActionEntry(SHIFT, 178);
   _actionMap[292][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[292][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[292][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[292][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[292][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[292][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[292][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[292][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[292][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[292][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[292][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[292][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[292][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[292][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[292][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[292][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[292][ObjSpec] = 122;
   _jumpMap[292][Constant] = 121;
   _jumpMap[292][SignedFloat] = 120;
   _jumpMap[292][SignedInt] = 119;
   _jumpMap[292][Attribute] = 118;
   _jumpMap[292][Function] = 117;
   _jumpMap[292][Factor] = 116;
   _jumpMap[292][Term] = 115;
   _jumpMap[292][Expr] = 472;
   _jumpMap[292][CasePrepare] = 113;
   _jumpMap[292][CaseClause] = 112;
   _actionMap[293][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[293][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[293][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[293][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[293][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[293][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[293][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[293][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[293][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[293][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[293][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[293][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[293][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[293][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[293][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[293][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[293][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[293][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[293][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[293][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[293][REPLACE] = ActionEntry(SHIFT, 163);
}
void Cego::loadParser196()
{
   _actionMap[293][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[293][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[293][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[293][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[293][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[293][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[293][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[293][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[293][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[293][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[293][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[293][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[293][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[293][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[293][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[293][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[293][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[293][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[293][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[293][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[293][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[293][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[293][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[293][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[293][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[293][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[293][LB] = ActionEntry(SHIFT, 178);
   _actionMap[293][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[293][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[293][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[293][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[293][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[293][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[293][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[293][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[293][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[293][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[293][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[293][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[293][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[293][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[293][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[293][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[293][ObjSpec] = 122;
   _jumpMap[293][Constant] = 121;
   _jumpMap[293][SignedFloat] = 120;
   _jumpMap[293][SignedInt] = 119;
   _jumpMap[293][Attribute] = 118;
   _jumpMap[293][ExpressionList] = 473;
   _jumpMap[293][Function] = 117;
}
void Cego::loadParser197()
{
   _jumpMap[293][Factor] = 116;
   _jumpMap[293][Term] = 115;
   _jumpMap[293][Expr] = 468;
   _jumpMap[293][CasePrepare] = 113;
   _jumpMap[293][CaseClause] = 112;
   _actionMap[294][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[294][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[294][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[294][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[294][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[294][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[294][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[294][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[294][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[294][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[294][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[294][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[294][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[294][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[294][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[294][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[294][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[294][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[294][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[294][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[294][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[294][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[294][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[294][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[294][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[294][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[294][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[294][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[294][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[294][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[294][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[294][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[294][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[294][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[294][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[294][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[294][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[294][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[294][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[294][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[294][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[294][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[294][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[294][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[294][IDENTIFIER] = ActionEntry(SHIFT, 182);
}
void Cego::loadParser198()
{
   _actionMap[294][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[294][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[294][LB] = ActionEntry(SHIFT, 178);
   _actionMap[294][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[294][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[294][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[294][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[294][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[294][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[294][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[294][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[294][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[294][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[294][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[294][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[294][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[294][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[294][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[294][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[294][ObjSpec] = 122;
   _jumpMap[294][Constant] = 121;
   _jumpMap[294][SignedFloat] = 120;
   _jumpMap[294][SignedInt] = 119;
   _jumpMap[294][Attribute] = 118;
   _jumpMap[294][ExpressionList] = 474;
   _jumpMap[294][Function] = 117;
   _jumpMap[294][Factor] = 116;
   _jumpMap[294][Term] = 115;
   _jumpMap[294][Expr] = 468;
   _jumpMap[294][CasePrepare] = 113;
   _jumpMap[294][CaseClause] = 112;
   _actionMap[295][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[295][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[295][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[295][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[295][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[295][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[295][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[295][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[295][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[295][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[295][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[295][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[295][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[295][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[295][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[295][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[295][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[295][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[295][GETPOS] = ActionEntry(SHIFT, 144);
}
void Cego::loadParser199()
{
   _actionMap[295][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[295][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[295][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[295][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[295][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[295][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[295][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[295][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[295][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[295][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[295][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[295][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[295][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[295][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[295][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[295][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[295][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[295][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[295][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[295][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[295][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[295][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[295][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[295][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[295][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[295][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[295][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[295][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[295][LB] = ActionEntry(SHIFT, 178);
   _actionMap[295][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[295][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[295][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[295][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[295][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[295][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[295][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[295][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[295][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[295][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[295][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[295][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[295][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[295][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[295][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[295][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[295][ObjSpec] = 122;
   _jumpMap[295][Constant] = 121;
   _jumpMap[295][SignedFloat] = 120;
   _jumpMap[295][SignedInt] = 119;
   _jumpMap[295][Attribute] = 118;
}
void Cego::loadParser200()
{
   _jumpMap[295][ExpressionList] = 475;
   _jumpMap[295][Function] = 117;
   _jumpMap[295][Factor] = 116;
   _jumpMap[295][Term] = 115;
   _jumpMap[295][Expr] = 468;
   _jumpMap[295][CasePrepare] = 113;
   _jumpMap[295][CaseClause] = 112;
   _actionMap[296][INTVAL] = ActionEntry(SHIFT, 476);
   _actionMap[297][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[297][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[297][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[297][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[297][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[297][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[297][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[297][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[297][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[297][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[297][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[297][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[297][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[297][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[297][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[297][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[297][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[297][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[297][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[297][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[297][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[297][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[297][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[297][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[297][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[297][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[297][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[297][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[297][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[297][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[297][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[297][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[297][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[297][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[297][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[297][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[297][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[297][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[297][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[297][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[297][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[297][NEXTCOUNT] = ActionEntry(SHIFT, 157);
}
void Cego::loadParser201()
{
   _actionMap[297][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[297][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[297][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[297][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[297][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[297][LB] = ActionEntry(SHIFT, 178);
   _actionMap[297][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[297][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[297][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[297][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[297][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[297][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[297][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[297][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[297][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[297][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[297][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[297][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[297][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[297][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[297][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[297][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[297][ObjSpec] = 122;
   _jumpMap[297][Constant] = 121;
   _jumpMap[297][SignedFloat] = 120;
   _jumpMap[297][SignedInt] = 119;
   _jumpMap[297][Attribute] = 118;
   _jumpMap[297][ExpressionList] = 477;
   _jumpMap[297][Function] = 117;
   _jumpMap[297][Factor] = 116;
   _jumpMap[297][Term] = 115;
   _jumpMap[297][Expr] = 468;
   _jumpMap[297][CasePrepare] = 113;
   _jumpMap[297][CaseClause] = 112;
   _actionMap[298][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[298][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[298][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[298][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[298][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[298][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[298][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[298][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[298][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[298][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[298][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[298][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[298][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[298][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[298][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[298][UPPER] = ActionEntry(SHIFT, 177);
}
void Cego::loadParser202()
{
   _actionMap[298][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[298][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[298][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[298][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[298][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[298][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[298][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[298][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[298][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[298][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[298][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[298][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[298][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[298][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[298][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[298][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[298][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[298][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[298][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[298][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[298][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[298][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[298][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[298][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[298][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[298][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[298][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[298][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[298][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[298][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[298][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[298][LB] = ActionEntry(SHIFT, 178);
   _actionMap[298][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[298][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[298][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[298][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[298][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[298][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[298][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[298][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[298][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[298][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[298][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[298][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[298][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[298][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[298][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[298][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[298][ObjSpec] = 122;
   _jumpMap[298][Constant] = 121;
}
void Cego::loadParser203()
{
   _jumpMap[298][SignedFloat] = 120;
   _jumpMap[298][SignedInt] = 119;
   _jumpMap[298][Attribute] = 118;
   _jumpMap[298][ExpressionList] = 478;
   _jumpMap[298][Function] = 117;
   _jumpMap[298][Factor] = 116;
   _jumpMap[298][Term] = 115;
   _jumpMap[298][Expr] = 468;
   _jumpMap[298][CasePrepare] = 113;
   _jumpMap[298][CaseClause] = 112;
   _actionMap[299][INTVAL] = ActionEntry(SHIFT, 479);
   _actionMap[300][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[300][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[300][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[300][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[300][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[300][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[300][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[300][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[300][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[300][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[300][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[300][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[300][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[300][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[300][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[300][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[300][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[300][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[300][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[300][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[300][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[300][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[300][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[300][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[300][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[300][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[300][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[300][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[300][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[300][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[300][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[300][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[300][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[300][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[300][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[300][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[300][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[300][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[300][CLOBREF] = ActionEntry(SHIFT, 135);
}
void Cego::loadParser204()
{
   _actionMap[300][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[300][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[300][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[300][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[300][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[300][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[300][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[300][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[300][LB] = ActionEntry(SHIFT, 178);
   _actionMap[300][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[300][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[300][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[300][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[300][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[300][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[300][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[300][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[300][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[300][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[300][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[300][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[300][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[300][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[300][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[300][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[300][ObjSpec] = 122;
   _jumpMap[300][Constant] = 121;
   _jumpMap[300][SignedFloat] = 120;
   _jumpMap[300][SignedInt] = 119;
   _jumpMap[300][Attribute] = 118;
   _jumpMap[300][ExpressionList] = 480;
   _jumpMap[300][Function] = 117;
   _jumpMap[300][Factor] = 116;
   _jumpMap[300][Term] = 115;
   _jumpMap[300][Expr] = 468;
   _jumpMap[300][CasePrepare] = 113;
   _jumpMap[300][CaseClause] = 112;
   _actionMap[301][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[301][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[301][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[301][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[301][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[301][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[301][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[301][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[301][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[301][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[301][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[301][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[301][LONG2DATE] = ActionEntry(SHIFT, 145);
}
void Cego::loadParser205()
{
   _actionMap[301][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[301][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[301][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[301][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[301][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[301][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[301][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[301][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[301][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[301][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[301][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[301][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[301][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[301][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[301][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[301][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[301][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[301][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[301][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[301][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[301][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[301][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[301][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[301][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[301][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[301][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[301][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[301][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[301][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[301][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[301][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[301][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[301][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[301][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[301][LB] = ActionEntry(SHIFT, 178);
   _actionMap[301][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[301][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[301][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[301][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[301][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[301][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[301][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[301][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[301][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[301][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[301][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[301][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[301][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[301][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[301][MIN] = ActionEntry(SHIFT, 154);
}
void Cego::loadParser206()
{
   _actionMap[301][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[301][ObjSpec] = 122;
   _jumpMap[301][Constant] = 121;
   _jumpMap[301][SignedFloat] = 120;
   _jumpMap[301][SignedInt] = 119;
   _jumpMap[301][Attribute] = 118;
   _jumpMap[301][ExpressionList] = 481;
   _jumpMap[301][Function] = 117;
   _jumpMap[301][Factor] = 116;
   _jumpMap[301][Term] = 115;
   _jumpMap[301][Expr] = 468;
   _jumpMap[301][CasePrepare] = 113;
   _jumpMap[301][CaseClause] = 112;
   _actionMap[302][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[302][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[302][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[302][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[302][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[302][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[302][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[302][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[302][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[302][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[302][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[302][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[302][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[302][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[302][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[302][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[302][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[302][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[302][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[302][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[302][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[302][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[302][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[302][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[302][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[302][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[302][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[302][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[302][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[302][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[302][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[302][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[302][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[302][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[302][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[302][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[302][BLOBREF] = ActionEntry(SHIFT, 131);
}
void Cego::loadParser207()
{
   _actionMap[302][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[302][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[302][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[302][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[302][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[302][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[302][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[302][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[302][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[302][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[302][LB] = ActionEntry(SHIFT, 178);
   _actionMap[302][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[302][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[302][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[302][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[302][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[302][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[302][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[302][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[302][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[302][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[302][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[302][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[302][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[302][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[302][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[302][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[302][ObjSpec] = 122;
   _jumpMap[302][Constant] = 121;
   _jumpMap[302][SignedFloat] = 120;
   _jumpMap[302][SignedInt] = 119;
   _jumpMap[302][Attribute] = 118;
   _jumpMap[302][ExpressionList] = 482;
   _jumpMap[302][Function] = 117;
   _jumpMap[302][Factor] = 116;
   _jumpMap[302][Term] = 115;
   _jumpMap[302][Expr] = 468;
   _jumpMap[302][CasePrepare] = 113;
   _jumpMap[302][CaseClause] = 112;
   _actionMap[303][STAR] = ActionEntry(SHIFT, 484);
   _actionMap[303][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[303][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[303][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[303][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[303][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[303][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[303][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[303][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[303][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[303][SCANDATE] = ActionEntry(SHIFT, 167);
}
void Cego::loadParser208()
{
   _actionMap[303][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[303][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[303][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[303][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[303][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[303][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[303][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[303][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[303][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[303][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[303][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[303][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[303][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[303][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[303][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[303][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[303][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[303][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[303][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[303][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[303][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[303][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[303][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[303][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[303][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[303][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[303][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[303][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[303][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[303][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[303][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[303][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[303][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[303][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[303][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[303][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[303][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[303][LB] = ActionEntry(SHIFT, 178);
   _actionMap[303][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[303][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[303][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[303][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[303][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[303][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[303][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[303][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[303][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[303][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[303][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[303][COUNT] = ActionEntry(SHIFT, 137);
}
void Cego::loadParser209()
{
   _actionMap[303][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[303][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[303][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[303][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[303][ObjSpec] = 122;
   _jumpMap[303][Constant] = 121;
   _jumpMap[303][SignedFloat] = 120;
   _jumpMap[303][SignedInt] = 119;
   _jumpMap[303][Attribute] = 118;
   _jumpMap[303][Function] = 117;
   _jumpMap[303][Factor] = 116;
   _jumpMap[303][Term] = 115;
   _jumpMap[303][Expr] = 483;
   _jumpMap[303][CasePrepare] = 113;
   _jumpMap[303][CaseClause] = 112;
   _actionMap[304][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[304][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[304][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[304][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[304][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[304][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[304][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[304][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[304][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[304][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[304][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[304][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[304][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[304][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[304][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[304][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[304][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[304][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[304][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[304][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[304][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[304][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[304][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[304][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[304][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[304][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[304][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[304][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[304][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[304][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[304][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[304][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[304][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[304][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[304][BITXOR] = ActionEntry(SHIFT, 128);
}
void Cego::loadParser210()
{
   _actionMap[304][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[304][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[304][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[304][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[304][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[304][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[304][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[304][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[304][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[304][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[304][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[304][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[304][LB] = ActionEntry(SHIFT, 178);
   _actionMap[304][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[304][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[304][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[304][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[304][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[304][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[304][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[304][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[304][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[304][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[304][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[304][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[304][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[304][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[304][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[304][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[304][ObjSpec] = 122;
   _jumpMap[304][Constant] = 121;
   _jumpMap[304][SignedFloat] = 120;
   _jumpMap[304][SignedInt] = 119;
   _jumpMap[304][Attribute] = 118;
   _jumpMap[304][ExpressionList] = 485;
   _jumpMap[304][Function] = 117;
   _jumpMap[304][Factor] = 116;
   _jumpMap[304][Term] = 115;
   _jumpMap[304][Expr] = 468;
   _jumpMap[304][CasePrepare] = 113;
   _jumpMap[304][CaseClause] = 112;
   _actionMap[305][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[305][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[305][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[305][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[305][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[305][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[305][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[305][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[305][ROUND] = ActionEntry(SHIFT, 165);
}
void Cego::loadParser211()
{
   _actionMap[305][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[305][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[305][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[305][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[305][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[305][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[305][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[305][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[305][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[305][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[305][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[305][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[305][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[305][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[305][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[305][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[305][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[305][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[305][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[305][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[305][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[305][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[305][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[305][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[305][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[305][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[305][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[305][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[305][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[305][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[305][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[305][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[305][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[305][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[305][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[305][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[305][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[305][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[305][LB] = ActionEntry(SHIFT, 178);
   _actionMap[305][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[305][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[305][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[305][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[305][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[305][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[305][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[305][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[305][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[305][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[305][FETCH] = ActionEntry(SHIFT, 142);
}
void Cego::loadParser212()
{
   _actionMap[305][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[305][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[305][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[305][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[305][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[305][ObjSpec] = 122;
   _jumpMap[305][Constant] = 121;
   _jumpMap[305][SignedFloat] = 120;
   _jumpMap[305][SignedInt] = 119;
   _jumpMap[305][Attribute] = 118;
   _jumpMap[305][ExpressionList] = 486;
   _jumpMap[305][Function] = 117;
   _jumpMap[305][Factor] = 116;
   _jumpMap[305][Term] = 115;
   _jumpMap[305][Expr] = 468;
   _jumpMap[305][CasePrepare] = 113;
   _jumpMap[305][CaseClause] = 112;
   _actionMap[306][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[306][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[306][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[306][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[306][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[306][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[306][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[306][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[306][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[306][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[306][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[306][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[306][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[306][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[306][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[306][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[306][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[306][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[306][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[306][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[306][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[306][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[306][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[306][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[306][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[306][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[306][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[306][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[306][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[306][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[306][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[306][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[306][BITAND] = ActionEntry(SHIFT, 126);
}
void Cego::loadParser213()
{
   _actionMap[306][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[306][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[306][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[306][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[306][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[306][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[306][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[306][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[306][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[306][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[306][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[306][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[306][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[306][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[306][LB] = ActionEntry(SHIFT, 178);
   _actionMap[306][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[306][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[306][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[306][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[306][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[306][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[306][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[306][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[306][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[306][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[306][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[306][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[306][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[306][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[306][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[306][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[306][ObjSpec] = 122;
   _jumpMap[306][Constant] = 121;
   _jumpMap[306][SignedFloat] = 120;
   _jumpMap[306][SignedInt] = 119;
   _jumpMap[306][Attribute] = 118;
   _jumpMap[306][ExpressionList] = 487;
   _jumpMap[306][Function] = 117;
   _jumpMap[306][Factor] = 116;
   _jumpMap[306][Term] = 115;
   _jumpMap[306][Expr] = 468;
   _jumpMap[306][CasePrepare] = 113;
   _jumpMap[306][CaseClause] = 112;
   _actionMap[307][INTO] = ActionEntry(SHIFT, 488);
   _actionMap[308][IDENTIFIER] = ActionEntry(SHIFT, 489);
   _actionMap[309][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[309][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[309][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[309][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[309][ASC2INT] = ActionEntry(SHIFT, 124);
}
void Cego::loadParser214()
{
   _actionMap[309][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[309][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[309][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[309][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[309][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[309][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[309][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[309][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[309][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[309][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[309][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[309][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[309][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[309][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[309][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[309][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[309][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[309][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[309][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[309][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[309][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[309][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[309][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[309][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[309][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[309][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[309][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[309][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[309][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[309][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[309][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[309][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[309][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[309][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[309][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[309][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[309][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[309][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[309][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[309][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[309][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[309][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[309][LB] = ActionEntry(SHIFT, 178);
   _actionMap[309][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[309][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[309][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[309][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[309][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[309][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[309][CLOB] = ActionEntry(SHIFT, 133);
}
void Cego::loadParser215()
{
   _actionMap[309][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[309][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[309][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[309][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[309][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[309][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[309][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[309][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[309][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[309][ObjSpec] = 122;
   _jumpMap[309][Constant] = 121;
   _jumpMap[309][SignedFloat] = 120;
   _jumpMap[309][SignedInt] = 119;
   _jumpMap[309][Attribute] = 118;
   _jumpMap[309][ExpressionList] = 490;
   _jumpMap[309][Function] = 117;
   _jumpMap[309][Factor] = 116;
   _jumpMap[309][Term] = 115;
   _jumpMap[309][Expr] = 468;
   _jumpMap[309][CasePrepare] = 113;
   _jumpMap[309][CaseClause] = 112;
   _actionMap[310][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[310][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[310][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[310][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[310][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[310][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[310][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[310][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[310][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[310][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[310][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[310][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[310][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[310][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[310][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[310][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[310][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[310][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[310][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[310][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[310][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[310][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[310][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[310][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[310][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[310][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[310][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[310][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[310][DIV] = ActionEntry(SHIFT, 140);
}
void Cego::loadParser216()
{
   _actionMap[310][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[310][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[310][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[310][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[310][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[310][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[310][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[310][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[310][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[310][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[310][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[310][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[310][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[310][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[310][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[310][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[310][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[310][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[310][LB] = ActionEntry(SHIFT, 178);
   _actionMap[310][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[310][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[310][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[310][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[310][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[310][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[310][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[310][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[310][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[310][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[310][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[310][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[310][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[310][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[310][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[310][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[310][ObjSpec] = 122;
   _jumpMap[310][Constant] = 121;
   _jumpMap[310][SignedFloat] = 120;
   _jumpMap[310][SignedInt] = 119;
   _jumpMap[310][Attribute] = 118;
   _jumpMap[310][ExpressionList] = 491;
   _jumpMap[310][Function] = 117;
   _jumpMap[310][Factor] = 116;
   _jumpMap[310][Term] = 115;
   _jumpMap[310][Expr] = 468;
   _jumpMap[310][CasePrepare] = 113;
   _jumpMap[310][CaseClause] = 112;
   _actionMap[311][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[311][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[311][INTVAL] = ActionEntry(SHIFT, 180);
}
void Cego::loadParser217()
{
   _actionMap[311][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[311][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[311][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[311][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[311][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[311][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[311][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[311][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[311][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[311][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[311][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[311][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[311][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[311][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[311][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[311][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[311][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[311][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[311][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[311][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[311][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[311][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[311][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[311][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[311][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[311][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[311][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[311][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[311][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[311][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[311][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[311][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[311][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[311][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[311][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[311][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[311][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[311][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[311][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[311][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[311][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[311][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[311][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[311][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[311][LB] = ActionEntry(SHIFT, 178);
   _actionMap[311][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[311][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[311][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[311][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[311][FALSEVAL] = ActionEntry(SHIFT, 141);
}
void Cego::loadParser218()
{
   _actionMap[311][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[311][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[311][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[311][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[311][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[311][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[311][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[311][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[311][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[311][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[311][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[311][ObjSpec] = 122;
   _jumpMap[311][Constant] = 121;
   _jumpMap[311][SignedFloat] = 120;
   _jumpMap[311][SignedInt] = 119;
   _jumpMap[311][Attribute] = 118;
   _jumpMap[311][ExpressionList] = 492;
   _jumpMap[311][Function] = 117;
   _jumpMap[311][Factor] = 116;
   _jumpMap[311][Term] = 115;
   _jumpMap[311][Expr] = 468;
   _jumpMap[311][CasePrepare] = 113;
   _jumpMap[311][CaseClause] = 112;
   _actionMap[312][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[312][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[312][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[312][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[312][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[312][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[312][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[312][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[312][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[312][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[312][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[312][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[312][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[312][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[312][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[312][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[312][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[312][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[312][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[312][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[312][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[312][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[312][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[312][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[312][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[312][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[312][RANDINT] = ActionEntry(SHIFT, 161);
}
void Cego::loadParser219()
{
   _actionMap[312][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[312][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[312][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[312][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[312][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[312][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[312][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[312][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[312][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[312][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[312][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[312][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[312][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[312][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[312][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[312][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[312][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[312][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[312][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[312][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[312][LB] = ActionEntry(SHIFT, 178);
   _actionMap[312][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[312][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[312][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[312][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[312][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[312][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[312][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[312][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[312][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[312][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[312][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[312][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[312][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[312][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[312][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[312][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[312][ObjSpec] = 122;
   _jumpMap[312][Constant] = 121;
   _jumpMap[312][SignedFloat] = 120;
   _jumpMap[312][SignedInt] = 119;
   _jumpMap[312][Attribute] = 118;
   _jumpMap[312][ExpressionList] = 493;
   _jumpMap[312][Function] = 117;
   _jumpMap[312][Factor] = 116;
   _jumpMap[312][Term] = 115;
   _jumpMap[312][Expr] = 468;
   _jumpMap[312][CasePrepare] = 113;
   _jumpMap[312][CaseClause] = 112;
   _actionMap[313][FLOATVAL] = ActionEntry(SHIFT, 181);
}
void Cego::loadParser220()
{
   _actionMap[313][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[313][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[313][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[313][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[313][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[313][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[313][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[313][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[313][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[313][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[313][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[313][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[313][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[313][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[313][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[313][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[313][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[313][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[313][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[313][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[313][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[313][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[313][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[313][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[313][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[313][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[313][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[313][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[313][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[313][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[313][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[313][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[313][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[313][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[313][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[313][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[313][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[313][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[313][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[313][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[313][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[313][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[313][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[313][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[313][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[313][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[313][LB] = ActionEntry(SHIFT, 178);
   _actionMap[313][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[313][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[313][NULLTOKEN] = ActionEntry(SHIFT, 158);
}
void Cego::loadParser221()
{
   _actionMap[313][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[313][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[313][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[313][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[313][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[313][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[313][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[313][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[313][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[313][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[313][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[313][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[313][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[313][ObjSpec] = 122;
   _jumpMap[313][Constant] = 121;
   _jumpMap[313][SignedFloat] = 120;
   _jumpMap[313][SignedInt] = 119;
   _jumpMap[313][Attribute] = 118;
   _jumpMap[313][ExpressionList] = 494;
   _jumpMap[313][Function] = 117;
   _jumpMap[313][Factor] = 116;
   _jumpMap[313][Term] = 115;
   _jumpMap[313][Expr] = 468;
   _jumpMap[313][CasePrepare] = 113;
   _jumpMap[313][CaseClause] = 112;
   _actionMap[314][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[314][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[314][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[314][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[314][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[314][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[314][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[314][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[314][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[314][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[314][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[314][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[314][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[314][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[314][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[314][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[314][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[314][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[314][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[314][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[314][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[314][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[314][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[314][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[314][STR2LONG] = ActionEntry(SHIFT, 173);
}
void Cego::loadParser222()
{
   _actionMap[314][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[314][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[314][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[314][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[314][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[314][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[314][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[314][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[314][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[314][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[314][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[314][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[314][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[314][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[314][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[314][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[314][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[314][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[314][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[314][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[314][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[314][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[314][LB] = ActionEntry(SHIFT, 178);
   _actionMap[314][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[314][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[314][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[314][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[314][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[314][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[314][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[314][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[314][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[314][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[314][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[314][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[314][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[314][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[314][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[314][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[314][ObjSpec] = 122;
   _jumpMap[314][Constant] = 121;
   _jumpMap[314][SignedFloat] = 120;
   _jumpMap[314][SignedInt] = 119;
   _jumpMap[314][Attribute] = 118;
   _jumpMap[314][ExpressionList] = 495;
   _jumpMap[314][Function] = 117;
   _jumpMap[314][Factor] = 116;
   _jumpMap[314][Term] = 115;
   _jumpMap[314][Expr] = 468;
   _jumpMap[314][CasePrepare] = 113;
}
void Cego::loadParser223()
{
   _jumpMap[314][CaseClause] = 112;
   _actionMap[315][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[315][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[315][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[315][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[315][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[315][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[315][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[315][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[315][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[315][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[315][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[315][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[315][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[315][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[315][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[315][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[315][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[315][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[315][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[315][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[315][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[315][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[315][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[315][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[315][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[315][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[315][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[315][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[315][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[315][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[315][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[315][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[315][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[315][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[315][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[315][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[315][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[315][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[315][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[315][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[315][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[315][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[315][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[315][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[315][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[315][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[315][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[315][LB] = ActionEntry(SHIFT, 178);
   _actionMap[315][STRINGVAL] = ActionEntry(SHIFT, 123);
}
void Cego::loadParser224()
{
   _actionMap[315][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[315][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[315][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[315][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[315][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[315][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[315][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[315][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[315][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[315][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[315][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[315][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[315][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[315][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[315][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[315][ObjSpec] = 122;
   _jumpMap[315][Constant] = 121;
   _jumpMap[315][SignedFloat] = 120;
   _jumpMap[315][SignedInt] = 119;
   _jumpMap[315][Attribute] = 118;
   _jumpMap[315][ExpressionList] = 496;
   _jumpMap[315][Function] = 117;
   _jumpMap[315][Factor] = 116;
   _jumpMap[315][Term] = 115;
   _jumpMap[315][Expr] = 468;
   _jumpMap[315][CasePrepare] = 113;
   _jumpMap[315][CaseClause] = 112;
   _actionMap[316][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[316][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[316][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[316][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[316][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[316][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[316][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[316][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[316][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[316][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[316][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[316][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[316][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[316][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[316][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[316][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[316][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[316][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[316][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[316][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[316][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[316][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[316][TRUNC] = ActionEntry(SHIFT, 176);
}
void Cego::loadParser225()
{
   _actionMap[316][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[316][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[316][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[316][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[316][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[316][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[316][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[316][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[316][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[316][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[316][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[316][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[316][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[316][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[316][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[316][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[316][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[316][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[316][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[316][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[316][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[316][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[316][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[316][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[316][LB] = ActionEntry(SHIFT, 178);
   _actionMap[316][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[316][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[316][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[316][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[316][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[316][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[316][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[316][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[316][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[316][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[316][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[316][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[316][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[316][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[316][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[316][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[316][ObjSpec] = 122;
   _jumpMap[316][Constant] = 121;
   _jumpMap[316][SignedFloat] = 120;
   _jumpMap[316][SignedInt] = 119;
   _jumpMap[316][Attribute] = 118;
   _jumpMap[316][ExpressionList] = 497;
   _jumpMap[316][Function] = 117;
   _jumpMap[316][Factor] = 116;
   _jumpMap[316][Term] = 115;
}
void Cego::loadParser226()
{
   _jumpMap[316][Expr] = 468;
   _jumpMap[316][CasePrepare] = 113;
   _jumpMap[316][CaseClause] = 112;
   _actionMap[317][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[317][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[317][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[317][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[317][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[317][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[317][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[317][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[317][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[317][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[317][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[317][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[317][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[317][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[317][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[317][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[317][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[317][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[317][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[317][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[317][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[317][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[317][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[317][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[317][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[317][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[317][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[317][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[317][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[317][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[317][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[317][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[317][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[317][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[317][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[317][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[317][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[317][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[317][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[317][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[317][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[317][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[317][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[317][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[317][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[317][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[317][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
}
void Cego::loadParser227()
{
   _actionMap[317][LB] = ActionEntry(SHIFT, 178);
   _actionMap[317][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[317][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[317][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[317][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[317][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[317][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[317][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[317][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[317][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[317][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[317][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[317][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[317][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[317][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[317][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[317][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[317][ObjSpec] = 122;
   _jumpMap[317][Constant] = 121;
   _jumpMap[317][SignedFloat] = 120;
   _jumpMap[317][SignedInt] = 119;
   _jumpMap[317][Attribute] = 118;
   _jumpMap[317][ExpressionList] = 498;
   _jumpMap[317][Function] = 117;
   _jumpMap[317][Factor] = 116;
   _jumpMap[317][Term] = 115;
   _jumpMap[317][Expr] = 468;
   _jumpMap[317][CasePrepare] = 113;
   _jumpMap[317][CaseClause] = 112;
   _actionMap[318][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[318][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[318][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[318][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[318][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[318][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[318][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[318][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[318][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[318][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[318][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[318][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[318][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[318][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[318][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[318][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[318][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[318][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[318][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[318][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[318][REPLACE] = ActionEntry(SHIFT, 163);
}
void Cego::loadParser228()
{
   _actionMap[318][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[318][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[318][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[318][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[318][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[318][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[318][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[318][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[318][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[318][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[318][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[318][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[318][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[318][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[318][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[318][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[318][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[318][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[318][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[318][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[318][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[318][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[318][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[318][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[318][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[318][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[318][LB] = ActionEntry(SHIFT, 178);
   _actionMap[318][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[318][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[318][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[318][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[318][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[318][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[318][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[318][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[318][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[318][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[318][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[318][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[318][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[318][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[318][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[318][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[318][ObjSpec] = 122;
   _jumpMap[318][Constant] = 121;
   _jumpMap[318][SignedFloat] = 120;
   _jumpMap[318][SignedInt] = 119;
   _jumpMap[318][Attribute] = 118;
   _jumpMap[318][ExpressionList] = 499;
   _jumpMap[318][Function] = 117;
}
void Cego::loadParser229()
{
   _jumpMap[318][Factor] = 116;
   _jumpMap[318][Term] = 115;
   _jumpMap[318][Expr] = 468;
   _jumpMap[318][CasePrepare] = 113;
   _jumpMap[318][CaseClause] = 112;
   _actionMap[319][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[319][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[319][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[319][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[319][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[319][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[319][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[319][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[319][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[319][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[319][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[319][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[319][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[319][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[319][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[319][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[319][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[319][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[319][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[319][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[319][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[319][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[319][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[319][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[319][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[319][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[319][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[319][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[319][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[319][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[319][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[319][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[319][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[319][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[319][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[319][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[319][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[319][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[319][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[319][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[319][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[319][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[319][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[319][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[319][IDENTIFIER] = ActionEntry(SHIFT, 182);
}
void Cego::loadParser230()
{
   _actionMap[319][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[319][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[319][LB] = ActionEntry(SHIFT, 178);
   _actionMap[319][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[319][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[319][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[319][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[319][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[319][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[319][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[319][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[319][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[319][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[319][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[319][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[319][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[319][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[319][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[319][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[319][ObjSpec] = 122;
   _jumpMap[319][Constant] = 121;
   _jumpMap[319][SignedFloat] = 120;
   _jumpMap[319][SignedInt] = 119;
   _jumpMap[319][Attribute] = 118;
   _jumpMap[319][Function] = 117;
   _jumpMap[319][Factor] = 116;
   _jumpMap[319][Term] = 115;
   _jumpMap[319][Expr] = 500;
   _jumpMap[319][CasePrepare] = 113;
   _jumpMap[319][CaseClause] = 112;
   _actionMap[320][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[320][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[320][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[320][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[320][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[320][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[320][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[320][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[320][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[320][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[320][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[320][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[320][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[320][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[320][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[320][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[320][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[320][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[320][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[320][SUBSTR] = ActionEntry(SHIFT, 169);
}
void Cego::loadParser231()
{
   _actionMap[320][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[320][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[320][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[320][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[320][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[320][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[320][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[320][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[320][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[320][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[320][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[320][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[320][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[320][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[320][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[320][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[320][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[320][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[320][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[320][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[320][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[320][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[320][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[320][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[320][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[320][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[320][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[320][LB] = ActionEntry(SHIFT, 178);
   _actionMap[320][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[320][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[320][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[320][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[320][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[320][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[320][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[320][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[320][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[320][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[320][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[320][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[320][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[320][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[320][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[320][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[320][ObjSpec] = 122;
   _jumpMap[320][Constant] = 121;
   _jumpMap[320][SignedFloat] = 120;
   _jumpMap[320][SignedInt] = 119;
   _jumpMap[320][Attribute] = 118;
   _jumpMap[320][Function] = 117;
}
void Cego::loadParser232()
{
   _jumpMap[320][Factor] = 116;
   _jumpMap[320][Term] = 115;
   _jumpMap[320][Expr] = 501;
   _jumpMap[320][CasePrepare] = 113;
   _jumpMap[320][CaseClause] = 112;
   _actionMap[321][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[321][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[321][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[321][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[321][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[321][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[321][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[321][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[321][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[321][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[321][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[321][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[321][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[321][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[321][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[321][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[321][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[321][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[321][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[321][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[321][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[321][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[321][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[321][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[321][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[321][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[321][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[321][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[321][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[321][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[321][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[321][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[321][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[321][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[321][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[321][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[321][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[321][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[321][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[321][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[321][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[321][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[321][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[321][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[321][IDENTIFIER] = ActionEntry(SHIFT, 182);
}
void Cego::loadParser233()
{
   _actionMap[321][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[321][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[321][LB] = ActionEntry(SHIFT, 178);
   _actionMap[321][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[321][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[321][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[321][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[321][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[321][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[321][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[321][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[321][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[321][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[321][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[321][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[321][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[321][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[321][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[321][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[321][ObjSpec] = 122;
   _jumpMap[321][Constant] = 121;
   _jumpMap[321][SignedFloat] = 120;
   _jumpMap[321][SignedInt] = 119;
   _jumpMap[321][Attribute] = 118;
   _jumpMap[321][ExpressionList] = 502;
   _jumpMap[321][Function] = 117;
   _jumpMap[321][Factor] = 116;
   _jumpMap[321][Term] = 115;
   _jumpMap[321][Expr] = 468;
   _jumpMap[321][CasePrepare] = 113;
   _jumpMap[321][CaseClause] = 112;
   _actionMap[322][IDENTIFIER] = ActionEntry(SHIFT, 503);
   _actionMap[323][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[323][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[323][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[323][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[323][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[323][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[323][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[323][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[323][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[323][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[323][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[323][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[323][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[323][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[323][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[323][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[323][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[323][RIGHT] = ActionEntry(SHIFT, 164);
}
void Cego::loadParser234()
{
   _actionMap[323][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[323][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[323][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[323][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[323][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[323][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[323][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[323][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[323][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[323][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[323][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[323][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[323][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[323][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[323][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[323][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[323][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[323][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[323][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[323][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[323][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[323][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[323][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[323][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[323][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[323][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[323][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[323][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[323][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[323][LB] = ActionEntry(SHIFT, 178);
   _actionMap[323][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[323][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[323][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[323][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[323][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[323][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[323][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[323][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[323][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[323][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[323][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[323][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[323][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[323][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[323][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[323][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[323][ObjSpec] = 122;
   _jumpMap[323][Constant] = 121;
   _jumpMap[323][SignedFloat] = 120;
   _jumpMap[323][SignedInt] = 119;
}
void Cego::loadParser235()
{
   _jumpMap[323][Attribute] = 118;
   _jumpMap[323][ExpressionList] = 504;
   _jumpMap[323][Function] = 117;
   _jumpMap[323][Factor] = 116;
   _jumpMap[323][Term] = 115;
   _jumpMap[323][Expr] = 468;
   _jumpMap[323][CasePrepare] = 113;
   _jumpMap[323][CaseClause] = 112;
   _actionMap[324][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[324][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[324][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[324][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[324][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[324][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[324][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[324][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[324][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[324][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[324][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[324][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[324][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[324][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[324][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[324][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[324][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[324][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[324][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[324][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[324][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[324][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[324][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[324][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[324][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[324][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[324][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[324][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[324][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[324][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[324][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[324][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[324][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[324][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[324][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[324][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[324][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[324][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[324][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[324][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[324][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[324][NEXTCOUNT] = ActionEntry(SHIFT, 157);
}
void Cego::loadParser236()
{
   _actionMap[324][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[324][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[324][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[324][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[324][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[324][LB] = ActionEntry(SHIFT, 178);
   _actionMap[324][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[324][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[324][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[324][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[324][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[324][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[324][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[324][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[324][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[324][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[324][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[324][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[324][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[324][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[324][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[324][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[324][ObjSpec] = 122;
   _jumpMap[324][Constant] = 121;
   _jumpMap[324][SignedFloat] = 120;
   _jumpMap[324][SignedInt] = 119;
   _jumpMap[324][Attribute] = 118;
   _jumpMap[324][ExpressionList] = 505;
   _jumpMap[324][Function] = 117;
   _jumpMap[324][Factor] = 116;
   _jumpMap[324][Term] = 115;
   _jumpMap[324][Expr] = 468;
   _jumpMap[324][CasePrepare] = 113;
   _jumpMap[324][CaseClause] = 112;
   _actionMap[325][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[325][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[325][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[325][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[325][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[325][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[325][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[325][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[325][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[325][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[325][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[325][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[325][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[325][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[325][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[325][UPPER] = ActionEntry(SHIFT, 177);
}
void Cego::loadParser237()
{
   _actionMap[325][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[325][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[325][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[325][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[325][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[325][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[325][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[325][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[325][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[325][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[325][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[325][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[325][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[325][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[325][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[325][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[325][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[325][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[325][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[325][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[325][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[325][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[325][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[325][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[325][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[325][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[325][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[325][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[325][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[325][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[325][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[325][LB] = ActionEntry(SHIFT, 178);
   _actionMap[325][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[325][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[325][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[325][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[325][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[325][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[325][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[325][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[325][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[325][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[325][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[325][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[325][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[325][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[325][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[325][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[325][ObjSpec] = 122;
   _jumpMap[325][Constant] = 121;
}
void Cego::loadParser238()
{
   _jumpMap[325][SignedFloat] = 120;
   _jumpMap[325][SignedInt] = 119;
   _jumpMap[325][Attribute] = 118;
   _jumpMap[325][ExpressionList] = 506;
   _jumpMap[325][Function] = 117;
   _jumpMap[325][Factor] = 116;
   _jumpMap[325][Term] = 115;
   _jumpMap[325][Expr] = 468;
   _jumpMap[325][CasePrepare] = 113;
   _jumpMap[325][CaseClause] = 112;
   _actionMap[326][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[326][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[326][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[326][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[326][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[326][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[326][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[326][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[326][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[326][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[326][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[326][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[326][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[326][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[326][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[326][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[326][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[326][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[326][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[326][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[326][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[326][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[326][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[326][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[326][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[326][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[326][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[326][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[326][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[326][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[326][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[326][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[326][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[326][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[326][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[326][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[326][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[326][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[326][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[326][CLOB2STR] = ActionEntry(SHIFT, 136);
}
void Cego::loadParser239()
{
   _actionMap[326][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[326][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[326][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[326][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[326][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[326][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[326][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[326][LB] = ActionEntry(SHIFT, 178);
   _actionMap[326][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[326][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[326][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[326][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[326][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[326][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[326][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[326][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[326][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[326][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[326][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[326][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[326][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[326][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[326][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[326][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[326][ObjSpec] = 122;
   _jumpMap[326][Constant] = 121;
   _jumpMap[326][SignedFloat] = 120;
   _jumpMap[326][SignedInt] = 119;
   _jumpMap[326][Attribute] = 118;
   _jumpMap[326][ExpressionList] = 507;
   _jumpMap[326][Function] = 117;
   _jumpMap[326][Factor] = 116;
   _jumpMap[326][Term] = 115;
   _jumpMap[326][Expr] = 468;
   _jumpMap[326][CasePrepare] = 113;
   _jumpMap[326][CaseClause] = 112;
   _actionMap[327][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[327][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[327][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[327][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[327][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[327][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[327][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[327][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[327][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[327][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[327][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[327][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[327][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[327][NEWDATE] = ActionEntry(SHIFT, 146);
}
void Cego::loadParser240()
{
   _actionMap[327][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[327][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[327][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[327][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[327][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[327][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[327][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[327][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[327][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[327][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[327][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[327][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[327][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[327][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[327][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[327][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[327][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[327][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[327][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[327][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[327][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[327][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[327][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[327][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[327][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[327][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[327][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[327][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[327][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[327][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[327][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[327][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[327][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[327][LB] = ActionEntry(SHIFT, 178);
   _actionMap[327][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[327][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[327][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[327][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[327][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[327][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[327][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[327][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[327][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[327][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[327][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[327][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[327][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[327][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[327][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[327][MAX] = ActionEntry(SHIFT, 155);
}
void Cego::loadParser241()
{
   _jumpMap[327][ObjSpec] = 122;
   _jumpMap[327][Constant] = 121;
   _jumpMap[327][SignedFloat] = 120;
   _jumpMap[327][SignedInt] = 119;
   _jumpMap[327][Attribute] = 118;
   _jumpMap[327][ExpressionList] = 508;
   _jumpMap[327][Function] = 117;
   _jumpMap[327][Factor] = 116;
   _jumpMap[327][Term] = 115;
   _jumpMap[327][Expr] = 468;
   _jumpMap[327][CasePrepare] = 113;
   _jumpMap[327][CaseClause] = 112;
   _actionMap[328][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[328][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[328][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[328][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[328][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[328][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[328][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[328][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[328][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[328][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[328][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[328][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[328][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[328][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[328][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[328][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[328][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[328][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[328][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[328][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[328][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[328][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[328][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[328][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[328][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[328][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[328][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[328][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[328][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[328][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[328][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[328][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[328][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[328][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[328][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[328][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[328][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[328][CLOBSIZE] = ActionEntry(SHIFT, 134);
}
void Cego::loadParser242()
{
   _actionMap[328][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[328][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[328][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[328][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[328][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[328][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[328][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[328][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[328][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[328][LB] = ActionEntry(SHIFT, 178);
   _actionMap[328][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[328][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[328][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[328][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[328][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[328][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[328][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[328][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[328][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[328][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[328][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[328][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[328][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[328][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[328][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[328][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[328][ObjSpec] = 122;
   _jumpMap[328][Constant] = 121;
   _jumpMap[328][SignedFloat] = 120;
   _jumpMap[328][SignedInt] = 119;
   _jumpMap[328][Attribute] = 118;
   _jumpMap[328][ExpressionList] = 509;
   _jumpMap[328][Function] = 117;
   _jumpMap[328][Factor] = 116;
   _jumpMap[328][Term] = 115;
   _jumpMap[328][Expr] = 468;
   _jumpMap[328][CasePrepare] = 113;
   _jumpMap[328][CaseClause] = 112;
   _actionMap[329][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[329][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[329][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[329][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[329][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[329][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[329][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[329][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[329][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[329][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[329][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[329][DATE2LONG] = ActionEntry(SHIFT, 139);
}
void Cego::loadParser243()
{
   _actionMap[329][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[329][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[329][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[329][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[329][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[329][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[329][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[329][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[329][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[329][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[329][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[329][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[329][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[329][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[329][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[329][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[329][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[329][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[329][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[329][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[329][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[329][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[329][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[329][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[329][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[329][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[329][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[329][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[329][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[329][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[329][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[329][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[329][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[329][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[329][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[329][LB] = ActionEntry(SHIFT, 178);
   _actionMap[329][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[329][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[329][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[329][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[329][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[329][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[329][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[329][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[329][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[329][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[329][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[329][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[329][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[329][AVG] = ActionEntry(SHIFT, 125);
}
void Cego::loadParser244()
{
   _actionMap[329][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[329][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[329][ObjSpec] = 122;
   _jumpMap[329][Constant] = 121;
   _jumpMap[329][SignedFloat] = 120;
   _jumpMap[329][SignedInt] = 119;
   _jumpMap[329][Attribute] = 118;
   _jumpMap[329][ExpressionList] = 510;
   _jumpMap[329][Function] = 117;
   _jumpMap[329][Factor] = 116;
   _jumpMap[329][Term] = 115;
   _jumpMap[329][Expr] = 468;
   _jumpMap[329][CasePrepare] = 113;
   _jumpMap[329][CaseClause] = 112;
   _actionMap[330][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[330][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[330][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[330][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[330][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[330][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[330][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[330][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[330][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[330][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[330][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[330][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[330][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[330][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[330][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[330][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[330][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[330][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[330][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[330][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[330][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[330][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[330][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[330][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[330][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[330][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[330][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[330][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[330][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[330][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[330][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[330][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[330][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[330][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[330][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[330][BLOBSIZE] = ActionEntry(SHIFT, 130);
}
void Cego::loadParser245()
{
   _actionMap[330][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[330][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[330][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[330][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[330][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[330][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[330][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[330][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[330][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[330][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[330][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[330][LB] = ActionEntry(SHIFT, 178);
   _actionMap[330][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[330][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[330][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[330][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[330][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[330][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[330][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[330][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[330][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[330][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[330][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[330][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[330][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[330][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[330][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[330][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[330][ObjSpec] = 122;
   _jumpMap[330][Constant] = 121;
   _jumpMap[330][SignedFloat] = 120;
   _jumpMap[330][SignedInt] = 119;
   _jumpMap[330][Attribute] = 118;
   _jumpMap[330][ExpressionList] = 511;
   _jumpMap[330][Function] = 117;
   _jumpMap[330][Factor] = 116;
   _jumpMap[330][Term] = 115;
   _jumpMap[330][Expr] = 468;
   _jumpMap[330][CasePrepare] = 113;
   _jumpMap[330][CaseClause] = 112;
   _actionMap[331][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[331][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[331][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[331][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[331][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[331][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[331][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[331][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[331][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[331][SCANDATE] = ActionEntry(SHIFT, 167);
}
void Cego::loadParser246()
{
   _actionMap[331][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[331][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[331][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[331][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[331][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[331][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[331][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[331][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[331][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[331][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[331][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[331][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[331][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[331][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[331][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[331][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[331][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[331][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[331][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[331][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[331][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[331][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[331][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[331][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[331][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[331][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[331][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[331][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[331][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[331][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[331][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[331][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[331][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[331][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[331][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[331][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[331][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[331][LB] = ActionEntry(SHIFT, 178);
   _actionMap[331][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[331][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[331][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[331][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[331][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[331][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[331][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[331][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[331][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[331][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[331][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[331][COUNT] = ActionEntry(SHIFT, 137);
}
void Cego::loadParser247()
{
   _actionMap[331][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[331][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[331][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[331][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[331][ObjSpec] = 122;
   _jumpMap[331][Constant] = 121;
   _jumpMap[331][SignedFloat] = 120;
   _jumpMap[331][SignedInt] = 119;
   _jumpMap[331][Attribute] = 118;
   _jumpMap[331][ExpressionList] = 512;
   _jumpMap[331][Function] = 117;
   _jumpMap[331][Factor] = 116;
   _jumpMap[331][Term] = 115;
   _jumpMap[331][Expr] = 468;
   _jumpMap[331][CasePrepare] = 113;
   _jumpMap[331][CaseClause] = 112;
   _actionMap[332][IDENTIFIER] = ActionEntry(SHIFT, 513);
   _actionMap[333][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[333][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[333][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[333][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[333][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[333][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[333][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[333][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[333][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[333][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[333][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[333][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[333][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[333][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[333][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[333][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[333][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[333][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[333][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[333][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[333][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[333][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[333][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[333][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[333][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[333][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[333][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[333][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[333][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[333][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[333][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[333][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[333][BITAND] = ActionEntry(SHIFT, 126);
}
void Cego::loadParser248()
{
   _actionMap[333][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[333][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[333][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[333][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[333][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[333][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[333][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[333][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[333][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[333][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[333][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[333][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[333][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[333][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[333][LB] = ActionEntry(SHIFT, 178);
   _actionMap[333][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[333][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[333][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[333][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[333][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[333][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[333][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[333][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[333][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[333][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[333][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[333][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[333][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[333][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[333][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[333][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[333][ObjSpec] = 122;
   _jumpMap[333][Constant] = 121;
   _jumpMap[333][SignedFloat] = 120;
   _jumpMap[333][SignedInt] = 119;
   _jumpMap[333][Attribute] = 118;
   _jumpMap[333][ExpressionList] = 514;
   _jumpMap[333][Function] = 117;
   _jumpMap[333][Factor] = 116;
   _jumpMap[333][Term] = 115;
   _jumpMap[333][Expr] = 468;
   _jumpMap[333][CasePrepare] = 113;
   _jumpMap[333][CaseClause] = 112;
   _actionMap[334][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[334][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[334][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[334][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[334][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[334][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[334][RTRIM] = ActionEntry(SHIFT, 166);
}
void Cego::loadParser249()
{
   _actionMap[334][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[334][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[334][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[334][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[334][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[334][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[334][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[334][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[334][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[334][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[334][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[334][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[334][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[334][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[334][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[334][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[334][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[334][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[334][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[334][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[334][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[334][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[334][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[334][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[334][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[334][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[334][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[334][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[334][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[334][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[334][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[334][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[334][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[334][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[334][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[334][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[334][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[334][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[334][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[334][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[334][LB] = ActionEntry(SHIFT, 178);
   _actionMap[334][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[334][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[334][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[334][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[334][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[334][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[334][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[334][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[334][CASE] = ActionEntry(SHIFT, 132);
}
void Cego::loadParser250()
{
   _actionMap[334][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[334][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[334][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[334][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[334][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[334][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[334][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[334][ObjSpec] = 122;
   _jumpMap[334][Constant] = 121;
   _jumpMap[334][SignedFloat] = 120;
   _jumpMap[334][SignedInt] = 119;
   _jumpMap[334][Attribute] = 118;
   _jumpMap[334][Function] = 117;
   _jumpMap[334][Factor] = 116;
   _jumpMap[334][Term] = 115;
   _jumpMap[334][Expr] = 515;
   _jumpMap[334][CasePrepare] = 113;
   _jumpMap[334][CaseClause] = 112;
   _actionMap[335][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[335][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[335][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[335][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[335][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[335][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[335][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[335][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[335][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[335][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[335][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[335][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[335][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[335][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[335][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[335][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[335][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[335][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[335][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[335][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[335][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[335][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[335][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[335][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[335][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[335][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[335][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[335][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[335][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[335][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[335][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[335][POWER] = ActionEntry(SHIFT, 159);
}
void Cego::loadParser251()
{
   _actionMap[335][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[335][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[335][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[335][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[335][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[335][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[335][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[335][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[335][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[335][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[335][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[335][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[335][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[335][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[335][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[335][LB] = ActionEntry(SHIFT, 178);
   _actionMap[335][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[335][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[335][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[335][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[335][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[335][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[335][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[335][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[335][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[335][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[335][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[335][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[335][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[335][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[335][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[335][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[335][ObjSpec] = 122;
   _jumpMap[335][Constant] = 121;
   _jumpMap[335][SignedFloat] = 120;
   _jumpMap[335][SignedInt] = 119;
   _jumpMap[335][Attribute] = 118;
   _jumpMap[335][ExpressionList] = 516;
   _jumpMap[335][Function] = 117;
   _jumpMap[335][Factor] = 116;
   _jumpMap[335][Term] = 115;
   _jumpMap[335][Expr] = 468;
   _jumpMap[335][CasePrepare] = 113;
   _jumpMap[335][CaseClause] = 112;
   _actionMap[336][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[336][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[336][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[336][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[336][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[336][TRIM] = ActionEntry(SHIFT, 174);
}
void Cego::loadParser252()
{
   _actionMap[336][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[336][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[336][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[336][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[336][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[336][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[336][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[336][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[336][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[336][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[336][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[336][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[336][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[336][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[336][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[336][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[336][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[336][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[336][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[336][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[336][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[336][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[336][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[336][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[336][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[336][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[336][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[336][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[336][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[336][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[336][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[336][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[336][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[336][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[336][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[336][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[336][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[336][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[336][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[336][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[336][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[336][LB] = ActionEntry(SHIFT, 178);
   _actionMap[336][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[336][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[336][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[336][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[336][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[336][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[336][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[336][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
}
void Cego::loadParser253()
{
   _actionMap[336][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[336][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[336][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[336][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[336][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[336][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[336][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[336][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[336][ObjSpec] = 122;
   _jumpMap[336][Constant] = 121;
   _jumpMap[336][SignedFloat] = 120;
   _jumpMap[336][SignedInt] = 119;
   _jumpMap[336][Attribute] = 118;
   _jumpMap[336][ExpressionList] = 517;
   _jumpMap[336][Function] = 117;
   _jumpMap[336][Factor] = 116;
   _jumpMap[336][Term] = 115;
   _jumpMap[336][Expr] = 468;
   _jumpMap[336][CasePrepare] = 113;
   _jumpMap[336][CaseClause] = 112;
   _actionMap[337][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[337][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[337][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[337][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[337][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[337][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[337][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[337][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[337][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[337][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[337][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[337][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[337][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[337][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[337][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[337][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[337][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[337][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[337][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[337][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[337][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[337][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[337][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[337][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[337][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[337][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[337][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[337][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[337][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[337][LMOD] = ActionEntry(SHIFT, 151);
}
void Cego::loadParser254()
{
   _actionMap[337][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[337][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[337][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[337][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[337][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[337][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[337][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[337][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[337][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[337][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[337][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[337][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[337][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[337][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[337][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[337][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[337][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[337][LB] = ActionEntry(SHIFT, 178);
   _actionMap[337][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[337][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[337][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[337][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[337][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[337][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[337][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[337][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[337][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[337][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[337][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[337][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[337][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[337][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[337][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[337][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[337][ObjSpec] = 122;
   _jumpMap[337][Constant] = 121;
   _jumpMap[337][SignedFloat] = 120;
   _jumpMap[337][SignedInt] = 119;
   _jumpMap[337][Attribute] = 118;
   _jumpMap[337][ExpressionList] = 518;
   _jumpMap[337][Function] = 117;
   _jumpMap[337][Factor] = 116;
   _jumpMap[337][Term] = 115;
   _jumpMap[337][Expr] = 468;
   _jumpMap[337][CasePrepare] = 113;
   _jumpMap[337][CaseClause] = 112;
   _actionMap[338][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[338][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[338][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[338][INT2ASC] = ActionEntry(SHIFT, 147);
}
void Cego::loadParser255()
{
   _actionMap[338][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[338][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[338][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[338][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[338][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[338][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[338][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[338][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[338][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[338][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[338][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[338][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[338][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[338][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[338][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[338][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[338][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[338][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[338][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[338][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[338][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[338][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[338][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[338][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[338][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[338][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[338][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[338][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[338][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[338][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[338][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[338][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[338][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[338][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[338][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[338][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[338][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[338][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[338][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[338][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[338][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[338][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[338][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[338][LB] = ActionEntry(SHIFT, 178);
   _actionMap[338][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[338][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[338][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[338][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[338][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[338][BLOB] = ActionEntry(SHIFT, 129);
}
void Cego::loadParser256()
{
   _actionMap[338][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[338][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[338][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[338][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[338][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[338][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[338][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[338][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[338][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[338][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[338][ObjSpec] = 122;
   _jumpMap[338][Constant] = 121;
   _jumpMap[338][SignedFloat] = 120;
   _jumpMap[338][SignedInt] = 119;
   _jumpMap[338][Attribute] = 118;
   _jumpMap[338][ExpressionList] = 519;
   _jumpMap[338][Function] = 117;
   _jumpMap[338][Factor] = 116;
   _jumpMap[338][Term] = 115;
   _jumpMap[338][Expr] = 468;
   _jumpMap[338][CasePrepare] = 113;
   _jumpMap[338][CaseClause] = 112;
   _actionMap[339][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[339][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[339][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[339][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[339][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[339][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[339][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[339][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[339][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[339][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[339][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[339][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[339][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[339][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[339][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[339][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[339][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[339][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[339][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[339][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[339][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[339][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[339][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[339][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[339][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[339][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[339][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[339][MOD] = ActionEntry(SHIFT, 156);
}
void Cego::loadParser257()
{
   _actionMap[339][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[339][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[339][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[339][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[339][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[339][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[339][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[339][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[339][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[339][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[339][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[339][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[339][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[339][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[339][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[339][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[339][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[339][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[339][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[339][LB] = ActionEntry(SHIFT, 178);
   _actionMap[339][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[339][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[339][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[339][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[339][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[339][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[339][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[339][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[339][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[339][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[339][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[339][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[339][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[339][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[339][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[339][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[339][ObjSpec] = 122;
   _jumpMap[339][Constant] = 121;
   _jumpMap[339][SignedFloat] = 120;
   _jumpMap[339][SignedInt] = 119;
   _jumpMap[339][Attribute] = 118;
   _jumpMap[339][ExpressionList] = 520;
   _jumpMap[339][Function] = 117;
   _jumpMap[339][Factor] = 116;
   _jumpMap[339][Term] = 115;
   _jumpMap[339][Expr] = 468;
   _jumpMap[339][CasePrepare] = 113;
   _jumpMap[339][CaseClause] = 112;
   _actionMap[340][RB] = ActionEntry(SHIFT, 521);
   _actionMap[341][RB] = ActionEntry(SHIFT, 522);
}
void Cego::loadParser258()
{
   _actionMap[341][OR] = ActionEntry(SHIFT, 444);
   _actionMap[342][RB] = ActionEntry(SHIFT, 523);
   _actionMap[343][RB] = ActionEntry(SHIFT, 524);
   _actionMap[344][RB] = ActionEntry(SHIFT, 525);
   _actionMap[345][RB] = ActionEntry(SHIFT, 526);
   _actionMap[346][RB] = ActionEntry(SHIFT, 527);
   _actionMap[347][RB] = ActionEntry(SHIFT, 528);
   _actionMap[348][RB] = ActionEntry(SHIFT, 529);
   _actionMap[349][WHEN] = ActionEntry(REDUCE, 406);
   _actionMap[349][ELSE] = ActionEntry(REDUCE, 406);
   _actionMap[349][AS] = ActionEntry(REDUCE, 406);
   _actionMap[349][FROM] = ActionEntry(REDUCE, 406);
   _actionMap[349][END_TOKEN] = ActionEntry(REDUCE, 406);
   _actionMap[349][BEGIN] = ActionEntry(REDUCE, 406);
   _actionMap[349][THEN] = ActionEntry(REDUCE, 406);
   _actionMap[349][LEFT] = ActionEntry(REDUCE, 406);
   _actionMap[349][RIGHT] = ActionEntry(REDUCE, 406);
   _actionMap[349][INNER] = ActionEntry(REDUCE, 406);
   _actionMap[349][JOIN] = ActionEntry(REDUCE, 406);
   _actionMap[349][ORDER] = ActionEntry(REDUCE, 406);
   _actionMap[349][GROUP] = ActionEntry(REDUCE, 406);
   _actionMap[349][RETURNTOKEN] = ActionEntry(REDUCE, 406);
   _actionMap[349][WHERE] = ActionEntry(REDUCE, 406);
   _actionMap[349][NULLTOKEN] = ActionEntry(REDUCE, 406);
   _actionMap[349][OR] = ActionEntry(REDUCE, 406);
   _actionMap[349][AND] = ActionEntry(REDUCE, 406);
   _actionMap[349][NCLIKE] = ActionEntry(REDUCE, 406);
   _actionMap[349][LIKE] = ActionEntry(REDUCE, 406);
   _actionMap[349][IS] = ActionEntry(REDUCE, 406);
   _actionMap[349][BETWEEN] = ActionEntry(REDUCE, 406);
   _actionMap[349][EQU] = ActionEntry(REDUCE, 406);
   _actionMap[349][NEGATION] = ActionEntry(REDUCE, 406);
   _actionMap[349][LT] = ActionEntry(REDUCE, 406);
   _actionMap[349][MT] = ActionEntry(REDUCE, 406);
   _actionMap[349][NOT] = ActionEntry(REDUCE, 406);
   _actionMap[349][INTOK] = ActionEntry(REDUCE, 406);
   _actionMap[349][DESC] = ActionEntry(REDUCE, 406);
   _actionMap[349][ASC] = ActionEntry(REDUCE, 406);
   _actionMap[349][KSEP] = ActionEntry(REDUCE, 406);
   _actionMap[349][ROWLIMIT] = ActionEntry(REDUCE, 406);
   _actionMap[349][UNION] = ActionEntry(REDUCE, 406);
   _actionMap[349][ENDTOKEN] = ActionEntry(REDUCE, 406);
   _actionMap[349][RB] = ActionEntry(REDUCE, 406);
   _actionMap[349][CONCAT] = ActionEntry(REDUCE, 406);
   _actionMap[349][STAR] = ActionEntry(REDUCE, 406);
   _actionMap[349][DIVISION] = ActionEntry(REDUCE, 406);
   _actionMap[349][MINUS] = ActionEntry(REDUCE, 406);
   _actionMap[349][PLUS] = ActionEntry(REDUCE, 406);
   _actionMap[349][SEMICOLON] = ActionEntry(REDUCE, 406);
   _actionMap[350][WHEN] = ActionEntry(REDUCE, 408);
}
void Cego::loadParser259()
{
   _actionMap[350][ELSE] = ActionEntry(REDUCE, 408);
   _actionMap[350][AS] = ActionEntry(REDUCE, 408);
   _actionMap[350][FROM] = ActionEntry(REDUCE, 408);
   _actionMap[350][END_TOKEN] = ActionEntry(REDUCE, 408);
   _actionMap[350][BEGIN] = ActionEntry(REDUCE, 408);
   _actionMap[350][THEN] = ActionEntry(REDUCE, 408);
   _actionMap[350][LEFT] = ActionEntry(REDUCE, 408);
   _actionMap[350][RIGHT] = ActionEntry(REDUCE, 408);
   _actionMap[350][INNER] = ActionEntry(REDUCE, 408);
   _actionMap[350][JOIN] = ActionEntry(REDUCE, 408);
   _actionMap[350][ORDER] = ActionEntry(REDUCE, 408);
   _actionMap[350][GROUP] = ActionEntry(REDUCE, 408);
   _actionMap[350][RETURNTOKEN] = ActionEntry(REDUCE, 408);
   _actionMap[350][WHERE] = ActionEntry(REDUCE, 408);
   _actionMap[350][NULLTOKEN] = ActionEntry(REDUCE, 408);
   _actionMap[350][OR] = ActionEntry(REDUCE, 408);
   _actionMap[350][AND] = ActionEntry(REDUCE, 408);
   _actionMap[350][NCLIKE] = ActionEntry(REDUCE, 408);
   _actionMap[350][LIKE] = ActionEntry(REDUCE, 408);
   _actionMap[350][IS] = ActionEntry(REDUCE, 408);
   _actionMap[350][BETWEEN] = ActionEntry(REDUCE, 408);
   _actionMap[350][EQU] = ActionEntry(REDUCE, 408);
   _actionMap[350][NEGATION] = ActionEntry(REDUCE, 408);
   _actionMap[350][LT] = ActionEntry(REDUCE, 408);
   _actionMap[350][MT] = ActionEntry(REDUCE, 408);
   _actionMap[350][NOT] = ActionEntry(REDUCE, 408);
   _actionMap[350][INTOK] = ActionEntry(REDUCE, 408);
   _actionMap[350][DESC] = ActionEntry(REDUCE, 408);
   _actionMap[350][ASC] = ActionEntry(REDUCE, 408);
   _actionMap[350][KSEP] = ActionEntry(REDUCE, 408);
   _actionMap[350][ROWLIMIT] = ActionEntry(REDUCE, 408);
   _actionMap[350][UNION] = ActionEntry(REDUCE, 408);
   _actionMap[350][ENDTOKEN] = ActionEntry(REDUCE, 408);
   _actionMap[350][RB] = ActionEntry(REDUCE, 408);
   _actionMap[350][CONCAT] = ActionEntry(REDUCE, 408);
   _actionMap[350][STAR] = ActionEntry(REDUCE, 408);
   _actionMap[350][DIVISION] = ActionEntry(REDUCE, 408);
   _actionMap[350][MINUS] = ActionEntry(REDUCE, 408);
   _actionMap[350][PLUS] = ActionEntry(REDUCE, 408);
   _actionMap[350][SEMICOLON] = ActionEntry(REDUCE, 408);
   _actionMap[351][WHEN] = ActionEntry(REDUCE, 404);
   _actionMap[351][ELSE] = ActionEntry(REDUCE, 404);
   _actionMap[351][FROM] = ActionEntry(REDUCE, 404);
   _actionMap[351][AS] = ActionEntry(REDUCE, 404);
   _actionMap[351][END_TOKEN] = ActionEntry(REDUCE, 404);
   _actionMap[351][BEGIN] = ActionEntry(REDUCE, 404);
   _actionMap[351][THEN] = ActionEntry(REDUCE, 404);
   _actionMap[351][LEFT] = ActionEntry(REDUCE, 404);
   _actionMap[351][RIGHT] = ActionEntry(REDUCE, 404);
   _actionMap[351][INNER] = ActionEntry(REDUCE, 404);
}
void Cego::loadParser260()
{
   _actionMap[351][JOIN] = ActionEntry(REDUCE, 404);
   _actionMap[351][GROUP] = ActionEntry(REDUCE, 404);
   _actionMap[351][RETURNTOKEN] = ActionEntry(REDUCE, 404);
   _actionMap[351][WHERE] = ActionEntry(REDUCE, 404);
   _actionMap[351][HAVING] = ActionEntry(REDUCE, 404);
   _actionMap[351][ORDER] = ActionEntry(REDUCE, 404);
   _actionMap[351][AND] = ActionEntry(REDUCE, 404);
   _actionMap[351][OR] = ActionEntry(REDUCE, 404);
   _actionMap[351][INTOK] = ActionEntry(REDUCE, 404);
   _actionMap[351][NOT] = ActionEntry(REDUCE, 404);
   _actionMap[351][MT] = ActionEntry(REDUCE, 404);
   _actionMap[351][LT] = ActionEntry(REDUCE, 404);
   _actionMap[351][NEGATION] = ActionEntry(REDUCE, 404);
   _actionMap[351][EQU] = ActionEntry(REDUCE, 404);
   _actionMap[351][BETWEEN] = ActionEntry(REDUCE, 404);
   _actionMap[351][IS] = ActionEntry(REDUCE, 404);
   _actionMap[351][LIKE] = ActionEntry(REDUCE, 404);
   _actionMap[351][NCLIKE] = ActionEntry(REDUCE, 404);
   _actionMap[351][RB] = ActionEntry(REDUCE, 404);
   _actionMap[351][ENDTOKEN] = ActionEntry(REDUCE, 404);
   _actionMap[351][UNION] = ActionEntry(REDUCE, 404);
   _actionMap[351][ROWLIMIT] = ActionEntry(REDUCE, 404);
   _actionMap[351][KSEP] = ActionEntry(REDUCE, 404);
   _actionMap[351][ASC] = ActionEntry(REDUCE, 404);
   _actionMap[351][DESC] = ActionEntry(REDUCE, 404);
   _actionMap[351][PLUS] = ActionEntry(REDUCE, 404);
   _actionMap[351][MINUS] = ActionEntry(REDUCE, 404);
   _actionMap[351][DIVISION] = ActionEntry(REDUCE, 404);
   _actionMap[351][STAR] = ActionEntry(REDUCE, 404);
   _actionMap[351][CONCAT] = ActionEntry(REDUCE, 404);
   _actionMap[351][SEMICOLON] = ActionEntry(REDUCE, 404);
   _actionMap[352][TO] = ActionEntry(SHIFT, 530);
   _actionMap[353][TO] = ActionEntry(SHIFT, 531);
   _actionMap[354][TO] = ActionEntry(SHIFT, 532);
   _actionMap[355][TO] = ActionEntry(SHIFT, 533);
   _actionMap[356][TO] = ActionEntry(SHIFT, 534);
   _actionMap[357][TO] = ActionEntry(SHIFT, 535);
   _actionMap[358][TO] = ActionEntry(SHIFT, 536);
   _actionMap[359][TO] = ActionEntry(SHIFT, 537);
   _actionMap[360][SEMICOLON] = ActionEntry(REDUCE, 50);
   _actionMap[361][SEMICOLON] = ActionEntry(REDUCE, 49);
   _actionMap[362][SEMICOLON] = ActionEntry(REDUCE, 168);
   _actionMap[362][RB] = ActionEntry(REDUCE, 168);
   _actionMap[363][SEMICOLON] = ActionEntry(REDUCE, 170);
   _actionMap[363][RB] = ActionEntry(REDUCE, 170);
   _actionMap[364][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[364][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[364][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[364][ObjSpec] = 542;
   _jumpMap[364][Table] = 541;
}
void Cego::loadParser261()
{
   _jumpMap[364][TableList] = 540;
   _jumpMap[364][JoinSpecList] = 539;
   _jumpMap[364][TableSource] = 538;
   _actionMap[365][KSEP] = ActionEntry(SHIFT, 543);
   _actionMap[365][FROM] = ActionEntry(REDUCE, 172);
   _actionMap[365][RB] = ActionEntry(REDUCE, 172);
   _actionMap[365][SEMICOLON] = ActionEntry(REDUCE, 172);
   _actionMap[365][ENDTOKEN] = ActionEntry(REDUCE, 172);
   _actionMap[366][FROM] = ActionEntry(REDUCE, 175);
   _actionMap[366][RB] = ActionEntry(REDUCE, 175);
   _actionMap[366][SEMICOLON] = ActionEntry(REDUCE, 175);
   _actionMap[366][ENDTOKEN] = ActionEntry(REDUCE, 175);
   _actionMap[366][KSEP] = ActionEntry(REDUCE, 175);
   _actionMap[367][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[367][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[367][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[367][KSEP] = ActionEntry(REDUCE, 196);
   _actionMap[367][AS] = ActionEntry(SHIFT, 546);
   _actionMap[367][FROM] = ActionEntry(REDUCE, 196);
   _actionMap[367][RB] = ActionEntry(REDUCE, 196);
   _actionMap[367][SEMICOLON] = ActionEntry(REDUCE, 196);
   _actionMap[367][ENDTOKEN] = ActionEntry(REDUCE, 196);
   _jumpMap[367][NoAliasOpt] = 545;
   _jumpMap[367][AliasOpt] = 544;
   _actionMap[368][SEMICOLON] = ActionEntry(REDUCE, 45);
   _actionMap[369][SEMICOLON] = ActionEntry(REDUCE, 44);
   _actionMap[370][SEMICOLON] = ActionEntry(REDUCE, 47);
   _actionMap[371][SEMICOLON] = ActionEntry(REDUCE, 46);
   _actionMap[372][TO] = ActionEntry(SHIFT, 547);
   _actionMap[373][SEMICOLON] = ActionEntry(REDUCE, 43);
   _actionMap[374][SEMICOLON] = ActionEntry(REDUCE, 42);
   _actionMap[375][SEMICOLON] = ActionEntry(REDUCE, 48);
   _actionMap[376][SEMICOLON] = ActionEntry(REDUCE, 35);
   _actionMap[377][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[377][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[377][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[377][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[377][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[377][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[377][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[377][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[377][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[377][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[377][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[377][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[377][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[377][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[377][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[377][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[377][LEFT] = ActionEntry(SHIFT, 148);
}
void Cego::loadParser262()
{
   _actionMap[377][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[377][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[377][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[377][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[377][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[377][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[377][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[377][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[377][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[377][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[377][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[377][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[377][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[377][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[377][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[377][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[377][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[377][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[377][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[377][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[377][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[377][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[377][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[377][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[377][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[377][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[377][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[377][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[377][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[377][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[377][LB] = ActionEntry(SHIFT, 178);
   _actionMap[377][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[377][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[377][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[377][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[377][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[377][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[377][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[377][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[377][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[377][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[377][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[377][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[377][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[377][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[377][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[377][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[377][ObjSpec] = 122;
   _jumpMap[377][Constant] = 121;
   _jumpMap[377][SignedFloat] = 120;
}
void Cego::loadParser263()
{
   _jumpMap[377][SignedInt] = 119;
   _jumpMap[377][Attribute] = 118;
   _jumpMap[377][Function] = 117;
   _jumpMap[377][Factor] = 116;
   _jumpMap[377][Term] = 115;
   _jumpMap[377][Expr] = 548;
   _jumpMap[377][CasePrepare] = 113;
   _jumpMap[377][CaseClause] = 112;
   _actionMap[378][SEMICOLON] = ActionEntry(REDUCE, 33);
   _actionMap[379][SEMICOLON] = ActionEntry(REDUCE, 31);
   _actionMap[380][SEMICOLON] = ActionEntry(REDUCE, 34);
   _actionMap[381][SEMICOLON] = ActionEntry(REDUCE, 32);
   _actionMap[382][SEMICOLON] = ActionEntry(REDUCE, 76);
   _actionMap[383][SET] = ActionEntry(SHIFT, 384);
   _actionMap[384][IDENTIFIER] = ActionEntry(SHIFT, 551);
   _jumpMap[384][Assignment] = 550;
   _jumpMap[384][UpdateList] = 549;
   _actionMap[385][SET] = ActionEntry(REDUCE, 166);
   _actionMap[385][WHERE] = ActionEntry(REDUCE, 166);
   _actionMap[385][RETURNTOKEN] = ActionEntry(REDUCE, 166);
   _actionMap[385][SEMICOLON] = ActionEntry(REDUCE, 166);
   _actionMap[385][GROUP] = ActionEntry(REDUCE, 166);
   _actionMap[385][ORDER] = ActionEntry(REDUCE, 166);
   _actionMap[385][ROWLIMIT] = ActionEntry(REDUCE, 166);
   _actionMap[385][UNION] = ActionEntry(REDUCE, 166);
   _actionMap[385][ENDTOKEN] = ActionEntry(REDUCE, 166);
   _actionMap[385][RB] = ActionEntry(REDUCE, 166);
   _actionMap[386][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[386][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[386][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[386][ObjSpec] = 552;
   _actionMap[46][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[46][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[46][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[46][ObjSpec] = 221;
   _actionMap[47][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[47][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[47][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[47][ObjSpec] = 222;
   _actionMap[48][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[48][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[48][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[48][ObjSpec] = 223;
   _actionMap[49][FOR] = ActionEntry(REDUCE, 135);
   _actionMap[49][SEMICOLON] = ActionEntry(REDUCE, 135);
   _actionMap[49][QUALIFIEDOBJ] = ActionEntry(REDUCE, 135);
   _actionMap[49][QUALIFIEDTS] = ActionEntry(REDUCE, 135);
   _actionMap[49][ON] = ActionEntry(REDUCE, 135);
   _actionMap[49][IDENTIFIER] = ActionEntry(REDUCE, 135);
   _actionMap[50][IDENTIFIER] = ActionEntry(SHIFT, 62);
}
void Cego::loadParser264()
{
   _actionMap[50][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[50][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[50][ObjSpec] = 224;
   _actionMap[51][IDENTIFIER] = ActionEntry(SHIFT, 226);
   _jumpMap[51][CounterId] = 225;
   _actionMap[52][KEY] = ActionEntry(SHIFT, 227);
   _actionMap[53][FOR] = ActionEntry(REDUCE, 136);
   _actionMap[53][SEMICOLON] = ActionEntry(REDUCE, 136);
   _actionMap[53][QUALIFIEDOBJ] = ActionEntry(REDUCE, 136);
   _actionMap[53][QUALIFIEDTS] = ActionEntry(REDUCE, 136);
   _actionMap[53][ON] = ActionEntry(REDUCE, 136);
   _actionMap[53][IDENTIFIER] = ActionEntry(REDUCE, 136);
   _actionMap[54][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[54][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[54][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[54][ObjSpec] = 228;
   _actionMap[55][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[55][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[55][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[55][ObjSpec] = 229;
   _actionMap[56][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[56][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[56][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[56][ObjSpec] = 230;
   _actionMap[57][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[57][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[57][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[57][ObjSpec] = 231;
   _actionMap[58][ENDTOKEN] = ActionEntry(ACCEPT, 0);
   _actionMap[59][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[59][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[59][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[59][ObjSpec] = 232;
   _actionMap[60][IDENTIFIED] = ActionEntry(SHIFT, 233);
   _actionMap[61][LB] = ActionEntry(SHIFT, 234);
   _actionMap[62][BEGIN] = ActionEntry(REDUCE, 425);
   _actionMap[62][TO] = ActionEntry(REDUCE, 425);
   _actionMap[62][VALUES] = ActionEntry(REDUCE, 425);
   _actionMap[62][SELECT] = ActionEntry(REDUCE, 425);
   _actionMap[62][SET] = ActionEntry(REDUCE, 425);
   _actionMap[62][AS] = ActionEntry(REDUCE, 425);
   _actionMap[62][BEFORE] = ActionEntry(REDUCE, 425);
   _actionMap[62][AFTER] = ActionEntry(REDUCE, 425);
   _actionMap[62][DROP] = ActionEntry(REDUCE, 425);
   _actionMap[62][MODIFY] = ActionEntry(REDUCE, 425);
   _actionMap[62][RENAME] = ActionEntry(REDUCE, 425);
   _actionMap[62][ADD] = ActionEntry(REDUCE, 425);
   _actionMap[62][KSEP] = ActionEntry(REDUCE, 425);
   _actionMap[62][LEFT] = ActionEntry(REDUCE, 425);
   _actionMap[62][RIGHT] = ActionEntry(REDUCE, 425);
}
void Cego::loadParser265()
{
   _actionMap[62][INNER] = ActionEntry(REDUCE, 425);
   _actionMap[62][JOIN] = ActionEntry(REDUCE, 425);
   _actionMap[62][RB] = ActionEntry(REDUCE, 425);
   _actionMap[62][ENDTOKEN] = ActionEntry(REDUCE, 425);
   _actionMap[62][UNION] = ActionEntry(REDUCE, 425);
   _actionMap[62][ROWLIMIT] = ActionEntry(REDUCE, 425);
   _actionMap[62][ORDER] = ActionEntry(REDUCE, 425);
   _actionMap[62][GROUP] = ActionEntry(REDUCE, 425);
   _actionMap[62][SEMICOLON] = ActionEntry(REDUCE, 425);
   _actionMap[62][RETURNTOKEN] = ActionEntry(REDUCE, 425);
   _actionMap[62][WHERE] = ActionEntry(REDUCE, 425);
   _actionMap[62][LB] = ActionEntry(REDUCE, 425);
   _actionMap[62][ON] = ActionEntry(REDUCE, 425);
   _actionMap[62][IDENTIFIER] = ActionEntry(REDUCE, 425);
   _actionMap[63][BEGIN] = ActionEntry(REDUCE, 426);
   _actionMap[63][TO] = ActionEntry(REDUCE, 426);
   _actionMap[63][VALUES] = ActionEntry(REDUCE, 426);
   _actionMap[63][SELECT] = ActionEntry(REDUCE, 426);
   _actionMap[63][SET] = ActionEntry(REDUCE, 426);
   _actionMap[63][AS] = ActionEntry(REDUCE, 426);
   _actionMap[63][BEFORE] = ActionEntry(REDUCE, 426);
   _actionMap[63][AFTER] = ActionEntry(REDUCE, 426);
   _actionMap[63][DROP] = ActionEntry(REDUCE, 426);
   _actionMap[63][MODIFY] = ActionEntry(REDUCE, 426);
   _actionMap[63][RENAME] = ActionEntry(REDUCE, 426);
   _actionMap[63][ADD] = ActionEntry(REDUCE, 426);
   _actionMap[63][KSEP] = ActionEntry(REDUCE, 426);
   _actionMap[63][LEFT] = ActionEntry(REDUCE, 426);
   _actionMap[63][RIGHT] = ActionEntry(REDUCE, 426);
   _actionMap[63][INNER] = ActionEntry(REDUCE, 426);
   _actionMap[63][JOIN] = ActionEntry(REDUCE, 426);
   _actionMap[63][RB] = ActionEntry(REDUCE, 426);
   _actionMap[63][ENDTOKEN] = ActionEntry(REDUCE, 426);
   _actionMap[63][UNION] = ActionEntry(REDUCE, 426);
   _actionMap[63][ROWLIMIT] = ActionEntry(REDUCE, 426);
   _actionMap[63][ORDER] = ActionEntry(REDUCE, 426);
   _actionMap[63][GROUP] = ActionEntry(REDUCE, 426);
   _actionMap[63][SEMICOLON] = ActionEntry(REDUCE, 426);
   _actionMap[63][RETURNTOKEN] = ActionEntry(REDUCE, 426);
   _actionMap[63][WHERE] = ActionEntry(REDUCE, 426);
   _actionMap[63][LB] = ActionEntry(REDUCE, 426);
   _actionMap[63][ON] = ActionEntry(REDUCE, 426);
   _actionMap[63][IDENTIFIER] = ActionEntry(REDUCE, 426);
   _actionMap[64][BEGIN] = ActionEntry(REDUCE, 427);
   _actionMap[64][TO] = ActionEntry(REDUCE, 427);
   _actionMap[64][VALUES] = ActionEntry(REDUCE, 427);
   _actionMap[64][SELECT] = ActionEntry(REDUCE, 427);
   _actionMap[64][SET] = ActionEntry(REDUCE, 427);
   _actionMap[64][AS] = ActionEntry(REDUCE, 427);
   _actionMap[64][BEFORE] = ActionEntry(REDUCE, 427);
}
void Cego::loadParser266()
{
   _actionMap[64][AFTER] = ActionEntry(REDUCE, 427);
   _actionMap[64][DROP] = ActionEntry(REDUCE, 427);
   _actionMap[64][MODIFY] = ActionEntry(REDUCE, 427);
   _actionMap[64][RENAME] = ActionEntry(REDUCE, 427);
   _actionMap[64][ADD] = ActionEntry(REDUCE, 427);
   _actionMap[64][KSEP] = ActionEntry(REDUCE, 427);
   _actionMap[64][LEFT] = ActionEntry(REDUCE, 427);
   _actionMap[64][RIGHT] = ActionEntry(REDUCE, 427);
   _actionMap[64][INNER] = ActionEntry(REDUCE, 427);
   _actionMap[64][JOIN] = ActionEntry(REDUCE, 427);
   _actionMap[64][RB] = ActionEntry(REDUCE, 427);
   _actionMap[64][ENDTOKEN] = ActionEntry(REDUCE, 427);
   _actionMap[64][UNION] = ActionEntry(REDUCE, 427);
   _actionMap[64][ROWLIMIT] = ActionEntry(REDUCE, 427);
   _actionMap[64][ORDER] = ActionEntry(REDUCE, 427);
   _actionMap[64][GROUP] = ActionEntry(REDUCE, 427);
   _actionMap[64][SEMICOLON] = ActionEntry(REDUCE, 427);
   _actionMap[64][RETURNTOKEN] = ActionEntry(REDUCE, 427);
   _actionMap[64][WHERE] = ActionEntry(REDUCE, 427);
   _actionMap[64][ON] = ActionEntry(REDUCE, 427);
   _actionMap[64][IDENTIFIER] = ActionEntry(REDUCE, 427);
   _actionMap[64][LB] = ActionEntry(REDUCE, 427);
   _actionMap[65][IDENTIFIER] = ActionEntry(SHIFT, 235);
   _actionMap[66][SEMICOLON] = ActionEntry(REDUCE, 74);
   _actionMap[67][BEGIN] = ActionEntry(SHIFT, 236);
   _actionMap[68][BTREE] = ActionEntry(SHIFT, 49);
   _actionMap[68][INDEX] = ActionEntry(SHIFT, 53);
   _actionMap[68][AVLTREE] = ActionEntry(SHIFT, 239);
   _jumpMap[68][BtreeType] = 238;
   _jumpMap[68][IndexType] = 237;
   _actionMap[69][BEGIN] = ActionEntry(SHIFT, 240);
   _actionMap[70][SEMICOLON] = ActionEntry(REDUCE, 60);
   _actionMap[71][IDENTIFIER] = ActionEntry(SHIFT, 241);
   _actionMap[72][IDENTIFIER] = ActionEntry(SHIFT, 226);
   _jumpMap[72][CounterId] = 242;
   _actionMap[73][BTREE] = ActionEntry(SHIFT, 49);
   _actionMap[73][INDEX] = ActionEntry(SHIFT, 53);
   _actionMap[73][AVLTREE] = ActionEntry(SHIFT, 239);
   _jumpMap[73][BtreeType] = 238;
   _jumpMap[73][IndexType] = 243;
   _actionMap[74][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[74][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[74][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[74][ObjSpec] = 244;
   _actionMap[75][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[75][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[75][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[75][ObjSpec] = 245;
   _actionMap[76][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[76][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
}
void Cego::loadParser267()
{
   _actionMap[76][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[76][ObjSpec] = 246;
   _actionMap[77][AVLTREE] = ActionEntry(REDUCE, 131);
   _actionMap[77][BTREE] = ActionEntry(REDUCE, 131);
   _actionMap[77][INDEX] = ActionEntry(REDUCE, 131);
   _actionMap[78][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[78][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[78][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[78][ObjSpec] = 247;
   _actionMap[79][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[79][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[79][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[79][ObjSpec] = 248;
   _actionMap[80][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[80][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[80][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[80][ObjSpec] = 249;
   _actionMap[81][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[81][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[81][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[81][ObjSpec] = 250;
   _actionMap[82][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[82][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[82][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[82][ObjSpec] = 251;
   _actionMap[83][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[83][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[83][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[83][ObjSpec] = 252;
   _actionMap[84][KEY] = ActionEntry(SHIFT, 253);
   _actionMap[85][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[85][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[85][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[85][ObjSpec] = 254;
   _actionMap[86][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[86][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[86][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[86][ObjSpec] = 255;
   _actionMap[87][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[87][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[87][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[87][ObjSpec] = 256;
   _actionMap[88][EXISTS] = ActionEntry(SHIFT, 257);
   _actionMap[89][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[89][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[89][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[89][ObjSpec] = 258;
   _actionMap[90][IDENTIFIER] = ActionEntry(SHIFT, 259);
   _actionMap[90][SEMICOLON] = ActionEntry(REDUCE, 97);
   _actionMap[91][IDENTIFIER] = ActionEntry(REDUCE, 99);
}
void Cego::loadParser268()
{
   _actionMap[91][SEMICOLON] = ActionEntry(REDUCE, 99);
   _actionMap[92][FOR] = ActionEntry(SHIFT, 261);
   _actionMap[92][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[92][TableSetOpt] = 260;
   _actionMap[93][FOR] = ActionEntry(SHIFT, 261);
   _actionMap[93][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[93][TableSetOpt] = 262;
   _actionMap[94][FOR] = ActionEntry(SHIFT, 261);
   _actionMap[94][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[94][TableSetOpt] = 263;
   _actionMap[95][FOR] = ActionEntry(SHIFT, 261);
   _actionMap[95][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[95][TableSetOpt] = 264;
   _actionMap[96][FOR] = ActionEntry(SHIFT, 261);
   _actionMap[96][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[96][TableSetOpt] = 265;
   _actionMap[97][FOR] = ActionEntry(SHIFT, 261);
   _actionMap[97][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[97][TableSetOpt] = 266;
   _actionMap[98][FOR] = ActionEntry(SHIFT, 261);
   _actionMap[98][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[98][TableSetOpt] = 267;
   _actionMap[99][FOR] = ActionEntry(SHIFT, 261);
   _actionMap[99][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[99][TableSetOpt] = 268;
   _actionMap[100][FOR] = ActionEntry(SHIFT, 261);
   _actionMap[100][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[100][TableSetOpt] = 269;
   _actionMap[101][SEMICOLON] = ActionEntry(REDUCE, 2);
   _actionMap[102][FOR] = ActionEntry(SHIFT, 261);
   _actionMap[102][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[102][TableSetOpt] = 270;
   _actionMap[103][FOR] = ActionEntry(SHIFT, 261);
   _actionMap[103][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[103][TableSetOpt] = 271;
   _actionMap[104][FOR] = ActionEntry(SHIFT, 261);
   _actionMap[104][SEMICOLON] = ActionEntry(REDUCE, 16);
   _jumpMap[104][TableSetOpt] = 272;
   _actionMap[105][SEMICOLON] = ActionEntry(REDUCE, 75);
   _actionMap[106][SEMICOLON] = ActionEntry(REDUCE, 61);
   _actionMap[107][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[107][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[107][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[107][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[107][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[107][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[107][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[107][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[107][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[107][SCANDATE] = ActionEntry(SHIFT, 167);
}
void Cego::loadParser269()
{
   _actionMap[107][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[107][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[107][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[107][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[107][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[107][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[107][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[107][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[107][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[107][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[107][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[107][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[107][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[107][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[107][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[107][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[107][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[107][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[107][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[107][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[107][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[107][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[107][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[107][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[107][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[107][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[107][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[107][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[107][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[107][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[107][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[107][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[107][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[107][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[107][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[107][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[107][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[107][LB] = ActionEntry(SHIFT, 178);
   _actionMap[107][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[107][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[107][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[107][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[107][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[107][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[107][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[107][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[107][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[107][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[107][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[107][COUNT] = ActionEntry(SHIFT, 137);
}
void Cego::loadParser270()
{
   _actionMap[107][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[107][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[107][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[107][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[107][EXISTS] = ActionEntry(SHIFT, 277);
   _actionMap[107][NOT] = ActionEntry(SHIFT, 278);
   _jumpMap[107][ObjSpec] = 122;
   _jumpMap[107][Constant] = 121;
   _jumpMap[107][SignedFloat] = 120;
   _jumpMap[107][SignedInt] = 119;
   _jumpMap[107][Attribute] = 118;
   _jumpMap[107][Function] = 117;
   _jumpMap[107][Factor] = 116;
   _jumpMap[107][Term] = 115;
   _jumpMap[107][Expr] = 276;
   _jumpMap[107][Predicate] = 275;
   _jumpMap[107][Conjunction] = 274;
   _jumpMap[107][Condition] = 273;
   _jumpMap[107][CasePrepare] = 113;
   _jumpMap[107][CaseClause] = 112;
   _actionMap[108][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[108][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[108][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[108][ObjSpec] = 279;
   _actionMap[109][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[109][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[109][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[109][ObjSpec] = 280;
   _actionMap[110][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[110][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[110][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[110][ObjSpec] = 281;
   _actionMap[111][SEMICOLON] = ActionEntry(REDUCE, 52);
   _actionMap[112][WHEN] = ActionEntry(REDUCE, 329);
   _actionMap[112][ELSE] = ActionEntry(REDUCE, 329);
   _actionMap[112][LEFT] = ActionEntry(REDUCE, 329);
   _actionMap[112][RIGHT] = ActionEntry(REDUCE, 329);
   _actionMap[112][INNER] = ActionEntry(REDUCE, 329);
   _actionMap[112][JOIN] = ActionEntry(REDUCE, 329);
   _actionMap[112][ORDER] = ActionEntry(REDUCE, 329);
   _actionMap[112][GROUP] = ActionEntry(REDUCE, 329);
   _actionMap[112][RETURNTOKEN] = ActionEntry(REDUCE, 329);
   _actionMap[112][WHERE] = ActionEntry(REDUCE, 329);
   _actionMap[112][AS] = ActionEntry(REDUCE, 329);
   _actionMap[112][FROM] = ActionEntry(REDUCE, 329);
   _actionMap[112][END_TOKEN] = ActionEntry(REDUCE, 329);
   _actionMap[112][BEGIN] = ActionEntry(REDUCE, 329);
   _actionMap[112][THEN] = ActionEntry(REDUCE, 329);
   _actionMap[112][OR] = ActionEntry(REDUCE, 329);
   _actionMap[112][AND] = ActionEntry(REDUCE, 329);
}
void Cego::loadParser271()
{
   _actionMap[112][NCLIKE] = ActionEntry(REDUCE, 329);
   _actionMap[112][LIKE] = ActionEntry(REDUCE, 329);
   _actionMap[112][IS] = ActionEntry(REDUCE, 329);
   _actionMap[112][BETWEEN] = ActionEntry(REDUCE, 329);
   _actionMap[112][EQU] = ActionEntry(REDUCE, 329);
   _actionMap[112][NEGATION] = ActionEntry(REDUCE, 329);
   _actionMap[112][LT] = ActionEntry(REDUCE, 329);
   _actionMap[112][MT] = ActionEntry(REDUCE, 329);
   _actionMap[112][NOT] = ActionEntry(REDUCE, 329);
   _actionMap[112][INTOK] = ActionEntry(REDUCE, 329);
   _actionMap[112][DESC] = ActionEntry(REDUCE, 329);
   _actionMap[112][ASC] = ActionEntry(REDUCE, 329);
   _actionMap[112][KSEP] = ActionEntry(REDUCE, 329);
   _actionMap[112][ROWLIMIT] = ActionEntry(REDUCE, 329);
   _actionMap[112][UNION] = ActionEntry(REDUCE, 329);
   _actionMap[112][ENDTOKEN] = ActionEntry(REDUCE, 329);
   _actionMap[112][RB] = ActionEntry(REDUCE, 329);
   _actionMap[112][CONCAT] = ActionEntry(REDUCE, 329);
   _actionMap[112][STAR] = ActionEntry(REDUCE, 329);
   _actionMap[112][DIVISION] = ActionEntry(REDUCE, 329);
   _actionMap[112][MINUS] = ActionEntry(REDUCE, 329);
   _actionMap[112][PLUS] = ActionEntry(REDUCE, 329);
   _actionMap[112][SEMICOLON] = ActionEntry(REDUCE, 329);
   _actionMap[113][WHEN] = ActionEntry(SHIFT, 284);
   _jumpMap[113][CaseCondition] = 283;
   _jumpMap[113][CaseConditionList] = 282;
   _actionMap[114][PLUS] = ActionEntry(SHIFT, 287);
   _actionMap[114][MINUS] = ActionEntry(SHIFT, 286);
   _actionMap[114][CONCAT] = ActionEntry(SHIFT, 285);
   _actionMap[114][SEMICOLON] = ActionEntry(REDUCE, 91);
   _actionMap[115][STAR] = ActionEntry(SHIFT, 288);
   _actionMap[115][DIVISION] = ActionEntry(SHIFT, 289);
   _actionMap[115][WHEN] = ActionEntry(REDUCE, 317);
   _actionMap[115][ELSE] = ActionEntry(REDUCE, 317);
   _actionMap[115][LEFT] = ActionEntry(REDUCE, 317);
   _actionMap[115][RIGHT] = ActionEntry(REDUCE, 317);
   _actionMap[115][INNER] = ActionEntry(REDUCE, 317);
   _actionMap[115][JOIN] = ActionEntry(REDUCE, 317);
   _actionMap[115][ORDER] = ActionEntry(REDUCE, 317);
   _actionMap[115][GROUP] = ActionEntry(REDUCE, 317);
   _actionMap[115][RETURNTOKEN] = ActionEntry(REDUCE, 317);
   _actionMap[115][WHERE] = ActionEntry(REDUCE, 317);
   _actionMap[115][AS] = ActionEntry(REDUCE, 317);
   _actionMap[115][FROM] = ActionEntry(REDUCE, 317);
   _actionMap[115][END_TOKEN] = ActionEntry(REDUCE, 317);
   _actionMap[115][BEGIN] = ActionEntry(REDUCE, 317);
   _actionMap[115][THEN] = ActionEntry(REDUCE, 317);
   _actionMap[115][OR] = ActionEntry(REDUCE, 317);
   _actionMap[115][AND] = ActionEntry(REDUCE, 317);
   _actionMap[115][NCLIKE] = ActionEntry(REDUCE, 317);
}
void Cego::loadParser272()
{
   _actionMap[115][LIKE] = ActionEntry(REDUCE, 317);
   _actionMap[115][IS] = ActionEntry(REDUCE, 317);
   _actionMap[115][BETWEEN] = ActionEntry(REDUCE, 317);
   _actionMap[115][EQU] = ActionEntry(REDUCE, 317);
   _actionMap[115][NEGATION] = ActionEntry(REDUCE, 317);
   _actionMap[115][LT] = ActionEntry(REDUCE, 317);
   _actionMap[115][MT] = ActionEntry(REDUCE, 317);
   _actionMap[115][NOT] = ActionEntry(REDUCE, 317);
   _actionMap[115][INTOK] = ActionEntry(REDUCE, 317);
   _actionMap[115][DESC] = ActionEntry(REDUCE, 317);
   _actionMap[115][ASC] = ActionEntry(REDUCE, 317);
   _actionMap[115][KSEP] = ActionEntry(REDUCE, 317);
   _actionMap[115][ROWLIMIT] = ActionEntry(REDUCE, 317);
   _actionMap[115][UNION] = ActionEntry(REDUCE, 317);
   _actionMap[115][ENDTOKEN] = ActionEntry(REDUCE, 317);
   _actionMap[115][RB] = ActionEntry(REDUCE, 317);
   _actionMap[115][CONCAT] = ActionEntry(REDUCE, 317);
   _actionMap[115][MINUS] = ActionEntry(REDUCE, 317);
   _actionMap[115][PLUS] = ActionEntry(REDUCE, 317);
   _actionMap[115][SEMICOLON] = ActionEntry(REDUCE, 317);
   _actionMap[116][WHEN] = ActionEntry(REDUCE, 321);
   _actionMap[116][ELSE] = ActionEntry(REDUCE, 321);
   _actionMap[116][LEFT] = ActionEntry(REDUCE, 321);
   _actionMap[116][RIGHT] = ActionEntry(REDUCE, 321);
   _actionMap[116][INNER] = ActionEntry(REDUCE, 321);
   _actionMap[116][JOIN] = ActionEntry(REDUCE, 321);
   _actionMap[116][ORDER] = ActionEntry(REDUCE, 321);
   _actionMap[116][GROUP] = ActionEntry(REDUCE, 321);
   _actionMap[116][RETURNTOKEN] = ActionEntry(REDUCE, 321);
   _actionMap[116][WHERE] = ActionEntry(REDUCE, 321);
   _actionMap[116][FROM] = ActionEntry(REDUCE, 321);
   _actionMap[116][AS] = ActionEntry(REDUCE, 321);
   _actionMap[116][END_TOKEN] = ActionEntry(REDUCE, 321);
   _actionMap[116][BEGIN] = ActionEntry(REDUCE, 321);
   _actionMap[116][THEN] = ActionEntry(REDUCE, 321);
   _actionMap[116][AND] = ActionEntry(REDUCE, 321);
   _actionMap[116][OR] = ActionEntry(REDUCE, 321);
   _actionMap[116][INTOK] = ActionEntry(REDUCE, 321);
   _actionMap[116][NOT] = ActionEntry(REDUCE, 321);
   _actionMap[116][MT] = ActionEntry(REDUCE, 321);
   _actionMap[116][LT] = ActionEntry(REDUCE, 321);
   _actionMap[116][NEGATION] = ActionEntry(REDUCE, 321);
   _actionMap[116][EQU] = ActionEntry(REDUCE, 321);
   _actionMap[116][BETWEEN] = ActionEntry(REDUCE, 321);
   _actionMap[116][IS] = ActionEntry(REDUCE, 321);
   _actionMap[116][LIKE] = ActionEntry(REDUCE, 321);
   _actionMap[116][NCLIKE] = ActionEntry(REDUCE, 321);
   _actionMap[116][RB] = ActionEntry(REDUCE, 321);
   _actionMap[116][ENDTOKEN] = ActionEntry(REDUCE, 321);
   _actionMap[116][UNION] = ActionEntry(REDUCE, 321);
}
void Cego::loadParser273()
{
   _actionMap[116][ROWLIMIT] = ActionEntry(REDUCE, 321);
   _actionMap[116][KSEP] = ActionEntry(REDUCE, 321);
   _actionMap[116][ASC] = ActionEntry(REDUCE, 321);
   _actionMap[116][DESC] = ActionEntry(REDUCE, 321);
   _actionMap[116][PLUS] = ActionEntry(REDUCE, 321);
   _actionMap[116][MINUS] = ActionEntry(REDUCE, 321);
   _actionMap[116][DIVISION] = ActionEntry(REDUCE, 321);
   _actionMap[116][STAR] = ActionEntry(REDUCE, 321);
   _actionMap[116][CONCAT] = ActionEntry(REDUCE, 321);
   _actionMap[116][SEMICOLON] = ActionEntry(REDUCE, 321);
   _actionMap[117][WHEN] = ActionEntry(REDUCE, 326);
   _actionMap[117][ELSE] = ActionEntry(REDUCE, 326);
   _actionMap[117][LEFT] = ActionEntry(REDUCE, 326);
   _actionMap[117][RIGHT] = ActionEntry(REDUCE, 326);
   _actionMap[117][INNER] = ActionEntry(REDUCE, 326);
   _actionMap[117][JOIN] = ActionEntry(REDUCE, 326);
   _actionMap[117][ORDER] = ActionEntry(REDUCE, 326);
   _actionMap[117][GROUP] = ActionEntry(REDUCE, 326);
   _actionMap[117][RETURNTOKEN] = ActionEntry(REDUCE, 326);
   _actionMap[117][WHERE] = ActionEntry(REDUCE, 326);
   _actionMap[117][AS] = ActionEntry(REDUCE, 326);
   _actionMap[117][FROM] = ActionEntry(REDUCE, 326);
   _actionMap[117][END_TOKEN] = ActionEntry(REDUCE, 326);
   _actionMap[117][BEGIN] = ActionEntry(REDUCE, 326);
   _actionMap[117][THEN] = ActionEntry(REDUCE, 326);
   _actionMap[117][OR] = ActionEntry(REDUCE, 326);
   _actionMap[117][AND] = ActionEntry(REDUCE, 326);
   _actionMap[117][NCLIKE] = ActionEntry(REDUCE, 326);
   _actionMap[117][LIKE] = ActionEntry(REDUCE, 326);
   _actionMap[117][IS] = ActionEntry(REDUCE, 326);
   _actionMap[117][BETWEEN] = ActionEntry(REDUCE, 326);
   _actionMap[117][EQU] = ActionEntry(REDUCE, 326);
   _actionMap[117][NEGATION] = ActionEntry(REDUCE, 326);
   _actionMap[117][LT] = ActionEntry(REDUCE, 326);
   _actionMap[117][MT] = ActionEntry(REDUCE, 326);
   _actionMap[117][NOT] = ActionEntry(REDUCE, 326);
   _actionMap[117][INTOK] = ActionEntry(REDUCE, 326);
   _actionMap[117][DESC] = ActionEntry(REDUCE, 326);
   _actionMap[117][ASC] = ActionEntry(REDUCE, 326);
   _actionMap[117][KSEP] = ActionEntry(REDUCE, 326);
   _actionMap[117][ROWLIMIT] = ActionEntry(REDUCE, 326);
   _actionMap[117][UNION] = ActionEntry(REDUCE, 326);
   _actionMap[117][ENDTOKEN] = ActionEntry(REDUCE, 326);
   _actionMap[117][RB] = ActionEntry(REDUCE, 326);
   _actionMap[117][CONCAT] = ActionEntry(REDUCE, 326);
   _actionMap[117][STAR] = ActionEntry(REDUCE, 326);
   _actionMap[117][DIVISION] = ActionEntry(REDUCE, 326);
   _actionMap[117][MINUS] = ActionEntry(REDUCE, 326);
   _actionMap[117][PLUS] = ActionEntry(REDUCE, 326);
   _actionMap[117][SEMICOLON] = ActionEntry(REDUCE, 326);
}
void Cego::loadParser274()
{
   _actionMap[118][WHEN] = ActionEntry(REDUCE, 325);
   _actionMap[118][ELSE] = ActionEntry(REDUCE, 325);
   _actionMap[118][LEFT] = ActionEntry(REDUCE, 325);
   _actionMap[118][RIGHT] = ActionEntry(REDUCE, 325);
   _actionMap[118][INNER] = ActionEntry(REDUCE, 325);
   _actionMap[118][JOIN] = ActionEntry(REDUCE, 325);
   _actionMap[118][ORDER] = ActionEntry(REDUCE, 325);
   _actionMap[118][GROUP] = ActionEntry(REDUCE, 325);
   _actionMap[118][RETURNTOKEN] = ActionEntry(REDUCE, 325);
   _actionMap[118][WHERE] = ActionEntry(REDUCE, 325);
   _actionMap[118][AS] = ActionEntry(REDUCE, 325);
   _actionMap[118][FROM] = ActionEntry(REDUCE, 325);
   _actionMap[118][END_TOKEN] = ActionEntry(REDUCE, 325);
   _actionMap[118][BEGIN] = ActionEntry(REDUCE, 325);
   _actionMap[118][THEN] = ActionEntry(REDUCE, 325);
   _actionMap[118][OR] = ActionEntry(REDUCE, 325);
   _actionMap[118][AND] = ActionEntry(REDUCE, 325);
   _actionMap[118][NCLIKE] = ActionEntry(REDUCE, 325);
   _actionMap[118][LIKE] = ActionEntry(REDUCE, 325);
   _actionMap[118][IS] = ActionEntry(REDUCE, 325);
   _actionMap[118][BETWEEN] = ActionEntry(REDUCE, 325);
   _actionMap[118][EQU] = ActionEntry(REDUCE, 325);
   _actionMap[118][NEGATION] = ActionEntry(REDUCE, 325);
   _actionMap[118][LT] = ActionEntry(REDUCE, 325);
   _actionMap[118][MT] = ActionEntry(REDUCE, 325);
   _actionMap[118][NOT] = ActionEntry(REDUCE, 325);
   _actionMap[118][INTOK] = ActionEntry(REDUCE, 325);
   _actionMap[118][DESC] = ActionEntry(REDUCE, 325);
   _actionMap[118][ASC] = ActionEntry(REDUCE, 325);
   _actionMap[118][KSEP] = ActionEntry(REDUCE, 325);
   _actionMap[118][ROWLIMIT] = ActionEntry(REDUCE, 325);
   _actionMap[118][UNION] = ActionEntry(REDUCE, 325);
   _actionMap[118][ENDTOKEN] = ActionEntry(REDUCE, 325);
   _actionMap[118][RB] = ActionEntry(REDUCE, 325);
   _actionMap[118][CONCAT] = ActionEntry(REDUCE, 325);
   _actionMap[118][STAR] = ActionEntry(REDUCE, 325);
   _actionMap[118][DIVISION] = ActionEntry(REDUCE, 325);
   _actionMap[118][MINUS] = ActionEntry(REDUCE, 325);
   _actionMap[118][PLUS] = ActionEntry(REDUCE, 325);
   _actionMap[118][SEMICOLON] = ActionEntry(REDUCE, 325);
   _actionMap[119][WHEN] = ActionEntry(REDUCE, 409);
   _actionMap[119][ELSE] = ActionEntry(REDUCE, 409);
   _actionMap[119][LEFT] = ActionEntry(REDUCE, 409);
   _actionMap[119][RIGHT] = ActionEntry(REDUCE, 409);
   _actionMap[119][INNER] = ActionEntry(REDUCE, 409);
   _actionMap[119][JOIN] = ActionEntry(REDUCE, 409);
   _actionMap[119][ORDER] = ActionEntry(REDUCE, 409);
   _actionMap[119][GROUP] = ActionEntry(REDUCE, 409);
   _actionMap[119][RETURNTOKEN] = ActionEntry(REDUCE, 409);
   _actionMap[119][WHERE] = ActionEntry(REDUCE, 409);
}
void Cego::loadParser275()
{
   _actionMap[119][NULLTOKEN] = ActionEntry(REDUCE, 409);
   _actionMap[119][FROM] = ActionEntry(REDUCE, 409);
   _actionMap[119][AS] = ActionEntry(REDUCE, 409);
   _actionMap[119][END_TOKEN] = ActionEntry(REDUCE, 409);
   _actionMap[119][BEGIN] = ActionEntry(REDUCE, 409);
   _actionMap[119][THEN] = ActionEntry(REDUCE, 409);
   _actionMap[119][AND] = ActionEntry(REDUCE, 409);
   _actionMap[119][OR] = ActionEntry(REDUCE, 409);
   _actionMap[119][INTOK] = ActionEntry(REDUCE, 409);
   _actionMap[119][NOT] = ActionEntry(REDUCE, 409);
   _actionMap[119][MT] = ActionEntry(REDUCE, 409);
   _actionMap[119][LT] = ActionEntry(REDUCE, 409);
   _actionMap[119][NEGATION] = ActionEntry(REDUCE, 409);
   _actionMap[119][EQU] = ActionEntry(REDUCE, 409);
   _actionMap[119][BETWEEN] = ActionEntry(REDUCE, 409);
   _actionMap[119][IS] = ActionEntry(REDUCE, 409);
   _actionMap[119][LIKE] = ActionEntry(REDUCE, 409);
   _actionMap[119][NCLIKE] = ActionEntry(REDUCE, 409);
   _actionMap[119][RB] = ActionEntry(REDUCE, 409);
   _actionMap[119][ENDTOKEN] = ActionEntry(REDUCE, 409);
   _actionMap[119][UNION] = ActionEntry(REDUCE, 409);
   _actionMap[119][ROWLIMIT] = ActionEntry(REDUCE, 409);
   _actionMap[119][KSEP] = ActionEntry(REDUCE, 409);
   _actionMap[119][ASC] = ActionEntry(REDUCE, 409);
   _actionMap[119][DESC] = ActionEntry(REDUCE, 409);
   _actionMap[119][PLUS] = ActionEntry(REDUCE, 409);
   _actionMap[119][MINUS] = ActionEntry(REDUCE, 409);
   _actionMap[119][DIVISION] = ActionEntry(REDUCE, 409);
   _actionMap[119][STAR] = ActionEntry(REDUCE, 409);
   _actionMap[119][CONCAT] = ActionEntry(REDUCE, 409);
   _actionMap[119][SEMICOLON] = ActionEntry(REDUCE, 409);
   _actionMap[120][WHEN] = ActionEntry(REDUCE, 415);
   _actionMap[120][ELSE] = ActionEntry(REDUCE, 415);
   _actionMap[120][LEFT] = ActionEntry(REDUCE, 415);
   _actionMap[120][RIGHT] = ActionEntry(REDUCE, 415);
   _actionMap[120][INNER] = ActionEntry(REDUCE, 415);
   _actionMap[120][JOIN] = ActionEntry(REDUCE, 415);
   _actionMap[120][ORDER] = ActionEntry(REDUCE, 415);
   _actionMap[120][GROUP] = ActionEntry(REDUCE, 415);
   _actionMap[120][RETURNTOKEN] = ActionEntry(REDUCE, 415);
   _actionMap[120][WHERE] = ActionEntry(REDUCE, 415);
   _actionMap[120][NULLTOKEN] = ActionEntry(REDUCE, 415);
   _actionMap[120][FROM] = ActionEntry(REDUCE, 415);
   _actionMap[120][AS] = ActionEntry(REDUCE, 415);
   _actionMap[120][END_TOKEN] = ActionEntry(REDUCE, 415);
   _actionMap[120][BEGIN] = ActionEntry(REDUCE, 415);
   _actionMap[120][THEN] = ActionEntry(REDUCE, 415);
   _actionMap[120][AND] = ActionEntry(REDUCE, 415);
   _actionMap[120][OR] = ActionEntry(REDUCE, 415);
   _actionMap[120][INTOK] = ActionEntry(REDUCE, 415);
}
void Cego::loadParser276()
{
   _actionMap[120][NOT] = ActionEntry(REDUCE, 415);
   _actionMap[120][MT] = ActionEntry(REDUCE, 415);
   _actionMap[120][LT] = ActionEntry(REDUCE, 415);
   _actionMap[120][NEGATION] = ActionEntry(REDUCE, 415);
   _actionMap[120][EQU] = ActionEntry(REDUCE, 415);
   _actionMap[120][BETWEEN] = ActionEntry(REDUCE, 415);
   _actionMap[120][IS] = ActionEntry(REDUCE, 415);
   _actionMap[120][LIKE] = ActionEntry(REDUCE, 415);
   _actionMap[120][NCLIKE] = ActionEntry(REDUCE, 415);
   _actionMap[120][RB] = ActionEntry(REDUCE, 415);
   _actionMap[120][ENDTOKEN] = ActionEntry(REDUCE, 415);
   _actionMap[120][UNION] = ActionEntry(REDUCE, 415);
   _actionMap[120][ROWLIMIT] = ActionEntry(REDUCE, 415);
   _actionMap[120][KSEP] = ActionEntry(REDUCE, 415);
   _actionMap[120][ASC] = ActionEntry(REDUCE, 415);
   _actionMap[120][DESC] = ActionEntry(REDUCE, 415);
   _actionMap[120][PLUS] = ActionEntry(REDUCE, 415);
   _actionMap[120][MINUS] = ActionEntry(REDUCE, 415);
   _actionMap[120][DIVISION] = ActionEntry(REDUCE, 415);
   _actionMap[120][STAR] = ActionEntry(REDUCE, 415);
   _actionMap[120][CONCAT] = ActionEntry(REDUCE, 415);
   _actionMap[120][SEMICOLON] = ActionEntry(REDUCE, 415);
   _actionMap[121][WHEN] = ActionEntry(REDUCE, 323);
   _actionMap[121][ELSE] = ActionEntry(REDUCE, 323);
   _actionMap[121][LEFT] = ActionEntry(REDUCE, 323);
   _actionMap[121][RIGHT] = ActionEntry(REDUCE, 323);
   _actionMap[121][INNER] = ActionEntry(REDUCE, 323);
   _actionMap[121][JOIN] = ActionEntry(REDUCE, 323);
   _actionMap[121][ORDER] = ActionEntry(REDUCE, 323);
   _actionMap[121][GROUP] = ActionEntry(REDUCE, 323);
   _actionMap[121][RETURNTOKEN] = ActionEntry(REDUCE, 323);
   _actionMap[121][WHERE] = ActionEntry(REDUCE, 323);
   _actionMap[121][AS] = ActionEntry(REDUCE, 323);
   _actionMap[121][FROM] = ActionEntry(REDUCE, 323);
   _actionMap[121][END_TOKEN] = ActionEntry(REDUCE, 323);
   _actionMap[121][BEGIN] = ActionEntry(REDUCE, 323);
   _actionMap[121][THEN] = ActionEntry(REDUCE, 323);
   _actionMap[121][OR] = ActionEntry(REDUCE, 323);
   _actionMap[121][AND] = ActionEntry(REDUCE, 323);
   _actionMap[121][NCLIKE] = ActionEntry(REDUCE, 323);
   _actionMap[121][LIKE] = ActionEntry(REDUCE, 323);
   _actionMap[121][IS] = ActionEntry(REDUCE, 323);
   _actionMap[121][BETWEEN] = ActionEntry(REDUCE, 323);
   _actionMap[121][EQU] = ActionEntry(REDUCE, 323);
   _actionMap[121][NEGATION] = ActionEntry(REDUCE, 323);
   _actionMap[121][LT] = ActionEntry(REDUCE, 323);
   _actionMap[121][MT] = ActionEntry(REDUCE, 323);
   _actionMap[121][NOT] = ActionEntry(REDUCE, 323);
   _actionMap[121][INTOK] = ActionEntry(REDUCE, 323);
   _actionMap[121][DESC] = ActionEntry(REDUCE, 323);
}
void Cego::loadParser277()
{
   _actionMap[121][ASC] = ActionEntry(REDUCE, 323);
   _actionMap[121][KSEP] = ActionEntry(REDUCE, 323);
   _actionMap[121][ROWLIMIT] = ActionEntry(REDUCE, 323);
   _actionMap[121][UNION] = ActionEntry(REDUCE, 323);
   _actionMap[121][ENDTOKEN] = ActionEntry(REDUCE, 323);
   _actionMap[121][RB] = ActionEntry(REDUCE, 323);
   _actionMap[121][CONCAT] = ActionEntry(REDUCE, 323);
   _actionMap[121][STAR] = ActionEntry(REDUCE, 323);
   _actionMap[121][DIVISION] = ActionEntry(REDUCE, 323);
   _actionMap[121][MINUS] = ActionEntry(REDUCE, 323);
   _actionMap[121][PLUS] = ActionEntry(REDUCE, 323);
   _actionMap[121][SEMICOLON] = ActionEntry(REDUCE, 323);
   _actionMap[122][LB] = ActionEntry(SHIFT, 290);
   _actionMap[123][WHEN] = ActionEntry(REDUCE, 414);
   _actionMap[123][ELSE] = ActionEntry(REDUCE, 414);
   _actionMap[123][LEFT] = ActionEntry(REDUCE, 414);
   _actionMap[123][RIGHT] = ActionEntry(REDUCE, 414);
   _actionMap[123][INNER] = ActionEntry(REDUCE, 414);
   _actionMap[123][JOIN] = ActionEntry(REDUCE, 414);
   _actionMap[123][ORDER] = ActionEntry(REDUCE, 414);
   _actionMap[123][GROUP] = ActionEntry(REDUCE, 414);
   _actionMap[123][RETURNTOKEN] = ActionEntry(REDUCE, 414);
   _actionMap[123][WHERE] = ActionEntry(REDUCE, 414);
   _actionMap[123][NULLTOKEN] = ActionEntry(REDUCE, 414);
   _actionMap[123][FROM] = ActionEntry(REDUCE, 414);
   _actionMap[123][AS] = ActionEntry(REDUCE, 414);
   _actionMap[123][END_TOKEN] = ActionEntry(REDUCE, 414);
   _actionMap[123][BEGIN] = ActionEntry(REDUCE, 414);
   _actionMap[123][THEN] = ActionEntry(REDUCE, 414);
   _actionMap[123][AND] = ActionEntry(REDUCE, 414);
   _actionMap[123][OR] = ActionEntry(REDUCE, 414);
   _actionMap[123][INTOK] = ActionEntry(REDUCE, 414);
   _actionMap[123][NOT] = ActionEntry(REDUCE, 414);
   _actionMap[123][MT] = ActionEntry(REDUCE, 414);
   _actionMap[123][LT] = ActionEntry(REDUCE, 414);
   _actionMap[123][NEGATION] = ActionEntry(REDUCE, 414);
   _actionMap[123][EQU] = ActionEntry(REDUCE, 414);
   _actionMap[123][BETWEEN] = ActionEntry(REDUCE, 414);
   _actionMap[123][IS] = ActionEntry(REDUCE, 414);
   _actionMap[123][LIKE] = ActionEntry(REDUCE, 414);
   _actionMap[123][NCLIKE] = ActionEntry(REDUCE, 414);
   _actionMap[123][RB] = ActionEntry(REDUCE, 414);
   _actionMap[123][ENDTOKEN] = ActionEntry(REDUCE, 414);
   _actionMap[123][UNION] = ActionEntry(REDUCE, 414);
   _actionMap[123][ROWLIMIT] = ActionEntry(REDUCE, 414);
   _actionMap[123][KSEP] = ActionEntry(REDUCE, 414);
   _actionMap[123][ASC] = ActionEntry(REDUCE, 414);
   _actionMap[123][DESC] = ActionEntry(REDUCE, 414);
   _actionMap[123][PLUS] = ActionEntry(REDUCE, 414);
   _actionMap[123][MINUS] = ActionEntry(REDUCE, 414);
}
void Cego::loadParser278()
{
   _actionMap[123][DIVISION] = ActionEntry(REDUCE, 414);
   _actionMap[123][STAR] = ActionEntry(REDUCE, 414);
   _actionMap[123][CONCAT] = ActionEntry(REDUCE, 414);
   _actionMap[123][SEMICOLON] = ActionEntry(REDUCE, 414);
   _actionMap[124][LB] = ActionEntry(SHIFT, 291);
   _actionMap[125][LB] = ActionEntry(SHIFT, 292);
   _actionMap[126][LB] = ActionEntry(SHIFT, 293);
   _actionMap[127][LB] = ActionEntry(SHIFT, 294);
   _actionMap[128][LB] = ActionEntry(SHIFT, 295);
   _actionMap[129][LAB] = ActionEntry(SHIFT, 296);
   _actionMap[130][LB] = ActionEntry(SHIFT, 297);
   _actionMap[131][LB] = ActionEntry(SHIFT, 298);
   _actionMap[132][WHEN] = ActionEntry(REDUCE, 113);
   _actionMap[133][LAB] = ActionEntry(SHIFT, 299);
   _actionMap[134][LB] = ActionEntry(SHIFT, 300);
   _actionMap[135][LB] = ActionEntry(SHIFT, 301);
   _actionMap[136][LB] = ActionEntry(SHIFT, 302);
   _actionMap[137][LB] = ActionEntry(SHIFT, 303);
   _actionMap[138][LB] = ActionEntry(SHIFT, 304);
   _actionMap[139][LB] = ActionEntry(SHIFT, 305);
   _actionMap[140][LB] = ActionEntry(SHIFT, 306);
   _actionMap[141][WHEN] = ActionEntry(REDUCE, 422);
   _actionMap[141][ELSE] = ActionEntry(REDUCE, 422);
   _actionMap[141][LEFT] = ActionEntry(REDUCE, 422);
   _actionMap[141][RIGHT] = ActionEntry(REDUCE, 422);
   _actionMap[141][INNER] = ActionEntry(REDUCE, 422);
   _actionMap[141][JOIN] = ActionEntry(REDUCE, 422);
   _actionMap[141][ORDER] = ActionEntry(REDUCE, 422);
   _actionMap[141][GROUP] = ActionEntry(REDUCE, 422);
   _actionMap[141][RETURNTOKEN] = ActionEntry(REDUCE, 422);
   _actionMap[141][WHERE] = ActionEntry(REDUCE, 422);
   _actionMap[141][FROM] = ActionEntry(REDUCE, 422);
   _actionMap[141][AS] = ActionEntry(REDUCE, 422);
   _actionMap[141][END_TOKEN] = ActionEntry(REDUCE, 422);
   _actionMap[141][BEGIN] = ActionEntry(REDUCE, 422);
   _actionMap[141][THEN] = ActionEntry(REDUCE, 422);
   _actionMap[141][NULLTOKEN] = ActionEntry(REDUCE, 422);
   _actionMap[141][AND] = ActionEntry(REDUCE, 422);
   _actionMap[141][OR] = ActionEntry(REDUCE, 422);
   _actionMap[141][INTOK] = ActionEntry(REDUCE, 422);
   _actionMap[141][NOT] = ActionEntry(REDUCE, 422);
   _actionMap[141][MT] = ActionEntry(REDUCE, 422);
   _actionMap[141][LT] = ActionEntry(REDUCE, 422);
   _actionMap[141][NEGATION] = ActionEntry(REDUCE, 422);
   _actionMap[141][EQU] = ActionEntry(REDUCE, 422);
   _actionMap[141][BETWEEN] = ActionEntry(REDUCE, 422);
   _actionMap[141][IS] = ActionEntry(REDUCE, 422);
   _actionMap[141][LIKE] = ActionEntry(REDUCE, 422);
   _actionMap[141][NCLIKE] = ActionEntry(REDUCE, 422);
   _actionMap[141][RB] = ActionEntry(REDUCE, 422);
}
void Cego::loadParser279()
{
   _actionMap[141][ENDTOKEN] = ActionEntry(REDUCE, 422);
   _actionMap[141][UNION] = ActionEntry(REDUCE, 422);
   _actionMap[141][ROWLIMIT] = ActionEntry(REDUCE, 422);
   _actionMap[141][KSEP] = ActionEntry(REDUCE, 422);
   _actionMap[141][ASC] = ActionEntry(REDUCE, 422);
   _actionMap[141][DESC] = ActionEntry(REDUCE, 422);
   _actionMap[141][PLUS] = ActionEntry(REDUCE, 422);
   _actionMap[141][MINUS] = ActionEntry(REDUCE, 422);
   _actionMap[141][DIVISION] = ActionEntry(REDUCE, 422);
   _actionMap[141][STAR] = ActionEntry(REDUCE, 422);
   _actionMap[141][CONCAT] = ActionEntry(REDUCE, 422);
   _actionMap[141][SEMICOLON] = ActionEntry(REDUCE, 422);
   _actionMap[142][IDENTIFIER] = ActionEntry(SHIFT, 307);
   _actionMap[143][LB] = ActionEntry(SHIFT, 308);
   _actionMap[144][LB] = ActionEntry(SHIFT, 309);
   _actionMap[145][LB] = ActionEntry(SHIFT, 310);
   _actionMap[146][LB] = ActionEntry(SHIFT, 311);
   _actionMap[147][LB] = ActionEntry(SHIFT, 312);
   _actionMap[148][LB] = ActionEntry(SHIFT, 313);
   _actionMap[149][LB] = ActionEntry(SHIFT, 314);
   _actionMap[150][LB] = ActionEntry(SHIFT, 315);
   _actionMap[151][LB] = ActionEntry(SHIFT, 316);
   _actionMap[152][LB] = ActionEntry(SHIFT, 317);
   _actionMap[153][LB] = ActionEntry(SHIFT, 318);
   _actionMap[154][LB] = ActionEntry(SHIFT, 319);
   _actionMap[155][LB] = ActionEntry(SHIFT, 320);
   _actionMap[156][LB] = ActionEntry(SHIFT, 321);
   _actionMap[157][LB] = ActionEntry(SHIFT, 322);
   _actionMap[158][WHEN] = ActionEntry(REDUCE, 420);
   _actionMap[158][ELSE] = ActionEntry(REDUCE, 420);
   _actionMap[158][LEFT] = ActionEntry(REDUCE, 420);
   _actionMap[158][RIGHT] = ActionEntry(REDUCE, 420);
   _actionMap[158][INNER] = ActionEntry(REDUCE, 420);
   _actionMap[158][JOIN] = ActionEntry(REDUCE, 420);
   _actionMap[158][ORDER] = ActionEntry(REDUCE, 420);
   _actionMap[158][GROUP] = ActionEntry(REDUCE, 420);
   _actionMap[158][RETURNTOKEN] = ActionEntry(REDUCE, 420);
   _actionMap[158][WHERE] = ActionEntry(REDUCE, 420);
   _actionMap[158][FROM] = ActionEntry(REDUCE, 420);
   _actionMap[158][AS] = ActionEntry(REDUCE, 420);
   _actionMap[158][END_TOKEN] = ActionEntry(REDUCE, 420);
   _actionMap[158][BEGIN] = ActionEntry(REDUCE, 420);
   _actionMap[158][THEN] = ActionEntry(REDUCE, 420);
   _actionMap[158][NULLTOKEN] = ActionEntry(REDUCE, 420);
   _actionMap[158][AND] = ActionEntry(REDUCE, 420);
   _actionMap[158][OR] = ActionEntry(REDUCE, 420);
   _actionMap[158][INTOK] = ActionEntry(REDUCE, 420);
   _actionMap[158][NOT] = ActionEntry(REDUCE, 420);
   _actionMap[158][MT] = ActionEntry(REDUCE, 420);
   _actionMap[158][LT] = ActionEntry(REDUCE, 420);
}
void Cego::loadParser280()
{
   _actionMap[158][NEGATION] = ActionEntry(REDUCE, 420);
   _actionMap[158][EQU] = ActionEntry(REDUCE, 420);
   _actionMap[158][BETWEEN] = ActionEntry(REDUCE, 420);
   _actionMap[158][IS] = ActionEntry(REDUCE, 420);
   _actionMap[158][LIKE] = ActionEntry(REDUCE, 420);
   _actionMap[158][NCLIKE] = ActionEntry(REDUCE, 420);
   _actionMap[158][RB] = ActionEntry(REDUCE, 420);
   _actionMap[158][ENDTOKEN] = ActionEntry(REDUCE, 420);
   _actionMap[158][UNION] = ActionEntry(REDUCE, 420);
   _actionMap[158][ROWLIMIT] = ActionEntry(REDUCE, 420);
   _actionMap[158][KSEP] = ActionEntry(REDUCE, 420);
   _actionMap[158][ASC] = ActionEntry(REDUCE, 420);
   _actionMap[158][DESC] = ActionEntry(REDUCE, 420);
   _actionMap[158][PLUS] = ActionEntry(REDUCE, 420);
   _actionMap[158][MINUS] = ActionEntry(REDUCE, 420);
   _actionMap[158][DIVISION] = ActionEntry(REDUCE, 420);
   _actionMap[158][STAR] = ActionEntry(REDUCE, 420);
   _actionMap[158][CONCAT] = ActionEntry(REDUCE, 420);
   _actionMap[158][SEMICOLON] = ActionEntry(REDUCE, 420);
   _actionMap[159][LB] = ActionEntry(SHIFT, 323);
   _actionMap[160][LB] = ActionEntry(SHIFT, 324);
   _actionMap[161][LB] = ActionEntry(SHIFT, 325);
   _actionMap[162][LB] = ActionEntry(SHIFT, 326);
   _actionMap[163][LB] = ActionEntry(SHIFT, 327);
   _actionMap[164][LB] = ActionEntry(SHIFT, 328);
   _actionMap[165][LB] = ActionEntry(SHIFT, 329);
   _actionMap[166][LB] = ActionEntry(SHIFT, 330);
   _actionMap[167][LB] = ActionEntry(SHIFT, 331);
   _actionMap[168][LB] = ActionEntry(SHIFT, 332);
   _actionMap[169][LB] = ActionEntry(SHIFT, 333);
   _actionMap[170][LB] = ActionEntry(SHIFT, 334);
   _actionMap[171][WHEN] = ActionEntry(REDUCE, 419);
   _actionMap[171][ELSE] = ActionEntry(REDUCE, 419);
   _actionMap[171][FROM] = ActionEntry(REDUCE, 419);
   _actionMap[171][AS] = ActionEntry(REDUCE, 419);
   _actionMap[171][END_TOKEN] = ActionEntry(REDUCE, 419);
   _actionMap[171][BEGIN] = ActionEntry(REDUCE, 419);
   _actionMap[171][THEN] = ActionEntry(REDUCE, 419);
   _actionMap[171][LEFT] = ActionEntry(REDUCE, 419);
   _actionMap[171][RIGHT] = ActionEntry(REDUCE, 419);
   _actionMap[171][INNER] = ActionEntry(REDUCE, 419);
   _actionMap[171][JOIN] = ActionEntry(REDUCE, 419);
   _actionMap[171][ORDER] = ActionEntry(REDUCE, 419);
   _actionMap[171][GROUP] = ActionEntry(REDUCE, 419);
   _actionMap[171][RETURNTOKEN] = ActionEntry(REDUCE, 419);
   _actionMap[171][WHERE] = ActionEntry(REDUCE, 419);
   _actionMap[171][NULLTOKEN] = ActionEntry(REDUCE, 419);
   _actionMap[171][AND] = ActionEntry(REDUCE, 419);
   _actionMap[171][OR] = ActionEntry(REDUCE, 419);
   _actionMap[171][INTOK] = ActionEntry(REDUCE, 419);
}
void Cego::loadParser281()
{
   _actionMap[171][NOT] = ActionEntry(REDUCE, 419);
   _actionMap[171][MT] = ActionEntry(REDUCE, 419);
   _actionMap[171][LT] = ActionEntry(REDUCE, 419);
   _actionMap[171][NEGATION] = ActionEntry(REDUCE, 419);
   _actionMap[171][EQU] = ActionEntry(REDUCE, 419);
   _actionMap[171][BETWEEN] = ActionEntry(REDUCE, 419);
   _actionMap[171][IS] = ActionEntry(REDUCE, 419);
   _actionMap[171][LIKE] = ActionEntry(REDUCE, 419);
   _actionMap[171][NCLIKE] = ActionEntry(REDUCE, 419);
   _actionMap[171][RB] = ActionEntry(REDUCE, 419);
   _actionMap[171][ENDTOKEN] = ActionEntry(REDUCE, 419);
   _actionMap[171][UNION] = ActionEntry(REDUCE, 419);
   _actionMap[171][ROWLIMIT] = ActionEntry(REDUCE, 419);
   _actionMap[171][KSEP] = ActionEntry(REDUCE, 419);
   _actionMap[171][ASC] = ActionEntry(REDUCE, 419);
   _actionMap[171][DESC] = ActionEntry(REDUCE, 419);
   _actionMap[171][PLUS] = ActionEntry(REDUCE, 419);
   _actionMap[171][MINUS] = ActionEntry(REDUCE, 419);
   _actionMap[171][DIVISION] = ActionEntry(REDUCE, 419);
   _actionMap[171][STAR] = ActionEntry(REDUCE, 419);
   _actionMap[171][CONCAT] = ActionEntry(REDUCE, 419);
   _actionMap[171][SEMICOLON] = ActionEntry(REDUCE, 419);
   _actionMap[172][LB] = ActionEntry(SHIFT, 335);
   _actionMap[173][LB] = ActionEntry(SHIFT, 336);
   _actionMap[174][LB] = ActionEntry(SHIFT, 337);
   _actionMap[175][WHEN] = ActionEntry(REDUCE, 421);
   _actionMap[175][ELSE] = ActionEntry(REDUCE, 421);
   _actionMap[175][FROM] = ActionEntry(REDUCE, 421);
   _actionMap[175][AS] = ActionEntry(REDUCE, 421);
   _actionMap[175][END_TOKEN] = ActionEntry(REDUCE, 421);
   _actionMap[175][BEGIN] = ActionEntry(REDUCE, 421);
   _actionMap[175][THEN] = ActionEntry(REDUCE, 421);
   _actionMap[175][LEFT] = ActionEntry(REDUCE, 421);
   _actionMap[175][RIGHT] = ActionEntry(REDUCE, 421);
   _actionMap[175][INNER] = ActionEntry(REDUCE, 421);
   _actionMap[175][JOIN] = ActionEntry(REDUCE, 421);
   _actionMap[175][ORDER] = ActionEntry(REDUCE, 421);
   _actionMap[175][GROUP] = ActionEntry(REDUCE, 421);
   _actionMap[175][RETURNTOKEN] = ActionEntry(REDUCE, 421);
   _actionMap[175][WHERE] = ActionEntry(REDUCE, 421);
   _actionMap[175][NULLTOKEN] = ActionEntry(REDUCE, 421);
   _actionMap[175][AND] = ActionEntry(REDUCE, 421);
   _actionMap[175][OR] = ActionEntry(REDUCE, 421);
   _actionMap[175][INTOK] = ActionEntry(REDUCE, 421);
   _actionMap[175][NOT] = ActionEntry(REDUCE, 421);
   _actionMap[175][MT] = ActionEntry(REDUCE, 421);
   _actionMap[175][LT] = ActionEntry(REDUCE, 421);
   _actionMap[175][NEGATION] = ActionEntry(REDUCE, 421);
   _actionMap[175][EQU] = ActionEntry(REDUCE, 421);
   _actionMap[175][BETWEEN] = ActionEntry(REDUCE, 421);
}
void Cego::loadParser282()
{
   _actionMap[175][IS] = ActionEntry(REDUCE, 421);
   _actionMap[175][LIKE] = ActionEntry(REDUCE, 421);
   _actionMap[175][NCLIKE] = ActionEntry(REDUCE, 421);
   _actionMap[175][RB] = ActionEntry(REDUCE, 421);
   _actionMap[175][ENDTOKEN] = ActionEntry(REDUCE, 421);
   _actionMap[175][UNION] = ActionEntry(REDUCE, 421);
   _actionMap[175][ROWLIMIT] = ActionEntry(REDUCE, 421);
   _actionMap[175][KSEP] = ActionEntry(REDUCE, 421);
   _actionMap[175][ASC] = ActionEntry(REDUCE, 421);
   _actionMap[175][DESC] = ActionEntry(REDUCE, 421);
   _actionMap[175][PLUS] = ActionEntry(REDUCE, 421);
   _actionMap[175][MINUS] = ActionEntry(REDUCE, 421);
   _actionMap[175][DIVISION] = ActionEntry(REDUCE, 421);
   _actionMap[175][STAR] = ActionEntry(REDUCE, 421);
   _actionMap[175][CONCAT] = ActionEntry(REDUCE, 421);
   _actionMap[175][SEMICOLON] = ActionEntry(REDUCE, 421);
   _actionMap[176][LB] = ActionEntry(SHIFT, 338);
   _actionMap[177][LB] = ActionEntry(SHIFT, 339);
   _actionMap[178][LONG] = ActionEntry(SHIFT, 346);
   _actionMap[178][BIGINT] = ActionEntry(SHIFT, 342);
   _actionMap[178][SMALLINT] = ActionEntry(SHIFT, 347);
   _actionMap[178][TINYINT] = ActionEntry(SHIFT, 348);
   _actionMap[178][DOUBLE] = ActionEntry(SHIFT, 345);
   _actionMap[178][DECIMAL] = ActionEntry(SHIFT, 344);
   _actionMap[178][DATETIME] = ActionEntry(SHIFT, 343);
   _actionMap[178][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[178][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[178][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[178][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[178][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[178][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[178][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[178][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[178][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[178][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[178][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[178][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[178][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[178][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[178][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[178][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[178][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[178][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[178][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[178][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[178][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[178][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[178][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[178][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[178][STR2LONG] = ActionEntry(SHIFT, 173);
}
void Cego::loadParser283()
{
   _actionMap[178][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[178][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[178][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[178][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[178][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[178][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[178][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[178][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[178][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[178][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[178][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[178][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[178][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[178][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[178][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[178][REGMATCH] = ActionEntry(SHIFT, 162);
   _actionMap[178][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[178][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[178][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[178][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[178][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[178][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[178][LB] = ActionEntry(SHIFT, 178);
   _actionMap[178][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[178][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[178][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[178][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[178][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[178][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[178][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[178][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[178][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[178][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[178][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[178][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[178][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[178][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[178][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[178][MAX] = ActionEntry(SHIFT, 155);
   _actionMap[178][EXISTS] = ActionEntry(SHIFT, 277);
   _actionMap[178][NOT] = ActionEntry(SHIFT, 278);
   _actionMap[178][SELECT] = ActionEntry(SHIFT, 34);
   _jumpMap[178][ObjSpec] = 122;
   _jumpMap[178][Constant] = 121;
   _jumpMap[178][SignedFloat] = 120;
   _jumpMap[178][SignedInt] = 119;
   _jumpMap[178][Attribute] = 118;
   _jumpMap[178][Function] = 117;
   _jumpMap[178][Factor] = 116;
   _jumpMap[178][Term] = 115;
}
void Cego::loadParser284()
{
   _jumpMap[178][Expr] = 276;
   _jumpMap[178][Predicate] = 275;
   _jumpMap[178][Conjunction] = 274;
   _jumpMap[178][Condition] = 341;
   _jumpMap[178][SelectStatement] = 340;
   _jumpMap[178][CasePrepare] = 113;
   _jumpMap[178][CaseClause] = 112;
   _actionMap[179][FLOATVAL] = ActionEntry(SHIFT, 350);
   _actionMap[179][INTVAL] = ActionEntry(SHIFT, 349);
   _actionMap[180][WHEN] = ActionEntry(REDUCE, 405);
   _actionMap[180][ELSE] = ActionEntry(REDUCE, 405);
   _actionMap[180][AS] = ActionEntry(REDUCE, 405);
   _actionMap[180][FROM] = ActionEntry(REDUCE, 405);
   _actionMap[180][END_TOKEN] = ActionEntry(REDUCE, 405);
   _actionMap[180][BEGIN] = ActionEntry(REDUCE, 405);
   _actionMap[180][THEN] = ActionEntry(REDUCE, 405);
   _actionMap[180][LEFT] = ActionEntry(REDUCE, 405);
   _actionMap[180][RIGHT] = ActionEntry(REDUCE, 405);
   _actionMap[180][INNER] = ActionEntry(REDUCE, 405);
   _actionMap[180][JOIN] = ActionEntry(REDUCE, 405);
   _actionMap[180][ORDER] = ActionEntry(REDUCE, 405);
   _actionMap[180][GROUP] = ActionEntry(REDUCE, 405);
   _actionMap[180][RETURNTOKEN] = ActionEntry(REDUCE, 405);
   _actionMap[180][WHERE] = ActionEntry(REDUCE, 405);
   _actionMap[180][NULLTOKEN] = ActionEntry(REDUCE, 405);
   _actionMap[180][OR] = ActionEntry(REDUCE, 405);
   _actionMap[180][AND] = ActionEntry(REDUCE, 405);
   _actionMap[180][NCLIKE] = ActionEntry(REDUCE, 405);
   _actionMap[180][LIKE] = ActionEntry(REDUCE, 405);
   _actionMap[180][IS] = ActionEntry(REDUCE, 405);
   _actionMap[180][BETWEEN] = ActionEntry(REDUCE, 405);
   _actionMap[180][EQU] = ActionEntry(REDUCE, 405);
   _actionMap[180][NEGATION] = ActionEntry(REDUCE, 405);
   _actionMap[180][LT] = ActionEntry(REDUCE, 405);
   _actionMap[180][MT] = ActionEntry(REDUCE, 405);
   _actionMap[180][NOT] = ActionEntry(REDUCE, 405);
   _actionMap[180][INTOK] = ActionEntry(REDUCE, 405);
   _actionMap[180][DESC] = ActionEntry(REDUCE, 405);
   _actionMap[180][ASC] = ActionEntry(REDUCE, 405);
   _actionMap[180][KSEP] = ActionEntry(REDUCE, 405);
   _actionMap[180][ROWLIMIT] = ActionEntry(REDUCE, 405);
   _actionMap[180][UNION] = ActionEntry(REDUCE, 405);
   _actionMap[180][ENDTOKEN] = ActionEntry(REDUCE, 405);
   _actionMap[180][RB] = ActionEntry(REDUCE, 405);
   _actionMap[180][CONCAT] = ActionEntry(REDUCE, 405);
   _actionMap[180][STAR] = ActionEntry(REDUCE, 405);
   _actionMap[180][DIVISION] = ActionEntry(REDUCE, 405);
   _actionMap[180][MINUS] = ActionEntry(REDUCE, 405);
   _actionMap[180][PLUS] = ActionEntry(REDUCE, 405);
   _actionMap[180][SEMICOLON] = ActionEntry(REDUCE, 405);
}
void Cego::loadParser285()
{
   _actionMap[181][WHEN] = ActionEntry(REDUCE, 407);
   _actionMap[181][ELSE] = ActionEntry(REDUCE, 407);
   _actionMap[181][AS] = ActionEntry(REDUCE, 407);
   _actionMap[181][FROM] = ActionEntry(REDUCE, 407);
   _actionMap[181][END_TOKEN] = ActionEntry(REDUCE, 407);
   _actionMap[181][BEGIN] = ActionEntry(REDUCE, 407);
   _actionMap[181][THEN] = ActionEntry(REDUCE, 407);
   _actionMap[181][LEFT] = ActionEntry(REDUCE, 407);
   _actionMap[181][RIGHT] = ActionEntry(REDUCE, 407);
   _actionMap[181][INNER] = ActionEntry(REDUCE, 407);
   _actionMap[181][JOIN] = ActionEntry(REDUCE, 407);
   _actionMap[181][ORDER] = ActionEntry(REDUCE, 407);
   _actionMap[181][GROUP] = ActionEntry(REDUCE, 407);
   _actionMap[181][RETURNTOKEN] = ActionEntry(REDUCE, 407);
   _actionMap[181][WHERE] = ActionEntry(REDUCE, 407);
   _actionMap[181][NULLTOKEN] = ActionEntry(REDUCE, 407);
   _actionMap[181][OR] = ActionEntry(REDUCE, 407);
   _actionMap[181][AND] = ActionEntry(REDUCE, 407);
   _actionMap[181][NCLIKE] = ActionEntry(REDUCE, 407);
   _actionMap[181][LIKE] = ActionEntry(REDUCE, 407);
   _actionMap[181][IS] = ActionEntry(REDUCE, 407);
   _actionMap[181][BETWEEN] = ActionEntry(REDUCE, 407);
   _actionMap[181][EQU] = ActionEntry(REDUCE, 407);
   _actionMap[181][NEGATION] = ActionEntry(REDUCE, 407);
   _actionMap[181][LT] = ActionEntry(REDUCE, 407);
   _actionMap[181][MT] = ActionEntry(REDUCE, 407);
   _actionMap[181][NOT] = ActionEntry(REDUCE, 407);
   _actionMap[181][INTOK] = ActionEntry(REDUCE, 407);
   _actionMap[181][DESC] = ActionEntry(REDUCE, 407);
   _actionMap[181][ASC] = ActionEntry(REDUCE, 407);
   _actionMap[181][KSEP] = ActionEntry(REDUCE, 407);
   _actionMap[181][ROWLIMIT] = ActionEntry(REDUCE, 407);
   _actionMap[181][UNION] = ActionEntry(REDUCE, 407);
   _actionMap[181][ENDTOKEN] = ActionEntry(REDUCE, 407);
   _actionMap[181][RB] = ActionEntry(REDUCE, 407);
   _actionMap[181][CONCAT] = ActionEntry(REDUCE, 407);
   _actionMap[181][STAR] = ActionEntry(REDUCE, 407);
   _actionMap[181][DIVISION] = ActionEntry(REDUCE, 407);
   _actionMap[181][MINUS] = ActionEntry(REDUCE, 407);
   _actionMap[181][PLUS] = ActionEntry(REDUCE, 407);
   _actionMap[181][SEMICOLON] = ActionEntry(REDUCE, 407);
   _actionMap[182][WHEN] = ActionEntry(REDUCE, 402);
   _actionMap[182][ELSE] = ActionEntry(REDUCE, 402);
   _actionMap[182][FROM] = ActionEntry(REDUCE, 402);
   _actionMap[182][AS] = ActionEntry(REDUCE, 402);
   _actionMap[182][END_TOKEN] = ActionEntry(REDUCE, 402);
   _actionMap[182][BEGIN] = ActionEntry(REDUCE, 402);
   _actionMap[182][THEN] = ActionEntry(REDUCE, 402);
   _actionMap[182][LEFT] = ActionEntry(REDUCE, 402);
   _actionMap[182][RIGHT] = ActionEntry(REDUCE, 402);
}
void Cego::loadParser286()
{
   _actionMap[182][INNER] = ActionEntry(REDUCE, 402);
   _actionMap[182][JOIN] = ActionEntry(REDUCE, 402);
   _actionMap[182][ORDER] = ActionEntry(REDUCE, 402);
   _actionMap[182][GROUP] = ActionEntry(REDUCE, 402);
   _actionMap[182][RETURNTOKEN] = ActionEntry(REDUCE, 402);
   _actionMap[182][WHERE] = ActionEntry(REDUCE, 402);
   _actionMap[182][AND] = ActionEntry(REDUCE, 402);
   _actionMap[182][OR] = ActionEntry(REDUCE, 402);
   _actionMap[182][INTOK] = ActionEntry(REDUCE, 402);
   _actionMap[182][NOT] = ActionEntry(REDUCE, 402);
   _actionMap[182][MT] = ActionEntry(REDUCE, 402);
   _actionMap[182][LT] = ActionEntry(REDUCE, 402);
   _actionMap[182][NEGATION] = ActionEntry(REDUCE, 402);
   _actionMap[182][EQU] = ActionEntry(REDUCE, 402);
   _actionMap[182][BETWEEN] = ActionEntry(REDUCE, 402);
   _actionMap[182][IS] = ActionEntry(REDUCE, 402);
   _actionMap[182][LIKE] = ActionEntry(REDUCE, 402);
   _actionMap[182][NCLIKE] = ActionEntry(REDUCE, 402);
   _actionMap[182][RB] = ActionEntry(REDUCE, 402);
   _actionMap[182][ENDTOKEN] = ActionEntry(REDUCE, 402);
   _actionMap[182][UNION] = ActionEntry(REDUCE, 402);
   _actionMap[182][ROWLIMIT] = ActionEntry(REDUCE, 402);
   _actionMap[182][KSEP] = ActionEntry(REDUCE, 402);
   _actionMap[182][ASC] = ActionEntry(REDUCE, 402);
   _actionMap[182][DESC] = ActionEntry(REDUCE, 402);
   _actionMap[182][PLUS] = ActionEntry(REDUCE, 402);
   _actionMap[182][MINUS] = ActionEntry(REDUCE, 402);
   _actionMap[182][LB] = ActionEntry(REDUCE, 425);
   _actionMap[182][DIVISION] = ActionEntry(REDUCE, 402);
   _actionMap[182][STAR] = ActionEntry(REDUCE, 402);
   _actionMap[182][CONCAT] = ActionEntry(REDUCE, 402);
   _actionMap[182][SEMICOLON] = ActionEntry(REDUCE, 402);
   _actionMap[183][WHEN] = ActionEntry(REDUCE, 322);
   _actionMap[183][ELSE] = ActionEntry(REDUCE, 322);
   _actionMap[183][AS] = ActionEntry(REDUCE, 322);
   _actionMap[183][FROM] = ActionEntry(REDUCE, 322);
   _actionMap[183][END_TOKEN] = ActionEntry(REDUCE, 322);
   _actionMap[183][BEGIN] = ActionEntry(REDUCE, 322);
   _actionMap[183][THEN] = ActionEntry(REDUCE, 322);
   _actionMap[183][LEFT] = ActionEntry(REDUCE, 322);
   _actionMap[183][RIGHT] = ActionEntry(REDUCE, 322);
   _actionMap[183][INNER] = ActionEntry(REDUCE, 322);
   _actionMap[183][JOIN] = ActionEntry(REDUCE, 322);
   _actionMap[183][ORDER] = ActionEntry(REDUCE, 322);
   _actionMap[183][GROUP] = ActionEntry(REDUCE, 322);
   _actionMap[183][RETURNTOKEN] = ActionEntry(REDUCE, 322);
   _actionMap[183][WHERE] = ActionEntry(REDUCE, 322);
   _actionMap[183][OR] = ActionEntry(REDUCE, 322);
   _actionMap[183][AND] = ActionEntry(REDUCE, 322);
   _actionMap[183][NCLIKE] = ActionEntry(REDUCE, 322);
}
void Cego::loadParser287()
{
   _actionMap[183][LIKE] = ActionEntry(REDUCE, 322);
   _actionMap[183][IS] = ActionEntry(REDUCE, 322);
   _actionMap[183][BETWEEN] = ActionEntry(REDUCE, 322);
   _actionMap[183][EQU] = ActionEntry(REDUCE, 322);
   _actionMap[183][NEGATION] = ActionEntry(REDUCE, 322);
   _actionMap[183][LT] = ActionEntry(REDUCE, 322);
   _actionMap[183][MT] = ActionEntry(REDUCE, 322);
   _actionMap[183][NOT] = ActionEntry(REDUCE, 322);
   _actionMap[183][INTOK] = ActionEntry(REDUCE, 322);
   _actionMap[183][CONCAT] = ActionEntry(REDUCE, 322);
   _actionMap[183][STAR] = ActionEntry(REDUCE, 322);
   _actionMap[183][DIVISION] = ActionEntry(REDUCE, 322);
   _actionMap[183][MINUS] = ActionEntry(REDUCE, 322);
   _actionMap[183][PLUS] = ActionEntry(REDUCE, 322);
   _actionMap[183][DESC] = ActionEntry(REDUCE, 322);
   _actionMap[183][ASC] = ActionEntry(REDUCE, 322);
   _actionMap[183][KSEP] = ActionEntry(REDUCE, 322);
   _actionMap[183][ROWLIMIT] = ActionEntry(REDUCE, 322);
   _actionMap[183][UNION] = ActionEntry(REDUCE, 322);
   _actionMap[183][ENDTOKEN] = ActionEntry(REDUCE, 322);
   _actionMap[183][RB] = ActionEntry(REDUCE, 322);
   _actionMap[183][SEMICOLON] = ActionEntry(REDUCE, 322);
   _actionMap[184][WHEN] = ActionEntry(REDUCE, 403);
   _actionMap[184][ELSE] = ActionEntry(REDUCE, 403);
   _actionMap[184][FROM] = ActionEntry(REDUCE, 403);
   _actionMap[184][AS] = ActionEntry(REDUCE, 403);
   _actionMap[184][END_TOKEN] = ActionEntry(REDUCE, 403);
   _actionMap[184][BEGIN] = ActionEntry(REDUCE, 403);
   _actionMap[184][THEN] = ActionEntry(REDUCE, 403);
   _actionMap[184][LEFT] = ActionEntry(REDUCE, 403);
   _actionMap[184][RIGHT] = ActionEntry(REDUCE, 403);
   _actionMap[184][INNER] = ActionEntry(REDUCE, 403);
   _actionMap[184][JOIN] = ActionEntry(REDUCE, 403);
   _actionMap[184][ORDER] = ActionEntry(REDUCE, 403);
   _actionMap[184][GROUP] = ActionEntry(REDUCE, 403);
   _actionMap[184][RETURNTOKEN] = ActionEntry(REDUCE, 403);
   _actionMap[184][WHERE] = ActionEntry(REDUCE, 403);
   _actionMap[184][AND] = ActionEntry(REDUCE, 403);
   _actionMap[184][OR] = ActionEntry(REDUCE, 403);
   _actionMap[184][INTOK] = ActionEntry(REDUCE, 403);
   _actionMap[184][NOT] = ActionEntry(REDUCE, 403);
   _actionMap[184][MT] = ActionEntry(REDUCE, 403);
   _actionMap[184][LT] = ActionEntry(REDUCE, 403);
   _actionMap[184][NEGATION] = ActionEntry(REDUCE, 403);
   _actionMap[184][EQU] = ActionEntry(REDUCE, 403);
   _actionMap[184][BETWEEN] = ActionEntry(REDUCE, 403);
   _actionMap[184][IS] = ActionEntry(REDUCE, 403);
   _actionMap[184][LIKE] = ActionEntry(REDUCE, 403);
   _actionMap[184][NCLIKE] = ActionEntry(REDUCE, 403);
   _actionMap[184][RB] = ActionEntry(REDUCE, 403);
}
void Cego::loadParser288()
{
   _actionMap[184][ENDTOKEN] = ActionEntry(REDUCE, 403);
   _actionMap[184][UNION] = ActionEntry(REDUCE, 403);
   _actionMap[184][ROWLIMIT] = ActionEntry(REDUCE, 403);
   _actionMap[184][KSEP] = ActionEntry(REDUCE, 403);
   _actionMap[184][ASC] = ActionEntry(REDUCE, 403);
   _actionMap[184][DESC] = ActionEntry(REDUCE, 403);
   _actionMap[184][PLUS] = ActionEntry(REDUCE, 403);
   _actionMap[184][MINUS] = ActionEntry(REDUCE, 403);
   _actionMap[184][LB] = ActionEntry(REDUCE, 426);
   _actionMap[184][DIVISION] = ActionEntry(REDUCE, 403);
   _actionMap[184][STAR] = ActionEntry(REDUCE, 403);
   _actionMap[184][CONCAT] = ActionEntry(REDUCE, 403);
   _actionMap[184][SEMICOLON] = ActionEntry(REDUCE, 403);
   _actionMap[185][STAR] = ActionEntry(SHIFT, 351);
   _actionMap[186][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[186][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[186][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[186][ObjSpec] = 352;
   _actionMap[187][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[187][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[187][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[187][ObjSpec] = 353;
   _actionMap[188][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[188][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[188][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[188][ObjSpec] = 354;
   _actionMap[189][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[189][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[189][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[189][ObjSpec] = 355;
   _actionMap[190][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[190][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[190][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[190][ObjSpec] = 356;
   _actionMap[191][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[191][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[191][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[191][ObjSpec] = 357;
   _actionMap[192][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[192][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[192][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[192][ObjSpec] = 358;
   _actionMap[193][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[193][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[193][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[193][ObjSpec] = 359;
   _actionMap[194][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[194][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[194][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[194][ObjSpec] = 360;
}
void Cego::loadParser289()
{
   _actionMap[195][IDENTIFIER] = ActionEntry(SHIFT, 62);
   _actionMap[195][QUALIFIEDOBJ] = ActionEntry(SHIFT, 63);
   _actionMap[195][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _jumpMap[195][ObjSpec] = 361;
   _actionMap[196][SEMICOLON] = ActionEntry(REDUCE, 171);
   _actionMap[196][FROM] = ActionEntry(SHIFT, 364);
   _actionMap[196][RB] = ActionEntry(REDUCE, 171);
   _jumpMap[196][NoFromOption] = 363;
   _jumpMap[196][FromOption] = 362;
   _actionMap[197][FLOATVAL] = ActionEntry(SHIFT, 181);
   _actionMap[197][MINUS] = ActionEntry(SHIFT, 179);
   _actionMap[197][INTVAL] = ActionEntry(SHIFT, 180);
   _actionMap[197][INT2ASC] = ActionEntry(SHIFT, 147);
   _actionMap[197][ASC2INT] = ActionEntry(SHIFT, 124);
   _actionMap[197][TRIM] = ActionEntry(SHIFT, 174);
   _actionMap[197][RTRIM] = ActionEntry(SHIFT, 166);
   _actionMap[197][LTRIM] = ActionEntry(SHIFT, 153);
   _actionMap[197][ROUND] = ActionEntry(SHIFT, 165);
   _actionMap[197][SCANDATE] = ActionEntry(SHIFT, 167);
   _actionMap[197][DATE2STR] = ActionEntry(SHIFT, 138);
   _actionMap[197][DATE2LONG] = ActionEntry(SHIFT, 139);
   _actionMap[197][LONG2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[197][NEWDATE] = ActionEntry(SHIFT, 146);
   _actionMap[197][LOWER] = ActionEntry(SHIFT, 152);
   _actionMap[197][UPPER] = ActionEntry(SHIFT, 177);
   _actionMap[197][LEFT] = ActionEntry(SHIFT, 148);
   _actionMap[197][RIGHT] = ActionEntry(SHIFT, 164);
   _actionMap[197][GETPOS] = ActionEntry(SHIFT, 144);
   _actionMap[197][SUBSTR] = ActionEntry(SHIFT, 169);
   _actionMap[197][REPLACE] = ActionEntry(SHIFT, 163);
   _actionMap[197][LENGTH] = ActionEntry(SHIFT, 149);
   _actionMap[197][TRUNC] = ActionEntry(SHIFT, 176);
   _actionMap[197][STR2INT] = ActionEntry(SHIFT, 172);
   _actionMap[197][STR2LONG] = ActionEntry(SHIFT, 173);
   _actionMap[197][RANDSTR] = ActionEntry(SHIFT, 160);
   _actionMap[197][RANDINT] = ActionEntry(SHIFT, 161);
   _actionMap[197][MOD] = ActionEntry(SHIFT, 156);
   _actionMap[197][DIV] = ActionEntry(SHIFT, 140);
   _actionMap[197][LMOD] = ActionEntry(SHIFT, 151);
   _actionMap[197][LDIV] = ActionEntry(SHIFT, 150);
   _actionMap[197][POWER] = ActionEntry(SHIFT, 159);
   _actionMap[197][BITAND] = ActionEntry(SHIFT, 126);
   _actionMap[197][BITOR] = ActionEntry(SHIFT, 127);
   _actionMap[197][BITXOR] = ActionEntry(SHIFT, 128);
   _actionMap[197][BLOBSIZE] = ActionEntry(SHIFT, 130);
   _actionMap[197][BLOBREF] = ActionEntry(SHIFT, 131);
   _actionMap[197][CLOBSIZE] = ActionEntry(SHIFT, 134);
   _actionMap[197][CLOBREF] = ActionEntry(SHIFT, 135);
   _actionMap[197][CLOB2STR] = ActionEntry(SHIFT, 136);
   _actionMap[197][REGMATCH] = ActionEntry(SHIFT, 162);
}
void Cego::loadParser290()
{
   _actionMap[197][NEXTCOUNT] = ActionEntry(SHIFT, 157);
   _actionMap[197][SETCOUNT] = ActionEntry(SHIFT, 168);
   _actionMap[197][GETCOUNT] = ActionEntry(SHIFT, 143);
   _actionMap[197][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[197][QUALIFIEDOBJ] = ActionEntry(SHIFT, 184);
   _actionMap[197][QUALIFIEDPRE] = ActionEntry(SHIFT, 185);
   _actionMap[197][LB] = ActionEntry(SHIFT, 178);
   _actionMap[197][STRINGVAL] = ActionEntry(SHIFT, 123);
   _actionMap[197][SYSDATE] = ActionEntry(SHIFT, 171);
   _actionMap[197][NULLTOKEN] = ActionEntry(SHIFT, 158);
   _actionMap[197][TRUEVAL] = ActionEntry(SHIFT, 175);
   _actionMap[197][FALSEVAL] = ActionEntry(SHIFT, 141);
   _actionMap[197][BLOB] = ActionEntry(SHIFT, 129);
   _actionMap[197][CLOB] = ActionEntry(SHIFT, 133);
   _actionMap[197][QUALIFIEDTS] = ActionEntry(SHIFT, 64);
   _actionMap[197][CASE] = ActionEntry(SHIFT, 132);
   _actionMap[197][VARREF] = ActionEntry(SHIFT, 183);
   _actionMap[197][FETCH] = ActionEntry(SHIFT, 142);
   _actionMap[197][COUNT] = ActionEntry(SHIFT, 137);
   _actionMap[197][SUM] = ActionEntry(SHIFT, 170);
   _actionMap[197][AVG] = ActionEntry(SHIFT, 125);
   _actionMap[197][MIN] = ActionEntry(SHIFT, 154);
   _actionMap[197][MAX] = ActionEntry(SHIFT, 155);
   _jumpMap[197][ObjSpec] = 122;
   _jumpMap[197][Constant] = 121;
   _jumpMap[197][SignedFloat] = 120;
   _jumpMap[197][SignedInt] = 119;
   _jumpMap[197][Attribute] = 118;
   _jumpMap[197][Function] = 117;
   _jumpMap[197][Factor] = 116;
   _jumpMap[197][Term] = 115;
   _jumpMap[197][Expr] = 367;
   _jumpMap[197][SelectItem] = 366;
   _jumpMap[197][SelectionList] = 365;
   _jumpMap[197][CasePrepare] = 113;
   _jumpMap[197][CaseClause] = 112;
   _actionMap[198][VARREF] = ActionEntry(REDUCE, 215);
   _actionMap[198][FETCH] = ActionEntry(REDUCE, 215);
   _actionMap[198][LB] = ActionEntry(REDUCE, 215);
   _actionMap[198][COUNT] = ActionEntry(REDUCE, 215);
   _actionMap[198][SUM] = ActionEntry(REDUCE, 215);
   _actionMap[198][AVG] = ActionEntry(REDUCE, 215);
   _actionMap[198][MIN] = ActionEntry(REDUCE, 215);
   _actionMap[198][MAX] = ActionEntry(REDUCE, 215);
   _actionMap[198][CASE] = ActionEntry(REDUCE, 215);
   _actionMap[198][INT2ASC] = ActionEntry(REDUCE, 215);
   _actionMap[198][ASC2INT] = ActionEntry(REDUCE, 215);
   _actionMap[198][TRIM] = ActionEntry(REDUCE, 215);
   _actionMap[198][RTRIM] = ActionEntry(REDUCE, 215);
   _actionMap[198][LTRIM] = ActionEntry(REDUCE, 215);
}
void Cego::loadParser291()
{
   _actionMap[198][ROUND] = ActionEntry(REDUCE, 215);
   _actionMap[198][SCANDATE] = ActionEntry(REDUCE, 215);
   _actionMap[198][DATE2STR] = ActionEntry(REDUCE, 215);
   _actionMap[198][DATE2LONG] = ActionEntry(REDUCE, 215);
   _actionMap[198][LONG2DATE] = ActionEntry(REDUCE, 215);
   _actionMap[198][NEWDATE] = ActionEntry(REDUCE, 215);
   _actionMap[198][LOWER] = ActionEntry(REDUCE, 215);
   _actionMap[198][UPPER] = ActionEntry(REDUCE, 215);
   _actionMap[198][LEFT] = ActionEntry(REDUCE, 215);
   _actionMap[198][RIGHT] = ActionEntry(REDUCE, 215);
   _actionMap[198][GETPOS] = ActionEntry(REDUCE, 215);
   _actionMap[198][SUBSTR] = ActionEntry(REDUCE, 215);
   _actionMap[198][REPLACE] = ActionEntry(REDUCE, 215);
   _actionMap[198][LENGTH] = ActionEntry(REDUCE, 215);
   _actionMap[198][TRUNC] = ActionEntry(REDUCE, 215);
   _actionMap[198][STR2INT] = ActionEntry(REDUCE, 215);
   _actionMap[198][STR2LONG] = ActionEntry(REDUCE, 215);
   _actionMap[198][RANDSTR] = Acti