#ifndef _CEGOADMINHANDLER_H_INCLUDED_
#define _CEGOADMINHANDLER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAdminHandler.h
// ------------------
// Cego admin handler class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// Class: CegoAdminHandler
// 
// Description: Administration client service request handler class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/NetHandler.h>
#include <lfcxml/XMLSuite.h>

// CEGO INCLUDES
#include "CegoTableObject.h"
#include "CegoModule.h"

class CegoAdminHandler {
    
public:
       
    enum RequestType {
	/* any node services */
	GET_TABLESETLIST,
	LOCKINFO,
	LOCKSTAT,
	PARAMETERINFO,
	POOLINFO,
	POOLENTRYLIST,
	THREADINFO,
	DBTHREADABORT,
	DBTHREADINFO,
	DBTHREADHIST,
	QUERYHISTLAST,
	QUERYHISTCOST,
	ADMTHREADINFO,
	SHOWQUERYCACHE,
	LISTQUERYCACHE,
	CLEANQUERYCACHE,
	SETQUERYCACHEPARAM,
	SHOWTABLECACHE,
	LISTTABLECACHE,
	CLEANTABLECACHE,
	SETTABLECACHEPARAM,
	DEFINE_TABLESET,
	REMOVE_TABLESET,
	RESET_TABLESET,
	CREATE_TABLESET,
	DROP_TABLESET,
	START_TABLESET,
	STOP_TABLESET,	
	SYNC_TABLESET,
	INIT_LOGS,
	START_RECOVERY,
	STOP_RECOVERY,
	SET_LOGMNG,
	SET_BACKUPMNG,
	SHOW_LOGMNG,
	SHOW_BACKUPMNG,
	SET_CHECKPOINT,
	SET_TSINITFILE,
	SET_TSSYSSIZE,
	SET_TSTMPSIZE,
	SET_TSAPPSIZE,
	SET_TSROOTPATH,
	SET_TSLOGNUM,
	SET_TSLOGSIZE,
	SET_TSSORTAREASIZE,
	SET_TSLOGUSER,
	GET_TSINFO,
	GET_DETAILED_TSINFO,
	GET_ARCHLOG_INFO,
	GET_OBJECT_INFO,
	GET_TRANSACTION_INFO,
	GET_BUSTAT,
	SET_LSN,
	EXPORT_TABLESET,
	IMPORT_TABLESET,
	EXPORT_TABLE,
	IMPORT_TABLE,
	ADD_DATAFILE,
	SHOW_USER,
	ADD_USER,
	REMOVE_USER,
	CHANGE_PWD,
	ASSIGN_ROLE,
	REMOVE_ROLE,
	LIST_ROLE,
	SHOW_ROLE,
	CREATE_ROLE,
	DROP_ROLE,
	SET_PERM,
	REMOVE_PERM,
	USER_TRACE,
	ADD_ARCHLOG,
	REMOVE_ARCHLOG,
	BEGIN_BACKUP,
	EXECUTE_BACKUP,
	END_BACKUP,
	LIST_BACKUP,
	RESTORE,
	RECOVER,
	VERIFY_TABLESET,
	CORRECT_TABLESET,
	DUMP_OBJECT,
	ENABLE_TABLECACHE,	
	DISABLE_TABLECACHE,
	ENABLE_QUERYCACHE,	
	DISABLE_QUERYCACHE,
	SET_NUMQUERYLAST,
	SET_NUMQUERYCOST,
	ENABLE_ARCHLOG,	
	DISABLE_ARCHLOG,
	ENABLE_AUTOCORRECT,	
	DISABLE_AUTOCORRECT,
	ENABLE_APPENDMODE,	
	DISABLE_APPENDMODE,
	RESET_BUSTAT,
		
	/* any requests */
	SESSION_CLOSE,
	REQTIMEOUT,
	UNKNOWN };
    
    enum ResultType { ADM_OK, ADM_ERROR, ADM_INFO };

    CegoAdminHandler(CegoModule* pModule, NetHandler *pN = 0);
    ~CegoAdminHandler();

    //////////////////////
    // protocol methods //
    //////////////////////

    ResultType requestSession(const Chain& user, const Chain& password, bool doEncrypt = true);
    ResultType closeSession();
    bool acceptSession();

    void setNetHandle(NetHandler *pN);
    NetHandler* getNetHandle();
    
    ResultType reqLockInfo(const Chain& lockCat);
    ResultType reqLockStat();
    ResultType reqPoolInfo();
    ResultType reqParameterInfo();
    
    ResultType reqPoolEntryList();
    ResultType reqThreadInfo();
    ResultType reqDbThreadInfo();
    ResultType reqDbThreadHistory(unsigned threadId);

    ResultType reqQueryHistoryLast(unsigned numLast);
    ResultType reqQueryHistoryCost(unsigned numLast);

    ResultType reqNumQueryLast(unsigned numLast);
    ResultType reqNumQueryCost(unsigned numCost);
    
    ResultType reqAdmThreadInfo();
    ResultType reqDbSessionInfo();

    ResultType reqShowQueryCache(const Chain& tableSet);
    ResultType reqListQueryCache(const Chain& tableSet);
    ResultType reqCleanQueryCache(const Chain& tableSet);
    ResultType reqSetQueryCacheParam(const Chain& tableSet, unsigned maxEntry, unsigned maxSize, unsigned threshold, unsigned hashRange);

    ResultType reqShowTableCache(const Chain& tableSet);
    ResultType reqListTableCache(const Chain& tableSet);
    ResultType reqCleanTableCache(const Chain& tableSet);

    ResultType reqSetTableCacheParam(const Chain& tableSet, const Chain& cacheFilter, unsigned maxEntry,
				     unsigned maxSize, unsigned hashRange);
        
    ResultType reqDbThreadAbort(unsigned threadId);

    ResultType reqDefineTableSet(const Chain& tableSet, 
				 const Chain& tsRoot,
				 unsigned sysFileSize, unsigned tmpFileSize, unsigned appFileSize,
				 unsigned logFileSize, unsigned logFileNum,
				 unsigned long long sortAreaSize,
				 unsigned branchId);

    ResultType reqRemoveTableSet(const Chain& tableSet);

    ResultType reqCreateTableSet(const Chain& tableSet);
    ResultType reqDropTableSet(const Chain& tableSet);
    ResultType reqStartTableSet(const Chain& tableSet, bool cleanIt, bool forceload, bool cpDump, bool noInit);
                                
    ResultType reqStopTableSet(const Chain& tableSet);

    ResultType reqInitLogs(const Chain& tableSet);

    ResultType reqSyncTableSet(const Chain& tableSet, const Chain& msg, const Chain& escCmd, unsigned timeout);

    ResultType reqStartRecovery(const Chain& tableSet);
    ResultType reqStopRecovery(const Chain& tableSet);
       
    ResultType reqGetTableSetList(bool getUsage = false);
    ResultType reqGetDbInfo();
    ResultType reqGetTSInfo(const Chain& tableSet);
    ResultType reqGetDetailedTSInfo(const Chain& tableSet);
    ResultType reqGetArchLogInfo(const Chain& tableSet);
    ResultType reqGetBUStatInfo(const Chain& tableSet);

    ResultType reqGetObjectInfo(const Chain& tableSet);

    ResultType reqGetTransactionInfo(const Chain& tableSet);
    ResultType reqSetLSN(const Chain& tableSet, unsigned long long lsn);

    ResultType reqSetRunState(const Chain& tableSet, const Chain& runState);
    ResultType reqSetSyncState(const Chain& tableSet, const Chain& syncState);

    ResultType reqRegisterHost(const Chain& hostName, const unsigned dataPortNo, const unsigned adminPortNo );

    ResultType reqExportTableSet(const Chain& tableSet, bool isStructure, const Chain& exportFile, const Chain& expMode);
    ResultType reqImportTableSet(const Chain& tableSet, bool isStructure, const Chain& importFile, const Chain& impMode);
    
    ResultType reqExportTable(const Chain& tableSet, const Chain& tableName, const Chain& exportFile, const Chain& expMode);
    ResultType reqImportTable(const Chain& tableSet, const Chain& tableName, const Chain& importFile, const Chain& impMode);

    ResultType reqAddDataFile(const Chain& tableSet, const Chain& fileType, const Chain& dataFile, unsigned fileSize);
    
    // ResultType reqAddDataFile(const Chain& tableSet, const Chain& fileType, const Chain& dataFile, unsigned fileSize);
    
    ResultType reqShowUser();
    ResultType reqAddUser(const Chain& user, const Chain& password);
    ResultType reqRemoveUser(const Chain& user);
    ResultType reqChangePwd(const Chain& user, const Chain& password);
    ResultType reqAssignRole(const Chain& user, const Chain& role);
    ResultType reqRemoveRole(const Chain& user, const Chain& role);

    ResultType reqCreateRole(const Chain& role);
    ResultType reqDropRole(const Chain& role);

    ResultType reqSetPermission(const Chain& role, const Chain& permid, const Chain& tableSet, const Chain& filter, const Chain& perm);
    ResultType reqRemovePermission(const Chain& role, const Chain& permid);

    ResultType reqUserTrace(const Chain& user, bool isOn);

    ResultType reqListRole();
    ResultType reqShowRole(const Chain& role);

    ResultType reqAddArchLog(const Chain& tableSet, const Chain& archId, const Chain& archPath);
    ResultType reqRemoveArchLog(const Chain& tableSet, const Chain& archId);

    ResultType reqBeginBackup(const Chain& tableSet, const Chain& msg);
    ResultType reqExecuteBackup(const Chain& tableSet, const Chain& msg);
    ResultType reqEndBackup(const Chain& tableSet, const Chain& msg, bool keepTicket);
    ResultType reqListBackup(const Chain& tableSet, const Chain& pit);
    ResultType reqRestore(const Chain& tableSet, const Chain& backupId);
    ResultType reqRecover(const Chain& tableSet, const Chain& pit, unsigned long long targetlsn);


    ResultType reqDumpObject(const Chain& tableSet, CegoObject::ObjectType type, const Chain& objName);

    ResultType reqSetLogMng(const Chain& progName, unsigned timeout);
    ResultType reqSetBackupMng(const Chain& progName);
    ResultType reqShowLogMng();
    ResultType reqShowBackupMng();

    ResultType reqSetCheckpoint(const Chain& tableSet, unsigned interval);
    ResultType reqSetTSInitFile(const Chain& tableSet, const Chain& initFile);

    ResultType reqSetTSSysSize(const Chain& tableSet, unsigned sysSize);
    ResultType reqSetTSTmpSize(const Chain& tableSet, unsigned tmpSize);
    ResultType reqSetTSAppSize(const Chain& tableSet, unsigned appSize);
    ResultType reqSetTSRootPath(const Chain& tableSet, const Chain& tsRoot);

    ResultType reqSetTSLogNum(const Chain& tableSet, unsigned logNum);
    ResultType reqSetTSLogSize(const Chain& tableSet, unsigned logSize);
    ResultType reqSetTSSortAreaSize(const Chain& tableSet, unsigned long long sortAreaSize);
    ResultType reqSetTSLogUser(const Chain& tableSet, const Chain& logUser);

    ResultType reqEnableTableCache(const Chain& tableSet);
    ResultType reqDisableTableCache(const Chain& tableSet);
    
    ResultType reqEnableQueryCache(const Chain& tableSet);
    ResultType reqDisableQueryCache(const Chain& tableSet);


    ResultType reqCheckTableSet(const Chain& tableSet);
    ResultType reqVerifyTableSet(const Chain& tableSet);
    ResultType reqCorrectTableSet(const Chain& tableSet);

    ResultType reqEnableArchLog(const Chain& tableSet);
    ResultType reqDisableArchLog(const Chain& tableSet);

    ResultType reqEnableAppendMode(const Chain& tableSet);
    ResultType reqDisableAppendMode(const Chain& tableSet);

    ResultType reqEnableAutoCorrect(const Chain& tableSet);
    ResultType reqDisableAutoCorrect(const Chain& tableSet);


    ResultType reqResetBUStat(const Chain& tableSet);
    
    ResultType sendReq(const Chain& reqType, Element* pRoot);
    
    RequestType acceptRequest();

    void sendInfo(const Chain& info);
    void sendResponse(const Chain& msg, Element* pSubElement = 0);
    void sendError(const Chain& msg);
    void sendData(const Chain& data);
    
    ResultType nextInfo();
    ResultType abort();
    bool syncWithInfo(const Chain& hostRole, const Chain& hostName, const Chain& msg, Element* pInfo = 0);

    ////////////////////////////
    // message access methods //
    ////////////////////////////

    const Chain& getUser();
    const Chain& getPassword();

    void getMsg(Chain& msg);
    void getBUMsg(Chain& msg);
    void getLockInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getLockStat(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getPoolInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);

    void getParameterInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    
    void getPoolEntryList(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getThreadInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getDbThreadInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info, Chain& format);
    void getDbThreadHistory(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info, Chain& format);

    void getAdmThreadInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info, Chain& format);
    void getDbSessionInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getCopyInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info, Chain& format);
    bool getCacheInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info, Chain& format);
    bool getCacheList(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info, Chain& format);

    Element* getTableSetInfo();

    Element* getTSInfo();
    Element* getArchInfo();
    Element* getObjectInfo();
    Element* getTAInfo();

    void getTableSetList( CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info, bool getUsage = false);
    void getDetailedTableSetInfo( CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getBuFileInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getDataFileInfo( CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info, Chain& format);
    void getArchLogInfo( CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getLogInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getObjectInfo( CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getTransactionInfo( CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getBUStatInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getBackupInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getNodeInfo( CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getUserInfo( CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getTableSetVerificationInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getTableSetCorrectionInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);

    void getRoleList( CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getRoleInfo( CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);

    void getLogMngInfo( CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getBackupMngInfo( CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);

    void getBackupId(Chain& backuId);
    void getTableSet(Chain& tableSet);
    void getTableSetRoot(Chain& tsRoot);
    void getTableSetTSTicket(Chain& tsTicket);
    void getTableName(Chain& tableName);
    void getThreadId(unsigned& threadId);
    void getFileId(unsigned& fileId);
    void getFileName(Chain& fileName);
    void getFileType(Chain& fileType);
    void getFileSize(unsigned& fileSize);
    void getFilter(Chain& filter);
    void getTargetHost(Chain& targetHost);
    void getEscapeCmd(Chain& escCmd);
    void getTSInitFile(Chain& initFile);
    void getTSRootPath(Chain& tsRoot);
    void getTSLogUser(Chain& logUser);
	
    void getTSTicket(Chain& tsRoot);
    void getTSLogNum(unsigned& logNum);
    void getTSLogSize(unsigned& logSize);
    void getTSSortAreaSize(unsigned long long& sortAreaSize);

    void getTimeoutValue(unsigned& timeout);
    void getUser(Chain& user);
    void getPassword(Chain& passwd);
    void getPerm(Chain& perm);
    void getPermId(Chain& permid);
    void getRole(Chain& role);
    void getTrace(bool& isOn);

    void getUsage(bool& getUsage);

    void getLogManager(Chain& progName);
    void getLogManagerTimeout(unsigned& timeout);

    void getBackupManager(Chain& progName);
    
    void getLockCat(Chain& lockCat);
    void getSysFileId(unsigned& sysFid);
    void getTmpFileId(unsigned& tmpFid);
    void getSysSize(unsigned& sysSize);
    void getTmpSize(unsigned& tmpSize);
    void getAppSize(unsigned& appSize);
    void getLogFileSize(unsigned& logFileSize);
    void getLogFileNum(unsigned& logFileNum);
    void getSortAreaSize(unsigned long long& sortAreaSize);
    void getBranchId(unsigned& branchId);
    void getArchId(Chain& archId);
    void getArchPath(Chain& archPath);
    void getHostRole(Chain& hostRole);
    void getHostName(Chain& hostName);
    void getHostStatus(Chain& hostStatus);
    void getDataPort(unsigned& dataPort);
    void getAdminPort(unsigned& adminPort);
    void getDataId(Chain& dataId);
    void getLSN(unsigned long long& lsn);
    void getRunState(Chain& runState);
    void getPit(Chain& pit);
    void getIsStructure(bool& isStructure);
    void getKeepTicket(bool& keepTicket);
    void getMode(Chain& mode);
    bool getCleanup();
    bool getForceload();
    bool getCPDump();
    bool getNoInit();
    
    void getObjName(Chain& objName);
    void getObjType(CegoObject::ObjectType& type);

    void getTableCacheFilter(Chain& cacheFilter);
    void getTableCacheMaxSize(unsigned& maxSize);
    void getTableCacheMaxEntry(unsigned& maxEntry);
    void getTableCacheHashRange(unsigned& hashRange);
    
    void getQueryCacheMaxEntry(unsigned& maxEntry);
    void getQueryCacheMaxSize(unsigned& maxSize);
    void getQueryCacheThreshold(unsigned& threshold);
    void getQueryCacheHashRange(unsigned& hashRange);

    void getNumLast(unsigned& numLast);
    void getNumCost(unsigned& numCost);
    
private:

    NetHandler *_pN;
    CegoModule *_pModule;
    XMLSuite _xml;

    Chain _user;
    Chain _password;

    unsigned long _modId;
};
#endif
