///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoGroupNode.cc
// -----------------
// Cego group node class implementation
//     
// Design and Implementation by Bjoern Lemke               
//     
// (C)opyright 2000-2025 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoGroupNode
//
// Description: Grouping entry handle for grouped select queries
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Exception.h>

// CEGO INCLUDES
#include "CegoGroupNode.h"

// POSIX INCLUDES
#include <string.h>
#include <stdlib.h>

CegoGroupNode::CegoGroupNode()
{
}

CegoGroupNode::CegoGroupNode(ListT<CegoField>& key)
{
    _key = key;
}

CegoGroupNode::CegoGroupNode(ListT<CegoField>& key, ListT<CegoField>& grouping)
{
    _key = key;
    _grouping = grouping;
}

CegoGroupNode::~CegoGroupNode()
{
}

ListT<CegoField>& CegoGroupNode::getKey()
{
    return _key;
}

ListT<CegoField>& CegoGroupNode::getGrouping()
{
    return _grouping;
}

void CegoGroupNode::setGrouping(ListT<CegoField>& grouping)
{
    _grouping = grouping;
}

CegoGroupNode& CegoGroupNode::operator = ( const CegoGroupNode& n)
{
    _key = n._key;
    _grouping = n._grouping;
    return (*this);
}

bool CegoGroupNode::operator == ( const CegoGroupNode& n)
{
    CegoField *pF1 = _key.First();
    CegoField *pF2 = n._key.First();

    while ( pF1 && pF2 )
    {
	if ( pF1->getValue() < pF2->getValue() )
	{
	    return false;
	}
	else if ( pF1->getValue() > pF2->getValue() )
	{
	    return false;
	}

	pF1 = _key.Next();
	pF2 = n._key.Next();
    }
    return true;
}

bool CegoGroupNode::operator > ( const CegoGroupNode& n)
{    
    CegoField *pF1 = _key.First();
    CegoField *pF2 = n._key.First();

    while ( pF1 && pF2 )
    {
	if ( pF1->getValue() < pF2->getValue() )
	{
	    return false;
	}
	else if ( pF1->getValue() > pF2->getValue() )
	{
	    return true;
	}

	pF1 = _key.Next();
	pF2 = n._key.Next();
    }
    return false;
}

bool CegoGroupNode::operator < ( const CegoGroupNode& n)
{
    CegoField *pF1 = _key.First();
    CegoField *pF2 = n._key.First();

    while ( pF1 && pF2 )
    {
	if ( pF1->getValue() < pF2->getValue() )
	{
	    return true;
	}
	else if ( pF1->getValue() > pF2->getValue() )
	{
	    return false;
	}

	pF1 = _key.Next();
	pF2 = n._key.Next();	
    }
    return false;
}
