#ifndef _CEGOSIGCATCH_H_INCLUDED_
#define _CEGOSIGCATCH_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoSigCatch.h  
// --------------
// Cego signal catcher class definition
//                                                        
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2026 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoSigCatch
// 
// Description: Catch interrupt signal to trigger server termination
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/ListT.h>
#include <lfcbase/SigHandler.h>

// CEGO INCLUDES
#include "CegoDatabaseManager.h"

class CegoSigCatch : public SigHandler {
    
public:
    
    CegoSigCatch(CegoDatabaseManager *pDBMng);
    ~CegoSigCatch();
    
    bool isTerminated();
    void sigCatch(int sig);

private:
    
    
    CegoDatabaseManager* _pDBMng;
    bool _terminated;
    unsigned long _modId;
};
#endif
