#ifndef _CEGOTYPECONVERTER_H_INCLUDED_
#define _CEGOTYPECONVERTER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoTypeConverter.h
// -------------------
// Cego type converter
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoTypeConverter
// 
// Description: Type conversion utility class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>

// cego includes
#include "CegoDataType.h"
#include "CegoObject.h"

extern const char *CEGO_TYPE_MAP[];
extern const char *CEGO_OBJECT_MAP[];
extern const int CEGO_JAVATYPE_MAP[];

class CegoTypeConverter {
    
public:

    CegoTypeConverter();
    ~CegoTypeConverter();

    static Chain getTypeString(CegoDataType type);
    static CegoDataType getTypeId(const Chain& typeString);
    static unsigned getTypeLen(CegoDataType type, const Chain& val = Chain(""));
    static Chain getObjectTypeString(CegoObject::ObjectType type);
    static CegoObject::ObjectType getObjectTypeId(const Chain& typeString);
};
#endif
