///////////////////////////////////////////////////////////////////////////////
//                                                         
// BigDecTest.cc
// -------------
// BigDecimal class test module
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 1996 by Bjoern Lemke                        
//
//
///////////////////////////////////////////////////////////////////////////////


#include "../src/Exception.h"
#include "../src/BigDecimal.h"

int main(int argc, char **argv)
{

    
    int numCheck = 18;
    int checkCount = 1;
    
    try {
	
	cout << "1.." << numCheck << endl;

	BigDecimal d01(".97");
	if ( d01.toChain() == Chain("0.97") )
	    cout << "ok " << checkCount << " - constructor" << endl;
	else
	    cout << "not ok " << checkCount << " - constructor" << endl;
	checkCount++;
	
       
	BigDecimal d02("0.0");	
	if ( d02.toChain() == Chain("0.0") )
	    cout << "ok " << checkCount << " - constructor" << endl;
	else
	    cout << "not ok " << checkCount << " - constructor" << endl;
	checkCount++;


	BigDecimal d03("00004.45");	
	if ( d03.toChain() == Chain("4.45") )
	    cout << "ok " << checkCount << " - constructor" << endl;
	else
	    cout << "not ok " << checkCount << " - constructor" << endl;
	checkCount++;

	BigDecimal d04("00004.450000");	
	if ( d04.toChain() == Chain("4.450000") )
	    cout << "ok " << checkCount << " - constructor" << endl;
	else
	    cout << "not ok " << checkCount << " - constructor" << endl;
	checkCount++;

	BigDecimal d05("00000.06780000");	
	if ( d05.toChain() == Chain("0.06780000") )
	    cout << "ok " << checkCount << " - constructor" << endl;
	else
	    cout << "not ok " << checkCount << " - constructor" << endl;
	checkCount++;

	BigDecimal d06("119.00");	
	if ( d06.toChain() == Chain("119.00") )
	    cout << "ok " << checkCount << " - constructor" << endl;
	else
	    cout << "not ok " << checkCount << " - constructor" << endl;
	checkCount++;

	
	BigDecimal d1("179.97");
	BigDecimal d2("120.11");
	BigDecimal d3("13.0");
	BigDecimal d4("4.987");      
	BigDecimal d5("16.987");
	
	if ( d2 < d1 )
	    cout << "ok " << checkCount << " - operator <" << endl;
	else
	    cout << "not ok " << checkCount << " - operator <" << endl;
	checkCount++;


	if ( d4 < d3 )
	    cout << "ok " << checkCount << " - operator <" << endl;
	else
	    cout << "not ok " << checkCount << " - operator <" << endl;
	checkCount++;

	if ( d3 < d2 )
	    cout << "ok " << checkCount << " - operator <" << endl;
	else
	    cout << "not ok " << checkCount << " - operator <" << endl;
	checkCount++;

	if ( d3 < d5 )
	    cout << "ok " << checkCount << " - operator <" << endl;
	else
	    cout << "not ok " << checkCount << " - operator <" << endl;
	checkCount++;

	
	BigDecimal dadd = d3.add(d4);
	if (  dadd.toChain() == Chain("17.987") )
	    cout << "ok " << checkCount << " - add" << endl;
	else
	    cout << "not ok " << checkCount << " - add" << endl;
	checkCount++;
	
	BigDecimal f1("5.0000");
	BigDecimal f2("0.0");
	BigDecimal ddiv = f2.div(f1);

	if (  ddiv.toChain() == Chain("0.0") )
	    cout << "ok " << checkCount << " - div" << endl;
	else
	    cout << "not ok " << checkCount << " - div" << endl;
	checkCount++;


	// eval term div (fixed)
	// eval facor div (fixed)-26.061528
	    
	BigDecimal f1n("-26.362528");
	BigDecimal f2n("-2606.152800");
	BigDecimal ddivn = f2n.div(f1n);

	// cout << ddivn << endl;
	
	if (  ddivn.toChain() == Chain("98.858227") )
	    cout << "ok " << checkCount << " - div" << endl;
	else
	    cout << "not ok " << checkCount << " - div" << endl;
	checkCount++;

	BigDecimal dsub = d1.sub(d2);
	
	if (  dsub.toChain() == Chain("59.86") )
	    cout << "ok " << checkCount << " - sub" << endl;
	else
	    cout << "not ok " << checkCount << " - sub" << endl;
	checkCount++;


	BigDecimal c1("12.4");
	BigDecimal c2("12.44234");
	
	if (  c1 < c2 )
	    cout << "ok " << checkCount << " - op <" << endl;
	else
	    cout << "not ok " << checkCount << " - op < " << endl;
	checkCount++;

	BigDecimal dxx1("119.00");
	BigDecimal dxx2("100.00");

	BigDecimal dxx3 = dxx1.div(dxx2);	
	
	if (  dxx3.toChain() == Chain("1.19") )
	    cout << "ok " << checkCount << " - div <" << endl;
	else
	    cout << "not ok " << checkCount << " - div < " << endl;
	checkCount++;

	BigDecimal dcomp1("0.001");
	BigDecimal dcomp2("0.001000");

	BigDecimal dzero1("-0.000");
	BigDecimal dzero2("0.000000");
	
	if (  dcomp1 == dcomp2 && dzero1 == dzero2 )
	    cout << "ok " << checkCount << " - comp check" << endl;
	else
	    cout << "not ok " << checkCount << " - comp check " << endl;
	checkCount++;	


	BigDecimal scaleSource("1.34667");
	BigDecimal scaleTarget = scaleSource.scaleTo(2);
	
	if (  scaleTarget.toChain() == Chain("1.35") )
	    cout << "ok " << checkCount << " - scale check" << endl;
	else
	    cout << "not ok " << checkCount << " - scale check " << endl;
	checkCount++;	

	
    }
    catch (Exception e)
    {

	Chain msg;
	e.pop(msg);
	cout << "not ok " << checkCount << " - " << msg << endl;
	return 1;
    }

    return 0;

}

