/////////////////////////////////////////////////////////////////////////////// 
// 
// Screen2Test.cc 
// ------------- 
// NG Screen class test module 
// 
// Design and Implementation by Bjoern Lemke 
// 
// (C)opyright 2017-2022 by Bjoern Lemke 
// 
// 
/////////////////////////////////////////////////////////////////////////////// 

#include "../src/Exception.h" 
#include "../src/Screen2.h"
#include "../src/Sleeper.h"

#include <locale.h> 


class MyMessage : public Screen2::Message
{
public:
    
    MyMessage(Screen2::Panel* pParent, const Chain& title, const Chain& msg) : Screen2::Message(pParent) {
	    setInfo(title, msg);
    }
    
};

class MySelect : public Screen2::Select
{
public:

    MySelect(Screen2::Panel* pParent, const Chain& title)
	: Screen2::Select(pParent) {

	ListT<Chain> items;
	items.Insert(Chain("First=1"));
	items.Insert(Chain("Sec=2"));
	items.Insert(Chain("Third=3"));

	setItems(title, items);

    }

    ~MySelect() {

    }
    
    Screen2::Panel* onSelect(int selected) {

	setStatus(Chain("Select item ") + Chain(selected) + Chain(" Key =") + getSelectedKey());

	return _pParent;
    }
    
private:

};


class MySubGrid : public Screen2::Grid
{
public:
    
    MySubGrid(Screen2::Panel* pParent)
	   : Screen2::Grid(pParent) {

	ListT<Chain> gridSchema;
	gridSchema.Insert(Chain("XFirst=10"));
	gridSchema.Insert(Chain("XSecond=20"));
	gridSchema.Insert(Chain("XThird=10"));
	gridSchema.Insert(Chain("XForth=10"));
	gridSchema.Insert(Chain("XFifth=10"));

	ListT<Screen2::GridColor> colorMap;
	setSchema(Chain("Sub Grid"), gridSchema, colorMap, 0);

    }

    ListT< ListT<Chain> > getData() {
	return _data;
    }
    
    void refresh() {
	

	_data.Empty();
	
	for ( int i=1; i<= 50; i++ )
	{
	    ListT<Chain> row;
	    row.Insert(Chain("XXX"));
	    row.Insert(Chain("YYYY"));
	    row.Insert(Chain("YYYY"));
	    row.Insert(Chain("YYYY"));
	    row.Insert(Chain(i));
	    _data.Insert(row);
	}
    }
private:
    ListT< ListT<Chain> > _data;
};
       


class MyGrid : public Screen2::Grid
{
public:
    
    MyGrid(Screen2::Panel* pParent, const Chain& title)
	   : Screen2::Grid(pParent) {


	ListT<Chain> gridSchema;
	gridSchema.Insert(Chain("First=10"));
	gridSchema.Insert(Chain("Second=20"));
	gridSchema.Insert(Chain("Third=10"));
	gridSchema.Insert(Chain("Forth=10"));
	gridSchema.Insert(Chain("Fifth=10"));

	ListT<Screen2::GridColor> colorMap;
	setSchema(title, gridSchema, colorMap, 0);

	_pMsg = new MyMessage(this, Chain("MyTitle"), Chain("XXXXXXXXXXX"));
	_pSelect = new MySelect(this, Chain("Sample select"));
	_pSubGrid = new MySubGrid(this);
    }

    ~MyGrid() {
	if ( _pMsg != 0 )
	    delete _pMsg;
	if ( _pSelect )
	    delete _pSelect;
	if ( _pSubGrid )
	    delete _pSubGrid;
    }
       
    Screen2::Panel* onSelect(int rowNum) {

	return _pSelect;
    }

    Screen2::Panel* onKey(int c, int rowNum) {
	

	if ( c == 'm' )
	{	    
	    _pMsg->setInfo(Chain("Key pressed = ") + Chain(c), Chain("RowNum = ") + Chain(rowNum));
	    return _pMsg;
	}
	else if ( c == 's' )
	{

	    ListT<Chain> items;
	    items.Insert(Chain("First=1"));
	    items.Insert(Chain("Sec=2"));
	    items.Insert(Chain("Third=3"));

	    _pSelect->setItems(Chain("Key pressed = ") + Chain(c) + Chain(" RowNum = ") + Chain(rowNum),
			       items);
	    return _pSelect;
	}
	else if ( c == 'g' )
	{
	    return _pSubGrid;
	}

	return this;
    }

    ListT< ListT<Chain> > getData() {
	return _data;
    }

    void refresh() {


	_data.Empty();
	
	for ( int i=1; i<= 80; i++ )
	{
	    ListT<Chain> row;
	    row.Insert(Chain("XXX"));
	    row.Insert(Chain("YYYY"));
	    row.Insert(Chain("YYYY"));
	    row.Insert(Chain("YYYY"));
	    row.Insert(Chain(i));
	    _data.Insert(row);
	}

	_j++;
    }
	

private:
    
    MyMessage* _pMsg;
    MySelect* _pSelect;
    MySubGrid* _pSubGrid;
    ListT< ListT<Chain> > _data;
    int _j;
};

class MyForm : public Screen2::Form
{
public:
    
    MyForm(Screen2::Panel* pParent)
    : Screen2::Form(pParent) {

	ListT<Chain> attrList;
	attrList.Insert(Chain("Str:S:80:Hello")); 
	attrList.Insert(Chain("Number:N:8:4711"));
	attrList.Insert(Chain("Password:P:5"));
	attrList.Insert(Chain("Menu Input:M:10:Beta=B,Alpha=A,Beta=B,Gamma=XXX"));

	setAttrList(Chain("Sample Form"), attrList, 10);
	
	ListT<Chain> valList;

	valList.Insert(Chain("XXX"));
	valList.Insert(Chain("66"));
	valList.Insert(Chain("secret"));
	valList.Insert(Chain("XXX"));
	
	setValueList(valList);
	
    }

    void enter() {
	this->reset();
	// this->clear();
    }
	    
    Screen2::Panel* onConfirm(const ListT<Chain>& valList) {
	
	// Chain *pVal = valList.First();
	this->clear();
	return _pParent;
    }

    Screen2::Panel* onCancel() {
	
	return _pParent;
    }

    
private:

    ListT<Chain> _attrList;
    ListT<Chain> _valList; 
    // int _maxVisible;
};


class MyAttr : public Screen2::Attribute
{
public:
    
    MyAttr(Screen2::Panel* pParent, const Chain& title)
	: Screen2::Attribute(pParent, false) {

	
	ListT<Chain> attrList1;
	attrList1.Insert(Chain("Name=Lemke")); 
	attrList1.Insert(Chain("ZIP=71638"));
	attrList1.Insert(Chain("City=Ludwigsburg"));
      
	ListT<Chain> attrList2;
	attrList2.Insert(Chain("Name=Hugo")); 
	attrList2.Insert(Chain("ZIP=9999"));
	attrList2.Insert(Chain("City=Bumpflingen"));
      
	ListT< ListT<Chain> > masterList;
	masterList.Insert(attrList1);
	masterList.Insert(attrList2);
		
	setAttrList(title, masterList);

	_count = 0;
    }

    void refresh() {


	ListT<Chain> attrList1;
	
	attrList1.Insert(Chain("Count=") + Chain(_count)); 
	attrList1.Insert(Chain("Name=Lemke")); 
	attrList1.Insert(Chain("ZIP=71638"));
	attrList1.Insert(Chain("City=Ludwigsburg"));
	
	ListT<Chain> attrList2;
	attrList2.Insert(Chain("Name=Hugo")); 
	attrList2.Insert(Chain("ZIP=9999"));
	attrList2.Insert(Chain("City=Bumpflingen"));
	
	ListT< ListT<Chain> > masterList;
	masterList.Insert(attrList1);
	masterList.Insert(attrList2);
	
	setAttrList(Chain("Attribute ") + Chain(_count), masterList);

	_count++;
    }

private:

    int _count;

};


class MyConfirm : public Screen2::Confirm
{
public:
    
    
    Screen2::Panel* onConfirm() {

	for ( int i = 100; i > 0 ; i-- )
	{
	    if ( i == 100 )
	    {
		setStatus(Chain("Confimed level XXXXXXXXXXXXX"));
		Sleeper::milliSleep(200);
	    }
	    setStatus(Chain("Confimed level ") + Chain(i));
	    Sleeper::milliSleep(10);
	}
	return _pParent;
    }

    Screen2::Panel* onCancel() {
	setStatus(Chain("Confirm panel canceled"));
	return _pParent;
    }

    MyConfirm(Screen2::Panel* pParent, const Chain& title, const Chain& details)
	: Screen2::Confirm(pParent) {
	setInfo(title, details);
    }    	    
};



int main(int argc, char **argv) 
{ 
   
    try
    { 

	Screen2 sc;

	sc.setTimeout(3000);

	Screen2::Menu* pMenu = new Screen2::Menu();
	
	sc.setRoot(pMenu);
	
	MyMessage* pMsg = new MyMessage(pMenu, Chain("MyTitle"), Chain("This is a long message\nwith newline"));
	pMenu->regItem(Chain("Message"), (Screen2::Panel*)pMsg);

	
	MySelect* pSelect = new MySelect(pMenu, Chain("Select item"));
	pMenu->regItem(Chain("Select"), (Screen2::Panel*)pSelect);

	
	/////////////////
	// Grid Sample //
	/////////////////

	MyGrid* pGrid = new MyGrid(pMenu, Chain("Sample Grid"));
	pMenu->regItem(Chain("Grid"), (Screen2::Panel*)pGrid);


	/////////////////
	// Form Sample //
	/////////////////
	
	MyForm* pForm = new MyForm(pMenu);
	pMenu->regItem(Chain("Form"), (Screen2::Panel*)pForm);


	//////////////////////
	// Attribute Sample //
	//////////////////////
	

	MyAttr* pAttr = new MyAttr(pMenu, Chain("Sample Attribute"));
	pMenu->regItem(Chain("Attr"), (Screen2::Panel*)pAttr);


	////////////////////
	// Confirm Sample //
	////////////////////
	
	MyConfirm* pConf = new MyConfirm(pMenu, Chain("Sample Confirm"), Chain("Confirmation details"));
	pMenu->regItem(Chain("Confirm"), (Screen2::Panel*)pConf);


	pMenu->regItem(Chain("Quit"), (Screen2::Panel*)0);
	
		
	sc.showScreen();

	delete pForm;
	delete pGrid;
	delete pMsg;
	delete pAttr;
	delete pConf;
	delete pSelect;
	
	
	
    } 
    catch (Exception e) 
    { 
        Chain msg; 
        e.pop(msg); 
        cout << msg << endl; 
        return 1; 
    } 

    cout << "Demo finished" << endl;
    return 0; 

} 
