///////////////////////////////////////////////////////////////////////////////
//                                                         
// NanoTimer.cc
// ------------
// NanoTimer implementation
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke         
//                                                         
// IMPLEMENTATION MODULE
//
// Class: NanoTimer
// 
// Description: NanoTimer class for time measurement
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#include "Exception.h"
#include "NanoTimer.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/time.h>

#ifdef HAVE_MACH_TIMEBASE_INFO
#include <mach/mach_time.h>
static mach_timebase_info_data_t s_timebase_info;
#endif

NanoTimer::NanoTimer()
{
    _start = 0;
    _end = 0;
    _sum = 0;
    
#if HAVE_MACH_TIMEBASE_INFO
    if (s_timebase_info.denom == 0) 
    {
	(void) mach_timebase_info(&s_timebase_info);
    }
#endif
}

NanoTimer::~NanoTimer()
{
}

void NanoTimer::start()
{
#if HAVE_GETHRTIME
    _start = gethrtime();
#elif HAVE_CLOCK_GETTIME
    struct timespec tp;
    clock_gettime(CLOCK_REALTIME, &tp);
    _start = tp.tv_sec * 1000000000 + tp.tv_nsec;
#elif HAVE_MACH_TIMEBASE_INFO
    _start = mach_absolute_time();
#else    
    _start = 0;
#endif   
}

void NanoTimer::stop()
{
#if HAVE_GETHRTIME
    _end = gethrtime();
#elif HAVE_CLOCK_GETTIME
    struct timespec tp;
    clock_gettime(CLOCK_REALTIME, &tp);
    _end = tp.tv_sec * 1000000000 + tp.tv_nsec;
#elif HAVE_MACH_TIMEBASE_INFO
    _end = mach_absolute_time();
#else
    _end = 0;
#endif
    
    _sum = _sum + ( _end - _start );

}

void NanoTimer::reset()
{    
    _start = 0;
    _end = 0;
    _sum = 0;
}

unsigned long long NanoTimer::getSum() const
{
    return _sum;
}
