// NetServer.cc
// -------------
// file class test module
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000,2001,2002,2003,2004,2005 
// by Bjoern Lemke                        
//
//
///////////////////////////////////////////////////////////////////////////////

#include "../src/Exception.h"
#include "../src/Net.h"
#include "../src/Chain.h"

int main(int argc, char **argv)
{

  try {

      Net n(1024, 10, 8192);

      //n.serve("fe80::1032:ec51:385f:76b0%en1", 4000);
      n.serve6(4000);
      
      NetHandler* pNetHandle;

      while ( 1 ) 
      {
	  cout << "In the request loop ..." << endl;
	  pNetHandle = n.nextRequest(700000);

	  if ( pNetHandle )
	  {
	      cout << "Next request from " << pNetHandle->getSource() << endl;
	      if ( pNetHandle->getMsgSize() > 0 )
	      {	  
		  cout << "Got Msg = " << pNetHandle->getMsg() << endl;

		  Chain answer = Chain("this is the answer to XXXX"); //  + Chain(pNetHandle->getId());
		  pNetHandle->setMsg((char*)answer, answer.length());
		  cout << "Sending answer ..." << endl;
		  pNetHandle->writeMsg();
	      }
	      delete pNetHandle;
	  }
      }
      
  }
  catch (Exception e)
  {
      cout << "Catch exception .." << endl;
      e.print();
      
  }
}
  

