//
// XMLTest.cc
// ---------
// Testmodul for the XML parser
//
// by Bjoern Lemke, (C)opyright 2005 by Bjoern Lemke
//


#include <lfcbase/Chain.h>
#include <lfcbase/File.h>
#include <lfcbase/GetLongOpt.h>
#include <lfcbase/Exception.h>

#include "XMLSuite.h"

#include <stdlib.h>
#include <unistd.h>

#define USAGE "Usage:\n\n\
  Info:               xmltest [ --version ] [ --help ]\n\
  Stream Out:         xmltest --mode=streamout\n\
  Stream Out:         xmltest --mode=streamin --file=<infile>"

class MyInStream : public XMLInStream {

public:

    MyInStream() {};
    ~MyInStream() {};

    void putFirst(Element *pParent, const Chain& name, const ListT<Attribute>& attrList, ListT<char*> dataList) {
	
	cout << "First Name is " << name << endl;
	cout  << "DATA List Size = " << dataList.Size() << endl;
    }

    void putNext(Element *pParent, const Chain& name, const ListT<Attribute>& attrList, ListT<char*> dataList) {
	
	cout << "Next Name is " << name << endl;
	cout  << "DATA List Size = " << dataList.Size() << endl;
    }

    
};

class MyOutStream : public XMLOutStream {

public:

    MyOutStream() { _count=0; };
    ~MyOutStream() {};

    Element* getFirst() {
	
	Element *pE = new Element("StreamElement");
	pE->setAttribute(Chain("Iwan"), Chain("ddddd"));
	pE->addData("THIS IS THE first data");
	pE->addData("THIS IS THE second data");

	return pE;
    }

    Element* getNext() {
	
	if ( _count < 3 )
	{
	    Element *pE = new Element("StreamElement");
	    pE->setAttribute(Chain("Iwan"), Chain(_count));
	    _count++;
	    return pE;
	}
	else
	{
	    return 0;
	}

    }
    
    
private:
    
    int _count;
    
};


int main(int argc, char** argv)
{
    
    GetLongOpt longOpt(argc, argv);

    
    longOpt.addOpt("mode");
    longOpt.addOpt("file");
    
    try
    {
	longOpt.parseOpt(); 
    }
    catch ( Exception e )
    {
	Chain msg;
	e.pop(msg);
	cerr << msg << endl;
	cerr << USAGE << endl;
	exit(1);	
    }

    // Variante I

    Chain mode = longOpt.getOptValue("mode");
    
    try {

	
	if (mode == Chain("streamin"))
	{
	
	    Chain fileName = longOpt.getOptValue("file");
	
	    File* pXMLFile = new File(fileName);
	    
	    pXMLFile->open(File::READ);
	    
	    XMLSuite xml;
	    MyInStream* pInStream = new MyInStream;
	    
	    Document *pDoc = new Document("XMLTEST");
	    pDoc->setAttribute(Chain("version"), Chain("1.0"));
	    
	    xml.setDocument(pDoc);    
	    xml.setFile(pXMLFile);
	    xml.setInStream(pInStream);
	    
	    xml.parse();

	    
	    cout << "Parse finished" << endl;
	    pXMLFile->close();
	    
	}
	else if ( mode == Chain("streamout") )
	{
	    
	    XMLSuite xml;
	    
	    Document *pDoc = new Document("XMLTEST");
	    pDoc->setAttribute(Chain("version"), Chain("1.0"));
	    pDoc->setDocType("TESTDOC");
	    
	    xml.setDocument(pDoc);
	    
	    Element *pRoot = new Element("MYROOT");
	    
	    MyOutStream *pOutStream = new MyOutStream;
	    
	    pRoot->setOutStream(pOutStream);
	    
	    int i=0;
	    while ( i < 3 )
	    {
		Element *pSub = new Element("SUB");
		pRoot->addContent(pSub);
		i++;
	    }
	    
	    pDoc->setRootElement(pRoot);
	    
	    Chain xmlChain;
	    xml.getXMLChain( xmlChain );
	    
	    cout << xmlChain << endl;
	   
	}
	else if ( mode == Chain("clonetest") )
	{
	    File xmlFile(argv[1]);
	
	    xmlFile.open(File::READ);
	    
	    char readBuf[1024];
	    Chain xmlDoc;
	    
	    int i;
	    while (( i = xmlFile.readByte(readBuf, 1024)) > 0)
	    {
		// cout << "Reading " << i << " bytes" << endl;
		xmlDoc = xmlDoc + Chain(readBuf, i); // .subChain(1,i);
	    }
	    
	    xmlFile.close();
	    
	    
	    Document *pDoc = new Document("XMLTEST");
	    pDoc->setAttribute(Chain("version"), Chain("1.0"));
	    
	    
	    XMLSuite xml((char*)xmlDoc);
	    
	    pDoc->clear();
	    
	    xml.setDocument(pDoc);
	    
	    cout << "Parsing " << endl;
	    xml.parse();
	    
	    cout << "Parse ok " << endl;
	    
	    Element* pE = pDoc->getRootElement();
	    
	    Element* pClone = pE->createClone();
	    
	    pDoc->clear();
	    
	    Document *pCloneDoc = new Document("CLONETEST");
	    pCloneDoc->setRootElement(pClone);
	    XMLSuite xmlClone;
	    xmlClone.setDocument(pCloneDoc);
	    
	    Chain xmlChain;
	    xmlClone.getXMLChain( xmlChain );
	    
	    cout << xmlChain << endl;
	    
	}
    }
    catch ( Exception e )
    {
	e.print();
    }
}


