///////////////////////////////////////////////////////////////////////////////
//
// Attribute.cc
// ------------
// XML attribute implementation
//
// Design and Implementation by Bjoern Lemke
//               
// (C)opyright 2000-2006 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: Attribute
// 
// Description: all operations on the XML attribute
//
// Status: IMPLEMENTED
//
///////////////////////////////////////////////////////////////////////////////

// INCLUDES
#include "Attribute.h"
#include "XMLEscaper.h"

Attribute::Attribute()
{
}

Attribute::Attribute(const Chain& name)
{
    _name = name;
}

Attribute::Attribute(const Chain& name, const Chain& value, bool treatXMLEscape)
{
    _name = name;
    _value = value;
    if ( treatXMLEscape )
    {
	XMLEscaper esc;
	esc.descape(_value);
    }
}

Attribute::~Attribute()
{
}

const Chain& Attribute::getName() const
{
    return _name;
}

void Attribute::setValue(const Chain& value, bool treatXMLEscape)
{
    _value = value;
    if ( treatXMLEscape )
    {
	XMLEscaper esc;
	esc.descape(_value);
    }
    
}

Chain Attribute::getXMLValue() const
{
    Chain value = _value;
    XMLEscaper esc;
    esc.escape(value);
    return value;
}

Chain Attribute::getValue() const
{
    return _value;
}

Attribute& Attribute::operator=(const Attribute& attr)
{
    _name = attr._name;
    _value = attr._value;
    return (*this);
}
    
bool Attribute::operator==(const Attribute& attr) const
{
    if ( _name == attr._name ) 
	return true;
    return false;
}
