#ifndef _DOCUMENT_H_INCLUDED_
#define _DOCUMENT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// Document.h
// ------
// XML document class definition
//                                                         
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2006 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: Document
// 
// Description: 
//
// Status: IMPLEMENTED
//
///////////////////////////////////////////////////////////////////////////////

// INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

#include "Element.h"
#include "Attribute.h"

class Document {
 
 public:

    Document();
    Document(const Chain& docName);
    Document(Element* pRootElement);
    ~Document();

    const Chain& getName();

    void setRootElement(Element* pRootElement);
    Element* getRootElement();

    void setDocType(const Chain& docType);
    const Chain& getDocType() const;

    void setAttributeList(const ListT<Attribute>& attrList);
    void setAttribute(const Chain& attr, const Chain& value);
    Chain getAttributeValue(const Chain& attr) const;

    const ListT<Attribute>& getAttributeList() const;

    Document& operator =  ( const Document& d);
    bool operator == ( const Document& d) const;

    void clear();

private:
    
    ListT<Attribute> _attrList;
    Element* _pRootElement;
    Chain _docType;
    Chain _docName;
     
};

#endif

