#ifndef _ELEMENT_H_INCLUDED_
#define _ELEMENT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// Element.h
// ---------
// XML element class definition
//                                                         
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2006 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: Element
// 
// Description:
//
// Status: IMPLEMENTED
//
///////////////////////////////////////////////////////////////////////////////

// INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

#include "Attribute.h"
#include "XMLOutStream.h"

class XMLOutStream;

class Element {
 
 public:

     Element(int refCount = 0);
     Element(const Chain& name, int refCount = 0);
     ~Element();

     void clear();

     void incRef();
     void decRef();
     int getRef();

     const Chain& getName() const;
     void setName(const Chain& name);

     void setAttributeList(ListT<Attribute>& attrList);
     const ListT<Attribute>& getAttributeList() const;

     void setAttribute(const Chain& attr, const Chain& value);
     bool hasAttribute(const Chain& attr) const;
     Chain getAttributeValue(const Chain& attr) const;

     void addContent(Element* pElement );
     ListT<Element*> getAllChildren() const;
     ListT<Element*> getChildren(const Chain& name) const;

     Element* getParent();
     void setParent(Element *pElement);
     bool removeChild(Element *pElement);     

     void setText(const Chain& t);
     Chain getText() const;
     Chain getXMLText() const;

     void addData(char* data);
     ListT<char*> getDataList() const;

     Element *createClone();

     void setOutStream(XMLOutStream *pOutStream);
     XMLOutStream* getOutStream();

     Element& operator =  ( const Element& elem);
     bool operator == ( const Element& elem) const;
          
 private:
     
     Chain _name;
     ListT<Attribute> _attrList;
     ListT<Element*> _childList;
     Chain _text;

     ListT<char*> _dataList;

     Element* _pParent;
     int _refCount;

     XMLOutStream* _pOutStream;
};

#endif

