///////////////////////////////////////////////////////////////////////////////
//
// XMLEscaper.cc
// -------------
// XML Escape character treatment
//
// Design and Implementation by Bjoern Lemke
//               
// (C)opyright 2000-2006 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: XMLEscaper
// 
// Description: 
//
// Status: IMPLEMENTED
//
///////////////////////////////////////////////////////////////////////////////

// INCLUDES
#include "XMLEscaper.h"

XMLEscaper::XMLEscaper()
{
}
XMLEscaper::~XMLEscaper()
{
}

void XMLEscaper::escape(Chain& target)
{
    target.replaceAll(Chain("&"), Chain("&amp;"), target);
    target.replaceAll(Chain("<"), Chain("&lt;"), target);
    target.replaceAll(Chain(">"), Chain("&gt;"), target);
    target.replaceAll(Chain("'"), Chain("&apos;"), target);
    target.replaceAll(Chain("\""), Chain("&quot;"), target);
    target.replaceAll(Chain("\t"), Chain("&#x9;"), target);
    target.replaceAll(Chain("\n"), Chain("&#xA;"), target);
}

void XMLEscaper::descape(Chain& target)
{
    target.replaceAll(Chain("&lt;"), Chain("<"), target);
    target.replaceAll(Chain("&gt;"), Chain(">"),  target);
    target.replaceAll(Chain("&apos;"), Chain("'"), target);
    target.replaceAll(Chain("&quot;"), Chain("\""), target);
    target.replaceAll(Chain("&amp;"), Chain("&"), target);
    target.replaceAll(Chain("&#x9;"), Chain("\t"), target);
    target.replaceAll(Chain("&#xA;"), Chain("\n"), target);
    target.replaceAll(Chain("&#xD;"), Chain("\n"), target);
}





