#ifndef _XMLINSTREAM_H_INCLUDED_
#define _XMLINSTREAM_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//
// XMLInStream.h
// -------------
// XML Instream abstract class
//               
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2007 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: XMLInStream
// 
// Description: 
//
// Status: IMPLEMENTED
//
///////////////////////////////////////////////////////////////////////////////

// INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

#include "Attribute.h"
#include "Element.h"

class XMLInStream {
 
 public:
  
    XMLInStream();
    virtual ~XMLInStream();
    
    virtual void putFirst(Element *pParent, const Chain& name, const ListT<Attribute>& attrList, ListT<char*> dataList ) = 0;
    virtual void putNext(Element *pParent, const Chain& name, const ListT<Attribute>& attrList, ListT<char*> dataList) = 0;
     
 private:
  
};

#endif

