///////////////////////////////////////////////////////////////////////////////
//
// XMLSuite.cc
// -----------
// xml suite class implementation
//
// Design and Implementation by Bjoern Lemke
//               
// (C)opyright 2000-2006 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: XMLSuite
// 
// Description:
//
// Status: IMPLEMENTED
//
///////////////////////////////////////////////////////////////////////////////

// INCLUDES
#include "XMLSuite.h"

#include <stdlib.h>

XMLSuite::XMLSuite(char *pC) : XML()  
{
    _pC = pC;
    _pFile = 0;
    _i = 0;
    _pElem = 0;
    _scanContent = false;
    _scanData = false;
    _pDoc=0;
    _lineNo=1;
}

XMLSuite::~XMLSuite()
{
}

void XMLSuite::setFile(File *pFile)
{
    _pC = 0;
    _pFile = pFile;
    _lineNo=1;
}

void XMLSuite::setInStream(XMLInStream *pInStream)
{
    _pInStream = pInStream;
}

int XMLSuite::getLineNo() const
{
    return _lineNo;
}

void XMLSuite::setChain(char *pC)
{
    _pC = pC;
    _i = 0;
    _pElem = 0;
    _scanContent = false;
    _scanData = false;
    _elemStack.Empty();
    _elemList.Empty();
    _attrList.Empty();
    _lineNo=1;
}

Document* XMLSuite::getDocument()
{
    return _pDoc;
}


void XMLSuite::setDocument(Document* pDoc)
{
    _pDoc = pDoc;
}

void XMLSuite::getXMLChain(Chain& xmlChain)
{
    if ( _pDoc == 0 )
    {
	throw Exception(EXLOC, "document not set");
    }
    xmlChain = Chain("<?xml ");
    Attribute* pAttr= _pDoc->getAttributeList().First();
    while ( pAttr )
    {
	xmlChain += " " + pAttr->getName() + "=";
	xmlChain += "\"" + pAttr->getXMLValue() + "\"";
	pAttr= _pDoc->getAttributeList().Next();
    }
    xmlChain += " ?>\n";

    if ( _pDoc->getDocType() != Chain("") )
    {
	xmlChain += Chain("<!DOCTYPE ") + _pDoc->getDocType() + ">\n";
    }

    if ( _pDoc->getRootElement() )
    {
	Chain xmlElement;
	getXMLForElement(_pDoc->getRootElement(), xmlElement, 0);
	
	xmlChain += xmlElement;
    }
    xmlChain += "\n";
}

void XMLSuite::getXMLChain(File* pOutFile)
{
    if ( _pDoc == 0 )
    {
	throw Exception(EXLOC, "document not set");
    }
    pOutFile->writeChain( Chain("<?xml ") );
    Attribute* pAttr= _pDoc->getAttributeList().First();
    while ( pAttr )
    {
	pOutFile->writeChain( Chain(" ") + pAttr->getName() + Chain("="));
	pOutFile->writeChain( Chain("\"") + pAttr->getXMLValue() + Chain("\""));
	pAttr= _pDoc->getAttributeList().Next();
    }
    pOutFile->writeChain( Chain(" ?>\n") );

    if ( _pDoc->getDocType() != Chain("") )
    {
	pOutFile->writeChain( Chain("<!DOCTYPE ") + _pDoc->getDocType() + Chain(">\n"));
    }

    if ( _pDoc->getRootElement() )
    {
	getXMLForElement(_pDoc->getRootElement(), pOutFile, 0);
    }

    pOutFile->writeChain( Chain("\n") );
    
}

void XMLSuite::getXMLForElement(Element* pElement, Chain& xmlElement, int level, bool isStream)
{
    
    int i=0;
    while ( i < level )
    {
	xmlElement += Chain(" ");
	i++;
    }

    if ( isStream )
    {
	xmlElement += "<STREAM " + pElement->getName();
	Attribute* pAttr = pElement->getAttributeList().First();
	while ( pAttr )
	{
	    xmlElement += " " + pAttr->getName() + "=";
	    xmlElement += "\"" + pAttr->getXMLValue() + "\"";
	    pAttr= pElement->getAttributeList().Next();
	}	

	ListT<char*> dataList = pElement->getDataList();
	if ( dataList.Size() == 0 )
	{
	    xmlElement += Chain("/>");
	}
	else
	{
	    xmlElement +=  Chain(">");
	    char** pData = dataList.First();
	    
	    while ( pData )
	    {		
		xmlElement += Chain("<![CDATA[");
		xmlElement += Chain( *pData );
		xmlElement += Chain("]]>");
		pData = dataList.Next();
	    }
	    
	    xmlElement += Chain("</") + pElement->getName() + Chain(">");
	    xmlElement += Chain("\n");
	    
	}
    }
    else
    {    
	xmlElement += "<" + pElement->getName();
	
	Attribute* pAttr = pElement->getAttributeList().First();
	while ( pAttr )
	{
	    xmlElement += " " + pAttr->getName() + "=";
	    xmlElement += "\"" + pAttr->getXMLValue() + "\"";
	    pAttr= pElement->getAttributeList().Next();
	}
	xmlElement += ">";
	
	Chain content = pElement->getXMLText();
	if ( content.length() > 1 )
	{
	    xmlElement += content;
	}
		
	ListT<Element*> childList = pElement->getAllChildren();
	Element** pElem = childList.First();
	
	while ( pElem )
	{
	    Chain xmlChildElement;
	    getXMLForElement(*pElem, xmlChildElement, level+1);
	    
	    xmlElement += xmlChildElement;
	    
	    pElem = childList.Next();
	}

	XMLOutStream *pOutStream = pElement->getOutStream();
	if ( pOutStream )
	{
	    Element *pStreamElement = pOutStream->getFirst();
	    while ( pStreamElement )
	    {
		Chain xmlChildElement;
		getXMLForElement(pStreamElement, xmlChildElement, level+1, true);
		
		xmlElement += xmlChildElement;
		
		delete pStreamElement;

		pStreamElement = pOutStream->getNext();
	    }
	}
        /*
	i=0;
	while ( i < level )
	{
	    xmlElement += Chain(" ");
	    i++;
	}
        */
	xmlElement += Chain("</") + pElement->getName() + Chain(">");
	if ( i > 0 )
	    xmlElement += Chain("\n");
    }
}

void XMLSuite::getXMLForElement(Element* pElement, File *pOutFile, int level, bool isStream)
{
    
    int i=0;
    while ( i < level )
    {
	pOutFile->writeChain( Chain(" ") );
	i++;
    }

    if ( isStream )
    {
	pOutFile->writeChain( Chain("<STREAM ") + pElement->getName() );
	Attribute* pAttr = pElement->getAttributeList().First();
	while ( pAttr )
	{
	    pOutFile->writeChain( Chain(" ") + pAttr->getName() + Chain("=") );
	    pOutFile->writeChain( Chain("\"") + pAttr->getXMLValue() + Chain("\"") );
	    pAttr= pElement->getAttributeList().Next();
	}
 
	ListT<char*> dataList = pElement->getDataList();
	if ( dataList.Size() == 0 )
	{
	    pOutFile->writeChain( Chain("/>\n") );
	}
	else
	{
	    pOutFile->writeChain( Chain(">") );
	    char** pData = dataList.First();
	    
	    while ( pData )
	    {		
		pOutFile->writeChain( Chain("<![CDATA[") );
		pOutFile->writeChain( *pData );
		pOutFile->writeChain( Chain("]]>"));
		pData = dataList.Next();
	    }
	    
	    pOutFile->writeChain( Chain("</") + pElement->getName() + Chain(">") );
	    pOutFile->writeChain( Chain("\n") );
	    
	}

    }
    else
    {    
	pOutFile->writeChain( Chain("<") + pElement->getName() );
	
	Attribute* pAttr = pElement->getAttributeList().First();
	while ( pAttr )
	{
	    pOutFile->writeChain( Chain(" ") + pAttr->getName() + Chain("=") );
	    pOutFile->writeChain( Chain("\"") + pAttr->getXMLValue() + Chain("\"") );
	    pAttr= pElement->getAttributeList().Next();
	}
	pOutFile->writeChain( Chain(">") );
	
	Chain content = pElement->getXMLText();
	if ( content.length() > 1 )
	{
	    pOutFile->writeChain( content );
	}
	
	ListT<Element*> childList = pElement->getAllChildren();
	Element** pElem = childList.First();
	
	while ( pElem )
	{
	    getXMLForElement(*pElem, pOutFile, level+1);	  	    
	    pElem = childList.Next();
	}

	XMLOutStream *pOutStream = pElement->getOutStream();
	if ( pOutStream )
	{
	    Element *pStreamElement = pOutStream->getFirst();
	    while ( pStreamElement )
	    {
		getXMLForElement(pStreamElement, pOutFile, level+1, true);
		delete pStreamElement;
		pStreamElement = pOutStream->getNext();
	    }
	}
	i=0;
	while ( i < level )
	{
	    pOutFile->writeChain( Chain(" ") );
	    i++;
	} 
        pOutFile->writeChain( Chain("</") + pElement->getName() + Chain(">") );
	if ( i > 0 )
	    pOutFile->writeChain( Chain("\n") );
    }
}

char XMLSuite::nextChar() 
{
    while ( 1 )
    {
	if (_pC && _pC[_i])
	{
	    if ( _scanContent )
	    {
		setReserved(CONTENT);
		int j = 0;
		while ( _pC[_i] != '<' && j < XMLSUITE_MAXCONTENT)
		{
		    if ( _pC[_i] == '\n' )
			_lineNo++;

		    // cout << "Storing <" << _pC[_i] << "> to content" << endl;
		    _content[j] = _pC[_i];
		    _i++;
		    j++;
		    
		    if ( _pC[_i] == 0 )
		    {
			if ( moreData() == false )
			{
			    throw Exception(EXLOC, "Unexpected end of data");
			}
		    }
		}

		if ( j ==  XMLSUITE_MAXCONTENT )
		{
		    throw Exception(EXLOC, "Content buffer exceedeed");
		}
		
		_content[j]=0;
		
		_scanContent = false;
		return 0;
	    }

	    if ( _scanData )
	    {
		setReserved(DATA);
		char *data = (char*)malloc(XMLSUITE_CHUNKSIZE);
		int dataLen = XMLSUITE_CHUNKSIZE;
		int j = 0;
		while ( _pC[_i] != ']' || _pC[_i+1] != ']' || _pC[_i+2] != '>' )
		{
		    if ( _pC[_i] == '\n' )
			_lineNo++;
		    
		    // cout << "Storing <" << _pC[_i] << "> to data" << endl;
		    data[j] = _pC[_i];
		    _i++;
		    j++;
		    
		    
		    if ( _pC[_i] == 0 )
		    {
			if ( moreData() == false )
			{
			    throw Exception(EXLOC, "Unexpected end of data");
			}
		    }
		    if ( j == dataLen )
		    {
			// rellocate buffer
			dataLen += XMLSUITE_CHUNKSIZE;
			data = (char*)realloc(data, dataLen);
		    }
		}
		data[j]=0;
		
		_dataList.Insert(data);
		_scanData = false;
		return 0;
	    }

	    
	    if ( _pC[_i] == '"')
	    {
		setReserved(STRINGVAL);
		
		_i++;

		if ( _pC[_i] == 0 )
		{
		    if ( moreData() == false )
		    {
			throw Exception(EXLOC, "Unexpected end of data");
		    }
		}

		int j = 0;
		while ( _pC[_i] != '"')
		{
		    // cout << "Storing: " << _pC[_i] << endl;
		    _stringBuf[j] =  _pC[_i];
		    
		    _i++;
		    if ( j == XMLSUITE_MAXSTRINGLEN )
			throw Exception(EXLOC, "String buffer exceeded");
		    j++;
		    if ( _pC[_i] == 0 )
		    {
			if ( moreData() == false )
			{
			    throw Exception(EXLOC, "Unexpected end of data");
			}
		    }
		    
		}
		_stringBuf[j] = 0;
		// cout << "StringBuf=" << _stringBuf << endl;
		_i++;
		return 0;
		
	    }
	    // checking comments
	    if ( _pC[_i] == '<' 
		 && _pC[_i+1] == '!' 
		 && _pC[_i+2] == '-'
		 && _pC[_i+3] == '-')
	    {
		
		_i=_i+4;
		bool commentEnd = false;
		while ( ! commentEnd )
		{
		    if ( _pC[_i] == 0 )
		    {
			if ( moreData() == false )
			{
			    throw Exception(EXLOC, "Unexpected end of data");
			}
		    }
		    if ( _pC[_i] == '-' 
			 && _pC[_i+1] == '-' 
			 && _pC[_i+2] == '>')
		    {
			commentEnd=true;
			_i=_i+3;
		    }
		    else
		    {
			_i++;
			if ( _pC[_i+2] == 0 )
			{
			    throw Exception(EXLOC, "Unexpected end");
			}
		    }
		}
	    }
	    _i++;

	    if ( _pC[_i-1] == '\n' )
	    {
		// cout << "Increasing line number at pos " << _i-1 << endl;
		_lineNo++;
	    }

	    // cout << "Scanner returns " << _i-1 << " " << _pC[_i-1] << ">" << endl; 
	    return (_pC[_i-1]);
	}
	else 
	{
	    if ( moreData() == false )
	    {
		return 0;
	    }
	}
	    
    }
}

void XMLSuite::backChar() 
{
    _i--;
    return;
}

bool XMLSuite::moreData()
{
    
    if ( _pFile )
    {
	int numRead = _pFile->readByte(_inBuf+1, XMLSUITE_INBUFSIZE-2);
	if ( numRead > 0 )
	{
	    if ( _pC )
	    {
		_inBuf[0]=_pC[_i-1];
	    }
	    _inBuf[numRead+1]=0;
	    _pC = _inBuf+1;
	    _i=0;
	    return true; 
	}
    }
    return false;

}
void XMLSuite::putPreamble()
{
    if ( _pDoc == 0 )
    {
	throw Exception(EXLOC, "Document not set");
    }

    _pDoc->setAttributeList(_attrList);
    _attrList.Empty();
    _streamFirst=true;
}

void XMLSuite::putDocType()
{
    if ( _pDoc == 0 )
    {
	throw Exception(EXLOC, "Document not set");
    }

    Chain* pS = getTokenList().First();
    pS = getTokenList().Next();
   
    _pDoc->setDocType(*pS);    
}

void XMLSuite::putBody()
{
    if ( _pDoc == 0 )
    {
	throw Exception(EXLOC, "Document not set");
    }
    
    _pDoc->setRootElement(_pElem);
}

void XMLSuite::putAttribute()
{

    Chain value = _stringBuf;
	
    Chain* pS = getTokenList().First();


    pS = getTokenList().Next();
    pS = getTokenList().Next();
    
    if ( pS )
    {
	Attribute attr(*pS, value, true);
	_attrList.Insert(attr);
    }
}

void XMLSuite::preElement()
{
    Chain* pS = getTokenList().First();

    if ( _pElem )
	_elemStack.Push(_pElem);
    
    _pElem = new Element(*pS);
    _pElem->setAttributeList(_attrList);	

    _attrList.Empty();
    _scanContent = true;
}

void XMLSuite::conElement()
{
    _pElem->setText(_content);    
}

void XMLSuite::postElement()
{

    Chain* pS = getTokenList().First();
    pS = getTokenList().Next();

    if ( pS )
    {
	Element* pElem = 0;
	
	_elemStack.Pop(pElem);
	
	if ( pElem )
	{
	    if ( _pElem->getName() != *pS )
	    {
		Chain msg = Chain("Closing tag for ") + *pS + Chain(" does not match");
		throw Exception(EXLOC, msg);
	    }
	    pElem->addContent(_pElem);
	    _pElem = pElem;
	}
	_streamFirst=true;
    }
}

void XMLSuite::putElement()
{

    Chain* pS = getTokenList().First();

    pS = getTokenList().Next();
    pS = getTokenList().Next();

    if ( _pElem )
    {
	Element * pElem = new Element(*pS);
	pElem->setAttributeList(_attrList);    
	_pElem->addContent(pElem);
    }
    else
    {
	_pElem = new Element(*pS);
	_pElem->setAttributeList(_attrList);     
    }
    _attrList.Empty();
    _streamFirst=true;
}


void XMLSuite::putStreamElement()
{
    Chain* pS = getTokenList().First();

    pS = getTokenList().Next();
    pS = getTokenList().Next();

    if ( _pInStream )
    {
	if ( _streamFirst == true )
	{
	    _pInStream->putFirst(_pElem, *pS, _attrList, _dataList);
	}
	else
	{
	    _pInStream->putNext(_pElem, *pS, _attrList, _dataList);
	}
	_streamFirst=false; 
   }
   _attrList.Empty();
}

void XMLSuite::preStreamData()
{
    Chain* pS = getTokenList().First();
    pS = getTokenList().Next();

    _streamName = *pS;
    _streamAttrList = _attrList;
 
    _attrList.Empty();
}

void XMLSuite::postStreamData()
{

    Chain* pS = getTokenList().First();
    pS = getTokenList().Next();

    if ( *pS != _streamName )
    {
	throw Exception(EXLOC, "Mismatched stream name");	
    }
    if ( _pInStream )
    {
	if ( _streamFirst == true )
	{
	    _pInStream->putFirst(_pElem, *pS, _streamAttrList, _dataList);
	}
	else
	{
	    _pInStream->putNext(_pElem, *pS, _streamAttrList, _dataList);
	}
	_streamFirst=false;
	char** pData = _dataList.First();
	while ( pData )
	{
	    delete (*pData);
	    pData = _dataList.Next();
	}
	_dataList.Empty(); 
   }

}

void XMLSuite::preData()
{
    _scanData = true;
}

void XMLSuite::storeData()
{
}


void XMLSuite::putData()
{
    
}
