#ifndef _XMLSUITE_H_INCLUDED_
#define _XMLSUITE_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// XMLSuite.h
// -----------
// xml suite class definition
//                                                         
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2006 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: Attribute
// 
// Description: 
//
// Status: IMPLEMENTED
//
///////////////////////////////////////////////////////////////////////////////

// INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/File.h>
#include <lfcbase/StackT.h>
#include <lfcbase/ListT.h>

#include "XML.h"
#include "Element.h"
#include "Document.h"
#include "Attribute.h"
#include "XMLInStream.h"
#include "XMLOutStream.h"

// XML INCLUDES

#define XMLSUITE_MAXSTRINGLEN 100000
#define XMLSUITE_MAXCONTENT 10000
#define XMLSUITE_INBUFSIZE 8192
#define XMLSUITE_CHUNKSIZE 1024

class XMLSuite : public XML {
    
public:

    XMLSuite(char *pC = 0);
    ~XMLSuite();

    // access methods
    Document* getDocument();
    void setDocument(Document* pDoc);

    void getXMLChain(Chain& xmlChain);
    void getXMLChain(File* pOutFile);
   
    // parser methods

    void setChain(char *pC);
    void setFile(File *pFile);
    void setInStream(XMLInStream *pInStream);

    int getLineNo() const;

private:

    char nextChar();
    void backChar();

    bool moreData();

    void putPreamble();
    void putDocType();

    void putBody();
    void putAttribute();
    void preElement();
    void conElement();
    void postElement();

    void putElement();
    void putStreamElement();

    void preStreamData();
    void postStreamData();
    void preData();
    void putData();
    void storeData();


    void getXMLForElement(Element* pElement, Chain& xmlElement, int level, bool isStream = false);
    void getXMLForElement(Element* pElement, File* pOutFile, int level, bool isStream = false);
    
    int _i;
    char *_pC;
    File *_pFile;
    XMLInStream* _pInStream;

    Element* _pElem;
    Document* _pDoc;

    Chain _streamName;

    ListT<Attribute> _attrList;
    ListT<Attribute> _streamAttrList;
    ListT<Element> _elemList;
    StackT<Element*> _elemStack;

    char _inBuf[XMLSUITE_INBUFSIZE]; 
    char _stringBuf[XMLSUITE_MAXSTRINGLEN]; 
    char _content[XMLSUITE_MAXCONTENT]; 
    ListT<char*> _dataList;

    bool _scanContent;
    bool _scanData;
    bool _streamFirst;

    int _lineNo;

};

#endif
