--
-- ### Verification of sophisticated btree conditions
-- 
--


-- delete from checklog;

drop if exists table a_tab;
create table a_tab ( a int, b string(10));
create btree b1 on a_tab(a,b);


drop if exists procedure loadData;
@
create procedure loadData()
begin

   delete from a_tab;
   insert into a_tab values ( 1, 'Alpha');
   insert into a_tab values ( 2, 'Beta');
   insert into a_tab values ( 3, 'Gamma');
   insert into a_tab values ( 4, 'Xeta');
   insert into a_tab values ( 5, 'Epsilon');
   insert into a_tab values ( 6, 'Delta');
   insert into a_tab values ( 7, 'Mythos');
   insert into a_tab values ( 8, 'Epsilon');
   insert into a_tab values ( 8, 'Hugo');
   insert into a_tab values ( 8, 'Berta');
end;
@

drop if exists procedure checkSelect001;
@
create procedure checkSelect001(msg out string(20)) return string(10)
begin

	var res string(10) = 'ERROR';
	var i int;
	
	cursor xCur as select a from a_tab where a = 1 and a < 10;
        if fetch xCur into ( :i ) = true
        then 
	     if :i = 1
	     then
		:res = 'ok';
	     end;
	end;
	close xCur;

	:msg = 'Select 1 ok';

	return :res;
end;
@

drop if exists procedure checkSelect002;
@
create procedure checkSelect002(msg out string(20)) return string(10)
begin

	var res string(10) = 'ERROR';
	var i int;
	
	cursor xCur as select count(*) from a_tab where a = 2 and a < 10 and b = 'Beta';
        if fetch xCur into ( :i ) = true
        then 
	     if :i = 1
	     then
		:res = 'ok';
	     end;
	end;
	close xCur;

	:msg = 'Select 2 ok';

	return :res;
end;
@

drop if exists procedure checkSelect003;
@
create procedure checkSelect003(msg out string(20)) return string(10)
begin

	var res string(10) = 'ERROR';
	var i int;
	
	cursor xCur as select a from a_tab where a = 3 and b < 'Xeta';
        if fetch xCur into ( :i ) = true
        then 
	     if :i = 3
	     then
		:res = 'ok';
	     end;
	end;
	close xCur;

	:msg = 'Select 3 ok';

	return :res;
end;
@

drop if exists procedure checkSelect004;
@
create procedure checkSelect004(msg out string(20)) return string(10)
begin

	var res string(10) = 'ERROR';
	var i int;
	
	cursor xCur as select a from a_tab where a >= 3 and b < 'Xeta' and b < 'XXX' and a < 1000;
        if fetch xCur into ( :i ) = true
        then 
	     if :i = 3
	     then
		:res = 'ok';
	     end;
	end;
	close xCur;

	:msg = 'Select 4 ok';

	return :res;
end;
@


drop if exists procedure checkSelect005;
@
create procedure checkSelect005(msg out string(20)) return string(10)
begin

	var res string(10) = 'ERROR';
	var i int;
	
	cursor xCur as select count(*) from a_tab where a between 1 and 5 and a between 4 and 9;
        if fetch xCur into ( :i ) = true
        then 
	     if :i = 2
	     then
		:res = 'ok';
	     end;
	end;
	close xCur;

	:msg = 'Select 5 ok';

	return :res;
end;
@

drop if exists procedure checkSelect006;
@
create procedure checkSelect006(msg out string(20)) return string(10)
begin

	var res string(10) = 'ERROR';
	var i int;
	
	cursor xCur as select count(*) from a_tab where a = 8 and b < 'Hugo';
        if fetch xCur into ( :i ) = true
        then 
	     if :i = 2
	     then
		:res = 'ok';
	     end;
	end;
	close xCur;

	:msg = 'Select 6 ok';

	return :res;
end;
@

drop if exists procedure checkSelect007;
@
create procedure checkSelect007(msg out string(20)) return string(10)
begin

	var res string(10) = 'ERROR';
	var i int;
	
	cursor xCur as select count(*) from a_tab where a = 8 and b <= 'Hugo' and a < 10 and a > 0;
        if fetch xCur into ( :i ) = true
        then 
	     if :i = 3
	     then
		:res = 'ok';
	     end;
	end;
	close xCur;

	:msg = 'Select 7 ok';

	return :res;
end;
@

drop if exists procedure checkSelect008;
@
create procedure checkSelect008(msg out string(20)) return string(10)
begin

	var res string(10) = 'ERROR';
	var i int;
	
	cursor xCur as select count(*) from a_tab where b > 'Hugo';
        if fetch xCur into ( :i ) = true
        then 
	     if :i = 2
	     then
		:res = 'ok';
	     end;
	end;
	close xCur;

	:msg = 'Select 8 ok';

	return :res;
end;
@



call loadData();

:r = call checkSelect001(:msg);
insert into checklog values ('GATE-G', :msg, :r);
:r = call checkSelect002(:msg);
insert into checklog values ('GATE-G', :msg, :r);
:r = call checkSelect003(:msg);
insert into checklog values ('GATE-G', :msg, :r);
:r = call checkSelect004(:msg);
insert into checklog values ('GATE-G', :msg, :r);
:r = call checkSelect005(:msg);
insert into checklog values ('GATE-G', :msg, :r);
:r = call checkSelect006(:msg);
insert into checklog values ('GATE-G', :msg, :r);
:r = call checkSelect007(:msg);
insert into checklog values ('GATE-G', :msg, :r);
:r = call checkSelect008(:msg);
insert into checklog values ('GATE-G', :msg, :r);

drop procedure loadData;
drop procedure checkSelect001;
drop procedure checkSelect002;
drop procedure checkSelect003;
drop procedure checkSelect004;
drop procedure checkSelect005;
drop procedure checkSelect006;
drop procedure checkSelect007;
drop procedure checkSelect008;



drop if exists table a_tab;

select * from checklog;


