--
-- ### Sample application to check all modifying operations with cglog
-- 

-- create required base tables
create table supplier ( primary snr int not null, sname string(30), prio int);
create table material ( primary mnr int not null, mname string(30), snr int);
create table orders (primary onr int not null, mname string(30), orderdate datetime, cnr int);
create table customer ( primary cnr int not null, cname string(30));
create table ids ( primary id string(30) not null, idval int);

-- add indexes
create index material_idx2 on material ( mname );
create index material_idx1 on material ( snr );
create index customer_idx1 on customer ( cname );
create index orders_idx1 on orders ( mname );

-- add foreign key constraints
alter table material add foreign key mat_fk ( snr ) references supplier ( snr );
alter table orders add foreign key ord_fk ( cnr ) references customer ( cnr );

-- insert base data
insert into supplier values ( 1, 'Time&Material', 3);
insert into supplier values ( 2, 'Cego AG', 5);
insert into supplier values ( 3, 'Moon Factory', 9);
insert into supplier values ( 4, 'McDagobert', 3);
insert into supplier values ( 11, 'HAL', 2);
insert into supplier values ( 12, 'Abraxas', 1);
insert into supplier values ( 13, 'ThunderStorm', 9);

insert into material values ( 1, 'screw', 11);
insert into material values ( 2, 'nail', 11);
insert into material values ( 3, 'hammer', 1);
insert into material values ( 4, 'saw', 2);
insert into material values ( 5, 'nail', 2);
insert into material values ( 6, 'knife', 1);
insert into material values ( 7, 'screw', 2);
insert into material values ( 8, 'saw', 11);
insert into material values ( 9, 'hammer', 11);

insert into customer values ( 23, 'John Smith');
insert into customer values ( 24, 'John Smith');
insert into customer values ( 25, 'John Smith');
insert into customer values ( 26, 'John Smith');

insert into orders values ( 4711, 'screw', sysdate, 23);
insert into orders values ( 4712, 'nail', sysdate, 23);
insert into orders values ( 4713, 'saw', sysdate, 23);
insert into orders values ( 4714, 'hammer', sysdate, 23 );
-- insert into orders values ( 4715, 'spoon', sysdate , 23 );
-- insert into orders values ( 4716, 'fork', sysdate , 23 );
-- insert into orders values ( 4717, 'plate', sysdate , 23 );
-- insert into orders values ( 4722, 'car', scandate('%Y-%m-%d %H:%M:%S %Z', '2007-07-07 13:33:12 CET'), 23);

start transaction;
insert into ids values ('ONR', 10000);
insert into ids values ('SNR', 10000);
insert into ids values ('MNR', 10000);
insert into ids values ('CNR', 10000);
commit;

-- view sample
create view matview as select sname as supname, mname as matname from material mat, supplier sup where sup.snr = mat.snr;

-- proc samples
@
create procedure nextId ( id in string(30) ) return int 
begin 

   var actId int;
   var res bool;

   cursor actIdCur as select idval from ids where id = :id;

   :actId = 0;

   if fetch actIdCur into ( :actId  ) = true
   then      
      close actIdCur;	
      :actId = :actId + 1;
      update ids set idval = :actId where id = :id;       	      
   end;

   return :actId;

end;
@


@
create procedure nextId2 ( id in string(30) ) return int 
begin 

   var idval int;

   update ids set idval = idval + 1 where id = :id return :idval = idval;
        
   return :idval;

end;
@

@
create procedure newOrder (mname in string(30), cnr in int ) return int 
begin 
 
   var onr int;
   :onr = nextId2('ONR');
   insert into orders values ( :onr, :mname, sysdate, :cnr );
   return :onr;
end;
@


:onr = call newOrder('spoon', 23);

-- table renaming
rename table customer to client;

-- table altering
alter table material add column mdesc string(100);
alter table material modify column mdesc string(200);
alter table material drop column mdesc;


-- aliases 

-- checks

-- triggers


create table mtrigger ( primary tmnr int not null, tdata string(30));
@
create trigger tg1 before insert on material 
begin
        -- while t1 in increasing, t2 is decreasing
        delete from mtrigger mx where mx.tmnr = material.mnr;     
end;
@

insert into mtrigger values ( 100, 'X Data');

select * from mtrigger;

insert into material values ( 100, 'screwX', 11);

-- should be empty
select * from mtrigger;




drop view matview;

drop table material;
drop table orders;

drop table supplier;
drop table client;
drop table ids;

drop procedure newOrder;
drop procedure nextId;
drop procedure nextId2;


