#ifndef _CEGOAVLINDEXENTRY_H_INCLUDED_
#define _CEGOAVLINDEXENTRY_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAVLIndexEntry.h
// ----------------
// AVL Index entry class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2019 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoAVLIndexEntry
// 
// Description: For any kind of index object, IndexEntry objects are used as row elements
//              to refer to further entries ( parent, left, right )
//              Cego index object provide full balancing on node level, so the index entry provides
//              the required information for the balancing algorithm 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoDataPointer.h"

class CegoAVLIndexEntry {

 public:
    
    CegoAVLIndexEntry();
    ~CegoAVLIndexEntry();
    
    void initEntry(const CegoDataPointer& dp, char* p = 0, unsigned len = 0);

    void setPtr(void* p, unsigned len);
    void* getPtr();
    unsigned getLen() const;
    
    void setParent(const CegoDataPointer& dp);
    CegoDataPointer getParent() const;

    void setLeftBranch(const CegoDataPointer& dp);
    CegoDataPointer getLeftBranch() const;

    void setRightBranch(const CegoDataPointer& dp);
    CegoDataPointer getRightBranch() const;

    void setHeight(char h);
    char getHeight() const;

    void setData(const CegoDataPointer& dp);
    CegoDataPointer getData() const;

    char* getIdxPtr();
    unsigned getIdxLen();

    CegoAVLIndexEntry& operator = (const CegoAVLIndexEntry& ie);
    
 private:
    
    void* _pI;
    unsigned _len;
    bool _isLocal;
    char* _idxDataPtr;
};

#endif
