--
-- ### Procedures using conditions of extended grammar ( from version 2.51. ) 
-- 


drop if exists table t1;
create table t1 ( a int, b string(10) );

insert into t1 values ( 1, 'X');
insert into t1 values ( 2, 'Y');
insert into t1 values ( 7, 'Z');


drop if exists procedure checkPred1;
@
create procedure checkPred1(a in int, b in string(10)) return bool
begin
    if :a in ( select a from t1 where b = :b )
    then
        return true;
    end;
    return false;
end;
@

drop if exists procedure checkPred2;
@
create procedure checkPred2(b in string(10)) return bool
begin
    if exists ( select a from t1 where b = :b )
    then
        return true;
    end;
    return false;
end;
@

drop if exists procedure checkPred3;
@
create procedure checkPred3(a1 in int, a2 in int, b in string(10)) return bool
begin
    if ( select a from t1 where b = :b ) between :a1 and :a2
    then
        return true;
    end;
    return false;
end;
@


select checkPred1(1, 'X');
select checkPred1(3, 'X');
select checkPred1(2, 'Y');

select checkPred2('X');
select checkPred2('Y');
select checkPred2('Z');

select checkPred3(5, 9, 'Z');
select checkPred3(11, 17, 'Z');

