--
-- ### Checking new introduced nclike operator 
-- 


drop if exists table t1;
create table t1 ( a int, b string(10) );

insert into t1 values ( 1, 'Alpha');
insert into t1 values ( 2, 'Beta');
insert into t1 values ( 7, 'Gamma');

drop if exists table t2;
create table t2 ( c int, d string(10) );

insert into t2 values ( 1, 'XXX');
insert into t2 values ( 2, 'YYY');
insert into t2 values ( 7, 'ZZZ');


drop if exists view v1;
create view v1 as
select t1.a  as a,
t1.b  as b,
t2.d as d
from
t1 inner join t2 on t1.a = t2.c;

-- with lower funktion in expression, join condition can actually NOT be enriched
plan select a, d from v1 where lower(b) like 'alpha';

-- with native nclike funktion, join condition can be enriched
plan select a, d from v1 where b nclike 'alpha';

