#ifndef _CEGOATTRCOMP_H_INCLUDED_
#define _CEGOATTRCOMP_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAttrComp.h
// --------------
// Cego table attribute comparison description class definition
//      
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoAttrComp
// 
// Description: Attribute comparison utility class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>
#include <lfcbase/Matcher.h>

// CEGO INCLUDES
#include "CegoField.h"
#include "CegoFieldValue.h"
#include "CegoAttrDesc.h"
#include "CegoComparison.h"

class CegoAttrComp {
    
public:
    
    enum CompMode { UNDEF, VAL, ATTR, BTWN, ISLIKE, ISNOTLIKE, ISNCLIKE, ISNOTNCLIKE };

    enum BetweenMode { VALUE2VALUE, VALUE2ATTR, ATTR2VALUE, ATTR2ATTR };

    CegoAttrComp();
    CegoAttrComp(const Chain& tableName, const Chain& attrName);
    CegoAttrComp(const Chain& tableName, const Chain& attrName, CegoComparison comp, const CegoFieldValue& fv);
    CegoAttrComp(const Chain& tableName, const Chain& attrName, CegoComparison comp, const CegoAttrDesc& attrDesc);
    CegoAttrComp(const Chain& tableName, const Chain& attrName, const CegoFieldValue& fv, const CegoFieldValue& fv2);

    CegoAttrComp(const Chain& tableName, const Chain& attrName, const CegoAttrDesc& attrDesc, const CegoFieldValue& fv2); 
    CegoAttrComp(const Chain& tableName, const Chain& attrName, const CegoFieldValue& fv, const CegoAttrDesc& attrDesc2); 
    CegoAttrComp(const Chain& tableName, const Chain& attrName, const CegoAttrDesc& attrDesc, const CegoAttrDesc& attrDesc2); 

    CegoAttrComp(const Chain& tableName, const Chain& attrName, const Chain& pattern, bool isNot, bool isCaseSensitive);
    ~CegoAttrComp();

    CompMode getCompMode() const;

    unsigned getPos() const;
    void setPos(unsigned pos);
    
    void setTableName(const Chain& tableName);
    const Chain& getTableName() const;
    void setAttrName(const Chain& attrName);
    const Chain& getAttrName() const;
    CegoComparison getComparison() const;
    void setComparison(CegoComparison comp);

    void setFieldValue(const CegoFieldValue& fv);
    void setFieldValue2(const CegoFieldValue& fv);
    
    const CegoFieldValue& getFieldValue() const;
    const CegoFieldValue& getFieldValue2() const;
    
    void setAttrDesc(const CegoAttrDesc& ad);
    const CegoAttrDesc& getAttrDesc() const;

    void setAttrDesc2(const CegoAttrDesc& ad);
    const CegoAttrDesc& getAttrDesc2() const;

    void reset();
    
    bool isParentSetup() { return _isParentSetup; }
    void setParentSetup() { _isParentSetup = true; }
	
    bool setup(const ListT<CegoField>& fl);
    bool setup(ListT<CegoField>** pJoinBuf, unsigned offset);

    bool isNullComp() const;
    
    bool isSetup();

    const Chain& getPattern() const;
    Matcher* getMatcher();

    CegoAttrComp& operator = ( const CegoAttrComp& ac);
    bool operator == ( const CegoAttrComp& ac) const;
    bool operator > ( const CegoAttrComp& ac) const;
    bool operator < ( const CegoAttrComp& ac) const;

    Chain getId() const;
    Chain toChain() const;
    friend ostream& operator << (ostream& s, const CegoAttrComp& ac);
      
private:

    unsigned _pos;
    Chain _tableName;
    Chain _attrName;
    CegoComparison _comp;
    CegoFieldValue _fv;
    CegoFieldValue _fv2;
    CegoAttrDesc _attrDesc;
    CegoAttrDesc _attrDesc2;
    CompMode _compMode;
    BetweenMode _btwnMode;
    Chain _pattern;    
    Matcher* _pMatcher;

    bool _isSetup;
    bool _isSetup2;

    unsigned _xpos;
    unsigned _ypos;
    unsigned _xpos2;
    unsigned _ypos2;

    bool _posSetup;
    bool _isParentSetup;
};
#endif
