///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoBufferPoolEntry.cc
// ----------------------
// Cego buffer pool entry implementation
//      
// Design and Implementation by Bjoern Lemke
//     
// (C)opyright 2000-2025 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoBufferPoolEntry
// 
// Description: Bufferpool entry handle
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// CEGO INCLUDES
#include "CegoBufferPoolEntry.h"

// LFC INCLUDES
#include <lfcbase/Exception.h>
#include <lfcbase/File.h>

// POSIX INCLUDES
#include <string.h>
#include <stdlib.h>

CegoBufferPoolEntry::CegoBufferPoolEntry()
{
}

CegoBufferPoolEntry::CegoBufferPoolEntry(unsigned seg, unsigned pos, const Chain& occState, bool isDirty, unsigned numFixes, unsigned tabSetId, PageIdType pageId, unsigned fixStat, unsigned long long numUsage)
{
    _seg = seg;
    _pos = pos;
    _occState = occState;
    _isDirty = isDirty;
    _numFixes = numFixes;
    _tabSetId = tabSetId;
    _pageId = pageId;
    _fixStat = fixStat;
    _numUsage = numUsage;
}

CegoBufferPoolEntry::~CegoBufferPoolEntry()
{
}

unsigned CegoBufferPoolEntry::getSegment() const
{
    return _seg;
}

unsigned CegoBufferPoolEntry::getPos() const
{
    return _pos;
}

const Chain& CegoBufferPoolEntry::getOccState() const
{
    return _occState;
}

bool CegoBufferPoolEntry::isDirty() const
{
    return _isDirty;
}

unsigned CegoBufferPoolEntry::getNumFixes() const
{
    return _numFixes;
}

unsigned CegoBufferPoolEntry::getTabSetId() const
{
    return _tabSetId;
}

PageIdType CegoBufferPoolEntry::getPageId() const
{
    return _pageId;
}

unsigned CegoBufferPoolEntry::getFixStat() const
{
    return _fixStat;
}

unsigned long long CegoBufferPoolEntry::getNumUsage() const
{
    return _numUsage;
}

CegoBufferPoolEntry& CegoBufferPoolEntry::operator = ( const CegoBufferPoolEntry& b)
{
    _seg = b._seg;
    _pos = b._pos;
    _occState = b._occState;
    _isDirty = b._isDirty;
    _numFixes = b._numFixes;
    _tabSetId = b._tabSetId;
    _pageId = b._pageId;
    _fixStat = b._fixStat;
    _numUsage = b._numUsage;
    return (*this);
}

bool CegoBufferPoolEntry::operator == ( const CegoBufferPoolEntry& b)
{
    if ( _seg == b._seg && _pos == b._pos )
	return true;
    return false;
}

Chain CegoBufferPoolEntry::toChain() const
{
    Chain s;
    s = "N/A";    
    return s;
}
    
ostream& operator << (ostream& s, const CegoBufferPoolEntry& qe)
{    
    s << qe.toChain();
    return s;
}
