#ifndef _CEGOBUFFERPOOLENTRY_H_INCLUDED_
#define _CEGOBUFFERPOOLENTRY_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoBufferPoolEntry.h
// ---------------------
// Cego buffer pool entry definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//     
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoBufferPoolEntry
//
// Description: Bufferpool entry handle
// 
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>

#include "CegoDefs.h"

class CegoBufferPoolEntry {

public:
  
    CegoBufferPoolEntry();  
    CegoBufferPoolEntry(unsigned seg, unsigned pos, const Chain& occState, bool isDirty, unsigned numFixes, unsigned tabSetId, PageIdType pageId, unsigned fixStat, unsigned long long numUsage);
    ~CegoBufferPoolEntry();

    unsigned getSegment() const;
    unsigned getPos() const;
    const Chain& getOccState() const;
    bool isDirty() const;
    unsigned getNumFixes() const;
    unsigned getTabSetId() const;
    PageIdType getPageId() const;
    unsigned getFixStat() const;
    unsigned long long getNumUsage() const;

    CegoBufferPoolEntry& operator = ( const CegoBufferPoolEntry& b);
    bool operator == ( const CegoBufferPoolEntry& b);

    Chain toChain() const;
    friend ostream& operator << (ostream& s, const CegoBufferPoolEntry& b);
    
private:

    unsigned _seg;
    unsigned _pos;
    Chain _occState;
    bool _isDirty;
    unsigned _numFixes;
    unsigned _tabSetId;
    PageIdType _pageId;
    unsigned _fixStat;
    unsigned long long _numUsage;
};
#endif
