#ifndef _CEGODECODABLEOBJECT_H_INCLUDED_
#define _CEGODECODABLEOBJECT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoDecodableObject.h
// ---------------------
// Cego decodable object class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoDecodableObject
// 
// Description: Super class for any database object, which is decodable
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcxml/Element.h>

// CEGO INCLUDES
#include "CegoField.h"
#include "CegoObject.h"

class CegoDecodableObject : public CegoObject {

public:
        
    CegoDecodableObject();
    CegoDecodableObject(const CegoDecodableObject& co);
    CegoDecodableObject(CegoObject::ObjectType type, const Chain& objName, unsigned tabSetId);
    virtual ~CegoDecodableObject();

    virtual unsigned getEntrySize() const = 0;
    virtual void encode(char *buf) const = 0;
    virtual void decode(char *buf) = 0;
    
    virtual Chain getInfo() const = 0;

    Chain getTableSet() const { return _tableSet; } 
    void setTableSet(const Chain& tableSet ) { _tableSet = tableSet; } 
    bool isLocal() { return _isLocal; }
    void setLocal(bool il) { _isLocal = il; }

    CegoDecodableObject& operator = ( const CegoDecodableObject& deo);
    bool operator == ( const CegoDecodableObject& deo);
    
private:

    Chain _tableSet;
    bool _isLocal;

};
#endif
