#ifndef _CEGOJDBCINFO_H_INCLUDED_
#define _CEGOJDBCINFO_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoJDBCInfo.h
// --------------
// Cego JDBC information handler
//      
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoJDBCInfo
// 
// Description: JDBC request handling
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

// CEGO INCLUDES
#include "CegoDistManager.h"
#include "CegoDbHandler.h"

class CegoJDBCInfo {

public:

    CegoJDBCInfo(CegoDistManager* pTabMng, CegoDbHandler* pDbHandle);
    ~CegoJDBCInfo();

    void handleRequest(const ListT<Chain>& argList) const;
    
private:

    void checkAccess() const;

    CegoDistManager* _pTabMng;
    CegoDbHandler* _pDbHandle;  
};
#endif
