#ifndef _CEGOLOGMANAGER_H_INCLUDED_
#define _CEGOLOGMANAGER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoLogManager.h
// ----------------
// Cego database log manager class definition
//                                                         
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoLogManager
// 
// Description: Cego database log management
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/File.h>

// CEGO INCLUDES
#include "CegoFileHandler.h"
#include "CegoLogHandler.h"
#include "CegoLogRecord.h"
#include "CegoXMLSpace.h"
#include "CegoDefs.h"

class CegoLogManager : public CegoXMLSpace {
    
public:
    
    enum LogResult { LOG_SUCCESS, LOG_FULL, LOG_ERROR };

    CegoLogManager(const Chain& xmlDef, const Chain& logFile, const Chain& progName);
    ~CegoLogManager();
    
    void initLog(unsigned tabSetId, unsigned size);
    void stopLog(unsigned tabSetId);
    void startLog(unsigned tabSetId);
    unsigned getLogOffset(unsigned tabSetId);
    void resetLog(unsigned tabSetId);
    bool isActive(unsigned tabSetId);
    LogResult logAction(unsigned tabSetId, CegoLogRecord& logRec, bool flushLog = true);
    void allocateLogConnection(unsigned tabSetId, const Chain& tableSet, const Chain& logHost, unsigned logPort, const Chain& logUser, const Chain& logPwd);
    bool hasLogConnection(unsigned tabSetId);
    void releaseLogConnection(unsigned tabSetId);
    void setLogFile(unsigned tabSetId, const Chain& logFile, bool readOnly);
    unsigned long long getMinLSN(unsigned tabSetId);
    unsigned long long getMaxLSN(unsigned tabSetId);
    void seekToStart(unsigned tabSetId);
    bool logSeek(unsigned tabSetId, unsigned long long lsn);
    bool logRead(unsigned tabSetId, CegoLogRecord& logRec);
    unsigned long long nextLSN(unsigned tabSetId);
    void setCurrentLSN(unsigned tabSetId, unsigned long long lsn);
    unsigned long long getCurrentLSN(unsigned tabSetId);
    Chain getArchiveLogName(const Chain& tableSet, unsigned long long lsn);
    bool switchLogFile(unsigned tabSetId);
    void setActiveLogFile(const Chain& tableSet);
    
private:
    
    unsigned getLFID();
    void switchLFID();
    
    File *_pLog[TABMNG_MAXTABSET];
    File *_pLFID[TABMNG_MAXTABSET];
    Chain _logFile[TABMNG_MAXTABSET];
    unsigned _logSize[TABMNG_MAXTABSET];
    unsigned _logOffset[TABMNG_MAXTABSET];
    char* _logBuf[TABMNG_MAXTABSET];
    unsigned _logBufLen[TABMNG_MAXTABSET];
    unsigned _numGroup[TABMNG_MAXTABSET];
    unsigned long long _lsn[TABMNG_MAXTABSET];
    unsigned _logPos[TABMNG_MAXTABSET];
    bool _logActive[TABMNG_MAXTABSET];
    CegoLogHandler* _pLogHandler[TABMNG_MAXTABSET];
    NetHandler* _pNetHandler[TABMNG_MAXTABSET];

    unsigned long _modId;
};
#endif
