#ifndef _CEGONET_H_INCLUDED_
#define _CEGONET_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoNet.h
// ---------
// Cego net client API
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoNet
// 
// Description: SQL Client API 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>
#include <lfcbase/NetHandler.h>
// CEGO INCLUDES
#include "CegoField.h"
#include "CegoDbHandler.h"
#include "CegoBlob.h"
#include "CegoClob.h"

class CegoNet {
    
public:

    CegoNet(CegoDbHandler::ProtocolType protType, const Chain& logFile, const Chain& progName, const Chain& logMode );
    ~CegoNet();
    
    void connect(const Chain& serverName, unsigned port, const Chain& tableSet, const Chain& user, const Chain& pwd, unsigned maxSendLen = NETMNG_MAXSENDLEN);
    unsigned long long doQuery(const Chain& query);
    void putBlob(CegoBlob& blob);
    void putClob(CegoClob& clob);
    void getBlob(CegoBlob& blob);
    void getClob(CegoClob& clob);
    void deleteClob(CegoClob& clob);
    void deleteBlob(CegoBlob& blob);
    bool fetchData(const ListT<CegoField>& schema, ListT<CegoFieldValue>& fvl);
    bool isFetchable();
    void abortQuery();
    void resetQuery();
    bool wasReset();
    unsigned long long getTid() const;
    const Chain& getDbName() const;
    const Chain& getDbVersion() const;
    void reqAbortQuery(unsigned long long tid);
    const Chain& getMsg();
    long getAffected();
    void getSchema(ListT<CegoField>& schema);
    void getFormat(Chain& format);
    void getProcResult(ListT<CegoProcVar>& outParamList, CegoFieldValue& retValue);
    void disconnect();

private:

    CegoDbHandler::ProtocolType _protType;
    Chain _progName;
    Chain _logFile;
    Chain _logMode;
    NetHandler* _pN;
    CegoDbHandler* _pSH;
    CegoModule* _pModule;
    bool _isFetchable;
};
#endif
