#ifndef _CEGOSYSTEMOBJECT_H_INCLUDED_
#define _CEGOSYSTEMOBJECT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoSystemObject.h
// ------------------
// Cego system object class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoSystemObject
// 
// Description: Description of all system tables like $table, $procedure, etc,
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoObjectManager.h"

class CegoSystemObject : public CegoObjectManager {
    
public:
    
    CegoSystemObject(CegoDatabaseManager *pDBMng);
    ~CegoSystemObject();

    void createSystemSpace(unsigned tabSetId);
    bool objectExists(unsigned tabSetId, const Chain& objectName, CegoObject::ObjectType type);
    void getObject(unsigned tabSetId, const Chain& objectName, CegoObject::ObjectType type, CegoDecodableObject& oe);
    void getObjectWithFix(unsigned tabSetId, const Chain& objectName, CegoObject::ObjectType type, CegoDecodableObject& oe, CegoBufferPage &bp);
    void getObjectList(unsigned tabSetId, CegoObject::ObjectType type, ListT<Chain>& objList);

private:
        
    unsigned long _modId;
};
#endif
