#ifndef _CEGOTERM_H_INCLUDED_
#define _CEGOTERM_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoTerm.h
// ----------
// Cego term class definition
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoTerm
// 
// Description: Term data struture
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/ListT.h>
#include <lfcbase/SetT.h>

// CEGO INCLUDES
#include "CegoProcStmt.h"
#include "CegoFieldValue.h"
#include "CegoFactor.h"

class CegoDistManager;

class CegoTerm {
    
public:
    
    enum TermType { MUL, DIV, FACTOR  };
    
    CegoTerm();
    CegoTerm(char* buf, CegoDistManager *pGTM, CegoProcBlock *pBlock, unsigned tabSetId);
    CegoTerm(CegoTerm *pTerm, CegoFactor *pFac, TermType termType);
    CegoTerm(CegoFactor *pFactor);
    ~CegoTerm();

    void cleanUp();
    void setTabSetId(unsigned tabSetId);
    void clearAttrCache();
    void getFunctionList(SetT<CegoObject>& funcList);
    void getSelectQueryList(ListT<CegoSelect*>& queryList);
    bool checkConst() const;
    bool checkVar(Chain& var) const;
    CegoAttrDesc* checkAttr() const;
    CegoCondition* checkCondition() const;
    bool checkLob(CegoFieldValue& fv, CegoProcBlock *pBlock);
    void getFieldList(ListT<CegoField>& fl, ListT<CegoField> **pFLA) const;
    ListT<CegoAttrDesc*> getAttrRefList() const;
    unsigned evalReferences(CegoContentObject *pCO, const ListT<CegoField>& fl);
    CegoField evalField(const ListT<CegoField>& fl, bool graceful = false) const;

    CegoFieldValue evalFieldValue(ListT<CegoField> **pFLA, CegoProcBlock *pBlock) const;
    
    TermType getType() const;
    CegoFactor* getFactor();
    CegoTerm* getTerm();
    ListT<CegoAggregation*> getAggregationList();
    CegoTerm* clone(bool isAttrRef = false);
    Chain getId(CegoProcBlock *pBlock) const;
    Chain toChain(unsigned defTabSetId, const Chain& indent) const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;

    void encode(char *buf, CegoProcBlock *pBlock);
    void decode(char *buf, CegoDistManager *pGTM, CegoProcBlock *pBlock, unsigned tabSetId);
    unsigned getEncodingLength(CegoProcBlock *pBlock) const;

    void getPlanList(ListT<Element*>& planList);

    CegoTerm& operator = ( const CegoTerm& e);
    friend ostream& operator << (ostream& s, const CegoTerm& e);


    CegoTerm* map(const Chain& viewAlias, const ListT<CegoExpr*>& exprList) const;
    
private:

    TermType _termType;
    CegoTerm *_pTerm;
    CegoFactor *_pFactor;
};
#endif
