#ifndef _CEGOVIEW_H_INCLUDED_
#define _CEGOVIEW_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoView.h
// ----------
// Cego view cache object
//      
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoView
// 
// Description: Cached view object data structure
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>

class CegoSelect;

class CegoView {

public:
    
    CegoView();
    CegoView(const Chain& viewName, CegoSelect *pSelect);
    ~CegoView();

    const Chain& getViewName() const;
    CegoSelect* getSelect() const;
    Chain toChain() const;

    CegoView& operator = ( const CegoView& v);
    bool operator == ( const CegoView& v);
    friend ostream& operator << (ostream& s, const CegoView& v);
    
private:
    
    Chain _viewName;
    CegoSelect *_pSelect;
};
#endif
