#ifndef _CEGOVIEWOBJECT_H_INCLUDED_
#define _CEGOVIEWOBJECT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoViewObject.h
// ----------------
// Cego view object class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2025 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoViewObject
// 
// Description: Cego view object structure
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/ListT.h>
#include <lfcbase/Chain.h>

// cego includes
#include "CegoField.h"
#include "CegoContentObject.h"

class CegoViewObject : public CegoContentObject {
    
public:
    
    CegoViewObject();
    CegoViewObject(const CegoViewObject& vo);
    CegoViewObject(const Chain& viewName, unsigned tabSetId = 0);
    CegoViewObject(unsigned tabSetId, const Chain& viewName, const ListT<CegoField>& schema, const Chain& viewStmt);
    ~CegoViewObject();
    
    unsigned getEntrySize() const;
    void encode(char *buf) const;
    void decode(char *buf);
    void setSchema(const ListT<CegoField>& schema);
    const Chain& getViewStmt() const;
    void setViewStmt(const Chain& viewStmt);
    void setEmpty();
    Chain getId(CegoProcBlock *pBlock) const;
    Chain toChain(unsigned defTabSetId) const;
    CegoContentObject* clone(bool isAttrRef=false);
    Chain getInfo() const;

    CegoViewObject& operator = ( const CegoViewObject& vo);
    bool operator == ( const CegoViewObject& vo);
    
private:

    Chain _viewStmt;
};
#endif
