--
-- ### Verification of casts
-- 
--

create table a_decimal ( a int, b decimal(3));


drop if exists procedure loadData;
@
create procedure loadData()
begin

   delete from a_decimal;
   insert into a_decimal values ( 1, 1.23);
   insert into a_decimal values ( 2, 2.345);
   insert into a_decimal values ( 3, 3.5193);
   insert into a_decimal values ( 4, 4.111);
   insert into a_decimal values ( 5, 4.111);
   insert into a_decimal values ( 6, 4.111);
end;
@

drop if exists procedure checkCast001;
@
create procedure checkCast001(msg out string(20)) return string(10)
begin

   var res string(10) = 'ok';
   
   var numrow int;

   :numrow = ( select count(*) from a_decimal where b = (decimal)1.230 );
   if :numrow != 1
   then
	:res = 'ERROR';
	return :res;
   end;

   :numrow = ( select count(*) from a_decimal where b = (decimal)2.345 );
   if :numrow != 1
   then
	:res = 'ERROR';
	return :res;
   end;

   :numrow = ( select count(*) from a_decimal where b = (decimal)4.111 );
   if :numrow != 3
   then
	:res = 'ERROR';
	return :res;
   end;

   :msg = 'Native casting';
   return :res;
end;
@

call loadData();
:r = call checkCast001(:msg);
insert into checklog values ('GATE-E', :msg, :r);

drop procedure loadData;
drop procedure checkCast001;

drop if exists table a_decimal;



